/* -*- pftp-c -*- */
#ifndef PFTP_SSH_BUF_H
#define PFTP_SSH_BUF_H

typedef struct pftp_ssh_buf_s *pftp_ssh_buf_t;

pftp_ssh_buf_t pftp_ssh_create_buf(void);
pftp_ssh_buf_t pftp_ssh_attach_buf(const char *data, size_t size);
void pftp_ssh_buf_free(pftp_ssh_buf_t buf);

/* Writing */

void pftp_ssh_buf_put_string(pftp_ssh_buf_t buf, const char *str);
void pftp_ssh_buf_put_string2(pftp_ssh_buf_t buf, const char *str, size_t len);
void pftp_ssh_buf_put_bignum(pftp_ssh_buf_t buf, const BIGNUM *num);
void pftp_ssh_buf_put_raw(pftp_ssh_buf_t buf, const void *data, size_t size);
void pftp_ssh_buf_put_uint16(pftp_ssh_buf_t buf, uint16_t num);
void pftp_ssh_buf_put_uint32(pftp_ssh_buf_t buf, uint32_t num);
void pftp_ssh_buf_put_uint64(pftp_ssh_buf_t buf, uint64_t num);
void pftp_ssh_buf_put_int64(pftp_ssh_buf_t buf, int64_t num);
void pftp_ssh_buf_put_char(pftp_ssh_buf_t buf, char c);

/* Reading */

char *pftp_ssh_buf_get_string(pftp_ssh_buf_t buf);
char *pftp_ssh_buf_get_string2(pftp_ssh_buf_t buf, size_t *len);
BIGNUM *pftp_ssh_buf_get_bignum(pftp_ssh_buf_t buf);
const char *pftp_ssh_buf_get_raw(pftp_ssh_buf_t buf, size_t len);
char pftp_ssh_buf_get_char(pftp_ssh_buf_t buf, int *valid);
uint16_t pftp_ssh_buf_get_uint16(pftp_ssh_buf_t buf, int *valid);
uint32_t pftp_ssh_buf_get_uint32(pftp_ssh_buf_t buf, int *valid);
uint64_t pftp_ssh_buf_get_uint64(pftp_ssh_buf_t buf, int *valid);
int64_t pftp_ssh_buf_get_int64(pftp_ssh_buf_t buf, int *valid);

const char *pftp_ssh_buf_raw(pftp_ssh_buf_t buf);
size_t pftp_ssh_buf_size(pftp_ssh_buf_t buf);
void pftp_ssh_buf_reset(pftp_ssh_buf_t buf);

void pftp_ssh_buf_seek(pftp_ssh_buf_t buf, size_t pos);
size_t pftp_ssh_buf_tell(pftp_ssh_buf_t buf);

size_t pftp_ssh_buf_data_left(pftp_ssh_buf_t buf);

#endif /* PFTP_SSH_BUF_H */
