/* -*- pftp-c -*- */
#ifndef PFTP_SSH_H
#define PFTP_SSH_H

typedef struct pftp_ssh_s *pftp_ssh_t;

pftp_ssh_t pftp_ssh_connect(pftp_server_t ftp);
void pftp_ssh_close(pftp_ssh_t *ssh);
pftp_ssh_pkt_t pftp_ssh_get(pftp_ssh_t ssh, unsigned long timeout);
int pftp_ssh_send(pftp_ssh_t ssh, const pftp_ssh_pkt_t packet, 
		  unsigned long timeout);
int pftp_ssh_request_service(pftp_ssh_t ssh, const char *service);

const char *pftp_ssh_get_server_str(pftp_ssh_t ssh);

#endif /* PFTP_SSH_H */
