/* -*- pftp-c -*- */
#ifndef PFTP_SPEED_H
#define PFTP_SPEED_H

typedef struct {
    uint64_t total, done;
    size_t buffersize;
    int unknown;
    // int lastchange;
    double speed; //, lastspeed;
    float percent;
    
    uint64_t lastdata;
    struct timeval lasttime;
} speed_data_s, *speed_data_t;

/* Helper function for speed calculation during data transfers */
speed_data_t pftp_init_speed(uint64_t total, uint64_t start, 
			     size_t lastgoodbuffersize);
/* Helper function for speed calculation during data transfers */
void pftp_update_speed(speed_data_t speed, size_t data);
/* Helper function for speed calculation during data transfers */
void pftp_free_speed(speed_data_t *speed, size_t *lastgoodbuffersize);

#endif /* PFTP_SPEED_H */
