/* -*- pftp-c -*- */
#ifndef PFTP_FFTP_ATTRIB_H
#define PFTP_FFTP_ATTRIB_H

typedef struct pftp_sftp_attr_s *pftp_sftp_attr_t;

pftp_sftp_attr_t pftp_sftp_parse_attr(uint32_t version, const char *server_str,
				      pftp_ssh_buf_t buf, const char *longinfo);
void pftp_sftp_free_attr(pftp_sftp_attr_t attr);

pftp_sftp_attr_t pftp_sftp_create_attr(void);
int pftp_sftp_export_attr(uint32_t version, pftp_ssh_buf_t buf,
			  pftp_sftp_attr_t attr);

void pftp_sftp_attr_set_permissions(pftp_sftp_attr_t attr, 
				    unsigned short access);
void pftp_sftp_attr_set_modificationtime(pftp_sftp_attr_t attr, 
					 const struct tm *date);

int pftp_sftp_is_dir(pftp_sftp_attr_t attr);
pftp_file_type_t pftp_sftp_convert_attr_type(pftp_sftp_attr_t attr);
void pftp_sftp_convert_attr(pftp_file_t *file, pftp_sftp_attr_t attr);

#endif /* #define PFTP_FFTP_ATTRIB_H */
