/* -*- pftp-c -*- */
#ifndef PFTP_SETTINGS_H
#define PFTP_SETTINGS_H

#include "pftp_default.h"

struct pftp_settings_s {
    /* can't have defaults */
    uint16_t *port;  
    char **hostname;
    size_t hosts;    
    char *username, *password, *account, *name;

    /* 0 = false, 1 = true, -1 = default/unknown */
    int pasv;    
    int secure_list, secure_data, use_secure, implicid_ssl;
    
    /* 0 = default */
    uint16_t port_start, port_stop;
    /* null = default */
    char *bind_to, *myaddr;

    int include_global_prio, include_global_ignore;
    char **prio_list, **ignore_list;
    size_t prio_list_len, ignore_list_len;

    pftp_default_t global;

    /* You are free to use this for whatever reason.
       Is sent with pftp_comm_centralFunc_t */
    void *userdata;
};

typedef struct pftp_settings_s *pftp_settings_t;

#endif /* PFTP_SETTINGS_H */
