/* -*- pftp-c -*- */
#ifndef PFTP_DIRECTORY_H
#define PFTP_DIRECTORY_H

typedef enum {
    pft_directory,
    pft_door,
    pft_block,
    pft_character,
    pft_fifo,
    pft_s_socket,
    pft_file,
    pft_unknown
} pftp_file_type_t;

typedef struct {
    pftp_file_type_t type;
    unsigned short perm;
    unsigned long links;
    char *user;
    int link;
    char *group;
    uint64_t size;
    char *changed;
    char *name;
} pftp_file_t;

typedef struct {
    pftp_file_t *files;
    size_t length;
} pftp_directory_t;

#include "pftp.h"

pftp_directory_t pftp_dir_parse(const char *ls_output, pftp_server_t ftp, 
				int sys_unix);
void pftp_cpy_dir(pftp_directory_t *dest, const pftp_directory_t *src);
void pftp_free_fft(pftp_file_t fft);
void pftp_free_fdt(pftp_directory_t fdt);

#endif /* PFTP_DIRECTORY_H */
