#ifndef _OPENNET_CFG_H
#define _OPNNEET_CFG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "win32.h"

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifndef HAVE_UNAME
#include "uname.h"
#endif

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif


#ifdef DEBUG
#define PRINT_LINE fprintf(stderr, "%lu:%s:%i:%s(): ", (unsigned long) time(NULL), __FILE__, __LINE__, __func__); 
#define PRINTERR_D(x...) { PRINT_LINE; fprintf(stderr, x); fprintf(stderr, "\n"); }
#define PERROR(x) { PRINT_LINE; perror(x); }
#define DPERROR(x) PERROR(x)
#else
#define PRINT_LINE /**/
#define PRINTERR_D(x...) /**/
#define PERROR(x) perror(x);
#define DPERROR(x) /**/
#endif
#define CHECKPOINT PRINTERR_D("*** CHECKPOINT REACHED ***")
#define SPOTVAR_LLX(x) PRINTERR_D(#x " = %llx", (unsigned long long) x)
#define SPOTVAR_LLU(x) PRINTERR_D(#x " = %llu", (unsigned long long) x)
#define SPOTVAR_LU(x) PRINTERR_D(#x " = %lu", (unsigned long) x)
#define SPOTVAR_D(x) PRINTERR_D(#x " = %lf", (double) x)
#define SPOTVAR_X(x) PRINTERR_D(#x " = 0x%x", (unsigned int) x)
#define SPOTVAR_I(x) PRINTERR_D(#x " = %i", (int) x)
#define SPOTVAR_P(x) PRINTERR_D(#x " = %p", (void *) x)
#define SPOTVAR_S(x) PRINTERR_D(#x " = \"%s\"", (char *) x)


#endif
