///=======================================================================
// WARNING: Do not use as an example of how to program against the API.
//          This file is strictly for low level testing.
//=======================================================================

#include <unistd.h>

// General Header Files   
#include "ldastoolsal/unittest.h"

//-----------------------------------------------------------------------
// To gain access to all of the functions that need to be tested,
// include the entire source.
//-----------------------------------------------------------------------
#if defined(__clang__) && ( __clang_major__ >= 7 )
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wkeyword-macro"
#endif /* defined(__clang__) && ( __clang_major__ >= 7 ) */
#ifdef __gcc__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wkeyword-macro"
#endif /* __gcc__ */
#define private public
#ifdef __gcc__
#pragma GCC diagnostic pop
#endif /* __gcc__ */
#if defined(__clang__) && ( __clang_major__ >= 7 )
#pragma clang diagnostic pop
#endif /* defined(__clang__) && ( __clang_major__ >= 7 ) */

#include "../src/Cache/SDGTx.cc"
#undef private

#include "genericAPI/LDASplatform.hh"
#include "genericAPI/Logging.hh"
#include "genericAPI/LogText.hh"

//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
LDASTools::Testing::UnitTest	Test;

#include "tSDGTxSupport.icc"
#include "tSDGTxDirectoryInfo.icc"
#include "tSDGTxScanData.icc"
#include "tSDGTxDirectory.icc"
#include "tSDGTxFind.icc"

int
main( int ArgC, char** ArgV )
{
  //---------------------------------------------------------------------
  // Get ready for testing
  //---------------------------------------------------------------------
  Test.Init( ArgC, ArgV );
  if ( ! LDASTools::AL::MemChecker::IsExiting( ) )
  {

  GenericAPI::LoggingInfo::LogDirectory( "-" );
  GenericAPI::SetLogFormatter( new GenericAPI::Log::Text( "" ) );
  GenericAPI::LDASplatform::AppName( "test_createRDS_cpp" );
  if ( Test.Verbosity( ) > 0 )
  {
    GenericAPI::setLogDebugLevel( Test.Verbosity( ) );
  }
  
  //---------------------------------------------------------------------
  // Execute a series of tests
  //---------------------------------------------------------------------
  test_directory_info( );
  test_scan_data( );
#if ! __APPLE__
  test_directory( );
  test_find( );
#endif /* ! __APPLE */

  //---------------------------------------------------------------------
  // Cleanup and exit
  //---------------------------------------------------------------------
  GenericAPI::SyncLog( );
  }
  Test.Exit();
   
  //---------------------------------------------------------------------
  // Should never get this far
  //---------------------------------------------------------------------
  return 1;
}
