/*
 * LALInferenceVCSInfo.h - LALInference VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALINFERENCEVCSINFO_H
#define _LALINFERENCEVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/* global variables for vcs information */
extern const char *const lalInferenceVCSVersion;
extern const char *const lalInferenceVCSId;
extern const char *const lalInferenceVCSDate;
extern const char *const lalInferenceVCSBranch;
extern const char *const lalInferenceVCSTag;
extern const char *const lalInferenceVCSAuthor;
extern const char *const lalInferenceVCSCommitter;
extern const char *const lalInferenceVCSStatus;

/* global variables for vcs information - identable */
extern const char *const lalInferenceVCSIdentId;
extern const char *const lalInferenceVCSIdentDate;
extern const char *const lalInferenceVCSIdentBranch;
extern const char *const lalInferenceVCSIdentTag;
extern const char *const lalInferenceVCSIdentAuthor;
extern const char *const lalInferenceVCSIdentCommitter;
extern const char *const lalInferenceVCSIdentStatus;

/* library vcs information structure */
extern const struct tagLALVCSInfo lalInferenceVCSInfo;

/* configure arguments */
extern const char *const lalInferenceConfigureArgs;

/* configure date */
extern const char *const lalInferenceConfigureDate;

/* build date */
extern const char *const lalInferenceBuildDate;

#ifdef __cplusplus
}
#endif

#endif /* _LALINFERENCEVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
