/***********************************************************************
 *                                                                      *
 *               This software is part of the ast package               *
 *          Copyright (c) 1985-2011 AT&T Intellectual Property          *
 *                      and is licensed under the                       *
 *                 Eclipse Public License, Version 1.0                  *
 *                    by AT&T Intellectual Property                     *
 *                                                                      *
 *                A copy of the License is available at                 *
 *          http://www.eclipse.org/org/documents/epl-v10.html           *
 *         (with md5 checksum b35adb5213ca9657e911e9befb180842)         *
 *                                                                      *
 *              Information and Software Systems Research               *
 *                            AT&T Research                             *
 *                           Florham Park NJ                            *
 *                                                                      *
 *               Glenn Fowler <glenn.s.fowler@gmail.com>                *
 *                    David Korn <dgkorn@gmail.com>                     *
 *                     Phong Vo <phongvo@gmail.com>                     *
 *                                                                      *
 ***********************************************************************/
/*
 * posix regex fatal error interface to error()
 */
#include "config_ast.h"  // IWYU pragma: keep

#include <stddef.h>

#include "error.h"
#include "reglib.h"

void regfatalpat(regex_t *p, int level, int code, const char *pat) {
    char buf[128];

    regerror(code, p, buf, sizeof(buf));
    regfree(p);
    if (pat) {
        error(level, "regular expression: %s: %s", pat, buf);
    } else {
        error(level, "regular expression: %s", buf);
    }
}

void regfatal(regex_t *p, int level, int code) { regfatalpat(p, level, code, NULL); }
