/***********************************************************************
 *                                                                      *
 *               This software is part of the ast package               *
 *          Copyright (c) 1999-2011 AT&T Intellectual Property          *
 *                      and is licensed under the                       *
 *                 Eclipse Public License, Version 1.0                  *
 *                    by AT&T Intellectual Property                     *
 *                                                                      *
 *                A copy of the License is available at                 *
 *          http://www.eclipse.org/org/documents/epl-v10.html           *
 *         (with md5 checksum b35adb5213ca9657e911e9befb180842)         *
 *                                                                      *
 *              Information and Software Systems Research               *
 *                            AT&T Research                             *
 *                           Florham Park NJ                            *
 *                                                                      *
 *               Glenn Fowler <glenn.s.fowler@gmail.com>                *
 *                                                                      *
 ***********************************************************************/
#include "config_ast.h"  // IWYU pragma: keep

#include "sfio.h"
#include "terror.h"

tmain() {
    UNUSED(argc);
    UNUSED(argv);
    unsigned int i, r;
    Sfio_t *fp;

    if (!(fp = sftmp(8))) terror("Can't open temp file");

    for (i = 10000; i <= 100000; i += 9)
        if (sfputu(fp, i) < 0) terror("Writing %u", i);

    sfseek(fp, (Sfoff_t)0, 0);

    for (i = 10000; i <= 100000; i += 9)
        if ((r = (unsigned int)sfgetu(fp)) != i) terror("Input=%u, Expect=%u", r, i);

    texit(0);
}
