/***********************************************************************
 *                                                                      *
 *               This software is part of the ast package               *
 *          Copyright (c) 1999-2011 AT&T Intellectual Property          *
 *                      and is licensed under the                       *
 *                 Eclipse Public License, Version 1.0                  *
 *                    by AT&T Intellectual Property                     *
 *                                                                      *
 *                A copy of the License is available at                 *
 *          http://www.eclipse.org/org/documents/epl-v10.html           *
 *         (with md5 checksum b35adb5213ca9657e911e9befb180842)         *
 *                                                                      *
 *              Information and Software Systems Research               *
 *                            AT&T Research                             *
 *                           Florham Park NJ                            *
 *                                                                      *
 *               Glenn Fowler <glenn.s.fowler@gmail.com>                *
 *                                                                      *
 ***********************************************************************/
#include "config_ast.h"  // IWYU pragma: keep

#include "sfio.h"
#include "terror.h"

tmain() {
    UNUSED(argc);
    UNUSED(argv);
    int i, r;
    Sfio_t *fp;

    if (!(fp = sftmp(8))) terror("Can't open temp file");

    for (i = -5448; i <= 5448; i += 101)
        if (sfputl(fp, (long)i) < 0) terror("Writing %d", i);

    sfseek(fp, (Sfoff_t)0, 0);

    for (i = -5448; i <= 5448; i += 101)
        if ((r = (int)sfgetl(fp)) != i) terror("Input=%d, Expect=%d", r, i);

    texit(0);
}
