# regression tests for the join utilitiy

TEST 01 'one field'
	EXEC	f1 f1
		INPUT f1 $'100214179\n101425403\n1023323808'
		INPUT f2 $'100214179 aaa\n101425403 bbb\n1023323808 ccc'
		OUTPUT - $'100214179\n101425403\n1023323808'
	EXEC	f1 f2
		OUTPUT - $'100214179 aaa\n101425403 bbb\n1023323808 ccc'
	EXEC	f2 f1
		OUTPUT - $'100214179 aaa\n101425403 bbb\n1023323808 ccc'
	EXEC	f2 f2
		OUTPUT - $'100214179 aaa aaa\n101425403 bbb bbb\n1023323808 ccc ccc'

TEST 02 'two fields'
	EXEC	f1 f2
		INPUT f1 $'a       b\na       c\na       d\nb       x\nc       y\nd       z'
		INPUT f2 $'a       i\nb       j\nc       k\nd       l'
		OUTPUT - $'a b i\na c i\na d i\nb x j\nc y k\nd z l'

TEST 03 'field exercises'
	EXEC	-t'|' -e NAV -1 2 -2 2 -o 1.1 1.2 2.1 f1 f2
		INPUT f1 $'205|AL\n501|AR\n602|AZ\n209|CA\n213|CA\n310|CA\n408|CA\n415|CA\n510|CA\n619|CA'
		INPUT f2 $'4|AL\n5|AR\n7|AZ\n1|CA\n7|CO\n3|CT\n6|DC\n6|DE\n4|FL\n4|GA'
		OUTPUT - $'205|AL|4\n501|AR|5\n602|AZ|7\n209|CA|1\n213|CA|1\n310|CA|1\n408|CA|1\n415|CA|1\n510|CA|1\n619|CA|1'
	EXEC	-t'|' -e NAV -j 2 -o 1.1 1.2 2.1 f1 f2
	EXEC	-t'|' -e NAV -j1 2 -j2 2 -o 1.1 1.2 2.1 f1 f2
	EXEC	-t'|' -e NAV -1 2 -2 2 -o 1.1 1.2 2.1 f1 f2
	EXEC	-t'|' -a1 -e NAV -1 2 -2 2 -o 1.1 1.2 2.1 f1 f2
		OUTPUT - $'205|AL|4\n501|AR|5\n602|AZ|7\n209|CA|1\n213|CA|1\n310|CA|1\n408|CA|1\n415|CA|1\n510|CA|1\n619|CA|1'
	EXEC	-t'|' -a1 -e NAV -j 2 -o 1.1 1.2 2.1 f1 f2
	EXEC	-t'|' -v1 -e NAV -1 2 -2 2 -o 1.1 1.2 2.1 f1 f2
		OUTPUT -
	EXEC	-t'|' -v1 -e NAV -j 2 -o 1.1 1.2 2.1 f1 f2
	EXEC	-t'|' -a1 -e NAV -1 2 -2 2 -o 1.1 1.2 2.1 f1 f2
		INPUT f1 $'205|AL\n501|AR\n602|AZ\n209|CA\n213|CA\n310|CA\n408|CA\n415|CA\n510|CA\n619|CA\n908|NJ'
		OUTPUT - $'205|AL|4\n501|AR|5\n602|AZ|7\n209|CA|1\n213|CA|1\n310|CA|1\n408|CA|1\n415|CA|1\n510|CA|1\n619|CA|1\n908|NJ|NAV'
	EXEC	-t'|' -a1 -e NAV -j 2 -o 1.1 1.2 2.1 f1 f2
	EXEC	-t'|' -v1 -e NAV -1 2 -2 2 -o 1.1 1.2 2.1 f1 f2
		OUTPUT - $'908|NJ|NAV'
	EXEC	-t'|' -v1 -e NAV -j 2 -o 1.1 1.2 2.1 f1 f2
	EXEC	-t '|' -1 2 -2 2 f1 f2
		INPUT f1 $'1||4\n2|x|5\n3|y|6'
		INPUT f2 $'a||d\nb|x|e\nc|y|f'
		OUTPUT - $'|1|4|a|d\nx|2|5|b|e\ny|3|6|c|f'
	EXEC	-t '|' -1 2 -2 2 f1 f2
		INPUT f1 $'1|w|4\n2|x|5\n3|y|6'
		INPUT f2 $'a|w|d\nb|x|e\nc|y|f'
		OUTPUT - $'w|1|4|a|d\nx|2|5|b|e\ny|3|6|c|f'

TEST 04 'phoney stuff'
	EXEC	-t: -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		INPUT f1 $'201:1087959:317956:214759:1620674\n202:198698:113245:55505:367448\n203:370611:391058:73131:834800\n205:825456:253691:53214:1132361\n206:804098:425758:109197:1339053\n207:475252:127876:29837:632965\n208:304855:172322:31832:509009\n209:706486:233530:44440:984456\n210:732423:272243:87315:1091981\n212:614509:313916:134331:1062756'
		INPUT f2 $'201:1101647:330947:212248:1644842\n202:202179:116338:55635:374152\n203:369618:392862:74562:837042\n205:832559:251988:55911:1140458\n206:810752:428137:111784:1350673\n207:478707:126589:30118:635414\n208:307105:173927:31891:512923\n209:708069:230231:45308:983608\n210:734879:270042:97955:1102876\n212:616079:315262:135458:1066799'
		OUTPUT - $'201:201:1620674:1644842\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799'
	EXEC	-t: -a2 -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		OUTPUT - $'201:201:1620674:1644842\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799'
	EXEC	-t: -a2 -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		INPUT f2 $'201:1101647:330947:212248:1644842\n202:202179:116338:55635:374152\n203:369618:392862:74562:837042\n205:832559:251988:55911:1140458\n206:810752:428137:111784:1350673\n207:478707:126589:30118:635414\n208:307105:173927:31891:512923\n209:708069:230231:45308:983608\n210:734879:270042:97955:1102876\n212:616079:315262:135458:1066799\n908:614509:313916:134331:1062756'
		OUTPUT - $'201:201:1620674:1644842\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799\n9999999:908:9999999:1062756'
	EXEC	-t: -a1 -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		OUTPUT - $'201:201:1620674:1644842\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799'
	EXEC	-a1 -j 1 -t"|" f1 f2
		INPUT f1 $'2012000008|940214|Y|950814||||F|||32|12|638|941|KO|P\n2012000013|941201|Y|941128||R||O||N|41|12|137|9|RT|C\n2012000036|970528|Y|970616||||O|||10|10|220|148|CH|A\n2012000038|940914|Y|940912|||||||43|12|0|10|CN|N\n2012000050|940721|Y|960326||R||||N|25|12|975|116|MX|M\n2012000055|910520|Y|970627||O|||||10|10|880|432|JP|P\n2012000066|940302|Y|940225|||||||50|12|222|54|BA|C\n2012000068|940413|Y|940409|||||||48|12|0|37|AG|A\n2012000077|940330|Y|970829|||||||8|8|125|57|GY|A\n2012000079|941009|Y|951129||O||O|||29|12|1553|1753|EG|E'
		INPUT f2 $'2012000008|970619|17CPE\n2012000079|970121|17CPE\n2012000079|980227|17CPR\n2012000079|980320|OCVO4\n2012000100|951117|17CPE\n2012000153|970801|OCVO4\n2012000208|980117|17CPE\n2012000208|980118|17CPR\n2012000291|970606|17CPE\n2012000342|971114|17CPE'
		OUTPUT - $'2012000008|940214|Y|950814||||F|||32|12|638|941|KO|P|970619|17CPE\n2012000013|941201|Y|941128||R||O||N|41|12|137|9|RT|C\n2012000036|970528|Y|970616||||O|||10|10|220|148|CH|A\n2012000038|940914|Y|940912|||||||43|12|0|10|CN|N\n2012000050|940721|Y|960326||R||||N|25|12|975|116|MX|M\n2012000055|910520|Y|970627||O|||||10|10|880|432|JP|P\n2012000066|940302|Y|940225|||||||50|12|222|54|BA|C\n2012000068|940413|Y|940409|||||||48|12|0|37|AG|A\n2012000077|940330|Y|970829|||||||8|8|125|57|GY|A\n2012000079|941009|Y|951129||O||O|||29|12|1553|1753|EG|E|970121|17CPE\n2012000079|941009|Y|951129||O||O|||29|12|1553|1753|EG|E|980227|17CPR\n2012000079|941009|Y|951129||O||O|||29|12|1553|1753|EG|E|980320|OCVO4'

TEST 05 'dup join field in f1'
	EXEC	-t: -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		INPUT f1 $'201:1087959:317956:214759:1620674\n201:198698:113245:55505:2367448\n202:198698:113245:55505:367448\n203:370611:391058:73131:834800\n205:825456:253691:53214:1132361\n206:804098:425758:109197:1339053\n207:475252:127876:29837:632965\n208:304855:172322:31832:509009\n209:706486:233530:44440:984456\n210:732423:272243:87315:1091981\n212:614509:313916:134331:1062756'
		INPUT f2 $'201:1101647:330947:212248:1644842\n202:202179:116338:55635:374152\n203:369618:392862:74562:837042\n205:832559:251988:55911:1140458\n206:810752:428137:111784:1350673\n207:478707:126589:30118:635414\n208:307105:173927:31891:512923\n209:708069:230231:45308:983608\n210:734879:270042:97955:1102876\n212:616079:315262:135458:1066799'
		OUTPUT - $'201:201:1620674:1644842\n201:201:2367448:1644842\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799'
	EXEC	-t: -a2 -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		OUTPUT - $'201:201:1620674:1644842\n201:201:2367448:1644842\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799'
	EXEC	-t: -a2 -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		INPUT f2 $'201:1101647:330947:212248:1644842\n202:202179:116338:55635:374152\n203:369618:392862:74562:837042\n205:832559:251988:55911:1140458\n206:810752:428137:111784:1350673\n207:478707:126589:30118:635414\n208:307105:173927:31891:512923\n209:708069:230231:45308:983608\n210:734879:270042:97955:1102876\n212:616079:315262:135458:1066799\n908:614509:313916:134331:1062756'
		OUTPUT - $'201:201:1620674:1644842\n201:201:2367448:1644842\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799\n9999999:908:9999999:1062756'
	EXEC	-t: -a1 -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		OUTPUT - $'201:201:1620674:1644842\n201:201:2367448:1644842\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799'

TEST 06 'dup join field in f2'
	EXEC	-t: -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		INPUT f1 $'201:1087959:317956:214759:1620674\n202:198698:113245:55505:367448\n203:370611:391058:73131:834800\n205:825456:253691:53214:1132361\n206:804098:425758:109197:1339053\n207:475252:127876:29837:632965\n208:304855:172322:31832:509009\n209:706486:233530:44440:984456\n210:732423:272243:87315:1091981\n212:614509:313916:134331:1062756'
		INPUT f2 $'201:1101647:330947:212248:1644842\n201:1478707:126589:30118:635414\n202:202179:116338:55635:374152\n203:369618:392862:74562:837042\n205:832559:251988:55911:1140458\n206:810752:428137:111784:1350673\n207:478707:126589:30118:635414\n208:307105:173927:31891:512923\n209:708069:230231:45308:983608\n210:734879:270042:97955:1102876\n212:616079:315262:135458:1066799'
		OUTPUT - $'201:201:1620674:1644842\n201:201:1620674:635414\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799'
	EXEC	-t: -a2 -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		OUTPUT - $'201:201:1620674:1644842\n201:201:1620674:635414\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799'
	EXEC	-t: -a2 -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		INPUT f2 $'201:1101647:330947:212248:1644842\n201:1478707:126589:30118:635414\n202:202179:116338:55635:374152\n203:369618:392862:74562:837042\n205:832559:251988:55911:1140458\n206:810752:428137:111784:1350673\n207:478707:126589:30118:635414\n208:307105:173927:31891:512923\n209:708069:230231:45308:983608\n210:734879:270042:97955:1102876\n212:616079:315262:135458:1066799\n908:614509:313916:134331:1062756'
		OUTPUT - $'201:201:1620674:1644842\n201:201:1620674:635414\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799\n9999999:908:9999999:1062756'
	EXEC	-t: -a1 -e 9999999 -j 1 -o 1.1 2.1 1.5 2.5 f1 f2
		OUTPUT - $'201:201:1620674:1644842\n201:201:1620674:635414\n202:202:367448:374152\n203:203:834800:837042\n205:205:1132361:1140458\n206:206:1339053:1350673\n207:207:632965:635414\n208:208:509009:512923\n209:209:984456:983608\n210:210:1091981:1102876\n212:212:1062756:1066799'

TEST 07 'common fields'
	EXEC	-a 1 -a 2 -e fff f1 f2
		INPUT f1 $'000 1\n111 1\n222 1\n333 1'
		INPUT f2 $'000 1\n222 1\n333 1\n444 1'
		OUTPUT - $'000 1 1\n111 1\n222 1 1\n333 1 1\n444 1'
	EXEC	-a 1 -a 2 -e fff f2 f1
		OUTPUT - $'000 1 1\n111 1\n222 1 1\n333 1 1\n444 1'
	EXEC	-a 1 -a 2 -e fff f1 f2
		INPUT f1 $'111 1\n222 1\n333 1'
		INPUT f2 $'222 1\n333 1\n444 1'
		OUTPUT - $'111 1\n222 1 1\n333 1 1\n444 1'
	EXEC	-a 1 -a 2 f1 f2
	EXEC	-a 1 f1 f2
		OUTPUT - $'111 1\n222 1 1\n333 1 1'
	EXEC	f1 f2
		OUTPUT - $'222 1 1\n333 1 1'
	EXEC	-a 1 -a 2 -e fff f2 f1
		OUTPUT - $'111 1\n222 1 1\n333 1 1\n444 1'
	EXEC	-a 1 -a 2 f2 f1
	EXEC	-a 2 f2 f1
		OUTPUT - $'111 1\n222 1 1\n333 1 1'
	EXEC	-a 1 f2 f1
		OUTPUT - $'222 1 1\n333 1 1\n444 1'
	EXEC	f2 f1
		OUTPUT - $'222 1 1\n333 1 1'
	EXEC	-a 1 -a 2 -e fff f1 f2
		INPUT f1 $'111 a\n222 b\n333 c'
		INPUT f2 $'222 B\n333 C\n444 D'
		OUTPUT - $'111 a\n222 b B\n333 c C\n444 D'
	EXEC	-a 1 -a 2 -e fff f1 f2
		OUTPUT - $'111 a\n222 b B\n333 c C\n444 D'

TEST 08 'no common fields'
	EXEC	-v 1 -v 2 -e fff f1 f2
		INPUT f1 $'000 1\n111 1\n222 1\n333 1'
		INPUT f2 $'000 1\n222 1\n333 1\n444 1'
		OUTPUT - $'111 1\n444 1'
	EXEC	-v 1 -v 2 -e fff f2 f1
	EXEC	-v 1 -v 2 -e fff f1 f2
		INPUT f1 $'111 1\n222 1\n333 1'
		INPUT f2 $'222 1\n333 1\n444 1'
	EXEC	-v 1 -v 2 f1 f2
	EXEC	-v 1 f1 f2
		OUTPUT - $'111 1'
	EXEC	f1 f2
		OUTPUT - $'222 1 1\n333 1 1'
	EXEC	-v 1 -v 2 -e fff f2 f1
		OUTPUT - $'111 1\n444 1'
	EXEC	-v 1 -v 2 f2 f1
	EXEC	-v 2 f2 f1
		OUTPUT - $'111 1'
	EXEC	-v 1 f2 f1
		OUTPUT - $'444 1'
	EXEC	f2 f1
		OUTPUT - $'222 1 1\n333 1 1'
	EXEC	-v 1 -v 2 -e fff f1 f2
		INPUT f1 $'111 a\n222 b\n333 c'
		INPUT f2 $'222 B\n333 C\n444 D'
		OUTPUT - $'111 a\n444 D'
	EXEC	-v 1 -v 2 -e fff f1 f2
	EXEC	-t: -v 2 -1 1 -2 1 f1 f2
		INPUT f1 $'AAAA:BBBB:1:2:CCCC:DDDD'
		INPUT f2 $'AAAA:BBBB:CCCC:DDDD:bbbb\nAAAA:BBBB:CCCC:DDDD:cccc'
		OUTPUT -
	EXEC	-t: -11 -21 f1 f2
		INPUT f1 $'A\nB\nC'
		INPUT f2 $'A:F2KEYA\nB:F2KEYB\nC:F2KEYC'
		SAME OUTPUT f2
	EXEC	-t: -11 -21 f1 f2
		INPUT f1 $'A\nC\nZ'
		OUTPUT - $'A:F2KEYA\nC:F2KEYC'
	EXEC	-v1 -t: -11 -21 f1 f2
		OUTPUT - $'Z'
	EXEC	-v2 -t: -11 -21 f1 f2
		OUTPUT - $'B:F2KEYB'
	EXEC	-v1 -v2 -t: -11 -21 f1 f2
		OUTPUT - $'B:F2KEYB\nZ'

TEST 09 'boundary conditions'
	EXEC	-1 2 -2 1 -o 1.1,2.2 f1 f2
		INPUT f1 $'903672 486\n806565 536\n806754 536\n806988 536\n915043 540\n915220 540\n915966 961\n915985 961'
		INPUT f2 $'540 3000\n542 4000\n664 5000\n961 6000'
		OUTPUT - $'915043 3000\n915220 3000\n915966 6000\n915985 6000'
	EXEC	-a1 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $'903672 \n806565 \n806754 \n806988 \n915043 3000\n915220 3000\n915966 6000\n915985 6000'
	EXEC	-a2 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $'915043 3000\n915220 3000\n 4000\n 5000\n915966 6000\n915985 6000'
	EXEC	-a1 -a2 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $'903672 \n806565 \n806754 \n806988 \n915043 3000\n915220 3000\n 4000\n 5000\n915966 6000\n915985 6000'
	EXEC	-v1 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $'903672 \n806565 \n806754 \n806988 '
	EXEC	-v2 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $' 4000\n 5000'
	EXEC	-v1 -v2 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $'903672 \n806565 \n806754 \n806988 \n 4000\n 5000'
	EXEC	-a1 -v1 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $'903672 \n806565 \n806754 \n806988 '
	EXEC	-a1 -v2 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $'903672 \n806565 \n806754 \n806988 \n 4000\n 5000'
	EXEC	-v1 -a2 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $'903672 \n806565 \n806754 \n806988 \n 4000\n 5000'
	EXEC	-v2 -a2 -1 2 -2 1 -o 1.1,2.2 f1 f2
		OUTPUT - $' 4000\n 5000'

TEST 10 'more ggs/psm bugs -- thanks guys'
	EXEC	-t: -a 1 -a 2 f1 f2
		INPUT f1 $'AGAIN:D981001:47\nAGAINST:D981001:101\nAGREED:D981001:67:72\nAHAS:D981001:5'
		INPUT f2 $'AGAIN:D981002:15:58\nAGO:D981002:31\nAL/TUC:D981002:2:3:4:5:6\nALL:D981002:16:58:74:84'
		OUTPUT - $'AGAIN:D981001:47:D981002:15:58\nAGAINST:D981001:101\nAGO:D981002:31\nAGREED:D981001:67:72\nAHAS:D981001:5\nAL/TUC:D981002:2:3:4:5:6\nALL:D981002:16:58:74:84'
	EXEC	-a2 f1 f2
		INPUT f1 $'9112170179\n9112170180\n9112170181\n9112170182'
		INPUT f2 $'9112161885\n9112170180\n9112170180\n9112170421\n9112170464'
		OUTPUT - $'9112161885\n9112170180\n9112170180\n9112170421\n9112170464'

SET pipe-input

TEST 11 'pipe on 1 or 2'
	EXEC	f1 -
		INPUT - $'9112161885\n9112170180\n9112170180\n9112170421\n9112170464'
		INPUT f1 $'9112170179\n9112170180\n9112170181\n9112170182'
		OUTPUT - $'9112170180\n9112170180'
	EXEC	- f1
	EXEC	f2 -
		INPUT - $'9112170179\n9112170180\n9112170181\n9112170182'
		INPUT f2 $'9112161885\n9112170180\n9112170180\n9112170421\n9112170464'
	EXEC	- f2

SET nopipe-input

TEST 12 'gnu join tests'
	EXEC	-a1 f1 f2
		INPUT f1 $'a 1'
		INPUT f2 $'b'
		OUTPUT - $'a 1'
	EXEC	-a2 f1 f2
		INPUT f1 $'a 1'
		INPUT f2 $'b'
		OUTPUT - $'b'
	EXEC	-a1 -a2 f1 f2
		INPUT f1 $'a 1'
		INPUT f2 $'b'
		OUTPUT - $'a 1\nb'
	EXEC	-a1 f1 f2
		INPUT f1 $'a 1\nb'
		INPUT f2 $'b'
		OUTPUT - $'a 1\nb'
	EXEC	-a2 f1 f2
		INPUT f1 $'a 1\nb'
		INPUT f2 $'b'
		OUTPUT - $'b'
	EXEC	-a2 f1 f2
		INPUT f1 $'b'
		INPUT f2 $'a\nb'
		OUTPUT - $'a\nb'

TEST 13 '-a -e'
	EXEC	-a1 -e . f1 f2
		INPUT f1 $'a\nb\nc'
		INPUT f2 $'a x y\nb\nc'
		OUTPUT - $'a x y\nb\nc'
	EXEC	-a1 -e . -o 2.1,2.2,2.3 f1 f2
		INPUT f1 $'a\nb\nc'
		INPUT f2 $'a x y\nb\nc'
		OUTPUT - $'a x y\nb . .\nc . .'
	EXEC	-a1 -e . -o 2.1,2.2,2.3 f1 f2
		INPUT f1 $'a\nb\nc\nd'
		INPUT f2 $'a x y\nb\nc'
		OUTPUT - $'a x y\nb . .\nc . .\n. . .'

TEST 14 '-t'
	EXEC	-t: f1 f2
		INPUT f1 $'a:1\nb:1'
		INPUT f2 $'a:2:\nb:2:'
		OUTPUT - $'a:1:2:\nb:1:2:'

TEST 15 '-v'
	EXEC	-v 1 f1 f2
		INPUT f1 $'a 1'
		INPUT f2 $'b'
		OUTPUT - $'a 1'
	EXEC	-v 2 f1 f2
		INPUT f1 $'a 1'
		INPUT f2 $'b'
		OUTPUT - $'b'
	EXEC	-v 1 f1 f2
		INPUT f1 $'a 1\nb'
		INPUT f2 $'b'
		OUTPUT - $'a 1'
	EXEC	-v 2 f1 f2
		INPUT f1 $'a 1\nb'
		INPUT f2 $'b'
		OUTPUT - 
	EXEC	-v 2 f1 f2
		INPUT f1 $'b'
		INPUT f2 $'a 1\nb'
		OUTPUT - $'a 1'

TEST 16 '-a -e -o'
	EXEC	-a1 -e - -o 1.1 2.2 f1 f2
		INPUT f1 $'a 1\nb 2'
		INPUT f2 $'a 11\nb'
		OUTPUT - $'a 11\nb \-'
	EXEC	-a1 -e - -o 1.1 2.2 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18\nfeb 05'
		INPUT f2 $'apr 06\naug 14\ndate\nfeb 15'
		OUTPUT - $'apr 06\naug 14\ndec \-\nfeb 15'
	EXEC	-a1 -e - -o 1.1 2.2 f1 f2
		INPUT f1 $'aug 20\ndec 18'
		INPUT f2 $'aug 14\ndate\nfeb 15'
		OUTPUT - $'aug 14\ndec \-'
	EXEC	-a1 -e - -o 1.1 2.2 f1 f2
		INPUT f1 $'dec 18'
		INPUT f2
		OUTPUT - $'dec \-'
	EXEC	-a2 -e - -o 1.1 2.2 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18\nfeb 05'
		INPUT f2 $'apr 06\naug 14\ndate\nfeb 15'
		OUTPUT - $'apr 06\naug 14\n\- \-\nfeb 15'
	EXEC	-a2 -e - -o 2.2 1.1 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18\nfeb 05'
		INPUT f2 $'apr 06\naug 14\ndate\nfeb 15'
		OUTPUT - $'06 apr\n14 aug\n\- \-\n15 feb'
	EXEC	-a1 -e - -o 2.2 1.1 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18\nfeb 05'
		INPUT f2 $'apr 06\naug 14\ndate\nfeb 15'
		OUTPUT - $'06 apr\n14 aug\n\- dec\n15 feb'
	EXEC	-a1 -e - -o 2.2 1.1 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18\nfeb 05'
		INPUT f2 $'apr 06\naug 14\ndate'
		OUTPUT - $'06 apr\n14 aug\n\- dec\n\- feb'
	EXEC	-a1 -e - -o 1.1 2.2 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18\nfeb 05'
		INPUT f2 $'apr 06\naug 14\ndate'
		OUTPUT - $'apr 06\naug 14\ndec \-\nfeb \-'
	EXEC	-a2 -e - -o 2.2 1.1 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18\nfeb 05'
		INPUT f2 $'apr 06\naug 14\ndate'
		OUTPUT - $'06 apr\n14 aug\n\- \-'
	EXEC	-a2 -e - -o 2.2 1.1 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18\nfeb 05'
		INPUT f2 $'apr 06\naug 14\ndate'
		OUTPUT - $'06 apr\n14 aug\n\- \-'
	EXEC	-a1 -e - -o 2.2 1.1 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18'
		INPUT f2 $'apr 06\naug 14\ndate\nfeb 15'
		OUTPUT - $'06 apr\n14 aug\n\- dec'
	EXEC	-a2 -e - -o 2.2 1.1 f1 f2
		INPUT f1 $'apr 15\naug 20\ndec 18'
		INPUT f2 $'apr 06\naug 14\ndate\nfeb 15'
		OUTPUT - $'06 apr\n14 aug\n\- \-\n15 \-'

TEST 17 '-e'
	EXEC	-e - f1 f2
		INPUT f1 $'a 1\nb 2\nd 4'
		INPUT f2 $'a 21\nb 22\nc 23\nf 26'
		OUTPUT - $'a 1 21\nb 2 22'
	EXEC	-a1 -e - f1 f2
		INPUT f1 $'a 1\nb 2\nd 4'
		INPUT f2 $'a 21\nb 22\nc 23\nf 26'
		OUTPUT - $'a 1 21\nb 2 22\nd 4'
	EXEC	-a1 -e - f1 f2
		INPUT f1 $'a 21\nb 22\nc 23\nf 26'
		INPUT f2 $'a 1\nb 2\nd 4'
		OUTPUT - $'a 21 1\nb 22 2\nc 23\nf 26'

TEST 18 '-a -e -o'
	EXEC	-a1 -e . -o 2.7 f1 f2
		INPUT f1 $'a\nb\nc'
		INPUT f2 $'a x y\nb\nc'
		OUTPUT - $'.\n.\n.'
	EXEC	-a1 -e . -o 0,1.2 f1 f2
		INPUT f1 $'a\nb\nc\nd G'
		INPUT f2 $'a x y\nb\nc\ne'
		OUTPUT - $'a .\nb .\nc .\nd G'
	EXEC	-a1 -a2 -e . -o 0,1.2 f1 f2
		INPUT f1 $'a\nb\nc\nd G'
		INPUT f2 $'a x y\nb\nc\ne'
		OUTPUT - $'a .\nb .\nc .\nd G\ne .'

TEST 19 'empty field deref'
	EXEC	-o 1.1 2.1 1.2 2.2 2.3 f1 f1
		INPUT f1 $'U+0750'
		OUTPUT - $'U+0750 U+0750   '

TEST 20 'nuttin'
	EXEC	f1 f2
		INPUT f1 $' a 1\nb 2'
		INPUT f2 $' a Y\nb Z'
		OUTPUT - $'a 1 Y\nb 2 Z'

TEST 21 '-v1 vs. -v2 inconsistencies'
	EXEC	-11 -21 -v2 f1 f2
		INPUT f1 $'a\nb\nc'
		INPUT f2 $'a 1\nb 2\nb 3\nc 4'
		OUTPUT -
	EXEC	-11 -21 -v1 f2 f1

TEST 22 VSC#8

	EXEC	-1 1 -2 1 -t: -o 1.5,2.5,1.6,2.6 -e bozo a.dat b.dat
		INPUT a.dat $'three:this:is:line:three:file2\ntwo:this:is:line:two:file2'
		INPUT b.dat $'four:this:is:line:four:file3\nthree:this:is:line:three::file3'
		OUTPUT - $'three:three:file2:bozo'

TEST 23 'multibyte C.UTF-8'

	EXPORT LC_CTYPE=C.UTF-8

	EXEC	-j1 1 -j2 2 -o 1.1 -t $'\342\202\254' a.dat b.dat
		INPUT a.dat $'f1\342\202\254f2'
		INPUT b.dat $'t2\342\202\254f1'
		OUTPUT - 'f1'

TEST 24 'multibyte euc'

	EXPORT LC_CTYPE=ja_JP.eucJP

	EXEC	-j1 1 -j2 2 -o 1.1 -t $'\xa1\xf7' a.dat b.dat
		INPUT a.dat $'f1\xa1\xf7f2'
		INPUT b.dat $'t2\xa1\xf7f1'
		OUTPUT - 'f1'
