# regression tests for the sum sort discipline library

TITLE + sum

export LC_ALL=C

VIEW data

TEST 01 'basics'

	EXEC -k.1.1 -lsum,op=sum:integer:.2.1
		INPUT - $'a2\na4\nb2\nc2\na1\nc7\nb6'
		OUTPUT - $'a7\nb8\nc9'
	EXEC -k.1.1 -lsum,op=sum:.2.1
		INPUT - $'a2\na4\nb2\nc2\na1\nc7\nb6'
		OUTPUT - $'a7\nb8\nc9'
	EXEC -k.1.1 -lsum,op=max:integer:.2.1
		OUTPUT - $'a4\nb6\nc7'
	EXEC -k.1.1 -lsum,op=min:integer:.2.1
		OUTPUT - $'a1\nb2\nc2'
	EXEC -k.1.1 -lsum,op=average:integer:.2.1
		OUTPUT - $'a2\nb4\nc4'
	EXEC -k.1.1 -lsum,op=:set:'\t':.2.1
		OUTPUT - $'a\t\nb\t\nc\t'

TEST 02 'diagnostics'

	EXEC -k.1.1 -lsum,op=s:integer:.2
		INPUT - $'a2\na4\nb2\nc2\na1\nc8\nb6'
		OUTPUT - $'a7\nb8\nc10'
	EXEC -k.1.1 -lsum,op=s:integer:.2.1
		EXIT 1
		INPUT - $'a2\na4\nb2\nc2\na1\nc8\nb6'
		OUTPUT -
		ERROR - $'sort: number value 10 width exceeds 1'
	EXEC -k.3 -k.1.1 -lsum,op=s:integer:.2.1
		ERROR - $'sort: number value 10 width exceeds 1'
	EXEC -k.3 -k.1.1 -lsum,op=max:.2.1:integer
		ERROR - $'sort: integer: invalid summary field operation'

TEST 03 'multiple fields'

	EXEC -Eo -R300 -lsum,debug,op=s:bcd_t:.195.5:.201.5:.206.6:.212.5:a:.217.7:.224.6:v:'\n':.230.7:.238.7 /dev/null
		ERROR - $'op 1 .195.5 s 4=>1 bcd_t
op 2 .201.5 s 4=>1 bcd_t
op 3 .206.6 s 4=>1 bcd_t
op 4 .212.5 s 4=>1 bcd_t
op 5 .217.7 a 4=>1 bcd_t
op 6 .224.6 a 4=>1 bcd_t
op 7 .230.7 v 4=>1 \'\\n\'
op 8 .238.7 v 4=>1 \'\\n\''
	EXEC -Eo -R300 -lsum,debug,op=sum:bcd_t:.195.5:.201.5:.206.6:.212.5:average:.217.7:.224.6:set:'\n':.230.7:.238.7 /dev/null

TEST 04 'variable length with width expansion'

	EXEC -t, -k 1,2 -lsum,op=sum:3
		INPUT - $'car,C,100
jrr,C,100
gsf,G,1
pdragosh,B,1
car,C,200
jrr,C,200
gsf,G,23
pdragosh,B,95
gsf,G,456'
		OUTPUT - $'car,C,300
gsf,G,480
jrr,C,300
pdragosh,B,96'

	EXEC -t' ' -k 1,2 -lsum,op=sum:3
		INPUT - $'car    C    100
jrr    C    100
gsf    G    1
pdragosh    B    1
car    C    200
jrr    C    200
gsf    G    23
pdragosh    B    95
gsf    G    456'
		OUTPUT - $'car    C    300
gsf    G    480
jrr    C    300
pdragosh    B    96'

	EXEC -k1,1 -lsum,op=max:2,op=sum:9
		INPUT - $'message      1  record      1  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 43  offset 0
message      2  record      2  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 57  offset 55
message      3  record      3  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 124
message      4  record      4  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 186
message      5  record      5  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 248
message      6  record      6  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 310
message      7  record      7  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 372
message      8  record      8  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 434
message      9  record      9  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 496
message     10  record     10  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 558
message     11  record     11  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 620
message     12  record     12  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 682
message     13  record     13  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 744
message     14  record     14  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 43  offset 806
message     15  record     15  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 861
message     16  record     16  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 57  offset 923
message     17  record     17  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 992
message     18  record     18  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 50  offset 1054
message     19  record     19  time 1314100800  TABLE_DUMP.IPV6_UNICAST size 80  offset 1116'
		OUTPUT - $'message      19 record      1  time 1314100800  TABLE_DUMP.IPV4_UNICAST size 980 offset 0'

TEST 05 'different types'

	EXEC -t'|' -k 4,4 -lsum,op=sum:integer:7 $data/nyse.dat
		OUTPUT - $'N|N0003|200106|AA|11|21|86407|3524300|9331|3494983|15500|1129332|1283396|639798|452298|5659|0.0021|0.0289|1717663|0.038|30|1195358|20|597462|0.0481|35
N|N0003|200106|AAT|11|21|455|14046|0|14046|0|7421|4549|1485|591|0|0.0314|0.0304|2513|0.01|25|11333|14|200|0.01|90
N|N0003|200106|ABJ|11|21|207|14508|0|14508|0|2603|9175|1650|1080|0|0.0756|0.0779|6636|0.0136|17|7872|25|||
N|N0003|200106|ABS|11|21|40667|1465605|200|1461410|2900|483622|651665|241738|87165|120|0.0097|0.0284|599869|0.0306|22|670152|18|194289|0.0373|25
N|N0003|200106|ABT|11|21|100005|3368858|8904|3347422|10900|1469987|1273455|447558|166267|1055|0.0041|0.0273|1682138|0.0365|18|1150749|14|525435|0.044|25
N|N0003|200106|ACA|11|21|185|11490|0|11490|0|2845|7495|100|1050|0|0.0908|0.0946|5052|0.0146|17|6438|22|||
N|N0003|200106|ACS|11|21|23220|523323|13500|509523|0|192518|202103|71973|42229|700|-0.0264|0.0658|254514|0.0654|21|177869|17|77140|0.0915|38
N|N0003|200106|AEF|11|21|1167|61757|0|61757|0|9524|22881|15536|13616|200|0.0418|0.0464|24867|0.0137|47|35248|43|1642|0.0401|27
N|N0003|200106|AET|11|21|20996|472785|900|471531|300|213068|162069|63465|32949|280|0.0069|0.0217|214120|0.0315|22|224763|16|32948|0.035|26
N|N0003|200106|AGC|11|21|43706|1443428|2747|1438956|1000|588445|574302|188125|88940|0|0.0076|0.0283|603123|0.0256|22|661220|16|175613|0.0329|31
N|N0003|200106|AGCPRA|11|21|315|16339|0|16339|0|3810|5914|4990|1625|0|0.1073|0.1187|7461|0.11|44|8678|25|200|0.085|8
N|N0003|200106|AGCPRB|11|21|293|6853|0|6853|0|100|3855|1550|1348|0|0.1382|0.115|3097|0.0587|44|3756|46|||
N|N0003|200106|AGCPRM|11|21|360|15702|100|15602|0|1685|7911|3046|2170|790|0.0762|0.0876|4071|0.0247|64|11031|65|500|0.078|166
N|N0003|200106|AGCPRMCL|11|21|30|1223|0|1223|0|0|923|300|0|0|0.04|0.04|1223|0.01|22|||||
N|N0003|200106|AGCPRN|11|21|262|18338|0|18338|0|5186|8423|2223|2306|200|0.0895|0.0967|2885|0.0334|65|15203|23|250|0.046|21
N|N0003|200106|AGCPRNCL|11|21|21|665|0|665|0|100|565|0|0|0|0.01|0.01||||665|21|||
N|N0003|200106|AGI|11|21|268|4879|0|4879|0|730|2761|1388|0|0|0.0154|0.0238|4099|0.0433|19|780|29|||
N|N0003|200106|AHO|11|21|5492|101764|100|101464|200|25120|56355|13898|6291|0|0.0582|0.061|51772|0.043|22|43731|19|6161|0.0371|23
N|N0003|200106|AIV|11|21|10308|143764|0|143464|0|58036|56027|19187|10214|0|0.0376|0.0629|54117|0.0484|20|80319|20|9028|0.0438|29
N|N0003|200106|AIVPRC|11|21|187|5998|0|5998|0|2025|2725|948|300|0|0.1019|0.1098|2675|0.0259|25|3023|15|300|0.09|37
N|N0003|200106|AIVPRD|11|21|350|15180|0|15180|0|5430|8025|825|900|0|0.1032|0.1226|6105|0.0322|15|8975|24|100|0.04|12
N|N0003|200106|AIVPRG|11|21|340|12295|0|12295|0|3195|6435|1315|1350|0|0.084|0.0783|3675|0.0122|30|7920|24|700|0.0343|32
N|N0003|200106|AIVPRH|11|21|141|5959|0|5959|0|2100|3074|785|0|0|0.075|0.1345|2824|0.0322|13|3035|18|100|0.11|9
N|N0003|200106|AIVPRK|11|21|48|2070|0|2070|0|0|1070|600|400|0|0.2686|0.4413|1350|0.1863|48|720|20|||
N|N0003|200106|AIVPRP|11|21|220|11916|0|11916|0|3681|4873|2148|1214|0|0.1826|0.2129|3376|0.0379|23|8540|26|||
N|N0003|200106|AIVPRQ|11|21|373|10242|0|10242|0|3898|5497|327|520|0|0.0807|0.0792|4613|0.0174|19|5629|13|||
N|N0003|200106|AJG|11|21|14874|196649|600|196049|0|80999|79015|21230|12954|1851|0.0292|0.0426|79215|0.0366|26|106810|13|10024|0.0518|45
N|N0003|200106|ALM|11|21|1560|9137|0|9137|0|300|7876|961|0|0|0.0497|0.0618|7139|0.0245|19|1998|15|||
N|N0003|200106|ALPPRN|11|21|11|1290|0|1290|0|0|890|400|0|0|0|0.181|400|0.05|16|890|21|||
N|N0003|200106|ALPPRO|11|21|22|1700|0|1700|0|0|1700|0|0|0|0.0159|0.2247|950|0.0621|26|750|18|||
N|N0003|200106|ALPPRQ|11|21|118|7400|0|7400|0|2517|4483|400|0|0|0.0703|0.0795|3496|0.0287|17|3904|11|||
N|N0003|200106|ALPPRR|11|21|192|12186|0|12186|0|2223|8511|1152|300|0|0.0695|0.0713|4546|0.0179|18|7540|15|100|0.04|63
N|N0003|200106|ALQ|11|21|319|14947|0|14947|0|5706|7091|2050|100|0|0.088|0.0864|8607|0.0231|21|6040|12|300|0.01|7
N|N0003|200106|ALZ|11|21|172|10019|0|10019|0|800|8563|656|0|0|0.0994|0.1095|6749|0.0256|19|3270|13|||
N|N0003|200106|AMB|11|21|9284|82057|0|81694|0|49345|26444|3944|1961|0|0.0218|0.029|37759|0.0248|12|40635|11|3300|0.0224|15
N|N0003|200106|AMBPRA|11|21|112|5460|0|5460|0|3560|1700|200|0|0|0.0574|0.1091|3300|0.0473|10|2160|13|||
N|N0003|200106|AMD|11|21|158595|4782471|105767|4655665|17300|1343670|1809871|952933|564656|1635|-0.01|0.0399|2160554|0.0464|24|1180503|21|1331908|0.0601|37
N|N0003|200106|ANN|11|21|14864|308613|7500|301013|100|160173|110558|25319|5063|0|-0.0095|0.0525|131184|0.0608|13|134861|10|35068|0.0762|17
N|N0003|200106|AOC|11|21|31694|740421|1545|737685|900|213132|304297|146622|73959|575|0.0001|0.0241|340231|0.0367|28|337678|21|60676|0.0378|34
N|N0003|200106|ARB|11|21|7383|81559|300|81259|0|24043|40724|12568|3924|0|0.0259|0.0549|39589|0.0546|22|36715|18|4955|0.0477|23
N|N0003|200106|ARH|11|21|158|1815|0|1815|0|400|1115|100|200|0|0.0357|0.0527|1190|0.0182|31|625|19|||
N|N0003|200106|ATI|11|21|13450|204221|195|204026|0|95949|86063|15394|6520|100|0.011|0.0249|88367|0.0285|16|109155|13|6504|0.0249|20
N|N0003|200106|AVP|11|21|39557|1025278|1664|1021714|1300|640871|320330|47980|12801|1032|-0.0027|0.0305|463631|0.0358|10|466899|8|92484|0.0454|15
N|N0003|200106|AVZ|11|21|4359|42999|0|42899|100|15985|19543|6471|1000|0|0.1208|0.1957|20702|0.1167|19|19355|14|2942|0.0663|19
N|N0003|200106|AXL|11|21|2761|43442|0|43442|0|11343|20974|6885|4240|0|0.0524|0.0834|21281|0.0732|30|20822|22|1339|0.0249|14
N|N0003|200106|AZA|11|21|72083|777156|5600|770456|500|475253|227074|51985|16512|132|0.0081|0.0359|346051|0.0248|11|287853|9|137052|0.035|17
N|N0003|200106|AZZ|11|21|999|30688|0|30688|0|5454|17696|5938|1600|0|0.0621|0.0925|17081|0.0713|24|12107|24|1500|0.0293|20
N|N0003|200106|BC|11|21|21176|347438|2150|344388|900|119326|140853|55052|29034|1023|0.0049|0.0287|151059|0.0335|27|165409|19|28820|0.0421|28
N|N0003|200106|BCC|11|21|29620|232534|1500|231034|0|90880|102617|27338|10199|0|0.0026|0.0495|86498|0.0425|21|123377|15|21159|0.0489|20
N|N0003|200106|BD|11|21|3387|26224|200|26024|0|8210|15964|1850|0|0|0.0081|0.0147|10370|0.0141|12|14654|13|1000|0.014|21
N|N0003|200106|BDF|11|21|207|9620|0|9620|0|3229|4243|1738|410|0|0.0458|0.0565|2903|0.0136|13|6717|23|||
N|N0003|200106|BGG|11|21|9151|164711|600|163823|0|76597|68590|14556|4080|0|0.0223|0.0874|65955|0.0439|16|85847|11|12021|0.0977|21
N|N0003|200106|BGT|11|21|550|15473|0|15473|0|8014|5024|1985|450|0|0.015|0.0185|3385|0.01|10|12088|14|||
N|N0003|200106|BK|11|21|97952|3340606|5800|3332030|800|2109454|974660|195186|53530|0|-0.0055|0.0372|1548826|0.0305|11|1273475|9|510529|0.0417|16
N|N0003|200106|BKE|11|21|1805|18544|0|18544|0|3788|12093|2226|437|0|0.0169|0.0528|10301|0.0694|18|7843|20|400|0.035|15
N|N0003|200106|BKPRC|11|21|318|17897|0|17897|0|10855|5842|850|350|0|0.0804|0.0857|8767|0.0274|15|8630|11|500|0.028|7
N|N0003|200106|BKPRD|11|21|394|21826|0|21826|0|13055|7571|500|700|0|0.0658|0.0714|10371|0.0168|11|11155|14|300|0.08|18
N|N0003|200106|BKPRE|11|21|300|23243|0|23243|0|10876|10497|1470|400|0|0.076|0.0832|15715|0.0205|15|7528|12|||
N|N0003|200106|BLI|11|21|10972|227952|1609|226143|100|75627|104943|33926|11747|0|0.0094|0.0263|112032|0.0332|20|104908|17|9303|0.0328|22
N|N0003|200106|BNI|11|21|50514|1206018|400|1203328|1600|680896|414696|85020|23178|1138|0.0049|0.0285|588392|0.0262|13|511908|10|104628|0.0403|19
N|N0003|200106|BR|11|21|64359|1378982|4900|1370416|2000|687207|493400|131614|58722|1473|0.0112|0.0302|782525|0.0406|16|459377|12|130514|0.0503|29
N|N0003|200106|BRG|11|21|881|11360|0|11360|0|2143|6614|1791|812|0|0.1021|0.1699|6410|0.118|29|4850|22|100|0.1|63
N|N0003|200106|BSP|11|21|268|4791|0|4791|0|1745|2537|509|0|0|0.0816|0.0835|2054|0.0143|14|2337|15|400|0.045|9
N|N0003|200106|BTY|11|21|10559|203914|400|203314|200|78459|82586|27485|14884|100|0.0731|0.1174|111376|0.0744|24|78300|16|13838|0.0657|24
N|N0002|200106|BTYRT|11|21|1262|50506|0|50506|0|19517|24313|3320|3356|0|0.1058|0.1598|32175|0.1498|23|17731|14|600|0.055|20
N|N0003|200106|BWG|11|21|661|6512|0|6512|0|1183|4379|650|300|0|0.0722|0.1734|4366|0.0936|24|2046|21|100|0.08|0
N|N0003|200106|BXS|11|21|4251|33939|0|33939|0|14334|13818|5063|724|0|-0.002|0.0378|17439|0.042|14|15418|17|1082|0.0204|22
N|N0003|200106|BYD|11|21|3086|35218|200|35018|0|8011|13121|6471|7115|300|0.0349|0.0426|12541|0.0321|37|19449|44|3028|0.0338|50
N|N0003|200106|BZL|11|21|147|2330|0|2330|0|1000|400|530|400|0|0.0741|0.0748|1130|0.04|53|800|8|400|0.02|7
N|N0003|200106|C|11|21|212024|7798662|31303|7747379|16900|3563357|2481386|1113981|603003|2552|0.0063|0.0228|4246991|0.0389|19|2228824|15|1288464|0.0463|33
N|N0003|200106|CBM|11|21|9318|194272|2240|191632|0|63286|89872|27044|11430|0|0.0026|0.1101|81401|0.0814|22|85841|16|24390|0.132|30
N|N0003|200106|CCC|11|21|3351|43832|300|43532|0|9359|19019|8257|6297|600|0.0433|0.0488|20746|0.0443|44|20283|29|2503|0.0202|39
N|N0003|200106|CCPPRA|11|21|157|13025|0|13025|0|2350|7424|2707|544|0|0.1786|0.3285|5751|0.0625|18|6774|26|500|0.058|17
N|N0003|200106|CCR|11|21|38403|728090|6800|719678|1000|267653|271128|122720|59077|100|-0.0069|0.0301|346880|0.0381|22|277870|18|95928|0.0488|30
N|N0003|200106|CEA|11|21|90|2229|0|2229|0|300|1601|328|0|0|0.0891|0.1549|928|0.031|17|1201|16|100|0.01|16
N|N0003|200106|CED|11|21|7490|25925|300|25625|0|5812|12625|5838|1350|0|0.1071|0.108|13523|0.0484|25|10252|19|1850|0.043|36
N|N0003|200106|CEM|11|21|3300|30385|0|30385|0|6560|16100|6125|1600|0|0.0332|0.0917|15567|0.0682|23|13468|23|1350|0.0337|30
N|N0003|200106|CEN|11|21|9359|110436|0|110236|200|45363|46318|11486|6969|300|0.0197|0.0306|50010|0.0344|21|55025|14|5401|0.0262|38
N|N0003|200106|CF|11|21|27038|639764|3248|634316|1500|182374|248718|123189|77927|3608|0.01|0.0254|286515|0.033|30|282454|22|66847|0.0282|49
N|N0003|200106|CFE|11|21|98|1684|0|1684|0|1300|100|284|0|0|0.1609|0.1669|984|0.25|18|700|8|||
N|N0003|200106|CFN|11|21|122|4234|0|4234|0|1018|1116|1300|800|0|0.0738|0.0828|1200|0.3967|71|3034|26|||
N|N0003|200106|CGPPRG|12|21|2684|5400|4900|500|0|0|100|200|200|0|-1.076|0.184|200|0.75|80|300|33|||
N|N0003|200106|CGPPRI|11|21|2481|750|0|750|0|0|200|0|400|150|-0.6333|0.026|550|0.7182|511|200|23|||
N|N0003|200106|CGPPRT|11|21|406|9711|0|9711|0|3766|4598|1147|200|0|0.0709|0.0734|2517|0.0372|15|7042|15|152|0.01|24
N|N0003|200106|CHD|11|21|9848|132464|1359|131105|0|52672|55896|14149|7853|535|0.0327|0.0634|55486|0.0467|19|68291|17|7328|0.0501|27
N|N0003|200106|CHH|11|21|3983|54062|0|53762|0|17816|21767|9596|4583|0|0.0255|0.0552|26188|0.0734|31|23562|16|4012|0.0527|16
N|N0002|200106|CHTRT|11|21|77|3174|0|3174|0|160|0|320|2375|319|0.0599|0.0609|1735|0.0113|116|1439|198|||
N|N0002|200106|CHTRTWI|12|24|26|5000|0|5000|0|0|0|5000|0|0|-0.02|0.04||||5000|31|||
N|N0003|200106|CIC|11|21|907|49613|0|49613|0|12025|25301|7518|4769|0|0.0555|0.0656|15733|0.0419|22|33280|25|600|0.0533|62
N|N0003|200106|CIP|11|21|529|22418|0|22418|0|4677|16266|1050|425|0|0.0692|0.0745|11685|0.0212|16|10033|16|700|0.0229|12
N|N0003|200106|CIR|11|21|3763|57557|600|56957|0|24724|23479|6114|2640|0|-0.0348|0.0568|31783|0.0736|16|21547|14|3627|0.1043|30
N|N0003|200106|CKC|11|21|1923|29607|0|29607|0|9386|15183|3387|1651|0|0.0419|0.0255|7241|0.0637|30|21486|17|880|0.0327|46
N|N0003|200106|CKH|11|21|6273|88089|0|88089|0|41269|36261|7618|2941|0|0.0003|0.0825|32140|0.0668|15|48565|12|7384|0.0821|18
N|N0003|200106|CLB|11|21|6228|122678|600|122078|0|25245|56302|22564|17297|670|0.0619|0.0714|57167|0.0743|39|58510|25|6401|0.0322|58
N|N0003|200106|CLJ|11|21|2691|38026|0|38026|0|5116|17590|8934|6386|0|0.0573|0.0909|17649|0.0682|43|19877|32|500|0.042|67
N|N0003|200106|CLL|11|21|505|8406|300|8106|0|1238|4650|1785|433|0|0.1254|0.2263|3948|0.1524|16|3958|24|200|0.29|58
N|N0003|200106|CMO|11|21|5068|106712|0|106312|400|43418|52504|8949|1841|0|0.0355|0.0488|53463|0.043|16|49371|12|3878|0.0384|11
N|N0003|200106|CMOPRA|11|21|112|3043|0|3043|0|1294|850|599|300|0|0.5313|0.3056|1249|0.5695|35|1794|16|||
N|N0003|200106|CMOPRB|11|21|291|10036|0|10036|0|3886|4894|915|341|0|0.1375|0.13|3128|0.0804|19|6528|19|380|0.01|14
N|N0003|200106|CMP|11|21|1783|73395|0|73395|0|17955|42915|9935|2590|0|0.0915|0.1083|20714|0.0277|19|48680|18|4001|0.0559|33
N|N0003|200106|CMS|11|21|22036|430340|888|427110|2000|222679|168912|27920|9599|0|0.0123|0.0312|192319|0.0264|13|205993|11|30798|0.0334|18
N|N0003|200106|CMSPRJ|11|21|96|6005|0|6005|0|975|4230|800|0|0|0.1592|0.2442|3930|0.0288|18|1775|17|300|0.1|17
N|N0003|200106|CMSPRK|11|21|157|9399|0|9399|0|800|7649|950|0|0|0.1539|0.2479|2575|0.0399|17|6124|18|700|0.1843|12
N|N0003|200106|CMSPRL|11|21|493|9413|0|9413|0|2016|4977|2005|415|0|0.1458|0.1851|4199|0.0565|24|4814|22|400|0.1|37
N|N0003|200106|CMSPRM|11|21|1098|1698|0|1698|0|0|1398|0|300|0|0.3066|0.3419|1398|0.0949|20|||300|0.25|156
N|N0003|200106|CMSPRN|11|21|118|4241|0|4241|0|523|2258|1260|200|0|0.0387|0.0779|3641|0.0212|28|600|9|||
N|N0003|200106|CNA|11|21|8744|155244|0|154844|400|57125|83968|12351|1800|0|0.0374|0.0546|66722|0.0293|14|80492|10|8030|0.033|17
N|N0003|200106|CNL|11|21|14089|129633|100|129233|300|70295|48666|7529|3043|0|0.027|0.0612|53723|0.0363|14|69264|10|6546|0.0487|18
N|N0003|200106|CNN|11|21|712|4852|0|4852|0|2531|1646|200|475|0|0.0395|0.038|3087|0.0285|13|1765|48|||
N|N0003|200106|COE|11|21|607|5098|0|5098|0|1085|1178|1635|1200|0|0.0263|0.0358|1785|0.0243|33|3313|59|||
N|N0003|200106|COG|11|21|12708|131188|1478|129510|200|31708|55095|27764|14801|342|0.0097|0.0433|60097|0.0666|32|60933|24|8680|0.0682|51
N|N0003|200106|CPD|11|21|284|9634|0|9634|0|4435|3309|1640|250|0|0.0402|0.0417|7584|0.0444|18|2050|11|||
N|N0003|200106|CPP|11|21|73|3230|0|3230|0|900|1350|980|0|0|0.1574|0.1737|900|0.0567|28|2330|18|||
N|N0003|200106|CPRE|11|21|399|23321|0|23321|0|2550|15745|3669|1357|0|0.0703|0.0674|13212|0.0199|26|9709|18|400|0.1|41
N|N0003|200106|CPRF|11|21|13|1100|0|1100|0|0|900|0|200|0|0.1932|0.3159|250|0.48|23|850|28|||
N|N0003|200106|CPRG|11|21|25|1326|0|1326|0|0|764|562|0|0|0.3991|0.4987|664|0.1324|29|662|30|||
N|N0003|200106|CPRH|11|21|30|1320|0|1320|0|0|600|720|0|0|0.3235|0.422|920|0.1978|23|400|59|||
N|N0003|200106|CPRK|11|21|161|11084|0|11084|0|500|7692|2092|600|200|0.2122|0.2243|5553|0.0862|41|5131|29|400|0.165|32
N|N0003|200106|CPRM|11|21|28|2226|0|2226|0|339|960|727|200|0|0.3019|0.5577|1580|0.2241|29|446|18|200|0.25|38
N|N0003|200106|CPRN|11|21|269|11091|0|11091|0|2000|7226|1205|660|0|0.0681|0.0632|5145|0.0127|21|5946|26|||
N|N0003|200106|CPRQ|11|21|12|1200|0|1200|0|0|500|700|0|0|0.5|0.5625|400|0.05|31|600|21|200|0.1|22
N|N0003|200106|CPRR|11|21|10|500|0|500|0|0|300|0|200|0|0.502|0.602|300|0.03|26|200|72|||
N|N0003|200106|CPRU|11|21|26|3145|0|3145|0|200|1745|800|400|0|0.4211|0.5192|1470|0.0813|20|1675|47|||
N|N0003|200106|CPRW|11|21|748|54632|0|54632|0|10698|29850|9542|4142|400|0.0671|0.0715|24025|0.0144|27|30207|31|400|0.04|21
N|N0003|200106|CPRX|11|21|713|45053|400|44653|0|9460|26551|5112|3530|0|0.056|0.0603|19055|0.0159|31|25098|22|500|0.044|106
N|N0003|200106|CQPRA|11|21|333|19210|0|19210|0|5594|9166|3275|1175|0|0.1281|0.1641|10230|0.0347|18|8480|27|500|0.08|40
N|N0003|200106|CRM|11|21|86|1000|0|1000|0|0|300|0|700|0|0.132|-0.057|500|0.81|65|500|66|||
N|N0003|200106|CRY|11|21|7970|234595|3650|230145|500|98877|107261|19489|5018|0|-0.0028|0.1235|91095|0.097|16|107036|12|32514|0.1306|20
N|N0003|200106|CSL|11|21|12261|142404|860|141544|0|43960|64987|21866|10199|532|0.0098|0.0624|60868|0.0381|24|68088|17|12588|0.0475|27
N|N0003|200106|CSP|11|21|386|11788|0|11188|600|4305|5430|1114|939|0|0.0331|0.0379|3505|0.0229|13|8183|24|100|0.02|14
N|N0003|200106|CVC|11|21|14796|300546|2400|297846|0|124254|143338|23288|6966|0|-0.0109|0.0522|119404|0.0584|16|145555|12|32887|0.052|19
N|N0003|200106|CVD|11|21|10013|215338|1250|212285|1000|63619|102151|34471|13044|0|0.0155|0.0433|91877|0.0469|22|107181|19|14227|0.0438|27
N|N0003|200106|CW|11|21|748|11629|0|11629|0|1568|7271|1704|1086|0|-0.039|0.1445|5531|0.0981|29|5598|18|500|0.082|24
N|N0003|200106|CWN|11|21|4783|59776|200|59176|400|10708|28045|14206|6517|100|0.0301|0.0268|23025|0.035|36|35286|30|1265|0.0361|38
N|N0003|200106|CWNPRA|11|21|122|5460|0|5460|0|1280|2775|1105|300|0|0.0251|0.1623|2850|0.0813|21|2610|29|||
N|N0003|200106|CYE|11|21|1141|44347|0|44047|300|11950|16310|9270|6567|250|0.0261|0.029|15808|0.0208|39|28139|28|400|0.03|68
N|N0003|200106|D|11|21|58011|1219758|2220|1216438|1100|899099|288283|25052|5104|0|-0.0017|0.0547|587917|0.0449|8|463592|7|166029|0.0507|10
N|N0003|200106|DCP|11|21|2446|23882|0|23882|0|6845|13962|2650|425|0|0.5272|0.4252|14729|0.1923|19|9153|17|||
N|N0003|200106|DCS|11|21|1232|4646|100|4546|0|826|1934|886|900|0|0.0456|0.0374|646|0.0154|28|3900|39|||
N|N0003|200106|DDF|11|21|624|34631|104|34527|0|7804|18014|5335|3374|0|0.06|0.0619|12217|0.0453|22|21810|22|500|0.01|12
N|N0003|200106|DFG|11|21|5894|57038|0|57038|0|27051|22775|5339|1873|0|0.0073|0.0532|24654|0.036|18|28384|11|4000|0.0359|16
N|N0003|200106|DGX|11|21|30450|1005363|24875|978733|1100|406700|402320|118543|51365|905|-0.0253|0.1035|454631|0.1058|20|354981|15|170221|0.1344|24
N|N0003|200106|DHY|11|21|1351|15511|0|15511|0|3644|6401|3456|1868|142|0.0168|0.0212|5804|0.0202|39|9407|33|300|0.01|39
N|N0003|200106|DJM|11|21|67|830|0|830|0|400|430|0|0|0|0.1148|0.1004|430|0.01|22|400|4|||
N|N0003|200106|DLX|11|21|16578|281299|2671|278216|300|71701|103284|50590|50913|2028|0.0145|0.0344|101971|0.0331|40|151551|33|24994|0.05|48
N|N0003|200106|DNB|11|21|8423|207241|100|207141|0|97114|83577|20796|5654|0|0.0274|0.0423|106479|0.0315|16|90982|12|9680|0.0268|21
N|N0003|200106|DNR|11|21|6446|73429|101|72428|900|27435|35656|7906|2331|0|0.0198|0.0339|30182|0.0324|16|39174|15|3972|0.0371|19
N|N0003|200106|DNY|11|21|20761|380145|100|379832|0|216298|132793|19890|10851|0|0.013|0.0381|156676|0.0298|13|193479|12|29677|0.0313|15
N|N0003|200106|DPRA|11|21|684|35911|0|35911|0|16642|14590|3109|1570|0|0.0942|0.1137|13725|0.0222|17|20986|15|1200|0.0733|17
N|N0003|200106|DSU|11|21|2510|76624|280|76344|0|28055|28115|11749|8425|0|0.0227|0.0231|27021|0.0138|28|48009|27|1314|0.0163|34
N|N0003|200106|DT|11|21|57959|446775|1300|444775|700|253675|148003|35543|8254|0|0.0139|0.0166|202363|0.0184|12|202306|10|40806|0.0204|23
N|N0003|200106|DV|11|21|12130|149804|900|148704|200|53027|64825|19880|10136|1036|0.01|0.0764|65449|0.0428|22|72670|17|10785|0.0449|21
N|N0003|200106|EAS|11|21|10895|158503|600|157500|0|70724|51100|22068|13608|0|0.0203|0.0322|57187|0.035|26|94069|17|6244|0.0266|40
N|N0003|200106|ED|11|21|31154|765164|1625|760880|1700|269390|288368|128899|73604|4061|0.0023|0.0326|315254|0.0402|32|364869|20|82457|0.0417|45
N|N0003|200106|EDE|11|21|3768|54956|0|54856|100|22840|24852|6013|1251|100|0.0248|0.0399|26989|0.0521|15|25555|16|2412|0.0353|19
N|N0003|200106|EDEPRD|11|21|104|4917|0|4917|0|900|2790|1127|100|0|0.0789|0.0871|4417|0.1058|19|300|26|200|0.06|31
N|N0003|200106|EDL|11|21|416|24045|0|24045|0|4069|14154|4450|1372|0|0.0875|0.0953|4642|0.0249|30|17298|22|2105|0.0329|18
N|N0003|200106|EDO|11|21|6440|150405|2000|148405|0|48400|64713|22279|12513|500|0.0238|0.0571|72066|0.0717|23|66460|15|9879|0.0961|31
N|N0003|200106|EDPRA|11|21|86|3320|0|3320|0|500|1950|400|470|0|0.3342|0.8095|1820|0.7951|31|1200|27|300|0.4167|28
N|N0003|200106|EFL|11|21|172|4491|0|4491|0|1783|2333|275|100|0|0.1172|0.1064|3238|0.0392|14|1253|18|||
N|N0003|200106|ELN|11|21|39373|1698154|28233|1658521|9800|591927|749792|247952|77850|800|0.0024|0.0376|896938|0.0543|20|574910|16|196473|0.0643|24
N|N0003|200106|ELNWSA|11|21|6643|15924|0|15924|0|2530|8535|2849|2010|0|0.706|0.618|9810|0.2236|33|5214|14|900|0.1233|61
N|N0003|200106|ELNWSB|11|21|1507|3710|0|3710|0|950|1510|800|450|0|0.6193|1.0969|2100|0.5145|54|1410|12|200|0.79|20
N|N0003|200106|EMC|11|21|281430|9897171|68202|9782039|39300|3244345|4085888|1836849|651461|1701|0.006|0.0249|5060991|0.0472|22|2257708|15|2502640|0.0544|30
N|N0003|200106|EMD|11|21|134|3634|0|3634|0|200|2219|700|515|0|0.1069|0.0971|1119|0.0607|21|2515|31|||
N|N0003|200106|EPG|11|21|88656|3812438|35121|3757321|15900|1178720|1457845|694790|424248|17468|0.0012|0.0318|2175190|0.0565|26|985314|20|612717|0.0627|36
N|N0003|200106|EPGPR|11|21|7|589|0|589|0|0|0|100|489|0|0.8351|1.1746|489|0.234|91|100|142|||
N|N0003|200106|EPGPRC|11|21|3904|1800|0|1800|0|0|200|800|400|400|0.9539|1.6667|500|0.298|99|900|253|400|1.05|42
N|N0003|200106|EPI|11|21|470|33956|200|33756|0|10726|15906|5444|1680|0|0.0689|0.0843|13803|0.0236|22|19153|19|800|0.0238|21
N|N0003|200106|EPL|11|21|4429|76532|0|76232|300|31698|32628|8058|4148|0|0.0225|0.039|33547|0.0448|20|41085|15|1900|0.0384|30
N|N0003|200106|EPN|11|21|6829|207403|200|207003|200|67977|98548|24636|15492|550|0.015|0.0573|111443|0.0584|22|85320|22|10440|0.0449|39
N|N0003|200106|ESI|11|21|11026|263316|10079|252937|200|72537|103484|43898|32168|1050|-0.0044|0.0683|113865|0.0789|32|107821|21|31451|0.1062|56
N|N0003|200106|ETA|11|21|261|6305|0|6305|0|800|3730|1385|390|0|0.0416|0.0437|3350|0.023|24|2855|29|100|0.04|38
N|N0003|200106|EX|11|21|3998|36259|200|36059|0|11720|18552|4551|1236|0|0.0152|0.0391|16262|0.0377|21|18701|14|1096|0.0338|35
N|N0003|200106|FC|11|21|1581|7273|0|7273|0|2340|3733|1100|100|0|0.0509|0.0469|4128|0.0602|21|3045|11|100|0.02|14
N|N0003|200106|FCX|11|21|22496|477507|0|477007|500|224775|186859|45247|20626|0|0.0095|0.0182|200039|0.0292|19|251445|13|26023|0.0258|17
N|N0003|200106|FCXA|11|21|8050|43156|440|42716|0|15376|22763|3384|1049|144|0.0347|0.0382|23814|0.0421|19|17487|13|1415|0.0248|40
N|N0003|200106|FCXPRA|11|21|621|18015|0|18015|0|5645|7438|3682|1250|0|0.0671|0.0635|11571|0.0507|23|6444|22|||
N|N0003|200106|FCXPRB|11|21|433|14738|0|14738|0|3662|8961|1765|350|0|0.0779|0.1379|5695|0.0608|21|9043|19|||
N|N0003|200106|FCXPRC|11|21|285|4202|0|4202|0|0|2202|1700|300|0|0.0778|0.1058|1100|0.0409|35|3102|25|||
N|N0003|200106|FCXPRD|11|21|176|7878|0|7878|0|754|6474|650|0|0|0.0569|0.0839|4508|0.0431|17|3370|19|||
N|N0003|200106|FE|11|21|35393|852395|1200|849495|600|440011|305729|80238|22433|1684|0.0002|0.0259|297521|0.0334|15|484823|12|67751|0.0391|18
N|N0003|200106|FLR|11|21|30545|566592|10100|554892|1000|189895|244194|85222|36481|100|-0.0088|0.062|286010|0.0751|20|184057|16|85825|0.1055|33
N|N0003|200106|FMC|11|21|31359|300685|6100|294585|0|119860|125954|33675|15096|0|-0.0114|0.06|158560|0.0587|18|100317|17|35708|0.0695|31
N|N0003|200106|FO|11|21|20172|497417|300|496617|200|263838|184257|39171|9551|0|0.0121|0.0459|217394|0.0347|13|239890|11|39533|0.0497|21
N|N0003|200106|FOE|11|21|10534|125134|506|124228|0|44257|57903|16669|5399|0|0.005|0.0377|56458|0.0374|20|61161|16|6609|0.0451|19
N|N0003|200106|FOPRA|13|21|1|300|300|0|0|0|0|0|0|0|0|||||||||
N|N0003|200106|FOR|11|21|743|12184|0|12184|0|8401|3433|350|0|0|0.03|0.0292|7012|0.0142|10|5172|7|||
N|N0003|200106|FPCPRA|11|21|369|22202|0|22202|0|9105|6257|2976|3864|0|0.0873|0.1081|10106|0.0562|28|12096|34|||
N|N0003|200106|FRC|11|21|4092|47308|200|47108|0|11567|14565|9783|10893|300|0.0397|0.0645|16764|0.0702|53|24944|38|5400|0.1115|77
N|N0003|200106|FSH|11|21|8517|195393|1100|194093|200|78546|81804|23834|10409|0|-0.0134|0.0717|92235|0.068|22|89125|14|12933|0.0638|25
N|N0003|200106|FTI|11|21|4534|362127|100|361927|100|145638|148580|54179|13530|100|0.0288|0.0225|195780|0.0546|19|152912|17|13335|0.0439|26
N|N0003|200106|FWJ|11|21|58|900|0|900|0|0|900|0|0|0|0.1167|0.1167|300|0.1|18|600|20|||
N|N0003|200106|GBE|11|21|180|4475|0|4475|0|1148|1629|814|884|0|0.052|0.0771|2092|0.049|30|2083|24|300|0.05|49
N|N0003|200106|GCG|11|21|114|900|0|900|0|400|0|100|400|0|-0.0011|-0.0011|700|0.0443|57|200|0|||
N|N0003|200106|GDP|11|21|940|4550|0|4550|0|1660|2414|476|0|0|0.0751|0.0799|1889|0.0255|18|2261|11|400|0.015|11
N|N0003|200106|GGT|11|21|1980|24322|0|24322|0|9040|11256|3414|612|0|0.0735|0.0914|9010|0.0369|16|14434|18|878|0.0613|14
N|N0003|200106|GGTPR|11|21|70|2302|0|2302|0|400|1602|300|0|0|0.2183|0.2422|200|0.02|8|2102|16|||
N|N0003|200106|GID|11|21|19|600|0|600|0|100|300|200|0|0|0.0667|0.0133|600|0.05|28|||||
N|N0003|200106|GK|11|21|2191|17156|0|17156|0|1750|7742|4376|3062|226|-0.0365|0.0597|9137|0.0484|35|6619|55|1400|0.0421|52
N|N0003|200106|GLC|11|21|20315|310305|2700|306105|1100|88027|135891|55266|26942|1079|0.0057|0.0268|152886|0.0322|25|129221|21|25098|0.0498|30
N|N0003|200106|GLG|11|21|4130|51489|0|51089|400|30501|17462|3225|301|0|0.0271|0.0265|13063|0.0168|11|37509|11|917|0.0151|7
N|N0003|200106|GLH|11|21|4147|45051|0|45051|0|15566|21649|5843|1993|0|0.1176|0.143|14705|0.0661|23|28551|15|1795|0.0261|21
N|N0003|200106|GLW|11|21|156273|6854173|13360|6798713|38700|3855589|2284747|586994|109468|615|0.001|0.0136|3112503|0.0242|12|2413309|9|1311601|0.0273|18
N|N0003|200106|GPB|11|21|406|26231|0|26231|0|4691|15476|4364|1700|0|0.0888|0.0968|14042|0.057|21|11889|26|300|0.0167|53
N|N0003|200106|GPD|11|21|247|13433|0|13433|0|7588|5845|0|0|0|0.1493|0.1593|7865|0.0481|10|5268|10|300|0.1|9
N|N0003|200106|GPEPRA|11|21|315|17189|0|17189|0|7510|8831|848|0|0|0.1012|0.1118|10268|0.0573|13|6921|10|||
N|N0003|200106|GPEPRT|11|21|238|14799|400|14399|0|6781|6318|1100|200|0|0.0676|0.0711|6620|0.0196|18|7779|8|||
N|N0003|200106|GPEPRU|11|21|174|12589|0|12589|0|4059|8135|395|0|0|0.1495|0.1653|7537|0.0333|12|5052|11|||
N|N0003|200106|GPEPRV|11|21|151|7953|0|7953|0|1966|4966|1021|0|0|0.1438|0.1588|4145|0.0421|17|3508|19|300|0.0733|14
N|N0003|200106|GPF|11|21|206|5986|0|5986|0|1030|3571|925|460|0|0.1227|0.1622|1540|0.0802|23|4446|26|||
N|N0003|200106|GPU|11|21|19288|331935|1599|329136|500|179273|123240|20383|6540|200|0.0195|0.0418|164349|0.0434|12|136469|11|28818|0.0411|15
N|N0003|200106|GRA|11|21|2238|50998|0|50998|0|21532|22718|6164|584|0|0.0138|0.0143|18821|0.0151|17|31361|14|816|0.0202|6
N|N0003|200106|GRB|11|21|3283|27554|0|27554|0|5052|13374|6620|2508|0|0.0005|0.0295|12715|0.0593|26|13418|28|1421|0.0244|47
N|N0003|200106|GUPPRA|11|21|62|4554|0|4554|0|350|4204|0|0|0|0.0982|0.1284|2809|0.1062|13|1745|14|||
N|N0003|200106|GUPPRB|11|21|58|5484|0|5484|0|550|4584|350|0|0|0.159|0.1667|3784|0.0723|15|1700|11|||
N|N0003|200106|HAR|11|21|8880|148497|1800|146597|100|34515|73133|27304|11745|0|-0.0186|0.0552|68766|0.0854|26|67117|23|10814|0.1312|22
N|N0003|200106|HAS|11|21|14135|438982|100|437882|1000|174135|192970|53185|18592|0|0.0166|0.0301|246768|0.0269|17|172621|16|19493|0.0313|24
N|N0003|200106|HCN|11|21|8757|177141|0|175441|800|59204|72907|26587|16813|730|0.0226|0.034|81716|0.0317|27|85715|20|8810|0.0327|45
N|N0003|200106|HCNPRB|11|21|192|10125|0|10125|0|2217|4841|2284|783|0|0.0938|0.1173|6825|0.0796|25|2900|37|400|0.05|14
N|N0003|200106|HGR|11|21|512|7668|0|7668|0|2203|2650|1915|900|0|0.0445|0.0502|2915|0.0361|44|4653|19|100|0.02|8
N|N0003|200106|HIL|11|21|1329|12938|0|12938|0|3997|7419|1222|300|0|0.0276|0.0221|7891|0.0332|15|4547|15|500|0.026|18
N|N0003|200106|HIW|11|21|15084|201813|138|201675|0|124564|67892|7219|1700|300|0.0216|0.0302|92008|0.0319|10|101169|9|8498|0.0282|18
N|N0003|200106|HIWPRB|11|21|235|13382|0|13382|0|3770|8212|1000|400|0|0.1157|0.1308|9665|0.0841|16|3717|18|||
N|N0003|200106|HIWPRD|11|21|249|13883|0|13883|0|3676|7969|2238|0|0|0.1125|0.1521|8843|0.0724|17|4640|16|400|0.055|9
N|N0003|200106|HMA|11|21|21854|285451|0|284551|900|120298|111741|35184|17878|350|0.0064|0.0185|153353|0.0329|22|115598|15|16500|0.0365|33
N|N0003|200106|HMC|11|21|4170|61763|0|61763|0|23757|28584|7033|2389|0|0.1082|0.1751|29459|0.1755|21|28592|13|3712|0.0987|30
N|N0003|200106|HMT|11|21|18273|248392|300|245792|2300|101541|107186|25592|12063|1710|0.0127|0.0155|123922|0.0207|20|115408|14|8762|0.018|59
N|N0003|200106|HMTPRA|11|21|303|10915|0|10915|0|2225|7190|1100|400|0|0.0923|0.1225|4130|0.0509|12|6285|19|500|0.086|42
N|N0003|200106|HMTPRB|11|21|319|12320|0|12320|0|4705|5465|1700|450|0|0.0738|0.0985|7575|0.0284|16|4545|23|200|0.1|18
N|N0003|200106|HMTPRC|11|21|631|16685|0|16685|0|4440|10635|1280|330|0|0.0792|0.0897|7385|0.018|21|8900|13|400|0.05|7
N|N0003|200106|HON|11|21|150245|4537992|36160|4486970|11800|2162439|1652916|496192|184563|2660|-0.0203|0.0359|2222825|0.0602|16|1376974|12|898971|0.0831|26
N|N0003|200106|HOV|11|21|7214|107289|200|106689|300|46229|49915|7595|3250|0|0.0423|0.0621|47328|0.0482|16|52446|13|7215|0.0522|15
N|N0003|200106|HZO|11|21|1042|4175|0|4175|0|1240|2184|200|551|0|0.0338|0.039|1809|0.0585|30|2366|22|||
N|N0003|200106|ICS|11|21|130|1506|0|1506|0|0|1506|0|0|0|0.0529|0.0675|770|0.0113|10|736|16|||
N|N0003|200106|IDG|11|21|68|2461|0|2461|0|319|1494|648|0|0|0.0047|0.1105|1813|0.0317|11|||648|0.1|38
N|N0003|200106|IEU|11|21|80|4255|0|4255|0|255|3200|400|400|0|0.1078|0.2366|1555|0.0971|15|2700|36|||
N|N0003|200106|IFX|11|21|32247|155517|1600|152017|400|57220|65935|19363|9549|350|0.0046|0.1008|54177|0.0564|21|66889|15|31351|0.0759|27
N|N0003|200106|IGL|11|21|13602|187910|400|187210|300|46812|77036|38157|24596|909|0.01|0.0177|77292|0.0227|36|101416|23|8802|0.0292|38
N|N0003|200106|IML|11|21|1449|6306|0|6306|0|857|3090|1110|945|304|0.0974|0.1118|4214|0.0282|50|1335|44|757|0.0617|87
N|N0003|200106|IQM|11|21|301|9088|0|9088|0|3112|3224|1533|1219|0|0.032|0.0412|2795|0.0247|19|6163|27|130|0.02|15
N|N0003|200106|IR|11|21|43081|759241|2050|754499|2100|278603|313443|122486|41102|1380|0.0004|0.0277|384981|0.0303|20|301091|17|70527|0.0412|26
N|N0003|200106|ISP|11|21|2682|20875|0|20875|0|5474|11352|2541|1508|0|0.0352|0.0493|11155|0.0345|20|8420|19|1300|0.0331|33
N|N0003|200106|ITG|11|21|11690|235115|3900|231115|100|71405|116744|30416|12650|0|-0.0315|0.0835|110607|0.0695|22|102156|15|18452|0.1072|32
N|N0003|200106|ITN|11|21|4918|78922|429|78493|0|38979|31129|6358|2027|0|0.0211|0.0448|27960|0.0329|13|45177|12|5356|0.037|20
N|N0003|200106|ITT|11|21|25796|286838|300|285930|500|109564|148979|23443|4444|0|0.0162|0.0516|134635|0.0453|15|131715|12|20080|0.0523|18
N|N0003|200106|ITX|11|21|2903|16878|200|16678|0|3675|9192|2450|1361|0|0.0283|0.0615|5862|0.039|25|7799|16|3017|0.0462|32
N|N0003|200106|ITXPR|11|21|32|1738|0|1738|0|199|729|450|360|0|0.2329|0.3264|888|0.2684|41|700|45|150|0.5|10
N|N0003|200106|IVC|11|21|7236|109326|0|109042|0|56256|39484|9774|3528|0|0.0119|0.0595|52292|0.0707|14|49763|14|6987|0.0589|23
N|N0003|200106|JBL|11|21|65286|2021224|38650|1976374|5600|828342|716374|280748|152377|4133|-0.0168|0.0406|978092|0.0497|20|664172|15|339710|0.0735|35
N|N0003|200106|JCP|11|21|32339|923275|3200|917192|2600|476919|354391|69553|17871|1058|0.0032|0.027|417906|0.0348|15|412601|11|89285|0.0462|17
N|N0003|200106|JEM|11|21|164|3691|0|3691|0|2595|846|250|0|0|0.0709|0.0709|650|0.0162|17|3041|8|||
N|N0003|200106|JOE|11|21|6413|109132|100|108932|100|37049|49203|13005|9415|360|0.0362|0.0545|30081|0.028|28|72812|20|6139|0.0361|55
N|N0003|200106|JYPPRZ|11|21|477|8294|0|8294|0|3987|2853|1454|0|0|0.075|0.0813|2801|0.0214|12|5093|17|400|0.055|13
N|N0003|200106|KBH|11|21|24625|396444|1900|393544|700|235578|135787|19031|3612|236|0.0173|0.052|158530|0.0436|12|201018|9|34696|0.062|18
N|N0003|200106|KBHPRG|12|23|94|4000|3800|200|0|0|200|0|0|0|-0.2|0.25||||200|18|||
N|N0003|200106|KBHPRI|11|21|481|1870|0|1870|0|670|1200|0|0|0|0.0917|0.1165|600|0.0233|10|1270|11|||
N|N0003|200106|KEG|11|21|13540|219955|1787|218168|0|79979|96492|29441|11905|351|0.0066|0.0309|96876|0.0251|21|100725|18|20567|0.0376|30
N|N0003|200106|KEI|11|21|9379|304821|3399|301422|0|107761|129096|42537|22028|0|-0.0197|0.0795|140598|0.0738|21|117736|18|43088|0.0839|31
N|N0003|200106|KG|11|21|38805|1031366|8400|1021866|1100|454412|432306|107139|28667|442|-0.0191|0.0377|522352|0.0555|16|392279|13|108335|0.069|18
N|N0003|200106|KLU|11|21|1499|33466|0|33466|0|12755|16840|3321|550|0|0.0379|0.052|13916|0.0403|14|18540|14|1010|0.01|16
N|N0003|200106|KMB|11|21|60627|2164410|4955|2150133|7000|686439|883329|387441|193491|6433|-0.0002|0.0322|1162179|0.0422|24|704899|21|290055|0.0583|29
N|N0003|200106|KOR|11|21|1063|5566|0|5566|0|1145|2746|600|1075|0|0.0353|0.0425|3656|0.0338|26|1910|33|||
N|N0003|200106|KPA|11|21|4799|63086|0|62586|500|27584|24830|7518|3154|0|0.0283|0.0301|18392|0.0203|18|41710|16|2984|0.0191|24
N|N0003|200106|KPAPRA|11|21|338|8841|0|8841|0|2025|3910|800|2106|0|0.1962|0.2095|2760|0.056|50|5456|28|625|0.1156|16
N|N0003|200106|KRJ|11|21|36|1150|0|1150|0|300|850|0|0|0|0.0652|0.113|600|0.0833|18|550|14|||
N|N0003|200106|KTB|11|21|98|6825|0|6825|0|1200|3975|850|800|0|0.0992|0.1024|4475|0.0597|29|2350|20|||
N|N0003|200106|KTP|11|21|644|29875|0|29875|0|11654|14076|3720|425|0|0.026|0.1111|13092|0.0381|17|15603|15|1180|0.0632|17
N|N0003|200106|KYO|11|21|6006|90772|0|90472|300|44067|39611|5763|1331|0|0.2892|0.3294|39291|0.1462|13|44089|12|7392|0.1991|15
N|N0003|200106|LBI|11|21|172|1540|0|1540|0|200|1090|250|0|0|0.0072|0.0645|713|0.121|22|827|15|||
N|N0003|200106|LDP|11|21|2070|16330|0|16330|0|4713|7895|1543|2179|0|0.0597|0.0814|6311|0.0355|21|9254|26|765|0.0413|41
N|N0003|200106|LMM|11|21|64|1340|0|1340|0|400|450|490|0|0|0.0192|0.0192|210|0.0257|18|1130|27|||
N|N0003|200106|LMS|11|21|2098|8949|0|8949|0|1605|5269|1025|1050|0|-0.0062|0.0789|5069|0.0544|32|3770|16|110|0.02|12
N|N0003|200106|LMT|11|21|42535|1539221|2321|1534598|1500|813099|498258|155630|68871|240|0.0089|0.038|652816|0.0387|18|731392|12|151890|0.0449|19
N|N0003|200106|LNT|11|21|11841|241025|0|240325|700|74986|120488|33823|11428|300|0.0151|0.0345|72301|0.0345|18|155939|17|12785|0.0238|23
N|N0003|200106|LRY|11|21|10872|157798|0|156898|900|63418|75594|14717|4069|0|0.0192|0.0361|80555|0.0294|15|73460|14|3783|0.0312|21
N|N0003|200106|LRYPRA|11|21|481|11239|0|11239|0|5040|5074|675|450|0|0.1234|0.1347|2244|0.0408|19|8795|14|200|0.05|24
N|N0003|200106|LSHPRA|11|21|370|8884|0|8884|0|1777|4625|1100|1382|0|0.0941|0.1001|4602|0.0332|34|4282|29|||
N|N0003|200106|MAG|11|21|3094|40664|100|40564|0|11519|19271|7942|1832|0|0.0271|0.034|18625|0.0561|21|21026|17|913|0.0264|46
N|N0003|200106|MAR|11|21|36100|852217|3439|847777|500|327186|338792|115285|64394|2620|-0.0021|0.0336|371175|0.0377|23|376069|17|101033|0.0395|25
N|N0003|200106|MAT|11|21|38265|1269034|600|1265555|2400|804303|370087|74517|19048|0|0.017|0.0286|536799|0.0232|12|603833|9|127323|0.0268|17
N|N0003|200106|MCC|11|21|1017|15602|100|15502|0|3391|5930|2640|3441|100|0.0695|0.1551|10231|0.1351|48|3496|48|1775|0.1344|50
N|N0003|200106|MCO|11|21|19298|482050|300|481050|0|205260|224512|38524|12754|0|0.0064|0.0344|232157|0.0449|16|218413|12|30480|0.0506|21
N|N0003|200106|MCT|11|21|2214|18905|300|18605|0|6170|8860|2500|1175|0|0.1805|0.2168|10070|0.0931|22|7035|21|1500|0.0993|18
N|N0003|200106|MDG|11|21|13082|44774|100|44574|100|18941|16881|6899|1953|0|0.0197|0.0379|17024|0.0225|15|23758|15|3892|0.029|43
N|N0003|200106|MEE|11|21|16499|209709|1746|206463|1500|66383|99319|28763|13498|0|0.0036|0.0405|111328|0.0591|22|81354|18|15281|0.0622|27
N|N0003|200106|MEH|11|21|3317|48319|0|48319|0|14334|23793|6423|3769|0|0.0076|0.0701|17902|0.0429|26|24568|19|5849|0.046|31
N|N0003|200106|MER|11|21|178402|6760165|79577|6655420|22100|3730194|2256343|498914|187021|5048|0.0048|0.0551|3050308|0.0476|13|1925818|9|1701394|0.066|19
N|N0003|200106|MERPRA|11|21|180|19057|0|19057|0|7062|8478|2817|700|0|0.0955|0.101|10546|0.0317|22|8411|15|100|0.02|24
N|N0003|200106|MERPRB|11|21|309|20512|0|20512|0|6773|11414|1925|400|0|0.0952|0.0985|12232|0.0367|16|7980|17|300|0.01|11
N|N0003|200106|MERPRC|11|21|244|18441|0|18441|0|4795|11057|1582|1007|0|0.1116|0.1103|11160|0.0386|24|7181|16|100|0.07|17
N|N0003|200106|MERPRD|11|21|792|50455|0|50455|0|18698|26565|3992|1200|0|0.0661|0.0677|28689|0.0208|17|21266|15|500|0.026|20
N|N0003|200106|MERPRE|11|21|398|24866|0|24866|0|7807|13364|1525|2170|0|0.0603|0.0673|17369|0.0194|23|7497|26|||
N|N0003|200106|MERPRF|11|21|850|64465|0|64465|0|22971|30739|8030|2725|0|0.0545|0.0566|35833|0.0187|19|27832|19|800|0.025|12
N|N0003|200106|MFW|11|21|486|7466|0|7466|0|2841|4113|512|0|0|0.0188|0.0181|2029|0.0623|12|5437|14|||
N|N0003|200106|MGF|11|21|829|16120|0|16120|0|6543|8899|500|178|0|0.0194|0.0166|3887|0.0103|17|12233|12|||
N|N0003|200106|MHN|11|21|517|10018|0|10018|0|5361|3632|1025|0|0|0.0233|0.0315|3926|0.014|17|5792|10|300|0.0133|16
N|N0003|200106|MIM|11|21|144|1347|0|1347|0|275|672|200|200|0|0.0974|0.1074|140|0.13|24|1207|26|||
N|N0003|200106|MLI|11|21|5950|69963|100|69763|100|19462|27043|13949|9309|100|0.0019|0.0273|31833|0.0706|30|34350|30|3680|0.0433|50
N|N0003|200106|MLM|11|21|13762|204799|300|204099|400|61064|95095|32619|15821|300|0.0101|0.0477|80241|0.0608|24|108917|20|15341|0.0475|23
N|N0003|200106|MLS|11|21|7694|206055|0|205855|200|74780|98864|22395|10016|0|0.0448|0.065|79217|0.0297|20|113979|14|12859|0.0332|28
N|N0003|200106|MMA|11|21|1082|41547|0|41347|200|6120|18982|11510|4935|0|0.0685|0.0759|18868|0.0622|31|22479|28|200|0.01|42
N|N0003|200106|MMC|11|21|67016|1504024|4800|1496324|2400|848935|524310|93936|31240|303|-0.0049|0.0776|737970|0.0635|14|537240|9|223514|0.0759|16
N|N0003|200106|MMR|11|21|2396|24452|0|24452|0|4408|14201|3524|2319|0|0.0558|0.0584|10071|0.0532|24|13468|26|913|0.0605|21
N|N0003|200106|MMS|11|21|7706|318955|1900|315905|900|106853|137298|48809|23545|300|0.0373|0.0495|180240|0.06|24|113201|20|23364|0.0565|33
N|N0003|200106|MOT|11|21|113979|3328170|5844|3311576|8100|1598352|1234943|389062|96669|650|0.0033|0.0107|1631510|0.0236|17|1229766|10|458400|0.0247|21
N|N0003|200106|MOTPRA|11|21|915|54690|0|54690|0|19492|24106|8167|2925|0|0.0856|0.0898|30541|0.0284|23|23749|17|400|0.025|16
N|N0003|200106|MPPRD|11|21|54|1975|0|1975|0|300|775|900|0|0|0.1489|0.2923|1600|0.04|28|375|14|||
N|N0003|200106|MRX|11|21|10826|320344|8637|310782|200|63174|159322|56740|29946|1800|-0.0397|0.0942|133022|0.0768|30|134927|24|43033|0.1141|30
N|N0003|200106|MSF|11|21|437|9509|0|9509|0|2112|6131|766|200|300|0.0557|0.0626|3761|0.0423|15|5748|16|||
N|N0003|200106|MTN|11|21|2686|22165|0|21965|200|4845|12736|2407|2177|0|0.0748|0.0896|11127|0.0907|28|10716|22|322|0.1|10
N|N0003|200106|MTTPRX|11|21|123|5969|0|5969|0|850|4879|240|0|0|0.1796|0.1935|3074|0.1643|18|2895|13|||
N|N0003|200106|MTX|11|21|10819|141623|0|140313|0|59229|61833|11244|8007|0|-0.0148|0.062|55775|0.0467|18|74506|17|10032|0.0553|28
N|N0003|200106|MUC|11|21|867|9273|0|9273|0|3762|3999|400|1112|0|0.0208|0.0279|5611|0.0146|17|3262|42|400|0.01|6
N|N0003|200106|MUJ|11|21|422|8266|0|8266|0|3118|4948|200|0|0|0.0242|0.0292|4991|0.0126|15|3275|10|||
N|N0003|200106|MUO|11|21|916|10408|0|10408|0|2493|6074|1116|725|0|0.0495|0.0519|3863|0.0223|24|6345|13|200|0.06|140
N|N0003|200106|MYI|11|21|1262|32319|0|32319|0|11642|14632|3472|2373|200|0.0321|0.0318|11728|0.0141|29|20291|17|300|0.01|18
N|N0003|200106|NAV|11|21|20231|207641|200|206594|300|100039|87977|14008|4870|0|-0.0035|0.0271|94076|0.027|14|101550|12|11268|0.0438|17
N|N0003|200106|NC|11|21|5222|70933|0|70933|0|24172|40012|5599|1150|0|0.0198|0.1476|27278|0.0952|18|37888|11|5767|0.0974|18
N|N0003|200106|NCI|11|21|4804|36300|0|36300|0|12555|13153|5331|4291|970|0.0303|0.0448|13065|0.0375|23|21642|25|1593|0.0567|119
N|N0003|200106|NDE|11|21|13717|252703|3500|248903|200|62581|105339|52043|27991|1149|0.0116|0.0427|103869|0.041|28|124648|23|20586|0.0692|57
N|N0003|200106|NEU|11|21|20914|434722|5500|427622|500|148279|190275|58105|31463|0|-0.019|0.0733|193603|0.0723|25|172307|15|62212|0.0672|31
N|N0003|200106|NMA|11|21|390|13504|0|13504|0|2868|6470|2799|1367|0|0.0282|0.033|1804|0.0319|18|11350|29|350|0.01|41
N|N0003|200106|NMI|11|21|277|5888|0|5888|0|2227|2881|580|200|0|0.064|0.0667|4313|0.0145|18|1575|13|||
N|N0003|200106|NMK|11|21|8588|308307|100|307707|400|114811|128594|41825|22677|200|0.0157|0.0191|97748|0.016|23|190283|18|20076|0.0143|28
N|N0003|200106|NMKPRK|11|21|12|100|0|100|0|100|0|0|0|0|0.75|0.75||||100|9|||
N|N0003|200106|NMT|11|21|209|5072|0|5072|0|507|4032|133|400|0|0.0567|0.0602|2876|0.023|19|2196|23|||
N|N0003|200106|NPC|11|21|179|2425|0|2425|0|798|1627|0|0|0|0.0346|0.0694|927|0.0578|14|1498|14|||
N|N0003|200106|NPV|11|21|314|8346|0|8346|0|2790|3706|1850|0|0|0.0819|0.0865|4223|0.0241|20|3823|17|300|0.01|13
N|N0003|200106|NQF|11|21|282|8197|0|8197|0|3319|3533|1145|0|200|0.0463|0.0506|4778|0.0118|32|3419|10|||
N|N0003|200106|NQS|11|21|408|13224|0|13224|0|3268|6571|3385|0|0|0.0347|0.0344|3655|0.0223|23|9235|17|334|0.04|32
N|N0003|200106|NSH|11|21|858|6351|0|6351|0|1216|4108|927|100|0|0.0297|0.0711|3151|0.0624|19|3200|18|||
N|N0003|200106|NSI|11|21|19979|206016|700|204916|400|81854|88750|26478|8134|100|0.0272|0.053|78530|0.0423|19|115118|14|11668|0.0455|29
N|N0003|200106|NTC|11|21|242|7856|0|7856|0|2683|4673|500|0|0|0.0712|0.0692|5213|0.0129|16|2643|12|||
N|N0003|200106|NUT|11|21|322|5170|0|5170|0|713|3916|541|0|0|0.0622|0.0767|3509|0.0365|19|1548|11|113|0.05|9
N|N0003|200106|NVN|11|21|612|17595|0|17595|0|3541|10820|1951|1283|0|0.0499|0.0528|6675|0.015|21|10105|23|815|0.0316|14
N|N0003|200106|OAT|11|21|34776|570965|4200|565465|1300|270878|204505|62275|28792|315|-0.0035|0.0499|293935|0.0578|17|213478|13|59352|0.0588|21
N|N0003|200106|OCN|11|21|3472|44482|122|44160|200|11948|15964|8555|7893|0|0.0258|0.0487|16847|0.0378|38|24518|33|2995|0.0362|41
N|N0003|200106|OECPRT|11|21|124|8598|0|8598|0|5028|2770|600|200|0|0.3548|0.3758|5885|0.0151|16|2713|9|||
N|N0003|200106|OFC|11|21|3280|44336|0|44336|0|7456|16953|9168|10759|0|0.0255|0.0313|17630|0.0546|51|22481|36|4225|0.0178|24
N|N0003|200106|OFCPRB|11|21|252|4268|0|4268|0|240|1775|1155|700|398|0.0107|0.0926|2050|0.1197|37|2118|122|100|0.05|65
N|N0003|200106|OFCPRE|11|21|161|4805|0|4805|0|700|1725|1130|1150|100|0.1199|0.1068|2310|0.0747|57|2195|46|300|0.03|11
N|N0003|200106|OH|11|21|1273|34617|140|34377|100|9919|17741|4045|2772|0|0.0228|0.0328|14906|0.0318|32|19248|18|323|0.0286|89
N|N0003|200106|OI|11|21|7970|74739|0|74739|0|33123|30579|7601|3436|0|0.0189|0.0219|24529|0.0238|16|47287|16|2923|0.0227|21
N|N0003|200106|OIPRA|11|21|440|16193|100|16093|0|2270|6602|2439|4282|500|0.0701|0.1128|7247|0.0299|73|7547|45|1299|0.0585|54
N|N0003|200106|OMG|11|21|9728|189051|1000|186551|0|54715|91492|27624|12720|0|-0.0421|0.0607|70167|0.0623|23|97105|18|19279|0.0554|29
N|N0003|200106|OMI|11|21|6928|107087|500|106087|300|26099|48534|18229|13525|0|0.0089|0.0552|41150|0.0578|29|56474|24|8763|0.0579|42
N|N0003|200106|ONE|11|21|88089|2557497|1921|2549239|4900|1590050|761410|159619|42657|403|0.0085|0.0277|1132248|0.0266|12|1085876|9|336015|0.0315|15
N|N0003|200106|ONEPRB|11|21|11|400|0|400|0|0|200|0|200|0|1.4375|2.3875|200|0.55|91|200|18|||
N|N0003|200106|ONEPRC|11|21|1|100|0|100|0|0|0|0|100|0|1.5|2|100|1|83|||||
N|N0003|200106|ONEPRT|11|21|498|29362|0|29362|0|13993|11061|3728|580|0|0.074|0.0822|11554|0.0415|15|16908|15|900|0.0289|13
N|N0003|200106|ONEPRU|11|21|385|17827|0|17827|0|6895|7268|3264|400|0|0.0987|0.1008|7272|0.0373|19|10355|15|200|0.05|22
N|N0003|200106|ONEPRV|11|21|563|23722|0|23722|0|10722|12220|400|380|0|0.0926|0.0884|13172|0.031|12|9650|13|900|0.0311|19
N|N0003|200106|OSI|11|21|12400|248089|2075|245714|300|63505|109163|44599|28147|600|0.0081|0.0554|102160|0.0585|31|123370|21|20484|0.0677|33
N|N0003|200106|OTL|11|21|3455|33973|0|33973|0|8320|18238|7115|300|0|0.0312|0.1038|11952|0.0549|18|17721|15|4300|0.2072|34
N|N0003|200106|OWC|11|21|3728|97564|400|97164|0|51956|36885|6365|1958|0|0.02|0.0286|25059|0.0166|13|64887|11|7218|0.0214|26
N|N0003|200106|PAG|11|21|1891|38597|0|38597|0|14405|16254|5316|2622|0|0.0254|0.0262|13760|0.0177|24|24337|16|500|0.016|16
N|N0003|200106|PAR|11|21|440|8752|0|8752|0|2836|4398|1118|400|0|0.0426|0.0644|3723|0.049|17|4629|33|400|0.0425|17
N|N0003|200106|PAS|11|21|12059|116739|596|115743|0|32186|50278|20265|12755|259|0.017|0.0361|55329|0.0333|31|57869|26|2545|0.0876|29
N|N0003|200106|PCEPR|11|21|433|7237|0|7237|0|1438|3578|1621|600|0|0.1028|0.1203|2378|0.0377|23|4459|27|400|0.0825|15
N|N0003|200106|PCEPRA|11|21|404|19235|0|19235|0|4495|7684|3786|3070|200|0.1077|0.1339|6197|0.0854|34|12438|40|600|0.0767|103
N|N0003|200106|PCL|11|21|7219|207041|0|205966|800|82550|84819|26006|12302|1289|0.0254|0.0518|79822|0.0285|32|112427|17|14517|0.0474|59
N|N0003|200106|PCT|11|21|370|10980|0|10980|0|1755|5233|2274|1718|0|0.0865|0.1086|4575|0.0492|32|6405|31|||
N|N0003|200106|PDE|11|21|40611|311176|2700|307576|900|153759|109523|33382|11412|400|0.0022|0.0241|146622|0.0338|16|130255|11|31599|0.0309|23
N|N0003|200106|PECPRX|11|21|116|9116|0|9116|0|3045|5421|650|0|0|0.2263|0.253|6766|0.2323|14|2250|16|100|0.2|13
N|N0003|200106|PEP|11|21|84694|3961781|3610|3935924|19800|1877493|1559852|407217|111162|0|0.0043|0.0169|2074843|0.0276|16|1458336|12|422545|0.0302|20
N|N0003|200106|PER|11|21|9104|147898|1311|146587|0|54071|50664|20863|20325|664|0.0339|0.0494|60502|0.0331|30|70966|23|15119|0.0414|37
N|N0003|200106|PFP|11|21|67|4346|0|4346|0|611|3014|223|498|0|0.1608|0.2408|2737|0.1043|23|1609|22|||
N|N0003|200106|PFPPR|11|21|78|1998|0|1998|0|456|1542|0|0|0|0.2503|0.3709|1060|0.1181|14|938|3|||
N|N0003|200106|PG|11|21|93171|3286058|7562|3265296|10900|1994720|980155|234132|65839|1200|0.0104|0.0383|1509114|0.0338|12|1185301|9|581781|0.0453|20
N|N0003|200106|PGF|11|21|159|3127|0|3127|0|400|2227|500|0|0|0.0715|0.1322|200|0.1|37|2927|16|||
N|N0003|200106|PGN|11|21|34344|803192|1050|800855|1100|395029|308406|70143|26814|1563|0.0002|0.0442|356946|0.0318|16|362495|12|82514|0.0394|21
N|N0003|200106|PHA|11|21|78871|2625800|5054|2615898|2300|1194257|945635|349082|129224|0|0.0004|0.0269|1208326|0.0303|19|1030728|13|379144|0.0395|26
N|N0003|200106|PII|11|21|6231|102532|100|102432|0|41394|47177|10024|3837|0|-0.0108|0.0656|43817|0.0617|19|50009|14|8606|0.067|21
N|N0003|200106|PIK|11|21|798|3575|0|3575|0|200|1904|349|1122|0|0.0443|0.048|2316|0.061|22|1092|112|167|0.02|177
N|N0003|200106|PIM|11|21|2066|49075|0|49075|0|24946|18678|4419|1032|0|0.021|0.0231|15250|0.0101|15|31123|13|2702|0.0172|21
N|N0003|200106|PIO|11|21|1431|20834|0|20834|0|4049|12496|3547|742|0|0.2372|0.1999|15381|0.3664|19|5353|24|100|0.03|57
N|N0003|200106|PKE|11|21|6898|119484|100|119384|0|37310|62636|13909|5529|0|-0.0061|0.0536|51032|0.0518|20|59311|16|9041|0.0835|42
N|N0003|200106|PKG|11|21|6978|146975|435|146340|200|34426|54415|28787|26474|2438|0.0148|0.0363|71171|0.0341|45|66334|34|9035|0.0866|51
N|N0003|200106|PKX|11|21|9086|142771|0|142226|200|41939|72365|20160|7962|0|0.013|0.0222|67854|0.0374|22|71279|18|3293|0.0316|36
N|N0003|200106|PLP|11|21|345|20783|0|20783|0|6623|11908|1872|380|0|0.0666|0.0736|9234|0.0405|19|9569|14|1980|0.048|16
N|N0003|200106|PNP|11|21|5806|77419|0|77419|0|21873|46990|6414|2142|0|0.0365|0.0584|39478|0.0455|17|35119|13|2822|0.0368|27
N|N0003|200106|PNW|11|21|23869|470049|2100|467443|400|193183|212965|42984|18311|400|-0.0151|0.0449|244484|0.0442|17|188356|15|35003|0.0463|22
N|N0003|200106|PPD|11|21|7092|203099|1025|199574|2500|50324|81817|41329|28104|500|0.0156|0.0512|76073|0.06|40|105458|21|20543|0.056|41
N|N0003|200106|PPP|11|21|18017|218104|600|217504|0|90001|84657|30380|12466|0|-0.0018|0.0533|86443|0.0541|21|107964|17|23097|0.0719|22
N|N0003|200106|PPPPRQ|11|21|1571|1220|0|1220|0|0|340|750|130|0|1.2195|1.2508|400|0.461|62|820|29|||
N|N0003|200106|PTV|11|21|16802|421537|524|420713|300|130636|203286|64391|22600|100|0.0084|0.0255|219254|0.0309|20|179782|19|21977|0.0307|20
N|N0003|200106|PX|11|21|41791|968093|4342|962551|400|391045|431840|105022|34611|433|0.0036|0.0323|517464|0.0384|17|360536|15|84951|0.0418|20
N|N0003|200106|RCL|11|21|12717|192609|1279|191130|200|73260|79569|27645|10856|0|0.01|0.0309|71595|0.0366|23|106888|15|12847|0.0291|21
N|N0003|200106|RCN|11|21|11082|26769|0|26769|0|7428|11535|3395|4411|0|0.0761|0.13|9038|0.0576|40|14081|20|3650|0.0453|33
N|N0003|200106|RG|11|21|25884|70949|0|70949|0|19784|28138|8150|13587|1290|0.0487|0.0507|16009|0.0463|71|42135|29|12805|0.0254|64
N|N0003|200106|RHB|11|21|7339|256151|6400|249751|0|54702|103946|53430|37673|0|0.0063|0.1091|117310|0.0835|36|102790|26|29651|0.1028|46
N|N0003|200106|RHD|11|21|7812|166190|100|165990|0|55871|81814|20848|7457|0|0.0146|0.0431|76146|0.0406|19|82195|17|7649|0.0406|25
N|N0003|200106|RHI|11|21|19904|438400|1243|436357|800|200230|165695|49195|21787|250|0.0035|0.0378|212536|0.0402|18|187120|13|37501|0.0493|32
N|N0003|200106|RJF|11|21|10562|179628|1970|177558|100|59606|69661|26503|21888|0|0.0153|0.0605|84064|0.0491|26|80046|18|13548|0.063|43
N|N0003|200106|RL|11|21|11111|188977|400|187027|1200|51875|75446|38251|22355|300|0.0187|0.0584|80017|0.0683|29|84714|25|23496|0.0661|31
N|N0003|200106|RMG|11|21|2931|76807|0|76807|0|31060|36138|8459|1150|0|0.0365|0.0786|40447|0.0656|14|32940|14|3420|0.0411|29
N|N0003|200106|RML|11|21|7338|65767|851|64916|0|15388|24785|9913|14430|400|0.0185|0.0323|25040|0.0345|54|36262|32|3614|0.036|68
N|N0003|200106|RNS|11|21|46|3105|0|3105|0|1535|1370|200|0|0|-0.0113|0.1214|2105|0.1211|11|1000|14|||
N|N0003|200106|ROP|11|21|6433|119636|1400|118236|0|31245|46507|21949|17566|969|-0.0259|0.0654|52276|0.0767|37|54041|26|11919|0.076|60
N|N0003|200106|ROS|11|21|1578|8810|0|8810|0|5900|2210|500|200|0|0.0236|0.0264|4960|0.0191|11|3850|15|||
N|N0003|200106|ROV|11|21|8870|280099|300|278999|800|121057|99650|39115|18932|1045|0.0341|0.0251|165982|0.0469|20|98628|16|15189|0.0513|69
N|N0003|200106|RS|11|21|4283|74715|300|74415|0|17112|35972|16048|5283|0|0.0392|0.0486|37850|0.0445|24|31898|21|4667|0.0411|26
N|N0003|200106|RSC|11|21|1537|35415|0|35415|0|8219|17055|6911|3230|0|0.0579|0.1382|19992|0.0862|25|13593|24|1830|0.1025|40
N|N0003|200106|RTP|11|21|2903|45752|200|45552|0|14891|21771|6917|1973|0|0.0728|0.4891|17391|0.1724|22|23561|14|4600|0.5028|31
N|N0003|200106|RWT|11|21|3971|52267|0|52267|0|18388|19210|10069|4600|0|0.0662|0.0721|25393|0.0563|23|24774|18|2100|0.0438|14
N|N0003|200106|RWTPRB|11|21|53|1638|0|1638|0|100|1288|100|150|0|-0.0472|0.0114|1239|0.599|39|399|13|||
N|N0003|200106|RYN|11|21|12725|128546|700|127446|0|34511|58160|23802|10373|600|0.0047|0.0552|52145|0.0532|29|64697|21|10604|0.0443|37
N|N0003|200106|RZT|11|21|4256|44179|0|44079|100|16442|21497|5031|1209|0|-0.0017|0.0511|18311|0.046|16|23659|13|2209|0.09|34
N|N0003|200106|SACPR|11|21|9|700|0|700|0|0|0|200|500|0|0.5386|1.1014||||700|86|||
N|N0003|200106|SACPRT|11|21|120|2493|0|2493|0|320|1463|300|410|0|0.1159|0.2151|413|0.1299|17|1980|41|100|0.1|16
N|N0003|200106|SAIPRW|11|21|247|17471|0|17471|0|9608|6338|1125|400|0|0.0927|0.0907|5971|0.0183|14|11400|15|100|0.03|7
N|N0003|200106|SBG|11|21|812|23981|0|23981|0|9947|6542|3638|3554|300|0.0214|0.0256|12268|0.0161|38|11713|39|||
N|N0003|200106|SC|11|21|18899|171378|1200|169328|600|35189|66402|34353|32589|1295|0.0253|0.0425|67572|0.0423|115|82345|33|20011|0.0432|74
N|N0003|200106|SCG|11|21|13208|174445|1450|172995|0|36451|63067|41038|31401|1038|0.0215|0.0434|73380|0.0352|39|85091|31|14524|0.0479|57
N|N0003|200106|SCL|11|21|401|4080|0|4080|0|797|977|1156|1007|143|0.0229|0.1141|1361|0.0648|33|2719|95|||
N|N0003|200106|SCX|11|21|191|5156|0|5156|0|1378|1806|500|1472|0|0.0984|0.1732|871|0.1332|41|4185|42|100|0.14|18
N|N0003|200106|SCZ|11|21|7318|93540|0|93440|100|37105|43330|8965|4140|0|0.0186|0.0246|42050|0.032|19|49810|15|1680|0.0214|19
N|N0003|200106|SCZA|12|21|38|1667|270|1397|0|450|430|200|317|0|-3.8031|6.7545|317|1|165|1080|17|||
N|N0003|200106|SDH|11|21|1601|41816|0|41816|0|18699|18351|3596|1170|0|0.0156|0.0167|12656|0.0124|16|28810|12|350|0.0243|60
N|N0003|200106|SGH|11|21|993|6168|0|6168|0|1085|2758|1200|1125|0|0.1017|0.1265|2783|0.0408|37|3000|41|385|0.033|9
N|N0003|200106|SGI|11|21|5965|72667|350|72017|300|24900|32188|9337|5892|0|0.0092|0.013|22488|0.0123|20|46559|19|3270|0.0143|58
N|N0003|200106|SGR|11|21|30681|1299132|35974|1259458|2700|574617|455207|144340|85394|2700|-0.0187|0.0949|654440|0.1078|20|422851|13|184867|0.1534|37
N|N0003|200106|SGU|11|21|1830|102190|475|101715|0|24400|44647|16278|15490|900|0.0525|0.0787|50870|0.0602|40|46623|28|4222|0.0301|56
N|N0003|200106|SII|11|21|79396|2461601|89352|2366784|2800|708230|989797|446578|224144|835|-0.0217|0.1034|1098122|0.0831|23|658194|17|613268|0.1146|34
N|N0003|200106|SLC|11|21|34939|102521|0|102521|0|31777|51814|14017|4913|0|0.0465|0.0498|39662|0.0221|22|51426|15|11433|0.021|27
N|N0003|200106|SLI|11|21|3881|40617|418|39999|200|9667|16424|8563|5445|100|0.0376|0.0584|15844|0.0585|43|20722|21|3633|0.0345|53
N|N0003|200106|SO|11|21|43036|1830209|2000|1815354|11800|580083|787613|325490|133214|754|0.007|0.0234|654768|0.0233|25|930696|18|241690|0.0333|29
N|N0003|200106|SOPRA|11|21|480|16715|0|16715|0|3470|8827|1949|2469|0|0.0601|0.0665|4028|0.0293|35|11087|27|1600|0.0338|30
N|N0003|200106|SOPRB|11|21|271|17925|0|17925|0|5235|6861|2834|2995|0|0.0985|0.0985|10104|0.042|50|7421|23|400|0.0375|42
N|N0003|200106|SOPRC|11|21|306|16462|0|16462|0|2966|8671|3400|1425|0|0.0695|0.0901|6935|0.0333|27|8927|25|600|0.0367|33
N|N0003|200106|SP|11|21|8355|417878|20700|395978|1000|88276|173307|84940|49425|1030|-0.1028|0.2098|199842|0.171|26|116566|21|80570|0.2007|41
N|N0003|200106|SPN|11|21|6300|100444|325|100119|0|31571|45383|12267|10898|0|0.017|0.0288|43292|0.0424|30|56427|21|400|0.015|91
N|N0003|200106|SPP|11|21|2658|51056|0|50756|300|10669|25951|9287|5149|0|0.035|0.0357|20559|0.0263|30|27662|21|2835|0.0104|42
N|N0003|200106|SRE|11|21|38345|776656|470|775086|1100|536186|219314|17703|2755|228|0.0072|0.0319|347116|0.0326|9|370017|8|59053|0.036|11
N|N0003|200106|SREPRA|11|21|318|28661|0|28661|0|5688|17888|3435|1650|0|0.148|0.1707|17662|0.1052|21|10199|21|800|0.075|20
N|N0003|200106|SSD|11|21|3721|35844|500|35344|0|9983|16926|5118|3317|0|0.0133|0.1372|17605|0.1104|33|13239|17|4500|0.1138|32
N|N0003|200106|SSR|11|21|578|19430|0|19430|0|3254|10127|4436|1013|600|0.0853|0.0911|7555|0.0238|45|11475|28|400|0.035|22
N|N0003|200106|STZ|11|21|12204|339807|2000|337207|600|85800|149849|59664|42094|400|-0.0029|0.0667|138641|0.0823|34|166570|25|32596|0.0947|42
N|N0003|200106|STZB|12|21|57|624|0|624|0|0|0|0|624|0|1.8974|2.1795||||400|153|224|0.25|294
N|N0003|200106|SUR|11|21|3353|31393|0|31393|0|11609|15609|2915|1260|0|0.0568|0.0639|12522|0.0329|17|17749|15|1122|0.04|22
N|N0003|200106|SUT|11|21|1820|35284|0|35084|0|12819|18577|3588|100|0|0.0201|0.0223|16575|0.0263|15|17409|13|1100|0.0291|14
N|N0003|200106|SUTPRA|11|21|196|10131|0|10131|0|1975|6048|2008|100|0|0.0368|0.1397|5027|0.083|25|5104|15|||
N|N0003|200106|SVAPR|11|21|42|3315|0|3315|0|200|1775|1340|0|0|0.0515|0.1859|1185|0.0888|22|1930|29|200|0.05|13
N|N0003|200106|SWM|11|21|3058|25116|100|25016|0|8271|12267|3269|1209|0|0.0461|0.0897|9365|0.0636|26|13651|16|2000|0.075|24
N|N0003|200106|SZ|11|21|258|2987|0|2987|0|0|1937|900|150|0|0.0285|0.0453|500|0.03|30|2487|36|||
N|N0003|200106|TAPPRA|11|21|636|40656|0|40656|0|9089|25026|6266|275|0|0.0569|0.0587|14590|0.0156|21|25766|17|300|0.03|15
N|N0003|200106|TAPPRB|11|21|105|5637|0|5637|0|628|4379|630|0|0|0.1076|0.112|4215|0.0363|18|1222|10|200|0.04|11
N|N0003|200106|TCC|11|21|2715|33038|0|32738|300|5154|13144|8508|6232|0|0.0327|0.0487|15161|0.0428|44|15526|27|2351|0.0516|33
N|N0003|200106|TCH|11|21|563|10532|0|10532|0|1828|7022|700|982|0|0.066|0.0697|2692|0.0298|26|7640|21|200|0.05|0
N|N0003|200106|TCLPR|11|21|281|6611|0|6611|0|2911|3700|0|0|0|0.1029|0.1033|1800|0.0339|16|4811|11|||
N|N0003|200106|TCR|11|21|9032|64034|0|64034|0|13892|25318|11708|12916|200|0.0298|0.0366|20925|0.0261|44|38017|34|5092|0.0244|58
N|N0003|200106|TD|11|21|44798|84704|200|84504|0|26904|43499|9309|4792|0|0.0325|0.0518|30355|0.0191|20|40045|14|14104|0.0498|25
N|N0003|200106|TDI|11|21|49|5012|0|5012|0|850|2266|1175|721|0|0.0014|0.177|2011|0.0975|46|3001|24|||
N|N0003|200106|TDR|11|21|513|4930|0|4930|0|160|4120|450|200|0|0.1722|0.1429|3070|0.0602|24|1860|18|||
N|N0003|200106|TDY|11|21|4964|111666|327|111339|0|39645|56089|11267|4338|0|0.0014|0.0325|46693|0.0382|21|60096|14|4550|0.0372|18
N|N0003|200106|TEE|11|21|3807|93634|194|93440|0|38091|39954|10290|5205|0|0.0724|0.0979|55764|0.0522|17|33575|17|4101|0.0442|24
N|N0003|200106|TEF|11|21|21316|396187|0|395605|100|185332|137753|47922|24698|0|0.0348|0.0489|199060|0.031|21|167710|14|28935|0.0439|27
N|N0003|200106|TEM|11|21|34|975|0|975|0|375|200|400|0|0|0.2018|0.2467|300|0.1167|11|675|25|||
N|N0003|200106|TEN|11|21|2800|70065|0|70065|0|20950|30885|10353|7877|0|0.0257|0.0338|26121|0.0405|24|39987|23|3957|0.0298|12
N|N0003|200106|TFS|11|21|8314|145212|800|143612|800|41861|68860|23910|9781|0|0.0099|0.0531|57459|0.0478|23|76318|19|10635|0.0542|23
N|N0003|200106|TGT|11|21|90495|3240598|7313|3215448|13900|1249034|1213942|478651|281570|6151|0.0055|0.0267|1754183|0.0402|22|1020458|16|454707|0.0506|33
N|N0003|200106|THX|11|21|8058|138946|400|137546|600|38790|53171|27131|18274|780|-0.0272|0.0806|45773|0.104|35|75898|24|16475|0.1466|48
N|N0003|200106|TI|11|21|6196|58047|100|57847|100|5609|27586|14591|9798|363|0.2277|0.3006|31788|0.331|46|23256|24|2903|0.1905|36
N|N0003|200106|TIA|12|23|14|3300|2600|700|0|0|0|0|700|0|-6.14|2.68||||700|208|||
N|N0003|200106|TLI|11|21|486|18393|0|18393|0|5914|7198|3215|2066|0|0.0338|0.0413|4007|0.0171|38|13686|23|700|0.0357|23
N|N0003|200106|TLK|11|21|1195|9060|0|9060|0|1072|5706|1383|899|0|0.0163|0.0239|6138|0.0201|21|2922|33|||
N|N0003|200106|TOL|11|21|15783|345725|1300|343187|300|106434|153897|54404|28752|0|0.0221|0.0455|141820|0.0581|27|171803|19|29864|0.0657|25
N|N0003|200106|TR|11|21|9367|189915|1800|188115|0|37995|79907|42395|26708|1110|0.0162|0.0758|79587|0.0422|37|92597|28|15931|0.1202|54
N|N0003|200106|TRA|11|21|3095|53919|100|53619|200|18468|22849|10610|1892|200|0.013|0.0187|18222|0.0285|24|34022|21|1575|0.0225|27
N|N0003|200106|TRP|11|21|12562|40568|300|39968|300|18516|17508|3049|1195|0|0.0232|0.0269|17545|0.0144|14|22113|14|610|0.0166|13
N|N0003|200106|TRPPR|11|21|510|18352|0|18352|0|6762|8990|2100|500|0|0.0461|0.0513|8625|0.0222|22|9527|12|200|0.03|10
N|N0003|200106|TRPPRC|11|21|137|6352|0|6352|0|3210|2942|200|0|0|0.0645|0.0643|2510|0.0303|14|3842|11|||
N|N0003|200106|TTR|11|21|181|6839|0|6839|0|4785|1668|386|0|0|0.058|0.0552|1506|0.0338|10|5333|9|||
N|N0003|200106|TWE|11|21|15596|116045|212|115233|600|36782|50391|20674|7986|0|0.0133|0.0223|38403|0.0222|28|69540|19|7890|0.0292|31
N|N0003|200106|TWK|11|21|8031|62550|426|62124|0|17218|21312|10709|12585|300|0.0112|0.0307|32607|0.0461|34|27617|38|1900|0.0442|41
N|N0003|200106|TX|11|21|97321|2376297|9060|2363465|2500|1397168|761431|163587|43779|0|0.0131|0.0354|1075238|0.0369|12|866775|10|423952|0.0385|15
N|N0003|200106|TXCPRA|11|21|550|35819|0|35819|0|20100|13164|1840|615|100|0.0692|0.0725|12355|0.0141|13|22764|13|700|0.0557|15
N|N0003|200106|TXCPRB|11|21|156|7489|0|7489|0|2855|3884|600|150|0|0.1133|0.1246|3550|0.0445|12|3739|19|200|0.01|22
N|N0003|200106|TXN|11|21|203098|7538253|101229|7394161|34500|2539737|2403485|1376649|1086906|21884|-0.0069|0.0401|3888049|0.0556|27|1778802|21|1761810|0.066|43
N|N0003|200106|UIS|11|21|33233|863380|300|860260|2600|520238|271865|59247|11158|352|0.0019|0.0169|410722|0.0227|12|392168|9|59970|0.0259|19
N|N0003|200106|VAP|11|21|142|5620|0|5620|0|1085|2560|500|1475|0|0.0876|0.0888|4035|0.0313|40|1485|25|100|0.02|11
N|N0003|200106|VBF|11|21|811|20011|0|20011|0|4270|7857|4087|3597|200|0.0555|0.0668|10578|0.0362|41|9233|30|200|0.02|320
N|N0003|200106|VEA|11|21|224|17329|0|17329|0|5199|9135|2195|800|0|0.0635|0.0988|8620|0.0473|19|8309|17|400|0.04|15
N|N0003|200106|VELPRT|11|21|384|9565|0|9565|0|3225|5640|600|100|0|0.1076|0.1207|5245|0.0358|15|4020|10|300|0.07|21
N|N0003|200106|VGM|11|21|363|5974|0|5974|0|2694|2750|530|0|0|0.0373|0.0349|3386|0.0109|14|2588|12|||
N|N0003|200106|VGR|11|21|5617|95521|600|94921|0|26817|43606|15460|8788|250|0.0653|0.1196|39410|0.111|32|46153|19|9358|0.0972|28
N|N0003|200106|VIG|11|21|133|2057|0|2057|0|389|1668|0|0|0|0.03|0.0391|800|0.0125|10|1157|10|100|0.01|13
N|N0003|200106|VIN|11|21|276|6807|0|6807|0|2456|1434|892|2025|0|0.0319|0.0312|2010|0.013|41|4797|48|||
N|N0003|200106|VIT|11|21|545|12624|0|12624|0|7444|4875|305|0|0|0.036|0.0359|6412|0.0114|11|5887|8|325|0.01|8
N|N0003|200106|VNV|11|21|211|2270|0|2270|0|780|1190|300|0|0|0.0572|0.0457|538|0.01|26|1732|10|||
N|N0003|200106|VOD|11|21|39993|1514065|2700|1506152|4300|792257|578419|118150|21426|200|0.0127|0.0158|842187|0.0218|14|579386|10|88879|0.0263|17
N|N0003|200106|VOL|11|21|2011|20551|0|20551|0|5757|10161|2999|1534|100|0.0559|0.0808|10322|0.0528|27|8844|20|1385|0.0453|26
N|N0003|200106|VOT|11|21|231|6573|0|6573|0|2658|3686|229|0|0|0.0452|0.0539|2850|0.0175|15|2968|10|755|0.01|23
N|N0003|200106|VPA|11|21|187|9050|0|9050|0|1907|5339|1300|504|0|0.0648|0.0632|5957|0.0343|22|3093|18|||
N|N0003|200106|VPQ|11|21|221|8868|0|8868|0|2747|4560|686|875|0|0.0484|0.0517|3903|0.0212|19|4965|23|||
N|N0003|200106|VRC|11|21|30663|721772|1186|719800|600|264831|294864|105814|54891|0|-0.0091|0.045|286261|0.0307|21|317784|20|116355|0.0471|28
N|N0003|200106|VSH|11|21|32551|439313|1600|434513|3200|160494|181677|67281|28161|100|0.0057|0.0236|201249|0.0324|22|186762|16|49702|0.0348|26
N|N0003|200106|VVC|11|21|13148|178642|300|178342|0|45864|72830|35634|23102|912|0.0164|0.0386|69059|0.0436|36|101042|24|8241|0.0549|69
N|N0003|200106|VVR|11|21|3157|83284|0|83284|0|28751|37822|13076|3635|0|0.0123|0.013|15688|0.0125|22|66309|18|1287|0.01|29
N|N0003|200106|WFR|11|21|4276|55333|0|55133|200|19295|21918|7154|6214|752|0.0271|0.0502|20319|0.0448|40|31596|17|3418|0.0496|22
N|N0003|200106|WG|11|21|2459|43323|200|43123|0|7887|16391|10247|8498|100|0.0451|0.0786|26932|0.0573|40|12256|37|3935|0.0413|33
N|N0003|200106|WLP|11|21|41220|613165|3600|607565|1800|224212|285602|70528|28442|581|0.0052|0.0537|307476|0.0591|19|225772|15|76117|0.0715|21
N|N0003|200106|WNI|11|21|69|620|0|620|0|100|320|200|0|0|0.029|0.0194|420|0.0333|11|200|39|||
N|N0003|200106|WSM|11|21|18497|335089|7400|327689|0|107654|147769|43968|28298|0|-0.02|0.0431|146297|0.0509|24|138437|17|42955|0.0611|38
N|N0003|200106|WTS|11|21|2185|25867|0|25867|0|9094|10894|4105|1774|0|0.0222|0.0725|13047|0.0591|24|12620|23|200|0.01|8
N|N0003|200106|XRX|11|21|45334|1563755|1500|1551990|9300|899430|518310|111272|32278|0|0.0048|0.0141|589903|0.0185|14|835374|9|136013|0.0244|21
N|N0003|200106|XVF|11|21|1738|63667|300|63367|0|20329|30220|10193|2625|0|0.1756|0.2107|36209|0.0865|21|24028|17|3130|0.1246|6
N|N0003|200106|YLD|11|21|1237|13280|0|13280|0|5464|4515|2276|1025|0|0.0185|0.0193|3096|0.0162|19|9884|23|300|0.01|7
N|N0003|200106|YUM|11|21|32965|681270|15304|663764|1800|124966|222082|150777|158519|9220|-0.0154|0.025|322286|0.0381|48|259741|38|83537|0.0503|67
N|N0003|200106|ZIF|11|21|469|9335|0|9335|0|3943|4592|700|100|0|0.0331|0.0384|4741|0.018|12|4594|17|||
N|N0003|200106|ZMX|11|21|74|2620|0|2620|0|0|1999|353|268|0|0.0441|0.0335|1979|0.0469|24|641|47|||'

	EXEC -t'|' -k 4,4 -lsum,op=average:integer:7 $data/nyse.dat
		OUTPUT - $'N|N0003|200106|AA|11|21| 4320|3524300|9331|3494983|15500|1129332|1283396|639798|452298|5659|0.0021|0.0289|1717663|0.038|30|1195358|20|597462|0.0481|35
N|N0003|200106|AAT|11|21|23|14046|0|14046|0|7421|4549|1485|591|0|0.0314|0.0304|2513|0.01|25|11333|14|200|0.01|90
N|N0003|200106|ABJ|11|21|12|14508|0|14508|0|2603|9175|1650|1080|0|0.0756|0.0779|6636|0.0136|17|7872|25|||
N|N0003|200106|ABS|11|21|2033|1465605|200|1461410|2900|483622|651665|241738|87165|120|0.0097|0.0284|599869|0.0306|22|670152|18|194289|0.0373|25
N|N0003|200106|ABT|11|21| 5000|3368858|8904|3347422|10900|1469987|1273455|447558|166267|1055|0.0041|0.0273|1682138|0.0365|18|1150749|14|525435|0.044|25
N|N0003|200106|ACA|11|21|11|11490|0|11490|0|2845|7495|100|1050|0|0.0908|0.0946|5052|0.0146|17|6438|22|||
N|N0003|200106|ACS|11|21|1161|523323|13500|509523|0|192518|202103|71973|42229|700|-0.0264|0.0658|254514|0.0654|21|177869|17|77140|0.0915|38
N|N0003|200106|AEF|11|21| 58|61757|0|61757|0|9524|22881|15536|13616|200|0.0418|0.0464|24867|0.0137|47|35248|43|1642|0.0401|27
N|N0003|200106|AET|11|21|1049|472785|900|471531|300|213068|162069|63465|32949|280|0.0069|0.0217|214120|0.0315|22|224763|16|32948|0.035|26
N|N0003|200106|AGC|11|21|2185|1443428|2747|1438956|1000|588445|574302|188125|88940|0|0.0076|0.0283|603123|0.0256|22|661220|16|175613|0.0329|31
N|N0003|200106|AGCPRA|11|21|18|16339|0|16339|0|3810|5914|4990|1625|0|0.1073|0.1187|7461|0.11|44|8678|25|200|0.085|8
N|N0003|200106|AGCPRB|11|21|18|6853|0|6853|0|100|3855|1550|1348|0|0.1382|0.115|3097|0.0587|44|3756|46|||
N|N0003|200106|AGCPRM|11|21|22|15702|100|15602|0|1685|7911|3046|2170|790|0.0762|0.0876|4071|0.0247|64|11031|65|500|0.078|166
N|N0003|200106|AGCPRMCL|11|21|3|1223|0|1223|0|0|923|300|0|0|0.04|0.04|1223|0.01|22|||||
N|N0003|200106|AGCPRN|11|21|14|18338|0|18338|0|5186|8423|2223|2306|200|0.0895|0.0967|2885|0.0334|65|15203|23|250|0.046|21
N|N0003|200106|AGCPRNCL|11|21|3|665|0|665|0|100|565|0|0|0|0.01|0.01||||665|21|||
N|N0003|200106|AGI|11|21|14|4879|0|4879|0|730|2761|1388|0|0|0.0154|0.0238|4099|0.0433|19|780|29|||
N|N0003|200106|AHO|11|21|274|101764|100|101464|200|25120|56355|13898|6291|0|0.0582|0.061|51772|0.043|22|43731|19|6161|0.0371|23
N|N0003|200106|AIV|11|21|515|143764|0|143464|0|58036|56027|19187|10214|0|0.0376|0.0629|54117|0.0484|20|80319|20|9028|0.0438|29
N|N0003|200106|AIVPRC|11|21|10|5998|0|5998|0|2025|2725|948|300|0|0.1019|0.1098|2675|0.0259|25|3023|15|300|0.09|37
N|N0003|200106|AIVPRD|11|21|19|15180|0|15180|0|5430|8025|825|900|0|0.1032|0.1226|6105|0.0322|15|8975|24|100|0.04|12
N|N0003|200106|AIVPRG|11|21|18|12295|0|12295|0|3195|6435|1315|1350|0|0.084|0.0783|3675|0.0122|30|7920|24|700|0.0343|32
N|N0003|200106|AIVPRH|11|21| 8|5959|0|5959|0|2100|3074|785|0|0|0.075|0.1345|2824|0.0322|13|3035|18|100|0.11|9
N|N0003|200106|AIVPRK|11|21|4|2070|0|2070|0|0|1070|600|400|0|0.2686|0.4413|1350|0.1863|48|720|20|||
N|N0003|200106|AIVPRP|11|21|11|11916|0|11916|0|3681|4873|2148|1214|0|0.1826|0.2129|3376|0.0379|23|8540|26|||
N|N0003|200106|AIVPRQ|11|21|19|10242|0|10242|0|3898|5497|327|520|0|0.0807|0.0792|4613|0.0174|19|5629|13|||
N|N0003|200106|AJG|11|21|743|196649|600|196049|0|80999|79015|21230|12954|1851|0.0292|0.0426|79215|0.0366|26|106810|13|10024|0.0518|45
N|N0003|200106|ALM|11|21|86|9137|0|9137|0|300|7876|961|0|0|0.0497|0.0618|7139|0.0245|19|1998|15|||
N|N0003|200106|ALPPRN|11|21|2|1290|0|1290|0|0|890|400|0|0|0|0.181|400|0.05|16|890|21|||
N|N0003|200106|ALPPRO|11|21|2|1700|0|1700|0|0|1700|0|0|0|0.0159|0.2247|950|0.0621|26|750|18|||
N|N0003|200106|ALPPRQ|11|21| 8|7400|0|7400|0|2517|4483|400|0|0|0.0703|0.0795|3496|0.0287|17|3904|11|||
N|N0003|200106|ALPPRR|11|21|11|12186|0|12186|0|2223|8511|1152|300|0|0.0695|0.0713|4546|0.0179|18|7540|15|100|0.04|63
N|N0003|200106|ALQ|11|21|17|14947|0|14947|0|5706|7091|2050|100|0|0.088|0.0864|8607|0.0231|21|6040|12|300|0.01|7
N|N0003|200106|ALZ|11|21|10|10019|0|10019|0|800|8563|656|0|0|0.0994|0.1095|6749|0.0256|19|3270|13|||
N|N0003|200106|AMB|11|21|464|82057|0|81694|0|49345|26444|3944|1961|0|0.0218|0.029|37759|0.0248|12|40635|11|3300|0.0224|15
N|N0003|200106|AMBPRA|11|21| 7|5460|0|5460|0|3560|1700|200|0|0|0.0574|0.1091|3300|0.0473|10|2160|13|||
N|N0003|200106|AMD|11|21| 7929|4782471|105767|4655665|17300|1343670|1809871|952933|564656|1635|-0.01|0.0399|2160554|0.0464|24|1180503|21|1331908|0.0601|37
N|N0003|200106|ANN|11|21| 743|308613|7500|301013|100|160173|110558|25319|5063|0|-0.0095|0.0525|131184|0.0608|13|134861|10|35068|0.0762|17
N|N0003|200106|AOC|11|21|1584|740421|1545|737685|900|213132|304297|146622|73959|575|0.0001|0.0241|340231|0.0367|28|337678|21|60676|0.0378|34
N|N0003|200106|ARB|11|21|369|81559|300|81259|0|24043|40724|12568|3924|0|0.0259|0.0549|39589|0.0546|22|36715|18|4955|0.0477|23
N|N0003|200106|ARH|11|21|7|1815|0|1815|0|400|1115|100|200|0|0.0357|0.0527|1190|0.0182|31|625|19|||
N|N0003|200106|ATI|11|21| 672|204221|195|204026|0|95949|86063|15394|6520|100|0.011|0.0249|88367|0.0285|16|109155|13|6504|0.0249|20
N|N0003|200106|AVP|11|21|1977|1025278|1664|1021714|1300|640871|320330|47980|12801|1032|-0.0027|0.0305|463631|0.0358|10|466899|8|92484|0.0454|15
N|N0003|200106|AVZ|11|21|217|42999|0|42899|100|15985|19543|6471|1000|0|0.1208|0.1957|20702|0.1167|19|19355|14|2942|0.0663|19
N|N0003|200106|AXL|11|21|138|43442|0|43442|0|11343|20974|6885|4240|0|0.0524|0.0834|21281|0.0732|30|20822|22|1339|0.0249|14
N|N0003|200106|AZA|11|21|3604|777156|5600|770456|500|475253|227074|51985|16512|132|0.0081|0.0359|346051|0.0248|11|287853|9|137052|0.035|17
N|N0003|200106|AZZ|11|21| 62|30688|0|30688|0|5454|17696|5938|1600|0|0.0621|0.0925|17081|0.0713|24|12107|24|1500|0.0293|20
N|N0003|200106|BC|11|21|1058|347438|2150|344388|900|119326|140853|55052|29034|1023|0.0049|0.0287|151059|0.0335|27|165409|19|28820|0.0421|28
N|N0003|200106|BCC|11|21|1481|232534|1500|231034|0|90880|102617|27338|10199|0|0.0026|0.0495|86498|0.0425|21|123377|15|21159|0.0489|20
N|N0003|200106|BD|11|21|169|26224|200|26024|0|8210|15964|1850|0|0|0.0081|0.0147|10370|0.0141|12|14654|13|1000|0.014|21
N|N0003|200106|BDF|11|21|12|9620|0|9620|0|3229|4243|1738|410|0|0.0458|0.0565|2903|0.0136|13|6717|23|||
N|N0003|200106|BGG|11|21|481|164711|600|163823|0|76597|68590|14556|4080|0|0.0223|0.0874|65955|0.0439|16|85847|11|12021|0.0977|21
N|N0003|200106|BGT|11|21|27|15473|0|15473|0|8014|5024|1985|450|0|0.015|0.0185|3385|0.01|10|12088|14|||
N|N0003|200106|BK|11|21| 4897|3340606|5800|3332030|800|2109454|974660|195186|53530|0|-0.0055|0.0372|1548826|0.0305|11|1273475|9|510529|0.0417|16
N|N0003|200106|BKE|11|21| 90|18544|0|18544|0|3788|12093|2226|437|0|0.0169|0.0528|10301|0.0694|18|7843|20|400|0.035|15
N|N0003|200106|BKPRC|11|21|17|17897|0|17897|0|10855|5842|850|350|0|0.0804|0.0857|8767|0.0274|15|8630|11|500|0.028|7
N|N0003|200106|BKPRD|11|21|20|21826|0|21826|0|13055|7571|500|700|0|0.0658|0.0714|10371|0.0168|11|11155|14|300|0.08|18
N|N0003|200106|BKPRE|11|21|16|23243|0|23243|0|10876|10497|1470|400|0|0.076|0.0832|15715|0.0205|15|7528|12|||
N|N0003|200106|BLI|11|21| 548|227952|1609|226143|100|75627|104943|33926|11747|0|0.0094|0.0263|112032|0.0332|20|104908|17|9303|0.0328|22
N|N0003|200106|BNI|11|21|2525|1206018|400|1203328|1600|680896|414696|85020|23178|1138|0.0049|0.0285|588392|0.0262|13|511908|10|104628|0.0403|19
N|N0003|200106|BR|11|21|3217|1378982|4900|1370416|2000|687207|493400|131614|58722|1473|0.0112|0.0302|782525|0.0406|16|459377|12|130514|0.0503|29
N|N0003|200106|BRG|11|21|51|11360|0|11360|0|2143|6614|1791|812|0|0.1021|0.1699|6410|0.118|29|4850|22|100|0.1|63
N|N0003|200106|BSP|11|21|14|4791|0|4791|0|1745|2537|509|0|0|0.0816|0.0835|2054|0.0143|14|2337|15|400|0.045|9
N|N0003|200106|BTY|11|21| 555|203914|400|203314|200|78459|82586|27485|14884|100|0.0731|0.1174|111376|0.0744|24|78300|16|13838|0.0657|24
N|N0002|200106|BTYRT|11|21| 63|50506|0|50506|0|19517|24313|3320|3356|0|0.1058|0.1598|32175|0.1498|23|17731|14|600|0.055|20
N|N0003|200106|BWG|11|21|44|6512|0|6512|0|1183|4379|650|300|0|0.0722|0.1734|4366|0.0936|24|2046|21|100|0.08|0
N|N0003|200106|BXS|11|21|212|33939|0|33939|0|14334|13818|5063|724|0|-0.002|0.0378|17439|0.042|14|15418|17|1082|0.0204|22
N|N0003|200106|BYD|11|21|154|35218|200|35018|0|8011|13121|6471|7115|300|0.0349|0.0426|12541|0.0321|37|19449|44|3028|0.0338|50
N|N0003|200106|BZL|11|21| 8|2330|0|2330|0|1000|400|530|400|0|0.0741|0.0748|1130|0.04|53|800|8|400|0.02|7
N|N0003|200106|C|11|21|10601|7798662|31303|7747379|16900|3563357|2481386|1113981|603003|2552|0.0063|0.0228|4246991|0.0389|19|2228824|15|1288464|0.0463|33
N|N0003|200106|CBM|11|21|465|194272|2240|191632|0|63286|89872|27044|11430|0|0.0026|0.1101|81401|0.0814|22|85841|16|24390|0.132|30
N|N0003|200106|CCC|11|21|167|43832|300|43532|0|9359|19019|8257|6297|600|0.0433|0.0488|20746|0.0443|44|20283|29|2503|0.0202|39
N|N0003|200106|CCPPRA|11|21|13|13025|0|13025|0|2350|7424|2707|544|0|0.1786|0.3285|5751|0.0625|18|6774|26|500|0.058|17
N|N0003|200106|CCR|11|21|1920|728090|6800|719678|1000|267653|271128|122720|59077|100|-0.0069|0.0301|346880|0.0381|22|277870|18|95928|0.0488|30
N|N0003|200106|CEA|11|21| 6|2229|0|2229|0|300|1601|328|0|0|0.0891|0.1549|928|0.031|17|1201|16|100|0.01|16
N|N0003|200106|CED|11|21|374|25925|300|25625|0|5812|12625|5838|1350|0|0.1071|0.108|13523|0.0484|25|10252|19|1850|0.043|36
N|N0003|200106|CEM|11|21|206|30385|0|30385|0|6560|16100|6125|1600|0|0.0332|0.0917|15567|0.0682|23|13468|23|1350|0.0337|30
N|N0003|200106|CEN|11|21|467|110436|0|110236|200|45363|46318|11486|6969|300|0.0197|0.0306|50010|0.0344|21|55025|14|5401|0.0262|38
N|N0003|200106|CF|11|21|1351|639764|3248|634316|1500|182374|248718|123189|77927|3608|0.01|0.0254|286515|0.033|30|282454|22|66847|0.0282|49
N|N0003|200106|CFE|11|21|7|1684|0|1684|0|1300|100|284|0|0|0.1609|0.1669|984|0.25|18|700|8|||
N|N0003|200106|CFN|11|21| 8|4234|0|4234|0|1018|1116|1300|800|0|0.0738|0.0828|1200|0.3967|71|3034|26|||
N|N0003|200106|CGPPRG|12|21|223|5400|4900|500|0|0|100|200|200|0|-1.076|0.184|200|0.75|80|300|33|||
N|N0003|200106|CGPPRI|11|21|177|750|0|750|0|0|200|0|400|150|-0.6333|0.026|550|0.7182|511|200|23|||
N|N0003|200106|CGPPRT|11|21|25|9711|0|9711|0|3766|4598|1147|200|0|0.0709|0.0734|2517|0.0372|15|7042|15|152|0.01|24
N|N0003|200106|CHD|11|21|518|132464|1359|131105|0|52672|55896|14149|7853|535|0.0327|0.0634|55486|0.0467|19|68291|17|7328|0.0501|27
N|N0003|200106|CHH|11|21|199|54062|0|53762|0|17816|21767|9596|4583|0|0.0255|0.0552|26188|0.0734|31|23562|16|4012|0.0527|16
N|N0002|200106|CHTRT|11|21| 4|3174|0|3174|0|160|0|320|2375|319|0.0599|0.0609|1735|0.0113|116|1439|198|||
N|N0002|200106|CHTRTWI|12|24|2|5000|0|5000|0|0|0|5000|0|0|-0.02|0.04||||5000|31|||
N|N0003|200106|CIC|11|21| 45|49613|0|49613|0|12025|25301|7518|4769|0|0.0555|0.0656|15733|0.0419|22|33280|25|600|0.0533|62
N|N0003|200106|CIP|11|21|27|22418|0|22418|0|4677|16266|1050|425|0|0.0692|0.0745|11685|0.0212|16|10033|16|700|0.0229|12
N|N0003|200106|CIR|11|21|188|57557|600|56957|0|24724|23479|6114|2640|0|-0.0348|0.0568|31783|0.0736|16|21547|14|3627|0.1043|30
N|N0003|200106|CKC|11|21|101|29607|0|29607|0|9386|15183|3387|1651|0|0.0419|0.0255|7241|0.0637|30|21486|17|880|0.0327|46
N|N0003|200106|CKH|11|21|313|88089|0|88089|0|41269|36261|7618|2941|0|0.0003|0.0825|32140|0.0668|15|48565|12|7384|0.0821|18
N|N0003|200106|CLB|11|21|311|122678|600|122078|0|25245|56302|22564|17297|670|0.0619|0.0714|57167|0.0743|39|58510|25|6401|0.0322|58
N|N0003|200106|CLJ|11|21|141|38026|0|38026|0|5116|17590|8934|6386|0|0.0573|0.0909|17649|0.0682|43|19877|32|500|0.042|67
N|N0003|200106|CLL|11|21|28|8406|300|8106|0|1238|4650|1785|433|0|0.1254|0.2263|3948|0.1524|16|3958|24|200|0.29|58
N|N0003|200106|CMO|11|21|253|106712|0|106312|400|43418|52504|8949|1841|0|0.0355|0.0488|53463|0.043|16|49371|12|3878|0.0384|11
N|N0003|200106|CMOPRA|11|21|10|3043|0|3043|0|1294|850|599|300|0|0.5313|0.3056|1249|0.5695|35|1794|16|||
N|N0003|200106|CMOPRB|11|21|14|10036|0|10036|0|3886|4894|915|341|0|0.1375|0.13|3128|0.0804|19|6528|19|380|0.01|14
N|N0003|200106|CMP|11|21| 93|73395|0|73395|0|17955|42915|9935|2590|0|0.0915|0.1083|20714|0.0277|19|48680|18|4001|0.0559|33
N|N0003|200106|CMS|11|21|1101|430340|888|427110|2000|222679|168912|27920|9599|0|0.0123|0.0312|192319|0.0264|13|205993|11|30798|0.0334|18
N|N0003|200106|CMSPRJ|11|21| 7|6005|0|6005|0|975|4230|800|0|0|0.1592|0.2442|3930|0.0288|18|1775|17|300|0.1|17
N|N0003|200106|CMSPRK|11|21|11|9399|0|9399|0|800|7649|950|0|0|0.1539|0.2479|2575|0.0399|17|6124|18|700|0.1843|12
N|N0003|200106|CMSPRL|11|21|30|9413|0|9413|0|2016|4977|2005|415|0|0.1458|0.1851|4199|0.0565|24|4814|22|400|0.1|37
N|N0003|200106|CMSPRM|11|21|61|1698|0|1698|0|0|1398|0|300|0|0.3066|0.3419|1398|0.0949|20|||300|0.25|156
N|N0003|200106|CMSPRN|11|21| 7|4241|0|4241|0|523|2258|1260|200|0|0.0387|0.0779|3641|0.0212|28|600|9|||
N|N0003|200106|CNA|11|21|437|155244|0|154844|400|57125|83968|12351|1800|0|0.0374|0.0546|66722|0.0293|14|80492|10|8030|0.033|17
N|N0003|200106|CNL|11|21|704|129633|100|129233|300|70295|48666|7529|3043|0|0.027|0.0612|53723|0.0363|14|69264|10|6546|0.0487|18
N|N0003|200106|CNN|11|21|41|4852|0|4852|0|2531|1646|200|475|0|0.0395|0.038|3087|0.0285|13|1765|48|||
N|N0003|200106|COE|11|21|30|5098|0|5098|0|1085|1178|1635|1200|0|0.0263|0.0358|1785|0.0243|33|3313|59|||
N|N0003|200106|COG|11|21|635|131188|1478|129510|200|31708|55095|27764|14801|342|0.0097|0.0433|60097|0.0666|32|60933|24|8680|0.0682|51
N|N0003|200106|CPD|11|21|23|9634|0|9634|0|4435|3309|1640|250|0|0.0402|0.0417|7584|0.0444|18|2050|11|||
N|N0003|200106|CPP|11|21| 6|3230|0|3230|0|900|1350|980|0|0|0.1574|0.1737|900|0.0567|28|2330|18|||
N|N0003|200106|CPRE|11|21|19|23321|0|23321|0|2550|15745|3669|1357|0|0.0703|0.0674|13212|0.0199|26|9709|18|400|0.1|41
N|N0003|200106|CPRF|11|21|3|1100|0|1100|0|0|900|0|200|0|0.1932|0.3159|250|0.48|23|850|28|||
N|N0003|200106|CPRG|11|21|2|1326|0|1326|0|0|764|562|0|0|0.3991|0.4987|664|0.1324|29|662|30|||
N|N0003|200106|CPRH|11|21|2|1320|0|1320|0|0|600|720|0|0|0.3235|0.422|920|0.1978|23|400|59|||
N|N0003|200106|CPRK|11|21| 9|11084|0|11084|0|500|7692|2092|600|200|0.2122|0.2243|5553|0.0862|41|5131|29|400|0.165|32
N|N0003|200106|CPRM|11|21| 3|2226|0|2226|0|339|960|727|200|0|0.3019|0.5577|1580|0.2241|29|446|18|200|0.25|38
N|N0003|200106|CPRN|11|21|15|11091|0|11091|0|2000|7226|1205|660|0|0.0681|0.0632|5145|0.0127|21|5946|26|||
N|N0003|200106|CPRQ|11|21|2|1200|0|1200|0|0|500|700|0|0|0.5|0.5625|400|0.05|31|600|21|200|0.1|22
N|N0003|200106|CPRR|11|21|2|500|0|500|0|0|300|0|200|0|0.502|0.602|300|0.03|26|200|72|||
N|N0003|200106|CPRU|11|21| 4|3145|0|3145|0|200|1745|800|400|0|0.4211|0.5192|1470|0.0813|20|1675|47|||
N|N0003|200106|CPRW|11|21| 41|54632|0|54632|0|10698|29850|9542|4142|400|0.0671|0.0715|24025|0.0144|27|30207|31|400|0.04|21
N|N0003|200106|CPRX|11|21| 35|45053|400|44653|0|9460|26551|5112|3530|0|0.056|0.0603|19055|0.0159|31|25098|22|500|0.044|106
N|N0003|200106|CQPRA|11|21|20|19210|0|19210|0|5594|9166|3275|1175|0|0.1281|0.1641|10230|0.0347|18|8480|27|500|0.08|40
N|N0003|200106|CRM|11|21|12|1000|0|1000|0|0|300|0|700|0|0.132|-0.057|500|0.81|65|500|66|||
N|N0003|200106|CRY|11|21| 398|234595|3650|230145|500|98877|107261|19489|5018|0|-0.0028|0.1235|91095|0.097|16|107036|12|32514|0.1306|20
N|N0003|200106|CSL|11|21|613|142404|860|141544|0|43960|64987|21866|10199|532|0.0098|0.0624|60868|0.0381|24|68088|17|12588|0.0475|27
N|N0003|200106|CSP|11|21|19|11788|0|11188|600|4305|5430|1114|939|0|0.0331|0.0379|3505|0.0229|13|8183|24|100|0.02|14
N|N0003|200106|CVC|11|21| 739|300546|2400|297846|0|124254|143338|23288|6966|0|-0.0109|0.0522|119404|0.0584|16|145555|12|32887|0.052|19
N|N0003|200106|CVD|11|21|500|215338|1250|212285|1000|63619|102151|34471|13044|0|0.0155|0.0433|91877|0.0469|22|107181|19|14227|0.0438|27
N|N0003|200106|CW|11|21|53|11629|0|11629|0|1568|7271|1704|1086|0|-0.039|0.1445|5531|0.0981|29|5598|18|500|0.082|24
N|N0003|200106|CWN|11|21|239|59776|200|59176|400|10708|28045|14206|6517|100|0.0301|0.0268|23025|0.035|36|35286|30|1265|0.0361|38
N|N0003|200106|CWNPRA|11|21| 8|5460|0|5460|0|1280|2775|1105|300|0|0.0251|0.1623|2850|0.0813|21|2610|29|||
N|N0003|200106|CYE|11|21| 57|44347|0|44047|300|11950|16310|9270|6567|250|0.0261|0.029|15808|0.0208|39|28139|28|400|0.03|68
N|N0003|200106|D|11|21|2900|1219758|2220|1216438|1100|899099|288283|25052|5104|0|-0.0017|0.0547|587917|0.0449|8|463592|7|166029|0.0507|10
N|N0003|200106|DCP|11|21|143|23882|0|23882|0|6845|13962|2650|425|0|0.5272|0.4252|14729|0.1923|19|9153|17|||
N|N0003|200106|DCS|11|21|68|4646|100|4546|0|826|1934|886|900|0|0.0456|0.0374|646|0.0154|28|3900|39|||
N|N0003|200106|DDF|11|21| 39|34631|104|34527|0|7804|18014|5335|3374|0|0.06|0.0619|12217|0.0453|22|21810|22|500|0.01|12
N|N0003|200106|DFG|11|21|327|57038|0|57038|0|27051|22775|5339|1873|0|0.0073|0.0532|24654|0.036|18|28384|11|4000|0.0359|16
N|N0003|200106|DGX|11|21|1522|1005363|24875|978733|1100|406700|402320|118543|51365|905|-0.0253|0.1035|454631|0.1058|20|354981|15|170221|0.1344|24
N|N0003|200106|DHY|11|21|67|15511|0|15511|0|3644|6401|3456|1868|142|0.0168|0.0212|5804|0.0202|39|9407|33|300|0.01|39
N|N0003|200106|DJM|11|21|5|830|0|830|0|400|430|0|0|0|0.1148|0.1004|430|0.01|22|400|4|||
N|N0003|200106|DLX|11|21| 828|281299|2671|278216|300|71701|103284|50590|50913|2028|0.0145|0.0344|101971|0.0331|40|151551|33|24994|0.05|48
N|N0003|200106|DNB|11|21|421|207241|100|207141|0|97114|83577|20796|5654|0|0.0274|0.0423|106479|0.0315|16|90982|12|9680|0.0268|21
N|N0003|200106|DNR|11|21|322|73429|101|72428|900|27435|35656|7906|2331|0|0.0198|0.0339|30182|0.0324|16|39174|15|3972|0.0371|19
N|N0003|200106|DNY|11|21|1038|380145|100|379832|0|216298|132793|19890|10851|0|0.013|0.0381|156676|0.0298|13|193479|12|29677|0.0313|15
N|N0003|200106|DPRA|11|21| 38|35911|0|35911|0|16642|14590|3109|1570|0|0.0942|0.1137|13725|0.0222|17|20986|15|1200|0.0733|17
N|N0003|200106|DSU|11|21|125|76624|280|76344|0|28055|28115|11749|8425|0|0.0227|0.0231|27021|0.0138|28|48009|27|1314|0.0163|34
N|N0003|200106|DT|11|21|2897|446775|1300|444775|700|253675|148003|35543|8254|0|0.0139|0.0166|202363|0.0184|12|202306|10|40806|0.0204|23
N|N0003|200106|DV|11|21|638|149804|900|148704|200|53027|64825|19880|10136|1036|0.01|0.0764|65449|0.0428|22|72670|17|10785|0.0449|21
N|N0003|200106|EAS|11|21|544|158503|600|157500|0|70724|51100|22068|13608|0|0.0203|0.0322|57187|0.035|26|94069|17|6244|0.0266|40
N|N0003|200106|ED|11|21|1557|765164|1625|760880|1700|269390|288368|128899|73604|4061|0.0023|0.0326|315254|0.0402|32|364869|20|82457|0.0417|45
N|N0003|200106|EDE|11|21|198|54956|0|54856|100|22840|24852|6013|1251|100|0.0248|0.0399|26989|0.0521|15|25555|16|2412|0.0353|19
N|N0003|200106|EDEPRD|11|21| 8|4917|0|4917|0|900|2790|1127|100|0|0.0789|0.0871|4417|0.1058|19|300|26|200|0.06|31
N|N0003|200106|EDL|11|21|20|24045|0|24045|0|4069|14154|4450|1372|0|0.0875|0.0953|4642|0.0249|30|17298|22|2105|0.0329|18
N|N0003|200106|EDO|11|21|322|150405|2000|148405|0|48400|64713|22279|12513|500|0.0238|0.0571|72066|0.0717|23|66460|15|9879|0.0961|31
N|N0003|200106|EDPRA|11|21| 9|3320|0|3320|0|500|1950|400|470|0|0.3342|0.8095|1820|0.7951|31|1200|27|300|0.4167|28
N|N0003|200106|EFL|11|21|11|4491|0|4491|0|1783|2333|275|100|0|0.1172|0.1064|3238|0.0392|14|1253|18|||
N|N0003|200106|ELN|11|21|1968|1698154|28233|1658521|9800|591927|749792|247952|77850|800|0.0024|0.0376|896938|0.0543|20|574910|16|196473|0.0643|24
N|N0003|200106|ELNWSA|11|21|369|15924|0|15924|0|2530|8535|2849|2010|0|0.706|0.618|9810|0.2236|33|5214|14|900|0.1233|61
N|N0003|200106|ELNWSB|11|21|107|3710|0|3710|0|950|1510|800|450|0|0.6193|1.0969|2100|0.5145|54|1410|12|200|0.79|20
N|N0003|200106|EMC|11|21|14071|9897171|68202|9782039|39300|3244345|4085888|1836849|651461|1701|0.006|0.0249|5060991|0.0472|22|2257708|15|2502640|0.0544|30
N|N0003|200106|EMD|11|21| 7|3634|0|3634|0|200|2219|700|515|0|0.1069|0.0971|1119|0.0607|21|2515|31|||
N|N0003|200106|EPG|11|21| 4432|3812438|35121|3757321|15900|1178720|1457845|694790|424248|17468|0.0012|0.0318|2175190|0.0565|26|985314|20|612717|0.0627|36
N|N0003|200106|EPGPR|11|21|2|589|0|589|0|0|0|100|489|0|0.8351|1.1746|489|0.234|91|100|142|||
N|N0003|200106|EPGPRC|11|21|260|1800|0|1800|0|0|200|800|400|400|0.9539|1.6667|500|0.298|99|900|253|400|1.05|42
N|N0003|200106|EPI|11|21| 24|33956|200|33756|0|10726|15906|5444|1680|0|0.0689|0.0843|13803|0.0236|22|19153|19|800|0.0238|21
N|N0003|200106|EPL|11|21|221|76532|0|76232|300|31698|32628|8058|4148|0|0.0225|0.039|33547|0.0448|20|41085|15|1900|0.0384|30
N|N0003|200106|EPN|11|21|341|207403|200|207003|200|67977|98548|24636|15492|550|0.015|0.0573|111443|0.0584|22|85320|22|10440|0.0449|39
N|N0003|200106|ESI|11|21| 551|263316|10079|252937|200|72537|103484|43898|32168|1050|-0.0044|0.0683|113865|0.0789|32|107821|21|31451|0.1062|56
N|N0003|200106|ETA|11|21|13|6305|0|6305|0|800|3730|1385|390|0|0.0416|0.0437|3350|0.023|24|2855|29|100|0.04|38
N|N0003|200106|EX|11|21|199|36259|200|36059|0|11720|18552|4551|1236|0|0.0152|0.0391|16262|0.0377|21|18701|14|1096|0.0338|35
N|N0003|200106|FC|11|21|93|7273|0|7273|0|2340|3733|1100|100|0|0.0509|0.0469|4128|0.0602|21|3045|11|100|0.02|14
N|N0003|200106|FCX|11|21|1124|477507|0|477007|500|224775|186859|45247|20626|0|0.0095|0.0182|200039|0.0292|19|251445|13|26023|0.0258|17
N|N0003|200106|FCXA|11|21|423|43156|440|42716|0|15376|22763|3384|1049|144|0.0347|0.0382|23814|0.0421|19|17487|13|1415|0.0248|40
N|N0003|200106|FCXPRA|11|21|32|18015|0|18015|0|5645|7438|3682|1250|0|0.0671|0.0635|11571|0.0507|23|6444|22|||
N|N0003|200106|FCXPRB|11|21|30|14738|0|14738|0|3662|8961|1765|350|0|0.0779|0.1379|5695|0.0608|21|9043|19|||
N|N0003|200106|FCXPRC|11|21|19|4202|0|4202|0|0|2202|1700|300|0|0.0778|0.1058|1100|0.0409|35|3102|25|||
N|N0003|200106|FCXPRD|11|21|10|7878|0|7878|0|754|6474|650|0|0|0.0569|0.0839|4508|0.0431|17|3370|19|||
N|N0003|200106|FE|11|21|1769|852395|1200|849495|600|440011|305729|80238|22433|1684|0.0002|0.0259|297521|0.0334|15|484823|12|67751|0.0391|18
N|N0003|200106|FLR|11|21|1527|566592|10100|554892|1000|189895|244194|85222|36481|100|-0.0088|0.062|286010|0.0751|20|184057|16|85825|0.1055|33
N|N0003|200106|FMC|11|21|1567|300685|6100|294585|0|119860|125954|33675|15096|0|-0.0114|0.06|158560|0.0587|18|100317|17|35708|0.0695|31
N|N0003|200106|FO|11|21|1008|497417|300|496617|200|263838|184257|39171|9551|0|0.0121|0.0459|217394|0.0347|13|239890|11|39533|0.0497|21
N|N0003|200106|FOE|11|21|526|125134|506|124228|0|44257|57903|16669|5399|0|0.005|0.0377|56458|0.0374|20|61161|16|6609|0.0451|19
N|N0003|200106|FOPRA|13|21|1|300|300|0|0|0|0|0|0|0|0|||||||||
N|N0003|200106|FOR|11|21|39|12184|0|12184|0|8401|3433|350|0|0|0.03|0.0292|7012|0.0142|10|5172|7|||
N|N0003|200106|FPCPRA|11|21|21|22202|0|22202|0|9105|6257|2976|3864|0|0.0873|0.1081|10106|0.0562|28|12096|34|||
N|N0003|200106|FRC|11|21|215|47308|200|47108|0|11567|14565|9783|10893|300|0.0397|0.0645|16764|0.0702|53|24944|38|5400|0.1115|77
N|N0003|200106|FSH|11|21|425|195393|1100|194093|200|78546|81804|23834|10409|0|-0.0134|0.0717|92235|0.068|22|89125|14|12933|0.0638|25
N|N0003|200106|FTI|11|21| 226|362127|100|361927|100|145638|148580|54179|13530|100|0.0288|0.0225|195780|0.0546|19|152912|17|13335|0.0439|26
N|N0003|200106|FWJ|11|21|4|900|0|900|0|0|900|0|0|0|0.1167|0.1167|300|0.1|18|600|20|||
N|N0003|200106|GBE|11|21|10|4475|0|4475|0|1148|1629|814|884|0|0.052|0.0771|2092|0.049|30|2083|24|300|0.05|49
N|N0003|200106|GCG|11|21|6|900|0|900|0|400|0|100|400|0|-0.0011|-0.0011|700|0.0443|57|200|0|||
N|N0003|200106|GDP|11|21|49|4550|0|4550|0|1660|2414|476|0|0|0.0751|0.0799|1889|0.0255|18|2261|11|400|0.015|11
N|N0003|200106|GGT|11|21|104|24322|0|24322|0|9040|11256|3414|612|0|0.0735|0.0914|9010|0.0369|16|14434|18|878|0.0613|14
N|N0003|200106|GGTPR|11|21|5|2302|0|2302|0|400|1602|300|0|0|0.2183|0.2422|200|0.02|8|2102|16|||
N|N0003|200106|GID|11|21|3|600|0|600|0|100|300|200|0|0|0.0667|0.0133|600|0.05|28|||||
N|N0003|200106|GK|11|21|115|17156|0|17156|0|1750|7742|4376|3062|226|-0.0365|0.0597|9137|0.0484|35|6619|55|1400|0.0421|52
N|N0003|200106|GLC|11|21|1015|310305|2700|306105|1100|88027|135891|55266|26942|1079|0.0057|0.0268|152886|0.0322|25|129221|21|25098|0.0498|30
N|N0003|200106|GLG|11|21|206|51489|0|51089|400|30501|17462|3225|301|0|0.0271|0.0265|13063|0.0168|11|37509|11|917|0.0151|7
N|N0003|200106|GLH|11|21|207|45051|0|45051|0|15566|21649|5843|1993|0|0.1176|0.143|14705|0.0661|23|28551|15|1795|0.0261|21
N|N0003|200106|GLW|11|21| 7813|6854173|13360|6798713|38700|3855589|2284747|586994|109468|615|0.001|0.0136|3112503|0.0242|12|2413309|9|1311601|0.0273|18
N|N0003|200106|GPB|11|21|20|26231|0|26231|0|4691|15476|4364|1700|0|0.0888|0.0968|14042|0.057|21|11889|26|300|0.0167|53
N|N0003|200106|GPD|11|21|16|13433|0|13433|0|7588|5845|0|0|0|0.1493|0.1593|7865|0.0481|10|5268|10|300|0.1|9
N|N0003|200106|GPEPRA|11|21|18|17189|0|17189|0|7510|8831|848|0|0|0.1012|0.1118|10268|0.0573|13|6921|10|||
N|N0003|200106|GPEPRT|11|21|14|14799|400|14399|0|6781|6318|1100|200|0|0.0676|0.0711|6620|0.0196|18|7779|8|||
N|N0003|200106|GPEPRU|11|21|13|12589|0|12589|0|4059|8135|395|0|0|0.1495|0.1653|7537|0.0333|12|5052|11|||
N|N0003|200106|GPEPRV|11|21|11|7953|0|7953|0|1966|4966|1021|0|0|0.1438|0.1588|4145|0.0421|17|3508|19|300|0.0733|14
N|N0003|200106|GPF|11|21|11|5986|0|5986|0|1030|3571|925|460|0|0.1227|0.1622|1540|0.0802|23|4446|26|||
N|N0003|200106|GPU|11|21| 964|331935|1599|329136|500|179273|123240|20383|6540|200|0.0195|0.0418|164349|0.0434|12|136469|11|28818|0.0411|15
N|N0003|200106|GRA|11|21|111|50998|0|50998|0|21532|22718|6164|584|0|0.0138|0.0143|18821|0.0151|17|31361|14|816|0.0202|6
N|N0003|200106|GRB|11|21|164|27554|0|27554|0|5052|13374|6620|2508|0|0.0005|0.0295|12715|0.0593|26|13418|28|1421|0.0244|47
N|N0003|200106|GUPPRA|11|21| 5|4554|0|4554|0|350|4204|0|0|0|0.0982|0.1284|2809|0.1062|13|1745|14|||
N|N0003|200106|GUPPRB|11|21| 6|5484|0|5484|0|550|4584|350|0|0|0.159|0.1667|3784|0.0723|15|1700|11|||
N|N0003|200106|HAR|11|21|444|148497|1800|146597|100|34515|73133|27304|11745|0|-0.0186|0.0552|68766|0.0854|26|67117|23|10814|0.1312|22
N|N0003|200106|HAS|11|21| 706|438982|100|437882|1000|174135|192970|53185|18592|0|0.0166|0.0301|246768|0.0269|17|172621|16|19493|0.0313|24
N|N0003|200106|HCN|11|21|437|177141|0|175441|800|59204|72907|26587|16813|730|0.0226|0.034|81716|0.0317|27|85715|20|8810|0.0327|45
N|N0003|200106|HCNPRB|11|21|16|10125|0|10125|0|2217|4841|2284|783|0|0.0938|0.1173|6825|0.0796|25|2900|37|400|0.05|14
N|N0003|200106|HGR|11|21|25|7668|0|7668|0|2203|2650|1915|900|0|0.0445|0.0502|2915|0.0361|44|4653|19|100|0.02|8
N|N0003|200106|HIL|11|21|66|12938|0|12938|0|3997|7419|1222|300|0|0.0276|0.0221|7891|0.0332|15|4547|15|500|0.026|18
N|N0003|200106|HIW|11|21|754|201813|138|201675|0|124564|67892|7219|1700|300|0.0216|0.0302|92008|0.0319|10|101169|9|8498|0.0282|18
N|N0003|200106|HIWPRB|11|21|14|13382|0|13382|0|3770|8212|1000|400|0|0.1157|0.1308|9665|0.0841|16|3717|18|||
N|N0003|200106|HIWPRD|11|21|19|13883|0|13883|0|3676|7969|2238|0|0|0.1125|0.1521|8843|0.0724|17|4640|16|400|0.055|9
N|N0003|200106|HMA|11|21|1092|285451|0|284551|900|120298|111741|35184|17878|350|0.0064|0.0185|153353|0.0329|22|115598|15|16500|0.0365|33
N|N0003|200106|HMC|11|21|219|61763|0|61763|0|23757|28584|7033|2389|0|0.1082|0.1751|29459|0.1755|21|28592|13|3712|0.0987|30
N|N0003|200106|HMT|11|21| 913|248392|300|245792|2300|101541|107186|25592|12063|1710|0.0127|0.0155|123922|0.0207|20|115408|14|8762|0.018|59
N|N0003|200106|HMTPRA|11|21|18|10915|0|10915|0|2225|7190|1100|400|0|0.0923|0.1225|4130|0.0509|12|6285|19|500|0.086|42
N|N0003|200106|HMTPRB|11|21|18|12320|0|12320|0|4705|5465|1700|450|0|0.0738|0.0985|7575|0.0284|16|4545|23|200|0.1|18
N|N0003|200106|HMTPRC|11|21|35|16685|0|16685|0|4440|10635|1280|330|0|0.0792|0.0897|7385|0.018|21|8900|13|400|0.05|7
N|N0003|200106|HON|11|21| 7512|4537992|36160|4486970|11800|2162439|1652916|496192|184563|2660|-0.0203|0.0359|2222825|0.0602|16|1376974|12|898971|0.0831|26
N|N0003|200106|HOV|11|21|360|107289|200|106689|300|46229|49915|7595|3250|0|0.0423|0.0621|47328|0.0482|16|52446|13|7215|0.0522|15
N|N0003|200106|HZO|11|21|54|4175|0|4175|0|1240|2184|200|551|0|0.0338|0.039|1809|0.0585|30|2366|22|||
N|N0003|200106|ICS|11|21|8|1506|0|1506|0|0|1506|0|0|0|0.0529|0.0675|770|0.0113|10|736|16|||
N|N0003|200106|IDG|11|21| 4|2461|0|2461|0|319|1494|648|0|0|0.0047|0.1105|1813|0.0317|11|||648|0.1|38
N|N0003|200106|IEU|11|21| 7|4255|0|4255|0|255|3200|400|400|0|0.1078|0.2366|1555|0.0971|15|2700|36|||
N|N0003|200106|IFX|11|21|1612|155517|1600|152017|400|57220|65935|19363|9549|350|0.0046|0.1008|54177|0.0564|21|66889|15|31351|0.0759|27
N|N0003|200106|IGL|11|21|680|187910|400|187210|300|46812|77036|38157|24596|909|0.01|0.0177|77292|0.0227|36|101416|23|8802|0.0292|38
N|N0003|200106|IML|11|21|76|6306|0|6306|0|857|3090|1110|945|304|0.0974|0.1118|4214|0.0282|50|1335|44|757|0.0617|87
N|N0003|200106|IQM|11|21|15|9088|0|9088|0|3112|3224|1533|1219|0|0.032|0.0412|2795|0.0247|19|6163|27|130|0.02|15
N|N0003|200106|IR|11|21|2154|759241|2050|754499|2100|278603|313443|122486|41102|1380|0.0004|0.0277|384981|0.0303|20|301091|17|70527|0.0412|26
N|N0003|200106|ISP|11|21|134|20875|0|20875|0|5474|11352|2541|1508|0|0.0352|0.0493|11155|0.0345|20|8420|19|1300|0.0331|33
N|N0003|200106|ITG|11|21| 584|235115|3900|231115|100|71405|116744|30416|12650|0|-0.0315|0.0835|110607|0.0695|22|102156|15|18452|0.1072|32
N|N0003|200106|ITN|11|21|245|78922|429|78493|0|38979|31129|6358|2027|0|0.0211|0.0448|27960|0.0329|13|45177|12|5356|0.037|20
N|N0003|200106|ITT|11|21|1289|286838|300|285930|500|109564|148979|23443|4444|0|0.0162|0.0516|134635|0.0453|15|131715|12|20080|0.0523|18
N|N0003|200106|ITX|11|21|145|16878|200|16678|0|3675|9192|2450|1361|0|0.0283|0.0615|5862|0.039|25|7799|16|3017|0.0462|32
N|N0003|200106|ITXPR|11|21|2|1738|0|1738|0|199|729|450|360|0|0.2329|0.3264|888|0.2684|41|700|45|150|0.5|10
N|N0003|200106|IVC|11|21|380|109326|0|109042|0|56256|39484|9774|3528|0|0.0119|0.0595|52292|0.0707|14|49763|14|6987|0.0589|23
N|N0003|200106|JBL|11|21| 3264|2021224|38650|1976374|5600|828342|716374|280748|152377|4133|-0.0168|0.0406|978092|0.0497|20|664172|15|339710|0.0735|35
N|N0003|200106|JCP|11|21|1616|923275|3200|917192|2600|476919|354391|69553|17871|1058|0.0032|0.027|417906|0.0348|15|412601|11|89285|0.0462|17
N|N0003|200106|JEM|11|21| 9|3691|0|3691|0|2595|846|250|0|0|0.0709|0.0709|650|0.0162|17|3041|8|||
N|N0003|200106|JOE|11|21|320|109132|100|108932|100|37049|49203|13005|9415|360|0.0362|0.0545|30081|0.028|28|72812|20|6139|0.0361|55
N|N0003|200106|JYPPRZ|11|21|29|8294|0|8294|0|3987|2853|1454|0|0|0.075|0.0813|2801|0.0214|12|5093|17|400|0.055|13
N|N0003|200106|KBH|11|21|1231|396444|1900|393544|700|235578|135787|19031|3612|236|0.0173|0.052|158530|0.0436|12|201018|9|34696|0.062|18
N|N0003|200106|KBHPRG|12|23|18|4000|3800|200|0|0|200|0|0|0|-0.2|0.25||||200|18|||
N|N0003|200106|KBHPRI|11|21|24|1870|0|1870|0|670|1200|0|0|0|0.0917|0.1165|600|0.0233|10|1270|11|||
N|N0003|200106|KEG|11|21| 677|219955|1787|218168|0|79979|96492|29441|11905|351|0.0066|0.0309|96876|0.0251|21|100725|18|20567|0.0376|30
N|N0003|200106|KEI|11|21| 468|304821|3399|301422|0|107761|129096|42537|22028|0|-0.0197|0.0795|140598|0.0738|21|117736|18|43088|0.0839|31
N|N0003|200106|KG|11|21|1940|1031366|8400|1021866|1100|454412|432306|107139|28667|442|-0.0191|0.0377|522352|0.0555|16|392279|13|108335|0.069|18
N|N0003|200106|KLU|11|21| 74|33466|0|33466|0|12755|16840|3321|550|0|0.0379|0.052|13916|0.0403|14|18540|14|1010|0.01|16
N|N0003|200106|KMB|11|21| 3031|2164410|4955|2150133|7000|686439|883329|387441|193491|6433|-0.0002|0.0322|1162179|0.0422|24|704899|21|290055|0.0583|29
N|N0003|200106|KOR|11|21|55|5566|0|5566|0|1145|2746|600|1075|0|0.0353|0.0425|3656|0.0338|26|1910|33|||
N|N0003|200106|KPA|11|21|239|63086|0|62586|500|27584|24830|7518|3154|0|0.0283|0.0301|18392|0.0203|18|41710|16|2984|0.0191|24
N|N0003|200106|KPAPRA|11|21|19|8841|0|8841|0|2025|3910|800|2106|0|0.1962|0.2095|2760|0.056|50|5456|28|625|0.1156|16
N|N0003|200106|KRJ|11|21|3|1150|0|1150|0|300|850|0|0|0|0.0652|0.113|600|0.0833|18|550|14|||
N|N0003|200106|KTB|11|21| 6|6825|0|6825|0|1200|3975|850|800|0|0.0992|0.1024|4475|0.0597|29|2350|20|||
N|N0003|200106|KTP|11|21| 35|29875|0|29875|0|11654|14076|3720|425|0|0.026|0.1111|13092|0.0381|17|15603|15|1180|0.0632|17
N|N0003|200106|KYO|11|21|353|90772|0|90472|300|44067|39611|5763|1331|0|0.2892|0.3294|39291|0.1462|13|44089|12|7392|0.1991|15
N|N0003|200106|LBI|11|21|9|1540|0|1540|0|200|1090|250|0|0|0.0072|0.0645|713|0.121|22|827|15|||
N|N0003|200106|LDP|11|21|103|16330|0|16330|0|4713|7895|1543|2179|0|0.0597|0.0814|6311|0.0355|21|9254|26|765|0.0413|41
N|N0003|200106|LMM|11|21|3|1340|0|1340|0|400|450|490|0|0|0.0192|0.0192|210|0.0257|18|1130|27|||
N|N0003|200106|LMS|11|21|110|8949|0|8949|0|1605|5269|1025|1050|0|-0.0062|0.0789|5069|0.0544|32|3770|16|110|0.02|12
N|N0003|200106|LMT|11|21|2126|1539221|2321|1534598|1500|813099|498258|155630|68871|240|0.0089|0.038|652816|0.0387|18|731392|12|151890|0.0449|19
N|N0003|200106|LNT|11|21| 592|241025|0|240325|700|74986|120488|33823|11428|300|0.0151|0.0345|72301|0.0345|18|155939|17|12785|0.0238|23
N|N0003|200106|LRY|11|21|543|157798|0|156898|900|63418|75594|14717|4069|0|0.0192|0.0361|80555|0.0294|15|73460|14|3783|0.0312|21
N|N0003|200106|LRYPRA|11|21|30|11239|0|11239|0|5040|5074|675|450|0|0.1234|0.1347|2244|0.0408|19|8795|14|200|0.05|24
N|N0003|200106|LSHPRA|11|21|30|8884|0|8884|0|1777|4625|1100|1382|0|0.0941|0.1001|4602|0.0332|34|4282|29|||
N|N0003|200106|MAG|11|21|154|40664|100|40564|0|11519|19271|7942|1832|0|0.0271|0.034|18625|0.0561|21|21026|17|913|0.0264|46
N|N0003|200106|MAR|11|21|1805|852217|3439|847777|500|327186|338792|115285|64394|2620|-0.0021|0.0336|371175|0.0377|23|376069|17|101033|0.0395|25
N|N0003|200106|MAT|11|21|1913|1269034|600|1265555|2400|804303|370087|74517|19048|0|0.017|0.0286|536799|0.0232|12|603833|9|127323|0.0268|17
N|N0003|200106|MCC|11|21|63|15602|100|15502|0|3391|5930|2640|3441|100|0.0695|0.1551|10231|0.1351|48|3496|48|1775|0.1344|50
N|N0003|200106|MCO|11|21| 964|482050|300|481050|0|205260|224512|38524|12754|0|0.0064|0.0344|232157|0.0449|16|218413|12|30480|0.0506|21
N|N0003|200106|MCT|11|21|138|18905|300|18605|0|6170|8860|2500|1175|0|0.1805|0.2168|10070|0.0931|22|7035|21|1500|0.0993|18
N|N0003|200106|MDG|11|21|654|44774|100|44574|100|18941|16881|6899|1953|0|0.0197|0.0379|17024|0.0225|15|23758|15|3892|0.029|43
N|N0003|200106|MEE|11|21| 824|209709|1746|206463|1500|66383|99319|28763|13498|0|0.0036|0.0405|111328|0.0591|22|81354|18|15281|0.0622|27
N|N0003|200106|MEH|11|21|174|48319|0|48319|0|14334|23793|6423|3769|0|0.0076|0.0701|17902|0.0429|26|24568|19|5849|0.046|31
N|N0003|200106|MER|11|21| 8920|6760165|79577|6655420|22100|3730194|2256343|498914|187021|5048|0.0048|0.0551|3050308|0.0476|13|1925818|9|1701394|0.066|19
N|N0003|200106|MERPRA|11|21|11|19057|0|19057|0|7062|8478|2817|700|0|0.0955|0.101|10546|0.0317|22|8411|15|100|0.02|24
N|N0003|200106|MERPRB|11|21|18|20512|0|20512|0|6773|11414|1925|400|0|0.0952|0.0985|12232|0.0367|16|7980|17|300|0.01|11
N|N0003|200106|MERPRC|11|21|14|18441|0|18441|0|4795|11057|1582|1007|0|0.1116|0.1103|11160|0.0386|24|7181|16|100|0.07|17
N|N0003|200106|MERPRD|11|21| 44|50455|0|50455|0|18698|26565|3992|1200|0|0.0661|0.0677|28689|0.0208|17|21266|15|500|0.026|20
N|N0003|200106|MERPRE|11|21|19|24866|0|24866|0|7807|13364|1525|2170|0|0.0603|0.0673|17369|0.0194|23|7497|26|||
N|N0003|200106|MERPRF|11|21| 47|64465|0|64465|0|22971|30739|8030|2725|0|0.0545|0.0566|35833|0.0187|19|27832|19|800|0.025|12
N|N0003|200106|MFW|11|21|25|7466|0|7466|0|2841|4113|512|0|0|0.0188|0.0181|2029|0.0623|12|5437|14|||
N|N0003|200106|MGF|11|21|41|16120|0|16120|0|6543|8899|500|178|0|0.0194|0.0166|3887|0.0103|17|12233|12|||
N|N0003|200106|MHN|11|21|25|10018|0|10018|0|5361|3632|1025|0|0|0.0233|0.0315|3926|0.014|17|5792|10|300|0.0133|16
N|N0003|200106|MIM|11|21|11|1347|0|1347|0|275|672|200|200|0|0.0974|0.1074|140|0.13|24|1207|26|||
N|N0003|200106|MLI|11|21|297|69963|100|69763|100|19462|27043|13949|9309|100|0.0019|0.0273|31833|0.0706|30|34350|30|3680|0.0433|50
N|N0003|200106|MLM|11|21|688|204799|300|204099|400|61064|95095|32619|15821|300|0.0101|0.0477|80241|0.0608|24|108917|20|15341|0.0475|23
N|N0003|200106|MLS|11|21|384|206055|0|205855|200|74780|98864|22395|10016|0|0.0448|0.065|79217|0.0297|20|113979|14|12859|0.0332|28
N|N0003|200106|MMA|11|21| 54|41547|0|41347|200|6120|18982|11510|4935|0|0.0685|0.0759|18868|0.0622|31|22479|28|200|0.01|42
N|N0003|200106|MMC|11|21|3350|1504024|4800|1496324|2400|848935|524310|93936|31240|303|-0.0049|0.0776|737970|0.0635|14|537240|9|223514|0.0759|16
N|N0003|200106|MMR|11|21|126|24452|0|24452|0|4408|14201|3524|2319|0|0.0558|0.0584|10071|0.0532|24|13468|26|913|0.0605|21
N|N0003|200106|MMS|11|21| 385|318955|1900|315905|900|106853|137298|48809|23545|300|0.0373|0.0495|180240|0.06|24|113201|20|23364|0.0565|33
N|N0003|200106|MOT|11|21| 5698|3328170|5844|3311576|8100|1598352|1234943|389062|96669|650|0.0033|0.0107|1631510|0.0236|17|1229766|10|458400|0.0247|21
N|N0003|200106|MOTPRA|11|21| 48|54690|0|54690|0|19492|24106|8167|2925|0|0.0856|0.0898|30541|0.0284|23|23749|17|400|0.025|16
N|N0003|200106|MPPRD|11|21|7|1975|0|1975|0|300|775|900|0|0|0.1489|0.2923|1600|0.04|28|375|14|||
N|N0003|200106|MRX|11|21| 541|320344|8637|310782|200|63174|159322|56740|29946|1800|-0.0397|0.0942|133022|0.0768|30|134927|24|43033|0.1141|30
N|N0003|200106|MSF|11|21|21|9509|0|9509|0|2112|6131|766|200|300|0.0557|0.0626|3761|0.0423|15|5748|16|||
N|N0003|200106|MTN|11|21|149|22165|0|21965|200|4845|12736|2407|2177|0|0.0748|0.0896|11127|0.0907|28|10716|22|322|0.1|10
N|N0003|200106|MTTPRX|11|21| 8|5969|0|5969|0|850|4879|240|0|0|0.1796|0.1935|3074|0.1643|18|2895|13|||
N|N0003|200106|MTX|11|21|540|141623|0|140313|0|59229|61833|11244|8007|0|-0.0148|0.062|55775|0.0467|18|74506|17|10032|0.0553|28
N|N0003|200106|MUC|11|21|43|9273|0|9273|0|3762|3999|400|1112|0|0.0208|0.0279|5611|0.0146|17|3262|42|400|0.01|6
N|N0003|200106|MUJ|11|21|22|8266|0|8266|0|3118|4948|200|0|0|0.0242|0.0292|4991|0.0126|15|3275|10|||
N|N0003|200106|MUO|11|21|48|10408|0|10408|0|2493|6074|1116|725|0|0.0495|0.0519|3863|0.0223|24|6345|13|200|0.06|140
N|N0003|200106|MYI|11|21| 66|32319|0|32319|0|11642|14632|3472|2373|200|0.0321|0.0318|11728|0.0141|29|20291|17|300|0.01|18
N|N0003|200106|NAV|11|21|1011|207641|200|206594|300|100039|87977|14008|4870|0|-0.0035|0.0271|94076|0.027|14|101550|12|11268|0.0438|17
N|N0003|200106|NC|11|21|261|70933|0|70933|0|24172|40012|5599|1150|0|0.0198|0.1476|27278|0.0952|18|37888|11|5767|0.0974|18
N|N0003|200106|NCI|11|21|240|36300|0|36300|0|12555|13153|5331|4291|970|0.0303|0.0448|13065|0.0375|23|21642|25|1593|0.0567|119
N|N0003|200106|NDE|11|21| 685|252703|3500|248903|200|62581|105339|52043|27991|1149|0.0116|0.0427|103869|0.041|28|124648|23|20586|0.0692|57
N|N0003|200106|NEU|11|21|1045|434722|5500|427622|500|148279|190275|58105|31463|0|-0.019|0.0733|193603|0.0723|25|172307|15|62212|0.0672|31
N|N0003|200106|NMA|11|21|21|13504|0|13504|0|2868|6470|2799|1367|0|0.0282|0.033|1804|0.0319|18|11350|29|350|0.01|41
N|N0003|200106|NMI|11|21|17|5888|0|5888|0|2227|2881|580|200|0|0.064|0.0667|4313|0.0145|18|1575|13|||
N|N0003|200106|NMK|11|21| 429|308307|100|307707|400|114811|128594|41825|22677|200|0.0157|0.0191|97748|0.016|23|190283|18|20076|0.0143|28
N|N0003|200106|NMKPRK|11|21|3|100|0|100|0|100|0|0|0|0|0.75|0.75||||100|9|||
N|N0003|200106|NMT|11|21|14|5072|0|5072|0|507|4032|133|400|0|0.0567|0.0602|2876|0.023|19|2196|23|||
N|N0003|200106|NPC|11|21|11|2425|0|2425|0|798|1627|0|0|0|0.0346|0.0694|927|0.0578|14|1498|14|||
N|N0003|200106|NPV|11|21|18|8346|0|8346|0|2790|3706|1850|0|0|0.0819|0.0865|4223|0.0241|20|3823|17|300|0.01|13
N|N0003|200106|NQF|11|21|16|8197|0|8197|0|3319|3533|1145|0|200|0.0463|0.0506|4778|0.0118|32|3419|10|||
N|N0003|200106|NQS|11|21|21|13224|0|13224|0|3268|6571|3385|0|0|0.0347|0.0344|3655|0.0223|23|9235|17|334|0.04|32
N|N0003|200106|NSH|11|21|57|6351|0|6351|0|1216|4108|927|100|0|0.0297|0.0711|3151|0.0624|19|3200|18|||
N|N0003|200106|NSI|11|21|998|206016|700|204916|400|81854|88750|26478|8134|100|0.0272|0.053|78530|0.0423|19|115118|14|11668|0.0455|29
N|N0003|200106|NTC|11|21|15|7856|0|7856|0|2683|4673|500|0|0|0.0712|0.0692|5213|0.0129|16|2643|12|||
N|N0003|200106|NUT|11|21|16|5170|0|5170|0|713|3916|541|0|0|0.0622|0.0767|3509|0.0365|19|1548|11|113|0.05|9
N|N0003|200106|NVN|11|21|30|17595|0|17595|0|3541|10820|1951|1283|0|0.0499|0.0528|6675|0.015|21|10105|23|815|0.0316|14
N|N0003|200106|OAT|11|21|1738|570965|4200|565465|1300|270878|204505|62275|28792|315|-0.0035|0.0499|293935|0.0578|17|213478|13|59352|0.0588|21
N|N0003|200106|OCN|11|21|173|44482|122|44160|200|11948|15964|8555|7893|0|0.0258|0.0487|16847|0.0378|38|24518|33|2995|0.0362|41
N|N0003|200106|OECPRT|11|21|12|8598|0|8598|0|5028|2770|600|200|0|0.3548|0.3758|5885|0.0151|16|2713|9|||
N|N0003|200106|OFC|11|21|172|44336|0|44336|0|7456|16953|9168|10759|0|0.0255|0.0313|17630|0.0546|51|22481|36|4225|0.0178|24
N|N0003|200106|OFCPRB|11|21|16|4268|0|4268|0|240|1775|1155|700|398|0.0107|0.0926|2050|0.1197|37|2118|122|100|0.05|65
N|N0003|200106|OFCPRE|11|21|10|4805|0|4805|0|700|1725|1130|1150|100|0.1199|0.1068|2310|0.0747|57|2195|46|300|0.03|11
N|N0003|200106|OH|11|21| 63|34617|140|34377|100|9919|17741|4045|2772|0|0.0228|0.0328|14906|0.0318|32|19248|18|323|0.0286|89
N|N0003|200106|OI|11|21|398|74739|0|74739|0|33123|30579|7601|3436|0|0.0189|0.0219|24529|0.0238|16|47287|16|2923|0.0227|21
N|N0003|200106|OIPRA|11|21|23|16193|100|16093|0|2270|6602|2439|4282|500|0.0701|0.1128|7247|0.0299|73|7547|45|1299|0.0585|54
N|N0003|200106|OMG|11|21|512|189051|1000|186551|0|54715|91492|27624|12720|0|-0.0421|0.0607|70167|0.0623|23|97105|18|19279|0.0554|29
N|N0003|200106|OMI|11|21|346|107087|500|106087|300|26099|48534|18229|13525|0|0.0089|0.0552|41150|0.0578|29|56474|24|8763|0.0579|42
N|N0003|200106|ONE|11|21| 4404|2557497|1921|2549239|4900|1590050|761410|159619|42657|403|0.0085|0.0277|1132248|0.0266|12|1085876|9|336015|0.0315|15
N|N0003|200106|ONEPRB|11|21|1|400|0|400|0|0|200|0|200|0|1.4375|2.3875|200|0.55|91|200|18|||
N|N0003|200106|ONEPRC|11|21|1|100|0|100|0|0|0|0|100|0|1.5|2|100|1|83|||||
N|N0003|200106|ONEPRT|11|21| 27|29362|0|29362|0|13993|11061|3728|580|0|0.074|0.0822|11554|0.0415|15|16908|15|900|0.0289|13
N|N0003|200106|ONEPRU|11|21|25|17827|0|17827|0|6895|7268|3264|400|0|0.0987|0.1008|7272|0.0373|19|10355|15|200|0.05|22
N|N0003|200106|ONEPRV|11|21|29|23722|0|23722|0|10722|12220|400|380|0|0.0926|0.0884|13172|0.031|12|9650|13|900|0.0311|19
N|N0003|200106|OSI|11|21| 620|248089|2075|245714|300|63505|109163|44599|28147|600|0.0081|0.0554|102160|0.0585|31|123370|21|20484|0.0677|33
N|N0003|200106|OTL|11|21|172|33973|0|33973|0|8320|18238|7115|300|0|0.0312|0.1038|11952|0.0549|18|17721|15|4300|0.2072|34
N|N0003|200106|OWC|11|21|186|97564|400|97164|0|51956|36885|6365|1958|0|0.02|0.0286|25059|0.0166|13|64887|11|7218|0.0214|26
N|N0003|200106|PAG|11|21| 94|38597|0|38597|0|14405|16254|5316|2622|0|0.0254|0.0262|13760|0.0177|24|24337|16|500|0.016|16
N|N0003|200106|PAR|11|21|24|8752|0|8752|0|2836|4398|1118|400|0|0.0426|0.0644|3723|0.049|17|4629|33|400|0.0425|17
N|N0003|200106|PAS|11|21|602|116739|596|115743|0|32186|50278|20265|12755|259|0.017|0.0361|55329|0.0333|31|57869|26|2545|0.0876|29
N|N0003|200106|PCEPR|11|21|24|7237|0|7237|0|1438|3578|1621|600|0|0.1028|0.1203|2378|0.0377|23|4459|27|400|0.0825|15
N|N0003|200106|PCEPRA|11|21|20|19235|0|19235|0|4495|7684|3786|3070|200|0.1077|0.1339|6197|0.0854|34|12438|40|600|0.0767|103
N|N0003|200106|PCL|11|21|360|207041|0|205966|800|82550|84819|26006|12302|1289|0.0254|0.0518|79822|0.0285|32|112427|17|14517|0.0474|59
N|N0003|200106|PCT|11|21|28|10980|0|10980|0|1755|5233|2274|1718|0|0.0865|0.1086|4575|0.0492|32|6405|31|||
N|N0003|200106|PDE|11|21|2030|311176|2700|307576|900|153759|109523|33382|11412|400|0.0022|0.0241|146622|0.0338|16|130255|11|31599|0.0309|23
N|N0003|200106|PECPRX|11|21|10|9116|0|9116|0|3045|5421|650|0|0|0.2263|0.253|6766|0.2323|14|2250|16|100|0.2|13
N|N0003|200106|PEP|11|21| 4234|3961781|3610|3935924|19800|1877493|1559852|407217|111162|0|0.0043|0.0169|2074843|0.0276|16|1458336|12|422545|0.0302|20
N|N0003|200106|PER|11|21|455|147898|1311|146587|0|54071|50664|20863|20325|664|0.0339|0.0494|60502|0.0331|30|70966|23|15119|0.0414|37
N|N0003|200106|PFP|11|21| 6|4346|0|4346|0|611|3014|223|498|0|0.1608|0.2408|2737|0.1043|23|1609|22|||
N|N0003|200106|PFPPR|11|21|4|1998|0|1998|0|456|1542|0|0|0|0.2503|0.3709|1060|0.1181|14|938|3|||
N|N0003|200106|PG|11|21| 4658|3286058|7562|3265296|10900|1994720|980155|234132|65839|1200|0.0104|0.0383|1509114|0.0338|12|1185301|9|581781|0.0453|20
N|N0003|200106|PGF|11|21|14|3127|0|3127|0|400|2227|500|0|0|0.0715|0.1322|200|0.1|37|2927|16|||
N|N0003|200106|PGN|11|21|1717|803192|1050|800855|1100|395029|308406|70143|26814|1563|0.0002|0.0442|356946|0.0318|16|362495|12|82514|0.0394|21
N|N0003|200106|PHA|11|21| 3943|2625800|5054|2615898|2300|1194257|945635|349082|129224|0|0.0004|0.0269|1208326|0.0303|19|1030728|13|379144|0.0395|26
N|N0003|200106|PII|11|21|327|102532|100|102432|0|41394|47177|10024|3837|0|-0.0108|0.0656|43817|0.0617|19|50009|14|8606|0.067|21
N|N0003|200106|PIK|11|21|46|3575|0|3575|0|200|1904|349|1122|0|0.0443|0.048|2316|0.061|22|1092|112|167|0.02|177
N|N0003|200106|PIM|11|21|103|49075|0|49075|0|24946|18678|4419|1032|0|0.021|0.0231|15250|0.0101|15|31123|13|2702|0.0172|21
N|N0003|200106|PIO|11|21| 95|20834|0|20834|0|4049|12496|3547|742|0|0.2372|0.1999|15381|0.3664|19|5353|24|100|0.03|57
N|N0003|200106|PKE|11|21|363|119484|100|119384|0|37310|62636|13909|5529|0|-0.0061|0.0536|51032|0.0518|20|59311|16|9041|0.0835|42
N|N0003|200106|PKG|11|21|348|146975|435|146340|200|34426|54415|28787|26474|2438|0.0148|0.0363|71171|0.0341|45|66334|34|9035|0.0866|51
N|N0003|200106|PKX|11|21|454|142771|0|142226|200|41939|72365|20160|7962|0|0.013|0.0222|67854|0.0374|22|71279|18|3293|0.0316|36
N|N0003|200106|PLP|11|21|18|20783|0|20783|0|6623|11908|1872|380|0|0.0666|0.0736|9234|0.0405|19|9569|14|1980|0.048|16
N|N0003|200106|PNP|11|21|290|77419|0|77419|0|21873|46990|6414|2142|0|0.0365|0.0584|39478|0.0455|17|35119|13|2822|0.0368|27
N|N0003|200106|PNW|11|21|1193|470049|2100|467443|400|193183|212965|42984|18311|400|-0.0151|0.0449|244484|0.0442|17|188356|15|35003|0.0463|22
N|N0003|200106|PPD|11|21| 354|203099|1025|199574|2500|50324|81817|41329|28104|500|0.0156|0.0512|76073|0.06|40|105458|21|20543|0.056|41
N|N0003|200106|PPP|11|21| 900|218104|600|217504|0|90001|84657|30380|12466|0|-0.0018|0.0533|86443|0.0541|21|107964|17|23097|0.0719|22
N|N0003|200106|PPPPRQ|11|21|92|1220|0|1220|0|0|340|750|130|0|1.2195|1.2508|400|0.461|62|820|29|||
N|N0003|200106|PTV|11|21| 840|421537|524|420713|300|130636|203286|64391|22600|100|0.0084|0.0255|219254|0.0309|20|179782|19|21977|0.0307|20
N|N0003|200106|PX|11|21|2089|968093|4342|962551|400|391045|431840|105022|34611|433|0.0036|0.0323|517464|0.0384|17|360536|15|84951|0.0418|20
N|N0003|200106|RCL|11|21|635|192609|1279|191130|200|73260|79569|27645|10856|0|0.01|0.0309|71595|0.0366|23|106888|15|12847|0.0291|21
N|N0003|200106|RCN|11|21|583|26769|0|26769|0|7428|11535|3395|4411|0|0.0761|0.13|9038|0.0576|40|14081|20|3650|0.0453|33
N|N0003|200106|RG|11|21|1362|70949|0|70949|0|19784|28138|8150|13587|1290|0.0487|0.0507|16009|0.0463|71|42135|29|12805|0.0254|64
N|N0003|200106|RHB|11|21| 366|256151|6400|249751|0|54702|103946|53430|37673|0|0.0063|0.1091|117310|0.0835|36|102790|26|29651|0.1028|46
N|N0003|200106|RHD|11|21|390|166190|100|165990|0|55871|81814|20848|7457|0|0.0146|0.0431|76146|0.0406|19|82195|17|7649|0.0406|25
N|N0003|200106|RHI|11|21| 995|438400|1243|436357|800|200230|165695|49195|21787|250|0.0035|0.0378|212536|0.0402|18|187120|13|37501|0.0493|32
N|N0003|200106|RJF|11|21|528|179628|1970|177558|100|59606|69661|26503|21888|0|0.0153|0.0605|84064|0.0491|26|80046|18|13548|0.063|43
N|N0003|200106|RL|11|21|555|188977|400|187027|1200|51875|75446|38251|22355|300|0.0187|0.0584|80017|0.0683|29|84714|25|23496|0.0661|31
N|N0003|200106|RMG|11|21|154|76807|0|76807|0|31060|36138|8459|1150|0|0.0365|0.0786|40447|0.0656|14|32940|14|3420|0.0411|29
N|N0003|200106|RML|11|21|366|65767|851|64916|0|15388|24785|9913|14430|400|0.0185|0.0323|25040|0.0345|54|36262|32|3614|0.036|68
N|N0003|200106|RNS|11|21| 4|3105|0|3105|0|1535|1370|200|0|0|-0.0113|0.1214|2105|0.1211|11|1000|14|||
N|N0003|200106|ROP|11|21|321|119636|1400|118236|0|31245|46507|21949|17566|969|-0.0259|0.0654|52276|0.0767|37|54041|26|11919|0.076|60
N|N0003|200106|ROS|11|21|78|8810|0|8810|0|5900|2210|500|200|0|0.0236|0.0264|4960|0.0191|11|3850|15|||
N|N0003|200106|ROV|11|21| 443|280099|300|278999|800|121057|99650|39115|18932|1045|0.0341|0.0251|165982|0.0469|20|98628|16|15189|0.0513|69
N|N0003|200106|RS|11|21|214|74715|300|74415|0|17112|35972|16048|5283|0|0.0392|0.0486|37850|0.0445|24|31898|21|4667|0.0411|26
N|N0003|200106|RSC|11|21| 76|35415|0|35415|0|8219|17055|6911|3230|0|0.0579|0.1382|19992|0.0862|25|13593|24|1830|0.1025|40
N|N0003|200106|RTP|11|21|145|45752|200|45552|0|14891|21771|6917|1973|0|0.0728|0.4891|17391|0.1724|22|23561|14|4600|0.5028|31
N|N0003|200106|RWT|11|21|198|52267|0|52267|0|18388|19210|10069|4600|0|0.0662|0.0721|25393|0.0563|23|24774|18|2100|0.0438|14
N|N0003|200106|RWTPRB|11|21|5|1638|0|1638|0|100|1288|100|150|0|-0.0472|0.0114|1239|0.599|39|399|13|||
N|N0003|200106|RYN|11|21|669|128546|700|127446|0|34511|58160|23802|10373|600|0.0047|0.0552|52145|0.0532|29|64697|21|10604|0.0443|37
N|N0003|200106|RZT|11|21|212|44179|0|44079|100|16442|21497|5031|1209|0|-0.0017|0.0511|18311|0.046|16|23659|13|2209|0.09|34
N|N0003|200106|SACPR|11|21|3|700|0|700|0|0|0|200|500|0|0.5386|1.1014||||700|86|||
N|N0003|200106|SACPRT|11|21| 8|2493|0|2493|0|320|1463|300|410|0|0.1159|0.2151|413|0.1299|17|1980|41|100|0.1|16
N|N0003|200106|SAIPRW|11|21|13|17471|0|17471|0|9608|6338|1125|400|0|0.0927|0.0907|5971|0.0183|14|11400|15|100|0.03|7
N|N0003|200106|SBG|11|21|40|23981|0|23981|0|9947|6542|3638|3554|300|0.0214|0.0256|12268|0.0161|38|11713|39|||
N|N0003|200106|SC|11|21|944|171378|1200|169328|600|35189|66402|34353|32589|1295|0.0253|0.0425|67572|0.0423|115|82345|33|20011|0.0432|74
N|N0003|200106|SCG|11|21|660|174445|1450|172995|0|36451|63067|41038|31401|1038|0.0215|0.0434|73380|0.0352|39|85091|31|14524|0.0479|57
N|N0003|200106|SCL|11|21|36|4080|0|4080|0|797|977|1156|1007|143|0.0229|0.1141|1361|0.0648|33|2719|95|||
N|N0003|200106|SCX|11|21|13|5156|0|5156|0|1378|1806|500|1472|0|0.0984|0.1732|871|0.1332|41|4185|42|100|0.14|18
N|N0003|200106|SCZ|11|21|365|93540|0|93440|100|37105|43330|8965|4140|0|0.0186|0.0246|42050|0.032|19|49810|15|1680|0.0214|19
N|N0003|200106|SCZA|12|21| 7|1667|270|1397|0|450|430|200|317|0|-3.8031|6.7545|317|1|165|1080|17|||
N|N0003|200106|SDH|11|21| 84|41816|0|41816|0|18699|18351|3596|1170|0|0.0156|0.0167|12656|0.0124|16|28810|12|350|0.0243|60
N|N0003|200106|SGH|11|21|66|6168|0|6168|0|1085|2758|1200|1125|0|0.1017|0.1265|2783|0.0408|37|3000|41|385|0.033|9
N|N0003|200106|SGI|11|21|298|72667|350|72017|300|24900|32188|9337|5892|0|0.0092|0.013|22488|0.0123|20|46559|19|3270|0.0143|58
N|N0003|200106|SGR|11|21|1534|1299132|35974|1259458|2700|574617|455207|144340|85394|2700|-0.0187|0.0949|654440|0.1078|20|422851|13|184867|0.1534|37
N|N0003|200106|SGU|11|21| 91|102190|475|101715|0|24400|44647|16278|15490|900|0.0525|0.0787|50870|0.0602|40|46623|28|4222|0.0301|56
N|N0003|200106|SII|11|21| 3969|2461601|89352|2366784|2800|708230|989797|446578|224144|835|-0.0217|0.1034|1098122|0.0831|23|658194|17|613268|0.1146|34
N|N0003|200106|SLC|11|21|1746|102521|0|102521|0|31777|51814|14017|4913|0|0.0465|0.0498|39662|0.0221|22|51426|15|11433|0.021|27
N|N0003|200106|SLI|11|21|194|40617|418|39999|200|9667|16424|8563|5445|100|0.0376|0.0584|15844|0.0585|43|20722|21|3633|0.0345|53
N|N0003|200106|SO|11|21|2151|1830209|2000|1815354|11800|580083|787613|325490|133214|754|0.007|0.0234|654768|0.0233|25|930696|18|241690|0.0333|29
N|N0003|200106|SOPRA|11|21|28|16715|0|16715|0|3470|8827|1949|2469|0|0.0601|0.0665|4028|0.0293|35|11087|27|1600|0.0338|30
N|N0003|200106|SOPRB|11|21|16|17925|0|17925|0|5235|6861|2834|2995|0|0.0985|0.0985|10104|0.042|50|7421|23|400|0.0375|42
N|N0003|200106|SOPRC|11|21|17|16462|0|16462|0|2966|8671|3400|1425|0|0.0695|0.0901|6935|0.0333|27|8927|25|600|0.0367|33
N|N0003|200106|SP|11|21| 417|417878|20700|395978|1000|88276|173307|84940|49425|1030|-0.1028|0.2098|199842|0.171|26|116566|21|80570|0.2007|41
N|N0003|200106|SPN|11|21|315|100444|325|100119|0|31571|45383|12267|10898|0|0.017|0.0288|43292|0.0424|30|56427|21|400|0.015|91
N|N0003|200106|SPP|11|21|132|51056|0|50756|300|10669|25951|9287|5149|0|0.035|0.0357|20559|0.0263|30|27662|21|2835|0.0104|42
N|N0003|200106|SRE|11|21|1917|776656|470|775086|1100|536186|219314|17703|2755|228|0.0072|0.0319|347116|0.0326|9|370017|8|59053|0.036|11
N|N0003|200106|SREPRA|11|21| 19|28661|0|28661|0|5688|17888|3435|1650|0|0.148|0.1707|17662|0.1052|21|10199|21|800|0.075|20
N|N0003|200106|SSD|11|21|195|35844|500|35344|0|9983|16926|5118|3317|0|0.0133|0.1372|17605|0.1104|33|13239|17|4500|0.1138|32
N|N0003|200106|SSR|11|21|30|19430|0|19430|0|3254|10127|4436|1013|600|0.0853|0.0911|7555|0.0238|45|11475|28|400|0.035|22
N|N0003|200106|STZ|11|21| 610|339807|2000|337207|600|85800|149849|59664|42094|400|-0.0029|0.0667|138641|0.0823|34|166570|25|32596|0.0947|42
N|N0003|200106|STZB|12|21|8|624|0|624|0|0|0|0|624|0|1.8974|2.1795||||400|153|224|0.25|294
N|N0003|200106|SUR|11|21|167|31393|0|31393|0|11609|15609|2915|1260|0|0.0568|0.0639|12522|0.0329|17|17749|15|1122|0.04|22
N|N0003|200106|SUT|11|21| 91|35284|0|35084|0|12819|18577|3588|100|0|0.0201|0.0223|16575|0.0263|15|17409|13|1100|0.0291|14
N|N0003|200106|SUTPRA|11|21|11|10131|0|10131|0|1975|6048|2008|100|0|0.0368|0.1397|5027|0.083|25|5104|15|||
N|N0003|200106|SVAPR|11|21| 4|3315|0|3315|0|200|1775|1340|0|0|0.0515|0.1859|1185|0.0888|22|1930|29|200|0.05|13
N|N0003|200106|SWM|11|21|152|25116|100|25016|0|8271|12267|3269|1209|0|0.0461|0.0897|9365|0.0636|26|13651|16|2000|0.075|24
N|N0003|200106|SZ|11|21|13|2987|0|2987|0|0|1937|900|150|0|0.0285|0.0453|500|0.03|30|2487|36|||
N|N0003|200106|TAPPRA|11|21| 31|40656|0|40656|0|9089|25026|6266|275|0|0.0569|0.0587|14590|0.0156|21|25766|17|300|0.03|15
N|N0003|200106|TAPPRB|11|21| 7|5637|0|5637|0|628|4379|630|0|0|0.1076|0.112|4215|0.0363|18|1222|10|200|0.04|11
N|N0003|200106|TCC|11|21|135|33038|0|32738|300|5154|13144|8508|6232|0|0.0327|0.0487|15161|0.0428|44|15526|27|2351|0.0516|33
N|N0003|200106|TCH|11|21|28|10532|0|10532|0|1828|7022|700|982|0|0.066|0.0697|2692|0.0298|26|7640|21|200|0.05|0
N|N0003|200106|TCLPR|11|21|15|6611|0|6611|0|2911|3700|0|0|0|0.1029|0.1033|1800|0.0339|16|4811|11|||
N|N0003|200106|TCR|11|21|451|64034|0|64034|0|13892|25318|11708|12916|200|0.0298|0.0366|20925|0.0261|44|38017|34|5092|0.0244|58
N|N0003|200106|TD|11|21|2357|84704|200|84504|0|26904|43499|9309|4792|0|0.0325|0.0518|30355|0.0191|20|40045|14|14104|0.0498|25
N|N0003|200106|TDI|11|21| 4|5012|0|5012|0|850|2266|1175|721|0|0.0014|0.177|2011|0.0975|46|3001|24|||
N|N0003|200106|TDR|11|21|27|4930|0|4930|0|160|4120|450|200|0|0.1722|0.1429|3070|0.0602|24|1860|18|||
N|N0003|200106|TDY|11|21|248|111666|327|111339|0|39645|56089|11267|4338|0|0.0014|0.0325|46693|0.0382|21|60096|14|4550|0.0372|18
N|N0003|200106|TEE|11|21|190|93634|194|93440|0|38091|39954|10290|5205|0|0.0724|0.0979|55764|0.0522|17|33575|17|4101|0.0442|24
N|N0003|200106|TEF|11|21|1065|396187|0|395605|100|185332|137753|47922|24698|0|0.0348|0.0489|199060|0.031|21|167710|14|28935|0.0439|27
N|N0003|200106|TEM|11|21|4|975|0|975|0|375|200|400|0|0|0.2018|0.2467|300|0.1167|11|675|25|||
N|N0003|200106|TEN|11|21|140|70065|0|70065|0|20950|30885|10353|7877|0|0.0257|0.0338|26121|0.0405|24|39987|23|3957|0.0298|12
N|N0003|200106|TFS|11|21|415|145212|800|143612|800|41861|68860|23910|9781|0|0.0099|0.0531|57459|0.0478|23|76318|19|10635|0.0542|23
N|N0003|200106|TGT|11|21| 4524|3240598|7313|3215448|13900|1249034|1213942|478651|281570|6151|0.0055|0.0267|1754183|0.0402|22|1020458|16|454707|0.0506|33
N|N0003|200106|THX|11|21|424|138946|400|137546|600|38790|53171|27131|18274|780|-0.0272|0.0806|45773|0.104|35|75898|24|16475|0.1466|48
N|N0003|200106|TI|11|21|309|58047|100|57847|100|5609|27586|14591|9798|363|0.2277|0.3006|31788|0.331|46|23256|24|2903|0.1905|36
N|N0003|200106|TIA|12|23|2|3300|2600|700|0|0|0|0|700|0|-6.14|2.68||||700|208|||
N|N0003|200106|TLI|11|21|25|18393|0|18393|0|5914|7198|3215|2066|0|0.0338|0.0413|4007|0.0171|38|13686|23|700|0.0357|23
N|N0003|200106|TLK|11|21|59|9060|0|9060|0|1072|5706|1383|899|0|0.0163|0.0239|6138|0.0201|21|2922|33|||
N|N0003|200106|TOL|11|21| 789|345725|1300|343187|300|106434|153897|54404|28752|0|0.0221|0.0455|141820|0.0581|27|171803|19|29864|0.0657|25
N|N0003|200106|TR|11|21|468|189915|1800|188115|0|37995|79907|42395|26708|1110|0.0162|0.0758|79587|0.0422|37|92597|28|15931|0.1202|54
N|N0003|200106|TRA|11|21|154|53919|100|53619|200|18468|22849|10610|1892|200|0.013|0.0187|18222|0.0285|24|34022|21|1575|0.0225|27
N|N0003|200106|TRP|11|21|628|40568|300|39968|300|18516|17508|3049|1195|0|0.0232|0.0269|17545|0.0144|14|22113|14|610|0.0166|13
N|N0003|200106|TRPPR|11|21|26|18352|0|18352|0|6762|8990|2100|500|0|0.0461|0.0513|8625|0.0222|22|9527|12|200|0.03|10
N|N0003|200106|TRPPRC|11|21| 9|6352|0|6352|0|3210|2942|200|0|0|0.0645|0.0643|2510|0.0303|14|3842|11|||
N|N0003|200106|TTR|11|21|10|6839|0|6839|0|4785|1668|386|0|0|0.058|0.0552|1506|0.0338|10|5333|9|||
N|N0003|200106|TWE|11|21|779|116045|212|115233|600|36782|50391|20674|7986|0|0.0133|0.0223|38403|0.0222|28|69540|19|7890|0.0292|31
N|N0003|200106|TWK|11|21|401|62550|426|62124|0|17218|21312|10709|12585|300|0.0112|0.0307|32607|0.0461|34|27617|38|1900|0.0442|41
N|N0003|200106|TX|11|21| 4866|2376297|9060|2363465|2500|1397168|761431|163587|43779|0|0.0131|0.0354|1075238|0.0369|12|866775|10|423952|0.0385|15
N|N0003|200106|TXCPRA|11|21| 28|35819|0|35819|0|20100|13164|1840|615|100|0.0692|0.0725|12355|0.0141|13|22764|13|700|0.0557|15
N|N0003|200106|TXCPRB|11|21| 9|7489|0|7489|0|2855|3884|600|150|0|0.1133|0.1246|3550|0.0445|12|3739|19|200|0.01|22
N|N0003|200106|TXN|11|21|10154|7538253|101229|7394161|34500|2539737|2403485|1376649|1086906|21884|-0.0069|0.0401|3888049|0.0556|27|1778802|21|1761810|0.066|43
N|N0003|200106|UIS|11|21|1661|863380|300|860260|2600|520238|271865|59247|11158|352|0.0019|0.0169|410722|0.0227|12|392168|9|59970|0.0259|19
N|N0003|200106|VAP|11|21|10|5620|0|5620|0|1085|2560|500|1475|0|0.0876|0.0888|4035|0.0313|40|1485|25|100|0.02|11
N|N0003|200106|VBF|11|21|57|20011|0|20011|0|4270|7857|4087|3597|200|0.0555|0.0668|10578|0.0362|41|9233|30|200|0.02|320
N|N0003|200106|VEA|11|21|13|17329|0|17329|0|5199|9135|2195|800|0|0.0635|0.0988|8620|0.0473|19|8309|17|400|0.04|15
N|N0003|200106|VELPRT|11|21|22|9565|0|9565|0|3225|5640|600|100|0|0.1076|0.1207|5245|0.0358|15|4020|10|300|0.07|21
N|N0003|200106|VGM|11|21|18|5974|0|5974|0|2694|2750|530|0|0|0.0373|0.0349|3386|0.0109|14|2588|12|||
N|N0003|200106|VGR|11|21|280|95521|600|94921|0|26817|43606|15460|8788|250|0.0653|0.1196|39410|0.111|32|46153|19|9358|0.0972|28
N|N0003|200106|VIG|11|21| 7|2057|0|2057|0|389|1668|0|0|0|0.03|0.0391|800|0.0125|10|1157|10|100|0.01|13
N|N0003|200106|VIN|11|21|15|6807|0|6807|0|2456|1434|892|2025|0|0.0319|0.0312|2010|0.013|41|4797|48|||
N|N0003|200106|VIT|11|21|27|12624|0|12624|0|7444|4875|305|0|0|0.036|0.0359|6412|0.0114|11|5887|8|325|0.01|8
N|N0003|200106|VNV|11|21|13|2270|0|2270|0|780|1190|300|0|0|0.0572|0.0457|538|0.01|26|1732|10|||
N|N0003|200106|VOD|11|21|1999|1514065|2700|1506152|4300|792257|578419|118150|21426|200|0.0127|0.0158|842187|0.0218|14|579386|10|88879|0.0263|17
N|N0003|200106|VOL|11|21|105|20551|0|20551|0|5757|10161|2999|1534|100|0.0559|0.0808|10322|0.0528|27|8844|20|1385|0.0453|26
N|N0003|200106|VOT|11|21|13|6573|0|6573|0|2658|3686|229|0|0|0.0452|0.0539|2850|0.0175|15|2968|10|755|0.01|23
N|N0003|200106|VPA|11|21|10|9050|0|9050|0|1907|5339|1300|504|0|0.0648|0.0632|5957|0.0343|22|3093|18|||
N|N0003|200106|VPQ|11|21|14|8868|0|8868|0|2747|4560|686|875|0|0.0484|0.0517|3903|0.0212|19|4965|23|||
N|N0003|200106|VRC|11|21|1533|721772|1186|719800|600|264831|294864|105814|54891|0|-0.0091|0.045|286261|0.0307|21|317784|20|116355|0.0471|28
N|N0003|200106|VSH|11|21|1627|439313|1600|434513|3200|160494|181677|67281|28161|100|0.0057|0.0236|201249|0.0324|22|186762|16|49702|0.0348|26
N|N0003|200106|VVC|11|21|657|178642|300|178342|0|45864|72830|35634|23102|912|0.0164|0.0386|69059|0.0436|36|101042|24|8241|0.0549|69
N|N0003|200106|VVR|11|21|157|83284|0|83284|0|28751|37822|13076|3635|0|0.0123|0.013|15688|0.0125|22|66309|18|1287|0.01|29
N|N0003|200106|WFR|11|21|225|55333|0|55133|200|19295|21918|7154|6214|752|0.0271|0.0502|20319|0.0448|40|31596|17|3418|0.0496|22
N|N0003|200106|WG|11|21|122|43323|200|43123|0|7887|16391|10247|8498|100|0.0451|0.0786|26932|0.0573|40|12256|37|3935|0.0413|33
N|N0003|200106|WLP|11|21|2061|613165|3600|607565|1800|224212|285602|70528|28442|581|0.0052|0.0537|307476|0.0591|19|225772|15|76117|0.0715|21
N|N0003|200106|WNI|11|21|4|620|0|620|0|100|320|200|0|0|0.029|0.0194|420|0.0333|11|200|39|||
N|N0003|200106|WSM|11|21| 924|335089|7400|327689|0|107654|147769|43968|28298|0|-0.02|0.0431|146297|0.0509|24|138437|17|42955|0.0611|38
N|N0003|200106|WTS|11|21|121|25867|0|25867|0|9094|10894|4105|1774|0|0.0222|0.0725|13047|0.0591|24|12620|23|200|0.01|8
N|N0003|200106|XRX|11|21|2266|1563755|1500|1551990|9300|899430|518310|111272|32278|0|0.0048|0.0141|589903|0.0185|14|835374|9|136013|0.0244|21
N|N0003|200106|XVF|11|21| 86|63667|300|63367|0|20329|30220|10193|2625|0|0.1756|0.2107|36209|0.0865|21|24028|17|3130|0.1246|6
N|N0003|200106|YLD|11|21|61|13280|0|13280|0|5464|4515|2276|1025|0|0.0185|0.0193|3096|0.0162|19|9884|23|300|0.01|7
N|N0003|200106|YUM|11|21|1648|681270|15304|663764|1800|124966|222082|150777|158519|9220|-0.0154|0.025|322286|0.0381|48|259741|38|83537|0.0503|67
N|N0003|200106|ZIF|11|21|23|9335|0|9335|0|3943|4592|700|100|0|0.0331|0.0384|4741|0.018|12|4594|17|||
N|N0003|200106|ZMX|11|21| 5|2620|0|2620|0|0|1999|353|268|0|0.0441|0.0335|1979|0.0469|24|641|47|||'

	EXEC -t'|' -k 4,4 -lsum,regress,op=sum:float:17 $data/nyse.dat
		OUTPUT - $'N|N0003|200106|AA|11|21|14596|3524300|9331|3494983|15500|1129332|1283396|639798|452298|5659|      21|0.0289|1717663|0.038|30|1195358|20|597462|0.0481|35
N|N0003|200106|AAT|11|21|48|14046|0|14046|0|7421|4549|1485|591|0|       0|0.0304|2513|0.01|25|11333|14|200|0.01|90
N|N0003|200106|ABJ|11|21|57|14508|0|14508|0|2603|9175|1650|1080|0|      43|0.0779|6636|0.0136|17|7872|25|||
N|N0003|200106|ABS|11|21|7425|1465605|200|1461410|2900|483622|651665|241738|87165|120|       5|0.0284|599869|0.0306|22|670152|18|194289|0.0373|25
N|N0003|200106|ABT|11|21|14051|3368858|8904|3347422|10900|1469987|1273455|447558|166267|1055|      10|0.0273|1682138|0.0365|18|1150749|14|525435|0.044|25
N|N0003|200106|ACA|11|21|45|11490|0|11490|0|2845|7495|100|1050|0|     -12|0.0946|5052|0.0146|17|6438|22|||
N|N0003|200106|ACS|11|21|2456|523323|13500|509523|0|192518|202103|71973|42229|700|      79|0.0658|254514|0.0654|21|177869|17|77140|0.0915|38
N|N0003|200106|AEF|11|21|210|61757|0|61757|0|9524|22881|15536|13616|200|      -6|0.0464|24867|0.0137|47|35248|43|1642|0.0401|27
N|N0003|200106|AET|11|21|2439|472785|900|471531|300|213068|162069|63465|32949|280|      24|0.0217|214120|0.0315|22|224763|16|32948|0.035|26
N|N0003|200106|AGC|11|21|6689|1443428|2747|1438956|1000|588445|574302|188125|88940|0|       3|0.0283|603123|0.0256|22|661220|16|175613|0.0329|31
N|N0003|200106|AGCPRA|11|21|56|16339|0|16339|0|3810|5914|4990|1625|0|      18|0.1187|7461|0.11|44|8678|25|200|0.085|8
N|N0003|200106|AGCPRB|11|21|25|6853|0|6853|0|100|3855|1550|1348|0|      43|0.115|3097|0.0587|44|3756|46|||
N|N0003|200106|AGCPRM|11|21|57|15702|100|15602|0|1685|7911|3046|2170|790|     -23|0.0876|4071|0.0247|64|11031|65|500|0.078|166
N|N0003|200106|AGCPRMCL|11|21|4|1223|0|1223|0|0|923|300|0|0|      17|0.04|1223|0.01|22|||||
N|N0003|200106|AGCPRN|11|21|82|18338|0|18338|0|5186|8423|2223|2306|200|     -18|0.0967|2885|0.0334|65|15203|23|250|0.046|21
N|N0003|200106|AGCPRNCL|11|21|3|665|0|665|0|100|565|0|0|0|       8|0.01||||665|21|||
N|N0003|200106|AGI|11|21|23|4879|0|4879|0|730|2761|1388|0|0|      16|0.0238|4099|0.0433|19|780|29|||
N|N0003|200106|AHO|11|21|514|101764|100|101464|200|25120|56355|13898|6291|0|       4|0.061|51772|0.043|22|43731|19|6161|0.0371|23
N|N0003|200106|AIV|11|21|697|143764|0|143464|0|58036|56027|19187|10214|0|      -2|0.0629|54117|0.0484|20|80319|20|9028|0.0438|29
N|N0003|200106|AIVPRC|11|21|23|5998|0|5998|0|2025|2725|948|300|0|      -6|0.1098|2675|0.0259|25|3023|15|300|0.09|37
N|N0003|200106|AIVPRD|11|21|63|15180|0|15180|0|5430|8025|825|900|0|      24|0.1226|6105|0.0322|15|8975|24|100|0.04|12
N|N0003|200106|AIVPRG|11|21|45|12295|0|12295|0|3195|6435|1315|1350|0|      -7|0.0783|3675|0.0122|30|7920|24|700|0.0343|32
N|N0003|200106|AIVPRH|11|21|25|5959|0|5959|0|2100|3074|785|0|0|     -26|0.1345|2824|0.0322|13|3035|18|100|0.11|9
N|N0003|200106|AIVPRK|11|21|9|2070|0|2070|0|0|1070|600|400|0|       4|0.4413|1350|0.1863|48|720|20|||
N|N0003|200106|AIVPRP|11|21|56|11916|0|11916|0|3681|4873|2148|1214|0|      19|0.2129|3376|0.0379|23|8540|26|||
N|N0003|200106|AIVPRQ|11|21|39|10242|0|10242|0|3898|5497|327|520|0|      -2|0.0792|4613|0.0174|19|5629|13|||
N|N0003|200106|AJG|11|21|875|196649|600|196049|0|80999|79015|21230|12954|1851|      19|0.0426|79215|0.0366|26|106810|13|10024|0.0518|45
N|N0003|200106|ALM|11|21|38|9137|0|9137|0|300|7876|961|0|0|     -25|0.0618|7139|0.0245|19|1998|15|||
N|N0003|200106|ALPPRN|11|21|3|1290|0|1290|0|0|890|400|0|0|       1|0.181|400|0.05|16|890|21|||
N|N0003|200106|ALPPRO|11|21|6|1700|0|1700|0|0|1700|0|0|0|     -88|0.2247|950|0.0621|26|750|18|||
N|N0003|200106|ALPPRQ|11|21|28|7400|0|7400|0|2517|4483|400|0|0|       3|0.0795|3496|0.0287|17|3904|11|||
N|N0003|200106|ALPPRR|11|21|43|12186|0|12186|0|2223|8511|1152|300|0|     -22|0.0713|4546|0.0179|18|7540|15|100|0.04|63
N|N0003|200106|ALQ|11|21|53|14947|0|14947|0|5706|7091|2050|100|0|      15|0.0864|8607|0.0231|21|6040|12|300|0.01|7
N|N0003|200106|ALZ|11|21|38|10019|0|10019|0|800|8563|656|0|0|      39|0.1095|6749|0.0256|19|3270|13|||
N|N0003|200106|AMB|11|21|340|82057|0|81694|0|49345|26444|3944|1961|0|       3|0.029|37759|0.0248|12|40635|11|3300|0.0224|15
N|N0003|200106|AMBPRA|11|21|19|5460|0|5460|0|3560|1700|200|0|0|      16|0.1091|3300|0.0473|10|2160|13|||
N|N0003|200106|AMD|11|21|22321|4782471|105767|4655665|17300|1343670|1809871|952933|564656|1635|      14|0.0399|2160554|0.0464|24|1180503|21|1331908|0.0601|37
N|N0003|200106|ANN|11|21|1471|308613|7500|301013|100|160173|110558|25319|5063|0|      59|0.0525|131184|0.0608|13|134861|10|35068|0.0762|17
N|N0003|200106|AOC|11|21|3951|740421|1545|737685|900|213132|304297|146622|73959|575|      10|0.0241|340231|0.0367|28|337678|21|60676|0.0378|34
N|N0003|200106|ARB|11|21|432|81559|300|81259|0|24043|40724|12568|3924|0|      18|0.0549|39589|0.0546|22|36715|18|4955|0.0477|23
N|N0003|200106|ARH|11|21|9|1815|0|1815|0|400|1115|100|200|0|      -7|0.0527|1190|0.0182|31|625|19|||
N|N0003|200106|ATI|11|21|1153|204221|195|204026|0|95949|86063|15394|6520|100|      22|0.0249|88367|0.0285|16|109155|13|6504|0.0249|20
N|N0003|200106|AVP|11|21|5362|1025278|1664|1021714|1300|640871|320330|47980|12801|1032|      26|0.0305|463631|0.0358|10|466899|8|92484|0.0454|15
N|N0003|200106|AVZ|11|21|203|42999|0|42899|100|15985|19543|6471|1000|0|      26|0.1957|20702|0.1167|19|19355|14|2942|0.0663|19
N|N0003|200106|AXL|11|21|233|43442|0|43442|0|11343|20974|6885|4240|0|     -19|0.0834|21281|0.0732|30|20822|22|1339|0.0249|14
N|N0003|200106|AZA|11|21|4036|777156|5600|770456|500|475253|227074|51985|16512|132|      -4|0.0359|346051|0.0248|11|287853|9|137052|0.035|17
N|N0003|200106|AZZ|11|21|141|30688|0|30688|0|5454|17696|5938|1600|0|      42|0.0925|17081|0.0713|24|12107|24|1500|0.0293|20
N|N0003|200106|BC|11|21|1794|347438|2150|344388|900|119326|140853|55052|29034|1023|      28|0.0287|151059|0.0335|27|165409|19|28820|0.0421|28
N|N0003|200106|BCC|11|21|1261|232534|1500|231034|0|90880|102617|27338|10199|0|      32|0.0495|86498|0.0425|21|123377|15|21159|0.0489|20
N|N0003|200106|BD|11|21|132|26224|200|26024|0|8210|15964|1850|0|0|       0|0.0147|10370|0.0141|12|14654|13|1000|0.014|21
N|N0003|200106|BDF|11|21|39|9620|0|9620|0|3229|4243|1738|410|0|     -19|0.0565|2903|0.0136|13|6717|23|||
N|N0003|200106|BGG|11|21|774|164711|600|163823|0|76597|68590|14556|4080|0|      25|0.0874|65955|0.0439|16|85847|11|12021|0.0977|21
N|N0003|200106|BGT|11|21|60|15473|0|15473|0|8014|5024|1985|450|0|      10|0.0185|3385|0.01|10|12088|14|||
N|N0003|200106|BK|11|21|14814|3340606|5800|3332030|800|2109454|974660|195186|53530|0|      24|0.0372|1548826|0.0305|11|1273475|9|510529|0.0417|16
N|N0003|200106|BKE|11|21|104|18544|0|18544|0|3788|12093|2226|437|0|      34|0.0528|10301|0.0694|18|7843|20|400|0.035|15
N|N0003|200106|BKPRC|11|21|66|17897|0|17897|0|10855|5842|850|350|0|       8|0.0857|8767|0.0274|15|8630|11|500|0.028|7
N|N0003|200106|BKPRD|11|21|80|21826|0|21826|0|13055|7571|500|700|0|      13|0.0714|10371|0.0168|11|11155|14|300|0.08|18
N|N0003|200106|BKPRE|11|21|81|23243|0|23243|0|10876|10497|1470|400|0|      30|0.0832|15715|0.0205|15|7528|12|||
N|N0003|200106|BLI|11|21|1232|227952|1609|226143|100|75627|104943|33926|11747|0|      10|0.0263|112032|0.0332|20|104908|17|9303|0.0328|22
N|N0003|200106|BNI|11|21|6187|1206018|400|1203328|1600|680896|414696|85020|23178|1138|       0|0.0285|588392|0.0262|13|511908|10|104628|0.0403|19
N|N0003|200106|BR|11|21|7135|1378982|4900|1370416|2000|687207|493400|131614|58722|1473|      12|0.0302|782525|0.0406|16|459377|12|130514|0.0503|29
N|N0003|200106|BRG|11|21|56|11360|0|11360|0|2143|6614|1791|812|0|     -30|0.1699|6410|0.118|29|4850|22|100|0.1|63
N|N0003|200106|BSP|11|21|25|4791|0|4791|0|1745|2537|509|0|0|      12|0.0835|2054|0.0143|14|2337|15|400|0.045|9
N|N0003|200106|BTY|11|21|1036|203914|400|203314|200|78459|82586|27485|14884|100|     102|0.1174|111376|0.0744|24|78300|16|13838|0.0657|24
N|N0002|200106|BTYRT|11|21|239|50506|0|50506|0|19517|24313|3320|3356|0|   -1206|0.1598|32175|0.1498|23|17731|14|600|0.055|20
N|N0003|200106|BWG|11|21|30|6512|0|6512|0|1183|4379|650|300|0|      -5|0.1734|4366|0.0936|24|2046|21|100|0.08|0
N|N0003|200106|BXS|11|21|157|33939|0|33939|0|14334|13818|5063|724|0|      13|0.0378|17439|0.042|14|15418|17|1082|0.0204|22
N|N0003|200106|BYD|11|21|166|35218|200|35018|0|8011|13121|6471|7115|300|       1|0.0426|12541|0.0321|37|19449|44|3028|0.0338|50
N|N0003|200106|BZL|11|21|10|2330|0|2330|0|1000|400|530|400|0|      -4|0.0748|1130|0.04|53|800|8|400|0.02|7
N|N0003|200106|C|11|21|36206|7798662|31303|7747379|16900|3563357|2481386|1113981|603003|2552|       1|0.0228|4246991|0.0389|19|2228824|15|1288464|0.0463|33
N|N0003|200106|CBM|11|21|983|194272|2240|191632|0|63286|89872|27044|11430|0|      83|0.1101|81401|0.0814|22|85841|16|24390|0.132|30
N|N0003|200106|CCC|11|21|209|43832|300|43532|0|9359|19019|8257|6297|600|      10|0.0488|20746|0.0443|44|20283|29|2503|0.0202|39
N|N0003|200106|CCPPRA|11|21|60|13025|0|13025|0|2350|7424|2707|544|0|     -52|0.3285|5751|0.0625|18|6774|26|500|0.058|17
N|N0003|200106|CCR|11|21|3630|728090|6800|719678|1000|267653|271128|122720|59077|100|      49|0.0301|346880|0.0381|22|277870|18|95928|0.0488|30
N|N0003|200106|CEA|11|21|10|2229|0|2229|0|300|1601|328|0|0|     -26|0.1549|928|0.031|17|1201|16|100|0.01|16
N|N0003|200106|CED|11|21|138|25925|300|25625|0|5812|12625|5838|1350|0|      16|0.108|13523|0.0484|25|10252|19|1850|0.043|36
N|N0003|200106|CEM|11|21|155|30385|0|30385|0|6560|16100|6125|1600|0|      -8|0.0917|15567|0.0682|23|13468|23|1350|0.0337|30
N|N0003|200106|CEN|11|21|498|110436|0|110236|200|45363|46318|11486|6969|300|      -8|0.0306|50010|0.0344|21|55025|14|5401|0.0262|38
N|N0003|200106|CF|11|21|3637|639764|3248|634316|1500|182374|248718|123189|77927|3608|       8|0.0254|286515|0.033|30|282454|22|66847|0.0282|49
N|N0003|200106|CFE|11|21|7|1684|0|1684|0|1300|100|284|0|0|     -38|0.1669|984|0.25|18|700|8|||
N|N0003|200106|CFN|11|21|16|4234|0|4234|0|1018|1116|1300|800|0|      -6|0.0828|1200|0.3967|71|3034|26|||
N|N0003|200106|CGPPRG|12|21|54|5400|4900|500|0|0|100|200|200|0|    -174|0.184|200|0.75|80|300|33|||
N|N0003|200106|CGPPRI|11|21|4|750|0|750|0|0|200|0|400|150|    -262|0.026|550|0.7182|511|200|23|||
N|N0003|200106|CGPPRT|11|21|38|9711|0|9711|0|3766|4598|1147|200|0|     -48|0.0734|2517|0.0372|15|7042|15|152|0.01|24
N|N0003|200106|CHD|11|21|606|132464|1359|131105|0|52672|55896|14149|7853|535|     -11|0.0634|55486|0.0467|19|68291|17|7328|0.0501|27
N|N0003|200106|CHH|11|21|242|54062|0|53762|0|17816|21767|9596|4583|0|       0|0.0552|26188|0.0734|31|23562|16|4012|0.0527|16
N|N0002|200106|CHTRT|11|21|12|3174|0|3174|0|160|0|320|2375|319|      23|0.0609|1735|0.0113|116|1439|198|||
N|N0002|200106|CHTRTWI|12|24|1|5000|0|5000|0|0|0|5000|0|0|     -12|0.04||||5000|31|||
N|N0003|200106|CIC|11|21|184|49613|0|49613|0|12025|25301|7518|4769|0|     -19|0.0656|15733|0.0419|22|33280|25|600|0.0533|62
N|N0003|200106|CIP|11|21|84|22418|0|22418|0|4677|16266|1050|425|0|     -23|0.0745|11685|0.0212|16|10033|16|700|0.0229|12
N|N0003|200106|CIR|11|21|339|57557|600|56957|0|24724|23479|6114|2640|0|      75|0.0568|31783|0.0736|16|21547|14|3627|0.1043|30
N|N0003|200106|CKC|11|21|157|29607|0|29607|0|9386|15183|3387|1651|0|     -67|0.0255|7241|0.0637|30|21486|17|880|0.0327|46
N|N0003|200106|CKH|11|21|487|88089|0|88089|0|41269|36261|7618|2941|0|       6|0.0825|32140|0.0668|15|48565|12|7384|0.0821|18
N|N0003|200106|CLB|11|21|640|122678|600|122078|0|25245|56302|22564|17297|670|      57|0.0714|57167|0.0743|39|58510|25|6401|0.0322|58
N|N0003|200106|CLJ|11|21|236|38026|0|38026|0|5116|17590|8934|6386|0|     -28|0.0909|17649|0.0682|43|19877|32|500|0.042|67
N|N0003|200106|CLL|11|21|46|8406|300|8106|0|1238|4650|1785|433|0|     -48|0.2263|3948|0.1524|16|3958|24|200|0.29|58
N|N0003|200106|CMO|11|21|543|106712|0|106312|400|43418|52504|8949|1841|0|      58|0.0488|53463|0.043|16|49371|12|3878|0.0384|11
N|N0003|200106|CMOPRA|11|21|15|3043|0|3043|0|1294|850|599|300|0|      41|0.3056|1249|0.5695|35|1794|16|||
N|N0003|200106|CMOPRB|11|21|38|10036|0|10036|0|3886|4894|915|341|0|      49|0.13|3128|0.0804|19|6528|19|380|0.01|14
N|N0003|200106|CMP|11|21|326|73395|0|73395|0|17955|42915|9935|2590|0|     -17|0.1083|20714|0.0277|19|48680|18|4001|0.0559|33
N|N0003|200106|CMS|11|21|2234|430340|888|427110|2000|222679|168912|27920|9599|0|      36|0.0312|192319|0.0264|13|205993|11|30798|0.0334|18
N|N0003|200106|CMSPRJ|11|21|22|6005|0|6005|0|975|4230|800|0|0|      38|0.2442|3930|0.0288|18|1775|17|300|0.1|17
N|N0003|200106|CMSPRK|11|21|33|9399|0|9399|0|800|7649|950|0|0|      16|0.2479|2575|0.0399|17|6124|18|700|0.1843|12
N|N0003|200106|CMSPRL|11|21|35|9413|0|9413|0|2016|4977|2005|415|0|      60|0.1851|4199|0.0565|24|4814|22|400|0.1|37
N|N0003|200106|CMSPRM|11|21|7|1698|0|1698|0|0|1398|0|300|0|      -6|0.3419|1398|0.0949|20|||300|0.25|156
N|N0003|200106|CMSPRN|11|21|17|4241|0|4241|0|523|2258|1260|200|0|       9|0.0779|3641|0.0212|28|600|9|||
N|N0003|200106|CNA|11|21|681|155244|0|154844|400|57125|83968|12351|1800|0|       7|0.0546|66722|0.0293|14|80492|10|8030|0.033|17
N|N0003|200106|CNL|11|21|567|129633|100|129233|300|70295|48666|7529|3043|0|     -34|0.0612|53723|0.0363|14|69264|10|6546|0.0487|18
N|N0003|200106|CNN|11|21|21|4852|0|4852|0|2531|1646|200|475|0|       1|0.038|3087|0.0285|13|1765|48|||
N|N0003|200106|COE|11|21|21|5098|0|5098|0|1085|1178|1635|1200|0|      10|0.0358|1785|0.0243|33|3313|59|||
N|N0003|200106|COG|11|21|625|131188|1478|129510|200|31708|55095|27764|14801|342|      11|0.0433|60097|0.0666|32|60933|24|8680|0.0682|51
N|N0003|200106|CPD|11|21|41|9634|0|9634|0|4435|3309|1640|250|0|      17|0.0417|7584|0.0444|18|2050|11|||
N|N0003|200106|CPP|11|21|13|3230|0|3230|0|900|1350|980|0|0|     122|0.1737|900|0.0567|28|2330|18|||
N|N0003|200106|CPRE|11|21|90|23321|0|23321|0|2550|15745|3669|1357|0|     -11|0.0674|13212|0.0199|26|9709|18|400|0.1|41
N|N0003|200106|CPRF|11|21|6|1100|0|1100|0|0|900|0|200|0|     -19|0.3159|250|0.48|23|850|28|||
N|N0003|200106|CPRG|11|21|7|1326|0|1326|0|0|764|562|0|0|      65|0.4987|664|0.1324|29|662|30|||
N|N0003|200106|CPRH|11|21|6|1320|0|1320|0|0|600|720|0|0|     182|0.422|920|0.1978|23|400|59|||
N|N0003|200106|CPRK|11|21|42|11084|0|11084|0|500|7692|2092|600|200|      48|0.2243|5553|0.0862|41|5131|29|400|0.165|32
N|N0003|200106|CPRM|11|21|10|2226|0|2226|0|339|960|727|200|0|     121|0.5577|1580|0.2241|29|446|18|200|0.25|38
N|N0003|200106|CPRN|11|21|43|11091|0|11091|0|2000|7226|1205|660|0|      15|0.0632|5145|0.0127|21|5946|26|||
N|N0003|200106|CPRQ|11|21|4|1200|0|1200|0|0|500|700|0|0|     124|0.5625|400|0.05|31|600|21|200|0.1|22
N|N0003|200106|CPRR|11|21|2|500|0|500|0|0|300|0|200|0|     128|0.602|300|0.03|26|200|72|||
N|N0003|200106|CPRU|11|21|12|3145|0|3145|0|200|1745|800|400|0|      93|0.5192|1470|0.0813|20|1675|47|||
N|N0003|200106|CPRW|11|21|203|54632|0|54632|0|10698|29850|9542|4142|400|       6|0.0715|24025|0.0144|27|30207|31|400|0.04|21
N|N0003|200106|CPRX|11|21|152|45053|400|44653|0|9460|26551|5112|3530|0|       4|0.0603|19055|0.0159|31|25098|22|500|0.044|106
N|N0003|200106|CQPRA|11|21|80|19210|0|19210|0|5594|9166|3275|1175|0|     -37|0.1641|10230|0.0347|18|8480|27|500|0.08|40
N|N0003|200106|CRM|11|21|6|1000|0|1000|0|0|300|0|700|0|     -45|-0.057|500|0.81|65|500|66|||
N|N0003|200106|CRY|11|21|1181|234595|3650|230145|500|98877|107261|19489|5018|0|     108|0.1235|91095|0.097|16|107036|12|32514|0.1306|20
N|N0003|200106|CSL|11|21|702|142404|860|141544|0|43960|64987|21866|10199|532|      -4|0.0624|60868|0.0381|24|68088|17|12588|0.0475|27
N|N0003|200106|CSP|11|21|46|11788|0|11188|600|4305|5430|1114|939|0|       8|0.0379|3505|0.0229|13|8183|24|100|0.02|14
N|N0003|200106|CVC|11|21|1573|300546|2400|297846|0|124254|143338|23288|6966|0|      77|0.0522|119404|0.0584|16|145555|12|32887|0.052|19
N|N0003|200106|CVD|11|21|957|215338|1250|212285|1000|63619|102151|34471|13044|0|       8|0.0433|91877|0.0469|22|107181|19|14227|0.0438|27
N|N0003|200106|CW|11|21|64|11629|0|11629|0|1568|7271|1704|1086|0|     -19|0.1445|5531|0.0981|29|5598|18|500|0.082|24
N|N0003|200106|CWN|11|21|268|59776|200|59176|400|10708|28045|14206|6517|100|       2|0.0268|23025|0.035|36|35286|30|1265|0.0361|38
N|N0003|200106|CWNPRA|11|21|23|5460|0|5460|0|1280|2775|1105|300|0|      69|0.1623|2850|0.0813|21|2610|29|||
N|N0003|200106|CYE|11|21|163|44347|0|44047|300|11950|16310|9270|6567|250|     -23|0.029|15808|0.0208|39|28139|28|400|0.03|68
N|N0003|200106|D|11|21|6378|1219758|2220|1216438|1100|899099|288283|25052|5104|0|      30|0.0547|587917|0.0449|8|463592|7|166029|0.0507|10
N|N0003|200106|DCP|11|21|120|23882|0|23882|0|6845|13962|2650|425|0|     -28|0.4252|14729|0.1923|19|9153|17|||
N|N0003|200106|DCS|11|21|26|4646|100|4546|0|826|1934|886|900|0|      -1|0.0374|646|0.0154|28|3900|39|||
N|N0003|200106|DDF|11|21|130|34631|104|34527|0|7804|18014|5335|3374|0|     -28|0.0619|12217|0.0453|22|21810|22|500|0.01|12
N|N0003|200106|DFG|11|21|322|57038|0|57038|0|27051|22775|5339|1873|0|     -15|0.0532|24654|0.036|18|28384|11|4000|0.0359|16
N|N0003|200106|DGX|11|21|5186|1005363|24875|978733|1100|406700|402320|118543|51365|905|     157|0.1035|454631|0.1058|20|354981|15|170221|0.1344|24
N|N0003|200106|DHY|11|21|69|15511|0|15511|0|3644|6401|3456|1868|142|     -20|0.0212|5804|0.0202|39|9407|33|300|0.01|39
N|N0003|200106|DJM|11|21|2|830|0|830|0|400|430|0|0|0|       5|0.1004|430|0.01|22|400|4|||
N|N0003|200106|DLX|11|21|1601|281299|2671|278216|300|71701|103284|50590|50913|2028|      34|0.0344|101971|0.0331|40|151551|33|24994|0.05|48
N|N0003|200106|DNB|11|21|925|207241|100|207141|0|97114|83577|20796|5654|0|       9|0.0423|106479|0.0315|16|90982|12|9680|0.0268|21
N|N0003|200106|DNR|11|21|384|73429|101|72428|900|27435|35656|7906|2331|0|      12|0.0339|30182|0.0324|16|39174|15|3972|0.0371|19
N|N0003|200106|DNY|11|21|1965|380145|100|379832|0|216298|132793|19890|10851|0|      -4|0.0381|156676|0.0298|13|193479|12|29677|0.0313|15
N|N0003|200106|DPRA|11|21|125|35911|0|35911|0|16642|14590|3109|1570|0|     -33|0.1137|13725|0.0222|17|20986|15|1200|0.0733|17
N|N0003|200106|DSU|11|21|261|76624|280|76344|0|28055|28115|11749|8425|0|      -9|0.0231|27021|0.0138|28|48009|27|1314|0.0163|34
N|N0003|200106|DT|11|21|2026|446775|1300|444775|700|253675|148003|35543|8254|0|       2|0.0166|202363|0.0184|12|202306|10|40806|0.0204|23
N|N0003|200106|DV|11|21|677|149804|900|148704|200|53027|64825|19880|10136|1036|      50|0.0764|65449|0.0428|22|72670|17|10785|0.0449|21
N|N0003|200106|EAS|11|21|709|158503|600|157500|0|70724|51100|22068|13608|0|       6|0.0322|57187|0.035|26|94069|17|6244|0.0266|40
N|N0003|200106|ED|11|21|4263|765164|1625|760880|1700|269390|288368|128899|73604|4061|       8|0.0326|315254|0.0402|32|364869|20|82457|0.0417|45
N|N0003|200106|EDE|11|21|259|54956|0|54856|100|22840|24852|6013|1251|100|     -46|0.0399|26989|0.0521|15|25555|16|2412|0.0353|19
N|N0003|200106|EDEPRD|11|21|20|4917|0|4917|0|900|2790|1127|100|0|      47|0.0871|4417|0.1058|19|300|26|200|0.06|31
N|N0003|200106|EDL|11|21|93|24045|0|24045|0|4069|14154|4450|1372|0|     -17|0.0953|4642|0.0249|30|17298|22|2105|0.0329|18
N|N0003|200106|EDO|11|21|700|150405|2000|148405|0|48400|64713|22279|12513|500|      11|0.0571|72066|0.0717|23|66460|15|9879|0.0961|31
N|N0003|200106|EDPRA|11|21|19|3320|0|3320|0|500|1950|400|470|0|    -110|0.8095|1820|0.7951|31|1200|27|300|0.4167|28
N|N0003|200106|EFL|11|21|24|4491|0|4491|0|1783|2333|275|100|0|      -6|0.1064|3238|0.0392|14|1253|18|||
N|N0003|200106|ELN|11|21|8381|1698154|28233|1658521|9800|591927|749792|247952|77850|800|      71|0.0376|896938|0.0543|20|574910|16|196473|0.0643|24
N|N0003|200106|ELNWSA|11|21|81|15924|0|15924|0|2530|8535|2849|2010|0|      56|0.618|9810|0.2236|33|5214|14|900|0.1233|61
N|N0003|200106|ELNWSB|11|21|16|3710|0|3710|0|950|1510|800|450|0|      87|1.0969|2100|0.5145|54|1410|12|200|0.79|20
N|N0003|200106|EMC|11|21|47650|9897171|68202|9782039|39300|3244345|4085888|1836849|651461|1701|      -1|0.0249|5060991|0.0472|22|2257708|15|2502640|0.0544|30
N|N0003|200106|EMD|11|21|14|3634|0|3634|0|200|2219|700|515|0|      37|0.0971|1119|0.0607|21|2515|31|||
N|N0003|200106|EPG|11|21|18292|3812438|35121|3757321|15900|1178720|1457845|694790|424248|17468|      33|0.0318|2175190|0.0565|26|985314|20|612717|0.0627|36
N|N0003|200106|EPGPR|11|21|4|589|0|589|0|0|0|100|489|0|      83|1.1746|489|0.234|91|100|142|||
N|N0003|200106|EPGPRC|11|21|9|1800|0|1800|0|0|200|800|400|400|    -635|1.6667|500|0.298|99|900|253|400|1.05|42
N|N0003|200106|EPI|11|21|126|33956|200|33756|0|10726|15906|5444|1680|0|      -6|0.0843|13803|0.0236|22|19153|19|800|0.0238|21
N|N0003|200106|EPL|11|21|326|76532|0|76232|300|31698|32628|8058|4148|0|      86|0.039|33547|0.0448|20|41085|15|1900|0.0384|30
N|N0003|200106|EPN|11|21|918|207403|200|207003|200|67977|98548|24636|15492|550|     -16|0.0573|111443|0.0584|22|85320|22|10440|0.0449|39
N|N0003|200106|ESI|11|21|1347|263316|10079|252937|200|72537|103484|43898|32168|1050|      35|0.0683|113865|0.0789|32|107821|21|31451|0.1062|56
N|N0003|200106|ETA|11|21|30|6305|0|6305|0|800|3730|1385|390|0|      -9|0.0437|3350|0.023|24|2855|29|100|0.04|38
N|N0003|200106|EX|11|21|189|36259|200|36059|0|11720|18552|4551|1236|0|      19|0.0391|16262|0.0377|21|18701|14|1096|0.0338|35
N|N0003|200106|FC|11|21|39|7273|0|7273|0|2340|3733|1100|100|0|      25|0.0469|4128|0.0602|21|3045|11|100|0.02|14
N|N0003|200106|FCX|11|21|2268|477507|0|477007|500|224775|186859|45247|20626|0|      -9|0.0182|200039|0.0292|19|251445|13|26023|0.0258|17
N|N0003|200106|FCXA|11|21|203|43156|440|42716|0|15376|22763|3384|1049|144|      15|0.0382|23814|0.0421|19|17487|13|1415|0.0248|40
N|N0003|200106|FCXPRA|11|21|76|18015|0|18015|0|5645|7438|3682|1250|0|      20|0.0635|11571|0.0507|23|6444|22|||
N|N0003|200106|FCXPRB|11|21|66|14738|0|14738|0|3662|8961|1765|350|0|     -13|0.1379|5695|0.0608|21|9043|19|||
N|N0003|200106|FCXPRC|11|21|18|4202|0|4202|0|0|2202|1700|300|0|      41|0.1058|1100|0.0409|35|3102|25|||
N|N0003|200106|FCXPRD|11|21|32|7878|0|7878|0|754|6474|650|0|0|      -9|0.0839|4508|0.0431|17|3370|19|||
N|N0003|200106|FE|11|21|4339|852395|1200|849495|600|440011|305729|80238|22433|1684|      14|0.0259|297521|0.0334|15|484823|12|67751|0.0391|18
N|N0003|200106|FLR|11|21|2918|566592|10100|554892|1000|189895|244194|85222|36481|100|      80|0.062|286010|0.0751|20|184057|16|85825|0.1055|33
N|N0003|200106|FMC|11|21|1529|300685|6100|294585|0|119860|125954|33675|15096|0|     110|0.06|158560|0.0587|18|100317|17|35708|0.0695|31
N|N0003|200106|FO|11|21|2620|497417|300|496617|200|263838|184257|39171|9551|0|      17|0.0459|217394|0.0347|13|239890|11|39533|0.0497|21
N|N0003|200106|FOE|11|21|591|125134|506|124228|0|44257|57903|16669|5399|0|      17|0.0377|56458|0.0374|20|61161|16|6609|0.0451|19
N|N0003|200106|FOPRA|13|21|1|300|300|0|0|0|0|0|0|0|0|||||||||
N|N0003|200106|FOR|11|21|60|12184|0|12184|0|8401|3433|350|0|0|       6|0.0292|7012|0.0142|10|5172|7|||
N|N0003|200106|FPCPRA|11|21|74|22202|0|22202|0|9105|6257|2976|3864|0|      34|0.1081|10106|0.0562|28|12096|34|||
N|N0003|200106|FRC|11|21|251|47308|200|47108|0|11567|14565|9783|10893|300|      35|0.0645|16764|0.0702|53|24944|38|5400|0.1115|77
N|N0003|200106|FSH|11|21|917|195393|1100|194093|200|78546|81804|23834|10409|0|      51|0.0717|92235|0.068|22|89125|14|12933|0.0638|25
N|N0003|200106|FTI|11|21|1980|362127|100|361927|100|145638|148580|54179|13530|100|      97|0.0225|195780|0.0546|19|152912|17|13335|0.0439|26
N|N0003|200106|FWJ|11|21|3|900|0|900|0|0|900|0|0|0|      -2|0.1167|300|0.1|18|600|20|||
N|N0003|200106|GBE|11|21|23|4475|0|4475|0|1148|1629|814|884|0|      -2|0.0771|2092|0.049|30|2083|24|300|0.05|49
N|N0003|200106|GCG|11|21|4|900|0|900|0|400|0|100|400|0|      12|-0.0011|700|0.0443|57|200|0|||
N|N0003|200106|GDP|11|21|20|4550|0|4550|0|1660|2414|476|0|0|      27|0.0799|1889|0.0255|18|2261|11|400|0.015|11
N|N0003|200106|GGT|11|21|114|24322|0|24322|0|9040|11256|3414|612|0|      -2|0.0914|9010|0.0369|16|14434|18|878|0.0613|14
N|N0003|200106|GGTPR|11|21|9|2302|0|2302|0|400|1602|300|0|0|      55|0.2422|200|0.02|8|2102|16|||
N|N0003|200106|GID|11|21|3|600|0|600|0|100|300|200|0|0|       0|0.0133|600|0.05|28|||||
N|N0003|200106|GK|11|21|110|17156|0|17156|0|1750|7742|4376|3062|226|       2|0.0597|9137|0.0484|35|6619|55|1400|0.0421|52
N|N0003|200106|GLC|11|21|1397|310305|2700|306105|1100|88027|135891|55266|26942|1079|       3|0.0268|152886|0.0322|25|129221|21|25098|0.0498|30
N|N0003|200106|GLG|11|21|210|51489|0|51089|400|30501|17462|3225|301|0|       1|0.0265|13063|0.0168|11|37509|11|917|0.0151|7
N|N0003|200106|GLH|11|21|201|45051|0|45051|0|15566|21649|5843|1993|0|     -27|0.143|14705|0.0661|23|28551|15|1795|0.0261|21
N|N0003|200106|GLW|11|21|31632|6854173|13360|6798713|38700|3855589|2284747|586994|109468|615|       1|0.0136|3112503|0.0242|12|2413309|9|1311601|0.0273|18
N|N0003|200106|GPB|11|21|94|26231|0|26231|0|4691|15476|4364|1700|0|     -37|0.0968|14042|0.057|21|11889|26|300|0.0167|53
N|N0003|200106|GPD|11|21|53|13433|0|13433|0|7588|5845|0|0|0|      21|0.1593|7865|0.0481|10|5268|10|300|0.1|9
N|N0003|200106|GPEPRA|11|21|62|17189|0|17189|0|7510|8831|848|0|0|      44|0.1118|10268|0.0573|13|6921|10|||
N|N0003|200106|GPEPRT|11|21|57|14799|400|14399|0|6781|6318|1100|200|0|       8|0.0711|6620|0.0196|18|7779|8|||
N|N0003|200106|GPEPRU|11|21|49|12589|0|12589|0|4059|8135|395|0|0|      32|0.1653|7537|0.0333|12|5052|11|||
N|N0003|200106|GPEPRV|11|21|32|7953|0|7953|0|1966|4966|1021|0|0|      35|0.1588|4145|0.0421|17|3508|19|300|0.0733|14
N|N0003|200106|GPF|11|21|20|5986|0|5986|0|1030|3571|925|460|0|     -41|0.1622|1540|0.0802|23|4446|26|||
N|N0003|200106|GPU|11|21|1834|331935|1599|329136|500|179273|123240|20383|6540|200|      30|0.0418|164349|0.0434|12|136469|11|28818|0.0411|15
N|N0003|200106|GRA|11|21|217|50998|0|50998|0|21532|22718|6164|584|0|     -14|0.0143|18821|0.0151|17|31361|14|816|0.0202|6
N|N0003|200106|GRB|11|21|163|27554|0|27554|0|5052|13374|6620|2508|0|       8|0.0295|12715|0.0593|26|13418|28|1421|0.0244|47
N|N0003|200106|GUPPRA|11|21|18|4554|0|4554|0|350|4204|0|0|0|       8|0.1284|2809|0.1062|13|1745|14|||
N|N0003|200106|GUPPRB|11|21|21|5484|0|5484|0|550|4584|350|0|0|     -11|0.1667|3784|0.0723|15|1700|11|||
N|N0003|200106|HAR|11|21|769|148497|1800|146597|100|34515|73133|27304|11745|0|      74|0.0552|68766|0.0854|26|67117|23|10814|0.1312|22
N|N0003|200106|HAS|11|21|2142|438982|100|437882|1000|174135|192970|53185|18592|0|       9|0.0301|246768|0.0269|17|172621|16|19493|0.0313|24
N|N0003|200106|HCN|11|21|804|177141|0|175441|800|59204|72907|26587|16813|730|     -32|0.034|81716|0.0317|27|85715|20|8810|0.0327|45
N|N0003|200106|HCNPRB|11|21|38|10125|0|10125|0|2217|4841|2284|783|0|       7|0.1173|6825|0.0796|25|2900|37|400|0.05|14
N|N0003|200106|HGR|11|21|31|7668|0|7668|0|2203|2650|1915|900|0|       1|0.0502|2915|0.0361|44|4653|19|100|0.02|8
N|N0003|200106|HIL|11|21|58|12938|0|12938|0|3997|7419|1222|300|0|      -1|0.0221|7891|0.0332|15|4547|15|500|0.026|18
N|N0003|200106|HIW|11|21|853|201813|138|201675|0|124564|67892|7219|1700|300|      17|0.0302|92008|0.0319|10|101169|9|8498|0.0282|18
N|N0003|200106|HIWPRB|11|21|48|13382|0|13382|0|3770|8212|1000|400|0|     -24|0.1308|9665|0.0841|16|3717|18|||
N|N0003|200106|HIWPRD|11|21|51|13883|0|13883|0|3676|7969|2238|0|0|     -33|0.1521|8843|0.0724|17|4640|16|400|0.055|9
N|N0003|200106|HMA|11|21|1305|285451|0|284551|900|120298|111741|35184|17878|350|      16|0.0185|153353|0.0329|22|115598|15|16500|0.0365|33
N|N0003|200106|HMC|11|21|327|61763|0|61763|0|23757|28584|7033|2389|0|     112|0.1751|29459|0.1755|21|28592|13|3712|0.0987|30
N|N0003|200106|HMT|11|21|1019|248392|300|245792|2300|101541|107186|25592|12063|1710|       4|0.0155|123922|0.0207|20|115408|14|8762|0.018|59
N|N0003|200106|HMTPRA|11|21|40|10915|0|10915|0|2225|7190|1100|400|0|     -10|0.1225|4130|0.0509|12|6285|19|500|0.086|42
N|N0003|200106|HMTPRB|11|21|45|12320|0|12320|0|4705|5465|1700|450|0|     -65|0.0985|7575|0.0284|16|4545|23|200|0.1|18
N|N0003|200106|HMTPRC|11|21|58|16685|0|16685|0|4440|10635|1280|330|0|     -32|0.0897|7385|0.018|21|8900|13|400|0.05|7
N|N0003|200106|HON|11|21|19634|4537992|36160|4486970|11800|2162439|1652916|496192|184563|2660|      -6|0.0359|2222825|0.0602|16|1376974|12|898971|0.0831|26
N|N0003|200106|HOV|11|21|497|107289|200|106689|300|46229|49915|7595|3250|0|      30|0.0621|47328|0.0482|16|52446|13|7215|0.0522|15
N|N0003|200106|HZO|11|21|20|4175|0|4175|0|1240|2184|200|551|0|      21|0.039|1809|0.0585|30|2366|22|||
N|N0003|200106|ICS|11|21|7|1506|0|1506|0|0|1506|0|0|0|      14|0.0675|770|0.0113|10|736|16|||
N|N0003|200106|IDG|11|21|11|2461|0|2461|0|319|1494|648|0|0|      27|0.1105|1813|0.0317|11|||648|0.1|38
N|N0003|200106|IEU|11|21|16|4255|0|4255|0|255|3200|400|400|0|     -14|0.2366|1555|0.0971|15|2700|36|||
N|N0003|200106|IFX|11|21|738|155517|1600|152017|400|57220|65935|19363|9549|350|      54|0.1008|54177|0.0564|21|66889|15|31351|0.0759|27
N|N0003|200106|IGL|11|21|884|187910|400|187210|300|46812|77036|38157|24596|909|      10|0.0177|77292|0.0227|36|101416|23|8802|0.0292|38
N|N0003|200106|IML|11|21|24|6306|0|6306|0|857|3090|1110|945|304|      15|0.1118|4214|0.0282|50|1335|44|757|0.0617|87
N|N0003|200106|IQM|11|21|27|9088|0|9088|0|3112|3224|1533|1219|0|     -12|0.0412|2795|0.0247|19|6163|27|130|0.02|15
N|N0003|200106|IR|11|21|3775|759241|2050|754499|2100|278603|313443|122486|41102|1380|      26|0.0277|384981|0.0303|20|301091|17|70527|0.0412|26
N|N0003|200106|ISP|11|21|117|20875|0|20875|0|5474|11352|2541|1508|0|      45|0.0493|11155|0.0345|20|8420|19|1300|0.0331|33
N|N0003|200106|ITG|11|21|1108|235115|3900|231115|100|71405|116744|30416|12650|0|      75|0.0835|110607|0.0695|22|102156|15|18452|0.1072|32
N|N0003|200106|ITN|11|21|371|78922|429|78493|0|38979|31129|6358|2027|0|      31|0.0448|27960|0.0329|13|45177|12|5356|0.037|20
N|N0003|200106|ITT|11|21|1622|286838|300|285930|500|109564|148979|23443|4444|0|      38|0.0516|134635|0.0453|15|131715|12|20080|0.0523|18
N|N0003|200106|ITX|11|21|71|16878|200|16678|0|3675|9192|2450|1361|0|       0|0.0615|5862|0.039|25|7799|16|3017|0.0462|32
N|N0003|200106|ITXPR|11|21|8|1738|0|1738|0|199|729|450|360|0|    -122|0.3264|888|0.2684|41|700|45|150|0.5|10
N|N0003|200106|IVC|11|21|574|109326|0|109042|0|56256|39484|9774|3528|0|      -2|0.0595|52292|0.0707|14|49763|14|6987|0.0589|23
N|N0003|200106|JBL|11|21|10652|2021224|38650|1976374|5600|828342|716374|280748|152377|4133|      43|0.0406|978092|0.0497|20|664172|15|339710|0.0735|35
N|N0003|200106|JCP|11|21|4785|923275|3200|917192|2600|476919|354391|69553|17871|1058|      18|0.027|417906|0.0348|15|412601|11|89285|0.0462|17
N|N0003|200106|JEM|11|21|14|3691|0|3691|0|2595|846|250|0|0|      48|0.0709|650|0.0162|17|3041|8|||
N|N0003|200106|JOE|11|21|560|109132|100|108932|100|37049|49203|13005|9415|360|      20|0.0545|30081|0.028|28|72812|20|6139|0.0361|55
N|N0003|200106|JYPPRZ|11|21|33|8294|0|8294|0|3987|2853|1454|0|0|     -11|0.0813|2801|0.0214|12|5093|17|400|0.055|13
N|N0003|200106|KBH|11|21|2003|396444|1900|393544|700|235578|135787|19031|3612|236|      31|0.052|158530|0.0436|12|201018|9|34696|0.062|18
N|N0003|200106|KBHPRG|12|23|1|4000|3800|200|0|0|200|0|0|0|     -80|0.25||||200|18|||
N|N0003|200106|KBHPRI|11|21|10|1870|0|1870|0|670|1200|0|0|0|      -1|0.1165|600|0.0233|10|1270|11|||
N|N0003|200106|KEG|11|21|1018|219955|1787|218168|0|79979|96492|29441|11905|351|       2|0.0309|96876|0.0251|21|100725|18|20567|0.0376|30
N|N0003|200106|KEI|11|21|1527|304821|3399|301422|0|107761|129096|42537|22028|0|      43|0.0795|140598|0.0738|21|117736|18|43088|0.0839|31
N|N0003|200106|KG|11|21|5215|1031366|8400|1021866|1100|454412|432306|107139|28667|442|      43|0.0377|522352|0.0555|16|392279|13|108335|0.069|18
N|N0003|200106|KLU|11|21|160|33466|0|33466|0|12755|16840|3321|550|0|       5|0.052|13916|0.0403|14|18540|14|1010|0.01|16
N|N0003|200106|KMB|11|21|10045|2164410|4955|2150133|7000|686439|883329|387441|193491|6433|      20|0.0322|1162179|0.0422|24|704899|21|290055|0.0583|29
N|N0003|200106|KOR|11|21|26|5566|0|5566|0|1145|2746|600|1075|0|     -21|0.0425|3656|0.0338|26|1910|33|||
N|N0003|200106|KPA|11|21|290|63086|0|62586|500|27584|24830|7518|3154|0|       5|0.0301|18392|0.0203|18|41710|16|2984|0.0191|24
N|N0003|200106|KPAPRA|11|21|38|8841|0|8841|0|2025|3910|800|2106|0|     -17|0.2095|2760|0.056|50|5456|28|625|0.1156|16
N|N0003|200106|KRJ|11|21|4|1150|0|1150|0|300|850|0|0|0|       9|0.113|600|0.0833|18|550|14|||
N|N0003|200106|KTB|11|21|24|6825|0|6825|0|1200|3975|850|800|0|      14|0.1024|4475|0.0597|29|2350|20|||
N|N0003|200106|KTP|11|21|113|29875|0|29875|0|11654|14076|3720|425|0|      -6|0.1111|13092|0.0381|17|15603|15|1180|0.0632|17
N|N0003|200106|KYO|11|21|488|90772|0|90472|300|44067|39611|5763|1331|0|      87|0.3294|39291|0.1462|13|44089|12|7392|0.1991|15
N|N0003|200106|LBI|11|21|9|1540|0|1540|0|200|1090|250|0|0|     -20|0.0645|713|0.121|22|827|15|||
N|N0003|200106|LDP|11|21|71|16330|0|16330|0|4713|7895|1543|2179|0|       7|0.0814|6311|0.0355|21|9254|26|765|0.0413|41
N|N0003|200106|LMM|11|21|5|1340|0|1340|0|400|450|490|0|0|       7|0.0192|210|0.0257|18|1130|27|||
N|N0003|200106|LMS|11|21|40|8949|0|8949|0|1605|5269|1025|1050|0|     -23|0.0789|5069|0.0544|32|3770|16|110|0.02|12
N|N0003|200106|LMT|11|21|7427|1539221|2321|1534598|1500|813099|498258|155630|68871|240|      25|0.038|652816|0.0387|18|731392|12|151890|0.0449|19
N|N0003|200106|LNT|11|21|1104|241025|0|240325|700|74986|120488|33823|11428|300|       3|0.0345|72301|0.0345|18|155939|17|12785|0.0238|23
N|N0003|200106|LRY|11|21|728|157798|0|156898|900|63418|75594|14717|4069|0|     -11|0.0361|80555|0.0294|15|73460|14|3783|0.0312|21
N|N0003|200106|LRYPRA|11|21|45|11239|0|11239|0|5040|5074|675|450|0|      -9|0.1347|2244|0.0408|19|8795|14|200|0.05|24
N|N0003|200106|LSHPRA|11|21|38|8884|0|8884|0|1777|4625|1100|1382|0|      21|0.1001|4602|0.0332|34|4282|29|||
N|N0003|200106|MAG|11|21|205|40664|100|40564|0|11519|19271|7942|1832|0|       3|0.034|18625|0.0561|21|21026|17|913|0.0264|46
N|N0003|200106|MAR|11|21|4566|852217|3439|847777|500|327186|338792|115285|64394|2620|      17|0.0336|371175|0.0377|23|376069|17|101033|0.0395|25
N|N0003|200106|MAT|11|21|6271|1269034|600|1265555|2400|804303|370087|74517|19048|0|       9|0.0286|536799|0.0232|12|603833|9|127323|0.0268|17
N|N0003|200106|MCC|11|21|92|15602|100|15502|0|3391|5930|2640|3441|100|      31|0.1551|10231|0.1351|48|3496|48|1775|0.1344|50
N|N0003|200106|MCO|11|21|2564|482050|300|481050|0|205260|224512|38524|12754|0|      50|0.0344|232157|0.0449|16|218413|12|30480|0.0506|21
N|N0003|200106|MCT|11|21|93|18905|300|18605|0|6170|8860|2500|1175|0|     -95|0.2168|10070|0.0931|22|7035|21|1500|0.0993|18
N|N0003|200106|MDG|11|21|222|44774|100|44574|100|18941|16881|6899|1953|0|       3|0.0379|17024|0.0225|15|23758|15|3892|0.029|43
N|N0003|200106|MEE|11|21|1036|209709|1746|206463|1500|66383|99319|28763|13498|0|      29|0.0405|111328|0.0591|22|81354|18|15281|0.0622|27
N|N0003|200106|MEH|11|21|251|48319|0|48319|0|14334|23793|6423|3769|0|      23|0.0701|17902|0.0429|26|24568|19|5849|0.046|31
N|N0003|200106|MER|11|21|30073|6760165|79577|6655420|22100|3730194|2256343|498914|187021|5048|      30|0.0551|3050308|0.0476|13|1925818|9|1701394|0.066|19
N|N0003|200106|MERPRA|11|21|78|19057|0|19057|0|7062|8478|2817|700|0|      20|0.101|10546|0.0317|22|8411|15|100|0.02|24
N|N0003|200106|MERPRB|11|21|79|20512|0|20512|0|6773|11414|1925|400|0|      -6|0.0985|12232|0.0367|16|7980|17|300|0.01|11
N|N0003|200106|MERPRC|11|21|75|18441|0|18441|0|4795|11057|1582|1007|0|      -5|0.1103|11160|0.0386|24|7181|16|100|0.07|17
N|N0003|200106|MERPRD|11|21|180|50455|0|50455|0|18698|26565|3992|1200|0|      -3|0.0677|28689|0.0208|17|21266|15|500|0.026|20
N|N0003|200106|MERPRE|11|21|91|24866|0|24866|0|7807|13364|1525|2170|0|       5|0.0673|17369|0.0194|23|7497|26|||
N|N0003|200106|MERPRF|11|21|254|64465|0|64465|0|22971|30739|8030|2725|0|     -21|0.0566|35833|0.0187|19|27832|19|800|0.025|12
N|N0003|200106|MFW|11|21|32|7466|0|7466|0|2841|4113|512|0|0|      -3|0.0181|2029|0.0623|12|5437|14|||
N|N0003|200106|MGF|11|21|70|16120|0|16120|0|6543|8899|500|178|0|       4|0.0166|3887|0.0103|17|12233|12|||
N|N0003|200106|MHN|11|21|44|10018|0|10018|0|5361|3632|1025|0|0|      -2|0.0315|3926|0.014|17|5792|10|300|0.0133|16
N|N0003|200106|MIM|11|21|7|1347|0|1347|0|275|672|200|200|0|     -34|0.1074|140|0.13|24|1207|26|||
N|N0003|200106|MLI|11|21|373|69963|100|69763|100|19462|27043|13949|9309|100|      46|0.0273|31833|0.0706|30|34350|30|3680|0.0433|50
N|N0003|200106|MLM|11|21|956|204799|300|204099|400|61064|95095|32619|15821|300|       9|0.0477|80241|0.0608|24|108917|20|15341|0.0475|23
N|N0003|200106|MLS|11|21|869|206055|0|205855|200|74780|98864|22395|10016|0|      -6|0.065|79217|0.0297|20|113979|14|12859|0.0332|28
N|N0003|200106|MMA|11|21|164|41547|0|41347|200|6120|18982|11510|4935|0|     -35|0.0759|18868|0.0622|31|22479|28|200|0.01|42
N|N0003|200106|MMC|11|21|7854|1504024|4800|1496324|2400|848935|524310|93936|31240|303|      96|0.0776|737970|0.0635|14|537240|9|223514|0.0759|16
N|N0003|200106|MMR|11|21|143|24452|0|24452|0|4408|14201|3524|2319|0|     -64|0.0584|10071|0.0532|24|13468|26|913|0.0605|21
N|N0003|200106|MMS|11|21|1627|318955|1900|315905|900|106853|137298|48809|23545|300|     169|0.0495|180240|0.06|24|113201|20|23364|0.0565|33
N|N0003|200106|MOT|11|21|15110|3328170|5844|3311576|8100|1598352|1234943|389062|96669|650|       2|0.0107|1631510|0.0236|17|1229766|10|458400|0.0247|21
N|N0003|200106|MOTPRA|11|21|193|54690|0|54690|0|19492|24106|8167|2925|0|      -1|0.0898|30541|0.0284|23|23749|17|400|0.025|16
N|N0003|200106|MPPRD|11|21|9|1975|0|1975|0|300|775|900|0|0|      29|0.2923|1600|0.04|28|375|14|||
N|N0003|200106|MRX|11|21|1621|320344|8637|310782|200|63174|159322|56740|29946|1800|      17|0.0942|133022|0.0768|30|134927|24|43033|0.1141|30
N|N0003|200106|MSF|11|21|42|9509|0|9509|0|2112|6131|766|200|300|     -21|0.0626|3761|0.0423|15|5748|16|||
N|N0003|200106|MTN|11|21|145|22165|0|21965|200|4845|12736|2407|2177|0|      46|0.0896|11127|0.0907|28|10716|22|322|0.1|10
N|N0003|200106|MTTPRX|11|21|23|5969|0|5969|0|850|4879|240|0|0|     124|0.1935|3074|0.1643|18|2895|13|||
N|N0003|200106|MTX|11|21|764|141623|0|140313|0|59229|61833|11244|8007|0|      -3|0.062|55775|0.0467|18|74506|17|10032|0.0553|28
N|N0003|200106|MUC|11|21|37|9273|0|9273|0|3762|3999|400|1112|0|     -13|0.0279|5611|0.0146|17|3262|42|400|0.01|6
N|N0003|200106|MUJ|11|21|36|8266|0|8266|0|3118|4948|200|0|0|       1|0.0292|4991|0.0126|15|3275|10|||
N|N0003|200106|MUO|11|21|47|10408|0|10408|0|2493|6074|1116|725|0|      -6|0.0519|3863|0.0223|24|6345|13|200|0.06|140
N|N0003|200106|MYI|11|21|107|32319|0|32319|0|11642|14632|3472|2373|200|     -11|0.0318|11728|0.0141|29|20291|17|300|0.01|18
N|N0003|200106|NAV|11|21|1165|207641|200|206594|300|100039|87977|14008|4870|0|      34|0.0271|94076|0.027|14|101550|12|11268|0.0438|17
N|N0003|200106|NC|11|21|422|70933|0|70933|0|24172|40012|5599|1150|0|     -71|0.1476|27278|0.0952|18|37888|11|5767|0.0974|18
N|N0003|200106|NCI|11|21|165|36300|0|36300|0|12555|13153|5331|4291|970|      20|0.0448|13065|0.0375|23|21642|25|1593|0.0567|119
N|N0003|200106|NDE|11|21|1140|252703|3500|248903|200|62581|105339|52043|27991|1149|      31|0.0427|103869|0.041|28|124648|23|20586|0.0692|57
N|N0003|200106|NEU|11|21|2069|434722|5500|427622|500|148279|190275|58105|31463|0|     118|0.0733|193603|0.0723|25|172307|15|62212|0.0672|31
N|N0003|200106|NMA|11|21|57|13504|0|13504|0|2868|6470|2799|1367|0|       5|0.033|1804|0.0319|18|11350|29|350|0.01|41
N|N0003|200106|NMI|11|21|23|5888|0|5888|0|2227|2881|580|200|0|      23|0.0667|4313|0.0145|18|1575|13|||
N|N0003|200106|NMK|11|21|1636|308307|100|307707|400|114811|128594|41825|22677|200|       1|0.0191|97748|0.016|23|190283|18|20076|0.0143|28
N|N0003|200106|NMKPRK|11|21|1|100|0|100|0|100|0|0|0|0|     110|0.75||||100|9|||
N|N0003|200106|NMT|11|21|21|5072|0|5072|0|507|4032|133|400|0|      20|0.0602|2876|0.023|19|2196|23|||
N|N0003|200106|NPC|11|21|12|2425|0|2425|0|798|1627|0|0|0|       8|0.0694|927|0.0578|14|1498|14|||
N|N0003|200106|NPV|11|21|36|8346|0|8346|0|2790|3706|1850|0|0|      10|0.0865|4223|0.0241|20|3823|17|300|0.01|13
N|N0003|200106|NQF|11|21|33|8197|0|8197|0|3319|3533|1145|0|200|      -1|0.0506|4778|0.0118|32|3419|10|||
N|N0003|200106|NQS|11|21|50|13224|0|13224|0|3268|6571|3385|0|0|       6|0.0344|3655|0.0223|23|9235|17|334|0.04|32
N|N0003|200106|NSH|11|21|31|6351|0|6351|0|1216|4108|927|100|0|      -7|0.0711|3151|0.0624|19|3200|18|||
N|N0003|200106|NSI|11|21|989|206016|700|204916|400|81854|88750|26478|8134|100|      26|0.053|78530|0.0423|19|115118|14|11668|0.0455|29
N|N0003|200106|NTC|11|21|29|7856|0|7856|0|2683|4673|500|0|0|      23|0.0692|5213|0.0129|16|2643|12|||
N|N0003|200106|NUT|11|21|24|5170|0|5170|0|713|3916|541|0|0|      17|0.0767|3509|0.0365|19|1548|11|113|0.05|9
N|N0003|200106|NVN|11|21|60|17595|0|17595|0|3541|10820|1951|1283|0|      -8|0.0528|6675|0.015|21|10105|23|815|0.0316|14
N|N0003|200106|OAT|11|21|3034|570965|4200|565465|1300|270878|204505|62275|28792|315|      40|0.0499|293935|0.0578|17|213478|13|59352|0.0588|21
N|N0003|200106|OCN|11|21|196|44482|122|44160|200|11948|15964|8555|7893|0|      28|0.0487|16847|0.0378|38|24518|33|2995|0.0362|41
N|N0003|200106|OECPRT|11|21|37|8598|0|8598|0|5028|2770|600|200|0|      59|0.3758|5885|0.0151|16|2713|9|||
N|N0003|200106|OFC|11|21|228|44336|0|44336|0|7456|16953|9168|10759|0|     -30|0.0313|17630|0.0546|51|22481|36|4225|0.0178|24
N|N0003|200106|OFCPRB|11|21|24|4268|0|4268|0|240|1775|1155|700|398|     -16|0.0926|2050|0.1197|37|2118|122|100|0.05|65
N|N0003|200106|OFCPRE|11|21|22|4805|0|4805|0|700|1725|1130|1150|100|      13|0.1068|2310|0.0747|57|2195|46|300|0.03|11
N|N0003|200106|OH|11|21|149|34617|140|34377|100|9919|17741|4045|2772|0|      -1|0.0328|14906|0.0318|32|19248|18|323|0.0286|89
N|N0003|200106|OI|11|21|353|74739|0|74739|0|33123|30579|7601|3436|0|      12|0.0219|24529|0.0238|16|47287|16|2923|0.0227|21
N|N0003|200106|OIPRA|11|21|62|16193|100|16093|0|2270|6602|2439|4282|500|     -37|0.1128|7247|0.0299|73|7547|45|1299|0.0585|54
N|N0003|200106|OMG|11|21|965|189051|1000|186551|0|54715|91492|27624|12720|0|      22|0.0607|70167|0.0623|23|97105|18|19279|0.0554|29
N|N0003|200106|OMI|11|21|565|107087|500|106087|300|26099|48534|18229|13525|0|      32|0.0552|41150|0.0578|29|56474|24|8763|0.0579|42
N|N0003|200106|ONE|11|21|10768|2557497|1921|2549239|4900|1590050|761410|159619|42657|403|       9|0.0277|1132248|0.0266|12|1085876|9|336015|0.0315|15
N|N0003|200106|ONEPRB|11|21|3|400|0|400|0|0|200|0|200|0|     211|2.3875|200|0.55|91|200|18|||
N|N0003|200106|ONEPRC|11|21|1|100|0|100|0|0|0|0|100|0|1.5|2|100|1|83|||||
N|N0003|200106|ONEPRT|11|21|109|29362|0|29362|0|13993|11061|3728|580|0|     -24|0.0822|11554|0.0415|15|16908|15|900|0.0289|13
N|N0003|200106|ONEPRU|11|21|60|17827|0|17827|0|6895|7268|3264|400|0|     -23|0.1008|7272|0.0373|19|10355|15|200|0.05|22
N|N0003|200106|ONEPRV|11|21|93|23722|0|23722|0|10722|12220|400|380|0|     -10|0.0884|13172|0.031|12|9650|13|900|0.0311|19
N|N0003|200106|OSI|11|21|1058|248089|2075|245714|300|63505|109163|44599|28147|600|      23|0.0554|102160|0.0585|31|123370|21|20484|0.0677|33
N|N0003|200106|OTL|11|21|200|33973|0|33973|0|8320|18238|7115|300|0|      44|0.1038|11952|0.0549|18|17721|15|4300|0.2072|34
N|N0003|200106|OWC|11|21|426|97564|400|97164|0|51956|36885|6365|1958|0|       4|0.0286|25059|0.0166|13|64887|11|7218|0.0214|26
N|N0003|200106|PAG|11|21|182|38597|0|38597|0|14405|16254|5316|2622|0|       3|0.0262|13760|0.0177|24|24337|16|500|0.016|16
N|N0003|200106|PAR|11|21|38|8752|0|8752|0|2836|4398|1118|400|0|     -30|0.0644|3723|0.049|17|4629|33|400|0.0425|17
N|N0003|200106|PAS|11|21|469|116739|596|115743|0|32186|50278|20265|12755|259|      20|0.0361|55329|0.0333|31|57869|26|2545|0.0876|29
N|N0003|200106|PCEPR|11|21|28|7237|0|7237|0|1438|3578|1621|600|0|      37|0.1203|2378|0.0377|23|4459|27|400|0.0825|15
N|N0003|200106|PCEPRA|11|21|67|19235|0|19235|0|4495|7684|3786|3070|200|     -12|0.1339|6197|0.0854|34|12438|40|600|0.0767|103
N|N0003|200106|PCL|11|21|870|207041|0|205966|800|82550|84819|26006|12302|1289|      38|0.0518|79822|0.0285|32|112427|17|14517|0.0474|59
N|N0003|200106|PCT|11|21|41|10980|0|10980|0|1755|5233|2274|1718|0|      -4|0.1086|4575|0.0492|32|6405|31|||
N|N0003|200106|PDE|11|21|1349|311176|2700|307576|900|153759|109523|33382|11412|400|       5|0.0241|146622|0.0338|16|130255|11|31599|0.0309|23
N|N0003|200106|PECPRX|11|21|31|9116|0|9116|0|3045|5421|650|0|0|      46|0.253|6766|0.2323|14|2250|16|100|0.2|13
N|N0003|200106|PEP|11|21|17054|3961781|3610|3935924|19800|1877493|1559852|407217|111162|0|      10|0.0169|2074843|0.0276|16|1458336|12|422545|0.0302|20
N|N0003|200106|PER|11|21|681|147898|1311|146587|0|54071|50664|20863|20325|664|      -3|0.0494|60502|0.0331|30|70966|23|15119|0.0414|37
N|N0003|200106|PFP|11|21|20|4346|0|4346|0|611|3014|223|498|0|      75|0.2408|2737|0.1043|23|1609|22|||
N|N0003|200106|PFPPR|11|21|8|1998|0|1998|0|456|1542|0|0|0|      38|0.3709|1060|0.1181|14|938|3|||
N|N0003|200106|PG|11|21|14631|3286058|7562|3265296|10900|1994720|980155|234132|65839|1200|      17|0.0383|1509114|0.0338|12|1185301|9|581781|0.0453|20
N|N0003|200106|PGF|11|21|13|3127|0|3127|0|400|2227|500|0|0|     -19|0.1322|200|0.1|37|2927|16|||
N|N0003|200106|PGN|11|21|4449|803192|1050|800855|1100|395029|308406|70143|26814|1563|      11|0.0442|356946|0.0318|16|362495|12|82514|0.0394|21
N|N0003|200106|PHA|11|21|11090|2625800|5054|2615898|2300|1194257|945635|349082|129224|0|      18|0.0269|1208326|0.0303|19|1030728|13|379144|0.0395|26
N|N0003|200106|PII|11|21|547|102532|100|102432|0|41394|47177|10024|3837|0|     -53|0.0656|43817|0.0617|19|50009|14|8606|0.067|21
N|N0003|200106|PIK|11|21|20|3575|0|3575|0|200|1904|349|1122|0|      16|0.048|2316|0.061|22|1092|112|167|0.02|177
N|N0003|200106|PIM|11|21|174|49075|0|49075|0|24946|18678|4419|1032|0|     -11|0.0231|15250|0.0101|15|31123|13|2702|0.0172|21
N|N0003|200106|PIO|11|21|112|20834|0|20834|0|4049|12496|3547|742|0|     -15|0.1999|15381|0.3664|19|5353|24|100|0.03|57
N|N0003|200106|PKE|11|21|670|119484|100|119384|0|37310|62636|13909|5529|0|       0|0.0536|51032|0.0518|20|59311|16|9041|0.0835|42
N|N0003|200106|PKG|11|21|595|146975|435|146340|200|34426|54415|28787|26474|2438|      29|0.0363|71171|0.0341|45|66334|34|9035|0.0866|51
N|N0003|200106|PKX|11|21|711|142771|0|142226|200|41939|72365|20160|7962|0|      33|0.0222|67854|0.0374|22|71279|18|3293|0.0316|36
N|N0003|200106|PLP|11|21|84|20783|0|20783|0|6623|11908|1872|380|0|       1|0.0736|9234|0.0405|19|9569|14|1980|0.048|16
N|N0003|200106|PNP|11|21|360|77419|0|77419|0|21873|46990|6414|2142|0|      49|0.0584|39478|0.0455|17|35119|13|2822|0.0368|27
N|N0003|200106|PNW|11|21|2281|470049|2100|467443|400|193183|212965|42984|18311|400|      58|0.0449|244484|0.0442|17|188356|15|35003|0.0463|22
N|N0003|200106|PPD|11|21|1023|203099|1025|199574|2500|50324|81817|41329|28104|500|      -8|0.0512|76073|0.06|40|105458|21|20543|0.056|41
N|N0003|200106|PPP|11|21|1071|218104|600|217504|0|90001|84657|30380|12466|0|      33|0.0533|86443|0.0541|21|107964|17|23097|0.0719|22
N|N0003|200106|PPPPRQ|11|21|8|1220|0|1220|0|0|340|750|130|0|    -419|1.2508|400|0.461|62|820|29|||
N|N0003|200106|PTV|11|21|2082|421537|524|420713|300|130636|203286|64391|22600|100|      14|0.0255|219254|0.0309|20|179782|19|21977|0.0307|20
N|N0003|200106|PX|11|21|4735|968093|4342|962551|400|391045|431840|105022|34611|433|      32|0.0323|517464|0.0384|17|360536|15|84951|0.0418|20
N|N0003|200106|RCL|11|21|888|192609|1279|191130|200|73260|79569|27645|10856|0|      -4|0.0309|71595|0.0366|23|106888|15|12847|0.0291|21
N|N0003|200106|RCN|11|21|119|26769|0|26769|0|7428|11535|3395|4411|0|     -65|0.13|9038|0.0576|40|14081|20|3650|0.0453|33
N|N0003|200106|RG|11|21|357|70949|0|70949|0|19784|28138|8150|13587|1290|       4|0.0507|16009|0.0463|71|42135|29|12805|0.0254|64
N|N0003|200106|RHB|11|21|1366|256151|6400|249751|0|54702|103946|53430|37673|0|     -13|0.1091|117310|0.0835|36|102790|26|29651|0.1028|46
N|N0003|200106|RHD|11|21|830|166190|100|165990|0|55871|81814|20848|7457|0|      19|0.0431|76146|0.0406|19|82195|17|7649|0.0406|25
N|N0003|200106|RHI|11|21|2239|438400|1243|436357|800|200230|165695|49195|21787|250|      40|0.0378|212536|0.0402|18|187120|13|37501|0.0493|32
N|N0003|200106|RJF|11|21|865|179628|1970|177558|100|59606|69661|26503|21888|0|      60|0.0605|84064|0.0491|26|80046|18|13548|0.063|43
N|N0003|200106|RL|11|21|883|188977|400|187027|1200|51875|75446|38251|22355|300|       7|0.0584|80017|0.0683|29|84714|25|23496|0.0661|31
N|N0003|200106|RMG|11|21|406|76807|0|76807|0|31060|36138|8459|1150|0|      63|0.0786|40447|0.0656|14|32940|14|3420|0.0411|29
N|N0003|200106|RML|11|21|302|65767|851|64916|0|15388|24785|9913|14430|400|      -1|0.0323|25040|0.0345|54|36262|32|3614|0.036|68
N|N0003|200106|RNS|11|21|11|3105|0|3105|0|1535|1370|200|0|0|    -196|0.1214|2105|0.1211|11|1000|14|||
N|N0003|200106|ROP|11|21|637|119636|1400|118236|0|31245|46507|21949|17566|969|     -49|0.0654|52276|0.0767|37|54041|26|11919|0.076|60
N|N0003|200106|ROS|11|21|42|8810|0|8810|0|5900|2210|500|200|0|      15|0.0264|4960|0.0191|11|3850|15|||
N|N0003|200106|ROV|11|21|1256|280099|300|278999|800|121057|99650|39115|18932|1045|      48|0.0251|165982|0.0469|20|98628|16|15189|0.0513|69
N|N0003|200106|RS|11|21|364|74715|300|74415|0|17112|35972|16048|5283|0|      16|0.0486|37850|0.0445|24|31898|21|4667|0.0411|26
N|N0003|200106|RSC|11|21|163|35415|0|35415|0|8219|17055|6911|3230|0|       7|0.1382|19992|0.0862|25|13593|24|1830|0.1025|40
N|N0003|200106|RTP|11|21|224|45752|200|45552|0|14891|21771|6917|1973|0|    -105|0.4891|17391|0.1724|22|23561|14|4600|0.5028|31
N|N0003|200106|RWT|11|21|272|52267|0|52267|0|18388|19210|10069|4600|0|       6|0.0721|25393|0.0563|23|24774|18|2100|0.0438|14
N|N0003|200106|RWTPRB|11|21|9|1638|0|1638|0|100|1288|100|150|0|      -2|0.0114|1239|0.599|39|399|13|||
N|N0003|200106|RYN|11|21|672|128546|700|127446|0|34511|58160|23802|10373|600|     -12|0.0552|52145|0.0532|29|64697|21|10604|0.0443|37
N|N0003|200106|RZT|11|21|212|44179|0|44079|100|16442|21497|5031|1209|0|      15|0.0511|18311|0.046|16|23659|13|2209|0.09|34
N|N0003|200106|SACPR|11|21|3|700|0|700|0|0|0|200|500|0|      53|1.1014||||700|86|||
N|N0003|200106|SACPRT|11|21|11|2493|0|2493|0|320|1463|300|410|0|      -2|0.2151|413|0.1299|17|1980|41|100|0.1|16
N|N0003|200106|SAIPRW|11|21|70|17471|0|17471|0|9608|6338|1125|400|0|     -25|0.0907|5971|0.0183|14|11400|15|100|0.03|7
N|N0003|200106|SBG|11|21|92|23981|0|23981|0|9947|6542|3638|3554|300|     -11|0.0256|12268|0.0161|38|11713|39|||
N|N0003|200106|SC|11|21|804|171378|1200|169328|600|35189|66402|34353|32589|1295|      -1|0.0425|67572|0.0423|115|82345|33|20011|0.0432|74
N|N0003|200106|SCG|11|21|813|174445|1450|172995|0|36451|63067|41038|31401|1038|     -26|0.0434|73380|0.0352|39|85091|31|14524|0.0479|57
N|N0003|200106|SCL|11|21|28|4080|0|4080|0|797|977|1156|1007|143|      18|0.1141|1361|0.0648|33|2719|95|||
N|N0003|200106|SCX|11|21|19|5156|0|5156|0|1378|1806|500|1472|0|      51|0.1732|871|0.1332|41|4185|42|100|0.14|18
N|N0003|200106|SCZ|11|21|416|93540|0|93440|100|37105|43330|8965|4140|0|      -2|0.0246|42050|0.032|19|49810|15|1680|0.0214|19
N|N0003|200106|SCZA|12|21|13|1667|270|1397|0|450|430|200|317|0|   -2735|6.7545|317|1|165|1080|17|||
N|N0003|200106|SDH|11|21|187|41816|0|41816|0|18699|18351|3596|1170|0|       5|0.0167|12656|0.0124|16|28810|12|350|0.0243|60
N|N0003|200106|SGH|11|21|24|6168|0|6168|0|1085|2758|1200|1125|0|       4|0.1265|2783|0.0408|37|3000|41|385|0.033|9
N|N0003|200106|SGI|11|21|340|72667|350|72017|300|24900|32188|9337|5892|0|       0|0.013|22488|0.0123|20|46559|19|3270|0.0143|58
N|N0003|200106|SGR|11|21|6170|1299132|35974|1259458|2700|574617|455207|144340|85394|2700|     133|0.0949|654440|0.1078|20|422851|13|184867|0.1534|37
N|N0003|200106|SGU|11|21|421|102190|475|101715|0|24400|44647|16278|15490|900|     -39|0.0787|50870|0.0602|40|46623|28|4222|0.0301|56
N|N0003|200106|SII|11|21|12161|2461601|89352|2366784|2800|708230|989797|446578|224144|835|      63|0.1034|1098122|0.0831|23|658194|17|613268|0.1146|34
N|N0003|200106|SLC|11|21|462|102521|0|102521|0|31777|51814|14017|4913|0|       8|0.0498|39662|0.0221|22|51426|15|11433|0.021|27
N|N0003|200106|SLI|11|21|223|40617|418|39999|200|9667|16424|8563|5445|100|      38|0.0584|15844|0.0585|43|20722|21|3633|0.0345|53
N|N0003|200106|SO|11|21|7112|1830209|2000|1815354|11800|580083|787613|325490|133214|754|      -4|0.0234|654768|0.0233|25|930696|18|241690|0.0333|29
N|N0003|200106|SOPRA|11|21|65|16715|0|16715|0|3470|8827|1949|2469|0|      -2|0.0665|4028|0.0293|35|11087|27|1600|0.0338|30
N|N0003|200106|SOPRB|11|21|65|17925|0|17925|0|5235|6861|2834|2995|0|      19|0.0985|10104|0.042|50|7421|23|400|0.0375|42
N|N0003|200106|SOPRC|11|21|62|16462|0|16462|0|2966|8671|3400|1425|0|     -30|0.0901|6935|0.0333|27|8927|25|600|0.0367|33
N|N0003|200106|SP|11|21|2259|417878|20700|395978|1000|88276|173307|84940|49425|1030|     346|0.2098|199842|0.171|26|116566|21|80570|0.2007|41
N|N0003|200106|SPN|11|21|400|100444|325|100119|0|31571|45383|12267|10898|0|      39|0.0288|43292|0.0424|30|56427|21|400|0.015|91
N|N0003|200106|SPP|11|21|229|51056|0|50756|300|10669|25951|9287|5149|0|      15|0.0357|20559|0.0263|30|27662|21|2835|0.0104|42
N|N0003|200106|SRE|11|21|4174|776656|470|775086|1100|536186|219314|17703|2755|228|      28|0.0319|347116|0.0326|9|370017|8|59053|0.036|11
N|N0003|200106|SREPRA|11|21|101|28661|0|28661|0|5688|17888|3435|1650|0|      11|0.1707|17662|0.1052|21|10199|21|800|0.075|20
N|N0003|200106|SSD|11|21|206|35844|500|35344|0|9983|16926|5118|3317|0|      60|0.1372|17605|0.1104|33|13239|17|4500|0.1138|32
N|N0003|200106|SSR|11|21|75|19430|0|19430|0|3254|10127|4436|1013|600|     -14|0.0911|7555|0.0238|45|11475|28|400|0.035|22
N|N0003|200106|STZ|11|21|1619|339807|2000|337207|600|85800|149849|59664|42094|400|      17|0.0667|138641|0.0823|34|166570|25|32596|0.0947|42
N|N0003|200106|STZB|12|21|2|624|0|624|0|0|0|0|624|0|     -12|2.1795||||400|153|224|0.25|294
N|N0003|200106|SUR|11|21|181|31393|0|31393|0|11609|15609|2915|1260|0|      -5|0.0639|12522|0.0329|17|17749|15|1122|0.04|22
N|N0003|200106|SUT|11|21|236|35284|0|35084|0|12819|18577|3588|100|0|     -43|0.0223|16575|0.0263|15|17409|13|1100|0.0291|14
N|N0003|200106|SUTPRA|11|21|47|10131|0|10131|0|1975|6048|2008|100|0|     -10|0.1397|5027|0.083|25|5104|15|||
N|N0003|200106|SVAPR|11|21|12|3315|0|3315|0|200|1775|1340|0|0|     -13|0.1859|1185|0.0888|22|1930|29|200|0.05|13
N|N0003|200106|SWM|11|21|126|25116|100|25016|0|8271|12267|3269|1209|0|      14|0.0897|9365|0.0636|26|13651|16|2000|0.075|24
N|N0003|200106|SZ|11|21|12|2987|0|2987|0|0|1937|900|150|0|       4|0.0453|500|0.03|30|2487|36|||
N|N0003|200106|TAPPRA|11|21|151|40656|0|40656|0|9089|25026|6266|275|0|      -1|0.0587|14590|0.0156|21|25766|17|300|0.03|15
N|N0003|200106|TAPPRB|11|21|23|5637|0|5637|0|628|4379|630|0|0|      22|0.112|4215|0.0363|18|1222|10|200|0.04|11
N|N0003|200106|TCC|11|21|160|33038|0|32738|300|5154|13144|8508|6232|0|       4|0.0487|15161|0.0428|44|15526|27|2351|0.0516|33
N|N0003|200106|TCH|11|21|46|10532|0|10532|0|1828|7022|700|982|0|      35|0.0697|2692|0.0298|26|7640|21|200|0.05|0
N|N0003|200106|TCLPR|11|21|23|6611|0|6611|0|2911|3700|0|0|0|       8|0.1033|1800|0.0339|16|4811|11|||
N|N0003|200106|TCR|11|21|254|64034|0|64034|0|13892|25318|11708|12916|200|     -26|0.0366|20925|0.0261|44|38017|34|5092|0.0244|58
N|N0003|200106|TD|11|21|444|84704|200|84504|0|26904|43499|9309|4792|0|      13|0.0518|30355|0.0191|20|40045|14|14104|0.0498|25
N|N0003|200106|TDI|11|21|22|5012|0|5012|0|850|2266|1175|721|0|     -21|0.177|2011|0.0975|46|3001|24|||
N|N0003|200106|TDR|11|21|26|4930|0|4930|0|160|4120|450|200|0|     -43|0.1429|3070|0.0602|24|1860|18|||
N|N0003|200106|TDY|11|21|602|111666|327|111339|0|39645|56089|11267|4338|0|      25|0.0325|46693|0.0382|21|60096|14|4550|0.0372|18
N|N0003|200106|TEE|11|21|387|93634|194|93440|0|38091|39954|10290|5205|0|       6|0.0979|55764|0.0522|17|33575|17|4101|0.0442|24
N|N0003|200106|TEF|11|21|1902|396187|0|395605|100|185332|137753|47922|24698|0|      39|0.0489|199060|0.031|21|167710|14|28935|0.0439|27
N|N0003|200106|TEM|11|21|5|975|0|975|0|375|200|400|0|0|      43|0.2467|300|0.1167|11|675|25|||
N|N0003|200106|TEN|11|21|340|70065|0|70065|0|20950|30885|10353|7877|0|      16|0.0338|26121|0.0405|24|39987|23|3957|0.0298|12
N|N0003|200106|TFS|11|21|769|145212|800|143612|800|41861|68860|23910|9781|0|      50|0.0531|57459|0.0478|23|76318|19|10635|0.0542|23
N|N0003|200106|TGT|11|21|13947|3240598|7313|3215448|13900|1249034|1213942|478651|281570|6151|       0|0.0267|1754183|0.0402|22|1020458|16|454707|0.0506|33
N|N0003|200106|THX|11|21|702|138946|400|137546|600|38790|53171|27131|18274|780|      22|0.0806|45773|0.104|35|75898|24|16475|0.1466|48
N|N0003|200106|TI|11|21|314|58047|100|57847|100|5609|27586|14591|9798|363|    -117|0.3006|31788|0.331|46|23256|24|2903|0.1905|36
N|N0003|200106|TIA|12|23|1|3300|2600|700|0|0|0|0|700|0|    -889|2.68||||700|208|||
N|N0003|200106|TLI|11|21|70|18393|0|18393|0|5914|7198|3215|2066|0|       6|0.0413|4007|0.0171|38|13686|23|700|0.0357|23
N|N0003|200106|TLK|11|21|37|9060|0|9060|0|1072|5706|1383|899|0|      13|0.0239|6138|0.0201|21|2922|33|||
N|N0003|200106|TOL|11|21|1670|345725|1300|343187|300|106434|153897|54404|28752|0|       2|0.0455|141820|0.0581|27|171803|19|29864|0.0657|25
N|N0003|200106|TR|11|21|913|189915|1800|188115|0|37995|79907|42395|26708|1110|     -93|0.0758|79587|0.0422|37|92597|28|15931|0.1202|54
N|N0003|200106|TRA|11|21|304|53919|100|53619|200|18468|22849|10610|1892|200|      -5|0.0187|18222|0.0285|24|34022|21|1575|0.0225|27
N|N0003|200106|TRP|11|21|180|40568|300|39968|300|18516|17508|3049|1195|0|      11|0.0269|17545|0.0144|14|22113|14|610|0.0166|13
N|N0003|200106|TRPPR|11|21|65|18352|0|18352|0|6762|8990|2100|500|0|      -1|0.0513|8625|0.0222|22|9527|12|200|0.03|10
N|N0003|200106|TRPPRC|11|21|25|6352|0|6352|0|3210|2942|200|0|0|      -3|0.0643|2510|0.0303|14|3842|11|||
N|N0003|200106|TTR|11|21|23|6839|0|6839|0|4785|1668|386|0|0|    -136|0.0552|1506|0.0338|10|5333|9|||
N|N0003|200106|TWE|11|21|558|116045|212|115233|600|36782|50391|20674|7986|0|     -79|0.0223|38403|0.0222|28|69540|19|7890|0.0292|31
N|N0003|200106|TWK|11|21|339|62550|426|62124|0|17218|21312|10709|12585|300|      46|0.0307|32607|0.0461|34|27617|38|1900|0.0442|41
N|N0003|200106|TX|11|21|10843|2376297|9060|2363465|2500|1397168|761431|163587|43779|0|      26|0.0354|1075238|0.0369|12|866775|10|423952|0.0385|15
N|N0003|200106|TXCPRA|11|21|138|35819|0|35819|0|20100|13164|1840|615|100|     -10|0.0725|12355|0.0141|13|22764|13|700|0.0557|15
N|N0003|200106|TXCPRB|11|21|33|7489|0|7489|0|2855|3884|600|150|0|     114|0.1246|3550|0.0445|12|3739|19|200|0.01|22
N|N0003|200106|TXN|11|21|32718|7538253|101229|7394161|34500|2539737|2403485|1376649|1086906|21884|      14|0.0401|3888049|0.0556|27|1778802|21|1761810|0.066|43
N|N0003|200106|UIS|11|21|3976|863380|300|860260|2600|520238|271865|59247|11158|352|       6|0.0169|410722|0.0227|12|392168|9|59970|0.0259|19
N|N0003|200106|VAP|11|21|25|5620|0|5620|0|1085|2560|500|1475|0|      46|0.0888|4035|0.0313|40|1485|25|100|0.02|11
N|N0003|200106|VBF|11|21|88|20011|0|20011|0|4270|7857|4087|3597|200|       3|0.0668|10578|0.0362|41|9233|30|200|0.02|320
N|N0003|200106|VEA|11|21|61|17329|0|17329|0|5199|9135|2195|800|0|     -27|0.0988|8620|0.0473|19|8309|17|400|0.04|15
N|N0003|200106|VELPRT|11|21|40|9565|0|9565|0|3225|5640|600|100|0|       1|0.1207|5245|0.0358|15|4020|10|300|0.07|21
N|N0003|200106|VGM|11|21|26|5974|0|5974|0|2694|2750|530|0|0|       8|0.0349|3386|0.0109|14|2588|12|||
N|N0003|200106|VGR|11|21|505|95521|600|94921|0|26817|43606|15460|8788|250|      76|0.1196|39410|0.111|32|46153|19|9358|0.0972|28
N|N0003|200106|VIG|11|21|10|2057|0|2057|0|389|1668|0|0|0|       5|0.0391|800|0.0125|10|1157|10|100|0.01|13
N|N0003|200106|VIN|11|21|31|6807|0|6807|0|2456|1434|892|2025|0|      15|0.0312|2010|0.013|41|4797|48|||
N|N0003|200106|VIT|11|21|48|12624|0|12624|0|7444|4875|305|0|0|       5|0.0359|6412|0.0114|11|5887|8|325|0.01|8
N|N0003|200106|VNV|11|21|7|2270|0|2270|0|780|1190|300|0|0|      -2|0.0457|538|0.01|26|1732|10|||
N|N0003|200106|VOD|11|21|7053|1514065|2700|1506152|4300|792257|578419|118150|21426|200|       8|0.0158|842187|0.0218|14|579386|10|88879|0.0263|17
N|N0003|200106|VOL|11|21|102|20551|0|20551|0|5757|10161|2999|1534|100|      37|0.0808|10322|0.0528|27|8844|20|1385|0.0453|26
N|N0003|200106|VOT|11|21|23|6573|0|6573|0|2658|3686|229|0|0|       2|0.0539|2850|0.0175|15|2968|10|755|0.01|23
N|N0003|200106|VPA|11|21|33|9050|0|9050|0|1907|5339|1300|504|0|      12|0.0632|5957|0.0343|22|3093|18|||
N|N0003|200106|VPQ|11|21|33|8868|0|8868|0|2747|4560|686|875|0|      10|0.0517|3903|0.0212|19|4965|23|||
N|N0003|200106|VRC|11|21|3288|721772|1186|719800|600|264831|294864|105814|54891|0|       6|0.045|286261|0.0307|21|317784|20|116355|0.0471|28
N|N0003|200106|VSH|11|21|2045|439313|1600|434513|3200|160494|181677|67281|28161|100|      22|0.0236|201249|0.0324|22|186762|16|49702|0.0348|26
N|N0003|200106|VVC|11|21|766|178642|300|178342|0|45864|72830|35634|23102|912|     -21|0.0386|69059|0.0436|36|101042|24|8241|0.0549|69
N|N0003|200106|VVR|11|21|328|83284|0|83284|0|28751|37822|13076|3635|0|      -4|0.013|15688|0.0125|22|66309|18|1287|0.01|29
N|N0003|200106|WFR|11|21|248|55333|0|55133|200|19295|21918|7154|6214|752|     -23|0.0502|20319|0.0448|40|31596|17|3418|0.0496|22
N|N0003|200106|WG|11|21|177|43323|200|43123|0|7887|16391|10247|8498|100|     -13|0.0786|26932|0.0573|40|12256|37|3935|0.0413|33
N|N0003|200106|WLP|11|21|3166|613165|3600|607565|1800|224212|285602|70528|28442|581|      53|0.0537|307476|0.0591|19|225772|15|76117|0.0715|21
N|N0003|200106|WNI|11|21|6|620|0|620|0|100|320|200|0|0|       5|0.0194|420|0.0333|11|200|39|||
N|N0003|200106|WSM|11|21|1521|335089|7400|327689|0|107654|147769|43968|28298|0|      61|0.0431|146297|0.0509|24|138437|17|42955|0.0611|38
N|N0003|200106|WTS|11|21|134|25867|0|25867|0|9094|10894|4105|1774|0|      21|0.0725|13047|0.0591|24|12620|23|200|0.01|8
N|N0003|200106|XRX|11|21|6165|1563755|1500|1551990|9300|899430|518310|111272|32278|0|       1|0.0141|589903|0.0185|14|835374|9|136013|0.0244|21
N|N0003|200106|XVF|11|21|284|63667|300|63367|0|20329|30220|10193|2625|0|     -66|0.2107|36209|0.0865|21|24028|17|3130|0.1246|6
N|N0003|200106|YLD|11|21|49|13280|0|13280|0|5464|4515|2276|1025|0|      -7|0.0193|3096|0.0162|19|9884|23|300|0.01|7
N|N0003|200106|YUM|11|21|3481|681270|15304|663764|1800|124966|222082|150777|158519|9220|      26|0.025|322286|0.0381|48|259741|38|83537|0.0503|67
N|N0003|200106|ZIF|11|21|45|9335|0|9335|0|3943|4592|700|100|0|     -26|0.0384|4741|0.018|12|4594|17|||
N|N0003|200106|ZMX|11|21|13|2620|0|2620|0|0|1999|353|268|0|     -14|0.0335|1979|0.0469|24|641|47|||'

	EXEC -t'|' -k 4,4 -lsum,regress,op=avg:float:17 $data/nyse.dat
		OUTPUT - $'N|N0003|200106|AA|11|21|14596|3524300|9331|3494983|15500|1129332|1283396|639798|452298|5659|1.05000|0.0289|1717663|0.038|30|1195358|20|597462|0.0481|35
N|N0003|200106|AAT|11|21|48|14046|0|14046|0|7421|4549|1485|591|0|       0|0.0304|2513|0.01|25|11333|14|200|0.01|90
N|N0003|200106|ABJ|11|21|57|14508|0|14508|0|2603|9175|1650|1080|0|2.52941|0.0779|6636|0.0136|17|7872|25|||
N|N0003|200106|ABS|11|21|7425|1465605|200|1461410|2900|483622|651665|241738|87165|120|0.25000|0.0284|599869|0.0306|22|670152|18|194289|0.0373|25
N|N0003|200106|ABT|11|21|14051|3368858|8904|3347422|10900|1469987|1273455|447558|166267|1055|0.50000|0.0273|1682138|0.0365|18|1150749|14|525435|0.044|25
N|N0003|200106|ACA|11|21|45|11490|0|11490|0|2845|7495|100|1050|0|-0.750|0.0946|5052|0.0146|17|6438|22|||
N|N0003|200106|ACS|11|21|2456|523323|13500|509523|0|192518|202103|71973|42229|700|3.95000|0.0658|254514|0.0654|21|177869|17|77140|0.0915|38
N|N0003|200106|AEF|11|21|210|61757|0|61757|0|9524|22881|15536|13616|200|-0.300|0.0464|24867|0.0137|47|35248|43|1642|0.0401|27
N|N0003|200106|AET|11|21|2439|472785|900|471531|300|213068|162069|63465|32949|280|1.20000|0.0217|214120|0.0315|22|224763|16|32948|0.035|26
N|N0003|200106|AGC|11|21|6689|1443428|2747|1438956|1000|588445|574302|188125|88940|0|0.15000|0.0283|603123|0.0256|22|661220|16|175613|0.0329|31
N|N0003|200106|AGCPRA|11|21|56|16339|0|16339|0|3810|5914|4990|1625|0|1.05882|0.1187|7461|0.11|44|8678|25|200|0.085|8
N|N0003|200106|AGCPRB|11|21|25|6853|0|6853|0|100|3855|1550|1348|0|2.68750|0.115|3097|0.0587|44|3756|46|||
N|N0003|200106|AGCPRM|11|21|57|15702|100|15602|0|1685|7911|3046|2170|790|-1.438|0.0876|4071|0.0247|64|11031|65|500|0.078|166
N|N0003|200106|AGCPRMCL|11|21|4|1223|0|1223|0|0|923|300|0|0|1.70000|0.04|1223|0.01|22|||||
N|N0003|200106|AGCPRN|11|21|82|18338|0|18338|0|5186|8423|2223|2306|200|      -1|0.0967|2885|0.0334|65|15203|23|250|0.046|21
N|N0003|200106|AGCPRNCL|11|21|3|665|0|665|0|100|565|0|0|0|1.14286|0.01||||665|21|||
N|N0003|200106|AGI|11|21|23|4879|0|4879|0|730|2761|1388|0|0|0.88889|0.0238|4099|0.0433|19|780|29|||
N|N0003|200106|AHO|11|21|514|101764|100|101464|200|25120|56355|13898|6291|0|0.20000|0.061|51772|0.043|22|43731|19|6161|0.0371|23
N|N0003|200106|AIV|11|21|697|143764|0|143464|0|58036|56027|19187|10214|0|-0.100|0.0629|54117|0.0484|20|80319|20|9028|0.0438|29
N|N0003|200106|AIVPRC|11|21|23|5998|0|5998|0|2025|2725|948|300|0|-0.333|0.1098|2675|0.0259|25|3023|15|300|0.09|37
N|N0003|200106|AIVPRD|11|21|63|15180|0|15180|0|5430|8025|825|900|0|1.33333|0.1226|6105|0.0322|15|8975|24|100|0.04|12
N|N0003|200106|AIVPRG|11|21|45|12295|0|12295|0|3195|6435|1315|1350|0|-0.389|0.0783|3675|0.0122|30|7920|24|700|0.0343|32
N|N0003|200106|AIVPRH|11|21|25|5959|0|5959|0|2100|3074|785|0|0|-1.625|0.1345|2824|0.0322|13|3035|18|100|0.11|9
N|N0003|200106|AIVPRK|11|21|9|2070|0|2070|0|0|1070|600|400|0|0.33333|0.4413|1350|0.1863|48|720|20|||
N|N0003|200106|AIVPRP|11|21|56|11916|0|11916|0|3681|4873|2148|1214|0|       1|0.2129|3376|0.0379|23|8540|26|||
N|N0003|200106|AIVPRQ|11|21|39|10242|0|10242|0|3898|5497|327|520|0|-0.105|0.0792|4613|0.0174|19|5629|13|||
N|N0003|200106|AJG|11|21|875|196649|600|196049|0|80999|79015|21230|12954|1851|0.95000|0.0426|79215|0.0366|26|106810|13|10024|0.0518|45
N|N0003|200106|ALM|11|21|38|9137|0|9137|0|300|7876|961|0|0|-1.389|0.0618|7139|0.0245|19|1998|15|||
N|N0003|200106|ALPPRN|11|21|3|1290|0|1290|0|0|890|400|0|0|0.20000|0.181|400|0.05|16|890|21|||
N|N0003|200106|ALPPRO|11|21|6|1700|0|1700|0|0|1700|0|0|0|-9.778|0.2247|950|0.0621|26|750|18|||
N|N0003|200106|ALPPRQ|11|21|28|7400|0|7400|0|2517|4483|400|0|0|0.21429|0.0795|3496|0.0287|17|3904|11|||
N|N0003|200106|ALPPRR|11|21|43|12186|0|12186|0|2223|8511|1152|300|0|-1.294|0.0713|4546|0.0179|18|7540|15|100|0.04|63
N|N0003|200106|ALQ|11|21|53|14947|0|14947|0|5706|7091|2050|100|0|0.83333|0.0864|8607|0.0231|21|6040|12|300|0.01|7
N|N0003|200106|ALZ|11|21|38|10019|0|10019|0|800|8563|656|0|0|2.29412|0.1095|6749|0.0256|19|3270|13|||
N|N0003|200106|AMB|11|21|340|82057|0|81694|0|49345|26444|3944|1961|0|0.15000|0.029|37759|0.0248|12|40635|11|3300|0.0224|15
N|N0003|200106|AMBPRA|11|21|19|5460|0|5460|0|3560|1700|200|0|0|       1|0.1091|3300|0.0473|10|2160|13|||
N|N0003|200106|AMD|11|21|22321|4782471|105767|4655665|17300|1343670|1809871|952933|564656|1635|0.70000|0.0399|2160554|0.0464|24|1180503|21|1331908|0.0601|37
N|N0003|200106|ANN|11|21|1471|308613|7500|301013|100|160173|110558|25319|5063|0|2.95000|0.0525|131184|0.0608|13|134861|10|35068|0.0762|17
N|N0003|200106|AOC|11|21|3951|740421|1545|737685|900|213132|304297|146622|73959|575|0.50000|0.0241|340231|0.0367|28|337678|21|60676|0.0378|34
N|N0003|200106|ARB|11|21|432|81559|300|81259|0|24043|40724|12568|3924|0|0.90000|0.0549|39589|0.0546|22|36715|18|4955|0.0477|23
N|N0003|200106|ARH|11|21|9|1815|0|1815|0|400|1115|100|200|0|-0.350|0.0527|1190|0.0182|31|625|19|||
N|N0003|200106|ATI|11|21|1153|204221|195|204026|0|95949|86063|15394|6520|100|1.10000|0.0249|88367|0.0285|16|109155|13|6504|0.0249|20
N|N0003|200106|AVP|11|21|5362|1025278|1664|1021714|1300|640871|320330|47980|12801|1032|1.30000|0.0305|463631|0.0358|10|466899|8|92484|0.0454|15
N|N0003|200106|AVZ|11|21|203|42999|0|42899|100|15985|19543|6471|1000|0|1.30000|0.1957|20702|0.1167|19|19355|14|2942|0.0663|19
N|N0003|200106|AXL|11|21|233|43442|0|43442|0|11343|20974|6885|4240|0|-0.950|0.0834|21281|0.0732|30|20822|22|1339|0.0249|14
N|N0003|200106|AZA|11|21|4036|777156|5600|770456|500|475253|227074|51985|16512|132|-0.200|0.0359|346051|0.0248|11|287853|9|137052|0.035|17
N|N0003|200106|AZZ|11|21|141|30688|0|30688|0|5454|17696|5938|1600|0|2.62500|0.0925|17081|0.0713|24|12107|24|1500|0.0293|20
N|N0003|200106|BC|11|21|1794|347438|2150|344388|900|119326|140853|55052|29034|1023|1.40000|0.0287|151059|0.0335|27|165409|19|28820|0.0421|28
N|N0003|200106|BCC|11|21|1261|232534|1500|231034|0|90880|102617|27338|10199|0|1.60000|0.0495|86498|0.0425|21|123377|15|21159|0.0489|20
N|N0003|200106|BD|11|21|132|26224|200|26024|0|8210|15964|1850|0|0|       0|0.0147|10370|0.0141|12|14654|13|1000|0.014|21
N|N0003|200106|BDF|11|21|39|9620|0|9620|0|3229|4243|1738|410|0|-1.188|0.0565|2903|0.0136|13|6717|23|||
N|N0003|200106|BGG|11|21|774|164711|600|163823|0|76597|68590|14556|4080|0|1.31579|0.0874|65955|0.0439|16|85847|11|12021|0.0977|21
N|N0003|200106|BGT|11|21|60|15473|0|15473|0|8014|5024|1985|450|0|0.50000|0.0185|3385|0.01|10|12088|14|||
N|N0003|200106|BK|11|21|14814|3340606|5800|3332030|800|2109454|974660|195186|53530|0|1.20000|0.0372|1548826|0.0305|11|1273475|9|510529|0.0417|16
N|N0003|200106|BKE|11|21|104|18544|0|18544|0|3788|12093|2226|437|0|1.70000|0.0528|10301|0.0694|18|7843|20|400|0.035|15
N|N0003|200106|BKPRC|11|21|66|17897|0|17897|0|10855|5842|850|350|0|0.44444|0.0857|8767|0.0274|15|8630|11|500|0.028|7
N|N0003|200106|BKPRD|11|21|80|21826|0|21826|0|13055|7571|500|700|0|0.68421|0.0714|10371|0.0168|11|11155|14|300|0.08|18
N|N0003|200106|BKPRE|11|21|81|23243|0|23243|0|10876|10497|1470|400|0|1.66667|0.0832|15715|0.0205|15|7528|12|||
N|N0003|200106|BLI|11|21|1232|227952|1609|226143|100|75627|104943|33926|11747|0|0.50000|0.0263|112032|0.0332|20|104908|17|9303|0.0328|22
N|N0003|200106|BNI|11|21|6187|1206018|400|1203328|1600|680896|414696|85020|23178|1138|       0|0.0285|588392|0.0262|13|511908|10|104628|0.0403|19
N|N0003|200106|BR|11|21|7135|1378982|4900|1370416|2000|687207|493400|131614|58722|1473|0.60000|0.0302|782525|0.0406|16|459377|12|130514|0.0503|29
N|N0003|200106|BRG|11|21|56|11360|0|11360|0|2143|6614|1791|812|0|-1.765|0.1699|6410|0.118|29|4850|22|100|0.1|63
N|N0003|200106|BSP|11|21|25|4791|0|4791|0|1745|2537|509|0|0|0.63158|0.0835|2054|0.0143|14|2337|15|400|0.045|9
N|N0003|200106|BTY|11|21|1036|203914|400|203314|200|78459|82586|27485|14884|100|5.36842|0.1174|111376|0.0744|24|78300|16|13838|0.0657|24
N|N0002|200106|BTYRT|11|21|239|50506|0|50506|0|19517|24313|3320|3356|0|-60.30|0.1598|32175|0.1498|23|17731|14|600|0.055|20
N|N0003|200106|BWG|11|21|30|6512|0|6512|0|1183|4379|650|300|0|-0.333|0.1734|4366|0.0936|24|2046|21|100|0.08|0
N|N0003|200106|BXS|11|21|157|33939|0|33939|0|14334|13818|5063|724|0|0.65000|0.0378|17439|0.042|14|15418|17|1082|0.0204|22
N|N0003|200106|BYD|11|21|166|35218|200|35018|0|8011|13121|6471|7115|300|0.05000|0.0426|12541|0.0321|37|19449|44|3028|0.0338|50
N|N0003|200106|BZL|11|21|10|2330|0|2330|0|1000|400|530|400|0|-0.222|0.0748|1130|0.04|53|800|8|400|0.02|7
N|N0003|200106|C|11|21|36206|7798662|31303|7747379|16900|3563357|2481386|1113981|603003|2552|0.05000|0.0228|4246991|0.0389|19|2228824|15|1288464|0.0463|33
N|N0003|200106|CBM|11|21|983|194272|2240|191632|0|63286|89872|27044|11430|0|4.15000|0.1101|81401|0.0814|22|85841|16|24390|0.132|30
N|N0003|200106|CCC|11|21|209|43832|300|43532|0|9359|19019|8257|6297|600|0.50000|0.0488|20746|0.0443|44|20283|29|2503|0.0202|39
N|N0003|200106|CCPPRA|11|21|60|13025|0|13025|0|2350|7424|2707|544|0|-4.333|0.3285|5751|0.0625|18|6774|26|500|0.058|17
N|N0003|200106|CCR|11|21|3630|728090|6800|719678|1000|267653|271128|122720|59077|100|2.45000|0.0301|346880|0.0381|22|277870|18|95928|0.0488|30
N|N0003|200106|CEA|11|21|10|2229|0|2229|0|300|1601|328|0|0|-1.857|0.1549|928|0.031|17|1201|16|100|0.01|16
N|N0003|200106|CED|11|21|138|25925|300|25625|0|5812|12625|5838|1350|0|0.80000|0.108|13523|0.0484|25|10252|19|1850|0.043|36
N|N0003|200106|CEM|11|21|155|30385|0|30385|0|6560|16100|6125|1600|0|-0.500|0.0917|15567|0.0682|23|13468|23|1350|0.0337|30
N|N0003|200106|CEN|11|21|498|110436|0|110236|200|45363|46318|11486|6969|300|-0.400|0.0306|50010|0.0344|21|55025|14|5401|0.0262|38
N|N0003|200106|CF|11|21|3637|639764|3248|634316|1500|182374|248718|123189|77927|3608|0.40000|0.0254|286515|0.033|30|282454|22|66847|0.0282|49
N|N0003|200106|CFE|11|21|7|1684|0|1684|0|1300|100|284|0|0|-2.714|0.1669|984|0.25|18|700|8|||
N|N0003|200106|CFN|11|21|16|4234|0|4234|0|1018|1116|1300|800|0|-0.400|0.0828|1200|0.3967|71|3034|26|||
N|N0003|200106|CGPPRG|12|21|54|5400|4900|500|0|0|100|200|200|0|-14.50|0.184|200|0.75|80|300|33|||
N|N0003|200106|CGPPRI|11|21|4|750|0|750|0|0|200|0|400|150| -18.71|0.026|550|0.7182|511|200|23|||
N|N0003|200106|CGPPRT|11|21|38|9711|0|9711|0|3766|4598|1147|200|0|      -3|0.0734|2517|0.0372|15|7042|15|152|0.01|24
N|N0003|200106|CHD|11|21|606|132464|1359|131105|0|52672|55896|14149|7853|535|-0.579|0.0634|55486|0.0467|19|68291|17|7328|0.0501|27
N|N0003|200106|CHH|11|21|242|54062|0|53762|0|17816|21767|9596|4583|0|       0|0.0552|26188|0.0734|31|23562|16|4012|0.0527|16
N|N0002|200106|CHTRT|11|21|12|3174|0|3174|0|160|0|320|2375|319|1.43750|0.0609|1735|0.0113|116|1439|198|||
N|N0002|200106|CHTRTWI|12|24|1|5000|0|5000|0|0|0|5000|0|0|-1.200|0.04||||5000|31|||
N|N0003|200106|CIC|11|21|184|49613|0|49613|0|12025|25301|7518|4769|0|-0.950|0.0656|15733|0.0419|22|33280|25|600|0.0533|62
N|N0003|200106|CIP|11|21|84|22418|0|22418|0|4677|16266|1050|425|0|-1.211|0.0745|11685|0.0212|16|10033|16|700|0.0229|12
N|N0003|200106|CIR|11|21|339|57557|600|56957|0|24724|23479|6114|2640|0|3.75000|0.0568|31783|0.0736|16|21547|14|3627|0.1043|30
N|N0003|200106|CKC|11|21|157|29607|0|29607|0|9386|15183|3387|1651|0|-3.526|0.0255|7241|0.0637|30|21486|17|880|0.0327|46
N|N0003|200106|CKH|11|21|487|88089|0|88089|0|41269|36261|7618|2941|0|0.30000|0.0825|32140|0.0668|15|48565|12|7384|0.0821|18
N|N0003|200106|CLB|11|21|640|122678|600|122078|0|25245|56302|22564|17297|670|2.85000|0.0714|57167|0.0743|39|58510|25|6401|0.0322|58
N|N0003|200106|CLJ|11|21|236|38026|0|38026|0|5116|17590|8934|6386|0|-1.474|0.0909|17649|0.0682|43|19877|32|500|0.042|67
N|N0003|200106|CLL|11|21|46|8406|300|8106|0|1238|4650|1785|433|0|-2.667|0.2263|3948|0.1524|16|3958|24|200|0.29|58
N|N0003|200106|CMO|11|21|543|106712|0|106312|400|43418|52504|8949|1841|0|2.90000|0.0488|53463|0.043|16|49371|12|3878|0.0384|11
N|N0003|200106|CMOPRA|11|21|15|3043|0|3043|0|1294|850|599|300|0|3.72727|0.3056|1249|0.5695|35|1794|16|||
N|N0003|200106|CMOPRB|11|21|38|10036|0|10036|0|3886|4894|915|341|0|2.45000|0.13|3128|0.0804|19|6528|19|380|0.01|14
N|N0003|200106|CMP|11|21|326|73395|0|73395|0|17955|42915|9935|2590|0|-0.895|0.1083|20714|0.0277|19|48680|18|4001|0.0559|33
N|N0003|200106|CMS|11|21|2234|430340|888|427110|2000|222679|168912|27920|9599|0|1.80000|0.0312|192319|0.0264|13|205993|11|30798|0.0334|18
N|N0003|200106|CMSPRJ|11|21|22|6005|0|6005|0|975|4230|800|0|0|2.92308|0.2442|3930|0.0288|18|1775|17|300|0.1|17
N|N0003|200106|CMSPRK|11|21|33|9399|0|9399|0|800|7649|950|0|0|1.14286|0.2479|2575|0.0399|17|6124|18|700|0.1843|12
N|N0003|200106|CMSPRL|11|21|35|9413|0|9413|0|2016|4977|2005|415|0|3.75000|0.1851|4199|0.0565|24|4814|22|400|0.1|37
N|N0003|200106|CMSPRM|11|21|7|1698|0|1698|0|0|1398|0|300|0|-0.333|0.3419|1398|0.0949|20|||300|0.25|156
N|N0003|200106|CMSPRN|11|21|17|4241|0|4241|0|523|2258|1260|200|0|0.60000|0.0779|3641|0.0212|28|600|9|||
N|N0003|200106|CNA|11|21|681|155244|0|154844|400|57125|83968|12351|1800|0|0.35000|0.0546|66722|0.0293|14|80492|10|8030|0.033|17
N|N0003|200106|CNL|11|21|567|129633|100|129233|300|70295|48666|7529|3043|0|-1.700|0.0612|53723|0.0363|14|69264|10|6546|0.0487|18
N|N0003|200106|CNN|11|21|21|4852|0|4852|0|2531|1646|200|475|0|0.05882|0.038|3087|0.0285|13|1765|48|||
N|N0003|200106|COE|11|21|21|5098|0|5098|0|1085|1178|1635|1200|0|0.50000|0.0358|1785|0.0243|33|3313|59|||
N|N0003|200106|COG|11|21|625|131188|1478|129510|200|31708|55095|27764|14801|342|0.55000|0.0433|60097|0.0666|32|60933|24|8680|0.0682|51
N|N0003|200106|CPD|11|21|41|9634|0|9634|0|4435|3309|1640|250|0|1.41667|0.0417|7584|0.0444|18|2050|11|||
N|N0003|200106|CPP|11|21|13|3230|0|3230|0|900|1350|980|0|0|11.0909|0.1737|900|0.0567|28|2330|18|||
N|N0003|200106|CPRE|11|21|90|23321|0|23321|0|2550|15745|3669|1357|0|-0.550|0.0674|13212|0.0199|26|9709|18|400|0.1|41
N|N0003|200106|CPRF|11|21|6|1100|0|1100|0|0|900|0|200|0|-4.750|0.3159|250|0.48|23|850|28|||
N|N0003|200106|CPRG|11|21|7|1326|0|1326|0|0|764|562|0|0|5.90909|0.4987|664|0.1324|29|662|30|||
N|N0003|200106|CPRH|11|21|6|1320|0|1320|0|0|600|720|0|0|15.1667|0.422|920|0.1978|23|400|59|||
N|N0003|200106|CPRK|11|21|42|11084|0|11084|0|500|7692|2092|600|200|2.82353|0.2243|5553|0.0862|41|5131|29|400|0.165|32
N|N0003|200106|CPRM|11|21|10|2226|0|2226|0|339|960|727|200|0|13.4444|0.5577|1580|0.2241|29|446|18|200|0.25|38
N|N0003|200106|CPRN|11|21|43|11091|0|11091|0|2000|7226|1205|660|0|0.88235|0.0632|5145|0.0127|21|5946|26|||
N|N0003|200106|CPRQ|11|21|4|1200|0|1200|0|0|500|700|0|0|20.6667|0.5625|400|0.05|31|600|21|200|0.1|22
N|N0003|200106|CPRR|11|21|2|500|0|500|0|0|300|0|200|0|25.6000|0.602|300|0.03|26|200|72|||
N|N0003|200106|CPRU|11|21|12|3145|0|3145|0|200|1745|800|400|0|15.5000|0.5192|1470|0.0813|20|1675|47|||
N|N0003|200106|CPRW|11|21|203|54632|0|54632|0|10698|29850|9542|4142|400|0.33333|0.0715|24025|0.0144|27|30207|31|400|0.04|21
N|N0003|200106|CPRX|11|21|152|45053|400|44653|0|9460|26551|5112|3530|0|0.20000|0.0603|19055|0.0159|31|25098|22|500|0.044|106
N|N0003|200106|CQPRA|11|21|80|19210|0|19210|0|5594|9166|3275|1175|0|-2.313|0.1641|10230|0.0347|18|8480|27|500|0.08|40
N|N0003|200106|CRM|11|21|6|1000|0|1000|0|0|300|0|700|0|-6.429|-0.057|500|0.81|65|500|66|||
N|N0003|200106|CRY|11|21|1181|234595|3650|230145|500|98877|107261|19489|5018|0|5.40000|0.1235|91095|0.097|16|107036|12|32514|0.1306|20
N|N0003|200106|CSL|11|21|702|142404|860|141544|0|43960|64987|21866|10199|532|-0.200|0.0624|60868|0.0381|24|68088|17|12588|0.0475|27
N|N0003|200106|CSP|11|21|46|11788|0|11188|600|4305|5430|1114|939|0|0.40000|0.0379|3505|0.0229|13|8183|24|100|0.02|14
N|N0003|200106|CVC|11|21|1573|300546|2400|297846|0|124254|143338|23288|6966|0|3.85000|0.0522|119404|0.0584|16|145555|12|32887|0.052|19
N|N0003|200106|CVD|11|21|957|215338|1250|212285|1000|63619|102151|34471|13044|0|0.40000|0.0433|91877|0.0469|22|107181|19|14227|0.0438|27
N|N0003|200106|CW|11|21|64|11629|0|11629|0|1568|7271|1704|1086|0|-1.357|0.1445|5531|0.0981|29|5598|18|500|0.082|24
N|N0003|200106|CWN|11|21|268|59776|200|59176|400|10708|28045|14206|6517|100|0.10000|0.0268|23025|0.035|36|35286|30|1265|0.0361|38
N|N0003|200106|CWNPRA|11|21|23|5460|0|5460|0|1280|2775|1105|300|0|4.92857|0.1623|2850|0.0813|21|2610|29|||
N|N0003|200106|CYE|11|21|163|44347|0|44047|300|11950|16310|9270|6567|250|-1.150|0.029|15808|0.0208|39|28139|28|400|0.03|68
N|N0003|200106|D|11|21|6378|1219758|2220|1216438|1100|899099|288283|25052|5104|0|1.50000|0.0547|587917|0.0449|8|463592|7|166029|0.0507|10
N|N0003|200106|DCP|11|21|120|23882|0|23882|0|6845|13962|2650|425|0|-1.647|0.4252|14729|0.1923|19|9153|17|||
N|N0003|200106|DCS|11|21|26|4646|100|4546|0|826|1934|886|900|0|-0.056|0.0374|646|0.0154|28|3900|39|||
N|N0003|200106|DDF|11|21|130|34631|104|34527|0|7804|18014|5335|3374|0|-1.750|0.0619|12217|0.0453|22|21810|22|500|0.01|12
N|N0003|200106|DFG|11|21|322|57038|0|57038|0|27051|22775|5339|1873|0|-0.833|0.0532|24654|0.036|18|28384|11|4000|0.0359|16
N|N0003|200106|DGX|11|21|5186|1005363|24875|978733|1100|406700|402320|118543|51365|905|7.85000|0.1035|454631|0.1058|20|354981|15|170221|0.1344|24
N|N0003|200106|DHY|11|21|69|15511|0|15511|0|3644|6401|3456|1868|142|      -1|0.0212|5804|0.0202|39|9407|33|300|0.01|39
N|N0003|200106|DJM|11|21|2|830|0|830|0|400|430|0|0|0|0.41667|0.1004|430|0.01|22|400|4|||
N|N0003|200106|DLX|11|21|1601|281299|2671|278216|300|71701|103284|50590|50913|2028|1.70000|0.0344|101971|0.0331|40|151551|33|24994|0.05|48
N|N0003|200106|DNB|11|21|925|207241|100|207141|0|97114|83577|20796|5654|0|0.45000|0.0423|106479|0.0315|16|90982|12|9680|0.0268|21
N|N0003|200106|DNR|11|21|384|73429|101|72428|900|27435|35656|7906|2331|0|0.60000|0.0339|30182|0.0324|16|39174|15|3972|0.0371|19
N|N0003|200106|DNY|11|21|1965|380145|100|379832|0|216298|132793|19890|10851|0|-0.200|0.0381|156676|0.0298|13|193479|12|29677|0.0313|15
N|N0003|200106|DPRA|11|21|125|35911|0|35911|0|16642|14590|3109|1570|0|-1.833|0.1137|13725|0.0222|17|20986|15|1200|0.0733|17
N|N0003|200106|DSU|11|21|261|76624|280|76344|0|28055|28115|11749|8425|0|-0.450|0.0231|27021|0.0138|28|48009|27|1314|0.0163|34
N|N0003|200106|DT|11|21|2026|446775|1300|444775|700|253675|148003|35543|8254|0|0.10000|0.0166|202363|0.0184|12|202306|10|40806|0.0204|23
N|N0003|200106|DV|11|21|677|149804|900|148704|200|53027|64825|19880|10136|1036|2.63158|0.0764|65449|0.0428|22|72670|17|10785|0.0449|21
N|N0003|200106|EAS|11|21|709|158503|600|157500|0|70724|51100|22068|13608|0|0.30000|0.0322|57187|0.035|26|94069|17|6244|0.0266|40
N|N0003|200106|ED|11|21|4263|765164|1625|760880|1700|269390|288368|128899|73604|4061|0.40000|0.0326|315254|0.0402|32|364869|20|82457|0.0417|45
N|N0003|200106|EDE|11|21|259|54956|0|54856|100|22840|24852|6013|1251|100|-2.421|0.0399|26989|0.0521|15|25555|16|2412|0.0353|19
N|N0003|200106|EDEPRD|11|21|20|4917|0|4917|0|900|2790|1127|100|0|3.91667|0.0871|4417|0.1058|19|300|26|200|0.06|31
N|N0003|200106|EDL|11|21|93|24045|0|24045|0|4069|14154|4450|1372|0|-0.850|0.0953|4642|0.0249|30|17298|22|2105|0.0329|18
N|N0003|200106|EDO|11|21|700|150405|2000|148405|0|48400|64713|22279|12513|500|0.55000|0.0571|72066|0.0717|23|66460|15|9879|0.0961|31
N|N0003|200106|EDPRA|11|21|19|3320|0|3320|0|500|1950|400|470|0|-12.22|0.8095|1820|0.7951|31|1200|27|300|0.4167|28
N|N0003|200106|EFL|11|21|24|4491|0|4491|0|1783|2333|275|100|0|-0.400|0.1064|3238|0.0392|14|1253|18|||
N|N0003|200106|ELN|11|21|8381|1698154|28233|1658521|9800|591927|749792|247952|77850|800|3.55000|0.0376|896938|0.0543|20|574910|16|196473|0.0643|24
N|N0003|200106|ELNWSA|11|21|81|15924|0|15924|0|2530|8535|2849|2010|0|3.11111|0.618|9810|0.2236|33|5214|14|900|0.1233|61
N|N0003|200106|ELNWSB|11|21|16|3710|0|3710|0|950|1510|800|450|0|6.21429|1.0969|2100|0.5145|54|1410|12|200|0.79|20
N|N0003|200106|EMC|11|21|47650|9897171|68202|9782039|39300|3244345|4085888|1836849|651461|1701|-0.050|0.0249|5060991|0.0472|22|2257708|15|2502640|0.0544|30
N|N0003|200106|EMD|11|21|14|3634|0|3634|0|200|2219|700|515|0|2.05556|0.0971|1119|0.0607|21|2515|31|||
N|N0003|200106|EPG|11|21|18292|3812438|35121|3757321|15900|1178720|1457845|694790|424248|17468|1.65000|0.0318|2175190|0.0565|26|985314|20|612717|0.0627|36
N|N0003|200106|EPGPR|11|21|4|589|0|589|0|0|0|100|489|0|27.6667|1.1746|489|0.234|91|100|142|||
N|N0003|200106|EPGPRC|11|21|9|1800|0|1800|0|0|200|800|400|400|-42.33|1.6667|500|0.298|99|900|253|400|1.05|42
N|N0003|200106|EPI|11|21|126|33956|200|33756|0|10726|15906|5444|1680|0|-0.316|0.0843|13803|0.0236|22|19153|19|800|0.0238|21
N|N0003|200106|EPL|11|21|326|76532|0|76232|300|31698|32628|8058|4148|0|4.30000|0.039|33547|0.0448|20|41085|15|1900|0.0384|30
N|N0003|200106|EPN|11|21|918|207403|200|207003|200|67977|98548|24636|15492|550|-0.800|0.0573|111443|0.0584|22|85320|22|10440|0.0449|39
N|N0003|200106|ESI|11|21|1347|263316|10079|252937|200|72537|103484|43898|32168|1050|1.75000|0.0683|113865|0.0789|32|107821|21|31451|0.1062|56
N|N0003|200106|ETA|11|21|30|6305|0|6305|0|800|3730|1385|390|0|-0.450|0.0437|3350|0.023|24|2855|29|100|0.04|38
N|N0003|200106|EX|11|21|189|36259|200|36059|0|11720|18552|4551|1236|0|0.95000|0.0391|16262|0.0377|21|18701|14|1096|0.0338|35
N|N0003|200106|FC|11|21|39|7273|0|7273|0|2340|3733|1100|100|0|1.47059|0.0469|4128|0.0602|21|3045|11|100|0.02|14
N|N0003|200106|FCX|11|21|2268|477507|0|477007|500|224775|186859|45247|20626|0|-0.450|0.0182|200039|0.0292|19|251445|13|26023|0.0258|17
N|N0003|200106|FCXA|11|21|203|43156|440|42716|0|15376|22763|3384|1049|144|0.78947|0.0382|23814|0.0421|19|17487|13|1415|0.0248|40
N|N0003|200106|FCXPRA|11|21|76|18015|0|18015|0|5645|7438|3682|1250|0|1.05263|0.0635|11571|0.0507|23|6444|22|||
N|N0003|200106|FCXPRB|11|21|66|14738|0|14738|0|3662|8961|1765|350|0|-0.929|0.1379|5695|0.0608|21|9043|19|||
N|N0003|200106|FCXPRC|11|21|18|4202|0|4202|0|0|2202|1700|300|0|2.73333|0.1058|1100|0.0409|35|3102|25|||
N|N0003|200106|FCXPRD|11|21|32|7878|0|7878|0|754|6474|650|0|0|-0.529|0.0839|4508|0.0431|17|3370|19|||
N|N0003|200106|FE|11|21|4339|852395|1200|849495|600|440011|305729|80238|22433|1684|0.70000|0.0259|297521|0.0334|15|484823|12|67751|0.0391|18
N|N0003|200106|FLR|11|21|2918|566592|10100|554892|1000|189895|244194|85222|36481|100|       4|0.062|286010|0.0751|20|184057|16|85825|0.1055|33
N|N0003|200106|FMC|11|21|1529|300685|6100|294585|0|119860|125954|33675|15096|0|5.50000|0.06|158560|0.0587|18|100317|17|35708|0.0695|31
N|N0003|200106|FO|11|21|2620|497417|300|496617|200|263838|184257|39171|9551|0|0.85000|0.0459|217394|0.0347|13|239890|11|39533|0.0497|21
N|N0003|200106|FOE|11|21|591|125134|506|124228|0|44257|57903|16669|5399|0|0.85000|0.0377|56458|0.0374|20|61161|16|6609|0.0451|19
N|N0003|200106|FOPRA|13|21|1|300|300|0|0|0|0|0|0|0|0|||||||||
N|N0003|200106|FOR|11|21|60|12184|0|12184|0|8401|3433|350|0|0|0.31579|0.0292|7012|0.0142|10|5172|7|||
N|N0003|200106|FPCPRA|11|21|74|22202|0|22202|0|9105|6257|2976|3864|0|       2|0.1081|10106|0.0562|28|12096|34|||
N|N0003|200106|FRC|11|21|251|47308|200|47108|0|11567|14565|9783|10893|300|1.84211|0.0645|16764|0.0702|53|24944|38|5400|0.1115|77
N|N0003|200106|FSH|11|21|917|195393|1100|194093|200|78546|81804|23834|10409|0|2.55000|0.0717|92235|0.068|22|89125|14|12933|0.0638|25
N|N0003|200106|FTI|11|21|1980|362127|100|361927|100|145638|148580|54179|13530|100|4.85000|0.0225|195780|0.0546|19|152912|17|13335|0.0439|26
N|N0003|200106|FWJ|11|21|3|900|0|900|0|0|900|0|0|0|-0.143|0.1167|300|0.1|18|600|20|||
N|N0003|200106|GBE|11|21|23|4475|0|4475|0|1148|1629|814|884|0|-0.118|0.0771|2092|0.049|30|2083|24|300|0.05|49
N|N0003|200106|GCG|11|21|4|900|0|900|0|400|0|100|400|0|0.70588|-0.0011|700|0.0443|57|200|0|||
N|N0003|200106|GDP|11|21|20|4550|0|4550|0|1660|2414|476|0|0|1.42105|0.0799|1889|0.0255|18|2261|11|400|0.015|11
N|N0003|200106|GGT|11|21|114|24322|0|24322|0|9040|11256|3414|612|0|-0.105|0.0914|9010|0.0369|16|14434|18|878|0.0613|14
N|N0003|200106|GGTPR|11|21|9|2302|0|2302|0|400|1602|300|0|0|4.58333|0.2422|200|0.02|8|2102|16|||
N|N0003|200106|GID|11|21|3|600|0|600|0|100|300|200|0|0|       0|0.0133|600|0.05|28|||||
N|N0003|200106|GK|11|21|110|17156|0|17156|0|1750|7742|4376|3062|226|0.10526|0.0597|9137|0.0484|35|6619|55|1400|0.0421|52
N|N0003|200106|GLC|11|21|1397|310305|2700|306105|1100|88027|135891|55266|26942|1079|0.15000|0.0268|152886|0.0322|25|129221|21|25098|0.0498|30
N|N0003|200106|GLG|11|21|210|51489|0|51089|400|30501|17462|3225|301|0|0.05000|0.0265|13063|0.0168|11|37509|11|917|0.0151|7
N|N0003|200106|GLH|11|21|201|45051|0|45051|0|15566|21649|5843|1993|0|-1.350|0.143|14705|0.0661|23|28551|15|1795|0.0261|21
N|N0003|200106|GLW|11|21|31632|6854173|13360|6798713|38700|3855589|2284747|586994|109468|615|0.05000|0.0136|3112503|0.0242|12|2413309|9|1311601|0.0273|18
N|N0003|200106|GPB|11|21|94|26231|0|26231|0|4691|15476|4364|1700|0|-1.850|0.0968|14042|0.057|21|11889|26|300|0.0167|53
N|N0003|200106|GPD|11|21|53|13433|0|13433|0|7588|5845|0|0|0|1.40000|0.1593|7865|0.0481|10|5268|10|300|0.1|9
N|N0003|200106|GPEPRA|11|21|62|17189|0|17189|0|7510|8831|848|0|0|2.58824|0.1118|10268|0.0573|13|6921|10|||
N|N0003|200106|GPEPRT|11|21|57|14799|400|14399|0|6781|6318|1100|200|0|0.50000|0.0711|6620|0.0196|18|7779|8|||
N|N0003|200106|GPEPRU|11|21|49|12589|0|12589|0|4059|8135|395|0|0|2.46154|0.1653|7537|0.0333|12|5052|11|||
N|N0003|200106|GPEPRV|11|21|32|7953|0|7953|0|1966|4966|1021|0|0|2.69231|0.1588|4145|0.0421|17|3508|19|300|0.0733|14
N|N0003|200106|GPF|11|21|20|5986|0|5986|0|1030|3571|925|460|0|-2.278|0.1622|1540|0.0802|23|4446|26|||
N|N0003|200106|GPU|11|21|1834|331935|1599|329136|500|179273|123240|20383|6540|200|1.50000|0.0418|164349|0.0434|12|136469|11|28818|0.0411|15
N|N0003|200106|GRA|11|21|217|50998|0|50998|0|21532|22718|6164|584|0|-0.700|0.0143|18821|0.0151|17|31361|14|816|0.0202|6
N|N0003|200106|GRB|11|21|163|27554|0|27554|0|5052|13374|6620|2508|0|0.40000|0.0295|12715|0.0593|26|13418|28|1421|0.0244|47
N|N0003|200106|GUPPRA|11|21|18|4554|0|4554|0|350|4204|0|0|0|0.66667|0.1284|2809|0.1062|13|1745|14|||
N|N0003|200106|GUPPRB|11|21|21|5484|0|5484|0|550|4584|350|0|0|-1.222|0.1667|3784|0.0723|15|1700|11|||
N|N0003|200106|HAR|11|21|769|148497|1800|146597|100|34515|73133|27304|11745|0|3.70000|0.0552|68766|0.0854|26|67117|23|10814|0.1312|22
N|N0003|200106|HAS|11|21|2142|438982|100|437882|1000|174135|192970|53185|18592|0|0.45000|0.0301|246768|0.0269|17|172621|16|19493|0.0313|24
N|N0003|200106|HCN|11|21|804|177141|0|175441|800|59204|72907|26587|16813|730|-1.600|0.034|81716|0.0317|27|85715|20|8810|0.0327|45
N|N0003|200106|HCNPRB|11|21|38|10125|0|10125|0|2217|4841|2284|783|0|0.58333|0.1173|6825|0.0796|25|2900|37|400|0.05|14
N|N0003|200106|HGR|11|21|31|7668|0|7668|0|2203|2650|1915|900|0|0.05000|0.0502|2915|0.0361|44|4653|19|100|0.02|8
N|N0003|200106|HIL|11|21|58|12938|0|12938|0|3997|7419|1222|300|0|-0.050|0.0221|7891|0.0332|15|4547|15|500|0.026|18
N|N0003|200106|HIW|11|21|853|201813|138|201675|0|124564|67892|7219|1700|300|0.85000|0.0302|92008|0.0319|10|101169|9|8498|0.0282|18
N|N0003|200106|HIWPRB|11|21|48|13382|0|13382|0|3770|8212|1000|400|0|-1.500|0.1308|9665|0.0841|16|3717|18|||
N|N0003|200106|HIWPRD|11|21|51|13883|0|13883|0|3676|7969|2238|0|0|-2.538|0.1521|8843|0.0724|17|4640|16|400|0.055|9
N|N0003|200106|HMA|11|21|1305|285451|0|284551|900|120298|111741|35184|17878|350|0.80000|0.0185|153353|0.0329|22|115598|15|16500|0.0365|33
N|N0003|200106|HMC|11|21|327|61763|0|61763|0|23757|28584|7033|2389|0|5.89474|0.1751|29459|0.1755|21|28592|13|3712|0.0987|30
N|N0003|200106|HMT|11|21|1019|248392|300|245792|2300|101541|107186|25592|12063|1710|0.20000|0.0155|123922|0.0207|20|115408|14|8762|0.018|59
N|N0003|200106|HMTPRA|11|21|40|10915|0|10915|0|2225|7190|1100|400|0|-0.625|0.1225|4130|0.0509|12|6285|19|500|0.086|42
N|N0003|200106|HMTPRB|11|21|45|12320|0|12320|0|4705|5465|1700|450|0|-3.824|0.0985|7575|0.0284|16|4545|23|200|0.1|18
N|N0003|200106|HMTPRC|11|21|58|16685|0|16685|0|4440|10635|1280|330|0|-1.778|0.0897|7385|0.018|21|8900|13|400|0.05|7
N|N0003|200106|HON|11|21|19634|4537992|36160|4486970|11800|2162439|1652916|496192|184563|2660| -0.300|0.0359|2222825|0.0602|16|1376974|12|898971|0.0831|26
N|N0003|200106|HOV|11|21|497|107289|200|106689|300|46229|49915|7595|3250|0|1.50000|0.0621|47328|0.0482|16|52446|13|7215|0.0522|15
N|N0003|200106|HZO|11|21|20|4175|0|4175|0|1240|2184|200|551|0|1.10526|0.039|1809|0.0585|30|2366|22|||
N|N0003|200106|ICS|11|21|7|1506|0|1506|0|0|1506|0|0|0|0.93333|0.0675|770|0.0113|10|736|16|||
N|N0003|200106|IDG|11|21|11|2461|0|2461|0|319|1494|648|0|0|1.80000|0.1105|1813|0.0317|11|||648|0.1|38
N|N0003|200106|IEU|11|21|16|4255|0|4255|0|255|3200|400|400|0|-1.273|0.2366|1555|0.0971|15|2700|36|||
N|N0003|200106|IFX|11|21|738|155517|1600|152017|400|57220|65935|19363|9549|350|2.70000|0.1008|54177|0.0564|21|66889|15|31351|0.0759|27
N|N0003|200106|IGL|11|21|884|187910|400|187210|300|46812|77036|38157|24596|909|0.50000|0.0177|77292|0.0227|36|101416|23|8802|0.0292|38
N|N0003|200106|IML|11|21|24|6306|0|6306|0|857|3090|1110|945|304|0.78947|0.1118|4214|0.0282|50|1335|44|757|0.0617|87
N|N0003|200106|IQM|11|21|27|9088|0|9088|0|3112|3224|1533|1219|0|-0.600|0.0412|2795|0.0247|19|6163|27|130|0.02|15
N|N0003|200106|IR|11|21|3775|759241|2050|754499|2100|278603|313443|122486|41102|1380|1.30000|0.0277|384981|0.0303|20|301091|17|70527|0.0412|26
N|N0003|200106|ISP|11|21|117|20875|0|20875|0|5474|11352|2541|1508|0|2.25000|0.0493|11155|0.0345|20|8420|19|1300|0.0331|33
N|N0003|200106|ITG|11|21|1108|235115|3900|231115|100|71405|116744|30416|12650|0|3.75000|0.0835|110607|0.0695|22|102156|15|18452|0.1072|32
N|N0003|200106|ITN|11|21|371|78922|429|78493|0|38979|31129|6358|2027|0|1.55000|0.0448|27960|0.0329|13|45177|12|5356|0.037|20
N|N0003|200106|ITT|11|21|1622|286838|300|285930|500|109564|148979|23443|4444|0|1.90000|0.0516|134635|0.0453|15|131715|12|20080|0.0523|18
N|N0003|200106|ITX|11|21|71|16878|200|16678|0|3675|9192|2450|1361|0|       0|0.0615|5862|0.039|25|7799|16|3017|0.0462|32
N|N0003|200106|ITXPR|11|21|8|1738|0|1738|0|199|729|450|360|0|-11.09|0.3264|888|0.2684|41|700|45|150|0.5|10
N|N0003|200106|IVC|11|21|574|109326|0|109042|0|56256|39484|9774|3528|0|-0.105|0.0595|52292|0.0707|14|49763|14|6987|0.0589|23
N|N0003|200106|JBL|11|21|10652|2021224|38650|1976374|5600|828342|716374|280748|152377|4133|2.15000|0.0406|978092|0.0497|20|664172|15|339710|0.0735|35
N|N0003|200106|JCP|11|21|4785|923275|3200|917192|2600|476919|354391|69553|17871|1058|0.90000|0.027|417906|0.0348|15|412601|11|89285|0.0462|17
N|N0003|200106|JEM|11|21|14|3691|0|3691|0|2595|846|250|0|0|2.66667|0.0709|650|0.0162|17|3041|8|||
N|N0003|200106|JOE|11|21|560|109132|100|108932|100|37049|49203|13005|9415|360|       1|0.0545|30081|0.028|28|72812|20|6139|0.0361|55
N|N0003|200106|JYPPRZ|11|21|33|8294|0|8294|0|3987|2853|1454|0|0|-0.688|0.0813|2801|0.0214|12|5093|17|400|0.055|13
N|N0003|200106|KBH|11|21|2003|396444|1900|393544|700|235578|135787|19031|3612|236|1.55000|0.052|158530|0.0436|12|201018|9|34696|0.062|18
N|N0003|200106|KBHPRG|12|23|1|4000|3800|200|0|0|200|0|0|0|     -16|0.25||||200|18|||
N|N0003|200106|KBHPRI|11|21|10|1870|0|1870|0|670|1200|0|0|0|-0.050|0.1165|600|0.0233|10|1270|11|||
N|N0003|200106|KEG|11|21|1018|219955|1787|218168|0|79979|96492|29441|11905|351|0.10000|0.0309|96876|0.0251|21|100725|18|20567|0.0376|30
N|N0003|200106|KEI|11|21|1527|304821|3399|301422|0|107761|129096|42537|22028|0|2.15000|0.0795|140598|0.0738|21|117736|18|43088|0.0839|31
N|N0003|200106|KG|11|21|5215|1031366|8400|1021866|1100|454412|432306|107139|28667|442|2.15000|0.0377|522352|0.0555|16|392279|13|108335|0.069|18
N|N0003|200106|KLU|11|21|160|33466|0|33466|0|12755|16840|3321|550|0|0.25000|0.052|13916|0.0403|14|18540|14|1010|0.01|16
N|N0003|200106|KMB|11|21|10045|2164410|4955|2150133|7000|686439|883329|387441|193491|6433|       1|0.0322|1162179|0.0422|24|704899|21|290055|0.0583|29
N|N0003|200106|KOR|11|21|26|5566|0|5566|0|1145|2746|600|1075|0|-1.105|0.0425|3656|0.0338|26|1910|33|||
N|N0003|200106|KPA|11|21|290|63086|0|62586|500|27584|24830|7518|3154|0|0.25000|0.0301|18392|0.0203|18|41710|16|2984|0.0191|24
N|N0003|200106|KPAPRA|11|21|38|8841|0|8841|0|2025|3910|800|2106|0|      -1|0.2095|2760|0.056|50|5456|28|625|0.1156|16
N|N0003|200106|KRJ|11|21|4|1150|0|1150|0|300|850|0|0|0|0.75000|0.113|600|0.0833|18|550|14|||
N|N0003|200106|KTB|11|21|24|6825|0|6825|0|1200|3975|850|800|0|0.87500|0.1024|4475|0.0597|29|2350|20|||
N|N0003|200106|KTP|11|21|113|29875|0|29875|0|11654|14076|3720|425|0|-0.333|0.1111|13092|0.0381|17|15603|15|1180|0.0632|17
N|N0003|200106|KYO|11|21|488|90772|0|90472|300|44067|39611|5763|1331|0|5.11765|0.3294|39291|0.1462|13|44089|12|7392|0.1991|15
N|N0003|200106|LBI|11|21|9|1540|0|1540|0|200|1090|250|0|0|-1.053|0.0645|713|0.121|22|827|15|||
N|N0003|200106|LDP|11|21|71|16330|0|16330|0|4713|7895|1543|2179|0|0.35000|0.0814|6311|0.0355|21|9254|26|765|0.0413|41
N|N0003|200106|LMM|11|21|5|1340|0|1340|0|400|450|490|0|0|0.41176|0.0192|210|0.0257|18|1130|27|||
N|N0003|200106|LMS|11|21|40|8949|0|8949|0|1605|5269|1025|1050|0| -1.211|0.0789|5069|0.0544|32|3770|16|110|0.02|12
N|N0003|200106|LMT|11|21|7427|1539221|2321|1534598|1500|813099|498258|155630|68871|240|1.25000|0.038|652816|0.0387|18|731392|12|151890|0.0449|19
N|N0003|200106|LNT|11|21|1104|241025|0|240325|700|74986|120488|33823|11428|300|0.15000|0.0345|72301|0.0345|18|155939|17|12785|0.0238|23
N|N0003|200106|LRY|11|21|728|157798|0|156898|900|63418|75594|14717|4069|0|-0.550|0.0361|80555|0.0294|15|73460|14|3783|0.0312|21
N|N0003|200106|LRYPRA|11|21|45|11239|0|11239|0|5040|5074|675|450|0|-0.563|0.1347|2244|0.0408|19|8795|14|200|0.05|24
N|N0003|200106|LSHPRA|11|21|38|8884|0|8884|0|1777|4625|1100|1382|0|1.75000|0.1001|4602|0.0332|34|4282|29|||
N|N0003|200106|MAG|11|21|205|40664|100|40564|0|11519|19271|7942|1832|0|0.15000|0.034|18625|0.0561|21|21026|17|913|0.0264|46
N|N0003|200106|MAR|11|21|4566|852217|3439|847777|500|327186|338792|115285|64394|2620|0.85000|0.0336|371175|0.0377|23|376069|17|101033|0.0395|25
N|N0003|200106|MAT|11|21|6271|1269034|600|1265555|2400|804303|370087|74517|19048|0|0.45000|0.0286|536799|0.0232|12|603833|9|127323|0.0268|17
N|N0003|200106|MCC|11|21|92|15602|100|15502|0|3391|5930|2640|3441|100|1.93750|0.1551|10231|0.1351|48|3496|48|1775|0.1344|50
N|N0003|200106|MCO|11|21|2564|482050|300|481050|0|205260|224512|38524|12754|0|2.50000|0.0344|232157|0.0449|16|218413|12|30480|0.0506|21
N|N0003|200106|MCT|11|21|93|18905|300|18605|0|6170|8860|2500|1175|0|-5.938|0.2168|10070|0.0931|22|7035|21|1500|0.0993|18
N|N0003|200106|MDG|11|21|222|44774|100|44574|100|18941|16881|6899|1953|0|0.15000|0.0379|17024|0.0225|15|23758|15|3892|0.029|43
N|N0003|200106|MEE|11|21|1036|209709|1746|206463|1500|66383|99319|28763|13498|0|1.45000|0.0405|111328|0.0591|22|81354|18|15281|0.0622|27
N|N0003|200106|MEH|11|21|251|48319|0|48319|0|14334|23793|6423|3769|0|1.21053|0.0701|17902|0.0429|26|24568|19|5849|0.046|31
N|N0003|200106|MER|11|21|30073|6760165|79577|6655420|22100|3730194|2256343|498914|187021|5048|1.50000|0.0551|3050308|0.0476|13|1925818|9|1701394|0.066|19
N|N0003|200106|MERPRA|11|21|78|19057|0|19057|0|7062|8478|2817|700|0|1.25000|0.101|10546|0.0317|22|8411|15|100|0.02|24
N|N0003|200106|MERPRB|11|21|79|20512|0|20512|0|6773|11414|1925|400|0|-0.353|0.0985|12232|0.0367|16|7980|17|300|0.01|11
N|N0003|200106|MERPRC|11|21|75|18441|0|18441|0|4795|11057|1582|1007|0|-0.294|0.1103|11160|0.0386|24|7181|16|100|0.07|17
N|N0003|200106|MERPRD|11|21|180|50455|0|50455|0|18698|26565|3992|1200|0|-0.167|0.0677|28689|0.0208|17|21266|15|500|0.026|20
N|N0003|200106|MERPRE|11|21|91|24866|0|24866|0|7807|13364|1525|2170|0|0.25000|0.0673|17369|0.0194|23|7497|26|||
N|N0003|200106|MERPRF|11|21|254|64465|0|64465|0|22971|30739|8030|2725|0|-1.167|0.0566|35833|0.0187|19|27832|19|800|0.025|12
N|N0003|200106|MFW|11|21|32|7466|0|7466|0|2841|4113|512|0|0|-0.158|0.0181|2029|0.0623|12|5437|14|||
N|N0003|200106|MGF|11|21|70|16120|0|16120|0|6543|8899|500|178|0|0.20000|0.0166|3887|0.0103|17|12233|12|||
N|N0003|200106|MHN|11|21|44|10018|0|10018|0|5361|3632|1025|0|0|-0.100|0.0315|3926|0.014|17|5792|10|300|0.0133|16
N|N0003|200106|MIM|11|21|7|1347|0|1347|0|275|672|200|200|0|-2.615|0.1074|140|0.13|24|1207|26|||
N|N0003|200106|MLI|11|21|373|69963|100|69763|100|19462|27043|13949|9309|100|2.30000|0.0273|31833|0.0706|30|34350|30|3680|0.0433|50
N|N0003|200106|MLM|11|21|956|204799|300|204099|400|61064|95095|32619|15821|300|0.45000|0.0477|80241|0.0608|24|108917|20|15341|0.0475|23
N|N0003|200106|MLS|11|21|869|206055|0|205855|200|74780|98864|22395|10016|0|-0.300|0.065|79217|0.0297|20|113979|14|12859|0.0332|28
N|N0003|200106|MMA|11|21|164|41547|0|41347|200|6120|18982|11510|4935|0|-1.750|0.0759|18868|0.0622|31|22479|28|200|0.01|42
N|N0003|200106|MMC|11|21|7854|1504024|4800|1496324|2400|848935|524310|93936|31240|303|4.80000|0.0776|737970|0.0635|14|537240|9|223514|0.0759|16
N|N0003|200106|MMR|11|21|143|24452|0|24452|0|4408|14201|3524|2319|0|-3.368|0.0584|10071|0.0532|24|13468|26|913|0.0605|21
N|N0003|200106|MMS|11|21|1627|318955|1900|315905|900|106853|137298|48809|23545|300|8.45000|0.0495|180240|0.06|24|113201|20|23364|0.0565|33
N|N0003|200106|MOT|11|21|15110|3328170|5844|3311576|8100|1598352|1234943|389062|96669|650|0.10000|0.0107|1631510|0.0236|17|1229766|10|458400|0.0247|21
N|N0003|200106|MOTPRA|11|21|193|54690|0|54690|0|19492|24106|8167|2925|0|-0.053|0.0898|30541|0.0284|23|23749|17|400|0.025|16
N|N0003|200106|MPPRD|11|21|9|1975|0|1975|0|300|775|900|0|0|4.14286|0.2923|1600|0.04|28|375|14|||
N|N0003|200106|MRX|11|21|1621|320344|8637|310782|200|63174|159322|56740|29946|1800|0.85000|0.0942|133022|0.0768|30|134927|24|43033|0.1141|30
N|N0003|200106|MSF|11|21|42|9509|0|9509|0|2112|6131|766|200|300|-1.050|0.0626|3761|0.0423|15|5748|16|||
N|N0003|200106|MTN|11|21|145|22165|0|21965|200|4845|12736|2407|2177|0|2.55556|0.0896|11127|0.0907|28|10716|22|322|0.1|10
N|N0003|200106|MTTPRX|11|21|23|5969|0|5969|0|850|4879|240|0|0|8.85714|0.1935|3074|0.1643|18|2895|13|||
N|N0003|200106|MTX|11|21|764|141623|0|140313|0|59229|61833|11244|8007|0| -0.150|0.062|55775|0.0467|18|74506|17|10032|0.0553|28
N|N0003|200106|MUC|11|21|37|9273|0|9273|0|3762|3999|400|1112|0|-0.650|0.0279|5611|0.0146|17|3262|42|400|0.01|6
N|N0003|200106|MUJ|11|21|36|8266|0|8266|0|3118|4948|200|0|0|0.05263|0.0292|4991|0.0126|15|3275|10|||
N|N0003|200106|MUO|11|21|47|10408|0|10408|0|2493|6074|1116|725|0|-0.316|0.0519|3863|0.0223|24|6345|13|200|0.06|140
N|N0003|200106|MYI|11|21|107|32319|0|32319|0|11642|14632|3472|2373|200|-0.579|0.0318|11728|0.0141|29|20291|17|300|0.01|18
N|N0003|200106|NAV|11|21|1165|207641|200|206594|300|100039|87977|14008|4870|0|1.70000|0.0271|94076|0.027|14|101550|12|11268|0.0438|17
N|N0003|200106|NC|11|21|422|70933|0|70933|0|24172|40012|5599|1150|0|-3.550|0.1476|27278|0.0952|18|37888|11|5767|0.0974|18
N|N0003|200106|NCI|11|21|165|36300|0|36300|0|12555|13153|5331|4291|970|       1|0.0448|13065|0.0375|23|21642|25|1593|0.0567|119
N|N0003|200106|NDE|11|21|1140|252703|3500|248903|200|62581|105339|52043|27991|1149|1.55000|0.0427|103869|0.041|28|124648|23|20586|0.0692|57
N|N0003|200106|NEU|11|21|2069|434722|5500|427622|500|148279|190275|58105|31463|0|5.90000|0.0733|193603|0.0723|25|172307|15|62212|0.0672|31
N|N0003|200106|NMA|11|21|57|13504|0|13504|0|2868|6470|2799|1367|0|0.27778|0.033|1804|0.0319|18|11350|29|350|0.01|41
N|N0003|200106|NMI|11|21|23|5888|0|5888|0|2227|2881|580|200|0|1.43750|0.0667|4313|0.0145|18|1575|13|||
N|N0003|200106|NMK|11|21|1636|308307|100|307707|400|114811|128594|41825|22677|200|0.05000|0.0191|97748|0.016|23|190283|18|20076|0.0143|28
N|N0003|200106|NMKPRK|11|21|1|100|0|100|0|100|0|0|0|0|27.5000|0.75||||100|9|||
N|N0003|200106|NMT|11|21|21|5072|0|5072|0|507|4032|133|400|0|1.42857|0.0602|2876|0.023|19|2196|23|||
N|N0003|200106|NPC|11|21|12|2425|0|2425|0|798|1627|0|0|0|0.53333|0.0694|927|0.0578|14|1498|14|||
N|N0003|200106|NPV|11|21|36|8346|0|8346|0|2790|3706|1850|0|0|0.58824|0.0865|4223|0.0241|20|3823|17|300|0.01|13
N|N0003|200106|NQF|11|21|33|8197|0|8197|0|3319|3533|1145|0|200|-0.059|0.0506|4778|0.0118|32|3419|10|||
N|N0003|200106|NQS|11|21|50|13224|0|13224|0|3268|6571|3385|0|0|0.31579|0.0344|3655|0.0223|23|9235|17|334|0.04|32
N|N0003|200106|NSH|11|21|31|6351|0|6351|0|1216|4108|927|100|0|-0.467|0.0711|3151|0.0624|19|3200|18|||
N|N0003|200106|NSI|11|21|989|206016|700|204916|400|81854|88750|26478|8134|100|1.30000|0.053|78530|0.0423|19|115118|14|11668|0.0455|29
N|N0003|200106|NTC|11|21|29|7856|0|7856|0|2683|4673|500|0|0|1.43750|0.0692|5213|0.0129|16|2643|12|||
N|N0003|200106|NUT|11|21|24|5170|0|5170|0|713|3916|541|0|0|0.89474|0.0767|3509|0.0365|19|1548|11|113|0.05|9
N|N0003|200106|NVN|11|21|60|17595|0|17595|0|3541|10820|1951|1283|0|-0.400|0.0528|6675|0.015|21|10105|23|815|0.0316|14
N|N0003|200106|OAT|11|21|3034|570965|4200|565465|1300|270878|204505|62275|28792|315|       2|0.0499|293935|0.0578|17|213478|13|59352|0.0588|21
N|N0003|200106|OCN|11|21|196|44482|122|44160|200|11948|15964|8555|7893|0|1.40000|0.0487|16847|0.0378|38|24518|33|2995|0.0362|41
N|N0003|200106|OECPRT|11|21|37|8598|0|8598|0|5028|2770|600|200|0|5.90000|0.3758|5885|0.0151|16|2713|9|||
N|N0003|200106|OFC|11|21|228|44336|0|44336|0|7456|16953|9168|10759|0|-1.579|0.0313|17630|0.0546|51|22481|36|4225|0.0178|24
N|N0003|200106|OFCPRB|11|21|24|4268|0|4268|0|240|1775|1155|700|398|-1.067|0.0926|2050|0.1197|37|2118|122|100|0.05|65
N|N0003|200106|OFCPRE|11|21|22|4805|0|4805|0|700|1725|1130|1150|100|0.81250|0.1068|2310|0.0747|57|2195|46|300|0.03|11
N|N0003|200106|OH|11|21|149|34617|140|34377|100|9919|17741|4045|2772|0|-0.050|0.0328|14906|0.0318|32|19248|18|323|0.0286|89
N|N0003|200106|OI|11|21|353|74739|0|74739|0|33123|30579|7601|3436|0|0.60000|0.0219|24529|0.0238|16|47287|16|2923|0.0227|21
N|N0003|200106|OIPRA|11|21|62|16193|100|16093|0|2270|6602|2439|4282|500|-1.947|0.1128|7247|0.0299|73|7547|45|1299|0.0585|54
N|N0003|200106|OMG|11|21|965|189051|1000|186551|0|54715|91492|27624|12720|0|1.15789|0.0607|70167|0.0623|23|97105|18|19279|0.0554|29
N|N0003|200106|OMI|11|21|565|107087|500|106087|300|26099|48534|18229|13525|0|1.60000|0.0552|41150|0.0578|29|56474|24|8763|0.0579|42
N|N0003|200106|ONE|11|21|10768|2557497|1921|2549239|4900|1590050|761410|159619|42657|403|0.45000|0.0277|1132248|0.0266|12|1085876|9|336015|0.0315|15
N|N0003|200106|ONEPRB|11|21|3|400|0|400|0|0|200|0|200|0|35.1667|2.3875|200|0.55|91|200|18|||
N|N0003|200106|ONEPRC|11|21|1|100|0|100|0|0|0|0|100|0|1.5|2|100|1|83|||||
N|N0003|200106|ONEPRT|11|21|109|29362|0|29362|0|13993|11061|3728|580|0|-1.333|0.0822|11554|0.0415|15|16908|15|900|0.0289|13
N|N0003|200106|ONEPRU|11|21|60|17827|0|17827|0|6895|7268|3264|400|0|-1.533|0.1008|7272|0.0373|19|10355|15|200|0.05|22
N|N0003|200106|ONEPRV|11|21|93|23722|0|23722|0|10722|12220|400|380|0|-0.526|0.0884|13172|0.031|12|9650|13|900|0.0311|19
N|N0003|200106|OSI|11|21|1058|248089|2075|245714|300|63505|109163|44599|28147|600|1.15000|0.0554|102160|0.0585|31|123370|21|20484|0.0677|33
N|N0003|200106|OTL|11|21|200|33973|0|33973|0|8320|18238|7115|300|0|2.20000|0.1038|11952|0.0549|18|17721|15|4300|0.2072|34
N|N0003|200106|OWC|11|21|426|97564|400|97164|0|51956|36885|6365|1958|0|0.20000|0.0286|25059|0.0166|13|64887|11|7218|0.0214|26
N|N0003|200106|PAG|11|21|182|38597|0|38597|0|14405|16254|5316|2622|0|0.15000|0.0262|13760|0.0177|24|24337|16|500|0.016|16
N|N0003|200106|PAR|11|21|38|8752|0|8752|0|2836|4398|1118|400|0|-1.667|0.0644|3723|0.049|17|4629|33|400|0.0425|17
N|N0003|200106|PAS|11|21|469|116739|596|115743|0|32186|50278|20265|12755|259|       1|0.0361|55329|0.0333|31|57869|26|2545|0.0876|29
N|N0003|200106|PCEPR|11|21|28|7237|0|7237|0|1438|3578|1621|600|0|2.05556|0.1203|2378|0.0377|23|4459|27|400|0.0825|15
N|N0003|200106|PCEPRA|11|21|67|19235|0|19235|0|4495|7684|3786|3070|200|-0.600|0.1339|6197|0.0854|34|12438|40|600|0.0767|103
N|N0003|200106|PCL|11|21|870|207041|0|205966|800|82550|84819|26006|12302|1289|1.90000|0.0518|79822|0.0285|32|112427|17|14517|0.0474|59
N|N0003|200106|PCT|11|21|41|10980|0|10980|0|1755|5233|2274|1718|0|-0.308|0.1086|4575|0.0492|32|6405|31|||
N|N0003|200106|PDE|11|21|1349|311176|2700|307576|900|153759|109523|33382|11412|400|0.25000|0.0241|146622|0.0338|16|130255|11|31599|0.0309|23
N|N0003|200106|PECPRX|11|21|31|9116|0|9116|0|3045|5421|650|0|0|4.18182|0.253|6766|0.2323|14|2250|16|100|0.2|13
N|N0003|200106|PEP|11|21|17054|3961781|3610|3935924|19800|1877493|1559852|407217|111162|0|0.50000|0.0169|2074843|0.0276|16|1458336|12|422545|0.0302|20
N|N0003|200106|PER|11|21|681|147898|1311|146587|0|54071|50664|20863|20325|664|-0.150|0.0494|60502|0.0331|30|70966|23|15119|0.0414|37
N|N0003|200106|PFP|11|21|20|4346|0|4346|0|611|3014|223|498|0|6.81818|0.2408|2737|0.1043|23|1609|22|||
N|N0003|200106|PFPPR|11|21|8|1998|0|1998|0|456|1542|0|0|0|2.37500|0.3709|1060|0.1181|14|938|3|||
N|N0003|200106|PG|11|21|14631|3286058|7562|3265296|10900|1994720|980155|234132|65839|1200|0.85000|0.0383|1509114|0.0338|12|1185301|9|581781|0.0453|20
N|N0003|200106|PGF|11|21|13|3127|0|3127|0|400|2227|500|0|0|-1.727|0.1322|200|0.1|37|2927|16|||
N|N0003|200106|PGN|11|21|4449|803192|1050|800855|1100|395029|308406|70143|26814|1563|0.55000|0.0442|356946|0.0318|16|362495|12|82514|0.0394|21
N|N0003|200106|PHA|11|21|11090|2625800|5054|2615898|2300|1194257|945635|349082|129224|0|0.90000|0.0269|1208326|0.0303|19|1030728|13|379144|0.0395|26
N|N0003|200106|PII|11|21|547|102532|100|102432|0|41394|47177|10024|3837|0| -2.789|0.0656|43817|0.0617|19|50009|14|8606|0.067|21
N|N0003|200106|PIK|11|21|20|3575|0|3575|0|200|1904|349|1122|0|0.94118|0.048|2316|0.061|22|1092|112|167|0.02|177
N|N0003|200106|PIM|11|21|174|49075|0|49075|0|24946|18678|4419|1032|0|-0.550|0.0231|15250|0.0101|15|31123|13|2702|0.0172|21
N|N0003|200106|PIO|11|21|112|20834|0|20834|0|4049|12496|3547|742|0|      -1|0.1999|15381|0.3664|19|5353|24|100|0.03|57
N|N0003|200106|PKE|11|21|670|119484|100|119384|0|37310|62636|13909|5529|0|       0|0.0536|51032|0.0518|20|59311|16|9041|0.0835|42
N|N0003|200106|PKG|11|21|595|146975|435|146340|200|34426|54415|28787|26474|2438|1.45000|0.0363|71171|0.0341|45|66334|34|9035|0.0866|51
N|N0003|200106|PKX|11|21|711|142771|0|142226|200|41939|72365|20160|7962|0|1.65000|0.0222|67854|0.0374|22|71279|18|3293|0.0316|36
N|N0003|200106|PLP|11|21|84|20783|0|20783|0|6623|11908|1872|380|0|0.05263|0.0736|9234|0.0405|19|9569|14|1980|0.048|16
N|N0003|200106|PNP|11|21|360|77419|0|77419|0|21873|46990|6414|2142|0|2.45000|0.0584|39478|0.0455|17|35119|13|2822|0.0368|27
N|N0003|200106|PNW|11|21|2281|470049|2100|467443|400|193183|212965|42984|18311|400|2.90000|0.0449|244484|0.0442|17|188356|15|35003|0.0463|22
N|N0003|200106|PPD|11|21|1023|203099|1025|199574|2500|50324|81817|41329|28104|500|-0.400|0.0512|76073|0.06|40|105458|21|20543|0.056|41
N|N0003|200106|PPP|11|21|1071|218104|600|217504|0|90001|84657|30380|12466|0|1.65000|0.0533|86443|0.0541|21|107964|17|23097|0.0719|22
N|N0003|200106|PPPPRQ|11|21|8|1220|0|1220|0|0|340|750|130|0|-24.65|1.2508|400|0.461|62|820|29|||
N|N0003|200106|PTV|11|21|2082|421537|524|420713|300|130636|203286|64391|22600|100|0.70000|0.0255|219254|0.0309|20|179782|19|21977|0.0307|20
N|N0003|200106|PX|11|21|4735|968093|4342|962551|400|391045|431840|105022|34611|433|1.60000|0.0323|517464|0.0384|17|360536|15|84951|0.0418|20
N|N0003|200106|RCL|11|21|888|192609|1279|191130|200|73260|79569|27645|10856|0|-0.200|0.0309|71595|0.0366|23|106888|15|12847|0.0291|21
N|N0003|200106|RCN|11|21|119|26769|0|26769|0|7428|11535|3395|4411|0|-3.421|0.13|9038|0.0576|40|14081|20|3650|0.0453|33
N|N0003|200106|RG|11|21|357|70949|0|70949|0|19784|28138|8150|13587|1290|0.21053|0.0507|16009|0.0463|71|42135|29|12805|0.0254|64
N|N0003|200106|RHB|11|21|1366|256151|6400|249751|0|54702|103946|53430|37673|0|-0.650|0.1091|117310|0.0835|36|102790|26|29651|0.1028|46
N|N0003|200106|RHD|11|21|830|166190|100|165990|0|55871|81814|20848|7457|0|0.95000|0.0431|76146|0.0406|19|82195|17|7649|0.0406|25
N|N0003|200106|RHI|11|21|2239|438400|1243|436357|800|200230|165695|49195|21787|250|       2|0.0378|212536|0.0402|18|187120|13|37501|0.0493|32
N|N0003|200106|RJF|11|21|865|179628|1970|177558|100|59606|69661|26503|21888|0|       3|0.0605|84064|0.0491|26|80046|18|13548|0.063|43
N|N0003|200106|RL|11|21|883|188977|400|187027|1200|51875|75446|38251|22355|300|0.35000|0.0584|80017|0.0683|29|84714|25|23496|0.0661|31
N|N0003|200106|RMG|11|21|406|76807|0|76807|0|31060|36138|8459|1150|0|3.31579|0.0786|40447|0.0656|14|32940|14|3420|0.0411|29
N|N0003|200106|RML|11|21|302|65767|851|64916|0|15388|24785|9913|14430|400|-0.050|0.0323|25040|0.0345|54|36262|32|3614|0.036|68
N|N0003|200106|RNS|11|21|11|3105|0|3105|0|1535|1370|200|0|0| -19.60|0.1214|2105|0.1211|11|1000|14|||
N|N0003|200106|ROP|11|21|637|119636|1400|118236|0|31245|46507|21949|17566|969| -2.450|0.0654|52276|0.0767|37|54041|26|11919|0.076|60
N|N0003|200106|ROS|11|21|42|8810|0|8810|0|5900|2210|500|200|0|0.75000|0.0264|4960|0.0191|11|3850|15|||
N|N0003|200106|ROV|11|21|1256|280099|300|278999|800|121057|99650|39115|18932|1045|2.40000|0.0251|165982|0.0469|20|98628|16|15189|0.0513|69
N|N0003|200106|RS|11|21|364|74715|300|74415|0|17112|35972|16048|5283|0|0.80000|0.0486|37850|0.0445|24|31898|21|4667|0.0411|26
N|N0003|200106|RSC|11|21|163|35415|0|35415|0|8219|17055|6911|3230|0|0.35000|0.1382|19992|0.0862|25|13593|24|1830|0.1025|40
N|N0003|200106|RTP|11|21|224|45752|200|45552|0|14891|21771|6917|1973|0|-5.250|0.4891|17391|0.1724|22|23561|14|4600|0.5028|31
N|N0003|200106|RWT|11|21|272|52267|0|52267|0|18388|19210|10069|4600|0|0.30000|0.0721|25393|0.0563|23|24774|18|2100|0.0438|14
N|N0003|200106|RWTPRB|11|21|9|1638|0|1638|0|100|1288|100|150|0| -0.222|0.0114|1239|0.599|39|399|13|||
N|N0003|200106|RYN|11|21|672|128546|700|127446|0|34511|58160|23802|10373|600|-0.632|0.0552|52145|0.0532|29|64697|21|10604|0.0443|37
N|N0003|200106|RZT|11|21|212|44179|0|44079|100|16442|21497|5031|1209|0|0.75000|0.0511|18311|0.046|16|23659|13|2209|0.09|34
N|N0003|200106|SACPR|11|21|3|700|0|700|0|0|0|200|500|0|17.6667|1.1014||||700|86|||
N|N0003|200106|SACPRT|11|21|11|2493|0|2493|0|320|1463|300|410|0|-0.133|0.2151|413|0.1299|17|1980|41|100|0.1|16
N|N0003|200106|SAIPRW|11|21|70|17471|0|17471|0|9608|6338|1125|400|0|-1.316|0.0907|5971|0.0183|14|11400|15|100|0.03|7
N|N0003|200106|SBG|11|21|92|23981|0|23981|0|9947|6542|3638|3554|300|-0.550|0.0256|12268|0.0161|38|11713|39|||
N|N0003|200106|SC|11|21|804|171378|1200|169328|600|35189|66402|34353|32589|1295|-0.050|0.0425|67572|0.0423|115|82345|33|20011|0.0432|74
N|N0003|200106|SCG|11|21|813|174445|1450|172995|0|36451|63067|41038|31401|1038|-1.300|0.0434|73380|0.0352|39|85091|31|14524|0.0479|57
N|N0003|200106|SCL|11|21|28|4080|0|4080|0|797|977|1156|1007|143|1.63636|0.1141|1361|0.0648|33|2719|95|||
N|N0003|200106|SCX|11|21|19|5156|0|5156|0|1378|1806|500|1472|0|3.64286|0.1732|871|0.1332|41|4185|42|100|0.14|18
N|N0003|200106|SCZ|11|21|416|93540|0|93440|100|37105|43330|8965|4140|0|-0.100|0.0246|42050|0.032|19|49810|15|1680|0.0214|19
N|N0003|200106|SCZA|12|21|13|1667|270|1397|0|450|430|200|317|0|    -547|6.7545|317|1|165|1080|17|||
N|N0003|200106|SDH|11|21|187|41816|0|41816|0|18699|18351|3596|1170|0|0.26316|0.0167|12656|0.0124|16|28810|12|350|0.0243|60
N|N0003|200106|SGH|11|21|24|6168|0|6168|0|1085|2758|1200|1125|0|0.26667|0.1265|2783|0.0408|37|3000|41|385|0.033|9
N|N0003|200106|SGI|11|21|340|72667|350|72017|300|24900|32188|9337|5892|0|       0|0.013|22488|0.0123|20|46559|19|3270|0.0143|58
N|N0003|200106|SGR|11|21|6170|1299132|35974|1259458|2700|574617|455207|144340|85394|2700|6.65000|0.0949|654440|0.1078|20|422851|13|184867|0.1534|37
N|N0003|200106|SGU|11|21|421|102190|475|101715|0|24400|44647|16278|15490|900|-1.950|0.0787|50870|0.0602|40|46623|28|4222|0.0301|56
N|N0003|200106|SII|11|21|12161|2461601|89352|2366784|2800|708230|989797|446578|224144|835|3.15000|0.1034|1098122|0.0831|23|658194|17|613268|0.1146|34
N|N0003|200106|SLC|11|21|462|102521|0|102521|0|31777|51814|14017|4913|0|0.40000|0.0498|39662|0.0221|22|51426|15|11433|0.021|27
N|N0003|200106|SLI|11|21|223|40617|418|39999|200|9667|16424|8563|5445|100|1.90000|0.0584|15844|0.0585|43|20722|21|3633|0.0345|53
N|N0003|200106|SO|11|21|7112|1830209|2000|1815354|11800|580083|787613|325490|133214|754|-0.200|0.0234|654768|0.0233|25|930696|18|241690|0.0333|29
N|N0003|200106|SOPRA|11|21|65|16715|0|16715|0|3470|8827|1949|2469|0|-0.118|0.0665|4028|0.0293|35|11087|27|1600|0.0338|30
N|N0003|200106|SOPRB|11|21|65|17925|0|17925|0|5235|6861|2834|2995|0|1.18750|0.0985|10104|0.042|50|7421|23|400|0.0375|42
N|N0003|200106|SOPRC|11|21|62|16462|0|16462|0|2966|8671|3400|1425|0|-1.667|0.0901|6935|0.0333|27|8927|25|600|0.0367|33
N|N0003|200106|SP|11|21|2259|417878|20700|395978|1000|88276|173307|84940|49425|1030|17.3000|0.2098|199842|0.171|26|116566|21|80570|0.2007|41
N|N0003|200106|SPN|11|21|400|100444|325|100119|0|31571|45383|12267|10898|0|1.95000|0.0288|43292|0.0424|30|56427|21|400|0.015|91
N|N0003|200106|SPP|11|21|229|51056|0|50756|300|10669|25951|9287|5149|0|0.75000|0.0357|20559|0.0263|30|27662|21|2835|0.0104|42
N|N0003|200106|SRE|11|21|4174|776656|470|775086|1100|536186|219314|17703|2755|228|1.40000|0.0319|347116|0.0326|9|370017|8|59053|0.036|11
N|N0003|200106|SREPRA|11|21|101|28661|0|28661|0|5688|17888|3435|1650|0|0.68750|0.1707|17662|0.1052|21|10199|21|800|0.075|20
N|N0003|200106|SSD|11|21|206|35844|500|35344|0|9983|16926|5118|3317|0|3.15789|0.1372|17605|0.1104|33|13239|17|4500|0.1138|32
N|N0003|200106|SSR|11|21|75|19430|0|19430|0|3254|10127|4436|1013|600|-0.737|0.0911|7555|0.0238|45|11475|28|400|0.035|22
N|N0003|200106|STZ|11|21|1619|339807|2000|337207|600|85800|149849|59664|42094|400|0.85000|0.0667|138641|0.0823|34|166570|25|32596|0.0947|42
N|N0003|200106|STZB|12|21|2|624|0|624|0|0|0|0|624|0|-1.714|2.1795||||400|153|224|0.25|294
N|N0003|200106|SUR|11|21|181|31393|0|31393|0|11609|15609|2915|1260|0|-0.250|0.0639|12522|0.0329|17|17749|15|1122|0.04|22
N|N0003|200106|SUT|11|21|236|35284|0|35084|0|12819|18577|3588|100|0|-2.150|0.0223|16575|0.0263|15|17409|13|1100|0.0291|14
N|N0003|200106|SUTPRA|11|21|47|10131|0|10131|0|1975|6048|2008|100|0|-0.588|0.1397|5027|0.083|25|5104|15|||
N|N0003|200106|SVAPR|11|21|12|3315|0|3315|0|200|1775|1340|0|0|-1.300|0.1859|1185|0.0888|22|1930|29|200|0.05|13
N|N0003|200106|SWM|11|21|126|25116|100|25016|0|8271|12267|3269|1209|0|0.70000|0.0897|9365|0.0636|26|13651|16|2000|0.075|24
N|N0003|200106|SZ|11|21|12|2987|0|2987|0|0|1937|900|150|0|0.21053|0.0453|500|0.03|30|2487|36|||
N|N0003|200106|TAPPRA|11|21|151|40656|0|40656|0|9089|25026|6266|275|0|-0.050|0.0587|14590|0.0156|21|25766|17|300|0.03|15
N|N0003|200106|TAPPRB|11|21|23|5637|0|5637|0|628|4379|630|0|0|1.46667|0.112|4215|0.0363|18|1222|10|200|0.04|11
N|N0003|200106|TCC|11|21|160|33038|0|32738|300|5154|13144|8508|6232|0|0.20000|0.0487|15161|0.0428|44|15526|27|2351|0.0516|33
N|N0003|200106|TCH|11|21|46|10532|0|10532|0|1828|7022|700|982|0|1.75000|0.0697|2692|0.0298|26|7640|21|200|0.05|0
N|N0003|200106|TCLPR|11|21|23|6611|0|6611|0|2911|3700|0|0|0|0.44444|0.1033|1800|0.0339|16|4811|11|||
N|N0003|200106|TCR|11|21|254|64034|0|64034|0|13892|25318|11708|12916|200|-1.300|0.0366|20925|0.0261|44|38017|34|5092|0.0244|58
N|N0003|200106|TD|11|21|444|84704|200|84504|0|26904|43499|9309|4792|0|0.68421|0.0518|30355|0.0191|20|40045|14|14104|0.0498|25
N|N0003|200106|TDI|11|21|22|5012|0|5012|0|850|2266|1175|721|0|-2.100|0.177|2011|0.0975|46|3001|24|||
N|N0003|200106|TDR|11|21|26|4930|0|4930|0|160|4120|450|200|0|-2.263|0.1429|3070|0.0602|24|1860|18|||
N|N0003|200106|TDY|11|21|602|111666|327|111339|0|39645|56089|11267|4338|0|1.25000|0.0325|46693|0.0382|21|60096|14|4550|0.0372|18
N|N0003|200106|TEE|11|21|387|93634|194|93440|0|38091|39954|10290|5205|0|0.30000|0.0979|55764|0.0522|17|33575|17|4101|0.0442|24
N|N0003|200106|TEF|11|21|1902|396187|0|395605|100|185332|137753|47922|24698|0|1.95000|0.0489|199060|0.031|21|167710|14|28935|0.0439|27
N|N0003|200106|TEM|11|21|5|975|0|975|0|375|200|400|0|0|6.14286|0.2467|300|0.1167|11|675|25|||
N|N0003|200106|TEN|11|21|340|70065|0|70065|0|20950|30885|10353|7877|0|0.80000|0.0338|26121|0.0405|24|39987|23|3957|0.0298|12
N|N0003|200106|TFS|11|21|769|145212|800|143612|800|41861|68860|23910|9781|0|2.50000|0.0531|57459|0.0478|23|76318|19|10635|0.0542|23
N|N0003|200106|TGT|11|21|13947|3240598|7313|3215448|13900|1249034|1213942|478651|281570|6151|       0|0.0267|1754183|0.0402|22|1020458|16|454707|0.0506|33
N|N0003|200106|THX|11|21|702|138946|400|137546|600|38790|53171|27131|18274|780|1.15789|0.0806|45773|0.104|35|75898|24|16475|0.1466|48
N|N0003|200106|TI|11|21|314|58047|100|57847|100|5609|27586|14591|9798|363|-5.850|0.3006|31788|0.331|46|23256|24|2903|0.1905|36
N|N0003|200106|TIA|12|23|1|3300|2600|700|0|0|0|0|700|0|    -127|2.68||||700|208|||
N|N0003|200106|TLI|11|21|70|18393|0|18393|0|5914|7198|3215|2066|0|0.31579|0.0413|4007|0.0171|38|13686|23|700|0.0357|23
N|N0003|200106|TLK|11|21|37|9060|0|9060|0|1072|5706|1383|899|0|0.65000|0.0239|6138|0.0201|21|2922|33|||
N|N0003|200106|TOL|11|21|1670|345725|1300|343187|300|106434|153897|54404|28752|0|0.10000|0.0455|141820|0.0581|27|171803|19|29864|0.0657|25
N|N0003|200106|TR|11|21|913|189915|1800|188115|0|37995|79907|42395|26708|1110|-4.650|0.0758|79587|0.0422|37|92597|28|15931|0.1202|54
N|N0003|200106|TRA|11|21|304|53919|100|53619|200|18468|22849|10610|1892|200|-0.250|0.0187|18222|0.0285|24|34022|21|1575|0.0225|27
N|N0003|200106|TRP|11|21|180|40568|300|39968|300|18516|17508|3049|1195|0|0.55000|0.0269|17545|0.0144|14|22113|14|610|0.0166|13
N|N0003|200106|TRPPR|11|21|65|18352|0|18352|0|6762|8990|2100|500|0|-0.053|0.0513|8625|0.0222|22|9527|12|200|0.03|10
N|N0003|200106|TRPPRC|11|21|25|6352|0|6352|0|3210|2942|200|0|0|-0.200|0.0643|2510|0.0303|14|3842|11|||
N|N0003|200106|TTR|11|21|23|6839|0|6839|0|4785|1668|386|0|0|      -8|0.0552|1506|0.0338|10|5333|9|||
N|N0003|200106|TWE|11|21|558|116045|212|115233|600|36782|50391|20674|7986|0|-3.950|0.0223|38403|0.0222|28|69540|19|7890|0.0292|31
N|N0003|200106|TWK|11|21|339|62550|426|62124|0|17218|21312|10709|12585|300|2.30000|0.0307|32607|0.0461|34|27617|38|1900|0.0442|41
N|N0003|200106|TX|11|21|10843|2376297|9060|2363465|2500|1397168|761431|163587|43779|0|1.30000|0.0354|1075238|0.0369|12|866775|10|423952|0.0385|15
N|N0003|200106|TXCPRA|11|21|138|35819|0|35819|0|20100|13164|1840|615|100|-0.526|0.0725|12355|0.0141|13|22764|13|700|0.0557|15
N|N0003|200106|TXCPRB|11|21|33|7489|0|7489|0|2855|3884|600|150|0|7.12500|0.1246|3550|0.0445|12|3739|19|200|0.01|22
N|N0003|200106|TXN|11|21|32718|7538253|101229|7394161|34500|2539737|2403485|1376649|1086906|21884|0.70000|0.0401|3888049|0.0556|27|1778802|21|1761810|0.066|43
N|N0003|200106|UIS|11|21|3976|863380|300|860260|2600|520238|271865|59247|11158|352|0.30000|0.0169|410722|0.0227|12|392168|9|59970|0.0259|19
N|N0003|200106|VAP|11|21|25|5620|0|5620|0|1085|2560|500|1475|0|3.28571|0.0888|4035|0.0313|40|1485|25|100|0.02|11
N|N0003|200106|VBF|11|21|88|20011|0|20011|0|4270|7857|4087|3597|200|0.21429|0.0668|10578|0.0362|41|9233|30|200|0.02|320
N|N0003|200106|VEA|11|21|61|17329|0|17329|0|5199|9135|2195|800|0|-1.588|0.0988|8620|0.0473|19|8309|17|400|0.04|15
N|N0003|200106|VELPRT|11|21|40|9565|0|9565|0|3225|5640|600|100|0|0.05882|0.1207|5245|0.0358|15|4020|10|300|0.07|21
N|N0003|200106|VGM|11|21|26|5974|0|5974|0|2694|2750|530|0|0|0.40000|0.0349|3386|0.0109|14|2588|12|||
N|N0003|200106|VGR|11|21|505|95521|600|94921|0|26817|43606|15460|8788|250|3.80000|0.1196|39410|0.111|32|46153|19|9358|0.0972|28
N|N0003|200106|VIG|11|21|10|2057|0|2057|0|389|1668|0|0|0|0.26316|0.0391|800|0.0125|10|1157|10|100|0.01|13
N|N0003|200106|VIN|11|21|31|6807|0|6807|0|2456|1434|892|2025|0|0.83333|0.0312|2010|0.013|41|4797|48|||
N|N0003|200106|VIT|11|21|48|12624|0|12624|0|7444|4875|305|0|0|0.25000|0.0359|6412|0.0114|11|5887|8|325|0.01|8
N|N0003|200106|VNV|11|21|7|2270|0|2270|0|780|1190|300|0|0|-0.125|0.0457|538|0.01|26|1732|10|||
N|N0003|200106|VOD|11|21|7053|1514065|2700|1506152|4300|792257|578419|118150|21426|200|0.40000|0.0158|842187|0.0218|14|579386|10|88879|0.0263|17
N|N0003|200106|VOL|11|21|102|20551|0|20551|0|5757|10161|2999|1534|100|1.94737|0.0808|10322|0.0528|27|8844|20|1385|0.0453|26
N|N0003|200106|VOT|11|21|23|6573|0|6573|0|2658|3686|229|0|0|0.11765|0.0539|2850|0.0175|15|2968|10|755|0.01|23
N|N0003|200106|VPA|11|21|33|9050|0|9050|0|1907|5339|1300|504|0|0.66667|0.0632|5957|0.0343|22|3093|18|||
N|N0003|200106|VPQ|11|21|33|8868|0|8868|0|2747|4560|686|875|0|0.66667|0.0517|3903|0.0212|19|4965|23|||
N|N0003|200106|VRC|11|21|3288|721772|1186|719800|600|264831|294864|105814|54891|0|0.30000|0.045|286261|0.0307|21|317784|20|116355|0.0471|28
N|N0003|200106|VSH|11|21|2045|439313|1600|434513|3200|160494|181677|67281|28161|100|1.10000|0.0236|201249|0.0324|22|186762|16|49702|0.0348|26
N|N0003|200106|VVC|11|21|766|178642|300|178342|0|45864|72830|35634|23102|912|-1.050|0.0386|69059|0.0436|36|101042|24|8241|0.0549|69
N|N0003|200106|VVR|11|21|328|83284|0|83284|0|28751|37822|13076|3635|0|-0.200|0.013|15688|0.0125|22|66309|18|1287|0.01|29
N|N0003|200106|WFR|11|21|248|55333|0|55133|200|19295|21918|7154|6214|752|-1.211|0.0502|20319|0.0448|40|31596|17|3418|0.0496|22
N|N0003|200106|WG|11|21|177|43323|200|43123|0|7887|16391|10247|8498|100|-0.650|0.0786|26932|0.0573|40|12256|37|3935|0.0413|33
N|N0003|200106|WLP|11|21|3166|613165|3600|607565|1800|224212|285602|70528|28442|581|2.65000|0.0537|307476|0.0591|19|225772|15|76117|0.0715|21
N|N0003|200106|WNI|11|21|6|620|0|620|0|100|320|200|0|0|0.29412|0.0194|420|0.0333|11|200|39|||
N|N0003|200106|WSM|11|21|1521|335089|7400|327689|0|107654|147769|43968|28298|0|3.05000|0.0431|146297|0.0509|24|138437|17|42955|0.0611|38
N|N0003|200106|WTS|11|21|134|25867|0|25867|0|9094|10894|4105|1774|0|1.16667|0.0725|13047|0.0591|24|12620|23|200|0.01|8
N|N0003|200106|XRX|11|21|6165|1563755|1500|1551990|9300|899430|518310|111272|32278|0|0.05000|0.0141|589903|0.0185|14|835374|9|136013|0.0244|21
N|N0003|200106|XVF|11|21|284|63667|300|63367|0|20329|30220|10193|2625|0|-3.300|0.2107|36209|0.0865|21|24028|17|3130|0.1246|6
N|N0003|200106|YLD|11|21|49|13280|0|13280|0|5464|4515|2276|1025|0|-0.350|0.0193|3096|0.0162|19|9884|23|300|0.01|7
N|N0003|200106|YUM|11|21|3481|681270|15304|663764|1800|124966|222082|150777|158519|9220|1.30000|0.025|322286|0.0381|48|259741|38|83537|0.0503|67
N|N0003|200106|ZIF|11|21|45|9335|0|9335|0|3943|4592|700|100|0|-1.300|0.0384|4741|0.018|12|4594|17|||
N|N0003|200106|ZMX|11|21|13|2620|0|2620|0|0|1999|353|268|0|      -1|0.0335|1979|0.0469|24|641|47|||'

	EXEC -t'|' -k 4,4 -lsum,regress,op=count:integer:7:average:float:17 $data/nyse.dat
		OUTPUT - $'N|N0003|200106|AA|11|21|14596|3524300|9331|3494983|15500|1129332|1283396|639798|452298|5659|       0|0.0289|1717663|0.038|30|1195358|20|597462|0.0481|35
N|N0003|200106|AAT|11|21|48|14046|0|14046|0|7421|4549|1485|591|0|       0|0.0304|2513|0.01|25|11333|14|200|0.01|90
N|N0003|200106|ABJ|11|21|57|14508|0|14508|0|2603|9175|1650|1080|0|       2|0.0779|6636|0.0136|17|7872|25|||
N|N0003|200106|ABS|11|21|7425|1465605|200|1461410|2900|483622|651665|241738|87165|120|       0|0.0284|599869|0.0306|22|670152|18|194289|0.0373|25
N|N0003|200106|ABT|11|21|14051|3368858|8904|3347422|10900|1469987|1273455|447558|166267|1055|       0|0.0273|1682138|0.0365|18|1150749|14|525435|0.044|25
N|N0003|200106|ACA|11|21|45|11490|0|11490|0|2845|7495|100|1050|0|       1|0.0946|5052|0.0146|17|6438|22|||
N|N0003|200106|ACS|11|21|2456|523323|13500|509523|0|192518|202103|71973|42229|700|       0|0.0658|254514|0.0654|21|177869|17|77140|0.0915|38
N|N0003|200106|AEF|11|21|210|61757|0|61757|0|9524|22881|15536|13616|200|       0|0.0464|24867|0.0137|47|35248|43|1642|0.0401|27
N|N0003|200106|AET|11|21|2439|472785|900|471531|300|213068|162069|63465|32949|280|       0|0.0217|214120|0.0315|22|224763|16|32948|0.035|26
N|N0003|200106|AGC|11|21|6689|1443428|2747|1438956|1000|588445|574302|188125|88940|0|       0|0.0283|603123|0.0256|22|661220|16|175613|0.0329|31
N|N0003|200106|AGCPRA|11|21|56|16339|0|16339|0|3810|5914|4990|1625|0|       0|0.1187|7461|0.11|44|8678|25|200|0.085|8
N|N0003|200106|AGCPRB|11|21|25|6853|0|6853|0|100|3855|1550|1348|0|      -1|0.115|3097|0.0587|44|3756|46|||
N|N0003|200106|AGCPRM|11|21|57|15702|100|15602|0|1685|7911|3046|2170|790|      -2|0.0876|4071|0.0247|64|11031|65|500|0.078|166
N|N0003|200106|AGCPRMCL|11|21|4|1223|0|1223|0|0|923|300|0|0|       1|0.04|1223|0.01|22|||||
N|N0003|200106|AGCPRN|11|21|82|18338|0|18338|0|5186|8423|2223|2306|200|      -2|0.0967|2885|0.0334|65|15203|23|250|0.046|21
N|N0003|200106|AGCPRNCL|11|21|3|665|0|665|0|100|565|0|0|0|       0|0.01||||665|21|||
N|N0003|200106|AGI|11|21|23|4879|0|4879|0|730|2761|1388|0|0|      -1|0.0238|4099|0.0433|19|780|29|||
N|N0003|200106|AHO|11|21|514|101764|100|101464|200|25120|56355|13898|6291|0|      -2|0.061|51772|0.043|22|43731|19|6161|0.0371|23
N|N0003|200106|AIV|11|21|697|143764|0|143464|0|58036|56027|19187|10214|0|      -1|0.0629|54117|0.0484|20|80319|20|9028|0.0438|29
N|N0003|200106|AIVPRC|11|21|23|5998|0|5998|0|2025|2725|948|300|0|      -1|0.1098|2675|0.0259|25|3023|15|300|0.09|37
N|N0003|200106|AIVPRD|11|21|63|15180|0|15180|0|5430|8025|825|900|0|       1|0.1226|6105|0.0322|15|8975|24|100|0.04|12
N|N0003|200106|AIVPRG|11|21|45|12295|0|12295|0|3195|6435|1315|1350|0|       0|0.0783|3675|0.0122|30|7920|24|700|0.0343|32
N|N0003|200106|AIVPRH|11|21|25|5959|0|5959|0|2100|3074|785|0|0|       0|0.1345|2824|0.0322|13|3035|18|100|0.11|9
N|N0003|200106|AIVPRK|11|21|9|2070|0|2070|0|0|1070|600|400|0|       0|0.4413|1350|0.1863|48|720|20|||
N|N0003|200106|AIVPRP|11|21|56|11916|0|11916|0|3681|4873|2148|1214|0|       2|0.2129|3376|0.0379|23|8540|26|||
N|N0003|200106|AIVPRQ|11|21|39|10242|0|10242|0|3898|5497|327|520|0|       1|0.0792|4613|0.0174|19|5629|13|||
N|N0003|200106|AJG|11|21|875|196649|600|196049|0|80999|79015|21230|12954|1851|       1|0.0426|79215|0.0366|26|106810|13|10024|0.0518|45
N|N0003|200106|ALM|11|21|38|9137|0|9137|0|300|7876|961|0|0|      -4|0.0618|7139|0.0245|19|1998|15|||
N|N0003|200106|ALPPRN|11|21|3|1290|0|1290|0|0|890|400|0|0|       1|0.181|400|0.05|16|890|21|||
N|N0003|200106|ALPPRO|11|21|6|1700|0|1700|0|0|1700|0|0|0|      -6|0.2247|950|0.0621|26|750|18|||
N|N0003|200106|ALPPRQ|11|21|28|7400|0|7400|0|2517|4483|400|0|0|       1|0.0795|3496|0.0287|17|3904|11|||
N|N0003|200106|ALPPRR|11|21|43|12186|0|12186|0|2223|8511|1152|300|0|       0|0.0713|4546|0.0179|18|7540|15|100|0.04|63
N|N0003|200106|ALQ|11|21|53|14947|0|14947|0|5706|7091|2050|100|0|       1|0.0864|8607|0.0231|21|6040|12|300|0.01|7
N|N0003|200106|ALZ|11|21|38|10019|0|10019|0|800|8563|656|0|0|       3|0.1095|6749|0.0256|19|3270|13|||
N|N0003|200106|AMB|11|21|340|82057|0|81694|0|49345|26444|3944|1961|0|       0|0.029|37759|0.0248|12|40635|11|3300|0.0224|15
N|N0003|200106|AMBPRA|11|21|19|5460|0|5460|0|3560|1700|200|0|0|       0|0.1091|3300|0.0473|10|2160|13|||
N|N0003|200106|AMD|11|21|22321|4782471|105767|4655665|17300|1343670|1809871|952933|564656|1635|       0|0.0399|2160554|0.0464|24|1180503|21|1331908|0.0601|37
N|N0003|200106|ANN|11|21|1471|308613|7500|301013|100|160173|110558|25319|5063|0|       0|0.0525|131184|0.0608|13|134861|10|35068|0.0762|17
N|N0003|200106|AOC|11|21|3951|740421|1545|737685|900|213132|304297|146622|73959|575|       0|0.0241|340231|0.0367|28|337678|21|60676|0.0378|34
N|N0003|200106|ARB|11|21|432|81559|300|81259|0|24043|40724|12568|3924|0|       1|0.0549|39589|0.0546|22|36715|18|4955|0.0477|23
N|N0003|200106|ARH|11|21|9|1815|0|1815|0|400|1115|100|200|0|      -1|0.0527|1190|0.0182|31|625|19|||
N|N0003|200106|ATI|11|21|1153|204221|195|204026|0|95949|86063|15394|6520|100|       0|0.0249|88367|0.0285|16|109155|13|6504|0.0249|20
N|N0003|200106|AVP|11|21|5362|1025278|1664|1021714|1300|640871|320330|47980|12801|1032|       0|0.0305|463631|0.0358|10|466899|8|92484|0.0454|15
N|N0003|200106|AVZ|11|21|203|42999|0|42899|100|15985|19543|6471|1000|0|      -2|0.1957|20702|0.1167|19|19355|14|2942|0.0663|19
N|N0003|200106|AXL|11|21|233|43442|0|43442|0|11343|20974|6885|4240|0|       0|0.0834|21281|0.0732|30|20822|22|1339|0.0249|14
N|N0003|200106|AZA|11|21|4036|777156|5600|770456|500|475253|227074|51985|16512|132|      -1|0.0359|346051|0.0248|11|287853|9|137052|0.035|17
N|N0003|200106|AZZ|11|21|141|30688|0|30688|0|5454|17696|5938|1600|0|       1|0.0925|17081|0.0713|24|12107|24|1500|0.0293|20
N|N0003|200106|BC|11|21|1794|347438|2150|344388|900|119326|140853|55052|29034|1023|       0|0.0287|151059|0.0335|27|165409|19|28820|0.0421|28
N|N0003|200106|BCC|11|21|1261|232534|1500|231034|0|90880|102617|27338|10199|0|       0|0.0495|86498|0.0425|21|123377|15|21159|0.0489|20
N|N0003|200106|BD|11|21|132|26224|200|26024|0|8210|15964|1850|0|0|       0|0.0147|10370|0.0141|12|14654|13|1000|0.014|21
N|N0003|200106|BDF|11|21|39|9620|0|9620|0|3229|4243|1738|410|0|       0|0.0565|2903|0.0136|13|6717|23|||
N|N0003|200106|BGG|11|21|774|164711|600|163823|0|76597|68590|14556|4080|0|       1|0.0874|65955|0.0439|16|85847|11|12021|0.0977|21
N|N0003|200106|BGT|11|21|60|15473|0|15473|0|8014|5024|1985|450|0|       0|0.0185|3385|0.01|10|12088|14|||
N|N0003|200106|BK|11|21|14814|3340606|5800|3332030|800|2109454|974660|195186|53530|0|       0|0.0372|1548826|0.0305|11|1273475|9|510529|0.0417|16
N|N0003|200106|BKE|11|21|104|18544|0|18544|0|3788|12093|2226|437|0|       0|0.0528|10301|0.0694|18|7843|20|400|0.035|15
N|N0003|200106|BKPRC|11|21|66|17897|0|17897|0|10855|5842|850|350|0|       1|0.0857|8767|0.0274|15|8630|11|500|0.028|7
N|N0003|200106|BKPRD|11|21|80|21826|0|21826|0|13055|7571|500|700|0|       0|0.0714|10371|0.0168|11|11155|14|300|0.08|18
N|N0003|200106|BKPRE|11|21|81|23243|0|23243|0|10876|10497|1470|400|0|       2|0.0832|15715|0.0205|15|7528|12|||
N|N0003|200106|BLI|11|21|1232|227952|1609|226143|100|75627|104943|33926|11747|0|       0|0.0263|112032|0.0332|20|104908|17|9303|0.0328|22
N|N0003|200106|BNI|11|21|6187|1206018|400|1203328|1600|680896|414696|85020|23178|1138|       0|0.0285|588392|0.0262|13|511908|10|104628|0.0403|19
N|N0003|200106|BR|11|21|7135|1378982|4900|1370416|2000|687207|493400|131614|58722|1473|       0|0.0302|782525|0.0406|16|459377|12|130514|0.0503|29
N|N0003|200106|BRG|11|21|56|11360|0|11360|0|2143|6614|1791|812|0|      -5|0.1699|6410|0.118|29|4850|22|100|0.1|63
N|N0003|200106|BSP|11|21|25|4791|0|4791|0|1745|2537|509|0|0|       0|0.0835|2054|0.0143|14|2337|15|400|0.045|9
N|N0003|200106|BTY|11|21|1036|203914|400|203314|200|78459|82586|27485|14884|100|       1|0.1174|111376|0.0744|24|78300|16|13838|0.0657|24
N|N0002|200106|BTYRT|11|21|239|50506|0|50506|0|19517|24313|3320|3356|0|    -248|0.1598|32175|0.1498|23|17731|14|600|0.055|20
N|N0003|200106|BWG|11|21|30|6512|0|6512|0|1183|4379|650|300|0|      -3|0.1734|4366|0.0936|24|2046|21|100|0.08|0
N|N0003|200106|BXS|11|21|157|33939|0|33939|0|14334|13818|5063|724|0|       0|0.0378|17439|0.042|14|15418|17|1082|0.0204|22
N|N0003|200106|BYD|11|21|166|35218|200|35018|0|8011|13121|6471|7115|300|       0|0.0426|12541|0.0321|37|19449|44|3028|0.0338|50
N|N0003|200106|BZL|11|21|10|2330|0|2330|0|1000|400|530|400|0|      -1|0.0748|1130|0.04|53|800|8|400|0.02|7
N|N0003|200106|C|11|21|36206|7798662|31303|7747379|16900|3563357|2481386|1113981|603003|2552|       0|0.0228|4246991|0.0389|19|2228824|15|1288464|0.0463|33
N|N0003|200106|CBM|11|21|983|194272|2240|191632|0|63286|89872|27044|11430|0|       3|0.1101|81401|0.0814|22|85841|16|24390|0.132|30
N|N0003|200106|CCC|11|21|209|43832|300|43532|0|9359|19019|8257|6297|600|       0|0.0488|20746|0.0443|44|20283|29|2503|0.0202|39
N|N0003|200106|CCPPRA|11|21|60|13025|0|13025|0|2350|7424|2707|544|0|       3|0.3285|5751|0.0625|18|6774|26|500|0.058|17
N|N0003|200106|CCR|11|21|3630|728090|6800|719678|1000|267653|271128|122720|59077|100|       1|0.0301|346880|0.0381|22|277870|18|95928|0.0488|30
N|N0003|200106|CEA|11|21|10|2229|0|2229|0|300|1601|328|0|0|      -6|0.1549|928|0.031|17|1201|16|100|0.01|16
N|N0003|200106|CED|11|21|138|25925|300|25625|0|5812|12625|5838|1350|0|      -4|0.108|13523|0.0484|25|10252|19|1850|0.043|36
N|N0003|200106|CEM|11|21|155|30385|0|30385|0|6560|16100|6125|1600|0|       1|0.0917|15567|0.0682|23|13468|23|1350|0.0337|30
N|N0003|200106|CEN|11|21|498|110436|0|110236|200|45363|46318|11486|6969|300|       0|0.0306|50010|0.0344|21|55025|14|5401|0.0262|38
N|N0003|200106|CF|11|21|3637|639764|3248|634316|1500|182374|248718|123189|77927|3608|       0|0.0254|286515|0.033|30|282454|22|66847|0.0282|49
N|N0003|200106|CFE|11|21|7|1684|0|1684|0|1300|100|284|0|0|       4|0.1669|984|0.25|18|700|8|||
N|N0003|200106|CFN|11|21|16|4234|0|4234|0|1018|1116|1300|800|0|      -1|0.0828|1200|0.3967|71|3034|26|||
N|N0003|200106|CGPPRG|12|21|54|5400|4900|500|0|0|100|200|200|0|     -59|0.184|200|0.75|80|300|33|||
N|N0003|200106|CGPPRI|11|21|4|750|0|750|0|0|200|0|400|150|     -17|0.026|550|0.7182|511|200|23|||
N|N0003|200106|CGPPRT|11|21|38|9711|0|9711|0|3766|4598|1147|200|0|      -4|0.0734|2517|0.0372|15|7042|15|152|0.01|24
N|N0003|200106|CHD|11|21|606|132464|1359|131105|0|52672|55896|14149|7853|535|       0|0.0634|55486|0.0467|19|68291|17|7328|0.0501|27
N|N0003|200106|CHH|11|21|242|54062|0|53762|0|17816|21767|9596|4583|0|       0|0.0552|26188|0.0734|31|23562|16|4012|0.0527|16
N|N0002|200106|CHTRT|11|21|12|3174|0|3174|0|160|0|320|2375|319|       0|0.0609|1735|0.0113|116|1439|198|||
N|N0002|200106|CHTRTWI|12|24|1|5000|0|5000|0|0|0|5000|0|0|      -1|0.04||||5000|31|||
N|N0003|200106|CIC|11|21|184|49613|0|49613|0|12025|25301|7518|4769|0|       0|0.0656|15733|0.0419|22|33280|25|600|0.0533|62
N|N0003|200106|CIP|11|21|84|22418|0|22418|0|4677|16266|1050|425|0|      -1|0.0745|11685|0.0212|16|10033|16|700|0.0229|12
N|N0003|200106|CIR|11|21|339|57557|600|56957|0|24724|23479|6114|2640|0|       2|0.0568|31783|0.0736|16|21547|14|3627|0.1043|30
N|N0003|200106|CKC|11|21|157|29607|0|29607|0|9386|15183|3387|1651|0|       0|0.0255|7241|0.0637|30|21486|17|880|0.0327|46
N|N0003|200106|CKH|11|21|487|88089|0|88089|0|41269|36261|7618|2941|0|       1|0.0825|32140|0.0668|15|48565|12|7384|0.0821|18
N|N0003|200106|CLB|11|21|640|122678|600|122078|0|25245|56302|22564|17297|670|       0|0.0714|57167|0.0743|39|58510|25|6401|0.0322|58
N|N0003|200106|CLJ|11|21|236|38026|0|38026|0|5116|17590|8934|6386|0|       0|0.0909|17649|0.0682|43|19877|32|500|0.042|67
N|N0003|200106|CLL|11|21|46|8406|300|8106|0|1238|4650|1785|433|0|      -9|0.2263|3948|0.1524|16|3958|24|200|0.29|58
N|N0003|200106|CMO|11|21|543|106712|0|106312|400|43418|52504|8949|1841|0|       0|0.0488|53463|0.043|16|49371|12|3878|0.0384|11
N|N0003|200106|CMOPRA|11|21|15|3043|0|3043|0|1294|850|599|300|0|     -20|0.3056|1249|0.5695|35|1794|16|||
N|N0003|200106|CMOPRB|11|21|38|10036|0|10036|0|3886|4894|915|341|0|       1|0.13|3128|0.0804|19|6528|19|380|0.01|14
N|N0003|200106|CMP|11|21|326|73395|0|73395|0|17955|42915|9935|2590|0|       0|0.1083|20714|0.0277|19|48680|18|4001|0.0559|33
N|N0003|200106|CMS|11|21|2234|430340|888|427110|2000|222679|168912|27920|9599|0|       0|0.0312|192319|0.0264|13|205993|11|30798|0.0334|18
N|N0003|200106|CMSPRJ|11|21|22|6005|0|6005|0|975|4230|800|0|0|      11|0.2442|3930|0.0288|18|1775|17|300|0.1|17
N|N0003|200106|CMSPRK|11|21|33|9399|0|9399|0|800|7649|950|0|0|       2|0.2479|2575|0.0399|17|6124|18|700|0.1843|12
N|N0003|200106|CMSPRL|11|21|35|9413|0|9413|0|2016|4977|2005|415|0|      -3|0.1851|4199|0.0565|24|4814|22|400|0.1|37
N|N0003|200106|CMSPRM|11|21|7|1698|0|1698|0|0|1398|0|300|0|     -11|0.3419|1398|0.0949|20|||300|0.25|156
N|N0003|200106|CMSPRN|11|21|17|4241|0|4241|0|523|2258|1260|200|0|       1|0.0779|3641|0.0212|28|600|9|||
N|N0003|200106|CNA|11|21|681|155244|0|154844|400|57125|83968|12351|1800|0|       0|0.0546|66722|0.0293|14|80492|10|8030|0.033|17
N|N0003|200106|CNL|11|21|567|129633|100|129233|300|70295|48666|7529|3043|0|       0|0.0612|53723|0.0363|14|69264|10|6546|0.0487|18
N|N0003|200106|CNN|11|21|21|4852|0|4852|0|2531|1646|200|475|0|      -2|0.038|3087|0.0285|13|1765|48|||
N|N0003|200106|COE|11|21|21|5098|0|5098|0|1085|1178|1635|1200|0|       0|0.0358|1785|0.0243|33|3313|59|||
N|N0003|200106|COG|11|21|625|131188|1478|129510|200|31708|55095|27764|14801|342|       0|0.0433|60097|0.0666|32|60933|24|8680|0.0682|51
N|N0003|200106|CPD|11|21|41|9634|0|9634|0|4435|3309|1640|250|0|       1|0.0417|7584|0.0444|18|2050|11|||
N|N0003|200106|CPP|11|21|13|3230|0|3230|0|900|1350|980|0|0|      14|0.1737|900|0.0567|28|2330|18|||
N|N0003|200106|CPRE|11|21|90|23321|0|23321|0|2550|15745|3669|1357|0|       1|0.0674|13212|0.0199|26|9709|18|400|0.1|41
N|N0003|200106|CPRF|11|21|6|1100|0|1100|0|0|900|0|200|0|       4|0.3159|250|0.48|23|850|28|||
N|N0003|200106|CPRG|11|21|7|1326|0|1326|0|0|764|562|0|0|      14|0.4987|664|0.1324|29|662|30|||
N|N0003|200106|CPRH|11|21|6|1320|0|1320|0|0|600|720|0|0|      13|0.422|920|0.1978|23|400|59|||
N|N0003|200106|CPRK|11|21|42|11084|0|11084|0|500|7692|2092|600|200|       7|0.2243|5553|0.0862|41|5131|29|400|0.165|32
N|N0003|200106|CPRM|11|21|10|2226|0|2226|0|339|960|727|200|0|      12|0.5577|1580|0.2241|29|446|18|200|0.25|38
N|N0003|200106|CPRN|11|21|43|11091|0|11091|0|2000|7226|1205|660|0|       1|0.0632|5145|0.0127|21|5946|26|||
N|N0003|200106|CPRQ|11|21|4|1200|0|1200|0|0|500|700|0|0|      27|0.5625|400|0.05|31|600|21|200|0.1|22
N|N0003|200106|CPRR|11|21|2|500|0|500|0|0|300|0|200|0|      28|0.602|300|0.03|26|200|72|||
N|N0003|200106|CPRU|11|21|12|3145|0|3145|0|200|1745|800|400|0|      23|0.5192|1470|0.0813|20|1675|47|||
N|N0003|200106|CPRW|11|21|203|54632|0|54632|0|10698|29850|9542|4142|400|       1|0.0715|24025|0.0144|27|30207|31|400|0.04|21
N|N0003|200106|CPRX|11|21|152|45053|400|44653|0|9460|26551|5112|3530|0|       1|0.0603|19055|0.0159|31|25098|22|500|0.044|106
N|N0003|200106|CQPRA|11|21|80|19210|0|19210|0|5594|9166|3275|1175|0|       0|0.1641|10230|0.0347|18|8480|27|500|0.08|40
N|N0003|200106|CRM|11|21|6|1000|0|1000|0|0|300|0|700|0|      -5|-0.057|500|0.81|65|500|66|||
N|N0003|200106|CRY|11|21|1181|234595|3650|230145|500|98877|107261|19489|5018|0|       2|0.1235|91095|0.097|16|107036|12|32514|0.1306|20
N|N0003|200106|CSL|11|21|702|142404|860|141544|0|43960|64987|21866|10199|532|       1|0.0624|60868|0.0381|24|68088|17|12588|0.0475|27
N|N0003|200106|CSP|11|21|46|11788|0|11188|600|4305|5430|1114|939|0|       0|0.0379|3505|0.0229|13|8183|24|100|0.02|14
N|N0003|200106|CVC|11|21|1573|300546|2400|297846|0|124254|143338|23288|6966|0|       1|0.0522|119404|0.0584|16|145555|12|32887|0.052|19
N|N0003|200106|CVD|11|21|957|215338|1250|212285|1000|63619|102151|34471|13044|0|       0|0.0433|91877|0.0469|22|107181|19|14227|0.0438|27
N|N0003|200106|CW|11|21|64|11629|0|11629|0|1568|7271|1704|1086|0|       0|0.1445|5531|0.0981|29|5598|18|500|0.082|24
N|N0003|200106|CWN|11|21|268|59776|200|59176|400|10708|28045|14206|6517|100|       0|0.0268|23025|0.035|36|35286|30|1265|0.0361|38
N|N0003|200106|CWNPRA|11|21|23|5460|0|5460|0|1280|2775|1105|300|0|       2|0.1623|2850|0.0813|21|2610|29|||
N|N0003|200106|CYE|11|21|163|44347|0|44047|300|11950|16310|9270|6567|250|       0|0.029|15808|0.0208|39|28139|28|400|0.03|68
N|N0003|200106|D|11|21|6378|1219758|2220|1216438|1100|899099|288283|25052|5104|0|       0|0.0547|587917|0.0449|8|463592|7|166029|0.0507|10
N|N0003|200106|DCP|11|21|120|23882|0|23882|0|6845|13962|2650|425|0|     -17|0.4252|14729|0.1923|19|9153|17|||
N|N0003|200106|DCS|11|21|26|4646|100|4546|0|826|1934|886|900|0|      -1|0.0374|646|0.0154|28|3900|39|||
N|N0003|200106|DDF|11|21|130|34631|104|34527|0|7804|18014|5335|3374|0|       0|0.0619|12217|0.0453|22|21810|22|500|0.01|12
N|N0003|200106|DFG|11|21|322|57038|0|57038|0|27051|22775|5339|1873|0|       0|0.0532|24654|0.036|18|28384|11|4000|0.0359|16
N|N0003|200106|DGX|11|21|5186|1005363|24875|978733|1100|406700|402320|118543|51365|905|       1|0.1035|454631|0.1058|20|354981|15|170221|0.1344|24
N|N0003|200106|DHY|11|21|69|15511|0|15511|0|3644|6401|3456|1868|142|      -1|0.0212|5804|0.0202|39|9407|33|300|0.01|39
N|N0003|200106|DJM|11|21|2|830|0|830|0|400|430|0|0|0|       0|0.1004|430|0.01|22|400|4|||
N|N0003|200106|DLX|11|21|1601|281299|2671|278216|300|71701|103284|50590|50913|2028|       0|0.0344|101971|0.0331|40|151551|33|24994|0.05|48
N|N0003|200106|DNB|11|21|925|207241|100|207141|0|97114|83577|20796|5654|0|       0|0.0423|106479|0.0315|16|90982|12|9680|0.0268|21
N|N0003|200106|DNR|11|21|384|73429|101|72428|900|27435|35656|7906|2331|0|       0|0.0339|30182|0.0324|16|39174|15|3972|0.0371|19
N|N0003|200106|DNY|11|21|1965|380145|100|379832|0|216298|132793|19890|10851|0|       0|0.0381|156676|0.0298|13|193479|12|29677|0.0313|15
N|N0003|200106|DPRA|11|21|125|35911|0|35911|0|16642|14590|3109|1570|0|       0|0.1137|13725|0.0222|17|20986|15|1200|0.0733|17
N|N0003|200106|DSU|11|21|261|76624|280|76344|0|28055|28115|11749|8425|0|       0|0.0231|27021|0.0138|28|48009|27|1314|0.0163|34
N|N0003|200106|DT|11|21|2026|446775|1300|444775|700|253675|148003|35543|8254|0|       0|0.0166|202363|0.0184|12|202306|10|40806|0.0204|23
N|N0003|200106|DV|11|21|677|149804|900|148704|200|53027|64825|19880|10136|1036|       0|0.0764|65449|0.0428|22|72670|17|10785|0.0449|21
N|N0003|200106|EAS|11|21|709|158503|600|157500|0|70724|51100|22068|13608|0|       0|0.0322|57187|0.035|26|94069|17|6244|0.0266|40
N|N0003|200106|ED|11|21|4263|765164|1625|760880|1700|269390|288368|128899|73604|4061|       0|0.0326|315254|0.0402|32|364869|20|82457|0.0417|45
N|N0003|200106|EDE|11|21|259|54956|0|54856|100|22840|24852|6013|1251|100|       0|0.0399|26989|0.0521|15|25555|16|2412|0.0353|19
N|N0003|200106|EDEPRD|11|21|20|4917|0|4917|0|900|2790|1127|100|0|       0|0.0871|4417|0.1058|19|300|26|200|0.06|31
N|N0003|200106|EDL|11|21|93|24045|0|24045|0|4069|14154|4450|1372|0|       0|0.0953|4642|0.0249|30|17298|22|2105|0.0329|18
N|N0003|200106|EDO|11|21|700|150405|2000|148405|0|48400|64713|22279|12513|500|       1|0.0571|72066|0.0717|23|66460|15|9879|0.0961|31
N|N0003|200106|EDPRA|11|21|19|3320|0|3320|0|500|1950|400|470|0|      -6|0.8095|1820|0.7951|31|1200|27|300|0.4167|28
N|N0003|200106|EFL|11|21|24|4491|0|4491|0|1783|2333|275|100|0|       0|0.1064|3238|0.0392|14|1253|18|||
N|N0003|200106|ELN|11|21|8381|1698154|28233|1658521|9800|591927|749792|247952|77850|800|       1|0.0376|896938|0.0543|20|574910|16|196473|0.0643|24
N|N0003|200106|ELNWSA|11|21|81|15924|0|15924|0|2530|8535|2849|2010|0|     -21|0.618|9810|0.2236|33|5214|14|900|0.1233|61
N|N0003|200106|ELNWSB|11|21|16|3710|0|3710|0|950|1510|800|450|0|     -47|1.0969|2100|0.5145|54|1410|12|200|0.79|20
N|N0003|200106|EMC|11|21|47650|9897171|68202|9782039|39300|3244345|4085888|1836849|651461|1701|       0|0.0249|5060991|0.0472|22|2257708|15|2502640|0.0544|30
N|N0003|200106|EMD|11|21|14|3634|0|3634|0|200|2219|700|515|0|       1|0.0971|1119|0.0607|21|2515|31|||
N|N0003|200106|EPG|11|21|18292|3812438|35121|3757321|15900|1178720|1457845|694790|424248|17468|       0|0.0318|2175190|0.0565|26|985314|20|612717|0.0627|36
N|N0003|200106|EPGPR|11|21|4|589|0|589|0|0|0|100|489|0|      47|1.1746|489|0.234|91|100|142|||
N|N0003|200106|EPGPRC|11|21|9|1800|0|1800|0|0|200|800|400|400|     -68|1.6667|500|0.298|99|900|253|400|1.05|42
N|N0003|200106|EPI|11|21|126|33956|200|33756|0|10726|15906|5444|1680|0|       0|0.0843|13803|0.0236|22|19153|19|800|0.0238|21
N|N0003|200106|EPL|11|21|326|76532|0|76232|300|31698|32628|8058|4148|0|       0|0.039|33547|0.0448|20|41085|15|1900|0.0384|30
N|N0003|200106|EPN|11|21|918|207403|200|207003|200|67977|98548|24636|15492|550|       0|0.0573|111443|0.0584|22|85320|22|10440|0.0449|39
N|N0003|200106|ESI|11|21|1347|263316|10079|252937|200|72537|103484|43898|32168|1050|       2|0.0683|113865|0.0789|32|107821|21|31451|0.1062|56
N|N0003|200106|ETA|11|21|30|6305|0|6305|0|800|3730|1385|390|0|      -2|0.0437|3350|0.023|24|2855|29|100|0.04|38
N|N0003|200106|EX|11|21|189|36259|200|36059|0|11720|18552|4551|1236|0|       0|0.0391|16262|0.0377|21|18701|14|1096|0.0338|35
N|N0003|200106|FC|11|21|39|7273|0|7273|0|2340|3733|1100|100|0|       0|0.0469|4128|0.0602|21|3045|11|100|0.02|14
N|N0003|200106|FCX|11|21|2268|477507|0|477007|500|224775|186859|45247|20626|0|       0|0.0182|200039|0.0292|19|251445|13|26023|0.0258|17
N|N0003|200106|FCXA|11|21|203|43156|440|42716|0|15376|22763|3384|1049|144|      -1|0.0382|23814|0.0421|19|17487|13|1415|0.0248|40
N|N0003|200106|FCXPRA|11|21|76|18015|0|18015|0|5645|7438|3682|1250|0|       0|0.0635|11571|0.0507|23|6444|22|||
N|N0003|200106|FCXPRB|11|21|66|14738|0|14738|0|3662|8961|1765|350|0|       2|0.1379|5695|0.0608|21|9043|19|||
N|N0003|200106|FCXPRC|11|21|18|4202|0|4202|0|0|2202|1700|300|0|       1|0.1058|1100|0.0409|35|3102|25|||
N|N0003|200106|FCXPRD|11|21|32|7878|0|7878|0|754|6474|650|0|0|       0|0.0839|4508|0.0431|17|3370|19|||
N|N0003|200106|FE|11|21|4339|852395|1200|849495|600|440011|305729|80238|22433|1684|       0|0.0259|297521|0.0334|15|484823|12|67751|0.0391|18
N|N0003|200106|FLR|11|21|2918|566592|10100|554892|1000|189895|244194|85222|36481|100|       3|0.062|286010|0.0751|20|184057|16|85825|0.1055|33
N|N0003|200106|FMC|11|21|1529|300685|6100|294585|0|119860|125954|33675|15096|0|       1|0.06|158560|0.0587|18|100317|17|35708|0.0695|31
N|N0003|200106|FO|11|21|2620|497417|300|496617|200|263838|184257|39171|9551|0|       0|0.0459|217394|0.0347|13|239890|11|39533|0.0497|21
N|N0003|200106|FOE|11|21|591|125134|506|124228|0|44257|57903|16669|5399|0|       0|0.0377|56458|0.0374|20|61161|16|6609|0.0451|19
N|N0003|200106|FOPRA|13|21|1|300|300|0|0|0|0|0|0|0|0|||||||||
N|N0003|200106|FOR|11|21|60|12184|0|12184|0|8401|3433|350|0|0|      -1|0.0292|7012|0.0142|10|5172|7|||
N|N0003|200106|FPCPRA|11|21|74|22202|0|22202|0|9105|6257|2976|3864|0|       1|0.1081|10106|0.0562|28|12096|34|||
N|N0003|200106|FRC|11|21|251|47308|200|47108|0|11567|14565|9783|10893|300|       1|0.0645|16764|0.0702|53|24944|38|5400|0.1115|77
N|N0003|200106|FSH|11|21|917|195393|1100|194093|200|78546|81804|23834|10409|0|       0|0.0717|92235|0.068|22|89125|14|12933|0.0638|25
N|N0003|200106|FTI|11|21|1980|362127|100|361927|100|145638|148580|54179|13530|100|       2|0.0225|195780|0.0546|19|152912|17|13335|0.0439|26
N|N0003|200106|FWJ|11|21|3|900|0|900|0|0|900|0|0|0|      -2|0.1167|300|0.1|18|600|20|||
N|N0003|200106|GBE|11|21|23|4475|0|4475|0|1148|1629|814|884|0|       0|0.0771|2092|0.049|30|2083|24|300|0.05|49
N|N0003|200106|GCG|11|21|4|900|0|900|0|400|0|100|400|0|       0|-0.0011|700|0.0443|57|200|0|||
N|N0003|200106|GDP|11|21|20|4550|0|4550|0|1660|2414|476|0|0|      -2|0.0799|1889|0.0255|18|2261|11|400|0.015|11
N|N0003|200106|GGT|11|21|114|24322|0|24322|0|9040|11256|3414|612|0|      -3|0.0914|9010|0.0369|16|14434|18|878|0.0613|14
N|N0003|200106|GGTPR|11|21|9|2302|0|2302|0|400|1602|300|0|0|      -1|0.2422|200|0.02|8|2102|16|||
N|N0003|200106|GID|11|21|3|600|0|600|0|100|300|200|0|0|       2|0.0133|600|0.05|28|||||
N|N0003|200106|GK|11|21|110|17156|0|17156|0|1750|7742|4376|3062|226|      -2|0.0597|9137|0.0484|35|6619|55|1400|0.0421|52
N|N0003|200106|GLC|11|21|1397|310305|2700|306105|1100|88027|135891|55266|26942|1079|       0|0.0268|152886|0.0322|25|129221|21|25098|0.0498|30
N|N0003|200106|GLG|11|21|210|51489|0|51089|400|30501|17462|3225|301|0|       0|0.0265|13063|0.0168|11|37509|11|917|0.0151|7
N|N0003|200106|GLH|11|21|201|45051|0|45051|0|15566|21649|5843|1993|0|      -6|0.143|14705|0.0661|23|28551|15|1795|0.0261|21
N|N0003|200106|GLW|11|21|31632|6854173|13360|6798713|38700|3855589|2284747|586994|109468|615|       0|0.0136|3112503|0.0242|12|2413309|9|1311601|0.0273|18
N|N0003|200106|GPB|11|21|94|26231|0|26231|0|4691|15476|4364|1700|0|       1|0.0968|14042|0.057|21|11889|26|300|0.0167|53
N|N0003|200106|GPD|11|21|53|13433|0|13433|0|7588|5845|0|0|0|      -1|0.1593|7865|0.0481|10|5268|10|300|0.1|9
N|N0003|200106|GPEPRA|11|21|62|17189|0|17189|0|7510|8831|848|0|0|       1|0.1118|10268|0.0573|13|6921|10|||
N|N0003|200106|GPEPRT|11|21|57|14799|400|14399|0|6781|6318|1100|200|0|       0|0.0711|6620|0.0196|18|7779|8|||
N|N0003|200106|GPEPRU|11|21|49|12589|0|12589|0|4059|8135|395|0|0|       0|0.1653|7537|0.0333|12|5052|11|||
N|N0003|200106|GPEPRV|11|21|32|7953|0|7953|0|1966|4966|1021|0|0|       5|0.1588|4145|0.0421|17|3508|19|300|0.0733|14
N|N0003|200106|GPF|11|21|20|5986|0|5986|0|1030|3571|925|460|0|      -2|0.1622|1540|0.0802|23|4446|26|||
N|N0003|200106|GPU|11|21|1834|331935|1599|329136|500|179273|123240|20383|6540|200|       0|0.0418|164349|0.0434|12|136469|11|28818|0.0411|15
N|N0003|200106|GRA|11|21|217|50998|0|50998|0|21532|22718|6164|584|0|       0|0.0143|18821|0.0151|17|31361|14|816|0.0202|6
N|N0003|200106|GRB|11|21|163|27554|0|27554|0|5052|13374|6620|2508|0|       0|0.0295|12715|0.0593|26|13418|28|1421|0.0244|47
N|N0003|200106|GUPPRA|11|21|18|4554|0|4554|0|350|4204|0|0|0|       1|0.1284|2809|0.1062|13|1745|14|||
N|N0003|200106|GUPPRB|11|21|21|5484|0|5484|0|550|4584|350|0|0|       4|0.1667|3784|0.0723|15|1700|11|||
N|N0003|200106|HAR|11|21|769|148497|1800|146597|100|34515|73133|27304|11745|0|       2|0.0552|68766|0.0854|26|67117|23|10814|0.1312|22
N|N0003|200106|HAS|11|21|2142|438982|100|437882|1000|174135|192970|53185|18592|0|       0|0.0301|246768|0.0269|17|172621|16|19493|0.0313|24
N|N0003|200106|HCN|11|21|804|177141|0|175441|800|59204|72907|26587|16813|730|      -1|0.034|81716|0.0317|27|85715|20|8810|0.0327|45
N|N0003|200106|HCNPRB|11|21|38|10125|0|10125|0|2217|4841|2284|783|0|       3|0.1173|6825|0.0796|25|2900|37|400|0.05|14
N|N0003|200106|HGR|11|21|31|7668|0|7668|0|2203|2650|1915|900|0|       0|0.0502|2915|0.0361|44|4653|19|100|0.02|8
N|N0003|200106|HIL|11|21|58|12938|0|12938|0|3997|7419|1222|300|0|       0|0.0221|7891|0.0332|15|4547|15|500|0.026|18
N|N0003|200106|HIW|11|21|853|201813|138|201675|0|124564|67892|7219|1700|300|       0|0.0302|92008|0.0319|10|101169|9|8498|0.0282|18
N|N0003|200106|HIWPRB|11|21|48|13382|0|13382|0|3770|8212|1000|400|0|       2|0.1308|9665|0.0841|16|3717|18|||
N|N0003|200106|HIWPRD|11|21|51|13883|0|13883|0|3676|7969|2238|0|0|       0|0.1521|8843|0.0724|17|4640|16|400|0.055|9
N|N0003|200106|HMA|11|21|1305|285451|0|284551|900|120298|111741|35184|17878|350|       0|0.0185|153353|0.0329|22|115598|15|16500|0.0365|33
N|N0003|200106|HMC|11|21|327|61763|0|61763|0|23757|28584|7033|2389|0|       0|0.1751|29459|0.1755|21|28592|13|3712|0.0987|30
N|N0003|200106|HMT|11|21|1019|248392|300|245792|2300|101541|107186|25592|12063|1710|       0|0.0155|123922|0.0207|20|115408|14|8762|0.018|59
N|N0003|200106|HMTPRA|11|21|40|10915|0|10915|0|2225|7190|1100|400|0|       0|0.1225|4130|0.0509|12|6285|19|500|0.086|42
N|N0003|200106|HMTPRB|11|21|45|12320|0|12320|0|4705|5465|1700|450|0|       0|0.0985|7575|0.0284|16|4545|23|200|0.1|18
N|N0003|200106|HMTPRC|11|21|58|16685|0|16685|0|4440|10635|1280|330|0|       0|0.0897|7385|0.018|21|8900|13|400|0.05|7
N|N0003|200106|HON|11|21|19634|4537992|36160|4486970|11800|2162439|1652916|496192|184563|2660|       0|0.0359|2222825|0.0602|16|1376974|12|898971|0.0831|26
N|N0003|200106|HOV|11|21|497|107289|200|106689|300|46229|49915|7595|3250|0|       0|0.0621|47328|0.0482|16|52446|13|7215|0.0522|15
N|N0003|200106|HZO|11|21|20|4175|0|4175|0|1240|2184|200|551|0|      -1|0.039|1809|0.0585|30|2366|22|||
N|N0003|200106|ICS|11|21|7|1506|0|1506|0|0|1506|0|0|0|       0|0.0675|770|0.0113|10|736|16|||
N|N0003|200106|IDG|11|21|11|2461|0|2461|0|319|1494|648|0|0|       3|0.1105|1813|0.0317|11|||648|0.1|38
N|N0003|200106|IEU|11|21|16|4255|0|4255|0|255|3200|400|400|0|      -4|0.2366|1555|0.0971|15|2700|36|||
N|N0003|200106|IFX|11|21|738|155517|1600|152017|400|57220|65935|19363|9549|350|      -2|0.1008|54177|0.0564|21|66889|15|31351|0.0759|27
N|N0003|200106|IGL|11|21|884|187910|400|187210|300|46812|77036|38157|24596|909|       0|0.0177|77292|0.0227|36|101416|23|8802|0.0292|38
N|N0003|200106|IML|11|21|24|6306|0|6306|0|857|3090|1110|945|304|      -1|0.1118|4214|0.0282|50|1335|44|757|0.0617|87
N|N0003|200106|IQM|11|21|27|9088|0|9088|0|3112|3224|1533|1219|0|       0|0.0412|2795|0.0247|19|6163|27|130|0.02|15
N|N0003|200106|IR|11|21|3775|759241|2050|754499|2100|278603|313443|122486|41102|1380|       0|0.0277|384981|0.0303|20|301091|17|70527|0.0412|26
N|N0003|200106|ISP|11|21|117|20875|0|20875|0|5474|11352|2541|1508|0|       0|0.0493|11155|0.0345|20|8420|19|1300|0.0331|33
N|N0003|200106|ITG|11|21|1108|235115|3900|231115|100|71405|116744|30416|12650|0|       0|0.0835|110607|0.0695|22|102156|15|18452|0.1072|32
N|N0003|200106|ITN|11|21|371|78922|429|78493|0|38979|31129|6358|2027|0|       0|0.0448|27960|0.0329|13|45177|12|5356|0.037|20
N|N0003|200106|ITT|11|21|1622|286838|300|285930|500|109564|148979|23443|4444|0|       0|0.0516|134635|0.0453|15|131715|12|20080|0.0523|18
N|N0003|200106|ITX|11|21|71|16878|200|16678|0|3675|9192|2450|1361|0|       0|0.0615|5862|0.039|25|7799|16|3017|0.0462|32
N|N0003|200106|ITXPR|11|21|8|1738|0|1738|0|199|729|450|360|0|     -23|0.3264|888|0.2684|41|700|45|150|0.5|10
N|N0003|200106|IVC|11|21|574|109326|0|109042|0|56256|39484|9774|3528|0|       1|0.0595|52292|0.0707|14|49763|14|6987|0.0589|23
N|N0003|200106|JBL|11|21|10652|2021224|38650|1976374|5600|828342|716374|280748|152377|4133|       0|0.0406|978092|0.0497|20|664172|15|339710|0.0735|35
N|N0003|200106|JCP|11|21|4785|923275|3200|917192|2600|476919|354391|69553|17871|1058|       0|0.027|417906|0.0348|15|412601|11|89285|0.0462|17
N|N0003|200106|JEM|11|21|14|3691|0|3691|0|2595|846|250|0|0|       1|0.0709|650|0.0162|17|3041|8|||
N|N0003|200106|JOE|11|21|560|109132|100|108932|100|37049|49203|13005|9415|360|       0|0.0545|30081|0.028|28|72812|20|6139|0.0361|55
N|N0003|200106|JYPPRZ|11|21|33|8294|0|8294|0|3987|2853|1454|0|0|       0|0.0813|2801|0.0214|12|5093|17|400|0.055|13
N|N0003|200106|KBH|11|21|2003|396444|1900|393544|700|235578|135787|19031|3612|236|       0|0.052|158530|0.0436|12|201018|9|34696|0.062|18
N|N0003|200106|KBHPRG|12|23|1|4000|3800|200|0|0|200|0|0|0|      -5|0.25||||200|18|||
N|N0003|200106|KBHPRI|11|21|10|1870|0|1870|0|670|1200|0|0|0|      -4|0.1165|600|0.0233|10|1270|11|||
N|N0003|200106|KEG|11|21|1018|219955|1787|218168|0|79979|96492|29441|11905|351|       0|0.0309|96876|0.0251|21|100725|18|20567|0.0376|30
N|N0003|200106|KEI|11|21|1527|304821|3399|301422|0|107761|129096|42537|22028|0|       0|0.0795|140598|0.0738|21|117736|18|43088|0.0839|31
N|N0003|200106|KG|11|21|5215|1031366|8400|1021866|1100|454412|432306|107139|28667|442|       0|0.0377|522352|0.0555|16|392279|13|108335|0.069|18
N|N0003|200106|KLU|11|21|160|33466|0|33466|0|12755|16840|3321|550|0|       1|0.052|13916|0.0403|14|18540|14|1010|0.01|16
N|N0003|200106|KMB|11|21|10045|2164410|4955|2150133|7000|686439|883329|387441|193491|6433|       0|0.0322|1162179|0.0422|24|704899|21|290055|0.0583|29
N|N0003|200106|KOR|11|21|26|5566|0|5566|0|1145|2746|600|1075|0|      -2|0.0425|3656|0.0338|26|1910|33|||
N|N0003|200106|KPA|11|21|290|63086|0|62586|500|27584|24830|7518|3154|0|       0|0.0301|18392|0.0203|18|41710|16|2984|0.0191|24
N|N0003|200106|KPAPRA|11|21|38|8841|0|8841|0|2025|3910|800|2106|0|       0|0.2095|2760|0.056|50|5456|28|625|0.1156|16
N|N0003|200106|KRJ|11|21|4|1150|0|1150|0|300|850|0|0|0|       2|0.113|600|0.0833|18|550|14|||
N|N0003|200106|KTB|11|21|24|6825|0|6825|0|1200|3975|850|800|0|       3|0.1024|4475|0.0597|29|2350|20|||
N|N0003|200106|KTP|11|21|113|29875|0|29875|0|11654|14076|3720|425|0|       0|0.1111|13092|0.0381|17|15603|15|1180|0.0632|17
N|N0003|200106|KYO|11|21|488|90772|0|90472|300|44067|39611|5763|1331|0|      -5|0.3294|39291|0.1462|13|44089|12|7392|0.1991|15
N|N0003|200106|LBI|11|21|9|1540|0|1540|0|200|1090|250|0|0|      -4|0.0645|713|0.121|22|827|15|||
N|N0003|200106|LDP|11|21|71|16330|0|16330|0|4713|7895|1543|2179|0|      -1|0.0814|6311|0.0355|21|9254|26|765|0.0413|41
N|N0003|200106|LMM|11|21|5|1340|0|1340|0|400|450|490|0|0|       0|0.0192|210|0.0257|18|1130|27|||
N|N0003|200106|LMS|11|21|40|8949|0|8949|0|1605|5269|1025|1050|0|      -1|0.0789|5069|0.0544|32|3770|16|110|0.02|12
N|N0003|200106|LMT|11|21|7427|1539221|2321|1534598|1500|813099|498258|155630|68871|240|       0|0.038|652816|0.0387|18|731392|12|151890|0.0449|19
N|N0003|200106|LNT|11|21|1104|241025|0|240325|700|74986|120488|33823|11428|300|       0|0.0345|72301|0.0345|18|155939|17|12785|0.0238|23
N|N0003|200106|LRY|11|21|728|157798|0|156898|900|63418|75594|14717|4069|0|       0|0.0361|80555|0.0294|15|73460|14|3783|0.0312|21
N|N0003|200106|LRYPRA|11|21|45|11239|0|11239|0|5040|5074|675|450|0|      -3|0.1347|2244|0.0408|19|8795|14|200|0.05|24
N|N0003|200106|LSHPRA|11|21|38|8884|0|8884|0|1777|4625|1100|1382|0|       0|0.1001|4602|0.0332|34|4282|29|||
N|N0003|200106|MAG|11|21|205|40664|100|40564|0|11519|19271|7942|1832|0|       0|0.034|18625|0.0561|21|21026|17|913|0.0264|46
N|N0003|200106|MAR|11|21|4566|852217|3439|847777|500|327186|338792|115285|64394|2620|       0|0.0336|371175|0.0377|23|376069|17|101033|0.0395|25
N|N0003|200106|MAT|11|21|6271|1269034|600|1265555|2400|804303|370087|74517|19048|0|       0|0.0286|536799|0.0232|12|603833|9|127323|0.0268|17
N|N0003|200106|MCC|11|21|92|15602|100|15502|0|3391|5930|2640|3441|100|       1|0.1551|10231|0.1351|48|3496|48|1775|0.1344|50
N|N0003|200106|MCO|11|21|2564|482050|300|481050|0|205260|224512|38524|12754|0|       0|0.0344|232157|0.0449|16|218413|12|30480|0.0506|21
N|N0003|200106|MCT|11|21|93|18905|300|18605|0|6170|8860|2500|1175|0|      -6|0.2168|10070|0.0931|22|7035|21|1500|0.0993|18
N|N0003|200106|MDG|11|21|222|44774|100|44574|100|18941|16881|6899|1953|0|      -2|0.0379|17024|0.0225|15|23758|15|3892|0.029|43
N|N0003|200106|MEE|11|21|1036|209709|1746|206463|1500|66383|99319|28763|13498|0|       0|0.0405|111328|0.0591|22|81354|18|15281|0.0622|27
N|N0003|200106|MEH|11|21|251|48319|0|48319|0|14334|23793|6423|3769|0|       2|0.0701|17902|0.0429|26|24568|19|5849|0.046|31
N|N0003|200106|MER|11|21|30073|6760165|79577|6655420|22100|3730194|2256343|498914|187021|5048|       0|0.0551|3050308|0.0476|13|1925818|9|1701394|0.066|19
N|N0003|200106|MERPRA|11|21|78|19057|0|19057|0|7062|8478|2817|700|0|       3|0.101|10546|0.0317|22|8411|15|100|0.02|24
N|N0003|200106|MERPRB|11|21|79|20512|0|20512|0|6773|11414|1925|400|0|       1|0.0985|12232|0.0367|16|7980|17|300|0.01|11
N|N0003|200106|MERPRC|11|21|75|18441|0|18441|0|4795|11057|1582|1007|0|       4|0.1103|11160|0.0386|24|7181|16|100|0.07|17
N|N0003|200106|MERPRD|11|21|180|50455|0|50455|0|18698|26565|3992|1200|0|       0|0.0677|28689|0.0208|17|21266|15|500|0.026|20
N|N0003|200106|MERPRE|11|21|91|24866|0|24866|0|7807|13364|1525|2170|0|       2|0.0673|17369|0.0194|23|7497|26|||
N|N0003|200106|MERPRF|11|21|254|64465|0|64465|0|22971|30739|8030|2725|0|       0|0.0566|35833|0.0187|19|27832|19|800|0.025|12
N|N0003|200106|MFW|11|21|32|7466|0|7466|0|2841|4113|512|0|0|      -2|0.0181|2029|0.0623|12|5437|14|||
N|N0003|200106|MGF|11|21|70|16120|0|16120|0|6543|8899|500|178|0|       0|0.0166|3887|0.0103|17|12233|12|||
N|N0003|200106|MHN|11|21|44|10018|0|10018|0|5361|3632|1025|0|0|       0|0.0315|3926|0.014|17|5792|10|300|0.0133|16
N|N0003|200106|MIM|11|21|7|1347|0|1347|0|275|672|200|200|0|      -8|0.1074|140|0.13|24|1207|26|||
N|N0003|200106|MLI|11|21|373|69963|100|69763|100|19462|27043|13949|9309|100|       0|0.0273|31833|0.0706|30|34350|30|3680|0.0433|50
N|N0003|200106|MLM|11|21|956|204799|300|204099|400|61064|95095|32619|15821|300|       0|0.0477|80241|0.0608|24|108917|20|15341|0.0475|23
N|N0003|200106|MLS|11|21|869|206055|0|205855|200|74780|98864|22395|10016|0|       0|0.065|79217|0.0297|20|113979|14|12859|0.0332|28
N|N0003|200106|MMA|11|21|164|41547|0|41347|200|6120|18982|11510|4935|0|       0|0.0759|18868|0.0622|31|22479|28|200|0.01|42
N|N0003|200106|MMC|11|21|7854|1504024|4800|1496324|2400|848935|524310|93936|31240|303|       0|0.0776|737970|0.0635|14|537240|9|223514|0.0759|16
N|N0003|200106|MMR|11|21|143|24452|0|24452|0|4408|14201|3524|2319|0|      -1|0.0584|10071|0.0532|24|13468|26|913|0.0605|21
N|N0003|200106|MMS|11|21|1627|318955|1900|315905|900|106853|137298|48809|23545|300|       1|0.0495|180240|0.06|24|113201|20|23364|0.0565|33
N|N0003|200106|MOT|11|21|15110|3328170|5844|3311576|8100|1598352|1234943|389062|96669|650|       0|0.0107|1631510|0.0236|17|1229766|10|458400|0.0247|21
N|N0003|200106|MOTPRA|11|21|193|54690|0|54690|0|19492|24106|8167|2925|0|       1|0.0898|30541|0.0284|23|23749|17|400|0.025|16
N|N0003|200106|MPPRD|11|21|9|1975|0|1975|0|300|775|900|0|0|       0|0.2923|1600|0.04|28|375|14|||
N|N0003|200106|MRX|11|21|1621|320344|8637|310782|200|63174|159322|56740|29946|1800|       1|0.0942|133022|0.0768|30|134927|24|43033|0.1141|30
N|N0003|200106|MSF|11|21|42|9509|0|9509|0|2112|6131|766|200|300|      -2|0.0626|3761|0.0423|15|5748|16|||
N|N0003|200106|MTN|11|21|145|22165|0|21965|200|4845|12736|2407|2177|0|       0|0.0896|11127|0.0907|28|10716|22|322|0.1|10
N|N0003|200106|MTTPRX|11|21|23|5969|0|5969|0|850|4879|240|0|0|       6|0.1935|3074|0.1643|18|2895|13|||
N|N0003|200106|MTX|11|21|764|141623|0|140313|0|59229|61833|11244|8007|0|       0|0.062|55775|0.0467|18|74506|17|10032|0.0553|28
N|N0003|200106|MUC|11|21|37|9273|0|9273|0|3762|3999|400|1112|0|      -1|0.0279|5611|0.0146|17|3262|42|400|0.01|6
N|N0003|200106|MUJ|11|21|36|8266|0|8266|0|3118|4948|200|0|0|       0|0.0292|4991|0.0126|15|3275|10|||
N|N0003|200106|MUO|11|21|47|10408|0|10408|0|2493|6074|1116|725|0|       0|0.0519|3863|0.0223|24|6345|13|200|0.06|140
N|N0003|200106|MYI|11|21|107|32319|0|32319|0|11642|14632|3472|2373|200|       0|0.0318|11728|0.0141|29|20291|17|300|0.01|18
N|N0003|200106|NAV|11|21|1165|207641|200|206594|300|100039|87977|14008|4870|0|       1|0.0271|94076|0.027|14|101550|12|11268|0.0438|17
N|N0003|200106|NC|11|21|422|70933|0|70933|0|24172|40012|5599|1150|0|       0|0.1476|27278|0.0952|18|37888|11|5767|0.0974|18
N|N0003|200106|NCI|11|21|165|36300|0|36300|0|12555|13153|5331|4291|970|       1|0.0448|13065|0.0375|23|21642|25|1593|0.0567|119
N|N0003|200106|NDE|11|21|1140|252703|3500|248903|200|62581|105339|52043|27991|1149|       1|0.0427|103869|0.041|28|124648|23|20586|0.0692|57
N|N0003|200106|NEU|11|21|2069|434722|5500|427622|500|148279|190275|58105|31463|0|       2|0.0733|193603|0.0723|25|172307|15|62212|0.0672|31
N|N0003|200106|NMA|11|21|57|13504|0|13504|0|2868|6470|2799|1367|0|       0|0.033|1804|0.0319|18|11350|29|350|0.01|41
N|N0003|200106|NMI|11|21|23|5888|0|5888|0|2227|2881|580|200|0|      -2|0.0667|4313|0.0145|18|1575|13|||
N|N0003|200106|NMK|11|21|1636|308307|100|307707|400|114811|128594|41825|22677|200|       0|0.0191|97748|0.016|23|190283|18|20076|0.0143|28
N|N0003|200106|NMKPRK|11|21|1|100|0|100|0|100|0|0|0|0|       5|0.75||||100|9|||
N|N0003|200106|NMT|11|21|21|5072|0|5072|0|507|4032|133|400|0|      -2|0.0602|2876|0.023|19|2196|23|||
N|N0003|200106|NPC|11|21|12|2425|0|2425|0|798|1627|0|0|0|      -1|0.0694|927|0.0578|14|1498|14|||
N|N0003|200106|NPV|11|21|36|8346|0|8346|0|2790|3706|1850|0|0|       3|0.0865|4223|0.0241|20|3823|17|300|0.01|13
N|N0003|200106|NQF|11|21|33|8197|0|8197|0|3319|3533|1145|0|200|       0|0.0506|4778|0.0118|32|3419|10|||
N|N0003|200106|NQS|11|21|50|13224|0|13224|0|3268|6571|3385|0|0|       0|0.0344|3655|0.0223|23|9235|17|334|0.04|32
N|N0003|200106|NSH|11|21|31|6351|0|6351|0|1216|4108|927|100|0|      -1|0.0711|3151|0.0624|19|3200|18|||
N|N0003|200106|NSI|11|21|989|206016|700|204916|400|81854|88750|26478|8134|100|       0|0.053|78530|0.0423|19|115118|14|11668|0.0455|29
N|N0003|200106|NTC|11|21|29|7856|0|7856|0|2683|4673|500|0|0|      -2|0.0692|5213|0.0129|16|2643|12|||
N|N0003|200106|NUT|11|21|24|5170|0|5170|0|713|3916|541|0|0|      -1|0.0767|3509|0.0365|19|1548|11|113|0.05|9
N|N0003|200106|NVN|11|21|60|17595|0|17595|0|3541|10820|1951|1283|0|       0|0.0528|6675|0.015|21|10105|23|815|0.0316|14
N|N0003|200106|OAT|11|21|3034|570965|4200|565465|1300|270878|204505|62275|28792|315|       0|0.0499|293935|0.0578|17|213478|13|59352|0.0588|21
N|N0003|200106|OCN|11|21|196|44482|122|44160|200|11948|15964|8555|7893|0|       1|0.0487|16847|0.0378|38|24518|33|2995|0.0362|41
N|N0003|200106|OECPRT|11|21|37|8598|0|8598|0|5028|2770|600|200|0|       8|0.3758|5885|0.0151|16|2713|9|||
N|N0003|200106|OFC|11|21|228|44336|0|44336|0|7456|16953|9168|10759|0|      -1|0.0313|17630|0.0546|51|22481|36|4225|0.0178|24
N|N0003|200106|OFCPRB|11|21|24|4268|0|4268|0|240|1775|1155|700|398|      -1|0.0926|2050|0.1197|37|2118|122|100|0.05|65
N|N0003|200106|OFCPRE|11|21|22|4805|0|4805|0|700|1725|1130|1150|100|       0|0.1068|2310|0.0747|57|2195|46|300|0.03|11
N|N0003|200106|OH|11|21|149|34617|140|34377|100|9919|17741|4045|2772|0|       0|0.0328|14906|0.0318|32|19248|18|323|0.0286|89
N|N0003|200106|OI|11|21|353|74739|0|74739|0|33123|30579|7601|3436|0|       0|0.0219|24529|0.0238|16|47287|16|2923|0.0227|21
N|N0003|200106|OIPRA|11|21|62|16193|100|16093|0|2270|6602|2439|4282|500|       1|0.1128|7247|0.0299|73|7547|45|1299|0.0585|54
N|N0003|200106|OMG|11|21|965|189051|1000|186551|0|54715|91492|27624|12720|0|       1|0.0607|70167|0.0623|23|97105|18|19279|0.0554|29
N|N0003|200106|OMI|11|21|565|107087|500|106087|300|26099|48534|18229|13525|0|       0|0.0552|41150|0.0578|29|56474|24|8763|0.0579|42
N|N0003|200106|ONE|11|21|10768|2557497|1921|2549239|4900|1590050|761410|159619|42657|403|       0|0.0277|1132248|0.0266|12|1085876|9|336015|0.0315|15
N|N0003|200106|ONEPRB|11|21|3|400|0|400|0|0|200|0|200|0|      55|2.3875|200|0.55|91|200|18|||
N|N0003|200106|ONEPRC|11|21|1|100|0|100|0|0|0|0|100|0|1.5|2|100|1|83|||||
N|N0003|200106|ONEPRT|11|21|109|29362|0|29362|0|13993|11061|3728|580|0|       0|0.0822|11554|0.0415|15|16908|15|900|0.0289|13
N|N0003|200106|ONEPRU|11|21|60|17827|0|17827|0|6895|7268|3264|400|0|       0|0.1008|7272|0.0373|19|10355|15|200|0.05|22
N|N0003|200106|ONEPRV|11|21|93|23722|0|23722|0|10722|12220|400|380|0|       2|0.0884|13172|0.031|12|9650|13|900|0.0311|19
N|N0003|200106|OSI|11|21|1058|248089|2075|245714|300|63505|109163|44599|28147|600|       0|0.0554|102160|0.0585|31|123370|21|20484|0.0677|33
N|N0003|200106|OTL|11|21|200|33973|0|33973|0|8320|18238|7115|300|0|       2|0.1038|11952|0.0549|18|17721|15|4300|0.2072|34
N|N0003|200106|OWC|11|21|426|97564|400|97164|0|51956|36885|6365|1958|0|       0|0.0286|25059|0.0166|13|64887|11|7218|0.0214|26
N|N0003|200106|PAG|11|21|182|38597|0|38597|0|14405|16254|5316|2622|0|       0|0.0262|13760|0.0177|24|24337|16|500|0.016|16
N|N0003|200106|PAR|11|21|38|8752|0|8752|0|2836|4398|1118|400|0|       0|0.0644|3723|0.049|17|4629|33|400|0.0425|17
N|N0003|200106|PAS|11|21|469|116739|596|115743|0|32186|50278|20265|12755|259|       0|0.0361|55329|0.0333|31|57869|26|2545|0.0876|29
N|N0003|200106|PCEPR|11|21|28|7237|0|7237|0|1438|3578|1621|600|0|       0|0.1203|2378|0.0377|23|4459|27|400|0.0825|15
N|N0003|200106|PCEPRA|11|21|67|19235|0|19235|0|4495|7684|3786|3070|200|       0|0.1339|6197|0.0854|34|12438|40|600|0.0767|103
N|N0003|200106|PCL|11|21|870|207041|0|205966|800|82550|84819|26006|12302|1289|       0|0.0518|79822|0.0285|32|112427|17|14517|0.0474|59
N|N0003|200106|PCT|11|21|41|10980|0|10980|0|1755|5233|2274|1718|0|      -2|0.1086|4575|0.0492|32|6405|31|||
N|N0003|200106|PDE|11|21|1349|311176|2700|307576|900|153759|109523|33382|11412|400|       0|0.0241|146622|0.0338|16|130255|11|31599|0.0309|23
N|N0003|200106|PECPRX|11|21|31|9116|0|9116|0|3045|5421|650|0|0|       8|0.253|6766|0.2323|14|2250|16|100|0.2|13
N|N0003|200106|PEP|11|21|17054|3961781|3610|3935924|19800|1877493|1559852|407217|111162|0|       0|0.0169|2074843|0.0276|16|1458336|12|422545|0.0302|20
N|N0003|200106|PER|11|21|681|147898|1311|146587|0|54071|50664|20863|20325|664|       0|0.0494|60502|0.0331|30|70966|23|15119|0.0414|37
N|N0003|200106|PFP|11|21|20|4346|0|4346|0|611|3014|223|498|0|       5|0.2408|2737|0.1043|23|1609|22|||
N|N0003|200106|PFPPR|11|21|8|1998|0|1998|0|456|1542|0|0|0|       2|0.3709|1060|0.1181|14|938|3|||
N|N0003|200106|PG|11|21|14631|3286058|7562|3265296|10900|1994720|980155|234132|65839|1200|       0|0.0383|1509114|0.0338|12|1185301|9|581781|0.0453|20
N|N0003|200106|PGF|11|21|13|3127|0|3127|0|400|2227|500|0|0|      -9|0.1322|200|0.1|37|2927|16|||
N|N0003|200106|PGN|11|21|4449|803192|1050|800855|1100|395029|308406|70143|26814|1563|       0|0.0442|356946|0.0318|16|362495|12|82514|0.0394|21
N|N0003|200106|PHA|11|21|11090|2625800|5054|2615898|2300|1194257|945635|349082|129224|0|       0|0.0269|1208326|0.0303|19|1030728|13|379144|0.0395|26
N|N0003|200106|PII|11|21|547|102532|100|102432|0|41394|47177|10024|3837|0|       1|0.0656|43817|0.0617|19|50009|14|8606|0.067|21
N|N0003|200106|PIK|11|21|20|3575|0|3575|0|200|1904|349|1122|0|      -2|0.048|2316|0.061|22|1092|112|167|0.02|177
N|N0003|200106|PIM|11|21|174|49075|0|49075|0|24946|18678|4419|1032|0|       0|0.0231|15250|0.0101|15|31123|13|2702|0.0172|21
N|N0003|200106|PIO|11|21|112|20834|0|20834|0|4049|12496|3547|742|0|      -4|0.1999|15381|0.3664|19|5353|24|100|0.03|57
N|N0003|200106|PKE|11|21|670|119484|100|119384|0|37310|62636|13909|5529|0|       0|0.0536|51032|0.0518|20|59311|16|9041|0.0835|42
N|N0003|200106|PKG|11|21|595|146975|435|146340|200|34426|54415|28787|26474|2438|       1|0.0363|71171|0.0341|45|66334|34|9035|0.0866|51
N|N0003|200106|PKX|11|21|711|142771|0|142226|200|41939|72365|20160|7962|0|       1|0.0222|67854|0.0374|22|71279|18|3293|0.0316|36
N|N0003|200106|PLP|11|21|84|20783|0|20783|0|6623|11908|1872|380|0|       0|0.0736|9234|0.0405|19|9569|14|1980|0.048|16
N|N0003|200106|PNP|11|21|360|77419|0|77419|0|21873|46990|6414|2142|0|       0|0.0584|39478|0.0455|17|35119|13|2822|0.0368|27
N|N0003|200106|PNW|11|21|2281|470049|2100|467443|400|193183|212965|42984|18311|400|       0|0.0449|244484|0.0442|17|188356|15|35003|0.0463|22
N|N0003|200106|PPD|11|21|1023|203099|1025|199574|2500|50324|81817|41329|28104|500|       0|0.0512|76073|0.06|40|105458|21|20543|0.056|41
N|N0003|200106|PPP|11|21|1071|218104|600|217504|0|90001|84657|30380|12466|0|       1|0.0533|86443|0.0541|21|107964|17|23097|0.0719|22
N|N0003|200106|PPPPRQ|11|21|8|1220|0|1220|0|0|340|750|130|0|    -100|1.2508|400|0.461|62|820|29|||
N|N0003|200106|PTV|11|21|2082|421537|524|420713|300|130636|203286|64391|22600|100|       0|0.0255|219254|0.0309|20|179782|19|21977|0.0307|20
N|N0003|200106|PX|11|21|4735|968093|4342|962551|400|391045|431840|105022|34611|433|       0|0.0323|517464|0.0384|17|360536|15|84951|0.0418|20
N|N0003|200106|RCL|11|21|888|192609|1279|191130|200|73260|79569|27645|10856|0|       0|0.0309|71595|0.0366|23|106888|15|12847|0.0291|21
N|N0003|200106|RCN|11|21|119|26769|0|26769|0|7428|11535|3395|4411|0|      -6|0.13|9038|0.0576|40|14081|20|3650|0.0453|33
N|N0003|200106|RG|11|21|357|70949|0|70949|0|19784|28138|8150|13587|1290|       0|0.0507|16009|0.0463|71|42135|29|12805|0.0254|64
N|N0003|200106|RHB|11|21|1366|256151|6400|249751|0|54702|103946|53430|37673|0|       0|0.1091|117310|0.0835|36|102790|26|29651|0.1028|46
N|N0003|200106|RHD|11|21|830|166190|100|165990|0|55871|81814|20848|7457|0|       1|0.0431|76146|0.0406|19|82195|17|7649|0.0406|25
N|N0003|200106|RHI|11|21|2239|438400|1243|436357|800|200230|165695|49195|21787|250|       0|0.0378|212536|0.0402|18|187120|13|37501|0.0493|32
N|N0003|200106|RJF|11|21|865|179628|1970|177558|100|59606|69661|26503|21888|0|       1|0.0605|84064|0.0491|26|80046|18|13548|0.063|43
N|N0003|200106|RL|11|21|883|188977|400|187027|1200|51875|75446|38251|22355|300|       1|0.0584|80017|0.0683|29|84714|25|23496|0.0661|31
N|N0003|200106|RMG|11|21|406|76807|0|76807|0|31060|36138|8459|1150|0|       0|0.0786|40447|0.0656|14|32940|14|3420|0.0411|29
N|N0003|200106|RML|11|21|302|65767|851|64916|0|15388|24785|9913|14430|400|       0|0.0323|25040|0.0345|54|36262|32|3614|0.036|68
N|N0003|200106|RNS|11|21|11|3105|0|3105|0|1535|1370|200|0|0|      -5|0.1214|2105|0.1211|11|1000|14|||
N|N0003|200106|ROP|11|21|637|119636|1400|118236|0|31245|46507|21949|17566|969|       2|0.0654|52276|0.0767|37|54041|26|11919|0.076|60
N|N0003|200106|ROS|11|21|42|8810|0|8810|0|5900|2210|500|200|0|      -1|0.0264|4960|0.0191|11|3850|15|||
N|N0003|200106|ROV|11|21|1256|280099|300|278999|800|121057|99650|39115|18932|1045|       1|0.0251|165982|0.0469|20|98628|16|15189|0.0513|69
N|N0003|200106|RS|11|21|364|74715|300|74415|0|17112|35972|16048|5283|0|       0|0.0486|37850|0.0445|24|31898|21|4667|0.0411|26
N|N0003|200106|RSC|11|21|163|35415|0|35415|0|8219|17055|6911|3230|0|      -1|0.1382|19992|0.0862|25|13593|24|1830|0.1025|40
N|N0003|200106|RTP|11|21|224|45752|200|45552|0|14891|21771|6917|1973|0|       0|0.4891|17391|0.1724|22|23561|14|4600|0.5028|31
N|N0003|200106|RWT|11|21|272|52267|0|52267|0|18388|19210|10069|4600|0|      -1|0.0721|25393|0.0563|23|24774|18|2100|0.0438|14
N|N0003|200106|RWTPRB|11|21|9|1638|0|1638|0|100|1288|100|150|0|      -8|0.0114|1239|0.599|39|399|13|||
N|N0003|200106|RYN|11|21|672|128546|700|127446|0|34511|58160|23802|10373|600|      -1|0.0552|52145|0.0532|29|64697|21|10604|0.0443|37
N|N0003|200106|RZT|11|21|212|44179|0|44079|100|16442|21497|5031|1209|0|       1|0.0511|18311|0.046|16|23659|13|2209|0.09|34
N|N0003|200106|SACPR|11|21|3|700|0|700|0|0|0|200|500|0|      17|1.1014||||700|86|||
N|N0003|200106|SACPRT|11|21|11|2493|0|2493|0|320|1463|300|410|0|       0|0.2151|413|0.1299|17|1980|41|100|0.1|16
N|N0003|200106|SAIPRW|11|21|70|17471|0|17471|0|9608|6338|1125|400|0|       1|0.0907|5971|0.0183|14|11400|15|100|0.03|7
N|N0003|200106|SBG|11|21|92|23981|0|23981|0|9947|6542|3638|3554|300|       0|0.0256|12268|0.0161|38|11713|39|||
N|N0003|200106|SC|11|21|804|171378|1200|169328|600|35189|66402|34353|32589|1295|       0|0.0425|67572|0.0423|115|82345|33|20011|0.0432|74
N|N0003|200106|SCG|11|21|813|174445|1450|172995|0|36451|63067|41038|31401|1038|       0|0.0434|73380|0.0352|39|85091|31|14524|0.0479|57
N|N0003|200106|SCL|11|21|28|4080|0|4080|0|797|977|1156|1007|143|       1|0.1141|1361|0.0648|33|2719|95|||
N|N0003|200106|SCX|11|21|19|5156|0|5156|0|1378|1806|500|1472|0|       1|0.1732|871|0.1332|41|4185|42|100|0.14|18
N|N0003|200106|SCZ|11|21|416|93540|0|93440|100|37105|43330|8965|4140|0|       0|0.0246|42050|0.032|19|49810|15|1680|0.0214|19
N|N0003|200106|SCZA|12|21|13|1667|270|1397|0|450|430|200|317|0|    -643|6.7545|317|1|165|1080|17|||
N|N0003|200106|SDH|11|21|187|41816|0|41816|0|18699|18351|3596|1170|0|       0|0.0167|12656|0.0124|16|28810|12|350|0.0243|60
N|N0003|200106|SGH|11|21|24|6168|0|6168|0|1085|2758|1200|1125|0|      -3|0.1265|2783|0.0408|37|3000|41|385|0.033|9
N|N0003|200106|SGI|11|21|340|72667|350|72017|300|24900|32188|9337|5892|0|       0|0.013|22488|0.0123|20|46559|19|3270|0.0143|58
N|N0003|200106|SGR|11|21|6170|1299132|35974|1259458|2700|574617|455207|144340|85394|2700|       3|0.0949|654440|0.1078|20|422851|13|184867|0.1534|37
N|N0003|200106|SGU|11|21|421|102190|475|101715|0|24400|44647|16278|15490|900|       0|0.0787|50870|0.0602|40|46623|28|4222|0.0301|56
N|N0003|200106|SII|11|21|12161|2461601|89352|2366784|2800|708230|989797|446578|224144|835|       0|0.1034|1098122|0.0831|23|658194|17|613268|0.1146|34
N|N0003|200106|SLC|11|21|462|102521|0|102521|0|31777|51814|14017|4913|0|      -2|0.0498|39662|0.0221|22|51426|15|11433|0.021|27
N|N0003|200106|SLI|11|21|223|40617|418|39999|200|9667|16424|8563|5445|100|       0|0.0584|15844|0.0585|43|20722|21|3633|0.0345|53
N|N0003|200106|SO|11|21|7112|1830209|2000|1815354|11800|580083|787613|325490|133214|754|       0|0.0234|654768|0.0233|25|930696|18|241690|0.0333|29
N|N0003|200106|SOPRA|11|21|65|16715|0|16715|0|3470|8827|1949|2469|0|       0|0.0665|4028|0.0293|35|11087|27|1600|0.0338|30
N|N0003|200106|SOPRB|11|21|65|17925|0|17925|0|5235|6861|2834|2995|0|       1|0.0985|10104|0.042|50|7421|23|400|0.0375|42
N|N0003|200106|SOPRC|11|21|62|16462|0|16462|0|2966|8671|3400|1425|0|       0|0.0901|6935|0.0333|27|8927|25|600|0.0367|33
N|N0003|200106|SP|11|21|2259|417878|20700|395978|1000|88276|173307|84940|49425|1030|       2|0.2098|199842|0.171|26|116566|21|80570|0.2007|41
N|N0003|200106|SPN|11|21|400|100444|325|100119|0|31571|45383|12267|10898|0|       1|0.0288|43292|0.0424|30|56427|21|400|0.015|91
N|N0003|200106|SPP|11|21|229|51056|0|50756|300|10669|25951|9287|5149|0|       0|0.0357|20559|0.0263|30|27662|21|2835|0.0104|42
N|N0003|200106|SRE|11|21|4174|776656|470|775086|1100|536186|219314|17703|2755|228|       0|0.0319|347116|0.0326|9|370017|8|59053|0.036|11
N|N0003|200106|SREPRA|11|21|101|28661|0|28661|0|5688|17888|3435|1650|0|       5|0.1707|17662|0.1052|21|10199|21|800|0.075|20
N|N0003|200106|SSD|11|21|206|35844|500|35344|0|9983|16926|5118|3317|0|       0|0.1372|17605|0.1104|33|13239|17|4500|0.1138|32
N|N0003|200106|SSR|11|21|75|19430|0|19430|0|3254|10127|4436|1013|600|       0|0.0911|7555|0.0238|45|11475|28|400|0.035|22
N|N0003|200106|STZ|11|21|1619|339807|2000|337207|600|85800|149849|59664|42094|400|       2|0.0667|138641|0.0823|34|166570|25|32596|0.0947|42
N|N0003|200106|STZB|12|21|2|624|0|624|0|0|0|0|624|0|       3|2.1795||||400|153|224|0.25|294
N|N0003|200106|SUR|11|21|181|31393|0|31393|0|11609|15609|2915|1260|0|       0|0.0639|12522|0.0329|17|17749|15|1122|0.04|22
N|N0003|200106|SUT|11|21|236|35284|0|35084|0|12819|18577|3588|100|0|       0|0.0223|16575|0.0263|15|17409|13|1100|0.0291|14
N|N0003|200106|SUTPRA|11|21|47|10131|0|10131|0|1975|6048|2008|100|0|       3|0.1397|5027|0.083|25|5104|15|||
N|N0003|200106|SVAPR|11|21|12|3315|0|3315|0|200|1775|1340|0|0|       0|0.1859|1185|0.0888|22|1930|29|200|0.05|13
N|N0003|200106|SWM|11|21|126|25116|100|25016|0|8271|12267|3269|1209|0|       0|0.0897|9365|0.0636|26|13651|16|2000|0.075|24
N|N0003|200106|SZ|11|21|12|2987|0|2987|0|0|1937|900|150|0|       0|0.0453|500|0.03|30|2487|36|||
N|N0003|200106|TAPPRA|11|21|151|40656|0|40656|0|9089|25026|6266|275|0|       1|0.0587|14590|0.0156|21|25766|17|300|0.03|15
N|N0003|200106|TAPPRB|11|21|23|5637|0|5637|0|628|4379|630|0|0|       0|0.112|4215|0.0363|18|1222|10|200|0.04|11
N|N0003|200106|TCC|11|21|160|33038|0|32738|300|5154|13144|8508|6232|0|       0|0.0487|15161|0.0428|44|15526|27|2351|0.0516|33
N|N0003|200106|TCH|11|21|46|10532|0|10532|0|1828|7022|700|982|0|      -1|0.0697|2692|0.0298|26|7640|21|200|0.05|0
N|N0003|200106|TCLPR|11|21|23|6611|0|6611|0|2911|3700|0|0|0|      -3|0.1033|1800|0.0339|16|4811|11|||
N|N0003|200106|TCR|11|21|254|64034|0|64034|0|13892|25318|11708|12916|200|      -1|0.0366|20925|0.0261|44|38017|34|5092|0.0244|58
N|N0003|200106|TD|11|21|444|84704|200|84504|0|26904|43499|9309|4792|0|       0|0.0518|30355|0.0191|20|40045|14|14104|0.0498|25
N|N0003|200106|TDI|11|21|22|5012|0|5012|0|850|2266|1175|721|0|       0|0.177|2011|0.0975|46|3001|24|||
N|N0003|200106|TDR|11|21|26|4930|0|4930|0|160|4120|450|200|0|      -3|0.1429|3070|0.0602|24|1860|18|||
N|N0003|200106|TDY|11|21|602|111666|327|111339|0|39645|56089|11267|4338|0|       1|0.0325|46693|0.0382|21|60096|14|4550|0.0372|18
N|N0003|200106|TEE|11|21|387|93634|194|93440|0|38091|39954|10290|5205|0|       0|0.0979|55764|0.0522|17|33575|17|4101|0.0442|24
N|N0003|200106|TEF|11|21|1902|396187|0|395605|100|185332|137753|47922|24698|0|       1|0.0489|199060|0.031|21|167710|14|28935|0.0439|27
N|N0003|200106|TEM|11|21|5|975|0|975|0|375|200|400|0|0|       0|0.2467|300|0.1167|11|675|25|||
N|N0003|200106|TEN|11|21|340|70065|0|70065|0|20950|30885|10353|7877|0|       0|0.0338|26121|0.0405|24|39987|23|3957|0.0298|12
N|N0003|200106|TFS|11|21|769|145212|800|143612|800|41861|68860|23910|9781|0|       1|0.0531|57459|0.0478|23|76318|19|10635|0.0542|23
N|N0003|200106|TGT|11|21|13947|3240598|7313|3215448|13900|1249034|1213942|478651|281570|6151|       0|0.0267|1754183|0.0402|22|1020458|16|454707|0.0506|33
N|N0003|200106|THX|11|21|702|138946|400|137546|600|38790|53171|27131|18274|780|       0|0.0806|45773|0.104|35|75898|24|16475|0.1466|48
N|N0003|200106|TI|11|21|314|58047|100|57847|100|5609|27586|14591|9798|363|      -4|0.3006|31788|0.331|46|23256|24|2903|0.1905|36
N|N0003|200106|TIA|12|23|1|3300|2600|700|0|0|0|0|700|0|    -105|2.68||||700|208|||
N|N0003|200106|TLI|11|21|70|18393|0|18393|0|5914|7198|3215|2066|0|       0|0.0413|4007|0.0171|38|13686|23|700|0.0357|23
N|N0003|200106|TLK|11|21|37|9060|0|9060|0|1072|5706|1383|899|0|       0|0.0239|6138|0.0201|21|2922|33|||
N|N0003|200106|TOL|11|21|1670|345725|1300|343187|300|106434|153897|54404|28752|0|       0|0.0455|141820|0.0581|27|171803|19|29864|0.0657|25
N|N0003|200106|TR|11|21|913|189915|1800|188115|0|37995|79907|42395|26708|1110|       0|0.0758|79587|0.0422|37|92597|28|15931|0.1202|54
N|N0003|200106|TRA|11|21|304|53919|100|53619|200|18468|22849|10610|1892|200|       0|0.0187|18222|0.0285|24|34022|21|1575|0.0225|27
N|N0003|200106|TRP|11|21|180|40568|300|39968|300|18516|17508|3049|1195|0|       0|0.0269|17545|0.0144|14|22113|14|610|0.0166|13
N|N0003|200106|TRPPR|11|21|65|18352|0|18352|0|6762|8990|2100|500|0|      -5|0.0513|8625|0.0222|22|9527|12|200|0.03|10
N|N0003|200106|TRPPRC|11|21|25|6352|0|6352|0|3210|2942|200|0|0|       0|0.0643|2510|0.0303|14|3842|11|||
N|N0003|200106|TTR|11|21|23|6839|0|6839|0|4785|1668|386|0|0|      -4|0.0552|1506|0.0338|10|5333|9|||
N|N0003|200106|TWE|11|21|558|116045|212|115233|600|36782|50391|20674|7986|0|      -2|0.0223|38403|0.0222|28|69540|19|7890|0.0292|31
N|N0003|200106|TWK|11|21|339|62550|426|62124|0|17218|21312|10709|12585|300|       0|0.0307|32607|0.0461|34|27617|38|1900|0.0442|41
N|N0003|200106|TX|11|21|10843|2376297|9060|2363465|2500|1397168|761431|163587|43779|0|       0|0.0354|1075238|0.0369|12|866775|10|423952|0.0385|15
N|N0003|200106|TXCPRA|11|21|138|35819|0|35819|0|20100|13164|1840|615|100|       0|0.0725|12355|0.0141|13|22764|13|700|0.0557|15
N|N0003|200106|TXCPRB|11|21|33|7489|0|7489|0|2855|3884|600|150|0|       5|0.1246|3550|0.0445|12|3739|19|200|0.01|22
N|N0003|200106|TXN|11|21|32718|7538253|101229|7394161|34500|2539737|2403485|1376649|1086906|21884|       0|0.0401|3888049|0.0556|27|1778802|21|1761810|0.066|43
N|N0003|200106|UIS|11|21|3976|863380|300|860260|2600|520238|271865|59247|11158|352|       0|0.0169|410722|0.0227|12|392168|9|59970|0.0259|19
N|N0003|200106|VAP|11|21|25|5620|0|5620|0|1085|2560|500|1475|0|       0|0.0888|4035|0.0313|40|1485|25|100|0.02|11
N|N0003|200106|VBF|11|21|88|20011|0|20011|0|4270|7857|4087|3597|200|      -2|0.0668|10578|0.0362|41|9233|30|200|0.02|320
N|N0003|200106|VEA|11|21|61|17329|0|17329|0|5199|9135|2195|800|0|       1|0.0988|8620|0.0473|19|8309|17|400|0.04|15
N|N0003|200106|VELPRT|11|21|40|9565|0|9565|0|3225|5640|600|100|0|      -1|0.1207|5245|0.0358|15|4020|10|300|0.07|21
N|N0003|200106|VGM|11|21|26|5974|0|5974|0|2694|2750|530|0|0|       0|0.0349|3386|0.0109|14|2588|12|||
N|N0003|200106|VGR|11|21|505|95521|600|94921|0|26817|43606|15460|8788|250|       4|0.1196|39410|0.111|32|46153|19|9358|0.0972|28
N|N0003|200106|VIG|11|21|10|2057|0|2057|0|389|1668|0|0|0|       0|0.0391|800|0.0125|10|1157|10|100|0.01|13
N|N0003|200106|VIN|11|21|31|6807|0|6807|0|2456|1434|892|2025|0|       0|0.0312|2010|0.013|41|4797|48|||
N|N0003|200106|VIT|11|21|48|12624|0|12624|0|7444|4875|305|0|0|       0|0.0359|6412|0.0114|11|5887|8|325|0.01|8
N|N0003|200106|VNV|11|21|7|2270|0|2270|0|780|1190|300|0|0|       0|0.0457|538|0.01|26|1732|10|||
N|N0003|200106|VOD|11|21|7053|1514065|2700|1506152|4300|792257|578419|118150|21426|200|       0|0.0158|842187|0.0218|14|579386|10|88879|0.0263|17
N|N0003|200106|VOL|11|21|102|20551|0|20551|0|5757|10161|2999|1534|100|       0|0.0808|10322|0.0528|27|8844|20|1385|0.0453|26
N|N0003|200106|VOT|11|21|23|6573|0|6573|0|2658|3686|229|0|0|       0|0.0539|2850|0.0175|15|2968|10|755|0.01|23
N|N0003|200106|VPA|11|21|33|9050|0|9050|0|1907|5339|1300|504|0|       0|0.0632|5957|0.0343|22|3093|18|||
N|N0003|200106|VPQ|11|21|33|8868|0|8868|0|2747|4560|686|875|0|       0|0.0517|3903|0.0212|19|4965|23|||
N|N0003|200106|VRC|11|21|3288|721772|1186|719800|600|264831|294864|105814|54891|0|       0|0.045|286261|0.0307|21|317784|20|116355|0.0471|28
N|N0003|200106|VSH|11|21|2045|439313|1600|434513|3200|160494|181677|67281|28161|100|       0|0.0236|201249|0.0324|22|186762|16|49702|0.0348|26
N|N0003|200106|VVC|11|21|766|178642|300|178342|0|45864|72830|35634|23102|912|       0|0.0386|69059|0.0436|36|101042|24|8241|0.0549|69
N|N0003|200106|VVR|11|21|328|83284|0|83284|0|28751|37822|13076|3635|0|       0|0.013|15688|0.0125|22|66309|18|1287|0.01|29
N|N0003|200106|WFR|11|21|248|55333|0|55133|200|19295|21918|7154|6214|752|       0|0.0502|20319|0.0448|40|31596|17|3418|0.0496|22
N|N0003|200106|WG|11|21|177|43323|200|43123|0|7887|16391|10247|8498|100|       0|0.0786|26932|0.0573|40|12256|37|3935|0.0413|33
N|N0003|200106|WLP|11|21|3166|613165|3600|607565|1800|224212|285602|70528|28442|581|       1|0.0537|307476|0.0591|19|225772|15|76117|0.0715|21
N|N0003|200106|WNI|11|21|6|620|0|620|0|100|320|200|0|0|       0|0.0194|420|0.0333|11|200|39|||
N|N0003|200106|WSM|11|21|1521|335089|7400|327689|0|107654|147769|43968|28298|0|       1|0.0431|146297|0.0509|24|138437|17|42955|0.0611|38
N|N0003|200106|WTS|11|21|134|25867|0|25867|0|9094|10894|4105|1774|0|       1|0.0725|13047|0.0591|24|12620|23|200|0.01|8
N|N0003|200106|XRX|11|21|6165|1563755|1500|1551990|9300|899430|518310|111272|32278|0|       0|0.0141|589903|0.0185|14|835374|9|136013|0.0244|21
N|N0003|200106|XVF|11|21|284|63667|300|63367|0|20329|30220|10193|2625|0|      -3|0.2107|36209|0.0865|21|24028|17|3130|0.1246|6
N|N0003|200106|YLD|11|21|49|13280|0|13280|0|5464|4515|2276|1025|0|       0|0.0193|3096|0.0162|19|9884|23|300|0.01|7
N|N0003|200106|YUM|11|21|3481|681270|15304|663764|1800|124966|222082|150777|158519|9220|       0|0.025|322286|0.0381|48|259741|38|83537|0.0503|67
N|N0003|200106|ZIF|11|21|45|9335|0|9335|0|3943|4592|700|100|0|      -1|0.0384|4741|0.018|12|4594|17|||
N|N0003|200106|ZMX|11|21|13|2620|0|2620|0|0|1999|353|268|0|      -2|0.0335|1979|0.0469|24|641|47|||'

TEST 06 'multibyte delimiter'

	EXPORT LC_ALL=en_US.UTF-8

	EXEC -t'€' -k 4,4 -lsum,op=sum:integer:7 $data/euro.dat
		OUTPUT - $'N€N0003€200106€AA€11€21€86407€3524300€9331€3494983€15500€1129332€1283396€639798€452298€5659€0.0021€0.0289€1717663€0.038€30€1195358€20€597462€0.0481€35
N€N0003€200106€AAT€11€21€455€14046€0€14046€0€7421€4549€1485€591€0€0.0314€0.0304€2513€0.01€25€11333€14€200€0.01€90
N€N0003€200106€ABJ€11€21€207€14508€0€14508€0€2603€9175€1650€1080€0€0.0756€0.0779€6636€0.0136€17€7872€25€€€
N€N0003€200106€ABS€11€21€40667€1465605€200€1461410€2900€483622€651665€241738€87165€120€0.0097€0.0284€599869€0.0306€22€670152€18€194289€0.0373€25
N€N0003€200106€ABT€11€21€100005€3368858€8904€3347422€10900€1469987€1273455€447558€166267€1055€0.0041€0.0273€1682138€0.0365€18€1150749€14€525435€0.044€25
N€N0003€200106€ACA€11€21€185€11490€0€11490€0€2845€7495€100€1050€0€0.0908€0.0946€5052€0.0146€17€6438€22€€€
N€N0003€200106€ACS€11€21€23220€523323€13500€509523€0€192518€202103€71973€42229€700€-0.0264€0.0658€254514€0.0654€21€177869€17€77140€0.0915€38
N€N0003€200106€AEF€11€21€1167€61757€0€61757€0€9524€22881€15536€13616€200€0.0418€0.0464€24867€0.0137€47€35248€43€1642€0.0401€27
N€N0003€200106€AET€11€21€20996€472785€900€471531€300€213068€162069€63465€32949€280€0.0069€0.0217€214120€0.0315€22€224763€16€32948€0.035€26
N€N0003€200106€AGC€11€21€43706€1443428€2747€1438956€1000€588445€574302€188125€88940€0€0.0076€0.0283€603123€0.0256€22€661220€16€175613€0.0329€31
N€N0003€200106€AGCPRA€11€21€315€16339€0€16339€0€3810€5914€4990€1625€0€0.1073€0.1187€7461€0.11€44€8678€25€200€0.085€8
N€N0003€200106€AGCPRB€11€21€293€6853€0€6853€0€100€3855€1550€1348€0€0.1382€0.115€3097€0.0587€44€3756€46€€€
N€N0003€200106€AGCPRM€11€21€360€15702€100€15602€0€1685€7911€3046€2170€790€0.0762€0.0876€4071€0.0247€64€11031€65€500€0.078€166
N€N0003€200106€AGCPRMCL€11€21€30€1223€0€1223€0€0€923€300€0€0€0.04€0.04€1223€0.01€22€€€€€
N€N0003€200106€AGCPRN€11€21€262€18338€0€18338€0€5186€8423€2223€2306€200€0.0895€0.0967€2885€0.0334€65€15203€23€250€0.046€21
N€N0003€200106€AGCPRNCL€11€21€21€665€0€665€0€100€565€0€0€0€0.01€0.01€€€€665€21€€€
N€N0003€200106€AGI€11€21€268€4879€0€4879€0€730€2761€1388€0€0€0.0154€0.0238€4099€0.0433€19€780€29€€€
N€N0003€200106€AHO€11€21€5492€101764€100€101464€200€25120€56355€13898€6291€0€0.0582€0.061€51772€0.043€22€43731€19€6161€0.0371€23
N€N0003€200106€AIV€11€21€10308€143764€0€143464€0€58036€56027€19187€10214€0€0.0376€0.0629€54117€0.0484€20€80319€20€9028€0.0438€29
N€N0003€200106€AIVPRC€11€21€187€5998€0€5998€0€2025€2725€948€300€0€0.1019€0.1098€2675€0.0259€25€3023€15€300€0.09€37
N€N0003€200106€AIVPRD€11€21€350€15180€0€15180€0€5430€8025€825€900€0€0.1032€0.1226€6105€0.0322€15€8975€24€100€0.04€12
N€N0003€200106€AIVPRG€11€21€340€12295€0€12295€0€3195€6435€1315€1350€0€0.084€0.0783€3675€0.0122€30€7920€24€700€0.0343€32
N€N0003€200106€AIVPRH€11€21€141€5959€0€5959€0€2100€3074€785€0€0€0.075€0.1345€2824€0.0322€13€3035€18€100€0.11€9
N€N0003€200106€AIVPRK€11€21€48€2070€0€2070€0€0€1070€600€400€0€0.2686€0.4413€1350€0.1863€48€720€20€€€
N€N0003€200106€AIVPRP€11€21€220€11916€0€11916€0€3681€4873€2148€1214€0€0.1826€0.2129€3376€0.0379€23€8540€26€€€
N€N0003€200106€AIVPRQ€11€21€373€10242€0€10242€0€3898€5497€327€520€0€0.0807€0.0792€4613€0.0174€19€5629€13€€€
N€N0003€200106€AJG€11€21€14874€196649€600€196049€0€80999€79015€21230€12954€1851€0.0292€0.0426€79215€0.0366€26€106810€13€10024€0.0518€45
N€N0003€200106€ALM€11€21€1560€9137€0€9137€0€300€7876€961€0€0€0.0497€0.0618€7139€0.0245€19€1998€15€€€
N€N0003€200106€ALPPRN€11€21€11€1290€0€1290€0€0€890€400€0€0€0€0.181€400€0.05€16€890€21€€€
N€N0003€200106€ALPPRO€11€21€22€1700€0€1700€0€0€1700€0€0€0€0.0159€0.2247€950€0.0621€26€750€18€€€
N€N0003€200106€ALPPRQ€11€21€118€7400€0€7400€0€2517€4483€400€0€0€0.0703€0.0795€3496€0.0287€17€3904€11€€€
N€N0003€200106€ALPPRR€11€21€192€12186€0€12186€0€2223€8511€1152€300€0€0.0695€0.0713€4546€0.0179€18€7540€15€100€0.04€63
N€N0003€200106€ALQ€11€21€319€14947€0€14947€0€5706€7091€2050€100€0€0.088€0.0864€8607€0.0231€21€6040€12€300€0.01€7
N€N0003€200106€ALZ€11€21€172€10019€0€10019€0€800€8563€656€0€0€0.0994€0.1095€6749€0.0256€19€3270€13€€€
N€N0003€200106€AMB€11€21€9284€82057€0€81694€0€49345€26444€3944€1961€0€0.0218€0.029€37759€0.0248€12€40635€11€3300€0.0224€15
N€N0003€200106€AMBPRA€11€21€112€5460€0€5460€0€3560€1700€200€0€0€0.0574€0.1091€3300€0.0473€10€2160€13€€€
N€N0003€200106€AMD€11€21€158595€4782471€105767€4655665€17300€1343670€1809871€952933€564656€1635€-0.01€0.0399€2160554€0.0464€24€1180503€21€1331908€0.0601€37
N€N0003€200106€ANN€11€21€14864€308613€7500€301013€100€160173€110558€25319€5063€0€-0.0095€0.0525€131184€0.0608€13€134861€10€35068€0.0762€17
N€N0003€200106€AOC€11€21€31694€740421€1545€737685€900€213132€304297€146622€73959€575€0.0001€0.0241€340231€0.0367€28€337678€21€60676€0.0378€34
N€N0003€200106€ARB€11€21€7383€81559€300€81259€0€24043€40724€12568€3924€0€0.0259€0.0549€39589€0.0546€22€36715€18€4955€0.0477€23
N€N0003€200106€ARH€11€21€158€1815€0€1815€0€400€1115€100€200€0€0.0357€0.0527€1190€0.0182€31€625€19€€€
N€N0003€200106€ATI€11€21€13450€204221€195€204026€0€95949€86063€15394€6520€100€0.011€0.0249€88367€0.0285€16€109155€13€6504€0.0249€20
N€N0003€200106€AVP€11€21€39557€1025278€1664€1021714€1300€640871€320330€47980€12801€1032€-0.0027€0.0305€463631€0.0358€10€466899€8€92484€0.0454€15
N€N0003€200106€AVZ€11€21€4359€42999€0€42899€100€15985€19543€6471€1000€0€0.1208€0.1957€20702€0.1167€19€19355€14€2942€0.0663€19
N€N0003€200106€AXL€11€21€2761€43442€0€43442€0€11343€20974€6885€4240€0€0.0524€0.0834€21281€0.0732€30€20822€22€1339€0.0249€14
N€N0003€200106€AZA€11€21€72083€777156€5600€770456€500€475253€227074€51985€16512€132€0.0081€0.0359€346051€0.0248€11€287853€9€137052€0.035€17
N€N0003€200106€AZZ€11€21€999€30688€0€30688€0€5454€17696€5938€1600€0€0.0621€0.0925€17081€0.0713€24€12107€24€1500€0.0293€20
N€N0003€200106€BC€11€21€21176€347438€2150€344388€900€119326€140853€55052€29034€1023€0.0049€0.0287€151059€0.0335€27€165409€19€28820€0.0421€28
N€N0003€200106€BCC€11€21€29620€232534€1500€231034€0€90880€102617€27338€10199€0€0.0026€0.0495€86498€0.0425€21€123377€15€21159€0.0489€20
N€N0003€200106€BD€11€21€3387€26224€200€26024€0€8210€15964€1850€0€0€0.0081€0.0147€10370€0.0141€12€14654€13€1000€0.014€21
N€N0003€200106€BDF€11€21€207€9620€0€9620€0€3229€4243€1738€410€0€0.0458€0.0565€2903€0.0136€13€6717€23€€€
N€N0003€200106€BGG€11€21€9151€164711€600€163823€0€76597€68590€14556€4080€0€0.0223€0.0874€65955€0.0439€16€85847€11€12021€0.0977€21
N€N0003€200106€BGT€11€21€550€15473€0€15473€0€8014€5024€1985€450€0€0.015€0.0185€3385€0.01€10€12088€14€€€
N€N0003€200106€BK€11€21€97952€3340606€5800€3332030€800€2109454€974660€195186€53530€0€-0.0055€0.0372€1548826€0.0305€11€1273475€9€510529€0.0417€16
N€N0003€200106€BKE€11€21€1805€18544€0€18544€0€3788€12093€2226€437€0€0.0169€0.0528€10301€0.0694€18€7843€20€400€0.035€15
N€N0003€200106€BKPRC€11€21€318€17897€0€17897€0€10855€5842€850€350€0€0.0804€0.0857€8767€0.0274€15€8630€11€500€0.028€7
N€N0003€200106€BKPRD€11€21€394€21826€0€21826€0€13055€7571€500€700€0€0.0658€0.0714€10371€0.0168€11€11155€14€300€0.08€18
N€N0003€200106€BKPRE€11€21€300€23243€0€23243€0€10876€10497€1470€400€0€0.076€0.0832€15715€0.0205€15€7528€12€€€
N€N0003€200106€BLI€11€21€10972€227952€1609€226143€100€75627€104943€33926€11747€0€0.0094€0.0263€112032€0.0332€20€104908€17€9303€0.0328€22
N€N0003€200106€BNI€11€21€50514€1206018€400€1203328€1600€680896€414696€85020€23178€1138€0.0049€0.0285€588392€0.0262€13€511908€10€104628€0.0403€19
N€N0003€200106€BR€11€21€64359€1378982€4900€1370416€2000€687207€493400€131614€58722€1473€0.0112€0.0302€782525€0.0406€16€459377€12€130514€0.0503€29
N€N0003€200106€BRG€11€21€881€11360€0€11360€0€2143€6614€1791€812€0€0.1021€0.1699€6410€0.118€29€4850€22€100€0.1€63
N€N0003€200106€BSP€11€21€268€4791€0€4791€0€1745€2537€509€0€0€0.0816€0.0835€2054€0.0143€14€2337€15€400€0.045€9
N€N0003€200106€BTY€11€21€10559€203914€400€203314€200€78459€82586€27485€14884€100€0.0731€0.1174€111376€0.0744€24€78300€16€13838€0.0657€24
N€N0002€200106€BTYRT€11€21€1262€50506€0€50506€0€19517€24313€3320€3356€0€0.1058€0.1598€32175€0.1498€23€17731€14€600€0.055€20
N€N0003€200106€BWG€11€21€661€6512€0€6512€0€1183€4379€650€300€0€0.0722€0.1734€4366€0.0936€24€2046€21€100€0.08€0
N€N0003€200106€BXS€11€21€4251€33939€0€33939€0€14334€13818€5063€724€0€-0.002€0.0378€17439€0.042€14€15418€17€1082€0.0204€22
N€N0003€200106€BYD€11€21€3086€35218€200€35018€0€8011€13121€6471€7115€300€0.0349€0.0426€12541€0.0321€37€19449€44€3028€0.0338€50
N€N0003€200106€BZL€11€21€147€2330€0€2330€0€1000€400€530€400€0€0.0741€0.0748€1130€0.04€53€800€8€400€0.02€7
N€N0003€200106€C€11€21€212024€7798662€31303€7747379€16900€3563357€2481386€1113981€603003€2552€0.0063€0.0228€4246991€0.0389€19€2228824€15€1288464€0.0463€33
N€N0003€200106€CBM€11€21€9318€194272€2240€191632€0€63286€89872€27044€11430€0€0.0026€0.1101€81401€0.0814€22€85841€16€24390€0.132€30
N€N0003€200106€CCC€11€21€3351€43832€300€43532€0€9359€19019€8257€6297€600€0.0433€0.0488€20746€0.0443€44€20283€29€2503€0.0202€39
N€N0003€200106€CCPPRA€11€21€157€13025€0€13025€0€2350€7424€2707€544€0€0.1786€0.3285€5751€0.0625€18€6774€26€500€0.058€17
N€N0003€200106€CCR€11€21€38403€728090€6800€719678€1000€267653€271128€122720€59077€100€-0.0069€0.0301€346880€0.0381€22€277870€18€95928€0.0488€30
N€N0003€200106€CEA€11€21€90€2229€0€2229€0€300€1601€328€0€0€0.0891€0.1549€928€0.031€17€1201€16€100€0.01€16
N€N0003€200106€CED€11€21€7490€25925€300€25625€0€5812€12625€5838€1350€0€0.1071€0.108€13523€0.0484€25€10252€19€1850€0.043€36
N€N0003€200106€CEM€11€21€3300€30385€0€30385€0€6560€16100€6125€1600€0€0.0332€0.0917€15567€0.0682€23€13468€23€1350€0.0337€30
N€N0003€200106€CEN€11€21€9359€110436€0€110236€200€45363€46318€11486€6969€300€0.0197€0.0306€50010€0.0344€21€55025€14€5401€0.0262€38
N€N0003€200106€CF€11€21€27038€639764€3248€634316€1500€182374€248718€123189€77927€3608€0.01€0.0254€286515€0.033€30€282454€22€66847€0.0282€49
N€N0003€200106€CFE€11€21€98€1684€0€1684€0€1300€100€284€0€0€0.1609€0.1669€984€0.25€18€700€8€€€
N€N0003€200106€CFN€11€21€122€4234€0€4234€0€1018€1116€1300€800€0€0.0738€0.0828€1200€0.3967€71€3034€26€€€
N€N0003€200106€CGPPRG€12€21€2684€5400€4900€500€0€0€100€200€200€0€-1.076€0.184€200€0.75€80€300€33€€€
N€N0003€200106€CGPPRI€11€21€2481€750€0€750€0€0€200€0€400€150€-0.6333€0.026€550€0.7182€511€200€23€€€
N€N0003€200106€CGPPRT€11€21€406€9711€0€9711€0€3766€4598€1147€200€0€0.0709€0.0734€2517€0.0372€15€7042€15€152€0.01€24
N€N0003€200106€CHD€11€21€9848€132464€1359€131105€0€52672€55896€14149€7853€535€0.0327€0.0634€55486€0.0467€19€68291€17€7328€0.0501€27
N€N0003€200106€CHH€11€21€3983€54062€0€53762€0€17816€21767€9596€4583€0€0.0255€0.0552€26188€0.0734€31€23562€16€4012€0.0527€16
N€N0002€200106€CHTRT€11€21€77€3174€0€3174€0€160€0€320€2375€319€0.0599€0.0609€1735€0.0113€116€1439€198€€€
N€N0002€200106€CHTRTWI€12€24€26€5000€0€5000€0€0€0€5000€0€0€-0.02€0.04€€€€5000€31€€€
N€N0003€200106€CIC€11€21€907€49613€0€49613€0€12025€25301€7518€4769€0€0.0555€0.0656€15733€0.0419€22€33280€25€600€0.0533€62
N€N0003€200106€CIP€11€21€529€22418€0€22418€0€4677€16266€1050€425€0€0.0692€0.0745€11685€0.0212€16€10033€16€700€0.0229€12
N€N0003€200106€CIR€11€21€3763€57557€600€56957€0€24724€23479€6114€2640€0€-0.0348€0.0568€31783€0.0736€16€21547€14€3627€0.1043€30
N€N0003€200106€CKC€11€21€1923€29607€0€29607€0€9386€15183€3387€1651€0€0.0419€0.0255€7241€0.0637€30€21486€17€880€0.0327€46
N€N0003€200106€CKH€11€21€6273€88089€0€88089€0€41269€36261€7618€2941€0€0.0003€0.0825€32140€0.0668€15€48565€12€7384€0.0821€18
N€N0003€200106€CLB€11€21€6228€122678€600€122078€0€25245€56302€22564€17297€670€0.0619€0.0714€57167€0.0743€39€58510€25€6401€0.0322€58
N€N0003€200106€CLJ€11€21€2691€38026€0€38026€0€5116€17590€8934€6386€0€0.0573€0.0909€17649€0.0682€43€19877€32€500€0.042€67
N€N0003€200106€CLL€11€21€505€8406€300€8106€0€1238€4650€1785€433€0€0.1254€0.2263€3948€0.1524€16€3958€24€200€0.29€58
N€N0003€200106€CMO€11€21€5068€106712€0€106312€400€43418€52504€8949€1841€0€0.0355€0.0488€53463€0.043€16€49371€12€3878€0.0384€11
N€N0003€200106€CMOPRA€11€21€112€3043€0€3043€0€1294€850€599€300€0€0.5313€0.3056€1249€0.5695€35€1794€16€€€
N€N0003€200106€CMOPRB€11€21€291€10036€0€10036€0€3886€4894€915€341€0€0.1375€0.13€3128€0.0804€19€6528€19€380€0.01€14
N€N0003€200106€CMP€11€21€1783€73395€0€73395€0€17955€42915€9935€2590€0€0.0915€0.1083€20714€0.0277€19€48680€18€4001€0.0559€33
N€N0003€200106€CMS€11€21€22036€430340€888€427110€2000€222679€168912€27920€9599€0€0.0123€0.0312€192319€0.0264€13€205993€11€30798€0.0334€18
N€N0003€200106€CMSPRJ€11€21€96€6005€0€6005€0€975€4230€800€0€0€0.1592€0.2442€3930€0.0288€18€1775€17€300€0.1€17
N€N0003€200106€CMSPRK€11€21€157€9399€0€9399€0€800€7649€950€0€0€0.1539€0.2479€2575€0.0399€17€6124€18€700€0.1843€12
N€N0003€200106€CMSPRL€11€21€493€9413€0€9413€0€2016€4977€2005€415€0€0.1458€0.1851€4199€0.0565€24€4814€22€400€0.1€37
N€N0003€200106€CMSPRM€11€21€1098€1698€0€1698€0€0€1398€0€300€0€0.3066€0.3419€1398€0.0949€20€€€300€0.25€156
N€N0003€200106€CMSPRN€11€21€118€4241€0€4241€0€523€2258€1260€200€0€0.0387€0.0779€3641€0.0212€28€600€9€€€
N€N0003€200106€CNA€11€21€8744€155244€0€154844€400€57125€83968€12351€1800€0€0.0374€0.0546€66722€0.0293€14€80492€10€8030€0.033€17
N€N0003€200106€CNL€11€21€14089€129633€100€129233€300€70295€48666€7529€3043€0€0.027€0.0612€53723€0.0363€14€69264€10€6546€0.0487€18
N€N0003€200106€CNN€11€21€712€4852€0€4852€0€2531€1646€200€475€0€0.0395€0.038€3087€0.0285€13€1765€48€€€
N€N0003€200106€COE€11€21€607€5098€0€5098€0€1085€1178€1635€1200€0€0.0263€0.0358€1785€0.0243€33€3313€59€€€
N€N0003€200106€COG€11€21€12708€131188€1478€129510€200€31708€55095€27764€14801€342€0.0097€0.0433€60097€0.0666€32€60933€24€8680€0.0682€51
N€N0003€200106€CPD€11€21€284€9634€0€9634€0€4435€3309€1640€250€0€0.0402€0.0417€7584€0.0444€18€2050€11€€€
N€N0003€200106€CPP€11€21€73€3230€0€3230€0€900€1350€980€0€0€0.1574€0.1737€900€0.0567€28€2330€18€€€
N€N0003€200106€CPRE€11€21€399€23321€0€23321€0€2550€15745€3669€1357€0€0.0703€0.0674€13212€0.0199€26€9709€18€400€0.1€41
N€N0003€200106€CPRF€11€21€13€1100€0€1100€0€0€900€0€200€0€0.1932€0.3159€250€0.48€23€850€28€€€
N€N0003€200106€CPRG€11€21€25€1326€0€1326€0€0€764€562€0€0€0.3991€0.4987€664€0.1324€29€662€30€€€
N€N0003€200106€CPRH€11€21€30€1320€0€1320€0€0€600€720€0€0€0.3235€0.422€920€0.1978€23€400€59€€€
N€N0003€200106€CPRK€11€21€161€11084€0€11084€0€500€7692€2092€600€200€0.2122€0.2243€5553€0.0862€41€5131€29€400€0.165€32
N€N0003€200106€CPRM€11€21€28€2226€0€2226€0€339€960€727€200€0€0.3019€0.5577€1580€0.2241€29€446€18€200€0.25€38
N€N0003€200106€CPRN€11€21€269€11091€0€11091€0€2000€7226€1205€660€0€0.0681€0.0632€5145€0.0127€21€5946€26€€€
N€N0003€200106€CPRQ€11€21€12€1200€0€1200€0€0€500€700€0€0€0.5€0.5625€400€0.05€31€600€21€200€0.1€22
N€N0003€200106€CPRR€11€21€10€500€0€500€0€0€300€0€200€0€0.502€0.602€300€0.03€26€200€72€€€
N€N0003€200106€CPRU€11€21€26€3145€0€3145€0€200€1745€800€400€0€0.4211€0.5192€1470€0.0813€20€1675€47€€€
N€N0003€200106€CPRW€11€21€748€54632€0€54632€0€10698€29850€9542€4142€400€0.0671€0.0715€24025€0.0144€27€30207€31€400€0.04€21
N€N0003€200106€CPRX€11€21€713€45053€400€44653€0€9460€26551€5112€3530€0€0.056€0.0603€19055€0.0159€31€25098€22€500€0.044€106
N€N0003€200106€CQPRA€11€21€333€19210€0€19210€0€5594€9166€3275€1175€0€0.1281€0.1641€10230€0.0347€18€8480€27€500€0.08€40
N€N0003€200106€CRM€11€21€86€1000€0€1000€0€0€300€0€700€0€0.132€-0.057€500€0.81€65€500€66€€€
N€N0003€200106€CRY€11€21€7970€234595€3650€230145€500€98877€107261€19489€5018€0€-0.0028€0.1235€91095€0.097€16€107036€12€32514€0.1306€20
N€N0003€200106€CSL€11€21€12261€142404€860€141544€0€43960€64987€21866€10199€532€0.0098€0.0624€60868€0.0381€24€68088€17€12588€0.0475€27
N€N0003€200106€CSP€11€21€386€11788€0€11188€600€4305€5430€1114€939€0€0.0331€0.0379€3505€0.0229€13€8183€24€100€0.02€14
N€N0003€200106€CVC€11€21€14796€300546€2400€297846€0€124254€143338€23288€6966€0€-0.0109€0.0522€119404€0.0584€16€145555€12€32887€0.052€19
N€N0003€200106€CVD€11€21€10013€215338€1250€212285€1000€63619€102151€34471€13044€0€0.0155€0.0433€91877€0.0469€22€107181€19€14227€0.0438€27
N€N0003€200106€CW€11€21€748€11629€0€11629€0€1568€7271€1704€1086€0€-0.039€0.1445€5531€0.0981€29€5598€18€500€0.082€24
N€N0003€200106€CWN€11€21€4783€59776€200€59176€400€10708€28045€14206€6517€100€0.0301€0.0268€23025€0.035€36€35286€30€1265€0.0361€38
N€N0003€200106€CWNPRA€11€21€122€5460€0€5460€0€1280€2775€1105€300€0€0.0251€0.1623€2850€0.0813€21€2610€29€€€
N€N0003€200106€CYE€11€21€1141€44347€0€44047€300€11950€16310€9270€6567€250€0.0261€0.029€15808€0.0208€39€28139€28€400€0.03€68
N€N0003€200106€D€11€21€58011€1219758€2220€1216438€1100€899099€288283€25052€5104€0€-0.0017€0.0547€587917€0.0449€8€463592€7€166029€0.0507€10
N€N0003€200106€DCP€11€21€2446€23882€0€23882€0€6845€13962€2650€425€0€0.5272€0.4252€14729€0.1923€19€9153€17€€€
N€N0003€200106€DCS€11€21€1232€4646€100€4546€0€826€1934€886€900€0€0.0456€0.0374€646€0.0154€28€3900€39€€€
N€N0003€200106€DDF€11€21€624€34631€104€34527€0€7804€18014€5335€3374€0€0.06€0.0619€12217€0.0453€22€21810€22€500€0.01€12
N€N0003€200106€DFG€11€21€5894€57038€0€57038€0€27051€22775€5339€1873€0€0.0073€0.0532€24654€0.036€18€28384€11€4000€0.0359€16
N€N0003€200106€DGX€11€21€30450€1005363€24875€978733€1100€406700€402320€118543€51365€905€-0.0253€0.1035€454631€0.1058€20€354981€15€170221€0.1344€24
N€N0003€200106€DHY€11€21€1351€15511€0€15511€0€3644€6401€3456€1868€142€0.0168€0.0212€5804€0.0202€39€9407€33€300€0.01€39
N€N0003€200106€DJM€11€21€67€830€0€830€0€400€430€0€0€0€0.1148€0.1004€430€0.01€22€400€4€€€
N€N0003€200106€DLX€11€21€16578€281299€2671€278216€300€71701€103284€50590€50913€2028€0.0145€0.0344€101971€0.0331€40€151551€33€24994€0.05€48
N€N0003€200106€DNB€11€21€8423€207241€100€207141€0€97114€83577€20796€5654€0€0.0274€0.0423€106479€0.0315€16€90982€12€9680€0.0268€21
N€N0003€200106€DNR€11€21€6446€73429€101€72428€900€27435€35656€7906€2331€0€0.0198€0.0339€30182€0.0324€16€39174€15€3972€0.0371€19
N€N0003€200106€DNY€11€21€20761€380145€100€379832€0€216298€132793€19890€10851€0€0.013€0.0381€156676€0.0298€13€193479€12€29677€0.0313€15
N€N0003€200106€DPRA€11€21€684€35911€0€35911€0€16642€14590€3109€1570€0€0.0942€0.1137€13725€0.0222€17€20986€15€1200€0.0733€17
N€N0003€200106€DSU€11€21€2510€76624€280€76344€0€28055€28115€11749€8425€0€0.0227€0.0231€27021€0.0138€28€48009€27€1314€0.0163€34
N€N0003€200106€DT€11€21€57959€446775€1300€444775€700€253675€148003€35543€8254€0€0.0139€0.0166€202363€0.0184€12€202306€10€40806€0.0204€23
N€N0003€200106€DV€11€21€12130€149804€900€148704€200€53027€64825€19880€10136€1036€0.01€0.0764€65449€0.0428€22€72670€17€10785€0.0449€21
N€N0003€200106€EAS€11€21€10895€158503€600€157500€0€70724€51100€22068€13608€0€0.0203€0.0322€57187€0.035€26€94069€17€6244€0.0266€40
N€N0003€200106€ED€11€21€31154€765164€1625€760880€1700€269390€288368€128899€73604€4061€0.0023€0.0326€315254€0.0402€32€364869€20€82457€0.0417€45
N€N0003€200106€EDE€11€21€3768€54956€0€54856€100€22840€24852€6013€1251€100€0.0248€0.0399€26989€0.0521€15€25555€16€2412€0.0353€19
N€N0003€200106€EDEPRD€11€21€104€4917€0€4917€0€900€2790€1127€100€0€0.0789€0.0871€4417€0.1058€19€300€26€200€0.06€31
N€N0003€200106€EDL€11€21€416€24045€0€24045€0€4069€14154€4450€1372€0€0.0875€0.0953€4642€0.0249€30€17298€22€2105€0.0329€18
N€N0003€200106€EDO€11€21€6440€150405€2000€148405€0€48400€64713€22279€12513€500€0.0238€0.0571€72066€0.0717€23€66460€15€9879€0.0961€31
N€N0003€200106€EDPRA€11€21€86€3320€0€3320€0€500€1950€400€470€0€0.3342€0.8095€1820€0.7951€31€1200€27€300€0.4167€28
N€N0003€200106€EFL€11€21€172€4491€0€4491€0€1783€2333€275€100€0€0.1172€0.1064€3238€0.0392€14€1253€18€€€
N€N0003€200106€ELN€11€21€39373€1698154€28233€1658521€9800€591927€749792€247952€77850€800€0.0024€0.0376€896938€0.0543€20€574910€16€196473€0.0643€24
N€N0003€200106€ELNWSA€11€21€6643€15924€0€15924€0€2530€8535€2849€2010€0€0.706€0.618€9810€0.2236€33€5214€14€900€0.1233€61
N€N0003€200106€ELNWSB€11€21€1507€3710€0€3710€0€950€1510€800€450€0€0.6193€1.0969€2100€0.5145€54€1410€12€200€0.79€20
N€N0003€200106€EMC€11€21€281430€9897171€68202€9782039€39300€3244345€4085888€1836849€651461€1701€0.006€0.0249€5060991€0.0472€22€2257708€15€2502640€0.0544€30
N€N0003€200106€EMD€11€21€134€3634€0€3634€0€200€2219€700€515€0€0.1069€0.0971€1119€0.0607€21€2515€31€€€
N€N0003€200106€EPG€11€21€88656€3812438€35121€3757321€15900€1178720€1457845€694790€424248€17468€0.0012€0.0318€2175190€0.0565€26€985314€20€612717€0.0627€36
N€N0003€200106€EPGPR€11€21€7€589€0€589€0€0€0€100€489€0€0.8351€1.1746€489€0.234€91€100€142€€€
N€N0003€200106€EPGPRC€11€21€3904€1800€0€1800€0€0€200€800€400€400€0.9539€1.6667€500€0.298€99€900€253€400€1.05€42
N€N0003€200106€EPI€11€21€470€33956€200€33756€0€10726€15906€5444€1680€0€0.0689€0.0843€13803€0.0236€22€19153€19€800€0.0238€21
N€N0003€200106€EPL€11€21€4429€76532€0€76232€300€31698€32628€8058€4148€0€0.0225€0.039€33547€0.0448€20€41085€15€1900€0.0384€30
N€N0003€200106€EPN€11€21€6829€207403€200€207003€200€67977€98548€24636€15492€550€0.015€0.0573€111443€0.0584€22€85320€22€10440€0.0449€39
N€N0003€200106€ESI€11€21€11026€263316€10079€252937€200€72537€103484€43898€32168€1050€-0.0044€0.0683€113865€0.0789€32€107821€21€31451€0.1062€56
N€N0003€200106€ETA€11€21€261€6305€0€6305€0€800€3730€1385€390€0€0.0416€0.0437€3350€0.023€24€2855€29€100€0.04€38
N€N0003€200106€EX€11€21€3998€36259€200€36059€0€11720€18552€4551€1236€0€0.0152€0.0391€16262€0.0377€21€18701€14€1096€0.0338€35
N€N0003€200106€FC€11€21€1581€7273€0€7273€0€2340€3733€1100€100€0€0.0509€0.0469€4128€0.0602€21€3045€11€100€0.02€14
N€N0003€200106€FCX€11€21€22496€477507€0€477007€500€224775€186859€45247€20626€0€0.0095€0.0182€200039€0.0292€19€251445€13€26023€0.0258€17
N€N0003€200106€FCXA€11€21€8050€43156€440€42716€0€15376€22763€3384€1049€144€0.0347€0.0382€23814€0.0421€19€17487€13€1415€0.0248€40
N€N0003€200106€FCXPRA€11€21€621€18015€0€18015€0€5645€7438€3682€1250€0€0.0671€0.0635€11571€0.0507€23€6444€22€€€
N€N0003€200106€FCXPRB€11€21€433€14738€0€14738€0€3662€8961€1765€350€0€0.0779€0.1379€5695€0.0608€21€9043€19€€€
N€N0003€200106€FCXPRC€11€21€285€4202€0€4202€0€0€2202€1700€300€0€0.0778€0.1058€1100€0.0409€35€3102€25€€€
N€N0003€200106€FCXPRD€11€21€176€7878€0€7878€0€754€6474€650€0€0€0.0569€0.0839€4508€0.0431€17€3370€19€€€
N€N0003€200106€FE€11€21€35393€852395€1200€849495€600€440011€305729€80238€22433€1684€0.0002€0.0259€297521€0.0334€15€484823€12€67751€0.0391€18
N€N0003€200106€FLR€11€21€30545€566592€10100€554892€1000€189895€244194€85222€36481€100€-0.0088€0.062€286010€0.0751€20€184057€16€85825€0.1055€33
N€N0003€200106€FMC€11€21€31359€300685€6100€294585€0€119860€125954€33675€15096€0€-0.0114€0.06€158560€0.0587€18€100317€17€35708€0.0695€31
N€N0003€200106€FO€11€21€20172€497417€300€496617€200€263838€184257€39171€9551€0€0.0121€0.0459€217394€0.0347€13€239890€11€39533€0.0497€21
N€N0003€200106€FOE€11€21€10534€125134€506€124228€0€44257€57903€16669€5399€0€0.005€0.0377€56458€0.0374€20€61161€16€6609€0.0451€19
N€N0003€200106€FOPRA€13€21€1€300€300€0€0€0€0€0€0€0€0€€€€€€€€€
N€N0003€200106€FOR€11€21€743€12184€0€12184€0€8401€3433€350€0€0€0.03€0.0292€7012€0.0142€10€5172€7€€€
N€N0003€200106€FPCPRA€11€21€369€22202€0€22202€0€9105€6257€2976€3864€0€0.0873€0.1081€10106€0.0562€28€12096€34€€€
N€N0003€200106€FRC€11€21€4092€47308€200€47108€0€11567€14565€9783€10893€300€0.0397€0.0645€16764€0.0702€53€24944€38€5400€0.1115€77
N€N0003€200106€FSH€11€21€8517€195393€1100€194093€200€78546€81804€23834€10409€0€-0.0134€0.0717€92235€0.068€22€89125€14€12933€0.0638€25
N€N0003€200106€FTI€11€21€4534€362127€100€361927€100€145638€148580€54179€13530€100€0.0288€0.0225€195780€0.0546€19€152912€17€13335€0.0439€26
N€N0003€200106€FWJ€11€21€58€900€0€900€0€0€900€0€0€0€0.1167€0.1167€300€0.1€18€600€20€€€
N€N0003€200106€GBE€11€21€180€4475€0€4475€0€1148€1629€814€884€0€0.052€0.0771€2092€0.049€30€2083€24€300€0.05€49
N€N0003€200106€GCG€11€21€114€900€0€900€0€400€0€100€400€0€-0.0011€-0.0011€700€0.0443€57€200€0€€€
N€N0003€200106€GDP€11€21€940€4550€0€4550€0€1660€2414€476€0€0€0.0751€0.0799€1889€0.0255€18€2261€11€400€0.015€11
N€N0003€200106€GGT€11€21€1980€24322€0€24322€0€9040€11256€3414€612€0€0.0735€0.0914€9010€0.0369€16€14434€18€878€0.0613€14
N€N0003€200106€GGTPR€11€21€70€2302€0€2302€0€400€1602€300€0€0€0.2183€0.2422€200€0.02€8€2102€16€€€
N€N0003€200106€GID€11€21€19€600€0€600€0€100€300€200€0€0€0.0667€0.0133€600€0.05€28€€€€€
N€N0003€200106€GK€11€21€2191€17156€0€17156€0€1750€7742€4376€3062€226€-0.0365€0.0597€9137€0.0484€35€6619€55€1400€0.0421€52
N€N0003€200106€GLC€11€21€20315€310305€2700€306105€1100€88027€135891€55266€26942€1079€0.0057€0.0268€152886€0.0322€25€129221€21€25098€0.0498€30
N€N0003€200106€GLG€11€21€4130€51489€0€51089€400€30501€17462€3225€301€0€0.0271€0.0265€13063€0.0168€11€37509€11€917€0.0151€7
N€N0003€200106€GLH€11€21€4147€45051€0€45051€0€15566€21649€5843€1993€0€0.1176€0.143€14705€0.0661€23€28551€15€1795€0.0261€21
N€N0003€200106€GLW€11€21€156273€6854173€13360€6798713€38700€3855589€2284747€586994€109468€615€0.001€0.0136€3112503€0.0242€12€2413309€9€1311601€0.0273€18
N€N0003€200106€GPB€11€21€406€26231€0€26231€0€4691€15476€4364€1700€0€0.0888€0.0968€14042€0.057€21€11889€26€300€0.0167€53
N€N0003€200106€GPD€11€21€247€13433€0€13433€0€7588€5845€0€0€0€0.1493€0.1593€7865€0.0481€10€5268€10€300€0.1€9
N€N0003€200106€GPEPRA€11€21€315€17189€0€17189€0€7510€8831€848€0€0€0.1012€0.1118€10268€0.0573€13€6921€10€€€
N€N0003€200106€GPEPRT€11€21€238€14799€400€14399€0€6781€6318€1100€200€0€0.0676€0.0711€6620€0.0196€18€7779€8€€€
N€N0003€200106€GPEPRU€11€21€174€12589€0€12589€0€4059€8135€395€0€0€0.1495€0.1653€7537€0.0333€12€5052€11€€€
N€N0003€200106€GPEPRV€11€21€151€7953€0€7953€0€1966€4966€1021€0€0€0.1438€0.1588€4145€0.0421€17€3508€19€300€0.0733€14
N€N0003€200106€GPF€11€21€206€5986€0€5986€0€1030€3571€925€460€0€0.1227€0.1622€1540€0.0802€23€4446€26€€€
N€N0003€200106€GPU€11€21€19288€331935€1599€329136€500€179273€123240€20383€6540€200€0.0195€0.0418€164349€0.0434€12€136469€11€28818€0.0411€15
N€N0003€200106€GRA€11€21€2238€50998€0€50998€0€21532€22718€6164€584€0€0.0138€0.0143€18821€0.0151€17€31361€14€816€0.0202€6
N€N0003€200106€GRB€11€21€3283€27554€0€27554€0€5052€13374€6620€2508€0€0.0005€0.0295€12715€0.0593€26€13418€28€1421€0.0244€47
N€N0003€200106€GUPPRA€11€21€62€4554€0€4554€0€350€4204€0€0€0€0.0982€0.1284€2809€0.1062€13€1745€14€€€
N€N0003€200106€GUPPRB€11€21€58€5484€0€5484€0€550€4584€350€0€0€0.159€0.1667€3784€0.0723€15€1700€11€€€
N€N0003€200106€HAR€11€21€8880€148497€1800€146597€100€34515€73133€27304€11745€0€-0.0186€0.0552€68766€0.0854€26€67117€23€10814€0.1312€22
N€N0003€200106€HAS€11€21€14135€438982€100€437882€1000€174135€192970€53185€18592€0€0.0166€0.0301€246768€0.0269€17€172621€16€19493€0.0313€24
N€N0003€200106€HCN€11€21€8757€177141€0€175441€800€59204€72907€26587€16813€730€0.0226€0.034€81716€0.0317€27€85715€20€8810€0.0327€45
N€N0003€200106€HCNPRB€11€21€192€10125€0€10125€0€2217€4841€2284€783€0€0.0938€0.1173€6825€0.0796€25€2900€37€400€0.05€14
N€N0003€200106€HGR€11€21€512€7668€0€7668€0€2203€2650€1915€900€0€0.0445€0.0502€2915€0.0361€44€4653€19€100€0.02€8
N€N0003€200106€HIL€11€21€1329€12938€0€12938€0€3997€7419€1222€300€0€0.0276€0.0221€7891€0.0332€15€4547€15€500€0.026€18
N€N0003€200106€HIW€11€21€15084€201813€138€201675€0€124564€67892€7219€1700€300€0.0216€0.0302€92008€0.0319€10€101169€9€8498€0.0282€18
N€N0003€200106€HIWPRB€11€21€235€13382€0€13382€0€3770€8212€1000€400€0€0.1157€0.1308€9665€0.0841€16€3717€18€€€
N€N0003€200106€HIWPRD€11€21€249€13883€0€13883€0€3676€7969€2238€0€0€0.1125€0.1521€8843€0.0724€17€4640€16€400€0.055€9
N€N0003€200106€HMA€11€21€21854€285451€0€284551€900€120298€111741€35184€17878€350€0.0064€0.0185€153353€0.0329€22€115598€15€16500€0.0365€33
N€N0003€200106€HMC€11€21€4170€61763€0€61763€0€23757€28584€7033€2389€0€0.1082€0.1751€29459€0.1755€21€28592€13€3712€0.0987€30
N€N0003€200106€HMT€11€21€18273€248392€300€245792€2300€101541€107186€25592€12063€1710€0.0127€0.0155€123922€0.0207€20€115408€14€8762€0.018€59
N€N0003€200106€HMTPRA€11€21€303€10915€0€10915€0€2225€7190€1100€400€0€0.0923€0.1225€4130€0.0509€12€6285€19€500€0.086€42
N€N0003€200106€HMTPRB€11€21€319€12320€0€12320€0€4705€5465€1700€450€0€0.0738€0.0985€7575€0.0284€16€4545€23€200€0.1€18
N€N0003€200106€HMTPRC€11€21€631€16685€0€16685€0€4440€10635€1280€330€0€0.0792€0.0897€7385€0.018€21€8900€13€400€0.05€7
N€N0003€200106€HON€11€21€150245€4537992€36160€4486970€11800€2162439€1652916€496192€184563€2660€-0.0203€0.0359€2222825€0.0602€16€1376974€12€898971€0.0831€26
N€N0003€200106€HOV€11€21€7214€107289€200€106689€300€46229€49915€7595€3250€0€0.0423€0.0621€47328€0.0482€16€52446€13€7215€0.0522€15
N€N0003€200106€HZO€11€21€1042€4175€0€4175€0€1240€2184€200€551€0€0.0338€0.039€1809€0.0585€30€2366€22€€€
N€N0003€200106€ICS€11€21€130€1506€0€1506€0€0€1506€0€0€0€0.0529€0.0675€770€0.0113€10€736€16€€€
N€N0003€200106€IDG€11€21€68€2461€0€2461€0€319€1494€648€0€0€0.0047€0.1105€1813€0.0317€11€€€648€0.1€38
N€N0003€200106€IEU€11€21€80€4255€0€4255€0€255€3200€400€400€0€0.1078€0.2366€1555€0.0971€15€2700€36€€€
N€N0003€200106€IFX€11€21€32247€155517€1600€152017€400€57220€65935€19363€9549€350€0.0046€0.1008€54177€0.0564€21€66889€15€31351€0.0759€27
N€N0003€200106€IGL€11€21€13602€187910€400€187210€300€46812€77036€38157€24596€909€0.01€0.0177€77292€0.0227€36€101416€23€8802€0.0292€38
N€N0003€200106€IML€11€21€1449€6306€0€6306€0€857€3090€1110€945€304€0.0974€0.1118€4214€0.0282€50€1335€44€757€0.0617€87
N€N0003€200106€IQM€11€21€301€9088€0€9088€0€3112€3224€1533€1219€0€0.032€0.0412€2795€0.0247€19€6163€27€130€0.02€15
N€N0003€200106€IR€11€21€43081€759241€2050€754499€2100€278603€313443€122486€41102€1380€0.0004€0.0277€384981€0.0303€20€301091€17€70527€0.0412€26
N€N0003€200106€ISP€11€21€2682€20875€0€20875€0€5474€11352€2541€1508€0€0.0352€0.0493€11155€0.0345€20€8420€19€1300€0.0331€33
N€N0003€200106€ITG€11€21€11690€235115€3900€231115€100€71405€116744€30416€12650€0€-0.0315€0.0835€110607€0.0695€22€102156€15€18452€0.1072€32
N€N0003€200106€ITN€11€21€4918€78922€429€78493€0€38979€31129€6358€2027€0€0.0211€0.0448€27960€0.0329€13€45177€12€5356€0.037€20
N€N0003€200106€ITT€11€21€25796€286838€300€285930€500€109564€148979€23443€4444€0€0.0162€0.0516€134635€0.0453€15€131715€12€20080€0.0523€18
N€N0003€200106€ITX€11€21€2903€16878€200€16678€0€3675€9192€2450€1361€0€0.0283€0.0615€5862€0.039€25€7799€16€3017€0.0462€32
N€N0003€200106€ITXPR€11€21€32€1738€0€1738€0€199€729€450€360€0€0.2329€0.3264€888€0.2684€41€700€45€150€0.5€10
N€N0003€200106€IVC€11€21€7236€109326€0€109042€0€56256€39484€9774€3528€0€0.0119€0.0595€52292€0.0707€14€49763€14€6987€0.0589€23
N€N0003€200106€JBL€11€21€65286€2021224€38650€1976374€5600€828342€716374€280748€152377€4133€-0.0168€0.0406€978092€0.0497€20€664172€15€339710€0.0735€35
N€N0003€200106€JCP€11€21€32339€923275€3200€917192€2600€476919€354391€69553€17871€1058€0.0032€0.027€417906€0.0348€15€412601€11€89285€0.0462€17
N€N0003€200106€JEM€11€21€164€3691€0€3691€0€2595€846€250€0€0€0.0709€0.0709€650€0.0162€17€3041€8€€€
N€N0003€200106€JOE€11€21€6413€109132€100€108932€100€37049€49203€13005€9415€360€0.0362€0.0545€30081€0.028€28€72812€20€6139€0.0361€55
N€N0003€200106€JYPPRZ€11€21€477€8294€0€8294€0€3987€2853€1454€0€0€0.075€0.0813€2801€0.0214€12€5093€17€400€0.055€13
N€N0003€200106€KBH€11€21€24625€396444€1900€393544€700€235578€135787€19031€3612€236€0.0173€0.052€158530€0.0436€12€201018€9€34696€0.062€18
N€N0003€200106€KBHPRG€12€23€94€4000€3800€200€0€0€200€0€0€0€-0.2€0.25€€€€200€18€€€
N€N0003€200106€KBHPRI€11€21€481€1870€0€1870€0€670€1200€0€0€0€0.0917€0.1165€600€0.0233€10€1270€11€€€
N€N0003€200106€KEG€11€21€13540€219955€1787€218168€0€79979€96492€29441€11905€351€0.0066€0.0309€96876€0.0251€21€100725€18€20567€0.0376€30
N€N0003€200106€KEI€11€21€9379€304821€3399€301422€0€107761€129096€42537€22028€0€-0.0197€0.0795€140598€0.0738€21€117736€18€43088€0.0839€31
N€N0003€200106€KG€11€21€38805€1031366€8400€1021866€1100€454412€432306€107139€28667€442€-0.0191€0.0377€522352€0.0555€16€392279€13€108335€0.069€18
N€N0003€200106€KLU€11€21€1499€33466€0€33466€0€12755€16840€3321€550€0€0.0379€0.052€13916€0.0403€14€18540€14€1010€0.01€16
N€N0003€200106€KMB€11€21€60627€2164410€4955€2150133€7000€686439€883329€387441€193491€6433€-0.0002€0.0322€1162179€0.0422€24€704899€21€290055€0.0583€29
N€N0003€200106€KOR€11€21€1063€5566€0€5566€0€1145€2746€600€1075€0€0.0353€0.0425€3656€0.0338€26€1910€33€€€
N€N0003€200106€KPA€11€21€4799€63086€0€62586€500€27584€24830€7518€3154€0€0.0283€0.0301€18392€0.0203€18€41710€16€2984€0.0191€24
N€N0003€200106€KPAPRA€11€21€338€8841€0€8841€0€2025€3910€800€2106€0€0.1962€0.2095€2760€0.056€50€5456€28€625€0.1156€16
N€N0003€200106€KRJ€11€21€36€1150€0€1150€0€300€850€0€0€0€0.0652€0.113€600€0.0833€18€550€14€€€
N€N0003€200106€KTB€11€21€98€6825€0€6825€0€1200€3975€850€800€0€0.0992€0.1024€4475€0.0597€29€2350€20€€€
N€N0003€200106€KTP€11€21€644€29875€0€29875€0€11654€14076€3720€425€0€0.026€0.1111€13092€0.0381€17€15603€15€1180€0.0632€17
N€N0003€200106€KYO€11€21€6006€90772€0€90472€300€44067€39611€5763€1331€0€0.2892€0.3294€39291€0.1462€13€44089€12€7392€0.1991€15
N€N0003€200106€LBI€11€21€172€1540€0€1540€0€200€1090€250€0€0€0.0072€0.0645€713€0.121€22€827€15€€€
N€N0003€200106€LDP€11€21€2070€16330€0€16330€0€4713€7895€1543€2179€0€0.0597€0.0814€6311€0.0355€21€9254€26€765€0.0413€41
N€N0003€200106€LMM€11€21€64€1340€0€1340€0€400€450€490€0€0€0.0192€0.0192€210€0.0257€18€1130€27€€€
N€N0003€200106€LMS€11€21€2098€8949€0€8949€0€1605€5269€1025€1050€0€-0.0062€0.0789€5069€0.0544€32€3770€16€110€0.02€12
N€N0003€200106€LMT€11€21€42535€1539221€2321€1534598€1500€813099€498258€155630€68871€240€0.0089€0.038€652816€0.0387€18€731392€12€151890€0.0449€19
N€N0003€200106€LNT€11€21€11841€241025€0€240325€700€74986€120488€33823€11428€300€0.0151€0.0345€72301€0.0345€18€155939€17€12785€0.0238€23
N€N0003€200106€LRY€11€21€10872€157798€0€156898€900€63418€75594€14717€4069€0€0.0192€0.0361€80555€0.0294€15€73460€14€3783€0.0312€21
N€N0003€200106€LRYPRA€11€21€481€11239€0€11239€0€5040€5074€675€450€0€0.1234€0.1347€2244€0.0408€19€8795€14€200€0.05€24
N€N0003€200106€LSHPRA€11€21€370€8884€0€8884€0€1777€4625€1100€1382€0€0.0941€0.1001€4602€0.0332€34€4282€29€€€
N€N0003€200106€MAG€11€21€3094€40664€100€40564€0€11519€19271€7942€1832€0€0.0271€0.034€18625€0.0561€21€21026€17€913€0.0264€46
N€N0003€200106€MAR€11€21€36100€852217€3439€847777€500€327186€338792€115285€64394€2620€-0.0021€0.0336€371175€0.0377€23€376069€17€101033€0.0395€25
N€N0003€200106€MAT€11€21€38265€1269034€600€1265555€2400€804303€370087€74517€19048€0€0.017€0.0286€536799€0.0232€12€603833€9€127323€0.0268€17
N€N0003€200106€MCC€11€21€1017€15602€100€15502€0€3391€5930€2640€3441€100€0.0695€0.1551€10231€0.1351€48€3496€48€1775€0.1344€50
N€N0003€200106€MCO€11€21€19298€482050€300€481050€0€205260€224512€38524€12754€0€0.0064€0.0344€232157€0.0449€16€218413€12€30480€0.0506€21
N€N0003€200106€MCT€11€21€2214€18905€300€18605€0€6170€8860€2500€1175€0€0.1805€0.2168€10070€0.0931€22€7035€21€1500€0.0993€18
N€N0003€200106€MDG€11€21€13082€44774€100€44574€100€18941€16881€6899€1953€0€0.0197€0.0379€17024€0.0225€15€23758€15€3892€0.029€43
N€N0003€200106€MEE€11€21€16499€209709€1746€206463€1500€66383€99319€28763€13498€0€0.0036€0.0405€111328€0.0591€22€81354€18€15281€0.0622€27
N€N0003€200106€MEH€11€21€3317€48319€0€48319€0€14334€23793€6423€3769€0€0.0076€0.0701€17902€0.0429€26€24568€19€5849€0.046€31
N€N0003€200106€MER€11€21€178402€6760165€79577€6655420€22100€3730194€2256343€498914€187021€5048€0.0048€0.0551€3050308€0.0476€13€1925818€9€1701394€0.066€19
N€N0003€200106€MERPRA€11€21€180€19057€0€19057€0€7062€8478€2817€700€0€0.0955€0.101€10546€0.0317€22€8411€15€100€0.02€24
N€N0003€200106€MERPRB€11€21€309€20512€0€20512€0€6773€11414€1925€400€0€0.0952€0.0985€12232€0.0367€16€7980€17€300€0.01€11
N€N0003€200106€MERPRC€11€21€244€18441€0€18441€0€4795€11057€1582€1007€0€0.1116€0.1103€11160€0.0386€24€7181€16€100€0.07€17
N€N0003€200106€MERPRD€11€21€792€50455€0€50455€0€18698€26565€3992€1200€0€0.0661€0.0677€28689€0.0208€17€21266€15€500€0.026€20
N€N0003€200106€MERPRE€11€21€398€24866€0€24866€0€7807€13364€1525€2170€0€0.0603€0.0673€17369€0.0194€23€7497€26€€€
N€N0003€200106€MERPRF€11€21€850€64465€0€64465€0€22971€30739€8030€2725€0€0.0545€0.0566€35833€0.0187€19€27832€19€800€0.025€12
N€N0003€200106€MFW€11€21€486€7466€0€7466€0€2841€4113€512€0€0€0.0188€0.0181€2029€0.0623€12€5437€14€€€
N€N0003€200106€MGF€11€21€829€16120€0€16120€0€6543€8899€500€178€0€0.0194€0.0166€3887€0.0103€17€12233€12€€€
N€N0003€200106€MHN€11€21€517€10018€0€10018€0€5361€3632€1025€0€0€0.0233€0.0315€3926€0.014€17€5792€10€300€0.0133€16
N€N0003€200106€MIM€11€21€144€1347€0€1347€0€275€672€200€200€0€0.0974€0.1074€140€0.13€24€1207€26€€€
N€N0003€200106€MLI€11€21€5950€69963€100€69763€100€19462€27043€13949€9309€100€0.0019€0.0273€31833€0.0706€30€34350€30€3680€0.0433€50
N€N0003€200106€MLM€11€21€13762€204799€300€204099€400€61064€95095€32619€15821€300€0.0101€0.0477€80241€0.0608€24€108917€20€15341€0.0475€23
N€N0003€200106€MLS€11€21€7694€206055€0€205855€200€74780€98864€22395€10016€0€0.0448€0.065€79217€0.0297€20€113979€14€12859€0.0332€28
N€N0003€200106€MMA€11€21€1082€41547€0€41347€200€6120€18982€11510€4935€0€0.0685€0.0759€18868€0.0622€31€22479€28€200€0.01€42
N€N0003€200106€MMC€11€21€67016€1504024€4800€1496324€2400€848935€524310€93936€31240€303€-0.0049€0.0776€737970€0.0635€14€537240€9€223514€0.0759€16
N€N0003€200106€MMR€11€21€2396€24452€0€24452€0€4408€14201€3524€2319€0€0.0558€0.0584€10071€0.0532€24€13468€26€913€0.0605€21
N€N0003€200106€MMS€11€21€7706€318955€1900€315905€900€106853€137298€48809€23545€300€0.0373€0.0495€180240€0.06€24€113201€20€23364€0.0565€33
N€N0003€200106€MOT€11€21€113979€3328170€5844€3311576€8100€1598352€1234943€389062€96669€650€0.0033€0.0107€1631510€0.0236€17€1229766€10€458400€0.0247€21
N€N0003€200106€MOTPRA€11€21€915€54690€0€54690€0€19492€24106€8167€2925€0€0.0856€0.0898€30541€0.0284€23€23749€17€400€0.025€16
N€N0003€200106€MPPRD€11€21€54€1975€0€1975€0€300€775€900€0€0€0.1489€0.2923€1600€0.04€28€375€14€€€
N€N0003€200106€MRX€11€21€10826€320344€8637€310782€200€63174€159322€56740€29946€1800€-0.0397€0.0942€133022€0.0768€30€134927€24€43033€0.1141€30
N€N0003€200106€MSF€11€21€437€9509€0€9509€0€2112€6131€766€200€300€0.0557€0.0626€3761€0.0423€15€5748€16€€€
N€N0003€200106€MTN€11€21€2686€22165€0€21965€200€4845€12736€2407€2177€0€0.0748€0.0896€11127€0.0907€28€10716€22€322€0.1€10
N€N0003€200106€MTTPRX€11€21€123€5969€0€5969€0€850€4879€240€0€0€0.1796€0.1935€3074€0.1643€18€2895€13€€€
N€N0003€200106€MTX€11€21€10819€141623€0€140313€0€59229€61833€11244€8007€0€-0.0148€0.062€55775€0.0467€18€74506€17€10032€0.0553€28
N€N0003€200106€MUC€11€21€867€9273€0€9273€0€3762€3999€400€1112€0€0.0208€0.0279€5611€0.0146€17€3262€42€400€0.01€6
N€N0003€200106€MUJ€11€21€422€8266€0€8266€0€3118€4948€200€0€0€0.0242€0.0292€4991€0.0126€15€3275€10€€€
N€N0003€200106€MUO€11€21€916€10408€0€10408€0€2493€6074€1116€725€0€0.0495€0.0519€3863€0.0223€24€6345€13€200€0.06€140
N€N0003€200106€MYI€11€21€1262€32319€0€32319€0€11642€14632€3472€2373€200€0.0321€0.0318€11728€0.0141€29€20291€17€300€0.01€18
N€N0003€200106€NAV€11€21€20231€207641€200€206594€300€100039€87977€14008€4870€0€-0.0035€0.0271€94076€0.027€14€101550€12€11268€0.0438€17
N€N0003€200106€NC€11€21€5222€70933€0€70933€0€24172€40012€5599€1150€0€0.0198€0.1476€27278€0.0952€18€37888€11€5767€0.0974€18
N€N0003€200106€NCI€11€21€4804€36300€0€36300€0€12555€13153€5331€4291€970€0.0303€0.0448€13065€0.0375€23€21642€25€1593€0.0567€119
N€N0003€200106€NDE€11€21€13717€252703€3500€248903€200€62581€105339€52043€27991€1149€0.0116€0.0427€103869€0.041€28€124648€23€20586€0.0692€57
N€N0003€200106€NEU€11€21€20914€434722€5500€427622€500€148279€190275€58105€31463€0€-0.019€0.0733€193603€0.0723€25€172307€15€62212€0.0672€31
N€N0003€200106€NMA€11€21€390€13504€0€13504€0€2868€6470€2799€1367€0€0.0282€0.033€1804€0.0319€18€11350€29€350€0.01€41
N€N0003€200106€NMI€11€21€277€5888€0€5888€0€2227€2881€580€200€0€0.064€0.0667€4313€0.0145€18€1575€13€€€
N€N0003€200106€NMK€11€21€8588€308307€100€307707€400€114811€128594€41825€22677€200€0.0157€0.0191€97748€0.016€23€190283€18€20076€0.0143€28
N€N0003€200106€NMKPRK€11€21€12€100€0€100€0€100€0€0€0€0€0.75€0.75€€€€100€9€€€
N€N0003€200106€NMT€11€21€209€5072€0€5072€0€507€4032€133€400€0€0.0567€0.0602€2876€0.023€19€2196€23€€€
N€N0003€200106€NPC€11€21€179€2425€0€2425€0€798€1627€0€0€0€0.0346€0.0694€927€0.0578€14€1498€14€€€
N€N0003€200106€NPV€11€21€314€8346€0€8346€0€2790€3706€1850€0€0€0.0819€0.0865€4223€0.0241€20€3823€17€300€0.01€13
N€N0003€200106€NQF€11€21€282€8197€0€8197€0€3319€3533€1145€0€200€0.0463€0.0506€4778€0.0118€32€3419€10€€€
N€N0003€200106€NQS€11€21€408€13224€0€13224€0€3268€6571€3385€0€0€0.0347€0.0344€3655€0.0223€23€9235€17€334€0.04€32
N€N0003€200106€NSH€11€21€858€6351€0€6351€0€1216€4108€927€100€0€0.0297€0.0711€3151€0.0624€19€3200€18€€€
N€N0003€200106€NSI€11€21€19979€206016€700€204916€400€81854€88750€26478€8134€100€0.0272€0.053€78530€0.0423€19€115118€14€11668€0.0455€29
N€N0003€200106€NTC€11€21€242€7856€0€7856€0€2683€4673€500€0€0€0.0712€0.0692€5213€0.0129€16€2643€12€€€
N€N0003€200106€NUT€11€21€322€5170€0€5170€0€713€3916€541€0€0€0.0622€0.0767€3509€0.0365€19€1548€11€113€0.05€9
N€N0003€200106€NVN€11€21€612€17595€0€17595€0€3541€10820€1951€1283€0€0.0499€0.0528€6675€0.015€21€10105€23€815€0.0316€14
N€N0003€200106€OAT€11€21€34776€570965€4200€565465€1300€270878€204505€62275€28792€315€-0.0035€0.0499€293935€0.0578€17€213478€13€59352€0.0588€21
N€N0003€200106€OCN€11€21€3472€44482€122€44160€200€11948€15964€8555€7893€0€0.0258€0.0487€16847€0.0378€38€24518€33€2995€0.0362€41
N€N0003€200106€OECPRT€11€21€124€8598€0€8598€0€5028€2770€600€200€0€0.3548€0.3758€5885€0.0151€16€2713€9€€€
N€N0003€200106€OFC€11€21€3280€44336€0€44336€0€7456€16953€9168€10759€0€0.0255€0.0313€17630€0.0546€51€22481€36€4225€0.0178€24
N€N0003€200106€OFCPRB€11€21€252€4268€0€4268€0€240€1775€1155€700€398€0.0107€0.0926€2050€0.1197€37€2118€122€100€0.05€65
N€N0003€200106€OFCPRE€11€21€161€4805€0€4805€0€700€1725€1130€1150€100€0.1199€0.1068€2310€0.0747€57€2195€46€300€0.03€11
N€N0003€200106€OH€11€21€1273€34617€140€34377€100€9919€17741€4045€2772€0€0.0228€0.0328€14906€0.0318€32€19248€18€323€0.0286€89
N€N0003€200106€OI€11€21€7970€74739€0€74739€0€33123€30579€7601€3436€0€0.0189€0.0219€24529€0.0238€16€47287€16€2923€0.0227€21
N€N0003€200106€OIPRA€11€21€440€16193€100€16093€0€2270€6602€2439€4282€500€0.0701€0.1128€7247€0.0299€73€7547€45€1299€0.0585€54
N€N0003€200106€OMG€11€21€9728€189051€1000€186551€0€54715€91492€27624€12720€0€-0.0421€0.0607€70167€0.0623€23€97105€18€19279€0.0554€29
N€N0003€200106€OMI€11€21€6928€107087€500€106087€300€26099€48534€18229€13525€0€0.0089€0.0552€41150€0.0578€29€56474€24€8763€0.0579€42
N€N0003€200106€ONE€11€21€88089€2557497€1921€2549239€4900€1590050€761410€159619€42657€403€0.0085€0.0277€1132248€0.0266€12€1085876€9€336015€0.0315€15
N€N0003€200106€ONEPRB€11€21€11€400€0€400€0€0€200€0€200€0€1.4375€2.3875€200€0.55€91€200€18€€€
N€N0003€200106€ONEPRC€11€21€1€100€0€100€0€0€0€0€100€0€1.5€2€100€1€83€€€€€
N€N0003€200106€ONEPRT€11€21€498€29362€0€29362€0€13993€11061€3728€580€0€0.074€0.0822€11554€0.0415€15€16908€15€900€0.0289€13
N€N0003€200106€ONEPRU€11€21€385€17827€0€17827€0€6895€7268€3264€400€0€0.0987€0.1008€7272€0.0373€19€10355€15€200€0.05€22
N€N0003€200106€ONEPRV€11€21€563€23722€0€23722€0€10722€12220€400€380€0€0.0926€0.0884€13172€0.031€12€9650€13€900€0.0311€19
N€N0003€200106€OSI€11€21€12400€248089€2075€245714€300€63505€109163€44599€28147€600€0.0081€0.0554€102160€0.0585€31€123370€21€20484€0.0677€33
N€N0003€200106€OTL€11€21€3455€33973€0€33973€0€8320€18238€7115€300€0€0.0312€0.1038€11952€0.0549€18€17721€15€4300€0.2072€34
N€N0003€200106€OWC€11€21€3728€97564€400€97164€0€51956€36885€6365€1958€0€0.02€0.0286€25059€0.0166€13€64887€11€7218€0.0214€26
N€N0003€200106€PAG€11€21€1891€38597€0€38597€0€14405€16254€5316€2622€0€0.0254€0.0262€13760€0.0177€24€24337€16€500€0.016€16
N€N0003€200106€PAR€11€21€440€8752€0€8752€0€2836€4398€1118€400€0€0.0426€0.0644€3723€0.049€17€4629€33€400€0.0425€17
N€N0003€200106€PAS€11€21€12059€116739€596€115743€0€32186€50278€20265€12755€259€0.017€0.0361€55329€0.0333€31€57869€26€2545€0.0876€29
N€N0003€200106€PCEPR€11€21€433€7237€0€7237€0€1438€3578€1621€600€0€0.1028€0.1203€2378€0.0377€23€4459€27€400€0.0825€15
N€N0003€200106€PCEPRA€11€21€404€19235€0€19235€0€4495€7684€3786€3070€200€0.1077€0.1339€6197€0.0854€34€12438€40€600€0.0767€103
N€N0003€200106€PCL€11€21€7219€207041€0€205966€800€82550€84819€26006€12302€1289€0.0254€0.0518€79822€0.0285€32€112427€17€14517€0.0474€59
N€N0003€200106€PCT€11€21€370€10980€0€10980€0€1755€5233€2274€1718€0€0.0865€0.1086€4575€0.0492€32€6405€31€€€
N€N0003€200106€PDE€11€21€40611€311176€2700€307576€900€153759€109523€33382€11412€400€0.0022€0.0241€146622€0.0338€16€130255€11€31599€0.0309€23
N€N0003€200106€PECPRX€11€21€116€9116€0€9116€0€3045€5421€650€0€0€0.2263€0.253€6766€0.2323€14€2250€16€100€0.2€13
N€N0003€200106€PEP€11€21€84694€3961781€3610€3935924€19800€1877493€1559852€407217€111162€0€0.0043€0.0169€2074843€0.0276€16€1458336€12€422545€0.0302€20
N€N0003€200106€PER€11€21€9104€147898€1311€146587€0€54071€50664€20863€20325€664€0.0339€0.0494€60502€0.0331€30€70966€23€15119€0.0414€37
N€N0003€200106€PFP€11€21€67€4346€0€4346€0€611€3014€223€498€0€0.1608€0.2408€2737€0.1043€23€1609€22€€€
N€N0003€200106€PFPPR€11€21€78€1998€0€1998€0€456€1542€0€0€0€0.2503€0.3709€1060€0.1181€14€938€3€€€
N€N0003€200106€PG€11€21€93171€3286058€7562€3265296€10900€1994720€980155€234132€65839€1200€0.0104€0.0383€1509114€0.0338€12€1185301€9€581781€0.0453€20
N€N0003€200106€PGF€11€21€159€3127€0€3127€0€400€2227€500€0€0€0.0715€0.1322€200€0.1€37€2927€16€€€
N€N0003€200106€PGN€11€21€34344€803192€1050€800855€1100€395029€308406€70143€26814€1563€0.0002€0.0442€356946€0.0318€16€362495€12€82514€0.0394€21
N€N0003€200106€PHA€11€21€78871€2625800€5054€2615898€2300€1194257€945635€349082€129224€0€0.0004€0.0269€1208326€0.0303€19€1030728€13€379144€0.0395€26
N€N0003€200106€PII€11€21€6231€102532€100€102432€0€41394€47177€10024€3837€0€-0.0108€0.0656€43817€0.0617€19€50009€14€8606€0.067€21
N€N0003€200106€PIK€11€21€798€3575€0€3575€0€200€1904€349€1122€0€0.0443€0.048€2316€0.061€22€1092€112€167€0.02€177
N€N0003€200106€PIM€11€21€2066€49075€0€49075€0€24946€18678€4419€1032€0€0.021€0.0231€15250€0.0101€15€31123€13€2702€0.0172€21
N€N0003€200106€PIO€11€21€1431€20834€0€20834€0€4049€12496€3547€742€0€0.2372€0.1999€15381€0.3664€19€5353€24€100€0.03€57
N€N0003€200106€PKE€11€21€6898€119484€100€119384€0€37310€62636€13909€5529€0€-0.0061€0.0536€51032€0.0518€20€59311€16€9041€0.0835€42
N€N0003€200106€PKG€11€21€6978€146975€435€146340€200€34426€54415€28787€26474€2438€0.0148€0.0363€71171€0.0341€45€66334€34€9035€0.0866€51
N€N0003€200106€PKX€11€21€9086€142771€0€142226€200€41939€72365€20160€7962€0€0.013€0.0222€67854€0.0374€22€71279€18€3293€0.0316€36
N€N0003€200106€PLP€11€21€345€20783€0€20783€0€6623€11908€1872€380€0€0.0666€0.0736€9234€0.0405€19€9569€14€1980€0.048€16
N€N0003€200106€PNP€11€21€5806€77419€0€77419€0€21873€46990€6414€2142€0€0.0365€0.0584€39478€0.0455€17€35119€13€2822€0.0368€27
N€N0003€200106€PNW€11€21€23869€470049€2100€467443€400€193183€212965€42984€18311€400€-0.0151€0.0449€244484€0.0442€17€188356€15€35003€0.0463€22
N€N0003€200106€PPD€11€21€7092€203099€1025€199574€2500€50324€81817€41329€28104€500€0.0156€0.0512€76073€0.06€40€105458€21€20543€0.056€41
N€N0003€200106€PPP€11€21€18017€218104€600€217504€0€90001€84657€30380€12466€0€-0.0018€0.0533€86443€0.0541€21€107964€17€23097€0.0719€22
N€N0003€200106€PPPPRQ€11€21€1571€1220€0€1220€0€0€340€750€130€0€1.2195€1.2508€400€0.461€62€820€29€€€
N€N0003€200106€PTV€11€21€16802€421537€524€420713€300€130636€203286€64391€22600€100€0.0084€0.0255€219254€0.0309€20€179782€19€21977€0.0307€20
N€N0003€200106€PX€11€21€41791€968093€4342€962551€400€391045€431840€105022€34611€433€0.0036€0.0323€517464€0.0384€17€360536€15€84951€0.0418€20
N€N0003€200106€RCL€11€21€12717€192609€1279€191130€200€73260€79569€27645€10856€0€0.01€0.0309€71595€0.0366€23€106888€15€12847€0.0291€21
N€N0003€200106€RCN€11€21€11082€26769€0€26769€0€7428€11535€3395€4411€0€0.0761€0.13€9038€0.0576€40€14081€20€3650€0.0453€33
N€N0003€200106€RG€11€21€25884€70949€0€70949€0€19784€28138€8150€13587€1290€0.0487€0.0507€16009€0.0463€71€42135€29€12805€0.0254€64
N€N0003€200106€RHB€11€21€7339€256151€6400€249751€0€54702€103946€53430€37673€0€0.0063€0.1091€117310€0.0835€36€102790€26€29651€0.1028€46
N€N0003€200106€RHD€11€21€7812€166190€100€165990€0€55871€81814€20848€7457€0€0.0146€0.0431€76146€0.0406€19€82195€17€7649€0.0406€25
N€N0003€200106€RHI€11€21€19904€438400€1243€436357€800€200230€165695€49195€21787€250€0.0035€0.0378€212536€0.0402€18€187120€13€37501€0.0493€32
N€N0003€200106€RJF€11€21€10562€179628€1970€177558€100€59606€69661€26503€21888€0€0.0153€0.0605€84064€0.0491€26€80046€18€13548€0.063€43
N€N0003€200106€RL€11€21€11111€188977€400€187027€1200€51875€75446€38251€22355€300€0.0187€0.0584€80017€0.0683€29€84714€25€23496€0.0661€31
N€N0003€200106€RMG€11€21€2931€76807€0€76807€0€31060€36138€8459€1150€0€0.0365€0.0786€40447€0.0656€14€32940€14€3420€0.0411€29
N€N0003€200106€RML€11€21€7338€65767€851€64916€0€15388€24785€9913€14430€400€0.0185€0.0323€25040€0.0345€54€36262€32€3614€0.036€68
N€N0003€200106€RNS€11€21€46€3105€0€3105€0€1535€1370€200€0€0€-0.0113€0.1214€2105€0.1211€11€1000€14€€€
N€N0003€200106€ROP€11€21€6433€119636€1400€118236€0€31245€46507€21949€17566€969€-0.0259€0.0654€52276€0.0767€37€54041€26€11919€0.076€60
N€N0003€200106€ROS€11€21€1578€8810€0€8810€0€5900€2210€500€200€0€0.0236€0.0264€4960€0.0191€11€3850€15€€€
N€N0003€200106€ROV€11€21€8870€280099€300€278999€800€121057€99650€39115€18932€1045€0.0341€0.0251€165982€0.0469€20€98628€16€15189€0.0513€69
N€N0003€200106€RS€11€21€4283€74715€300€74415€0€17112€35972€16048€5283€0€0.0392€0.0486€37850€0.0445€24€31898€21€4667€0.0411€26
N€N0003€200106€RSC€11€21€1537€35415€0€35415€0€8219€17055€6911€3230€0€0.0579€0.1382€19992€0.0862€25€13593€24€1830€0.1025€40
N€N0003€200106€RTP€11€21€2903€45752€200€45552€0€14891€21771€6917€1973€0€0.0728€0.4891€17391€0.1724€22€23561€14€4600€0.5028€31
N€N0003€200106€RWT€11€21€3971€52267€0€52267€0€18388€19210€10069€4600€0€0.0662€0.0721€25393€0.0563€23€24774€18€2100€0.0438€14
N€N0003€200106€RWTPRB€11€21€53€1638€0€1638€0€100€1288€100€150€0€-0.0472€0.0114€1239€0.599€39€399€13€€€
N€N0003€200106€RYN€11€21€12725€128546€700€127446€0€34511€58160€23802€10373€600€0.0047€0.0552€52145€0.0532€29€64697€21€10604€0.0443€37
N€N0003€200106€RZT€11€21€4256€44179€0€44079€100€16442€21497€5031€1209€0€-0.0017€0.0511€18311€0.046€16€23659€13€2209€0.09€34
N€N0003€200106€SACPR€11€21€9€700€0€700€0€0€0€200€500€0€0.5386€1.1014€€€€700€86€€€
N€N0003€200106€SACPRT€11€21€120€2493€0€2493€0€320€1463€300€410€0€0.1159€0.2151€413€0.1299€17€1980€41€100€0.1€16
N€N0003€200106€SAIPRW€11€21€247€17471€0€17471€0€9608€6338€1125€400€0€0.0927€0.0907€5971€0.0183€14€11400€15€100€0.03€7
N€N0003€200106€SBG€11€21€812€23981€0€23981€0€9947€6542€3638€3554€300€0.0214€0.0256€12268€0.0161€38€11713€39€€€
N€N0003€200106€SC€11€21€18899€171378€1200€169328€600€35189€66402€34353€32589€1295€0.0253€0.0425€67572€0.0423€115€82345€33€20011€0.0432€74
N€N0003€200106€SCG€11€21€13208€174445€1450€172995€0€36451€63067€41038€31401€1038€0.0215€0.0434€73380€0.0352€39€85091€31€14524€0.0479€57
N€N0003€200106€SCL€11€21€401€4080€0€4080€0€797€977€1156€1007€143€0.0229€0.1141€1361€0.0648€33€2719€95€€€
N€N0003€200106€SCX€11€21€191€5156€0€5156€0€1378€1806€500€1472€0€0.0984€0.1732€871€0.1332€41€4185€42€100€0.14€18
N€N0003€200106€SCZ€11€21€7318€93540€0€93440€100€37105€43330€8965€4140€0€0.0186€0.0246€42050€0.032€19€49810€15€1680€0.0214€19
N€N0003€200106€SCZA€12€21€38€1667€270€1397€0€450€430€200€317€0€-3.8031€6.7545€317€1€165€1080€17€€€
N€N0003€200106€SDH€11€21€1601€41816€0€41816€0€18699€18351€3596€1170€0€0.0156€0.0167€12656€0.0124€16€28810€12€350€0.0243€60
N€N0003€200106€SGH€11€21€993€6168€0€6168€0€1085€2758€1200€1125€0€0.1017€0.1265€2783€0.0408€37€3000€41€385€0.033€9
N€N0003€200106€SGI€11€21€5965€72667€350€72017€300€24900€32188€9337€5892€0€0.0092€0.013€22488€0.0123€20€46559€19€3270€0.0143€58
N€N0003€200106€SGR€11€21€30681€1299132€35974€1259458€2700€574617€455207€144340€85394€2700€-0.0187€0.0949€654440€0.1078€20€422851€13€184867€0.1534€37
N€N0003€200106€SGU€11€21€1830€102190€475€101715€0€24400€44647€16278€15490€900€0.0525€0.0787€50870€0.0602€40€46623€28€4222€0.0301€56
N€N0003€200106€SII€11€21€79396€2461601€89352€2366784€2800€708230€989797€446578€224144€835€-0.0217€0.1034€1098122€0.0831€23€658194€17€613268€0.1146€34
N€N0003€200106€SLC€11€21€34939€102521€0€102521€0€31777€51814€14017€4913€0€0.0465€0.0498€39662€0.0221€22€51426€15€11433€0.021€27
N€N0003€200106€SLI€11€21€3881€40617€418€39999€200€9667€16424€8563€5445€100€0.0376€0.0584€15844€0.0585€43€20722€21€3633€0.0345€53
N€N0003€200106€SO€11€21€43036€1830209€2000€1815354€11800€580083€787613€325490€133214€754€0.007€0.0234€654768€0.0233€25€930696€18€241690€0.0333€29
N€N0003€200106€SOPRA€11€21€480€16715€0€16715€0€3470€8827€1949€2469€0€0.0601€0.0665€4028€0.0293€35€11087€27€1600€0.0338€30
N€N0003€200106€SOPRB€11€21€271€17925€0€17925€0€5235€6861€2834€2995€0€0.0985€0.0985€10104€0.042€50€7421€23€400€0.0375€42
N€N0003€200106€SOPRC€11€21€306€16462€0€16462€0€2966€8671€3400€1425€0€0.0695€0.0901€6935€0.0333€27€8927€25€600€0.0367€33
N€N0003€200106€SP€11€21€8355€417878€20700€395978€1000€88276€173307€84940€49425€1030€-0.1028€0.2098€199842€0.171€26€116566€21€80570€0.2007€41
N€N0003€200106€SPN€11€21€6300€100444€325€100119€0€31571€45383€12267€10898€0€0.017€0.0288€43292€0.0424€30€56427€21€400€0.015€91
N€N0003€200106€SPP€11€21€2658€51056€0€50756€300€10669€25951€9287€5149€0€0.035€0.0357€20559€0.0263€30€27662€21€2835€0.0104€42
N€N0003€200106€SRE€11€21€38345€776656€470€775086€1100€536186€219314€17703€2755€228€0.0072€0.0319€347116€0.0326€9€370017€8€59053€0.036€11
N€N0003€200106€SREPRA€11€21€318€28661€0€28661€0€5688€17888€3435€1650€0€0.148€0.1707€17662€0.1052€21€10199€21€800€0.075€20
N€N0003€200106€SSD€11€21€3721€35844€500€35344€0€9983€16926€5118€3317€0€0.0133€0.1372€17605€0.1104€33€13239€17€4500€0.1138€32
N€N0003€200106€SSR€11€21€578€19430€0€19430€0€3254€10127€4436€1013€600€0.0853€0.0911€7555€0.0238€45€11475€28€400€0.035€22
N€N0003€200106€STZ€11€21€12204€339807€2000€337207€600€85800€149849€59664€42094€400€-0.0029€0.0667€138641€0.0823€34€166570€25€32596€0.0947€42
N€N0003€200106€STZB€12€21€57€624€0€624€0€0€0€0€624€0€1.8974€2.1795€€€€400€153€224€0.25€294
N€N0003€200106€SUR€11€21€3353€31393€0€31393€0€11609€15609€2915€1260€0€0.0568€0.0639€12522€0.0329€17€17749€15€1122€0.04€22
N€N0003€200106€SUT€11€21€1820€35284€0€35084€0€12819€18577€3588€100€0€0.0201€0.0223€16575€0.0263€15€17409€13€1100€0.0291€14
N€N0003€200106€SUTPRA€11€21€196€10131€0€10131€0€1975€6048€2008€100€0€0.0368€0.1397€5027€0.083€25€5104€15€€€
N€N0003€200106€SVAPR€11€21€42€3315€0€3315€0€200€1775€1340€0€0€0.0515€0.1859€1185€0.0888€22€1930€29€200€0.05€13
N€N0003€200106€SWM€11€21€3058€25116€100€25016€0€8271€12267€3269€1209€0€0.0461€0.0897€9365€0.0636€26€13651€16€2000€0.075€24
N€N0003€200106€SZ€11€21€258€2987€0€2987€0€0€1937€900€150€0€0.0285€0.0453€500€0.03€30€2487€36€€€
N€N0003€200106€TAPPRA€11€21€636€40656€0€40656€0€9089€25026€6266€275€0€0.0569€0.0587€14590€0.0156€21€25766€17€300€0.03€15
N€N0003€200106€TAPPRB€11€21€105€5637€0€5637€0€628€4379€630€0€0€0.1076€0.112€4215€0.0363€18€1222€10€200€0.04€11
N€N0003€200106€TCC€11€21€2715€33038€0€32738€300€5154€13144€8508€6232€0€0.0327€0.0487€15161€0.0428€44€15526€27€2351€0.0516€33
N€N0003€200106€TCH€11€21€563€10532€0€10532€0€1828€7022€700€982€0€0.066€0.0697€2692€0.0298€26€7640€21€200€0.05€0
N€N0003€200106€TCLPR€11€21€281€6611€0€6611€0€2911€3700€0€0€0€0.1029€0.1033€1800€0.0339€16€4811€11€€€
N€N0003€200106€TCR€11€21€9032€64034€0€64034€0€13892€25318€11708€12916€200€0.0298€0.0366€20925€0.0261€44€38017€34€5092€0.0244€58
N€N0003€200106€TD€11€21€44798€84704€200€84504€0€26904€43499€9309€4792€0€0.0325€0.0518€30355€0.0191€20€40045€14€14104€0.0498€25
N€N0003€200106€TDI€11€21€49€5012€0€5012€0€850€2266€1175€721€0€0.0014€0.177€2011€0.0975€46€3001€24€€€
N€N0003€200106€TDR€11€21€513€4930€0€4930€0€160€4120€450€200€0€0.1722€0.1429€3070€0.0602€24€1860€18€€€
N€N0003€200106€TDY€11€21€4964€111666€327€111339€0€39645€56089€11267€4338€0€0.0014€0.0325€46693€0.0382€21€60096€14€4550€0.0372€18
N€N0003€200106€TEE€11€21€3807€93634€194€93440€0€38091€39954€10290€5205€0€0.0724€0.0979€55764€0.0522€17€33575€17€4101€0.0442€24
N€N0003€200106€TEF€11€21€21316€396187€0€395605€100€185332€137753€47922€24698€0€0.0348€0.0489€199060€0.031€21€167710€14€28935€0.0439€27
N€N0003€200106€TEM€11€21€34€975€0€975€0€375€200€400€0€0€0.2018€0.2467€300€0.1167€11€675€25€€€
N€N0003€200106€TEN€11€21€2800€70065€0€70065€0€20950€30885€10353€7877€0€0.0257€0.0338€26121€0.0405€24€39987€23€3957€0.0298€12
N€N0003€200106€TFS€11€21€8314€145212€800€143612€800€41861€68860€23910€9781€0€0.0099€0.0531€57459€0.0478€23€76318€19€10635€0.0542€23
N€N0003€200106€TGT€11€21€90495€3240598€7313€3215448€13900€1249034€1213942€478651€281570€6151€0.0055€0.0267€1754183€0.0402€22€1020458€16€454707€0.0506€33
N€N0003€200106€THX€11€21€8058€138946€400€137546€600€38790€53171€27131€18274€780€-0.0272€0.0806€45773€0.104€35€75898€24€16475€0.1466€48
N€N0003€200106€TI€11€21€6196€58047€100€57847€100€5609€27586€14591€9798€363€0.2277€0.3006€31788€0.331€46€23256€24€2903€0.1905€36
N€N0003€200106€TIA€12€23€14€3300€2600€700€0€0€0€0€700€0€-6.14€2.68€€€€700€208€€€
N€N0003€200106€TLI€11€21€486€18393€0€18393€0€5914€7198€3215€2066€0€0.0338€0.0413€4007€0.0171€38€13686€23€700€0.0357€23
N€N0003€200106€TLK€11€21€1195€9060€0€9060€0€1072€5706€1383€899€0€0.0163€0.0239€6138€0.0201€21€2922€33€€€
N€N0003€200106€TOL€11€21€15783€345725€1300€343187€300€106434€153897€54404€28752€0€0.0221€0.0455€141820€0.0581€27€171803€19€29864€0.0657€25
N€N0003€200106€TR€11€21€9367€189915€1800€188115€0€37995€79907€42395€26708€1110€0.0162€0.0758€79587€0.0422€37€92597€28€15931€0.1202€54
N€N0003€200106€TRA€11€21€3095€53919€100€53619€200€18468€22849€10610€1892€200€0.013€0.0187€18222€0.0285€24€34022€21€1575€0.0225€27
N€N0003€200106€TRP€11€21€12562€40568€300€39968€300€18516€17508€3049€1195€0€0.0232€0.0269€17545€0.0144€14€22113€14€610€0.0166€13
N€N0003€200106€TRPPR€11€21€510€18352€0€18352€0€6762€8990€2100€500€0€0.0461€0.0513€8625€0.0222€22€9527€12€200€0.03€10
N€N0003€200106€TRPPRC€11€21€137€6352€0€6352€0€3210€2942€200€0€0€0.0645€0.0643€2510€0.0303€14€3842€11€€€
N€N0003€200106€TTR€11€21€181€6839€0€6839€0€4785€1668€386€0€0€0.058€0.0552€1506€0.0338€10€5333€9€€€
N€N0003€200106€TWE€11€21€15596€116045€212€115233€600€36782€50391€20674€7986€0€0.0133€0.0223€38403€0.0222€28€69540€19€7890€0.0292€31
N€N0003€200106€TWK€11€21€8031€62550€426€62124€0€17218€21312€10709€12585€300€0.0112€0.0307€32607€0.0461€34€27617€38€1900€0.0442€41
N€N0003€200106€TX€11€21€97321€2376297€9060€2363465€2500€1397168€761431€163587€43779€0€0.0131€0.0354€1075238€0.0369€12€866775€10€423952€0.0385€15
N€N0003€200106€TXCPRA€11€21€550€35819€0€35819€0€20100€13164€1840€615€100€0.0692€0.0725€12355€0.0141€13€22764€13€700€0.0557€15
N€N0003€200106€TXCPRB€11€21€156€7489€0€7489€0€2855€3884€600€150€0€0.1133€0.1246€3550€0.0445€12€3739€19€200€0.01€22
N€N0003€200106€TXN€11€21€203098€7538253€101229€7394161€34500€2539737€2403485€1376649€1086906€21884€-0.0069€0.0401€3888049€0.0556€27€1778802€21€1761810€0.066€43
N€N0003€200106€UIS€11€21€33233€863380€300€860260€2600€520238€271865€59247€11158€352€0.0019€0.0169€410722€0.0227€12€392168€9€59970€0.0259€19
N€N0003€200106€VAP€11€21€142€5620€0€5620€0€1085€2560€500€1475€0€0.0876€0.0888€4035€0.0313€40€1485€25€100€0.02€11
N€N0003€200106€VBF€11€21€811€20011€0€20011€0€4270€7857€4087€3597€200€0.0555€0.0668€10578€0.0362€41€9233€30€200€0.02€320
N€N0003€200106€VEA€11€21€224€17329€0€17329€0€5199€9135€2195€800€0€0.0635€0.0988€8620€0.0473€19€8309€17€400€0.04€15
N€N0003€200106€VELPRT€11€21€384€9565€0€9565€0€3225€5640€600€100€0€0.1076€0.1207€5245€0.0358€15€4020€10€300€0.07€21
N€N0003€200106€VGM€11€21€363€5974€0€5974€0€2694€2750€530€0€0€0.0373€0.0349€3386€0.0109€14€2588€12€€€
N€N0003€200106€VGR€11€21€5617€95521€600€94921€0€26817€43606€15460€8788€250€0.0653€0.1196€39410€0.111€32€46153€19€9358€0.0972€28
N€N0003€200106€VIG€11€21€133€2057€0€2057€0€389€1668€0€0€0€0.03€0.0391€800€0.0125€10€1157€10€100€0.01€13
N€N0003€200106€VIN€11€21€276€6807€0€6807€0€2456€1434€892€2025€0€0.0319€0.0312€2010€0.013€41€4797€48€€€
N€N0003€200106€VIT€11€21€545€12624€0€12624€0€7444€4875€305€0€0€0.036€0.0359€6412€0.0114€11€5887€8€325€0.01€8
N€N0003€200106€VNV€11€21€211€2270€0€2270€0€780€1190€300€0€0€0.0572€0.0457€538€0.01€26€1732€10€€€
N€N0003€200106€VOD€11€21€39993€1514065€2700€1506152€4300€792257€578419€118150€21426€200€0.0127€0.0158€842187€0.0218€14€579386€10€88879€0.0263€17
N€N0003€200106€VOL€11€21€2011€20551€0€20551€0€5757€10161€2999€1534€100€0.0559€0.0808€10322€0.0528€27€8844€20€1385€0.0453€26
N€N0003€200106€VOT€11€21€231€6573€0€6573€0€2658€3686€229€0€0€0.0452€0.0539€2850€0.0175€15€2968€10€755€0.01€23
N€N0003€200106€VPA€11€21€187€9050€0€9050€0€1907€5339€1300€504€0€0.0648€0.0632€5957€0.0343€22€3093€18€€€
N€N0003€200106€VPQ€11€21€221€8868€0€8868€0€2747€4560€686€875€0€0.0484€0.0517€3903€0.0212€19€4965€23€€€
N€N0003€200106€VRC€11€21€30663€721772€1186€719800€600€264831€294864€105814€54891€0€-0.0091€0.045€286261€0.0307€21€317784€20€116355€0.0471€28
N€N0003€200106€VSH€11€21€32551€439313€1600€434513€3200€160494€181677€67281€28161€100€0.0057€0.0236€201249€0.0324€22€186762€16€49702€0.0348€26
N€N0003€200106€VVC€11€21€13148€178642€300€178342€0€45864€72830€35634€23102€912€0.0164€0.0386€69059€0.0436€36€101042€24€8241€0.0549€69
N€N0003€200106€VVR€11€21€3157€83284€0€83284€0€28751€37822€13076€3635€0€0.0123€0.013€15688€0.0125€22€66309€18€1287€0.01€29
N€N0003€200106€WFR€11€21€4276€55333€0€55133€200€19295€21918€7154€6214€752€0.0271€0.0502€20319€0.0448€40€31596€17€3418€0.0496€22
N€N0003€200106€WG€11€21€2459€43323€200€43123€0€7887€16391€10247€8498€100€0.0451€0.0786€26932€0.0573€40€12256€37€3935€0.0413€33
N€N0003€200106€WLP€11€21€41220€613165€3600€607565€1800€224212€285602€70528€28442€581€0.0052€0.0537€307476€0.0591€19€225772€15€76117€0.0715€21
N€N0003€200106€WNI€11€21€69€620€0€620€0€100€320€200€0€0€0.029€0.0194€420€0.0333€11€200€39€€€
N€N0003€200106€WSM€11€21€18497€335089€7400€327689€0€107654€147769€43968€28298€0€-0.02€0.0431€146297€0.0509€24€138437€17€42955€0.0611€38
N€N0003€200106€WTS€11€21€2185€25867€0€25867€0€9094€10894€4105€1774€0€0.0222€0.0725€13047€0.0591€24€12620€23€200€0.01€8
N€N0003€200106€XRX€11€21€45334€1563755€1500€1551990€9300€899430€518310€111272€32278€0€0.0048€0.0141€589903€0.0185€14€835374€9€136013€0.0244€21
N€N0003€200106€XVF€11€21€1738€63667€300€63367€0€20329€30220€10193€2625€0€0.1756€0.2107€36209€0.0865€21€24028€17€3130€0.1246€6
N€N0003€200106€YLD€11€21€1237€13280€0€13280€0€5464€4515€2276€1025€0€0.0185€0.0193€3096€0.0162€19€9884€23€300€0.01€7
N€N0003€200106€YUM€11€21€32965€681270€15304€663764€1800€124966€222082€150777€158519€9220€-0.0154€0.025€322286€0.0381€48€259741€38€83537€0.0503€67
N€N0003€200106€ZIF€11€21€469€9335€0€9335€0€3943€4592€700€100€0€0.0331€0.0384€4741€0.018€12€4594€17€€€
N€N0003€200106€ZMX€11€21€74€2620€0€2620€0€0€1999€353€268€0€0.0441€0.0335€1979€0.0469€24€641€47€€€'

	EXEC -t'€' -k 4,4 -lsum,op=average:integer:7 $data/euro.dat
		OUTPUT - $'N€N0003€200106€AA€11€21€ 4320€3524300€9331€3494983€15500€1129332€1283396€639798€452298€5659€0.0021€0.0289€1717663€0.038€30€1195358€20€597462€0.0481€35
N€N0003€200106€AAT€11€21€23€14046€0€14046€0€7421€4549€1485€591€0€0.0314€0.0304€2513€0.01€25€11333€14€200€0.01€90
N€N0003€200106€ABJ€11€21€12€14508€0€14508€0€2603€9175€1650€1080€0€0.0756€0.0779€6636€0.0136€17€7872€25€€€
N€N0003€200106€ABS€11€21€2033€1465605€200€1461410€2900€483622€651665€241738€87165€120€0.0097€0.0284€599869€0.0306€22€670152€18€194289€0.0373€25
N€N0003€200106€ABT€11€21€ 5000€3368858€8904€3347422€10900€1469987€1273455€447558€166267€1055€0.0041€0.0273€1682138€0.0365€18€1150749€14€525435€0.044€25
N€N0003€200106€ACA€11€21€11€11490€0€11490€0€2845€7495€100€1050€0€0.0908€0.0946€5052€0.0146€17€6438€22€€€
N€N0003€200106€ACS€11€21€1161€523323€13500€509523€0€192518€202103€71973€42229€700€-0.0264€0.0658€254514€0.0654€21€177869€17€77140€0.0915€38
N€N0003€200106€AEF€11€21€ 58€61757€0€61757€0€9524€22881€15536€13616€200€0.0418€0.0464€24867€0.0137€47€35248€43€1642€0.0401€27
N€N0003€200106€AET€11€21€1049€472785€900€471531€300€213068€162069€63465€32949€280€0.0069€0.0217€214120€0.0315€22€224763€16€32948€0.035€26
N€N0003€200106€AGC€11€21€2185€1443428€2747€1438956€1000€588445€574302€188125€88940€0€0.0076€0.0283€603123€0.0256€22€661220€16€175613€0.0329€31
N€N0003€200106€AGCPRA€11€21€18€16339€0€16339€0€3810€5914€4990€1625€0€0.1073€0.1187€7461€0.11€44€8678€25€200€0.085€8
N€N0003€200106€AGCPRB€11€21€18€6853€0€6853€0€100€3855€1550€1348€0€0.1382€0.115€3097€0.0587€44€3756€46€€€
N€N0003€200106€AGCPRM€11€21€22€15702€100€15602€0€1685€7911€3046€2170€790€0.0762€0.0876€4071€0.0247€64€11031€65€500€0.078€166
N€N0003€200106€AGCPRMCL€11€21€3€1223€0€1223€0€0€923€300€0€0€0.04€0.04€1223€0.01€22€€€€€
N€N0003€200106€AGCPRN€11€21€14€18338€0€18338€0€5186€8423€2223€2306€200€0.0895€0.0967€2885€0.0334€65€15203€23€250€0.046€21
N€N0003€200106€AGCPRNCL€11€21€3€665€0€665€0€100€565€0€0€0€0.01€0.01€€€€665€21€€€
N€N0003€200106€AGI€11€21€14€4879€0€4879€0€730€2761€1388€0€0€0.0154€0.0238€4099€0.0433€19€780€29€€€
N€N0003€200106€AHO€11€21€274€101764€100€101464€200€25120€56355€13898€6291€0€0.0582€0.061€51772€0.043€22€43731€19€6161€0.0371€23
N€N0003€200106€AIV€11€21€515€143764€0€143464€0€58036€56027€19187€10214€0€0.0376€0.0629€54117€0.0484€20€80319€20€9028€0.0438€29
N€N0003€200106€AIVPRC€11€21€10€5998€0€5998€0€2025€2725€948€300€0€0.1019€0.1098€2675€0.0259€25€3023€15€300€0.09€37
N€N0003€200106€AIVPRD€11€21€19€15180€0€15180€0€5430€8025€825€900€0€0.1032€0.1226€6105€0.0322€15€8975€24€100€0.04€12
N€N0003€200106€AIVPRG€11€21€18€12295€0€12295€0€3195€6435€1315€1350€0€0.084€0.0783€3675€0.0122€30€7920€24€700€0.0343€32
N€N0003€200106€AIVPRH€11€21€ 8€5959€0€5959€0€2100€3074€785€0€0€0.075€0.1345€2824€0.0322€13€3035€18€100€0.11€9
N€N0003€200106€AIVPRK€11€21€4€2070€0€2070€0€0€1070€600€400€0€0.2686€0.4413€1350€0.1863€48€720€20€€€
N€N0003€200106€AIVPRP€11€21€11€11916€0€11916€0€3681€4873€2148€1214€0€0.1826€0.2129€3376€0.0379€23€8540€26€€€
N€N0003€200106€AIVPRQ€11€21€19€10242€0€10242€0€3898€5497€327€520€0€0.0807€0.0792€4613€0.0174€19€5629€13€€€
N€N0003€200106€AJG€11€21€743€196649€600€196049€0€80999€79015€21230€12954€1851€0.0292€0.0426€79215€0.0366€26€106810€13€10024€0.0518€45
N€N0003€200106€ALM€11€21€86€9137€0€9137€0€300€7876€961€0€0€0.0497€0.0618€7139€0.0245€19€1998€15€€€
N€N0003€200106€ALPPRN€11€21€2€1290€0€1290€0€0€890€400€0€0€0€0.181€400€0.05€16€890€21€€€
N€N0003€200106€ALPPRO€11€21€2€1700€0€1700€0€0€1700€0€0€0€0.0159€0.2247€950€0.0621€26€750€18€€€
N€N0003€200106€ALPPRQ€11€21€ 8€7400€0€7400€0€2517€4483€400€0€0€0.0703€0.0795€3496€0.0287€17€3904€11€€€
N€N0003€200106€ALPPRR€11€21€11€12186€0€12186€0€2223€8511€1152€300€0€0.0695€0.0713€4546€0.0179€18€7540€15€100€0.04€63
N€N0003€200106€ALQ€11€21€17€14947€0€14947€0€5706€7091€2050€100€0€0.088€0.0864€8607€0.0231€21€6040€12€300€0.01€7
N€N0003€200106€ALZ€11€21€10€10019€0€10019€0€800€8563€656€0€0€0.0994€0.1095€6749€0.0256€19€3270€13€€€
N€N0003€200106€AMB€11€21€464€82057€0€81694€0€49345€26444€3944€1961€0€0.0218€0.029€37759€0.0248€12€40635€11€3300€0.0224€15
N€N0003€200106€AMBPRA€11€21€ 7€5460€0€5460€0€3560€1700€200€0€0€0.0574€0.1091€3300€0.0473€10€2160€13€€€
N€N0003€200106€AMD€11€21€ 7929€4782471€105767€4655665€17300€1343670€1809871€952933€564656€1635€-0.01€0.0399€2160554€0.0464€24€1180503€21€1331908€0.0601€37
N€N0003€200106€ANN€11€21€ 743€308613€7500€301013€100€160173€110558€25319€5063€0€-0.0095€0.0525€131184€0.0608€13€134861€10€35068€0.0762€17
N€N0003€200106€AOC€11€21€1584€740421€1545€737685€900€213132€304297€146622€73959€575€0.0001€0.0241€340231€0.0367€28€337678€21€60676€0.0378€34
N€N0003€200106€ARB€11€21€369€81559€300€81259€0€24043€40724€12568€3924€0€0.0259€0.0549€39589€0.0546€22€36715€18€4955€0.0477€23
N€N0003€200106€ARH€11€21€7€1815€0€1815€0€400€1115€100€200€0€0.0357€0.0527€1190€0.0182€31€625€19€€€
N€N0003€200106€ATI€11€21€ 672€204221€195€204026€0€95949€86063€15394€6520€100€0.011€0.0249€88367€0.0285€16€109155€13€6504€0.0249€20
N€N0003€200106€AVP€11€21€1977€1025278€1664€1021714€1300€640871€320330€47980€12801€1032€-0.0027€0.0305€463631€0.0358€10€466899€8€92484€0.0454€15
N€N0003€200106€AVZ€11€21€217€42999€0€42899€100€15985€19543€6471€1000€0€0.1208€0.1957€20702€0.1167€19€19355€14€2942€0.0663€19
N€N0003€200106€AXL€11€21€138€43442€0€43442€0€11343€20974€6885€4240€0€0.0524€0.0834€21281€0.0732€30€20822€22€1339€0.0249€14
N€N0003€200106€AZA€11€21€3604€777156€5600€770456€500€475253€227074€51985€16512€132€0.0081€0.0359€346051€0.0248€11€287853€9€137052€0.035€17
N€N0003€200106€AZZ€11€21€ 62€30688€0€30688€0€5454€17696€5938€1600€0€0.0621€0.0925€17081€0.0713€24€12107€24€1500€0.0293€20
N€N0003€200106€BC€11€21€1058€347438€2150€344388€900€119326€140853€55052€29034€1023€0.0049€0.0287€151059€0.0335€27€165409€19€28820€0.0421€28
N€N0003€200106€BCC€11€21€1481€232534€1500€231034€0€90880€102617€27338€10199€0€0.0026€0.0495€86498€0.0425€21€123377€15€21159€0.0489€20
N€N0003€200106€BD€11€21€169€26224€200€26024€0€8210€15964€1850€0€0€0.0081€0.0147€10370€0.0141€12€14654€13€1000€0.014€21
N€N0003€200106€BDF€11€21€12€9620€0€9620€0€3229€4243€1738€410€0€0.0458€0.0565€2903€0.0136€13€6717€23€€€
N€N0003€200106€BGG€11€21€481€164711€600€163823€0€76597€68590€14556€4080€0€0.0223€0.0874€65955€0.0439€16€85847€11€12021€0.0977€21
N€N0003€200106€BGT€11€21€27€15473€0€15473€0€8014€5024€1985€450€0€0.015€0.0185€3385€0.01€10€12088€14€€€
N€N0003€200106€BK€11€21€ 4897€3340606€5800€3332030€800€2109454€974660€195186€53530€0€-0.0055€0.0372€1548826€0.0305€11€1273475€9€510529€0.0417€16
N€N0003€200106€BKE€11€21€ 90€18544€0€18544€0€3788€12093€2226€437€0€0.0169€0.0528€10301€0.0694€18€7843€20€400€0.035€15
N€N0003€200106€BKPRC€11€21€17€17897€0€17897€0€10855€5842€850€350€0€0.0804€0.0857€8767€0.0274€15€8630€11€500€0.028€7
N€N0003€200106€BKPRD€11€21€20€21826€0€21826€0€13055€7571€500€700€0€0.0658€0.0714€10371€0.0168€11€11155€14€300€0.08€18
N€N0003€200106€BKPRE€11€21€16€23243€0€23243€0€10876€10497€1470€400€0€0.076€0.0832€15715€0.0205€15€7528€12€€€
N€N0003€200106€BLI€11€21€ 548€227952€1609€226143€100€75627€104943€33926€11747€0€0.0094€0.0263€112032€0.0332€20€104908€17€9303€0.0328€22
N€N0003€200106€BNI€11€21€2525€1206018€400€1203328€1600€680896€414696€85020€23178€1138€0.0049€0.0285€588392€0.0262€13€511908€10€104628€0.0403€19
N€N0003€200106€BR€11€21€3217€1378982€4900€1370416€2000€687207€493400€131614€58722€1473€0.0112€0.0302€782525€0.0406€16€459377€12€130514€0.0503€29
N€N0003€200106€BRG€11€21€51€11360€0€11360€0€2143€6614€1791€812€0€0.1021€0.1699€6410€0.118€29€4850€22€100€0.1€63
N€N0003€200106€BSP€11€21€14€4791€0€4791€0€1745€2537€509€0€0€0.0816€0.0835€2054€0.0143€14€2337€15€400€0.045€9
N€N0003€200106€BTY€11€21€ 555€203914€400€203314€200€78459€82586€27485€14884€100€0.0731€0.1174€111376€0.0744€24€78300€16€13838€0.0657€24
N€N0002€200106€BTYRT€11€21€ 63€50506€0€50506€0€19517€24313€3320€3356€0€0.1058€0.1598€32175€0.1498€23€17731€14€600€0.055€20
N€N0003€200106€BWG€11€21€44€6512€0€6512€0€1183€4379€650€300€0€0.0722€0.1734€4366€0.0936€24€2046€21€100€0.08€0
N€N0003€200106€BXS€11€21€212€33939€0€33939€0€14334€13818€5063€724€0€-0.002€0.0378€17439€0.042€14€15418€17€1082€0.0204€22
N€N0003€200106€BYD€11€21€154€35218€200€35018€0€8011€13121€6471€7115€300€0.0349€0.0426€12541€0.0321€37€19449€44€3028€0.0338€50
N€N0003€200106€BZL€11€21€ 8€2330€0€2330€0€1000€400€530€400€0€0.0741€0.0748€1130€0.04€53€800€8€400€0.02€7
N€N0003€200106€C€11€21€10601€7798662€31303€7747379€16900€3563357€2481386€1113981€603003€2552€0.0063€0.0228€4246991€0.0389€19€2228824€15€1288464€0.0463€33
N€N0003€200106€CBM€11€21€465€194272€2240€191632€0€63286€89872€27044€11430€0€0.0026€0.1101€81401€0.0814€22€85841€16€24390€0.132€30
N€N0003€200106€CCC€11€21€167€43832€300€43532€0€9359€19019€8257€6297€600€0.0433€0.0488€20746€0.0443€44€20283€29€2503€0.0202€39
N€N0003€200106€CCPPRA€11€21€13€13025€0€13025€0€2350€7424€2707€544€0€0.1786€0.3285€5751€0.0625€18€6774€26€500€0.058€17
N€N0003€200106€CCR€11€21€1920€728090€6800€719678€1000€267653€271128€122720€59077€100€-0.0069€0.0301€346880€0.0381€22€277870€18€95928€0.0488€30
N€N0003€200106€CEA€11€21€ 6€2229€0€2229€0€300€1601€328€0€0€0.0891€0.1549€928€0.031€17€1201€16€100€0.01€16
N€N0003€200106€CED€11€21€374€25925€300€25625€0€5812€12625€5838€1350€0€0.1071€0.108€13523€0.0484€25€10252€19€1850€0.043€36
N€N0003€200106€CEM€11€21€206€30385€0€30385€0€6560€16100€6125€1600€0€0.0332€0.0917€15567€0.0682€23€13468€23€1350€0.0337€30
N€N0003€200106€CEN€11€21€467€110436€0€110236€200€45363€46318€11486€6969€300€0.0197€0.0306€50010€0.0344€21€55025€14€5401€0.0262€38
N€N0003€200106€CF€11€21€1351€639764€3248€634316€1500€182374€248718€123189€77927€3608€0.01€0.0254€286515€0.033€30€282454€22€66847€0.0282€49
N€N0003€200106€CFE€11€21€7€1684€0€1684€0€1300€100€284€0€0€0.1609€0.1669€984€0.25€18€700€8€€€
N€N0003€200106€CFN€11€21€ 8€4234€0€4234€0€1018€1116€1300€800€0€0.0738€0.0828€1200€0.3967€71€3034€26€€€
N€N0003€200106€CGPPRG€12€21€223€5400€4900€500€0€0€100€200€200€0€-1.076€0.184€200€0.75€80€300€33€€€
N€N0003€200106€CGPPRI€11€21€177€750€0€750€0€0€200€0€400€150€-0.6333€0.026€550€0.7182€511€200€23€€€
N€N0003€200106€CGPPRT€11€21€25€9711€0€9711€0€3766€4598€1147€200€0€0.0709€0.0734€2517€0.0372€15€7042€15€152€0.01€24
N€N0003€200106€CHD€11€21€518€132464€1359€131105€0€52672€55896€14149€7853€535€0.0327€0.0634€55486€0.0467€19€68291€17€7328€0.0501€27
N€N0003€200106€CHH€11€21€199€54062€0€53762€0€17816€21767€9596€4583€0€0.0255€0.0552€26188€0.0734€31€23562€16€4012€0.0527€16
N€N0002€200106€CHTRT€11€21€ 4€3174€0€3174€0€160€0€320€2375€319€0.0599€0.0609€1735€0.0113€116€1439€198€€€
N€N0002€200106€CHTRTWI€12€24€2€5000€0€5000€0€0€0€5000€0€0€-0.02€0.04€€€€5000€31€€€
N€N0003€200106€CIC€11€21€ 45€49613€0€49613€0€12025€25301€7518€4769€0€0.0555€0.0656€15733€0.0419€22€33280€25€600€0.0533€62
N€N0003€200106€CIP€11€21€27€22418€0€22418€0€4677€16266€1050€425€0€0.0692€0.0745€11685€0.0212€16€10033€16€700€0.0229€12
N€N0003€200106€CIR€11€21€188€57557€600€56957€0€24724€23479€6114€2640€0€-0.0348€0.0568€31783€0.0736€16€21547€14€3627€0.1043€30
N€N0003€200106€CKC€11€21€101€29607€0€29607€0€9386€15183€3387€1651€0€0.0419€0.0255€7241€0.0637€30€21486€17€880€0.0327€46
N€N0003€200106€CKH€11€21€313€88089€0€88089€0€41269€36261€7618€2941€0€0.0003€0.0825€32140€0.0668€15€48565€12€7384€0.0821€18
N€N0003€200106€CLB€11€21€311€122678€600€122078€0€25245€56302€22564€17297€670€0.0619€0.0714€57167€0.0743€39€58510€25€6401€0.0322€58
N€N0003€200106€CLJ€11€21€141€38026€0€38026€0€5116€17590€8934€6386€0€0.0573€0.0909€17649€0.0682€43€19877€32€500€0.042€67
N€N0003€200106€CLL€11€21€28€8406€300€8106€0€1238€4650€1785€433€0€0.1254€0.2263€3948€0.1524€16€3958€24€200€0.29€58
N€N0003€200106€CMO€11€21€253€106712€0€106312€400€43418€52504€8949€1841€0€0.0355€0.0488€53463€0.043€16€49371€12€3878€0.0384€11
N€N0003€200106€CMOPRA€11€21€10€3043€0€3043€0€1294€850€599€300€0€0.5313€0.3056€1249€0.5695€35€1794€16€€€
N€N0003€200106€CMOPRB€11€21€14€10036€0€10036€0€3886€4894€915€341€0€0.1375€0.13€3128€0.0804€19€6528€19€380€0.01€14
N€N0003€200106€CMP€11€21€ 93€73395€0€73395€0€17955€42915€9935€2590€0€0.0915€0.1083€20714€0.0277€19€48680€18€4001€0.0559€33
N€N0003€200106€CMS€11€21€1101€430340€888€427110€2000€222679€168912€27920€9599€0€0.0123€0.0312€192319€0.0264€13€205993€11€30798€0.0334€18
N€N0003€200106€CMSPRJ€11€21€ 7€6005€0€6005€0€975€4230€800€0€0€0.1592€0.2442€3930€0.0288€18€1775€17€300€0.1€17
N€N0003€200106€CMSPRK€11€21€11€9399€0€9399€0€800€7649€950€0€0€0.1539€0.2479€2575€0.0399€17€6124€18€700€0.1843€12
N€N0003€200106€CMSPRL€11€21€30€9413€0€9413€0€2016€4977€2005€415€0€0.1458€0.1851€4199€0.0565€24€4814€22€400€0.1€37
N€N0003€200106€CMSPRM€11€21€61€1698€0€1698€0€0€1398€0€300€0€0.3066€0.3419€1398€0.0949€20€€€300€0.25€156
N€N0003€200106€CMSPRN€11€21€ 7€4241€0€4241€0€523€2258€1260€200€0€0.0387€0.0779€3641€0.0212€28€600€9€€€
N€N0003€200106€CNA€11€21€437€155244€0€154844€400€57125€83968€12351€1800€0€0.0374€0.0546€66722€0.0293€14€80492€10€8030€0.033€17
N€N0003€200106€CNL€11€21€704€129633€100€129233€300€70295€48666€7529€3043€0€0.027€0.0612€53723€0.0363€14€69264€10€6546€0.0487€18
N€N0003€200106€CNN€11€21€41€4852€0€4852€0€2531€1646€200€475€0€0.0395€0.038€3087€0.0285€13€1765€48€€€
N€N0003€200106€COE€11€21€30€5098€0€5098€0€1085€1178€1635€1200€0€0.0263€0.0358€1785€0.0243€33€3313€59€€€
N€N0003€200106€COG€11€21€635€131188€1478€129510€200€31708€55095€27764€14801€342€0.0097€0.0433€60097€0.0666€32€60933€24€8680€0.0682€51
N€N0003€200106€CPD€11€21€23€9634€0€9634€0€4435€3309€1640€250€0€0.0402€0.0417€7584€0.0444€18€2050€11€€€
N€N0003€200106€CPP€11€21€ 6€3230€0€3230€0€900€1350€980€0€0€0.1574€0.1737€900€0.0567€28€2330€18€€€
N€N0003€200106€CPRE€11€21€19€23321€0€23321€0€2550€15745€3669€1357€0€0.0703€0.0674€13212€0.0199€26€9709€18€400€0.1€41
N€N0003€200106€CPRF€11€21€3€1100€0€1100€0€0€900€0€200€0€0.1932€0.3159€250€0.48€23€850€28€€€
N€N0003€200106€CPRG€11€21€2€1326€0€1326€0€0€764€562€0€0€0.3991€0.4987€664€0.1324€29€662€30€€€
N€N0003€200106€CPRH€11€21€2€1320€0€1320€0€0€600€720€0€0€0.3235€0.422€920€0.1978€23€400€59€€€
N€N0003€200106€CPRK€11€21€ 9€11084€0€11084€0€500€7692€2092€600€200€0.2122€0.2243€5553€0.0862€41€5131€29€400€0.165€32
N€N0003€200106€CPRM€11€21€ 3€2226€0€2226€0€339€960€727€200€0€0.3019€0.5577€1580€0.2241€29€446€18€200€0.25€38
N€N0003€200106€CPRN€11€21€15€11091€0€11091€0€2000€7226€1205€660€0€0.0681€0.0632€5145€0.0127€21€5946€26€€€
N€N0003€200106€CPRQ€11€21€2€1200€0€1200€0€0€500€700€0€0€0.5€0.5625€400€0.05€31€600€21€200€0.1€22
N€N0003€200106€CPRR€11€21€2€500€0€500€0€0€300€0€200€0€0.502€0.602€300€0.03€26€200€72€€€
N€N0003€200106€CPRU€11€21€ 4€3145€0€3145€0€200€1745€800€400€0€0.4211€0.5192€1470€0.0813€20€1675€47€€€
N€N0003€200106€CPRW€11€21€ 41€54632€0€54632€0€10698€29850€9542€4142€400€0.0671€0.0715€24025€0.0144€27€30207€31€400€0.04€21
N€N0003€200106€CPRX€11€21€ 35€45053€400€44653€0€9460€26551€5112€3530€0€0.056€0.0603€19055€0.0159€31€25098€22€500€0.044€106
N€N0003€200106€CQPRA€11€21€20€19210€0€19210€0€5594€9166€3275€1175€0€0.1281€0.1641€10230€0.0347€18€8480€27€500€0.08€40
N€N0003€200106€CRM€11€21€12€1000€0€1000€0€0€300€0€700€0€0.132€-0.057€500€0.81€65€500€66€€€
N€N0003€200106€CRY€11€21€ 398€234595€3650€230145€500€98877€107261€19489€5018€0€-0.0028€0.1235€91095€0.097€16€107036€12€32514€0.1306€20
N€N0003€200106€CSL€11€21€613€142404€860€141544€0€43960€64987€21866€10199€532€0.0098€0.0624€60868€0.0381€24€68088€17€12588€0.0475€27
N€N0003€200106€CSP€11€21€19€11788€0€11188€600€4305€5430€1114€939€0€0.0331€0.0379€3505€0.0229€13€8183€24€100€0.02€14
N€N0003€200106€CVC€11€21€ 739€300546€2400€297846€0€124254€143338€23288€6966€0€-0.0109€0.0522€119404€0.0584€16€145555€12€32887€0.052€19
N€N0003€200106€CVD€11€21€500€215338€1250€212285€1000€63619€102151€34471€13044€0€0.0155€0.0433€91877€0.0469€22€107181€19€14227€0.0438€27
N€N0003€200106€CW€11€21€53€11629€0€11629€0€1568€7271€1704€1086€0€-0.039€0.1445€5531€0.0981€29€5598€18€500€0.082€24
N€N0003€200106€CWN€11€21€239€59776€200€59176€400€10708€28045€14206€6517€100€0.0301€0.0268€23025€0.035€36€35286€30€1265€0.0361€38
N€N0003€200106€CWNPRA€11€21€ 8€5460€0€5460€0€1280€2775€1105€300€0€0.0251€0.1623€2850€0.0813€21€2610€29€€€
N€N0003€200106€CYE€11€21€ 57€44347€0€44047€300€11950€16310€9270€6567€250€0.0261€0.029€15808€0.0208€39€28139€28€400€0.03€68
N€N0003€200106€D€11€21€2900€1219758€2220€1216438€1100€899099€288283€25052€5104€0€-0.0017€0.0547€587917€0.0449€8€463592€7€166029€0.0507€10
N€N0003€200106€DCP€11€21€143€23882€0€23882€0€6845€13962€2650€425€0€0.5272€0.4252€14729€0.1923€19€9153€17€€€
N€N0003€200106€DCS€11€21€68€4646€100€4546€0€826€1934€886€900€0€0.0456€0.0374€646€0.0154€28€3900€39€€€
N€N0003€200106€DDF€11€21€ 39€34631€104€34527€0€7804€18014€5335€3374€0€0.06€0.0619€12217€0.0453€22€21810€22€500€0.01€12
N€N0003€200106€DFG€11€21€327€57038€0€57038€0€27051€22775€5339€1873€0€0.0073€0.0532€24654€0.036€18€28384€11€4000€0.0359€16
N€N0003€200106€DGX€11€21€1522€1005363€24875€978733€1100€406700€402320€118543€51365€905€-0.0253€0.1035€454631€0.1058€20€354981€15€170221€0.1344€24
N€N0003€200106€DHY€11€21€67€15511€0€15511€0€3644€6401€3456€1868€142€0.0168€0.0212€5804€0.0202€39€9407€33€300€0.01€39
N€N0003€200106€DJM€11€21€5€830€0€830€0€400€430€0€0€0€0.1148€0.1004€430€0.01€22€400€4€€€
N€N0003€200106€DLX€11€21€ 828€281299€2671€278216€300€71701€103284€50590€50913€2028€0.0145€0.0344€101971€0.0331€40€151551€33€24994€0.05€48
N€N0003€200106€DNB€11€21€421€207241€100€207141€0€97114€83577€20796€5654€0€0.0274€0.0423€106479€0.0315€16€90982€12€9680€0.0268€21
N€N0003€200106€DNR€11€21€322€73429€101€72428€900€27435€35656€7906€2331€0€0.0198€0.0339€30182€0.0324€16€39174€15€3972€0.0371€19
N€N0003€200106€DNY€11€21€1038€380145€100€379832€0€216298€132793€19890€10851€0€0.013€0.0381€156676€0.0298€13€193479€12€29677€0.0313€15
N€N0003€200106€DPRA€11€21€ 38€35911€0€35911€0€16642€14590€3109€1570€0€0.0942€0.1137€13725€0.0222€17€20986€15€1200€0.0733€17
N€N0003€200106€DSU€11€21€125€76624€280€76344€0€28055€28115€11749€8425€0€0.0227€0.0231€27021€0.0138€28€48009€27€1314€0.0163€34
N€N0003€200106€DT€11€21€2897€446775€1300€444775€700€253675€148003€35543€8254€0€0.0139€0.0166€202363€0.0184€12€202306€10€40806€0.0204€23
N€N0003€200106€DV€11€21€638€149804€900€148704€200€53027€64825€19880€10136€1036€0.01€0.0764€65449€0.0428€22€72670€17€10785€0.0449€21
N€N0003€200106€EAS€11€21€544€158503€600€157500€0€70724€51100€22068€13608€0€0.0203€0.0322€57187€0.035€26€94069€17€6244€0.0266€40
N€N0003€200106€ED€11€21€1557€765164€1625€760880€1700€269390€288368€128899€73604€4061€0.0023€0.0326€315254€0.0402€32€364869€20€82457€0.0417€45
N€N0003€200106€EDE€11€21€198€54956€0€54856€100€22840€24852€6013€1251€100€0.0248€0.0399€26989€0.0521€15€25555€16€2412€0.0353€19
N€N0003€200106€EDEPRD€11€21€ 8€4917€0€4917€0€900€2790€1127€100€0€0.0789€0.0871€4417€0.1058€19€300€26€200€0.06€31
N€N0003€200106€EDL€11€21€20€24045€0€24045€0€4069€14154€4450€1372€0€0.0875€0.0953€4642€0.0249€30€17298€22€2105€0.0329€18
N€N0003€200106€EDO€11€21€322€150405€2000€148405€0€48400€64713€22279€12513€500€0.0238€0.0571€72066€0.0717€23€66460€15€9879€0.0961€31
N€N0003€200106€EDPRA€11€21€ 9€3320€0€3320€0€500€1950€400€470€0€0.3342€0.8095€1820€0.7951€31€1200€27€300€0.4167€28
N€N0003€200106€EFL€11€21€11€4491€0€4491€0€1783€2333€275€100€0€0.1172€0.1064€3238€0.0392€14€1253€18€€€
N€N0003€200106€ELN€11€21€1968€1698154€28233€1658521€9800€591927€749792€247952€77850€800€0.0024€0.0376€896938€0.0543€20€574910€16€196473€0.0643€24
N€N0003€200106€ELNWSA€11€21€369€15924€0€15924€0€2530€8535€2849€2010€0€0.706€0.618€9810€0.2236€33€5214€14€900€0.1233€61
N€N0003€200106€ELNWSB€11€21€107€3710€0€3710€0€950€1510€800€450€0€0.6193€1.0969€2100€0.5145€54€1410€12€200€0.79€20
N€N0003€200106€EMC€11€21€14071€9897171€68202€9782039€39300€3244345€4085888€1836849€651461€1701€0.006€0.0249€5060991€0.0472€22€2257708€15€2502640€0.0544€30
N€N0003€200106€EMD€11€21€ 7€3634€0€3634€0€200€2219€700€515€0€0.1069€0.0971€1119€0.0607€21€2515€31€€€
N€N0003€200106€EPG€11€21€ 4432€3812438€35121€3757321€15900€1178720€1457845€694790€424248€17468€0.0012€0.0318€2175190€0.0565€26€985314€20€612717€0.0627€36
N€N0003€200106€EPGPR€11€21€2€589€0€589€0€0€0€100€489€0€0.8351€1.1746€489€0.234€91€100€142€€€
N€N0003€200106€EPGPRC€11€21€260€1800€0€1800€0€0€200€800€400€400€0.9539€1.6667€500€0.298€99€900€253€400€1.05€42
N€N0003€200106€EPI€11€21€ 24€33956€200€33756€0€10726€15906€5444€1680€0€0.0689€0.0843€13803€0.0236€22€19153€19€800€0.0238€21
N€N0003€200106€EPL€11€21€221€76532€0€76232€300€31698€32628€8058€4148€0€0.0225€0.039€33547€0.0448€20€41085€15€1900€0.0384€30
N€N0003€200106€EPN€11€21€341€207403€200€207003€200€67977€98548€24636€15492€550€0.015€0.0573€111443€0.0584€22€85320€22€10440€0.0449€39
N€N0003€200106€ESI€11€21€ 551€263316€10079€252937€200€72537€103484€43898€32168€1050€-0.0044€0.0683€113865€0.0789€32€107821€21€31451€0.1062€56
N€N0003€200106€ETA€11€21€13€6305€0€6305€0€800€3730€1385€390€0€0.0416€0.0437€3350€0.023€24€2855€29€100€0.04€38
N€N0003€200106€EX€11€21€199€36259€200€36059€0€11720€18552€4551€1236€0€0.0152€0.0391€16262€0.0377€21€18701€14€1096€0.0338€35
N€N0003€200106€FC€11€21€93€7273€0€7273€0€2340€3733€1100€100€0€0.0509€0.0469€4128€0.0602€21€3045€11€100€0.02€14
N€N0003€200106€FCX€11€21€1124€477507€0€477007€500€224775€186859€45247€20626€0€0.0095€0.0182€200039€0.0292€19€251445€13€26023€0.0258€17
N€N0003€200106€FCXA€11€21€423€43156€440€42716€0€15376€22763€3384€1049€144€0.0347€0.0382€23814€0.0421€19€17487€13€1415€0.0248€40
N€N0003€200106€FCXPRA€11€21€32€18015€0€18015€0€5645€7438€3682€1250€0€0.0671€0.0635€11571€0.0507€23€6444€22€€€
N€N0003€200106€FCXPRB€11€21€30€14738€0€14738€0€3662€8961€1765€350€0€0.0779€0.1379€5695€0.0608€21€9043€19€€€
N€N0003€200106€FCXPRC€11€21€19€4202€0€4202€0€0€2202€1700€300€0€0.0778€0.1058€1100€0.0409€35€3102€25€€€
N€N0003€200106€FCXPRD€11€21€10€7878€0€7878€0€754€6474€650€0€0€0.0569€0.0839€4508€0.0431€17€3370€19€€€
N€N0003€200106€FE€11€21€1769€852395€1200€849495€600€440011€305729€80238€22433€1684€0.0002€0.0259€297521€0.0334€15€484823€12€67751€0.0391€18
N€N0003€200106€FLR€11€21€1527€566592€10100€554892€1000€189895€244194€85222€36481€100€-0.0088€0.062€286010€0.0751€20€184057€16€85825€0.1055€33
N€N0003€200106€FMC€11€21€1567€300685€6100€294585€0€119860€125954€33675€15096€0€-0.0114€0.06€158560€0.0587€18€100317€17€35708€0.0695€31
N€N0003€200106€FO€11€21€1008€497417€300€496617€200€263838€184257€39171€9551€0€0.0121€0.0459€217394€0.0347€13€239890€11€39533€0.0497€21
N€N0003€200106€FOE€11€21€526€125134€506€124228€0€44257€57903€16669€5399€0€0.005€0.0377€56458€0.0374€20€61161€16€6609€0.0451€19
N€N0003€200106€FOPRA€13€21€1€300€300€0€0€0€0€0€0€0€0€€€€€€€€€
N€N0003€200106€FOR€11€21€39€12184€0€12184€0€8401€3433€350€0€0€0.03€0.0292€7012€0.0142€10€5172€7€€€
N€N0003€200106€FPCPRA€11€21€21€22202€0€22202€0€9105€6257€2976€3864€0€0.0873€0.1081€10106€0.0562€28€12096€34€€€
N€N0003€200106€FRC€11€21€215€47308€200€47108€0€11567€14565€9783€10893€300€0.0397€0.0645€16764€0.0702€53€24944€38€5400€0.1115€77
N€N0003€200106€FSH€11€21€425€195393€1100€194093€200€78546€81804€23834€10409€0€-0.0134€0.0717€92235€0.068€22€89125€14€12933€0.0638€25
N€N0003€200106€FTI€11€21€ 226€362127€100€361927€100€145638€148580€54179€13530€100€0.0288€0.0225€195780€0.0546€19€152912€17€13335€0.0439€26
N€N0003€200106€FWJ€11€21€4€900€0€900€0€0€900€0€0€0€0.1167€0.1167€300€0.1€18€600€20€€€
N€N0003€200106€GBE€11€21€10€4475€0€4475€0€1148€1629€814€884€0€0.052€0.0771€2092€0.049€30€2083€24€300€0.05€49
N€N0003€200106€GCG€11€21€6€900€0€900€0€400€0€100€400€0€-0.0011€-0.0011€700€0.0443€57€200€0€€€
N€N0003€200106€GDP€11€21€49€4550€0€4550€0€1660€2414€476€0€0€0.0751€0.0799€1889€0.0255€18€2261€11€400€0.015€11
N€N0003€200106€GGT€11€21€104€24322€0€24322€0€9040€11256€3414€612€0€0.0735€0.0914€9010€0.0369€16€14434€18€878€0.0613€14
N€N0003€200106€GGTPR€11€21€5€2302€0€2302€0€400€1602€300€0€0€0.2183€0.2422€200€0.02€8€2102€16€€€
N€N0003€200106€GID€11€21€3€600€0€600€0€100€300€200€0€0€0.0667€0.0133€600€0.05€28€€€€€
N€N0003€200106€GK€11€21€115€17156€0€17156€0€1750€7742€4376€3062€226€-0.0365€0.0597€9137€0.0484€35€6619€55€1400€0.0421€52
N€N0003€200106€GLC€11€21€1015€310305€2700€306105€1100€88027€135891€55266€26942€1079€0.0057€0.0268€152886€0.0322€25€129221€21€25098€0.0498€30
N€N0003€200106€GLG€11€21€206€51489€0€51089€400€30501€17462€3225€301€0€0.0271€0.0265€13063€0.0168€11€37509€11€917€0.0151€7
N€N0003€200106€GLH€11€21€207€45051€0€45051€0€15566€21649€5843€1993€0€0.1176€0.143€14705€0.0661€23€28551€15€1795€0.0261€21
N€N0003€200106€GLW€11€21€ 7813€6854173€13360€6798713€38700€3855589€2284747€586994€109468€615€0.001€0.0136€3112503€0.0242€12€2413309€9€1311601€0.0273€18
N€N0003€200106€GPB€11€21€20€26231€0€26231€0€4691€15476€4364€1700€0€0.0888€0.0968€14042€0.057€21€11889€26€300€0.0167€53
N€N0003€200106€GPD€11€21€16€13433€0€13433€0€7588€5845€0€0€0€0.1493€0.1593€7865€0.0481€10€5268€10€300€0.1€9
N€N0003€200106€GPEPRA€11€21€18€17189€0€17189€0€7510€8831€848€0€0€0.1012€0.1118€10268€0.0573€13€6921€10€€€
N€N0003€200106€GPEPRT€11€21€14€14799€400€14399€0€6781€6318€1100€200€0€0.0676€0.0711€6620€0.0196€18€7779€8€€€
N€N0003€200106€GPEPRU€11€21€13€12589€0€12589€0€4059€8135€395€0€0€0.1495€0.1653€7537€0.0333€12€5052€11€€€
N€N0003€200106€GPEPRV€11€21€11€7953€0€7953€0€1966€4966€1021€0€0€0.1438€0.1588€4145€0.0421€17€3508€19€300€0.0733€14
N€N0003€200106€GPF€11€21€11€5986€0€5986€0€1030€3571€925€460€0€0.1227€0.1622€1540€0.0802€23€4446€26€€€
N€N0003€200106€GPU€11€21€ 964€331935€1599€329136€500€179273€123240€20383€6540€200€0.0195€0.0418€164349€0.0434€12€136469€11€28818€0.0411€15
N€N0003€200106€GRA€11€21€111€50998€0€50998€0€21532€22718€6164€584€0€0.0138€0.0143€18821€0.0151€17€31361€14€816€0.0202€6
N€N0003€200106€GRB€11€21€164€27554€0€27554€0€5052€13374€6620€2508€0€0.0005€0.0295€12715€0.0593€26€13418€28€1421€0.0244€47
N€N0003€200106€GUPPRA€11€21€ 5€4554€0€4554€0€350€4204€0€0€0€0.0982€0.1284€2809€0.1062€13€1745€14€€€
N€N0003€200106€GUPPRB€11€21€ 6€5484€0€5484€0€550€4584€350€0€0€0.159€0.1667€3784€0.0723€15€1700€11€€€
N€N0003€200106€HAR€11€21€444€148497€1800€146597€100€34515€73133€27304€11745€0€-0.0186€0.0552€68766€0.0854€26€67117€23€10814€0.1312€22
N€N0003€200106€HAS€11€21€ 706€438982€100€437882€1000€174135€192970€53185€18592€0€0.0166€0.0301€246768€0.0269€17€172621€16€19493€0.0313€24
N€N0003€200106€HCN€11€21€437€177141€0€175441€800€59204€72907€26587€16813€730€0.0226€0.034€81716€0.0317€27€85715€20€8810€0.0327€45
N€N0003€200106€HCNPRB€11€21€16€10125€0€10125€0€2217€4841€2284€783€0€0.0938€0.1173€6825€0.0796€25€2900€37€400€0.05€14
N€N0003€200106€HGR€11€21€25€7668€0€7668€0€2203€2650€1915€900€0€0.0445€0.0502€2915€0.0361€44€4653€19€100€0.02€8
N€N0003€200106€HIL€11€21€66€12938€0€12938€0€3997€7419€1222€300€0€0.0276€0.0221€7891€0.0332€15€4547€15€500€0.026€18
N€N0003€200106€HIW€11€21€754€201813€138€201675€0€124564€67892€7219€1700€300€0.0216€0.0302€92008€0.0319€10€101169€9€8498€0.0282€18
N€N0003€200106€HIWPRB€11€21€14€13382€0€13382€0€3770€8212€1000€400€0€0.1157€0.1308€9665€0.0841€16€3717€18€€€
N€N0003€200106€HIWPRD€11€21€19€13883€0€13883€0€3676€7969€2238€0€0€0.1125€0.1521€8843€0.0724€17€4640€16€400€0.055€9
N€N0003€200106€HMA€11€21€1092€285451€0€284551€900€120298€111741€35184€17878€350€0.0064€0.0185€153353€0.0329€22€115598€15€16500€0.0365€33
N€N0003€200106€HMC€11€21€219€61763€0€61763€0€23757€28584€7033€2389€0€0.1082€0.1751€29459€0.1755€21€28592€13€3712€0.0987€30
N€N0003€200106€HMT€11€21€ 913€248392€300€245792€2300€101541€107186€25592€12063€1710€0.0127€0.0155€123922€0.0207€20€115408€14€8762€0.018€59
N€N0003€200106€HMTPRA€11€21€18€10915€0€10915€0€2225€7190€1100€400€0€0.0923€0.1225€4130€0.0509€12€6285€19€500€0.086€42
N€N0003€200106€HMTPRB€11€21€18€12320€0€12320€0€4705€5465€1700€450€0€0.0738€0.0985€7575€0.0284€16€4545€23€200€0.1€18
N€N0003€200106€HMTPRC€11€21€35€16685€0€16685€0€4440€10635€1280€330€0€0.0792€0.0897€7385€0.018€21€8900€13€400€0.05€7
N€N0003€200106€HON€11€21€ 7512€4537992€36160€4486970€11800€2162439€1652916€496192€184563€2660€-0.0203€0.0359€2222825€0.0602€16€1376974€12€898971€0.0831€26
N€N0003€200106€HOV€11€21€360€107289€200€106689€300€46229€49915€7595€3250€0€0.0423€0.0621€47328€0.0482€16€52446€13€7215€0.0522€15
N€N0003€200106€HZO€11€21€54€4175€0€4175€0€1240€2184€200€551€0€0.0338€0.039€1809€0.0585€30€2366€22€€€
N€N0003€200106€ICS€11€21€8€1506€0€1506€0€0€1506€0€0€0€0.0529€0.0675€770€0.0113€10€736€16€€€
N€N0003€200106€IDG€11€21€ 4€2461€0€2461€0€319€1494€648€0€0€0.0047€0.1105€1813€0.0317€11€€€648€0.1€38
N€N0003€200106€IEU€11€21€ 7€4255€0€4255€0€255€3200€400€400€0€0.1078€0.2366€1555€0.0971€15€2700€36€€€
N€N0003€200106€IFX€11€21€1612€155517€1600€152017€400€57220€65935€19363€9549€350€0.0046€0.1008€54177€0.0564€21€66889€15€31351€0.0759€27
N€N0003€200106€IGL€11€21€680€187910€400€187210€300€46812€77036€38157€24596€909€0.01€0.0177€77292€0.0227€36€101416€23€8802€0.0292€38
N€N0003€200106€IML€11€21€76€6306€0€6306€0€857€3090€1110€945€304€0.0974€0.1118€4214€0.0282€50€1335€44€757€0.0617€87
N€N0003€200106€IQM€11€21€15€9088€0€9088€0€3112€3224€1533€1219€0€0.032€0.0412€2795€0.0247€19€6163€27€130€0.02€15
N€N0003€200106€IR€11€21€2154€759241€2050€754499€2100€278603€313443€122486€41102€1380€0.0004€0.0277€384981€0.0303€20€301091€17€70527€0.0412€26
N€N0003€200106€ISP€11€21€134€20875€0€20875€0€5474€11352€2541€1508€0€0.0352€0.0493€11155€0.0345€20€8420€19€1300€0.0331€33
N€N0003€200106€ITG€11€21€ 584€235115€3900€231115€100€71405€116744€30416€12650€0€-0.0315€0.0835€110607€0.0695€22€102156€15€18452€0.1072€32
N€N0003€200106€ITN€11€21€245€78922€429€78493€0€38979€31129€6358€2027€0€0.0211€0.0448€27960€0.0329€13€45177€12€5356€0.037€20
N€N0003€200106€ITT€11€21€1289€286838€300€285930€500€109564€148979€23443€4444€0€0.0162€0.0516€134635€0.0453€15€131715€12€20080€0.0523€18
N€N0003€200106€ITX€11€21€145€16878€200€16678€0€3675€9192€2450€1361€0€0.0283€0.0615€5862€0.039€25€7799€16€3017€0.0462€32
N€N0003€200106€ITXPR€11€21€2€1738€0€1738€0€199€729€450€360€0€0.2329€0.3264€888€0.2684€41€700€45€150€0.5€10
N€N0003€200106€IVC€11€21€380€109326€0€109042€0€56256€39484€9774€3528€0€0.0119€0.0595€52292€0.0707€14€49763€14€6987€0.0589€23
N€N0003€200106€JBL€11€21€ 3264€2021224€38650€1976374€5600€828342€716374€280748€152377€4133€-0.0168€0.0406€978092€0.0497€20€664172€15€339710€0.0735€35
N€N0003€200106€JCP€11€21€1616€923275€3200€917192€2600€476919€354391€69553€17871€1058€0.0032€0.027€417906€0.0348€15€412601€11€89285€0.0462€17
N€N0003€200106€JEM€11€21€ 9€3691€0€3691€0€2595€846€250€0€0€0.0709€0.0709€650€0.0162€17€3041€8€€€
N€N0003€200106€JOE€11€21€320€109132€100€108932€100€37049€49203€13005€9415€360€0.0362€0.0545€30081€0.028€28€72812€20€6139€0.0361€55
N€N0003€200106€JYPPRZ€11€21€29€8294€0€8294€0€3987€2853€1454€0€0€0.075€0.0813€2801€0.0214€12€5093€17€400€0.055€13
N€N0003€200106€KBH€11€21€1231€396444€1900€393544€700€235578€135787€19031€3612€236€0.0173€0.052€158530€0.0436€12€201018€9€34696€0.062€18
N€N0003€200106€KBHPRG€12€23€18€4000€3800€200€0€0€200€0€0€0€-0.2€0.25€€€€200€18€€€
N€N0003€200106€KBHPRI€11€21€24€1870€0€1870€0€670€1200€0€0€0€0.0917€0.1165€600€0.0233€10€1270€11€€€
N€N0003€200106€KEG€11€21€ 677€219955€1787€218168€0€79979€96492€29441€11905€351€0.0066€0.0309€96876€0.0251€21€100725€18€20567€0.0376€30
N€N0003€200106€KEI€11€21€ 468€304821€3399€301422€0€107761€129096€42537€22028€0€-0.0197€0.0795€140598€0.0738€21€117736€18€43088€0.0839€31
N€N0003€200106€KG€11€21€1940€1031366€8400€1021866€1100€454412€432306€107139€28667€442€-0.0191€0.0377€522352€0.0555€16€392279€13€108335€0.069€18
N€N0003€200106€KLU€11€21€ 74€33466€0€33466€0€12755€16840€3321€550€0€0.0379€0.052€13916€0.0403€14€18540€14€1010€0.01€16
N€N0003€200106€KMB€11€21€ 3031€2164410€4955€2150133€7000€686439€883329€387441€193491€6433€-0.0002€0.0322€1162179€0.0422€24€704899€21€290055€0.0583€29
N€N0003€200106€KOR€11€21€55€5566€0€5566€0€1145€2746€600€1075€0€0.0353€0.0425€3656€0.0338€26€1910€33€€€
N€N0003€200106€KPA€11€21€239€63086€0€62586€500€27584€24830€7518€3154€0€0.0283€0.0301€18392€0.0203€18€41710€16€2984€0.0191€24
N€N0003€200106€KPAPRA€11€21€19€8841€0€8841€0€2025€3910€800€2106€0€0.1962€0.2095€2760€0.056€50€5456€28€625€0.1156€16
N€N0003€200106€KRJ€11€21€3€1150€0€1150€0€300€850€0€0€0€0.0652€0.113€600€0.0833€18€550€14€€€
N€N0003€200106€KTB€11€21€ 6€6825€0€6825€0€1200€3975€850€800€0€0.0992€0.1024€4475€0.0597€29€2350€20€€€
N€N0003€200106€KTP€11€21€ 35€29875€0€29875€0€11654€14076€3720€425€0€0.026€0.1111€13092€0.0381€17€15603€15€1180€0.0632€17
N€N0003€200106€KYO€11€21€353€90772€0€90472€300€44067€39611€5763€1331€0€0.2892€0.3294€39291€0.1462€13€44089€12€7392€0.1991€15
N€N0003€200106€LBI€11€21€9€1540€0€1540€0€200€1090€250€0€0€0.0072€0.0645€713€0.121€22€827€15€€€
N€N0003€200106€LDP€11€21€103€16330€0€16330€0€4713€7895€1543€2179€0€0.0597€0.0814€6311€0.0355€21€9254€26€765€0.0413€41
N€N0003€200106€LMM€11€21€3€1340€0€1340€0€400€450€490€0€0€0.0192€0.0192€210€0.0257€18€1130€27€€€
N€N0003€200106€LMS€11€21€110€8949€0€8949€0€1605€5269€1025€1050€0€-0.0062€0.0789€5069€0.0544€32€3770€16€110€0.02€12
N€N0003€200106€LMT€11€21€2126€1539221€2321€1534598€1500€813099€498258€155630€68871€240€0.0089€0.038€652816€0.0387€18€731392€12€151890€0.0449€19
N€N0003€200106€LNT€11€21€ 592€241025€0€240325€700€74986€120488€33823€11428€300€0.0151€0.0345€72301€0.0345€18€155939€17€12785€0.0238€23
N€N0003€200106€LRY€11€21€543€157798€0€156898€900€63418€75594€14717€4069€0€0.0192€0.0361€80555€0.0294€15€73460€14€3783€0.0312€21
N€N0003€200106€LRYPRA€11€21€30€11239€0€11239€0€5040€5074€675€450€0€0.1234€0.1347€2244€0.0408€19€8795€14€200€0.05€24
N€N0003€200106€LSHPRA€11€21€30€8884€0€8884€0€1777€4625€1100€1382€0€0.0941€0.1001€4602€0.0332€34€4282€29€€€
N€N0003€200106€MAG€11€21€154€40664€100€40564€0€11519€19271€7942€1832€0€0.0271€0.034€18625€0.0561€21€21026€17€913€0.0264€46
N€N0003€200106€MAR€11€21€1805€852217€3439€847777€500€327186€338792€115285€64394€2620€-0.0021€0.0336€371175€0.0377€23€376069€17€101033€0.0395€25
N€N0003€200106€MAT€11€21€1913€1269034€600€1265555€2400€804303€370087€74517€19048€0€0.017€0.0286€536799€0.0232€12€603833€9€127323€0.0268€17
N€N0003€200106€MCC€11€21€63€15602€100€15502€0€3391€5930€2640€3441€100€0.0695€0.1551€10231€0.1351€48€3496€48€1775€0.1344€50
N€N0003€200106€MCO€11€21€ 964€482050€300€481050€0€205260€224512€38524€12754€0€0.0064€0.0344€232157€0.0449€16€218413€12€30480€0.0506€21
N€N0003€200106€MCT€11€21€138€18905€300€18605€0€6170€8860€2500€1175€0€0.1805€0.2168€10070€0.0931€22€7035€21€1500€0.0993€18
N€N0003€200106€MDG€11€21€654€44774€100€44574€100€18941€16881€6899€1953€0€0.0197€0.0379€17024€0.0225€15€23758€15€3892€0.029€43
N€N0003€200106€MEE€11€21€ 824€209709€1746€206463€1500€66383€99319€28763€13498€0€0.0036€0.0405€111328€0.0591€22€81354€18€15281€0.0622€27
N€N0003€200106€MEH€11€21€174€48319€0€48319€0€14334€23793€6423€3769€0€0.0076€0.0701€17902€0.0429€26€24568€19€5849€0.046€31
N€N0003€200106€MER€11€21€ 8920€6760165€79577€6655420€22100€3730194€2256343€498914€187021€5048€0.0048€0.0551€3050308€0.0476€13€1925818€9€1701394€0.066€19
N€N0003€200106€MERPRA€11€21€11€19057€0€19057€0€7062€8478€2817€700€0€0.0955€0.101€10546€0.0317€22€8411€15€100€0.02€24
N€N0003€200106€MERPRB€11€21€18€20512€0€20512€0€6773€11414€1925€400€0€0.0952€0.0985€12232€0.0367€16€7980€17€300€0.01€11
N€N0003€200106€MERPRC€11€21€14€18441€0€18441€0€4795€11057€1582€1007€0€0.1116€0.1103€11160€0.0386€24€7181€16€100€0.07€17
N€N0003€200106€MERPRD€11€21€ 44€50455€0€50455€0€18698€26565€3992€1200€0€0.0661€0.0677€28689€0.0208€17€21266€15€500€0.026€20
N€N0003€200106€MERPRE€11€21€19€24866€0€24866€0€7807€13364€1525€2170€0€0.0603€0.0673€17369€0.0194€23€7497€26€€€
N€N0003€200106€MERPRF€11€21€ 47€64465€0€64465€0€22971€30739€8030€2725€0€0.0545€0.0566€35833€0.0187€19€27832€19€800€0.025€12
N€N0003€200106€MFW€11€21€25€7466€0€7466€0€2841€4113€512€0€0€0.0188€0.0181€2029€0.0623€12€5437€14€€€
N€N0003€200106€MGF€11€21€41€16120€0€16120€0€6543€8899€500€178€0€0.0194€0.0166€3887€0.0103€17€12233€12€€€
N€N0003€200106€MHN€11€21€25€10018€0€10018€0€5361€3632€1025€0€0€0.0233€0.0315€3926€0.014€17€5792€10€300€0.0133€16
N€N0003€200106€MIM€11€21€11€1347€0€1347€0€275€672€200€200€0€0.0974€0.1074€140€0.13€24€1207€26€€€
N€N0003€200106€MLI€11€21€297€69963€100€69763€100€19462€27043€13949€9309€100€0.0019€0.0273€31833€0.0706€30€34350€30€3680€0.0433€50
N€N0003€200106€MLM€11€21€688€204799€300€204099€400€61064€95095€32619€15821€300€0.0101€0.0477€80241€0.0608€24€108917€20€15341€0.0475€23
N€N0003€200106€MLS€11€21€384€206055€0€205855€200€74780€98864€22395€10016€0€0.0448€0.065€79217€0.0297€20€113979€14€12859€0.0332€28
N€N0003€200106€MMA€11€21€ 54€41547€0€41347€200€6120€18982€11510€4935€0€0.0685€0.0759€18868€0.0622€31€22479€28€200€0.01€42
N€N0003€200106€MMC€11€21€3350€1504024€4800€1496324€2400€848935€524310€93936€31240€303€-0.0049€0.0776€737970€0.0635€14€537240€9€223514€0.0759€16
N€N0003€200106€MMR€11€21€126€24452€0€24452€0€4408€14201€3524€2319€0€0.0558€0.0584€10071€0.0532€24€13468€26€913€0.0605€21
N€N0003€200106€MMS€11€21€ 385€318955€1900€315905€900€106853€137298€48809€23545€300€0.0373€0.0495€180240€0.06€24€113201€20€23364€0.0565€33
N€N0003€200106€MOT€11€21€ 5698€3328170€5844€3311576€8100€1598352€1234943€389062€96669€650€0.0033€0.0107€1631510€0.0236€17€1229766€10€458400€0.0247€21
N€N0003€200106€MOTPRA€11€21€ 48€54690€0€54690€0€19492€24106€8167€2925€0€0.0856€0.0898€30541€0.0284€23€23749€17€400€0.025€16
N€N0003€200106€MPPRD€11€21€7€1975€0€1975€0€300€775€900€0€0€0.1489€0.2923€1600€0.04€28€375€14€€€
N€N0003€200106€MRX€11€21€ 541€320344€8637€310782€200€63174€159322€56740€29946€1800€-0.0397€0.0942€133022€0.0768€30€134927€24€43033€0.1141€30
N€N0003€200106€MSF€11€21€21€9509€0€9509€0€2112€6131€766€200€300€0.0557€0.0626€3761€0.0423€15€5748€16€€€
N€N0003€200106€MTN€11€21€149€22165€0€21965€200€4845€12736€2407€2177€0€0.0748€0.0896€11127€0.0907€28€10716€22€322€0.1€10
N€N0003€200106€MTTPRX€11€21€ 8€5969€0€5969€0€850€4879€240€0€0€0.1796€0.1935€3074€0.1643€18€2895€13€€€
N€N0003€200106€MTX€11€21€540€141623€0€140313€0€59229€61833€11244€8007€0€-0.0148€0.062€55775€0.0467€18€74506€17€10032€0.0553€28
N€N0003€200106€MUC€11€21€43€9273€0€9273€0€3762€3999€400€1112€0€0.0208€0.0279€5611€0.0146€17€3262€42€400€0.01€6
N€N0003€200106€MUJ€11€21€22€8266€0€8266€0€3118€4948€200€0€0€0.0242€0.0292€4991€0.0126€15€3275€10€€€
N€N0003€200106€MUO€11€21€48€10408€0€10408€0€2493€6074€1116€725€0€0.0495€0.0519€3863€0.0223€24€6345€13€200€0.06€140
N€N0003€200106€MYI€11€21€ 66€32319€0€32319€0€11642€14632€3472€2373€200€0.0321€0.0318€11728€0.0141€29€20291€17€300€0.01€18
N€N0003€200106€NAV€11€21€1011€207641€200€206594€300€100039€87977€14008€4870€0€-0.0035€0.0271€94076€0.027€14€101550€12€11268€0.0438€17
N€N0003€200106€NC€11€21€261€70933€0€70933€0€24172€40012€5599€1150€0€0.0198€0.1476€27278€0.0952€18€37888€11€5767€0.0974€18
N€N0003€200106€NCI€11€21€240€36300€0€36300€0€12555€13153€5331€4291€970€0.0303€0.0448€13065€0.0375€23€21642€25€1593€0.0567€119
N€N0003€200106€NDE€11€21€ 685€252703€3500€248903€200€62581€105339€52043€27991€1149€0.0116€0.0427€103869€0.041€28€124648€23€20586€0.0692€57
N€N0003€200106€NEU€11€21€1045€434722€5500€427622€500€148279€190275€58105€31463€0€-0.019€0.0733€193603€0.0723€25€172307€15€62212€0.0672€31
N€N0003€200106€NMA€11€21€21€13504€0€13504€0€2868€6470€2799€1367€0€0.0282€0.033€1804€0.0319€18€11350€29€350€0.01€41
N€N0003€200106€NMI€11€21€17€5888€0€5888€0€2227€2881€580€200€0€0.064€0.0667€4313€0.0145€18€1575€13€€€
N€N0003€200106€NMK€11€21€ 429€308307€100€307707€400€114811€128594€41825€22677€200€0.0157€0.0191€97748€0.016€23€190283€18€20076€0.0143€28
N€N0003€200106€NMKPRK€11€21€3€100€0€100€0€100€0€0€0€0€0.75€0.75€€€€100€9€€€
N€N0003€200106€NMT€11€21€14€5072€0€5072€0€507€4032€133€400€0€0.0567€0.0602€2876€0.023€19€2196€23€€€
N€N0003€200106€NPC€11€21€11€2425€0€2425€0€798€1627€0€0€0€0.0346€0.0694€927€0.0578€14€1498€14€€€
N€N0003€200106€NPV€11€21€18€8346€0€8346€0€2790€3706€1850€0€0€0.0819€0.0865€4223€0.0241€20€3823€17€300€0.01€13
N€N0003€200106€NQF€11€21€16€8197€0€8197€0€3319€3533€1145€0€200€0.0463€0.0506€4778€0.0118€32€3419€10€€€
N€N0003€200106€NQS€11€21€21€13224€0€13224€0€3268€6571€3385€0€0€0.0347€0.0344€3655€0.0223€23€9235€17€334€0.04€32
N€N0003€200106€NSH€11€21€57€6351€0€6351€0€1216€4108€927€100€0€0.0297€0.0711€3151€0.0624€19€3200€18€€€
N€N0003€200106€NSI€11€21€998€206016€700€204916€400€81854€88750€26478€8134€100€0.0272€0.053€78530€0.0423€19€115118€14€11668€0.0455€29
N€N0003€200106€NTC€11€21€15€7856€0€7856€0€2683€4673€500€0€0€0.0712€0.0692€5213€0.0129€16€2643€12€€€
N€N0003€200106€NUT€11€21€16€5170€0€5170€0€713€3916€541€0€0€0.0622€0.0767€3509€0.0365€19€1548€11€113€0.05€9
N€N0003€200106€NVN€11€21€30€17595€0€17595€0€3541€10820€1951€1283€0€0.0499€0.0528€6675€0.015€21€10105€23€815€0.0316€14
N€N0003€200106€OAT€11€21€1738€570965€4200€565465€1300€270878€204505€62275€28792€315€-0.0035€0.0499€293935€0.0578€17€213478€13€59352€0.0588€21
N€N0003€200106€OCN€11€21€173€44482€122€44160€200€11948€15964€8555€7893€0€0.0258€0.0487€16847€0.0378€38€24518€33€2995€0.0362€41
N€N0003€200106€OECPRT€11€21€12€8598€0€8598€0€5028€2770€600€200€0€0.3548€0.3758€5885€0.0151€16€2713€9€€€
N€N0003€200106€OFC€11€21€172€44336€0€44336€0€7456€16953€9168€10759€0€0.0255€0.0313€17630€0.0546€51€22481€36€4225€0.0178€24
N€N0003€200106€OFCPRB€11€21€16€4268€0€4268€0€240€1775€1155€700€398€0.0107€0.0926€2050€0.1197€37€2118€122€100€0.05€65
N€N0003€200106€OFCPRE€11€21€10€4805€0€4805€0€700€1725€1130€1150€100€0.1199€0.1068€2310€0.0747€57€2195€46€300€0.03€11
N€N0003€200106€OH€11€21€ 63€34617€140€34377€100€9919€17741€4045€2772€0€0.0228€0.0328€14906€0.0318€32€19248€18€323€0.0286€89
N€N0003€200106€OI€11€21€398€74739€0€74739€0€33123€30579€7601€3436€0€0.0189€0.0219€24529€0.0238€16€47287€16€2923€0.0227€21
N€N0003€200106€OIPRA€11€21€23€16193€100€16093€0€2270€6602€2439€4282€500€0.0701€0.1128€7247€0.0299€73€7547€45€1299€0.0585€54
N€N0003€200106€OMG€11€21€512€189051€1000€186551€0€54715€91492€27624€12720€0€-0.0421€0.0607€70167€0.0623€23€97105€18€19279€0.0554€29
N€N0003€200106€OMI€11€21€346€107087€500€106087€300€26099€48534€18229€13525€0€0.0089€0.0552€41150€0.0578€29€56474€24€8763€0.0579€42
N€N0003€200106€ONE€11€21€ 4404€2557497€1921€2549239€4900€1590050€761410€159619€42657€403€0.0085€0.0277€1132248€0.0266€12€1085876€9€336015€0.0315€15
N€N0003€200106€ONEPRB€11€21€1€400€0€400€0€0€200€0€200€0€1.4375€2.3875€200€0.55€91€200€18€€€
N€N0003€200106€ONEPRC€11€21€1€100€0€100€0€0€0€0€100€0€1.5€2€100€1€83€€€€€
N€N0003€200106€ONEPRT€11€21€ 27€29362€0€29362€0€13993€11061€3728€580€0€0.074€0.0822€11554€0.0415€15€16908€15€900€0.0289€13
N€N0003€200106€ONEPRU€11€21€25€17827€0€17827€0€6895€7268€3264€400€0€0.0987€0.1008€7272€0.0373€19€10355€15€200€0.05€22
N€N0003€200106€ONEPRV€11€21€29€23722€0€23722€0€10722€12220€400€380€0€0.0926€0.0884€13172€0.031€12€9650€13€900€0.0311€19
N€N0003€200106€OSI€11€21€ 620€248089€2075€245714€300€63505€109163€44599€28147€600€0.0081€0.0554€102160€0.0585€31€123370€21€20484€0.0677€33
N€N0003€200106€OTL€11€21€172€33973€0€33973€0€8320€18238€7115€300€0€0.0312€0.1038€11952€0.0549€18€17721€15€4300€0.2072€34
N€N0003€200106€OWC€11€21€186€97564€400€97164€0€51956€36885€6365€1958€0€0.02€0.0286€25059€0.0166€13€64887€11€7218€0.0214€26
N€N0003€200106€PAG€11€21€ 94€38597€0€38597€0€14405€16254€5316€2622€0€0.0254€0.0262€13760€0.0177€24€24337€16€500€0.016€16
N€N0003€200106€PAR€11€21€24€8752€0€8752€0€2836€4398€1118€400€0€0.0426€0.0644€3723€0.049€17€4629€33€400€0.0425€17
N€N0003€200106€PAS€11€21€602€116739€596€115743€0€32186€50278€20265€12755€259€0.017€0.0361€55329€0.0333€31€57869€26€2545€0.0876€29
N€N0003€200106€PCEPR€11€21€24€7237€0€7237€0€1438€3578€1621€600€0€0.1028€0.1203€2378€0.0377€23€4459€27€400€0.0825€15
N€N0003€200106€PCEPRA€11€21€20€19235€0€19235€0€4495€7684€3786€3070€200€0.1077€0.1339€6197€0.0854€34€12438€40€600€0.0767€103
N€N0003€200106€PCL€11€21€360€207041€0€205966€800€82550€84819€26006€12302€1289€0.0254€0.0518€79822€0.0285€32€112427€17€14517€0.0474€59
N€N0003€200106€PCT€11€21€28€10980€0€10980€0€1755€5233€2274€1718€0€0.0865€0.1086€4575€0.0492€32€6405€31€€€
N€N0003€200106€PDE€11€21€2030€311176€2700€307576€900€153759€109523€33382€11412€400€0.0022€0.0241€146622€0.0338€16€130255€11€31599€0.0309€23
N€N0003€200106€PECPRX€11€21€10€9116€0€9116€0€3045€5421€650€0€0€0.2263€0.253€6766€0.2323€14€2250€16€100€0.2€13
N€N0003€200106€PEP€11€21€ 4234€3961781€3610€3935924€19800€1877493€1559852€407217€111162€0€0.0043€0.0169€2074843€0.0276€16€1458336€12€422545€0.0302€20
N€N0003€200106€PER€11€21€455€147898€1311€146587€0€54071€50664€20863€20325€664€0.0339€0.0494€60502€0.0331€30€70966€23€15119€0.0414€37
N€N0003€200106€PFP€11€21€ 6€4346€0€4346€0€611€3014€223€498€0€0.1608€0.2408€2737€0.1043€23€1609€22€€€
N€N0003€200106€PFPPR€11€21€4€1998€0€1998€0€456€1542€0€0€0€0.2503€0.3709€1060€0.1181€14€938€3€€€
N€N0003€200106€PG€11€21€ 4658€3286058€7562€3265296€10900€1994720€980155€234132€65839€1200€0.0104€0.0383€1509114€0.0338€12€1185301€9€581781€0.0453€20
N€N0003€200106€PGF€11€21€14€3127€0€3127€0€400€2227€500€0€0€0.0715€0.1322€200€0.1€37€2927€16€€€
N€N0003€200106€PGN€11€21€1717€803192€1050€800855€1100€395029€308406€70143€26814€1563€0.0002€0.0442€356946€0.0318€16€362495€12€82514€0.0394€21
N€N0003€200106€PHA€11€21€ 3943€2625800€5054€2615898€2300€1194257€945635€349082€129224€0€0.0004€0.0269€1208326€0.0303€19€1030728€13€379144€0.0395€26
N€N0003€200106€PII€11€21€327€102532€100€102432€0€41394€47177€10024€3837€0€-0.0108€0.0656€43817€0.0617€19€50009€14€8606€0.067€21
N€N0003€200106€PIK€11€21€46€3575€0€3575€0€200€1904€349€1122€0€0.0443€0.048€2316€0.061€22€1092€112€167€0.02€177
N€N0003€200106€PIM€11€21€103€49075€0€49075€0€24946€18678€4419€1032€0€0.021€0.0231€15250€0.0101€15€31123€13€2702€0.0172€21
N€N0003€200106€PIO€11€21€ 95€20834€0€20834€0€4049€12496€3547€742€0€0.2372€0.1999€15381€0.3664€19€5353€24€100€0.03€57
N€N0003€200106€PKE€11€21€363€119484€100€119384€0€37310€62636€13909€5529€0€-0.0061€0.0536€51032€0.0518€20€59311€16€9041€0.0835€42
N€N0003€200106€PKG€11€21€348€146975€435€146340€200€34426€54415€28787€26474€2438€0.0148€0.0363€71171€0.0341€45€66334€34€9035€0.0866€51
N€N0003€200106€PKX€11€21€454€142771€0€142226€200€41939€72365€20160€7962€0€0.013€0.0222€67854€0.0374€22€71279€18€3293€0.0316€36
N€N0003€200106€PLP€11€21€18€20783€0€20783€0€6623€11908€1872€380€0€0.0666€0.0736€9234€0.0405€19€9569€14€1980€0.048€16
N€N0003€200106€PNP€11€21€290€77419€0€77419€0€21873€46990€6414€2142€0€0.0365€0.0584€39478€0.0455€17€35119€13€2822€0.0368€27
N€N0003€200106€PNW€11€21€1193€470049€2100€467443€400€193183€212965€42984€18311€400€-0.0151€0.0449€244484€0.0442€17€188356€15€35003€0.0463€22
N€N0003€200106€PPD€11€21€ 354€203099€1025€199574€2500€50324€81817€41329€28104€500€0.0156€0.0512€76073€0.06€40€105458€21€20543€0.056€41
N€N0003€200106€PPP€11€21€ 900€218104€600€217504€0€90001€84657€30380€12466€0€-0.0018€0.0533€86443€0.0541€21€107964€17€23097€0.0719€22
N€N0003€200106€PPPPRQ€11€21€92€1220€0€1220€0€0€340€750€130€0€1.2195€1.2508€400€0.461€62€820€29€€€
N€N0003€200106€PTV€11€21€ 840€421537€524€420713€300€130636€203286€64391€22600€100€0.0084€0.0255€219254€0.0309€20€179782€19€21977€0.0307€20
N€N0003€200106€PX€11€21€2089€968093€4342€962551€400€391045€431840€105022€34611€433€0.0036€0.0323€517464€0.0384€17€360536€15€84951€0.0418€20
N€N0003€200106€RCL€11€21€635€192609€1279€191130€200€73260€79569€27645€10856€0€0.01€0.0309€71595€0.0366€23€106888€15€12847€0.0291€21
N€N0003€200106€RCN€11€21€583€26769€0€26769€0€7428€11535€3395€4411€0€0.0761€0.13€9038€0.0576€40€14081€20€3650€0.0453€33
N€N0003€200106€RG€11€21€1362€70949€0€70949€0€19784€28138€8150€13587€1290€0.0487€0.0507€16009€0.0463€71€42135€29€12805€0.0254€64
N€N0003€200106€RHB€11€21€ 366€256151€6400€249751€0€54702€103946€53430€37673€0€0.0063€0.1091€117310€0.0835€36€102790€26€29651€0.1028€46
N€N0003€200106€RHD€11€21€390€166190€100€165990€0€55871€81814€20848€7457€0€0.0146€0.0431€76146€0.0406€19€82195€17€7649€0.0406€25
N€N0003€200106€RHI€11€21€ 995€438400€1243€436357€800€200230€165695€49195€21787€250€0.0035€0.0378€212536€0.0402€18€187120€13€37501€0.0493€32
N€N0003€200106€RJF€11€21€528€179628€1970€177558€100€59606€69661€26503€21888€0€0.0153€0.0605€84064€0.0491€26€80046€18€13548€0.063€43
N€N0003€200106€RL€11€21€555€188977€400€187027€1200€51875€75446€38251€22355€300€0.0187€0.0584€80017€0.0683€29€84714€25€23496€0.0661€31
N€N0003€200106€RMG€11€21€154€76807€0€76807€0€31060€36138€8459€1150€0€0.0365€0.0786€40447€0.0656€14€32940€14€3420€0.0411€29
N€N0003€200106€RML€11€21€366€65767€851€64916€0€15388€24785€9913€14430€400€0.0185€0.0323€25040€0.0345€54€36262€32€3614€0.036€68
N€N0003€200106€RNS€11€21€ 4€3105€0€3105€0€1535€1370€200€0€0€-0.0113€0.1214€2105€0.1211€11€1000€14€€€
N€N0003€200106€ROP€11€21€321€119636€1400€118236€0€31245€46507€21949€17566€969€-0.0259€0.0654€52276€0.0767€37€54041€26€11919€0.076€60
N€N0003€200106€ROS€11€21€78€8810€0€8810€0€5900€2210€500€200€0€0.0236€0.0264€4960€0.0191€11€3850€15€€€
N€N0003€200106€ROV€11€21€ 443€280099€300€278999€800€121057€99650€39115€18932€1045€0.0341€0.0251€165982€0.0469€20€98628€16€15189€0.0513€69
N€N0003€200106€RS€11€21€214€74715€300€74415€0€17112€35972€16048€5283€0€0.0392€0.0486€37850€0.0445€24€31898€21€4667€0.0411€26
N€N0003€200106€RSC€11€21€ 76€35415€0€35415€0€8219€17055€6911€3230€0€0.0579€0.1382€19992€0.0862€25€13593€24€1830€0.1025€40
N€N0003€200106€RTP€11€21€145€45752€200€45552€0€14891€21771€6917€1973€0€0.0728€0.4891€17391€0.1724€22€23561€14€4600€0.5028€31
N€N0003€200106€RWT€11€21€198€52267€0€52267€0€18388€19210€10069€4600€0€0.0662€0.0721€25393€0.0563€23€24774€18€2100€0.0438€14
N€N0003€200106€RWTPRB€11€21€5€1638€0€1638€0€100€1288€100€150€0€-0.0472€0.0114€1239€0.599€39€399€13€€€
N€N0003€200106€RYN€11€21€669€128546€700€127446€0€34511€58160€23802€10373€600€0.0047€0.0552€52145€0.0532€29€64697€21€10604€0.0443€37
N€N0003€200106€RZT€11€21€212€44179€0€44079€100€16442€21497€5031€1209€0€-0.0017€0.0511€18311€0.046€16€23659€13€2209€0.09€34
N€N0003€200106€SACPR€11€21€3€700€0€700€0€0€0€200€500€0€0.5386€1.1014€€€€700€86€€€
N€N0003€200106€SACPRT€11€21€ 8€2493€0€2493€0€320€1463€300€410€0€0.1159€0.2151€413€0.1299€17€1980€41€100€0.1€16
N€N0003€200106€SAIPRW€11€21€13€17471€0€17471€0€9608€6338€1125€400€0€0.0927€0.0907€5971€0.0183€14€11400€15€100€0.03€7
N€N0003€200106€SBG€11€21€40€23981€0€23981€0€9947€6542€3638€3554€300€0.0214€0.0256€12268€0.0161€38€11713€39€€€
N€N0003€200106€SC€11€21€944€171378€1200€169328€600€35189€66402€34353€32589€1295€0.0253€0.0425€67572€0.0423€115€82345€33€20011€0.0432€74
N€N0003€200106€SCG€11€21€660€174445€1450€172995€0€36451€63067€41038€31401€1038€0.0215€0.0434€73380€0.0352€39€85091€31€14524€0.0479€57
N€N0003€200106€SCL€11€21€36€4080€0€4080€0€797€977€1156€1007€143€0.0229€0.1141€1361€0.0648€33€2719€95€€€
N€N0003€200106€SCX€11€21€13€5156€0€5156€0€1378€1806€500€1472€0€0.0984€0.1732€871€0.1332€41€4185€42€100€0.14€18
N€N0003€200106€SCZ€11€21€365€93540€0€93440€100€37105€43330€8965€4140€0€0.0186€0.0246€42050€0.032€19€49810€15€1680€0.0214€19
N€N0003€200106€SCZA€12€21€ 7€1667€270€1397€0€450€430€200€317€0€-3.8031€6.7545€317€1€165€1080€17€€€
N€N0003€200106€SDH€11€21€ 84€41816€0€41816€0€18699€18351€3596€1170€0€0.0156€0.0167€12656€0.0124€16€28810€12€350€0.0243€60
N€N0003€200106€SGH€11€21€66€6168€0€6168€0€1085€2758€1200€1125€0€0.1017€0.1265€2783€0.0408€37€3000€41€385€0.033€9
N€N0003€200106€SGI€11€21€298€72667€350€72017€300€24900€32188€9337€5892€0€0.0092€0.013€22488€0.0123€20€46559€19€3270€0.0143€58
N€N0003€200106€SGR€11€21€1534€1299132€35974€1259458€2700€574617€455207€144340€85394€2700€-0.0187€0.0949€654440€0.1078€20€422851€13€184867€0.1534€37
N€N0003€200106€SGU€11€21€ 91€102190€475€101715€0€24400€44647€16278€15490€900€0.0525€0.0787€50870€0.0602€40€46623€28€4222€0.0301€56
N€N0003€200106€SII€11€21€ 3969€2461601€89352€2366784€2800€708230€989797€446578€224144€835€-0.0217€0.1034€1098122€0.0831€23€658194€17€613268€0.1146€34
N€N0003€200106€SLC€11€21€1746€102521€0€102521€0€31777€51814€14017€4913€0€0.0465€0.0498€39662€0.0221€22€51426€15€11433€0.021€27
N€N0003€200106€SLI€11€21€194€40617€418€39999€200€9667€16424€8563€5445€100€0.0376€0.0584€15844€0.0585€43€20722€21€3633€0.0345€53
N€N0003€200106€SO€11€21€2151€1830209€2000€1815354€11800€580083€787613€325490€133214€754€0.007€0.0234€654768€0.0233€25€930696€18€241690€0.0333€29
N€N0003€200106€SOPRA€11€21€28€16715€0€16715€0€3470€8827€1949€2469€0€0.0601€0.0665€4028€0.0293€35€11087€27€1600€0.0338€30
N€N0003€200106€SOPRB€11€21€16€17925€0€17925€0€5235€6861€2834€2995€0€0.0985€0.0985€10104€0.042€50€7421€23€400€0.0375€42
N€N0003€200106€SOPRC€11€21€17€16462€0€16462€0€2966€8671€3400€1425€0€0.0695€0.0901€6935€0.0333€27€8927€25€600€0.0367€33
N€N0003€200106€SP€11€21€ 417€417878€20700€395978€1000€88276€173307€84940€49425€1030€-0.1028€0.2098€199842€0.171€26€116566€21€80570€0.2007€41
N€N0003€200106€SPN€11€21€315€100444€325€100119€0€31571€45383€12267€10898€0€0.017€0.0288€43292€0.0424€30€56427€21€400€0.015€91
N€N0003€200106€SPP€11€21€132€51056€0€50756€300€10669€25951€9287€5149€0€0.035€0.0357€20559€0.0263€30€27662€21€2835€0.0104€42
N€N0003€200106€SRE€11€21€1917€776656€470€775086€1100€536186€219314€17703€2755€228€0.0072€0.0319€347116€0.0326€9€370017€8€59053€0.036€11
N€N0003€200106€SREPRA€11€21€ 19€28661€0€28661€0€5688€17888€3435€1650€0€0.148€0.1707€17662€0.1052€21€10199€21€800€0.075€20
N€N0003€200106€SSD€11€21€195€35844€500€35344€0€9983€16926€5118€3317€0€0.0133€0.1372€17605€0.1104€33€13239€17€4500€0.1138€32
N€N0003€200106€SSR€11€21€30€19430€0€19430€0€3254€10127€4436€1013€600€0.0853€0.0911€7555€0.0238€45€11475€28€400€0.035€22
N€N0003€200106€STZ€11€21€ 610€339807€2000€337207€600€85800€149849€59664€42094€400€-0.0029€0.0667€138641€0.0823€34€166570€25€32596€0.0947€42
N€N0003€200106€STZB€12€21€8€624€0€624€0€0€0€0€624€0€1.8974€2.1795€€€€400€153€224€0.25€294
N€N0003€200106€SUR€11€21€167€31393€0€31393€0€11609€15609€2915€1260€0€0.0568€0.0639€12522€0.0329€17€17749€15€1122€0.04€22
N€N0003€200106€SUT€11€21€ 91€35284€0€35084€0€12819€18577€3588€100€0€0.0201€0.0223€16575€0.0263€15€17409€13€1100€0.0291€14
N€N0003€200106€SUTPRA€11€21€11€10131€0€10131€0€1975€6048€2008€100€0€0.0368€0.1397€5027€0.083€25€5104€15€€€
N€N0003€200106€SVAPR€11€21€ 4€3315€0€3315€0€200€1775€1340€0€0€0.0515€0.1859€1185€0.0888€22€1930€29€200€0.05€13
N€N0003€200106€SWM€11€21€152€25116€100€25016€0€8271€12267€3269€1209€0€0.0461€0.0897€9365€0.0636€26€13651€16€2000€0.075€24
N€N0003€200106€SZ€11€21€13€2987€0€2987€0€0€1937€900€150€0€0.0285€0.0453€500€0.03€30€2487€36€€€
N€N0003€200106€TAPPRA€11€21€ 31€40656€0€40656€0€9089€25026€6266€275€0€0.0569€0.0587€14590€0.0156€21€25766€17€300€0.03€15
N€N0003€200106€TAPPRB€11€21€ 7€5637€0€5637€0€628€4379€630€0€0€0.1076€0.112€4215€0.0363€18€1222€10€200€0.04€11
N€N0003€200106€TCC€11€21€135€33038€0€32738€300€5154€13144€8508€6232€0€0.0327€0.0487€15161€0.0428€44€15526€27€2351€0.0516€33
N€N0003€200106€TCH€11€21€28€10532€0€10532€0€1828€7022€700€982€0€0.066€0.0697€2692€0.0298€26€7640€21€200€0.05€0
N€N0003€200106€TCLPR€11€21€15€6611€0€6611€0€2911€3700€0€0€0€0.1029€0.1033€1800€0.0339€16€4811€11€€€
N€N0003€200106€TCR€11€21€451€64034€0€64034€0€13892€25318€11708€12916€200€0.0298€0.0366€20925€0.0261€44€38017€34€5092€0.0244€58
N€N0003€200106€TD€11€21€2357€84704€200€84504€0€26904€43499€9309€4792€0€0.0325€0.0518€30355€0.0191€20€40045€14€14104€0.0498€25
N€N0003€200106€TDI€11€21€ 4€5012€0€5012€0€850€2266€1175€721€0€0.0014€0.177€2011€0.0975€46€3001€24€€€
N€N0003€200106€TDR€11€21€27€4930€0€4930€0€160€4120€450€200€0€0.1722€0.1429€3070€0.0602€24€1860€18€€€
N€N0003€200106€TDY€11€21€248€111666€327€111339€0€39645€56089€11267€4338€0€0.0014€0.0325€46693€0.0382€21€60096€14€4550€0.0372€18
N€N0003€200106€TEE€11€21€190€93634€194€93440€0€38091€39954€10290€5205€0€0.0724€0.0979€55764€0.0522€17€33575€17€4101€0.0442€24
N€N0003€200106€TEF€11€21€1065€396187€0€395605€100€185332€137753€47922€24698€0€0.0348€0.0489€199060€0.031€21€167710€14€28935€0.0439€27
N€N0003€200106€TEM€11€21€4€975€0€975€0€375€200€400€0€0€0.2018€0.2467€300€0.1167€11€675€25€€€
N€N0003€200106€TEN€11€21€140€70065€0€70065€0€20950€30885€10353€7877€0€0.0257€0.0338€26121€0.0405€24€39987€23€3957€0.0298€12
N€N0003€200106€TFS€11€21€415€145212€800€143612€800€41861€68860€23910€9781€0€0.0099€0.0531€57459€0.0478€23€76318€19€10635€0.0542€23
N€N0003€200106€TGT€11€21€ 4524€3240598€7313€3215448€13900€1249034€1213942€478651€281570€6151€0.0055€0.0267€1754183€0.0402€22€1020458€16€454707€0.0506€33
N€N0003€200106€THX€11€21€424€138946€400€137546€600€38790€53171€27131€18274€780€-0.0272€0.0806€45773€0.104€35€75898€24€16475€0.1466€48
N€N0003€200106€TI€11€21€309€58047€100€57847€100€5609€27586€14591€9798€363€0.2277€0.3006€31788€0.331€46€23256€24€2903€0.1905€36
N€N0003€200106€TIA€12€23€2€3300€2600€700€0€0€0€0€700€0€-6.14€2.68€€€€700€208€€€
N€N0003€200106€TLI€11€21€25€18393€0€18393€0€5914€7198€3215€2066€0€0.0338€0.0413€4007€0.0171€38€13686€23€700€0.0357€23
N€N0003€200106€TLK€11€21€59€9060€0€9060€0€1072€5706€1383€899€0€0.0163€0.0239€6138€0.0201€21€2922€33€€€
N€N0003€200106€TOL€11€21€ 789€345725€1300€343187€300€106434€153897€54404€28752€0€0.0221€0.0455€141820€0.0581€27€171803€19€29864€0.0657€25
N€N0003€200106€TR€11€21€468€189915€1800€188115€0€37995€79907€42395€26708€1110€0.0162€0.0758€79587€0.0422€37€92597€28€15931€0.1202€54
N€N0003€200106€TRA€11€21€154€53919€100€53619€200€18468€22849€10610€1892€200€0.013€0.0187€18222€0.0285€24€34022€21€1575€0.0225€27
N€N0003€200106€TRP€11€21€628€40568€300€39968€300€18516€17508€3049€1195€0€0.0232€0.0269€17545€0.0144€14€22113€14€610€0.0166€13
N€N0003€200106€TRPPR€11€21€26€18352€0€18352€0€6762€8990€2100€500€0€0.0461€0.0513€8625€0.0222€22€9527€12€200€0.03€10
N€N0003€200106€TRPPRC€11€21€ 9€6352€0€6352€0€3210€2942€200€0€0€0.0645€0.0643€2510€0.0303€14€3842€11€€€
N€N0003€200106€TTR€11€21€10€6839€0€6839€0€4785€1668€386€0€0€0.058€0.0552€1506€0.0338€10€5333€9€€€
N€N0003€200106€TWE€11€21€779€116045€212€115233€600€36782€50391€20674€7986€0€0.0133€0.0223€38403€0.0222€28€69540€19€7890€0.0292€31
N€N0003€200106€TWK€11€21€401€62550€426€62124€0€17218€21312€10709€12585€300€0.0112€0.0307€32607€0.0461€34€27617€38€1900€0.0442€41
N€N0003€200106€TX€11€21€ 4866€2376297€9060€2363465€2500€1397168€761431€163587€43779€0€0.0131€0.0354€1075238€0.0369€12€866775€10€423952€0.0385€15
N€N0003€200106€TXCPRA€11€21€ 28€35819€0€35819€0€20100€13164€1840€615€100€0.0692€0.0725€12355€0.0141€13€22764€13€700€0.0557€15
N€N0003€200106€TXCPRB€11€21€ 9€7489€0€7489€0€2855€3884€600€150€0€0.1133€0.1246€3550€0.0445€12€3739€19€200€0.01€22
N€N0003€200106€TXN€11€21€10154€7538253€101229€7394161€34500€2539737€2403485€1376649€1086906€21884€-0.0069€0.0401€3888049€0.0556€27€1778802€21€1761810€0.066€43
N€N0003€200106€UIS€11€21€1661€863380€300€860260€2600€520238€271865€59247€11158€352€0.0019€0.0169€410722€0.0227€12€392168€9€59970€0.0259€19
N€N0003€200106€VAP€11€21€10€5620€0€5620€0€1085€2560€500€1475€0€0.0876€0.0888€4035€0.0313€40€1485€25€100€0.02€11
N€N0003€200106€VBF€11€21€57€20011€0€20011€0€4270€7857€4087€3597€200€0.0555€0.0668€10578€0.0362€41€9233€30€200€0.02€320
N€N0003€200106€VEA€11€21€13€17329€0€17329€0€5199€9135€2195€800€0€0.0635€0.0988€8620€0.0473€19€8309€17€400€0.04€15
N€N0003€200106€VELPRT€11€21€22€9565€0€9565€0€3225€5640€600€100€0€0.1076€0.1207€5245€0.0358€15€4020€10€300€0.07€21
N€N0003€200106€VGM€11€21€18€5974€0€5974€0€2694€2750€530€0€0€0.0373€0.0349€3386€0.0109€14€2588€12€€€
N€N0003€200106€VGR€11€21€280€95521€600€94921€0€26817€43606€15460€8788€250€0.0653€0.1196€39410€0.111€32€46153€19€9358€0.0972€28
N€N0003€200106€VIG€11€21€ 7€2057€0€2057€0€389€1668€0€0€0€0.03€0.0391€800€0.0125€10€1157€10€100€0.01€13
N€N0003€200106€VIN€11€21€15€6807€0€6807€0€2456€1434€892€2025€0€0.0319€0.0312€2010€0.013€41€4797€48€€€
N€N0003€200106€VIT€11€21€27€12624€0€12624€0€7444€4875€305€0€0€0.036€0.0359€6412€0.0114€11€5887€8€325€0.01€8
N€N0003€200106€VNV€11€21€13€2270€0€2270€0€780€1190€300€0€0€0.0572€0.0457€538€0.01€26€1732€10€€€
N€N0003€200106€VOD€11€21€1999€1514065€2700€1506152€4300€792257€578419€118150€21426€200€0.0127€0.0158€842187€0.0218€14€579386€10€88879€0.0263€17
N€N0003€200106€VOL€11€21€105€20551€0€20551€0€5757€10161€2999€1534€100€0.0559€0.0808€10322€0.0528€27€8844€20€1385€0.0453€26
N€N0003€200106€VOT€11€21€13€6573€0€6573€0€2658€3686€229€0€0€0.0452€0.0539€2850€0.0175€15€2968€10€755€0.01€23
N€N0003€200106€VPA€11€21€10€9050€0€9050€0€1907€5339€1300€504€0€0.0648€0.0632€5957€0.0343€22€3093€18€€€
N€N0003€200106€VPQ€11€21€14€8868€0€8868€0€2747€4560€686€875€0€0.0484€0.0517€3903€0.0212€19€4965€23€€€
N€N0003€200106€VRC€11€21€1533€721772€1186€719800€600€264831€294864€105814€54891€0€-0.0091€0.045€286261€0.0307€21€317784€20€116355€0.0471€28
N€N0003€200106€VSH€11€21€1627€439313€1600€434513€3200€160494€181677€67281€28161€100€0.0057€0.0236€201249€0.0324€22€186762€16€49702€0.0348€26
N€N0003€200106€VVC€11€21€657€178642€300€178342€0€45864€72830€35634€23102€912€0.0164€0.0386€69059€0.0436€36€101042€24€8241€0.0549€69
N€N0003€200106€VVR€11€21€157€83284€0€83284€0€28751€37822€13076€3635€0€0.0123€0.013€15688€0.0125€22€66309€18€1287€0.01€29
N€N0003€200106€WFR€11€21€225€55333€0€55133€200€19295€21918€7154€6214€752€0.0271€0.0502€20319€0.0448€40€31596€17€3418€0.0496€22
N€N0003€200106€WG€11€21€122€43323€200€43123€0€7887€16391€10247€8498€100€0.0451€0.0786€26932€0.0573€40€12256€37€3935€0.0413€33
N€N0003€200106€WLP€11€21€2061€613165€3600€607565€1800€224212€285602€70528€28442€581€0.0052€0.0537€307476€0.0591€19€225772€15€76117€0.0715€21
N€N0003€200106€WNI€11€21€4€620€0€620€0€100€320€200€0€0€0.029€0.0194€420€0.0333€11€200€39€€€
N€N0003€200106€WSM€11€21€ 924€335089€7400€327689€0€107654€147769€43968€28298€0€-0.02€0.0431€146297€0.0509€24€138437€17€42955€0.0611€38
N€N0003€200106€WTS€11€21€121€25867€0€25867€0€9094€10894€4105€1774€0€0.0222€0.0725€13047€0.0591€24€12620€23€200€0.01€8
N€N0003€200106€XRX€11€21€2266€1563755€1500€1551990€9300€899430€518310€111272€32278€0€0.0048€0.0141€589903€0.0185€14€835374€9€136013€0.0244€21
N€N0003€200106€XVF€11€21€ 86€63667€300€63367€0€20329€30220€10193€2625€0€0.1756€0.2107€36209€0.0865€21€24028€17€3130€0.1246€6
N€N0003€200106€YLD€11€21€61€13280€0€13280€0€5464€4515€2276€1025€0€0.0185€0.0193€3096€0.0162€19€9884€23€300€0.01€7
N€N0003€200106€YUM€11€21€1648€681270€15304€663764€1800€124966€222082€150777€158519€9220€-0.0154€0.025€322286€0.0381€48€259741€38€83537€0.0503€67
N€N0003€200106€ZIF€11€21€23€9335€0€9335€0€3943€4592€700€100€0€0.0331€0.0384€4741€0.018€12€4594€17€€€
N€N0003€200106€ZMX€11€21€ 5€2620€0€2620€0€0€1999€353€268€0€0.0441€0.0335€1979€0.0469€24€641€47€€€'

	EXEC -t'€' -k 4,4 -lsum,regress,op=sum:float:17 $data/euro.dat
		OUTPUT - $'N€N0003€200106€AA€11€21€14596€3524300€9331€3494983€15500€1129332€1283396€639798€452298€5659€      21€0.0289€1717663€0.038€30€1195358€20€597462€0.0481€35
N€N0003€200106€AAT€11€21€48€14046€0€14046€0€7421€4549€1485€591€0€       0€0.0304€2513€0.01€25€11333€14€200€0.01€90
N€N0003€200106€ABJ€11€21€57€14508€0€14508€0€2603€9175€1650€1080€0€      43€0.0779€6636€0.0136€17€7872€25€€€
N€N0003€200106€ABS€11€21€7425€1465605€200€1461410€2900€483622€651665€241738€87165€120€       5€0.0284€599869€0.0306€22€670152€18€194289€0.0373€25
N€N0003€200106€ABT€11€21€14051€3368858€8904€3347422€10900€1469987€1273455€447558€166267€1055€      10€0.0273€1682138€0.0365€18€1150749€14€525435€0.044€25
N€N0003€200106€ACA€11€21€45€11490€0€11490€0€2845€7495€100€1050€0€     -12€0.0946€5052€0.0146€17€6438€22€€€
N€N0003€200106€ACS€11€21€2456€523323€13500€509523€0€192518€202103€71973€42229€700€      79€0.0658€254514€0.0654€21€177869€17€77140€0.0915€38
N€N0003€200106€AEF€11€21€210€61757€0€61757€0€9524€22881€15536€13616€200€      -6€0.0464€24867€0.0137€47€35248€43€1642€0.0401€27
N€N0003€200106€AET€11€21€2439€472785€900€471531€300€213068€162069€63465€32949€280€      24€0.0217€214120€0.0315€22€224763€16€32948€0.035€26
N€N0003€200106€AGC€11€21€6689€1443428€2747€1438956€1000€588445€574302€188125€88940€0€       3€0.0283€603123€0.0256€22€661220€16€175613€0.0329€31
N€N0003€200106€AGCPRA€11€21€56€16339€0€16339€0€3810€5914€4990€1625€0€      18€0.1187€7461€0.11€44€8678€25€200€0.085€8
N€N0003€200106€AGCPRB€11€21€25€6853€0€6853€0€100€3855€1550€1348€0€      43€0.115€3097€0.0587€44€3756€46€€€
N€N0003€200106€AGCPRM€11€21€57€15702€100€15602€0€1685€7911€3046€2170€790€     -23€0.0876€4071€0.0247€64€11031€65€500€0.078€166
N€N0003€200106€AGCPRMCL€11€21€4€1223€0€1223€0€0€923€300€0€0€      17€0.04€1223€0.01€22€€€€€
N€N0003€200106€AGCPRN€11€21€82€18338€0€18338€0€5186€8423€2223€2306€200€     -18€0.0967€2885€0.0334€65€15203€23€250€0.046€21
N€N0003€200106€AGCPRNCL€11€21€3€665€0€665€0€100€565€0€0€0€       8€0.01€€€€665€21€€€
N€N0003€200106€AGI€11€21€23€4879€0€4879€0€730€2761€1388€0€0€      16€0.0238€4099€0.0433€19€780€29€€€
N€N0003€200106€AHO€11€21€514€101764€100€101464€200€25120€56355€13898€6291€0€       4€0.061€51772€0.043€22€43731€19€6161€0.0371€23
N€N0003€200106€AIV€11€21€697€143764€0€143464€0€58036€56027€19187€10214€0€      -2€0.0629€54117€0.0484€20€80319€20€9028€0.0438€29
N€N0003€200106€AIVPRC€11€21€23€5998€0€5998€0€2025€2725€948€300€0€      -6€0.1098€2675€0.0259€25€3023€15€300€0.09€37
N€N0003€200106€AIVPRD€11€21€63€15180€0€15180€0€5430€8025€825€900€0€      24€0.1226€6105€0.0322€15€8975€24€100€0.04€12
N€N0003€200106€AIVPRG€11€21€45€12295€0€12295€0€3195€6435€1315€1350€0€      -7€0.0783€3675€0.0122€30€7920€24€700€0.0343€32
N€N0003€200106€AIVPRH€11€21€25€5959€0€5959€0€2100€3074€785€0€0€     -26€0.1345€2824€0.0322€13€3035€18€100€0.11€9
N€N0003€200106€AIVPRK€11€21€9€2070€0€2070€0€0€1070€600€400€0€       4€0.4413€1350€0.1863€48€720€20€€€
N€N0003€200106€AIVPRP€11€21€56€11916€0€11916€0€3681€4873€2148€1214€0€      19€0.2129€3376€0.0379€23€8540€26€€€
N€N0003€200106€AIVPRQ€11€21€39€10242€0€10242€0€3898€5497€327€520€0€      -2€0.0792€4613€0.0174€19€5629€13€€€
N€N0003€200106€AJG€11€21€875€196649€600€196049€0€80999€79015€21230€12954€1851€      19€0.0426€79215€0.0366€26€106810€13€10024€0.0518€45
N€N0003€200106€ALM€11€21€38€9137€0€9137€0€300€7876€961€0€0€     -25€0.0618€7139€0.0245€19€1998€15€€€
N€N0003€200106€ALPPRN€11€21€3€1290€0€1290€0€0€890€400€0€0€       1€0.181€400€0.05€16€890€21€€€
N€N0003€200106€ALPPRO€11€21€6€1700€0€1700€0€0€1700€0€0€0€     -88€0.2247€950€0.0621€26€750€18€€€
N€N0003€200106€ALPPRQ€11€21€28€7400€0€7400€0€2517€4483€400€0€0€       3€0.0795€3496€0.0287€17€3904€11€€€
N€N0003€200106€ALPPRR€11€21€43€12186€0€12186€0€2223€8511€1152€300€0€     -22€0.0713€4546€0.0179€18€7540€15€100€0.04€63
N€N0003€200106€ALQ€11€21€53€14947€0€14947€0€5706€7091€2050€100€0€      15€0.0864€8607€0.0231€21€6040€12€300€0.01€7
N€N0003€200106€ALZ€11€21€38€10019€0€10019€0€800€8563€656€0€0€      39€0.1095€6749€0.0256€19€3270€13€€€
N€N0003€200106€AMB€11€21€340€82057€0€81694€0€49345€26444€3944€1961€0€       3€0.029€37759€0.0248€12€40635€11€3300€0.0224€15
N€N0003€200106€AMBPRA€11€21€19€5460€0€5460€0€3560€1700€200€0€0€      16€0.1091€3300€0.0473€10€2160€13€€€
N€N0003€200106€AMD€11€21€22321€4782471€105767€4655665€17300€1343670€1809871€952933€564656€1635€      14€0.0399€2160554€0.0464€24€1180503€21€1331908€0.0601€37
N€N0003€200106€ANN€11€21€1471€308613€7500€301013€100€160173€110558€25319€5063€0€      59€0.0525€131184€0.0608€13€134861€10€35068€0.0762€17
N€N0003€200106€AOC€11€21€3951€740421€1545€737685€900€213132€304297€146622€73959€575€      10€0.0241€340231€0.0367€28€337678€21€60676€0.0378€34
N€N0003€200106€ARB€11€21€432€81559€300€81259€0€24043€40724€12568€3924€0€      18€0.0549€39589€0.0546€22€36715€18€4955€0.0477€23
N€N0003€200106€ARH€11€21€9€1815€0€1815€0€400€1115€100€200€0€      -7€0.0527€1190€0.0182€31€625€19€€€
N€N0003€200106€ATI€11€21€1153€204221€195€204026€0€95949€86063€15394€6520€100€      22€0.0249€88367€0.0285€16€109155€13€6504€0.0249€20
N€N0003€200106€AVP€11€21€5362€1025278€1664€1021714€1300€640871€320330€47980€12801€1032€      26€0.0305€463631€0.0358€10€466899€8€92484€0.0454€15
N€N0003€200106€AVZ€11€21€203€42999€0€42899€100€15985€19543€6471€1000€0€      26€0.1957€20702€0.1167€19€19355€14€2942€0.0663€19
N€N0003€200106€AXL€11€21€233€43442€0€43442€0€11343€20974€6885€4240€0€     -19€0.0834€21281€0.0732€30€20822€22€1339€0.0249€14
N€N0003€200106€AZA€11€21€4036€777156€5600€770456€500€475253€227074€51985€16512€132€      -4€0.0359€346051€0.0248€11€287853€9€137052€0.035€17
N€N0003€200106€AZZ€11€21€141€30688€0€30688€0€5454€17696€5938€1600€0€      42€0.0925€17081€0.0713€24€12107€24€1500€0.0293€20
N€N0003€200106€BC€11€21€1794€347438€2150€344388€900€119326€140853€55052€29034€1023€      28€0.0287€151059€0.0335€27€165409€19€28820€0.0421€28
N€N0003€200106€BCC€11€21€1261€232534€1500€231034€0€90880€102617€27338€10199€0€      32€0.0495€86498€0.0425€21€123377€15€21159€0.0489€20
N€N0003€200106€BD€11€21€132€26224€200€26024€0€8210€15964€1850€0€0€       0€0.0147€10370€0.0141€12€14654€13€1000€0.014€21
N€N0003€200106€BDF€11€21€39€9620€0€9620€0€3229€4243€1738€410€0€     -19€0.0565€2903€0.0136€13€6717€23€€€
N€N0003€200106€BGG€11€21€774€164711€600€163823€0€76597€68590€14556€4080€0€      25€0.0874€65955€0.0439€16€85847€11€12021€0.0977€21
N€N0003€200106€BGT€11€21€60€15473€0€15473€0€8014€5024€1985€450€0€      10€0.0185€3385€0.01€10€12088€14€€€
N€N0003€200106€BK€11€21€14814€3340606€5800€3332030€800€2109454€974660€195186€53530€0€      24€0.0372€1548826€0.0305€11€1273475€9€510529€0.0417€16
N€N0003€200106€BKE€11€21€104€18544€0€18544€0€3788€12093€2226€437€0€      34€0.0528€10301€0.0694€18€7843€20€400€0.035€15
N€N0003€200106€BKPRC€11€21€66€17897€0€17897€0€10855€5842€850€350€0€       8€0.0857€8767€0.0274€15€8630€11€500€0.028€7
N€N0003€200106€BKPRD€11€21€80€21826€0€21826€0€13055€7571€500€700€0€      13€0.0714€10371€0.0168€11€11155€14€300€0.08€18
N€N0003€200106€BKPRE€11€21€81€23243€0€23243€0€10876€10497€1470€400€0€      30€0.0832€15715€0.0205€15€7528€12€€€
N€N0003€200106€BLI€11€21€1232€227952€1609€226143€100€75627€104943€33926€11747€0€      10€0.0263€112032€0.0332€20€104908€17€9303€0.0328€22
N€N0003€200106€BNI€11€21€6187€1206018€400€1203328€1600€680896€414696€85020€23178€1138€       0€0.0285€588392€0.0262€13€511908€10€104628€0.0403€19
N€N0003€200106€BR€11€21€7135€1378982€4900€1370416€2000€687207€493400€131614€58722€1473€      12€0.0302€782525€0.0406€16€459377€12€130514€0.0503€29
N€N0003€200106€BRG€11€21€56€11360€0€11360€0€2143€6614€1791€812€0€     -30€0.1699€6410€0.118€29€4850€22€100€0.1€63
N€N0003€200106€BSP€11€21€25€4791€0€4791€0€1745€2537€509€0€0€      12€0.0835€2054€0.0143€14€2337€15€400€0.045€9
N€N0003€200106€BTY€11€21€1036€203914€400€203314€200€78459€82586€27485€14884€100€     102€0.1174€111376€0.0744€24€78300€16€13838€0.0657€24
N€N0002€200106€BTYRT€11€21€239€50506€0€50506€0€19517€24313€3320€3356€0€   -1206€0.1598€32175€0.1498€23€17731€14€600€0.055€20
N€N0003€200106€BWG€11€21€30€6512€0€6512€0€1183€4379€650€300€0€      -5€0.1734€4366€0.0936€24€2046€21€100€0.08€0
N€N0003€200106€BXS€11€21€157€33939€0€33939€0€14334€13818€5063€724€0€      13€0.0378€17439€0.042€14€15418€17€1082€0.0204€22
N€N0003€200106€BYD€11€21€166€35218€200€35018€0€8011€13121€6471€7115€300€       1€0.0426€12541€0.0321€37€19449€44€3028€0.0338€50
N€N0003€200106€BZL€11€21€10€2330€0€2330€0€1000€400€530€400€0€      -4€0.0748€1130€0.04€53€800€8€400€0.02€7
N€N0003€200106€C€11€21€36206€7798662€31303€7747379€16900€3563357€2481386€1113981€603003€2552€       1€0.0228€4246991€0.0389€19€2228824€15€1288464€0.0463€33
N€N0003€200106€CBM€11€21€983€194272€2240€191632€0€63286€89872€27044€11430€0€      83€0.1101€81401€0.0814€22€85841€16€24390€0.132€30
N€N0003€200106€CCC€11€21€209€43832€300€43532€0€9359€19019€8257€6297€600€      10€0.0488€20746€0.0443€44€20283€29€2503€0.0202€39
N€N0003€200106€CCPPRA€11€21€60€13025€0€13025€0€2350€7424€2707€544€0€     -52€0.3285€5751€0.0625€18€6774€26€500€0.058€17
N€N0003€200106€CCR€11€21€3630€728090€6800€719678€1000€267653€271128€122720€59077€100€      49€0.0301€346880€0.0381€22€277870€18€95928€0.0488€30
N€N0003€200106€CEA€11€21€10€2229€0€2229€0€300€1601€328€0€0€     -26€0.1549€928€0.031€17€1201€16€100€0.01€16
N€N0003€200106€CED€11€21€138€25925€300€25625€0€5812€12625€5838€1350€0€      16€0.108€13523€0.0484€25€10252€19€1850€0.043€36
N€N0003€200106€CEM€11€21€155€30385€0€30385€0€6560€16100€6125€1600€0€      -8€0.0917€15567€0.0682€23€13468€23€1350€0.0337€30
N€N0003€200106€CEN€11€21€498€110436€0€110236€200€45363€46318€11486€6969€300€      -8€0.0306€50010€0.0344€21€55025€14€5401€0.0262€38
N€N0003€200106€CF€11€21€3637€639764€3248€634316€1500€182374€248718€123189€77927€3608€       8€0.0254€286515€0.033€30€282454€22€66847€0.0282€49
N€N0003€200106€CFE€11€21€7€1684€0€1684€0€1300€100€284€0€0€     -38€0.1669€984€0.25€18€700€8€€€
N€N0003€200106€CFN€11€21€16€4234€0€4234€0€1018€1116€1300€800€0€      -6€0.0828€1200€0.3967€71€3034€26€€€
N€N0003€200106€CGPPRG€12€21€54€5400€4900€500€0€0€100€200€200€0€    -174€0.184€200€0.75€80€300€33€€€
N€N0003€200106€CGPPRI€11€21€4€750€0€750€0€0€200€0€400€150€    -262€0.026€550€0.7182€511€200€23€€€
N€N0003€200106€CGPPRT€11€21€38€9711€0€9711€0€3766€4598€1147€200€0€     -48€0.0734€2517€0.0372€15€7042€15€152€0.01€24
N€N0003€200106€CHD€11€21€606€132464€1359€131105€0€52672€55896€14149€7853€535€     -11€0.0634€55486€0.0467€19€68291€17€7328€0.0501€27
N€N0003€200106€CHH€11€21€242€54062€0€53762€0€17816€21767€9596€4583€0€       0€0.0552€26188€0.0734€31€23562€16€4012€0.0527€16
N€N0002€200106€CHTRT€11€21€12€3174€0€3174€0€160€0€320€2375€319€      23€0.0609€1735€0.0113€116€1439€198€€€
N€N0002€200106€CHTRTWI€12€24€1€5000€0€5000€0€0€0€5000€0€0€     -12€0.04€€€€5000€31€€€
N€N0003€200106€CIC€11€21€184€49613€0€49613€0€12025€25301€7518€4769€0€     -19€0.0656€15733€0.0419€22€33280€25€600€0.0533€62
N€N0003€200106€CIP€11€21€84€22418€0€22418€0€4677€16266€1050€425€0€     -23€0.0745€11685€0.0212€16€10033€16€700€0.0229€12
N€N0003€200106€CIR€11€21€339€57557€600€56957€0€24724€23479€6114€2640€0€      75€0.0568€31783€0.0736€16€21547€14€3627€0.1043€30
N€N0003€200106€CKC€11€21€157€29607€0€29607€0€9386€15183€3387€1651€0€     -67€0.0255€7241€0.0637€30€21486€17€880€0.0327€46
N€N0003€200106€CKH€11€21€487€88089€0€88089€0€41269€36261€7618€2941€0€       6€0.0825€32140€0.0668€15€48565€12€7384€0.0821€18
N€N0003€200106€CLB€11€21€640€122678€600€122078€0€25245€56302€22564€17297€670€      57€0.0714€57167€0.0743€39€58510€25€6401€0.0322€58
N€N0003€200106€CLJ€11€21€236€38026€0€38026€0€5116€17590€8934€6386€0€     -28€0.0909€17649€0.0682€43€19877€32€500€0.042€67
N€N0003€200106€CLL€11€21€46€8406€300€8106€0€1238€4650€1785€433€0€     -48€0.2263€3948€0.1524€16€3958€24€200€0.29€58
N€N0003€200106€CMO€11€21€543€106712€0€106312€400€43418€52504€8949€1841€0€      58€0.0488€53463€0.043€16€49371€12€3878€0.0384€11
N€N0003€200106€CMOPRA€11€21€15€3043€0€3043€0€1294€850€599€300€0€      41€0.3056€1249€0.5695€35€1794€16€€€
N€N0003€200106€CMOPRB€11€21€38€10036€0€10036€0€3886€4894€915€341€0€      49€0.13€3128€0.0804€19€6528€19€380€0.01€14
N€N0003€200106€CMP€11€21€326€73395€0€73395€0€17955€42915€9935€2590€0€     -17€0.1083€20714€0.0277€19€48680€18€4001€0.0559€33
N€N0003€200106€CMS€11€21€2234€430340€888€427110€2000€222679€168912€27920€9599€0€      36€0.0312€192319€0.0264€13€205993€11€30798€0.0334€18
N€N0003€200106€CMSPRJ€11€21€22€6005€0€6005€0€975€4230€800€0€0€      38€0.2442€3930€0.0288€18€1775€17€300€0.1€17
N€N0003€200106€CMSPRK€11€21€33€9399€0€9399€0€800€7649€950€0€0€      16€0.2479€2575€0.0399€17€6124€18€700€0.1843€12
N€N0003€200106€CMSPRL€11€21€35€9413€0€9413€0€2016€4977€2005€415€0€      60€0.1851€4199€0.0565€24€4814€22€400€0.1€37
N€N0003€200106€CMSPRM€11€21€7€1698€0€1698€0€0€1398€0€300€0€      -6€0.3419€1398€0.0949€20€€€300€0.25€156
N€N0003€200106€CMSPRN€11€21€17€4241€0€4241€0€523€2258€1260€200€0€       9€0.0779€3641€0.0212€28€600€9€€€
N€N0003€200106€CNA€11€21€681€155244€0€154844€400€57125€83968€12351€1800€0€       7€0.0546€66722€0.0293€14€80492€10€8030€0.033€17
N€N0003€200106€CNL€11€21€567€129633€100€129233€300€70295€48666€7529€3043€0€     -34€0.0612€53723€0.0363€14€69264€10€6546€0.0487€18
N€N0003€200106€CNN€11€21€21€4852€0€4852€0€2531€1646€200€475€0€       1€0.038€3087€0.0285€13€1765€48€€€
N€N0003€200106€COE€11€21€21€5098€0€5098€0€1085€1178€1635€1200€0€      10€0.0358€1785€0.0243€33€3313€59€€€
N€N0003€200106€COG€11€21€625€131188€1478€129510€200€31708€55095€27764€14801€342€      11€0.0433€60097€0.0666€32€60933€24€8680€0.0682€51
N€N0003€200106€CPD€11€21€41€9634€0€9634€0€4435€3309€1640€250€0€      17€0.0417€7584€0.0444€18€2050€11€€€
N€N0003€200106€CPP€11€21€13€3230€0€3230€0€900€1350€980€0€0€     122€0.1737€900€0.0567€28€2330€18€€€
N€N0003€200106€CPRE€11€21€90€23321€0€23321€0€2550€15745€3669€1357€0€     -11€0.0674€13212€0.0199€26€9709€18€400€0.1€41
N€N0003€200106€CPRF€11€21€6€1100€0€1100€0€0€900€0€200€0€     -19€0.3159€250€0.48€23€850€28€€€
N€N0003€200106€CPRG€11€21€7€1326€0€1326€0€0€764€562€0€0€      65€0.4987€664€0.1324€29€662€30€€€
N€N0003€200106€CPRH€11€21€6€1320€0€1320€0€0€600€720€0€0€     182€0.422€920€0.1978€23€400€59€€€
N€N0003€200106€CPRK€11€21€42€11084€0€11084€0€500€7692€2092€600€200€      48€0.2243€5553€0.0862€41€5131€29€400€0.165€32
N€N0003€200106€CPRM€11€21€10€2226€0€2226€0€339€960€727€200€0€     121€0.5577€1580€0.2241€29€446€18€200€0.25€38
N€N0003€200106€CPRN€11€21€43€11091€0€11091€0€2000€7226€1205€660€0€      15€0.0632€5145€0.0127€21€5946€26€€€
N€N0003€200106€CPRQ€11€21€4€1200€0€1200€0€0€500€700€0€0€     124€0.5625€400€0.05€31€600€21€200€0.1€22
N€N0003€200106€CPRR€11€21€2€500€0€500€0€0€300€0€200€0€     128€0.602€300€0.03€26€200€72€€€
N€N0003€200106€CPRU€11€21€12€3145€0€3145€0€200€1745€800€400€0€      93€0.5192€1470€0.0813€20€1675€47€€€
N€N0003€200106€CPRW€11€21€203€54632€0€54632€0€10698€29850€9542€4142€400€       6€0.0715€24025€0.0144€27€30207€31€400€0.04€21
N€N0003€200106€CPRX€11€21€152€45053€400€44653€0€9460€26551€5112€3530€0€       4€0.0603€19055€0.0159€31€25098€22€500€0.044€106
N€N0003€200106€CQPRA€11€21€80€19210€0€19210€0€5594€9166€3275€1175€0€     -37€0.1641€10230€0.0347€18€8480€27€500€0.08€40
N€N0003€200106€CRM€11€21€6€1000€0€1000€0€0€300€0€700€0€     -45€-0.057€500€0.81€65€500€66€€€
N€N0003€200106€CRY€11€21€1181€234595€3650€230145€500€98877€107261€19489€5018€0€     108€0.1235€91095€0.097€16€107036€12€32514€0.1306€20
N€N0003€200106€CSL€11€21€702€142404€860€141544€0€43960€64987€21866€10199€532€      -4€0.0624€60868€0.0381€24€68088€17€12588€0.0475€27
N€N0003€200106€CSP€11€21€46€11788€0€11188€600€4305€5430€1114€939€0€       8€0.0379€3505€0.0229€13€8183€24€100€0.02€14
N€N0003€200106€CVC€11€21€1573€300546€2400€297846€0€124254€143338€23288€6966€0€      77€0.0522€119404€0.0584€16€145555€12€32887€0.052€19
N€N0003€200106€CVD€11€21€957€215338€1250€212285€1000€63619€102151€34471€13044€0€       8€0.0433€91877€0.0469€22€107181€19€14227€0.0438€27
N€N0003€200106€CW€11€21€64€11629€0€11629€0€1568€7271€1704€1086€0€     -19€0.1445€5531€0.0981€29€5598€18€500€0.082€24
N€N0003€200106€CWN€11€21€268€59776€200€59176€400€10708€28045€14206€6517€100€       2€0.0268€23025€0.035€36€35286€30€1265€0.0361€38
N€N0003€200106€CWNPRA€11€21€23€5460€0€5460€0€1280€2775€1105€300€0€      69€0.1623€2850€0.0813€21€2610€29€€€
N€N0003€200106€CYE€11€21€163€44347€0€44047€300€11950€16310€9270€6567€250€     -23€0.029€15808€0.0208€39€28139€28€400€0.03€68
N€N0003€200106€D€11€21€6378€1219758€2220€1216438€1100€899099€288283€25052€5104€0€      30€0.0547€587917€0.0449€8€463592€7€166029€0.0507€10
N€N0003€200106€DCP€11€21€120€23882€0€23882€0€6845€13962€2650€425€0€     -28€0.4252€14729€0.1923€19€9153€17€€€
N€N0003€200106€DCS€11€21€26€4646€100€4546€0€826€1934€886€900€0€      -1€0.0374€646€0.0154€28€3900€39€€€
N€N0003€200106€DDF€11€21€130€34631€104€34527€0€7804€18014€5335€3374€0€     -28€0.0619€12217€0.0453€22€21810€22€500€0.01€12
N€N0003€200106€DFG€11€21€322€57038€0€57038€0€27051€22775€5339€1873€0€     -15€0.0532€24654€0.036€18€28384€11€4000€0.0359€16
N€N0003€200106€DGX€11€21€5186€1005363€24875€978733€1100€406700€402320€118543€51365€905€     157€0.1035€454631€0.1058€20€354981€15€170221€0.1344€24
N€N0003€200106€DHY€11€21€69€15511€0€15511€0€3644€6401€3456€1868€142€     -20€0.0212€5804€0.0202€39€9407€33€300€0.01€39
N€N0003€200106€DJM€11€21€2€830€0€830€0€400€430€0€0€0€       5€0.1004€430€0.01€22€400€4€€€
N€N0003€200106€DLX€11€21€1601€281299€2671€278216€300€71701€103284€50590€50913€2028€      34€0.0344€101971€0.0331€40€151551€33€24994€0.05€48
N€N0003€200106€DNB€11€21€925€207241€100€207141€0€97114€83577€20796€5654€0€       9€0.0423€106479€0.0315€16€90982€12€9680€0.0268€21
N€N0003€200106€DNR€11€21€384€73429€101€72428€900€27435€35656€7906€2331€0€      12€0.0339€30182€0.0324€16€39174€15€3972€0.0371€19
N€N0003€200106€DNY€11€21€1965€380145€100€379832€0€216298€132793€19890€10851€0€      -4€0.0381€156676€0.0298€13€193479€12€29677€0.0313€15
N€N0003€200106€DPRA€11€21€125€35911€0€35911€0€16642€14590€3109€1570€0€     -33€0.1137€13725€0.0222€17€20986€15€1200€0.0733€17
N€N0003€200106€DSU€11€21€261€76624€280€76344€0€28055€28115€11749€8425€0€      -9€0.0231€27021€0.0138€28€48009€27€1314€0.0163€34
N€N0003€200106€DT€11€21€2026€446775€1300€444775€700€253675€148003€35543€8254€0€       2€0.0166€202363€0.0184€12€202306€10€40806€0.0204€23
N€N0003€200106€DV€11€21€677€149804€900€148704€200€53027€64825€19880€10136€1036€      50€0.0764€65449€0.0428€22€72670€17€10785€0.0449€21
N€N0003€200106€EAS€11€21€709€158503€600€157500€0€70724€51100€22068€13608€0€       6€0.0322€57187€0.035€26€94069€17€6244€0.0266€40
N€N0003€200106€ED€11€21€4263€765164€1625€760880€1700€269390€288368€128899€73604€4061€       8€0.0326€315254€0.0402€32€364869€20€82457€0.0417€45
N€N0003€200106€EDE€11€21€259€54956€0€54856€100€22840€24852€6013€1251€100€     -46€0.0399€26989€0.0521€15€25555€16€2412€0.0353€19
N€N0003€200106€EDEPRD€11€21€20€4917€0€4917€0€900€2790€1127€100€0€      47€0.0871€4417€0.1058€19€300€26€200€0.06€31
N€N0003€200106€EDL€11€21€93€24045€0€24045€0€4069€14154€4450€1372€0€     -17€0.0953€4642€0.0249€30€17298€22€2105€0.0329€18
N€N0003€200106€EDO€11€21€700€150405€2000€148405€0€48400€64713€22279€12513€500€      11€0.0571€72066€0.0717€23€66460€15€9879€0.0961€31
N€N0003€200106€EDPRA€11€21€19€3320€0€3320€0€500€1950€400€470€0€    -110€0.8095€1820€0.7951€31€1200€27€300€0.4167€28
N€N0003€200106€EFL€11€21€24€4491€0€4491€0€1783€2333€275€100€0€      -6€0.1064€3238€0.0392€14€1253€18€€€
N€N0003€200106€ELN€11€21€8381€1698154€28233€1658521€9800€591927€749792€247952€77850€800€      71€0.0376€896938€0.0543€20€574910€16€196473€0.0643€24
N€N0003€200106€ELNWSA€11€21€81€15924€0€15924€0€2530€8535€2849€2010€0€      56€0.618€9810€0.2236€33€5214€14€900€0.1233€61
N€N0003€200106€ELNWSB€11€21€16€3710€0€3710€0€950€1510€800€450€0€      87€1.0969€2100€0.5145€54€1410€12€200€0.79€20
N€N0003€200106€EMC€11€21€47650€9897171€68202€9782039€39300€3244345€4085888€1836849€651461€1701€      -1€0.0249€5060991€0.0472€22€2257708€15€2502640€0.0544€30
N€N0003€200106€EMD€11€21€14€3634€0€3634€0€200€2219€700€515€0€      37€0.0971€1119€0.0607€21€2515€31€€€
N€N0003€200106€EPG€11€21€18292€3812438€35121€3757321€15900€1178720€1457845€694790€424248€17468€      33€0.0318€2175190€0.0565€26€985314€20€612717€0.0627€36
N€N0003€200106€EPGPR€11€21€4€589€0€589€0€0€0€100€489€0€      83€1.1746€489€0.234€91€100€142€€€
N€N0003€200106€EPGPRC€11€21€9€1800€0€1800€0€0€200€800€400€400€    -635€1.6667€500€0.298€99€900€253€400€1.05€42
N€N0003€200106€EPI€11€21€126€33956€200€33756€0€10726€15906€5444€1680€0€      -6€0.0843€13803€0.0236€22€19153€19€800€0.0238€21
N€N0003€200106€EPL€11€21€326€76532€0€76232€300€31698€32628€8058€4148€0€      86€0.039€33547€0.0448€20€41085€15€1900€0.0384€30
N€N0003€200106€EPN€11€21€918€207403€200€207003€200€67977€98548€24636€15492€550€     -16€0.0573€111443€0.0584€22€85320€22€10440€0.0449€39
N€N0003€200106€ESI€11€21€1347€263316€10079€252937€200€72537€103484€43898€32168€1050€      35€0.0683€113865€0.0789€32€107821€21€31451€0.1062€56
N€N0003€200106€ETA€11€21€30€6305€0€6305€0€800€3730€1385€390€0€      -9€0.0437€3350€0.023€24€2855€29€100€0.04€38
N€N0003€200106€EX€11€21€189€36259€200€36059€0€11720€18552€4551€1236€0€      19€0.0391€16262€0.0377€21€18701€14€1096€0.0338€35
N€N0003€200106€FC€11€21€39€7273€0€7273€0€2340€3733€1100€100€0€      25€0.0469€4128€0.0602€21€3045€11€100€0.02€14
N€N0003€200106€FCX€11€21€2268€477507€0€477007€500€224775€186859€45247€20626€0€      -9€0.0182€200039€0.0292€19€251445€13€26023€0.0258€17
N€N0003€200106€FCXA€11€21€203€43156€440€42716€0€15376€22763€3384€1049€144€      15€0.0382€23814€0.0421€19€17487€13€1415€0.0248€40
N€N0003€200106€FCXPRA€11€21€76€18015€0€18015€0€5645€7438€3682€1250€0€      20€0.0635€11571€0.0507€23€6444€22€€€
N€N0003€200106€FCXPRB€11€21€66€14738€0€14738€0€3662€8961€1765€350€0€     -13€0.1379€5695€0.0608€21€9043€19€€€
N€N0003€200106€FCXPRC€11€21€18€4202€0€4202€0€0€2202€1700€300€0€      41€0.1058€1100€0.0409€35€3102€25€€€
N€N0003€200106€FCXPRD€11€21€32€7878€0€7878€0€754€6474€650€0€0€      -9€0.0839€4508€0.0431€17€3370€19€€€
N€N0003€200106€FE€11€21€4339€852395€1200€849495€600€440011€305729€80238€22433€1684€      14€0.0259€297521€0.0334€15€484823€12€67751€0.0391€18
N€N0003€200106€FLR€11€21€2918€566592€10100€554892€1000€189895€244194€85222€36481€100€      80€0.062€286010€0.0751€20€184057€16€85825€0.1055€33
N€N0003€200106€FMC€11€21€1529€300685€6100€294585€0€119860€125954€33675€15096€0€     110€0.06€158560€0.0587€18€100317€17€35708€0.0695€31
N€N0003€200106€FO€11€21€2620€497417€300€496617€200€263838€184257€39171€9551€0€      17€0.0459€217394€0.0347€13€239890€11€39533€0.0497€21
N€N0003€200106€FOE€11€21€591€125134€506€124228€0€44257€57903€16669€5399€0€      17€0.0377€56458€0.0374€20€61161€16€6609€0.0451€19
N€N0003€200106€FOPRA€13€21€1€300€300€0€0€0€0€0€0€0€0€€€€€€€€€
N€N0003€200106€FOR€11€21€60€12184€0€12184€0€8401€3433€350€0€0€       6€0.0292€7012€0.0142€10€5172€7€€€
N€N0003€200106€FPCPRA€11€21€74€22202€0€22202€0€9105€6257€2976€3864€0€      34€0.1081€10106€0.0562€28€12096€34€€€
N€N0003€200106€FRC€11€21€251€47308€200€47108€0€11567€14565€9783€10893€300€      35€0.0645€16764€0.0702€53€24944€38€5400€0.1115€77
N€N0003€200106€FSH€11€21€917€195393€1100€194093€200€78546€81804€23834€10409€0€      51€0.0717€92235€0.068€22€89125€14€12933€0.0638€25
N€N0003€200106€FTI€11€21€1980€362127€100€361927€100€145638€148580€54179€13530€100€      97€0.0225€195780€0.0546€19€152912€17€13335€0.0439€26
N€N0003€200106€FWJ€11€21€3€900€0€900€0€0€900€0€0€0€      -2€0.1167€300€0.1€18€600€20€€€
N€N0003€200106€GBE€11€21€23€4475€0€4475€0€1148€1629€814€884€0€      -2€0.0771€2092€0.049€30€2083€24€300€0.05€49
N€N0003€200106€GCG€11€21€4€900€0€900€0€400€0€100€400€0€      12€-0.0011€700€0.0443€57€200€0€€€
N€N0003€200106€GDP€11€21€20€4550€0€4550€0€1660€2414€476€0€0€      27€0.0799€1889€0.0255€18€2261€11€400€0.015€11
N€N0003€200106€GGT€11€21€114€24322€0€24322€0€9040€11256€3414€612€0€      -2€0.0914€9010€0.0369€16€14434€18€878€0.0613€14
N€N0003€200106€GGTPR€11€21€9€2302€0€2302€0€400€1602€300€0€0€      55€0.2422€200€0.02€8€2102€16€€€
N€N0003€200106€GID€11€21€3€600€0€600€0€100€300€200€0€0€       0€0.0133€600€0.05€28€€€€€
N€N0003€200106€GK€11€21€110€17156€0€17156€0€1750€7742€4376€3062€226€       2€0.0597€9137€0.0484€35€6619€55€1400€0.0421€52
N€N0003€200106€GLC€11€21€1397€310305€2700€306105€1100€88027€135891€55266€26942€1079€       3€0.0268€152886€0.0322€25€129221€21€25098€0.0498€30
N€N0003€200106€GLG€11€21€210€51489€0€51089€400€30501€17462€3225€301€0€       1€0.0265€13063€0.0168€11€37509€11€917€0.0151€7
N€N0003€200106€GLH€11€21€201€45051€0€45051€0€15566€21649€5843€1993€0€     -27€0.143€14705€0.0661€23€28551€15€1795€0.0261€21
N€N0003€200106€GLW€11€21€31632€6854173€13360€6798713€38700€3855589€2284747€586994€109468€615€       1€0.0136€3112503€0.0242€12€2413309€9€1311601€0.0273€18
N€N0003€200106€GPB€11€21€94€26231€0€26231€0€4691€15476€4364€1700€0€     -37€0.0968€14042€0.057€21€11889€26€300€0.0167€53
N€N0003€200106€GPD€11€21€53€13433€0€13433€0€7588€5845€0€0€0€      21€0.1593€7865€0.0481€10€5268€10€300€0.1€9
N€N0003€200106€GPEPRA€11€21€62€17189€0€17189€0€7510€8831€848€0€0€      44€0.1118€10268€0.0573€13€6921€10€€€
N€N0003€200106€GPEPRT€11€21€57€14799€400€14399€0€6781€6318€1100€200€0€       8€0.0711€6620€0.0196€18€7779€8€€€
N€N0003€200106€GPEPRU€11€21€49€12589€0€12589€0€4059€8135€395€0€0€      32€0.1653€7537€0.0333€12€5052€11€€€
N€N0003€200106€GPEPRV€11€21€32€7953€0€7953€0€1966€4966€1021€0€0€      35€0.1588€4145€0.0421€17€3508€19€300€0.0733€14
N€N0003€200106€GPF€11€21€20€5986€0€5986€0€1030€3571€925€460€0€     -41€0.1622€1540€0.0802€23€4446€26€€€
N€N0003€200106€GPU€11€21€1834€331935€1599€329136€500€179273€123240€20383€6540€200€      30€0.0418€164349€0.0434€12€136469€11€28818€0.0411€15
N€N0003€200106€GRA€11€21€217€50998€0€50998€0€21532€22718€6164€584€0€     -14€0.0143€18821€0.0151€17€31361€14€816€0.0202€6
N€N0003€200106€GRB€11€21€163€27554€0€27554€0€5052€13374€6620€2508€0€       8€0.0295€12715€0.0593€26€13418€28€1421€0.0244€47
N€N0003€200106€GUPPRA€11€21€18€4554€0€4554€0€350€4204€0€0€0€       8€0.1284€2809€0.1062€13€1745€14€€€
N€N0003€200106€GUPPRB€11€21€21€5484€0€5484€0€550€4584€350€0€0€     -11€0.1667€3784€0.0723€15€1700€11€€€
N€N0003€200106€HAR€11€21€769€148497€1800€146597€100€34515€73133€27304€11745€0€      74€0.0552€68766€0.0854€26€67117€23€10814€0.1312€22
N€N0003€200106€HAS€11€21€2142€438982€100€437882€1000€174135€192970€53185€18592€0€       9€0.0301€246768€0.0269€17€172621€16€19493€0.0313€24
N€N0003€200106€HCN€11€21€804€177141€0€175441€800€59204€72907€26587€16813€730€     -32€0.034€81716€0.0317€27€85715€20€8810€0.0327€45
N€N0003€200106€HCNPRB€11€21€38€10125€0€10125€0€2217€4841€2284€783€0€       7€0.1173€6825€0.0796€25€2900€37€400€0.05€14
N€N0003€200106€HGR€11€21€31€7668€0€7668€0€2203€2650€1915€900€0€       1€0.0502€2915€0.0361€44€4653€19€100€0.02€8
N€N0003€200106€HIL€11€21€58€12938€0€12938€0€3997€7419€1222€300€0€      -1€0.0221€7891€0.0332€15€4547€15€500€0.026€18
N€N0003€200106€HIW€11€21€853€201813€138€201675€0€124564€67892€7219€1700€300€      17€0.0302€92008€0.0319€10€101169€9€8498€0.0282€18
N€N0003€200106€HIWPRB€11€21€48€13382€0€13382€0€3770€8212€1000€400€0€     -24€0.1308€9665€0.0841€16€3717€18€€€
N€N0003€200106€HIWPRD€11€21€51€13883€0€13883€0€3676€7969€2238€0€0€     -33€0.1521€8843€0.0724€17€4640€16€400€0.055€9
N€N0003€200106€HMA€11€21€1305€285451€0€284551€900€120298€111741€35184€17878€350€      16€0.0185€153353€0.0329€22€115598€15€16500€0.0365€33
N€N0003€200106€HMC€11€21€327€61763€0€61763€0€23757€28584€7033€2389€0€     112€0.1751€29459€0.1755€21€28592€13€3712€0.0987€30
N€N0003€200106€HMT€11€21€1019€248392€300€245792€2300€101541€107186€25592€12063€1710€       4€0.0155€123922€0.0207€20€115408€14€8762€0.018€59
N€N0003€200106€HMTPRA€11€21€40€10915€0€10915€0€2225€7190€1100€400€0€     -10€0.1225€4130€0.0509€12€6285€19€500€0.086€42
N€N0003€200106€HMTPRB€11€21€45€12320€0€12320€0€4705€5465€1700€450€0€     -65€0.0985€7575€0.0284€16€4545€23€200€0.1€18
N€N0003€200106€HMTPRC€11€21€58€16685€0€16685€0€4440€10635€1280€330€0€     -32€0.0897€7385€0.018€21€8900€13€400€0.05€7
N€N0003€200106€HON€11€21€19634€4537992€36160€4486970€11800€2162439€1652916€496192€184563€2660€      -6€0.0359€2222825€0.0602€16€1376974€12€898971€0.0831€26
N€N0003€200106€HOV€11€21€497€107289€200€106689€300€46229€49915€7595€3250€0€      30€0.0621€47328€0.0482€16€52446€13€7215€0.0522€15
N€N0003€200106€HZO€11€21€20€4175€0€4175€0€1240€2184€200€551€0€      21€0.039€1809€0.0585€30€2366€22€€€
N€N0003€200106€ICS€11€21€7€1506€0€1506€0€0€1506€0€0€0€      14€0.0675€770€0.0113€10€736€16€€€
N€N0003€200106€IDG€11€21€11€2461€0€2461€0€319€1494€648€0€0€      27€0.1105€1813€0.0317€11€€€648€0.1€38
N€N0003€200106€IEU€11€21€16€4255€0€4255€0€255€3200€400€400€0€     -14€0.2366€1555€0.0971€15€2700€36€€€
N€N0003€200106€IFX€11€21€738€155517€1600€152017€400€57220€65935€19363€9549€350€      54€0.1008€54177€0.0564€21€66889€15€31351€0.0759€27
N€N0003€200106€IGL€11€21€884€187910€400€187210€300€46812€77036€38157€24596€909€      10€0.0177€77292€0.0227€36€101416€23€8802€0.0292€38
N€N0003€200106€IML€11€21€24€6306€0€6306€0€857€3090€1110€945€304€      15€0.1118€4214€0.0282€50€1335€44€757€0.0617€87
N€N0003€200106€IQM€11€21€27€9088€0€9088€0€3112€3224€1533€1219€0€     -12€0.0412€2795€0.0247€19€6163€27€130€0.02€15
N€N0003€200106€IR€11€21€3775€759241€2050€754499€2100€278603€313443€122486€41102€1380€      26€0.0277€384981€0.0303€20€301091€17€70527€0.0412€26
N€N0003€200106€ISP€11€21€117€20875€0€20875€0€5474€11352€2541€1508€0€      45€0.0493€11155€0.0345€20€8420€19€1300€0.0331€33
N€N0003€200106€ITG€11€21€1108€235115€3900€231115€100€71405€116744€30416€12650€0€      75€0.0835€110607€0.0695€22€102156€15€18452€0.1072€32
N€N0003€200106€ITN€11€21€371€78922€429€78493€0€38979€31129€6358€2027€0€      31€0.0448€27960€0.0329€13€45177€12€5356€0.037€20
N€N0003€200106€ITT€11€21€1622€286838€300€285930€500€109564€148979€23443€4444€0€      38€0.0516€134635€0.0453€15€131715€12€20080€0.0523€18
N€N0003€200106€ITX€11€21€71€16878€200€16678€0€3675€9192€2450€1361€0€       0€0.0615€5862€0.039€25€7799€16€3017€0.0462€32
N€N0003€200106€ITXPR€11€21€8€1738€0€1738€0€199€729€450€360€0€    -122€0.3264€888€0.2684€41€700€45€150€0.5€10
N€N0003€200106€IVC€11€21€574€109326€0€109042€0€56256€39484€9774€3528€0€      -2€0.0595€52292€0.0707€14€49763€14€6987€0.0589€23
N€N0003€200106€JBL€11€21€10652€2021224€38650€1976374€5600€828342€716374€280748€152377€4133€      43€0.0406€978092€0.0497€20€664172€15€339710€0.0735€35
N€N0003€200106€JCP€11€21€4785€923275€3200€917192€2600€476919€354391€69553€17871€1058€      18€0.027€417906€0.0348€15€412601€11€89285€0.0462€17
N€N0003€200106€JEM€11€21€14€3691€0€3691€0€2595€846€250€0€0€      48€0.0709€650€0.0162€17€3041€8€€€
N€N0003€200106€JOE€11€21€560€109132€100€108932€100€37049€49203€13005€9415€360€      20€0.0545€30081€0.028€28€72812€20€6139€0.0361€55
N€N0003€200106€JYPPRZ€11€21€33€8294€0€8294€0€3987€2853€1454€0€0€     -11€0.0813€2801€0.0214€12€5093€17€400€0.055€13
N€N0003€200106€KBH€11€21€2003€396444€1900€393544€700€235578€135787€19031€3612€236€      31€0.052€158530€0.0436€12€201018€9€34696€0.062€18
N€N0003€200106€KBHPRG€12€23€1€4000€3800€200€0€0€200€0€0€0€     -80€0.25€€€€200€18€€€
N€N0003€200106€KBHPRI€11€21€10€1870€0€1870€0€670€1200€0€0€0€      -1€0.1165€600€0.0233€10€1270€11€€€
N€N0003€200106€KEG€11€21€1018€219955€1787€218168€0€79979€96492€29441€11905€351€       2€0.0309€96876€0.0251€21€100725€18€20567€0.0376€30
N€N0003€200106€KEI€11€21€1527€304821€3399€301422€0€107761€129096€42537€22028€0€      43€0.0795€140598€0.0738€21€117736€18€43088€0.0839€31
N€N0003€200106€KG€11€21€5215€1031366€8400€1021866€1100€454412€432306€107139€28667€442€      43€0.0377€522352€0.0555€16€392279€13€108335€0.069€18
N€N0003€200106€KLU€11€21€160€33466€0€33466€0€12755€16840€3321€550€0€       5€0.052€13916€0.0403€14€18540€14€1010€0.01€16
N€N0003€200106€KMB€11€21€10045€2164410€4955€2150133€7000€686439€883329€387441€193491€6433€      20€0.0322€1162179€0.0422€24€704899€21€290055€0.0583€29
N€N0003€200106€KOR€11€21€26€5566€0€5566€0€1145€2746€600€1075€0€     -21€0.0425€3656€0.0338€26€1910€33€€€
N€N0003€200106€KPA€11€21€290€63086€0€62586€500€27584€24830€7518€3154€0€       5€0.0301€18392€0.0203€18€41710€16€2984€0.0191€24
N€N0003€200106€KPAPRA€11€21€38€8841€0€8841€0€2025€3910€800€2106€0€     -17€0.2095€2760€0.056€50€5456€28€625€0.1156€16
N€N0003€200106€KRJ€11€21€4€1150€0€1150€0€300€850€0€0€0€       9€0.113€600€0.0833€18€550€14€€€
N€N0003€200106€KTB€11€21€24€6825€0€6825€0€1200€3975€850€800€0€      14€0.1024€4475€0.0597€29€2350€20€€€
N€N0003€200106€KTP€11€21€113€29875€0€29875€0€11654€14076€3720€425€0€      -6€0.1111€13092€0.0381€17€15603€15€1180€0.0632€17
N€N0003€200106€KYO€11€21€488€90772€0€90472€300€44067€39611€5763€1331€0€      87€0.3294€39291€0.1462€13€44089€12€7392€0.1991€15
N€N0003€200106€LBI€11€21€9€1540€0€1540€0€200€1090€250€0€0€     -20€0.0645€713€0.121€22€827€15€€€
N€N0003€200106€LDP€11€21€71€16330€0€16330€0€4713€7895€1543€2179€0€       7€0.0814€6311€0.0355€21€9254€26€765€0.0413€41
N€N0003€200106€LMM€11€21€5€1340€0€1340€0€400€450€490€0€0€       7€0.0192€210€0.0257€18€1130€27€€€
N€N0003€200106€LMS€11€21€40€8949€0€8949€0€1605€5269€1025€1050€0€     -23€0.0789€5069€0.0544€32€3770€16€110€0.02€12
N€N0003€200106€LMT€11€21€7427€1539221€2321€1534598€1500€813099€498258€155630€68871€240€      25€0.038€652816€0.0387€18€731392€12€151890€0.0449€19
N€N0003€200106€LNT€11€21€1104€241025€0€240325€700€74986€120488€33823€11428€300€       3€0.0345€72301€0.0345€18€155939€17€12785€0.0238€23
N€N0003€200106€LRY€11€21€728€157798€0€156898€900€63418€75594€14717€4069€0€     -11€0.0361€80555€0.0294€15€73460€14€3783€0.0312€21
N€N0003€200106€LRYPRA€11€21€45€11239€0€11239€0€5040€5074€675€450€0€      -9€0.1347€2244€0.0408€19€8795€14€200€0.05€24
N€N0003€200106€LSHPRA€11€21€38€8884€0€8884€0€1777€4625€1100€1382€0€      21€0.1001€4602€0.0332€34€4282€29€€€
N€N0003€200106€MAG€11€21€205€40664€100€40564€0€11519€19271€7942€1832€0€       3€0.034€18625€0.0561€21€21026€17€913€0.0264€46
N€N0003€200106€MAR€11€21€4566€852217€3439€847777€500€327186€338792€115285€64394€2620€      17€0.0336€371175€0.0377€23€376069€17€101033€0.0395€25
N€N0003€200106€MAT€11€21€6271€1269034€600€1265555€2400€804303€370087€74517€19048€0€       9€0.0286€536799€0.0232€12€603833€9€127323€0.0268€17
N€N0003€200106€MCC€11€21€92€15602€100€15502€0€3391€5930€2640€3441€100€      31€0.1551€10231€0.1351€48€3496€48€1775€0.1344€50
N€N0003€200106€MCO€11€21€2564€482050€300€481050€0€205260€224512€38524€12754€0€      50€0.0344€232157€0.0449€16€218413€12€30480€0.0506€21
N€N0003€200106€MCT€11€21€93€18905€300€18605€0€6170€8860€2500€1175€0€     -95€0.2168€10070€0.0931€22€7035€21€1500€0.0993€18
N€N0003€200106€MDG€11€21€222€44774€100€44574€100€18941€16881€6899€1953€0€       3€0.0379€17024€0.0225€15€23758€15€3892€0.029€43
N€N0003€200106€MEE€11€21€1036€209709€1746€206463€1500€66383€99319€28763€13498€0€      29€0.0405€111328€0.0591€22€81354€18€15281€0.0622€27
N€N0003€200106€MEH€11€21€251€48319€0€48319€0€14334€23793€6423€3769€0€      23€0.0701€17902€0.0429€26€24568€19€5849€0.046€31
N€N0003€200106€MER€11€21€30073€6760165€79577€6655420€22100€3730194€2256343€498914€187021€5048€      30€0.0551€3050308€0.0476€13€1925818€9€1701394€0.066€19
N€N0003€200106€MERPRA€11€21€78€19057€0€19057€0€7062€8478€2817€700€0€      20€0.101€10546€0.0317€22€8411€15€100€0.02€24
N€N0003€200106€MERPRB€11€21€79€20512€0€20512€0€6773€11414€1925€400€0€      -6€0.0985€12232€0.0367€16€7980€17€300€0.01€11
N€N0003€200106€MERPRC€11€21€75€18441€0€18441€0€4795€11057€1582€1007€0€      -5€0.1103€11160€0.0386€24€7181€16€100€0.07€17
N€N0003€200106€MERPRD€11€21€180€50455€0€50455€0€18698€26565€3992€1200€0€      -3€0.0677€28689€0.0208€17€21266€15€500€0.026€20
N€N0003€200106€MERPRE€11€21€91€24866€0€24866€0€7807€13364€1525€2170€0€       5€0.0673€17369€0.0194€23€7497€26€€€
N€N0003€200106€MERPRF€11€21€254€64465€0€64465€0€22971€30739€8030€2725€0€     -21€0.0566€35833€0.0187€19€27832€19€800€0.025€12
N€N0003€200106€MFW€11€21€32€7466€0€7466€0€2841€4113€512€0€0€      -3€0.0181€2029€0.0623€12€5437€14€€€
N€N0003€200106€MGF€11€21€70€16120€0€16120€0€6543€8899€500€178€0€       4€0.0166€3887€0.0103€17€12233€12€€€
N€N0003€200106€MHN€11€21€44€10018€0€10018€0€5361€3632€1025€0€0€      -2€0.0315€3926€0.014€17€5792€10€300€0.0133€16
N€N0003€200106€MIM€11€21€7€1347€0€1347€0€275€672€200€200€0€     -34€0.1074€140€0.13€24€1207€26€€€
N€N0003€200106€MLI€11€21€373€69963€100€69763€100€19462€27043€13949€9309€100€      46€0.0273€31833€0.0706€30€34350€30€3680€0.0433€50
N€N0003€200106€MLM€11€21€956€204799€300€204099€400€61064€95095€32619€15821€300€       9€0.0477€80241€0.0608€24€108917€20€15341€0.0475€23
N€N0003€200106€MLS€11€21€869€206055€0€205855€200€74780€98864€22395€10016€0€      -6€0.065€79217€0.0297€20€113979€14€12859€0.0332€28
N€N0003€200106€MMA€11€21€164€41547€0€41347€200€6120€18982€11510€4935€0€     -35€0.0759€18868€0.0622€31€22479€28€200€0.01€42
N€N0003€200106€MMC€11€21€7854€1504024€4800€1496324€2400€848935€524310€93936€31240€303€      96€0.0776€737970€0.0635€14€537240€9€223514€0.0759€16
N€N0003€200106€MMR€11€21€143€24452€0€24452€0€4408€14201€3524€2319€0€     -64€0.0584€10071€0.0532€24€13468€26€913€0.0605€21
N€N0003€200106€MMS€11€21€1627€318955€1900€315905€900€106853€137298€48809€23545€300€     169€0.0495€180240€0.06€24€113201€20€23364€0.0565€33
N€N0003€200106€MOT€11€21€15110€3328170€5844€3311576€8100€1598352€1234943€389062€96669€650€       2€0.0107€1631510€0.0236€17€1229766€10€458400€0.0247€21
N€N0003€200106€MOTPRA€11€21€193€54690€0€54690€0€19492€24106€8167€2925€0€      -1€0.0898€30541€0.0284€23€23749€17€400€0.025€16
N€N0003€200106€MPPRD€11€21€9€1975€0€1975€0€300€775€900€0€0€      29€0.2923€1600€0.04€28€375€14€€€
N€N0003€200106€MRX€11€21€1621€320344€8637€310782€200€63174€159322€56740€29946€1800€      17€0.0942€133022€0.0768€30€134927€24€43033€0.1141€30
N€N0003€200106€MSF€11€21€42€9509€0€9509€0€2112€6131€766€200€300€     -21€0.0626€3761€0.0423€15€5748€16€€€
N€N0003€200106€MTN€11€21€145€22165€0€21965€200€4845€12736€2407€2177€0€      46€0.0896€11127€0.0907€28€10716€22€322€0.1€10
N€N0003€200106€MTTPRX€11€21€23€5969€0€5969€0€850€4879€240€0€0€     124€0.1935€3074€0.1643€18€2895€13€€€
N€N0003€200106€MTX€11€21€764€141623€0€140313€0€59229€61833€11244€8007€0€      -3€0.062€55775€0.0467€18€74506€17€10032€0.0553€28
N€N0003€200106€MUC€11€21€37€9273€0€9273€0€3762€3999€400€1112€0€     -13€0.0279€5611€0.0146€17€3262€42€400€0.01€6
N€N0003€200106€MUJ€11€21€36€8266€0€8266€0€3118€4948€200€0€0€       1€0.0292€4991€0.0126€15€3275€10€€€
N€N0003€200106€MUO€11€21€47€10408€0€10408€0€2493€6074€1116€725€0€      -6€0.0519€3863€0.0223€24€6345€13€200€0.06€140
N€N0003€200106€MYI€11€21€107€32319€0€32319€0€11642€14632€3472€2373€200€     -11€0.0318€11728€0.0141€29€20291€17€300€0.01€18
N€N0003€200106€NAV€11€21€1165€207641€200€206594€300€100039€87977€14008€4870€0€      34€0.0271€94076€0.027€14€101550€12€11268€0.0438€17
N€N0003€200106€NC€11€21€422€70933€0€70933€0€24172€40012€5599€1150€0€     -71€0.1476€27278€0.0952€18€37888€11€5767€0.0974€18
N€N0003€200106€NCI€11€21€165€36300€0€36300€0€12555€13153€5331€4291€970€      20€0.0448€13065€0.0375€23€21642€25€1593€0.0567€119
N€N0003€200106€NDE€11€21€1140€252703€3500€248903€200€62581€105339€52043€27991€1149€      31€0.0427€103869€0.041€28€124648€23€20586€0.0692€57
N€N0003€200106€NEU€11€21€2069€434722€5500€427622€500€148279€190275€58105€31463€0€     118€0.0733€193603€0.0723€25€172307€15€62212€0.0672€31
N€N0003€200106€NMA€11€21€57€13504€0€13504€0€2868€6470€2799€1367€0€       5€0.033€1804€0.0319€18€11350€29€350€0.01€41
N€N0003€200106€NMI€11€21€23€5888€0€5888€0€2227€2881€580€200€0€      23€0.0667€4313€0.0145€18€1575€13€€€
N€N0003€200106€NMK€11€21€1636€308307€100€307707€400€114811€128594€41825€22677€200€       1€0.0191€97748€0.016€23€190283€18€20076€0.0143€28
N€N0003€200106€NMKPRK€11€21€1€100€0€100€0€100€0€0€0€0€     110€0.75€€€€100€9€€€
N€N0003€200106€NMT€11€21€21€5072€0€5072€0€507€4032€133€400€0€      20€0.0602€2876€0.023€19€2196€23€€€
N€N0003€200106€NPC€11€21€12€2425€0€2425€0€798€1627€0€0€0€       8€0.0694€927€0.0578€14€1498€14€€€
N€N0003€200106€NPV€11€21€36€8346€0€8346€0€2790€3706€1850€0€0€      10€0.0865€4223€0.0241€20€3823€17€300€0.01€13
N€N0003€200106€NQF€11€21€33€8197€0€8197€0€3319€3533€1145€0€200€      -1€0.0506€4778€0.0118€32€3419€10€€€
N€N0003€200106€NQS€11€21€50€13224€0€13224€0€3268€6571€3385€0€0€       6€0.0344€3655€0.0223€23€9235€17€334€0.04€32
N€N0003€200106€NSH€11€21€31€6351€0€6351€0€1216€4108€927€100€0€      -7€0.0711€3151€0.0624€19€3200€18€€€
N€N0003€200106€NSI€11€21€989€206016€700€204916€400€81854€88750€26478€8134€100€      26€0.053€78530€0.0423€19€115118€14€11668€0.0455€29
N€N0003€200106€NTC€11€21€29€7856€0€7856€0€2683€4673€500€0€0€      23€0.0692€5213€0.0129€16€2643€12€€€
N€N0003€200106€NUT€11€21€24€5170€0€5170€0€713€3916€541€0€0€      17€0.0767€3509€0.0365€19€1548€11€113€0.05€9
N€N0003€200106€NVN€11€21€60€17595€0€17595€0€3541€10820€1951€1283€0€      -8€0.0528€6675€0.015€21€10105€23€815€0.0316€14
N€N0003€200106€OAT€11€21€3034€570965€4200€565465€1300€270878€204505€62275€28792€315€      40€0.0499€293935€0.0578€17€213478€13€59352€0.0588€21
N€N0003€200106€OCN€11€21€196€44482€122€44160€200€11948€15964€8555€7893€0€      28€0.0487€16847€0.0378€38€24518€33€2995€0.0362€41
N€N0003€200106€OECPRT€11€21€37€8598€0€8598€0€5028€2770€600€200€0€      59€0.3758€5885€0.0151€16€2713€9€€€
N€N0003€200106€OFC€11€21€228€44336€0€44336€0€7456€16953€9168€10759€0€     -30€0.0313€17630€0.0546€51€22481€36€4225€0.0178€24
N€N0003€200106€OFCPRB€11€21€24€4268€0€4268€0€240€1775€1155€700€398€     -16€0.0926€2050€0.1197€37€2118€122€100€0.05€65
N€N0003€200106€OFCPRE€11€21€22€4805€0€4805€0€700€1725€1130€1150€100€      13€0.1068€2310€0.0747€57€2195€46€300€0.03€11
N€N0003€200106€OH€11€21€149€34617€140€34377€100€9919€17741€4045€2772€0€      -1€0.0328€14906€0.0318€32€19248€18€323€0.0286€89
N€N0003€200106€OI€11€21€353€74739€0€74739€0€33123€30579€7601€3436€0€      12€0.0219€24529€0.0238€16€47287€16€2923€0.0227€21
N€N0003€200106€OIPRA€11€21€62€16193€100€16093€0€2270€6602€2439€4282€500€     -37€0.1128€7247€0.0299€73€7547€45€1299€0.0585€54
N€N0003€200106€OMG€11€21€965€189051€1000€186551€0€54715€91492€27624€12720€0€      22€0.0607€70167€0.0623€23€97105€18€19279€0.0554€29
N€N0003€200106€OMI€11€21€565€107087€500€106087€300€26099€48534€18229€13525€0€      32€0.0552€41150€0.0578€29€56474€24€8763€0.0579€42
N€N0003€200106€ONE€11€21€10768€2557497€1921€2549239€4900€1590050€761410€159619€42657€403€       9€0.0277€1132248€0.0266€12€1085876€9€336015€0.0315€15
N€N0003€200106€ONEPRB€11€21€3€400€0€400€0€0€200€0€200€0€     211€2.3875€200€0.55€91€200€18€€€
N€N0003€200106€ONEPRC€11€21€1€100€0€100€0€0€0€0€100€0€1.5€2€100€1€83€€€€€
N€N0003€200106€ONEPRT€11€21€109€29362€0€29362€0€13993€11061€3728€580€0€     -24€0.0822€11554€0.0415€15€16908€15€900€0.0289€13
N€N0003€200106€ONEPRU€11€21€60€17827€0€17827€0€6895€7268€3264€400€0€     -23€0.1008€7272€0.0373€19€10355€15€200€0.05€22
N€N0003€200106€ONEPRV€11€21€93€23722€0€23722€0€10722€12220€400€380€0€     -10€0.0884€13172€0.031€12€9650€13€900€0.0311€19
N€N0003€200106€OSI€11€21€1058€248089€2075€245714€300€63505€109163€44599€28147€600€      23€0.0554€102160€0.0585€31€123370€21€20484€0.0677€33
N€N0003€200106€OTL€11€21€200€33973€0€33973€0€8320€18238€7115€300€0€      44€0.1038€11952€0.0549€18€17721€15€4300€0.2072€34
N€N0003€200106€OWC€11€21€426€97564€400€97164€0€51956€36885€6365€1958€0€       4€0.0286€25059€0.0166€13€64887€11€7218€0.0214€26
N€N0003€200106€PAG€11€21€182€38597€0€38597€0€14405€16254€5316€2622€0€       3€0.0262€13760€0.0177€24€24337€16€500€0.016€16
N€N0003€200106€PAR€11€21€38€8752€0€8752€0€2836€4398€1118€400€0€     -30€0.0644€3723€0.049€17€4629€33€400€0.0425€17
N€N0003€200106€PAS€11€21€469€116739€596€115743€0€32186€50278€20265€12755€259€      20€0.0361€55329€0.0333€31€57869€26€2545€0.0876€29
N€N0003€200106€PCEPR€11€21€28€7237€0€7237€0€1438€3578€1621€600€0€      37€0.1203€2378€0.0377€23€4459€27€400€0.0825€15
N€N0003€200106€PCEPRA€11€21€67€19235€0€19235€0€4495€7684€3786€3070€200€     -12€0.1339€6197€0.0854€34€12438€40€600€0.0767€103
N€N0003€200106€PCL€11€21€870€207041€0€205966€800€82550€84819€26006€12302€1289€      38€0.0518€79822€0.0285€32€112427€17€14517€0.0474€59
N€N0003€200106€PCT€11€21€41€10980€0€10980€0€1755€5233€2274€1718€0€      -4€0.1086€4575€0.0492€32€6405€31€€€
N€N0003€200106€PDE€11€21€1349€311176€2700€307576€900€153759€109523€33382€11412€400€       5€0.0241€146622€0.0338€16€130255€11€31599€0.0309€23
N€N0003€200106€PECPRX€11€21€31€9116€0€9116€0€3045€5421€650€0€0€      46€0.253€6766€0.2323€14€2250€16€100€0.2€13
N€N0003€200106€PEP€11€21€17054€3961781€3610€3935924€19800€1877493€1559852€407217€111162€0€      10€0.0169€2074843€0.0276€16€1458336€12€422545€0.0302€20
N€N0003€200106€PER€11€21€681€147898€1311€146587€0€54071€50664€20863€20325€664€      -3€0.0494€60502€0.0331€30€70966€23€15119€0.0414€37
N€N0003€200106€PFP€11€21€20€4346€0€4346€0€611€3014€223€498€0€      75€0.2408€2737€0.1043€23€1609€22€€€
N€N0003€200106€PFPPR€11€21€8€1998€0€1998€0€456€1542€0€0€0€      38€0.3709€1060€0.1181€14€938€3€€€
N€N0003€200106€PG€11€21€14631€3286058€7562€3265296€10900€1994720€980155€234132€65839€1200€      17€0.0383€1509114€0.0338€12€1185301€9€581781€0.0453€20
N€N0003€200106€PGF€11€21€13€3127€0€3127€0€400€2227€500€0€0€     -19€0.1322€200€0.1€37€2927€16€€€
N€N0003€200106€PGN€11€21€4449€803192€1050€800855€1100€395029€308406€70143€26814€1563€      11€0.0442€356946€0.0318€16€362495€12€82514€0.0394€21
N€N0003€200106€PHA€11€21€11090€2625800€5054€2615898€2300€1194257€945635€349082€129224€0€      18€0.0269€1208326€0.0303€19€1030728€13€379144€0.0395€26
N€N0003€200106€PII€11€21€547€102532€100€102432€0€41394€47177€10024€3837€0€     -53€0.0656€43817€0.0617€19€50009€14€8606€0.067€21
N€N0003€200106€PIK€11€21€20€3575€0€3575€0€200€1904€349€1122€0€      16€0.048€2316€0.061€22€1092€112€167€0.02€177
N€N0003€200106€PIM€11€21€174€49075€0€49075€0€24946€18678€4419€1032€0€     -11€0.0231€15250€0.0101€15€31123€13€2702€0.0172€21
N€N0003€200106€PIO€11€21€112€20834€0€20834€0€4049€12496€3547€742€0€     -15€0.1999€15381€0.3664€19€5353€24€100€0.03€57
N€N0003€200106€PKE€11€21€670€119484€100€119384€0€37310€62636€13909€5529€0€       0€0.0536€51032€0.0518€20€59311€16€9041€0.0835€42
N€N0003€200106€PKG€11€21€595€146975€435€146340€200€34426€54415€28787€26474€2438€      29€0.0363€71171€0.0341€45€66334€34€9035€0.0866€51
N€N0003€200106€PKX€11€21€711€142771€0€142226€200€41939€72365€20160€7962€0€      33€0.0222€67854€0.0374€22€71279€18€3293€0.0316€36
N€N0003€200106€PLP€11€21€84€20783€0€20783€0€6623€11908€1872€380€0€       1€0.0736€9234€0.0405€19€9569€14€1980€0.048€16
N€N0003€200106€PNP€11€21€360€77419€0€77419€0€21873€46990€6414€2142€0€      49€0.0584€39478€0.0455€17€35119€13€2822€0.0368€27
N€N0003€200106€PNW€11€21€2281€470049€2100€467443€400€193183€212965€42984€18311€400€      58€0.0449€244484€0.0442€17€188356€15€35003€0.0463€22
N€N0003€200106€PPD€11€21€1023€203099€1025€199574€2500€50324€81817€41329€28104€500€      -8€0.0512€76073€0.06€40€105458€21€20543€0.056€41
N€N0003€200106€PPP€11€21€1071€218104€600€217504€0€90001€84657€30380€12466€0€      33€0.0533€86443€0.0541€21€107964€17€23097€0.0719€22
N€N0003€200106€PPPPRQ€11€21€8€1220€0€1220€0€0€340€750€130€0€    -419€1.2508€400€0.461€62€820€29€€€
N€N0003€200106€PTV€11€21€2082€421537€524€420713€300€130636€203286€64391€22600€100€      14€0.0255€219254€0.0309€20€179782€19€21977€0.0307€20
N€N0003€200106€PX€11€21€4735€968093€4342€962551€400€391045€431840€105022€34611€433€      32€0.0323€517464€0.0384€17€360536€15€84951€0.0418€20
N€N0003€200106€RCL€11€21€888€192609€1279€191130€200€73260€79569€27645€10856€0€      -4€0.0309€71595€0.0366€23€106888€15€12847€0.0291€21
N€N0003€200106€RCN€11€21€119€26769€0€26769€0€7428€11535€3395€4411€0€     -65€0.13€9038€0.0576€40€14081€20€3650€0.0453€33
N€N0003€200106€RG€11€21€357€70949€0€70949€0€19784€28138€8150€13587€1290€       4€0.0507€16009€0.0463€71€42135€29€12805€0.0254€64
N€N0003€200106€RHB€11€21€1366€256151€6400€249751€0€54702€103946€53430€37673€0€     -13€0.1091€117310€0.0835€36€102790€26€29651€0.1028€46
N€N0003€200106€RHD€11€21€830€166190€100€165990€0€55871€81814€20848€7457€0€      19€0.0431€76146€0.0406€19€82195€17€7649€0.0406€25
N€N0003€200106€RHI€11€21€2239€438400€1243€436357€800€200230€165695€49195€21787€250€      40€0.0378€212536€0.0402€18€187120€13€37501€0.0493€32
N€N0003€200106€RJF€11€21€865€179628€1970€177558€100€59606€69661€26503€21888€0€      60€0.0605€84064€0.0491€26€80046€18€13548€0.063€43
N€N0003€200106€RL€11€21€883€188977€400€187027€1200€51875€75446€38251€22355€300€       7€0.0584€80017€0.0683€29€84714€25€23496€0.0661€31
N€N0003€200106€RMG€11€21€406€76807€0€76807€0€31060€36138€8459€1150€0€      63€0.0786€40447€0.0656€14€32940€14€3420€0.0411€29
N€N0003€200106€RML€11€21€302€65767€851€64916€0€15388€24785€9913€14430€400€      -1€0.0323€25040€0.0345€54€36262€32€3614€0.036€68
N€N0003€200106€RNS€11€21€11€3105€0€3105€0€1535€1370€200€0€0€    -196€0.1214€2105€0.1211€11€1000€14€€€
N€N0003€200106€ROP€11€21€637€119636€1400€118236€0€31245€46507€21949€17566€969€     -49€0.0654€52276€0.0767€37€54041€26€11919€0.076€60
N€N0003€200106€ROS€11€21€42€8810€0€8810€0€5900€2210€500€200€0€      15€0.0264€4960€0.0191€11€3850€15€€€
N€N0003€200106€ROV€11€21€1256€280099€300€278999€800€121057€99650€39115€18932€1045€      48€0.0251€165982€0.0469€20€98628€16€15189€0.0513€69
N€N0003€200106€RS€11€21€364€74715€300€74415€0€17112€35972€16048€5283€0€      16€0.0486€37850€0.0445€24€31898€21€4667€0.0411€26
N€N0003€200106€RSC€11€21€163€35415€0€35415€0€8219€17055€6911€3230€0€       7€0.1382€19992€0.0862€25€13593€24€1830€0.1025€40
N€N0003€200106€RTP€11€21€224€45752€200€45552€0€14891€21771€6917€1973€0€    -105€0.4891€17391€0.1724€22€23561€14€4600€0.5028€31
N€N0003€200106€RWT€11€21€272€52267€0€52267€0€18388€19210€10069€4600€0€       6€0.0721€25393€0.0563€23€24774€18€2100€0.0438€14
N€N0003€200106€RWTPRB€11€21€9€1638€0€1638€0€100€1288€100€150€0€      -2€0.0114€1239€0.599€39€399€13€€€
N€N0003€200106€RYN€11€21€672€128546€700€127446€0€34511€58160€23802€10373€600€     -12€0.0552€52145€0.0532€29€64697€21€10604€0.0443€37
N€N0003€200106€RZT€11€21€212€44179€0€44079€100€16442€21497€5031€1209€0€      15€0.0511€18311€0.046€16€23659€13€2209€0.09€34
N€N0003€200106€SACPR€11€21€3€700€0€700€0€0€0€200€500€0€      53€1.1014€€€€700€86€€€
N€N0003€200106€SACPRT€11€21€11€2493€0€2493€0€320€1463€300€410€0€      -2€0.2151€413€0.1299€17€1980€41€100€0.1€16
N€N0003€200106€SAIPRW€11€21€70€17471€0€17471€0€9608€6338€1125€400€0€     -25€0.0907€5971€0.0183€14€11400€15€100€0.03€7
N€N0003€200106€SBG€11€21€92€23981€0€23981€0€9947€6542€3638€3554€300€     -11€0.0256€12268€0.0161€38€11713€39€€€
N€N0003€200106€SC€11€21€804€171378€1200€169328€600€35189€66402€34353€32589€1295€      -1€0.0425€67572€0.0423€115€82345€33€20011€0.0432€74
N€N0003€200106€SCG€11€21€813€174445€1450€172995€0€36451€63067€41038€31401€1038€     -26€0.0434€73380€0.0352€39€85091€31€14524€0.0479€57
N€N0003€200106€SCL€11€21€28€4080€0€4080€0€797€977€1156€1007€143€      18€0.1141€1361€0.0648€33€2719€95€€€
N€N0003€200106€SCX€11€21€19€5156€0€5156€0€1378€1806€500€1472€0€      51€0.1732€871€0.1332€41€4185€42€100€0.14€18
N€N0003€200106€SCZ€11€21€416€93540€0€93440€100€37105€43330€8965€4140€0€      -2€0.0246€42050€0.032€19€49810€15€1680€0.0214€19
N€N0003€200106€SCZA€12€21€13€1667€270€1397€0€450€430€200€317€0€   -2735€6.7545€317€1€165€1080€17€€€
N€N0003€200106€SDH€11€21€187€41816€0€41816€0€18699€18351€3596€1170€0€       5€0.0167€12656€0.0124€16€28810€12€350€0.0243€60
N€N0003€200106€SGH€11€21€24€6168€0€6168€0€1085€2758€1200€1125€0€       4€0.1265€2783€0.0408€37€3000€41€385€0.033€9
N€N0003€200106€SGI€11€21€340€72667€350€72017€300€24900€32188€9337€5892€0€       0€0.013€22488€0.0123€20€46559€19€3270€0.0143€58
N€N0003€200106€SGR€11€21€6170€1299132€35974€1259458€2700€574617€455207€144340€85394€2700€     133€0.0949€654440€0.1078€20€422851€13€184867€0.1534€37
N€N0003€200106€SGU€11€21€421€102190€475€101715€0€24400€44647€16278€15490€900€     -39€0.0787€50870€0.0602€40€46623€28€4222€0.0301€56
N€N0003€200106€SII€11€21€12161€2461601€89352€2366784€2800€708230€989797€446578€224144€835€      63€0.1034€1098122€0.0831€23€658194€17€613268€0.1146€34
N€N0003€200106€SLC€11€21€462€102521€0€102521€0€31777€51814€14017€4913€0€       8€0.0498€39662€0.0221€22€51426€15€11433€0.021€27
N€N0003€200106€SLI€11€21€223€40617€418€39999€200€9667€16424€8563€5445€100€      38€0.0584€15844€0.0585€43€20722€21€3633€0.0345€53
N€N0003€200106€SO€11€21€7112€1830209€2000€1815354€11800€580083€787613€325490€133214€754€      -4€0.0234€654768€0.0233€25€930696€18€241690€0.0333€29
N€N0003€200106€SOPRA€11€21€65€16715€0€16715€0€3470€8827€1949€2469€0€      -2€0.0665€4028€0.0293€35€11087€27€1600€0.0338€30
N€N0003€200106€SOPRB€11€21€65€17925€0€17925€0€5235€6861€2834€2995€0€      19€0.0985€10104€0.042€50€7421€23€400€0.0375€42
N€N0003€200106€SOPRC€11€21€62€16462€0€16462€0€2966€8671€3400€1425€0€     -30€0.0901€6935€0.0333€27€8927€25€600€0.0367€33
N€N0003€200106€SP€11€21€2259€417878€20700€395978€1000€88276€173307€84940€49425€1030€     346€0.2098€199842€0.171€26€116566€21€80570€0.2007€41
N€N0003€200106€SPN€11€21€400€100444€325€100119€0€31571€45383€12267€10898€0€      39€0.0288€43292€0.0424€30€56427€21€400€0.015€91
N€N0003€200106€SPP€11€21€229€51056€0€50756€300€10669€25951€9287€5149€0€      15€0.0357€20559€0.0263€30€27662€21€2835€0.0104€42
N€N0003€200106€SRE€11€21€4174€776656€470€775086€1100€536186€219314€17703€2755€228€      28€0.0319€347116€0.0326€9€370017€8€59053€0.036€11
N€N0003€200106€SREPRA€11€21€101€28661€0€28661€0€5688€17888€3435€1650€0€      11€0.1707€17662€0.1052€21€10199€21€800€0.075€20
N€N0003€200106€SSD€11€21€206€35844€500€35344€0€9983€16926€5118€3317€0€      60€0.1372€17605€0.1104€33€13239€17€4500€0.1138€32
N€N0003€200106€SSR€11€21€75€19430€0€19430€0€3254€10127€4436€1013€600€     -14€0.0911€7555€0.0238€45€11475€28€400€0.035€22
N€N0003€200106€STZ€11€21€1619€339807€2000€337207€600€85800€149849€59664€42094€400€      17€0.0667€138641€0.0823€34€166570€25€32596€0.0947€42
N€N0003€200106€STZB€12€21€2€624€0€624€0€0€0€0€624€0€     -12€2.1795€€€€400€153€224€0.25€294
N€N0003€200106€SUR€11€21€181€31393€0€31393€0€11609€15609€2915€1260€0€      -5€0.0639€12522€0.0329€17€17749€15€1122€0.04€22
N€N0003€200106€SUT€11€21€236€35284€0€35084€0€12819€18577€3588€100€0€     -43€0.0223€16575€0.0263€15€17409€13€1100€0.0291€14
N€N0003€200106€SUTPRA€11€21€47€10131€0€10131€0€1975€6048€2008€100€0€     -10€0.1397€5027€0.083€25€5104€15€€€
N€N0003€200106€SVAPR€11€21€12€3315€0€3315€0€200€1775€1340€0€0€     -13€0.1859€1185€0.0888€22€1930€29€200€0.05€13
N€N0003€200106€SWM€11€21€126€25116€100€25016€0€8271€12267€3269€1209€0€      14€0.0897€9365€0.0636€26€13651€16€2000€0.075€24
N€N0003€200106€SZ€11€21€12€2987€0€2987€0€0€1937€900€150€0€       4€0.0453€500€0.03€30€2487€36€€€
N€N0003€200106€TAPPRA€11€21€151€40656€0€40656€0€9089€25026€6266€275€0€      -1€0.0587€14590€0.0156€21€25766€17€300€0.03€15
N€N0003€200106€TAPPRB€11€21€23€5637€0€5637€0€628€4379€630€0€0€      22€0.112€4215€0.0363€18€1222€10€200€0.04€11
N€N0003€200106€TCC€11€21€160€33038€0€32738€300€5154€13144€8508€6232€0€       4€0.0487€15161€0.0428€44€15526€27€2351€0.0516€33
N€N0003€200106€TCH€11€21€46€10532€0€10532€0€1828€7022€700€982€0€      35€0.0697€2692€0.0298€26€7640€21€200€0.05€0
N€N0003€200106€TCLPR€11€21€23€6611€0€6611€0€2911€3700€0€0€0€       8€0.1033€1800€0.0339€16€4811€11€€€
N€N0003€200106€TCR€11€21€254€64034€0€64034€0€13892€25318€11708€12916€200€     -26€0.0366€20925€0.0261€44€38017€34€5092€0.0244€58
N€N0003€200106€TD€11€21€444€84704€200€84504€0€26904€43499€9309€4792€0€      13€0.0518€30355€0.0191€20€40045€14€14104€0.0498€25
N€N0003€200106€TDI€11€21€22€5012€0€5012€0€850€2266€1175€721€0€     -21€0.177€2011€0.0975€46€3001€24€€€
N€N0003€200106€TDR€11€21€26€4930€0€4930€0€160€4120€450€200€0€     -43€0.1429€3070€0.0602€24€1860€18€€€
N€N0003€200106€TDY€11€21€602€111666€327€111339€0€39645€56089€11267€4338€0€      25€0.0325€46693€0.0382€21€60096€14€4550€0.0372€18
N€N0003€200106€TEE€11€21€387€93634€194€93440€0€38091€39954€10290€5205€0€       6€0.0979€55764€0.0522€17€33575€17€4101€0.0442€24
N€N0003€200106€TEF€11€21€1902€396187€0€395605€100€185332€137753€47922€24698€0€      39€0.0489€199060€0.031€21€167710€14€28935€0.0439€27
N€N0003€200106€TEM€11€21€5€975€0€975€0€375€200€400€0€0€      43€0.2467€300€0.1167€11€675€25€€€
N€N0003€200106€TEN€11€21€340€70065€0€70065€0€20950€30885€10353€7877€0€      16€0.0338€26121€0.0405€24€39987€23€3957€0.0298€12
N€N0003€200106€TFS€11€21€769€145212€800€143612€800€41861€68860€23910€9781€0€      50€0.0531€57459€0.0478€23€76318€19€10635€0.0542€23
N€N0003€200106€TGT€11€21€13947€3240598€7313€3215448€13900€1249034€1213942€478651€281570€6151€       0€0.0267€1754183€0.0402€22€1020458€16€454707€0.0506€33
N€N0003€200106€THX€11€21€702€138946€400€137546€600€38790€53171€27131€18274€780€      22€0.0806€45773€0.104€35€75898€24€16475€0.1466€48
N€N0003€200106€TI€11€21€314€58047€100€57847€100€5609€27586€14591€9798€363€    -117€0.3006€31788€0.331€46€23256€24€2903€0.1905€36
N€N0003€200106€TIA€12€23€1€3300€2600€700€0€0€0€0€700€0€    -889€2.68€€€€700€208€€€
N€N0003€200106€TLI€11€21€70€18393€0€18393€0€5914€7198€3215€2066€0€       6€0.0413€4007€0.0171€38€13686€23€700€0.0357€23
N€N0003€200106€TLK€11€21€37€9060€0€9060€0€1072€5706€1383€899€0€      13€0.0239€6138€0.0201€21€2922€33€€€
N€N0003€200106€TOL€11€21€1670€345725€1300€343187€300€106434€153897€54404€28752€0€       2€0.0455€141820€0.0581€27€171803€19€29864€0.0657€25
N€N0003€200106€TR€11€21€913€189915€1800€188115€0€37995€79907€42395€26708€1110€     -93€0.0758€79587€0.0422€37€92597€28€15931€0.1202€54
N€N0003€200106€TRA€11€21€304€53919€100€53619€200€18468€22849€10610€1892€200€      -5€0.0187€18222€0.0285€24€34022€21€1575€0.0225€27
N€N0003€200106€TRP€11€21€180€40568€300€39968€300€18516€17508€3049€1195€0€      11€0.0269€17545€0.0144€14€22113€14€610€0.0166€13
N€N0003€200106€TRPPR€11€21€65€18352€0€18352€0€6762€8990€2100€500€0€      -1€0.0513€8625€0.0222€22€9527€12€200€0.03€10
N€N0003€200106€TRPPRC€11€21€25€6352€0€6352€0€3210€2942€200€0€0€      -3€0.0643€2510€0.0303€14€3842€11€€€
N€N0003€200106€TTR€11€21€23€6839€0€6839€0€4785€1668€386€0€0€    -136€0.0552€1506€0.0338€10€5333€9€€€
N€N0003€200106€TWE€11€21€558€116045€212€115233€600€36782€50391€20674€7986€0€     -79€0.0223€38403€0.0222€28€69540€19€7890€0.0292€31
N€N0003€200106€TWK€11€21€339€62550€426€62124€0€17218€21312€10709€12585€300€      46€0.0307€32607€0.0461€34€27617€38€1900€0.0442€41
N€N0003€200106€TX€11€21€10843€2376297€9060€2363465€2500€1397168€761431€163587€43779€0€      26€0.0354€1075238€0.0369€12€866775€10€423952€0.0385€15
N€N0003€200106€TXCPRA€11€21€138€35819€0€35819€0€20100€13164€1840€615€100€     -10€0.0725€12355€0.0141€13€22764€13€700€0.0557€15
N€N0003€200106€TXCPRB€11€21€33€7489€0€7489€0€2855€3884€600€150€0€     114€0.1246€3550€0.0445€12€3739€19€200€0.01€22
N€N0003€200106€TXN€11€21€32718€7538253€101229€7394161€34500€2539737€2403485€1376649€1086906€21884€      14€0.0401€3888049€0.0556€27€1778802€21€1761810€0.066€43
N€N0003€200106€UIS€11€21€3976€863380€300€860260€2600€520238€271865€59247€11158€352€       6€0.0169€410722€0.0227€12€392168€9€59970€0.0259€19
N€N0003€200106€VAP€11€21€25€5620€0€5620€0€1085€2560€500€1475€0€      46€0.0888€4035€0.0313€40€1485€25€100€0.02€11
N€N0003€200106€VBF€11€21€88€20011€0€20011€0€4270€7857€4087€3597€200€       3€0.0668€10578€0.0362€41€9233€30€200€0.02€320
N€N0003€200106€VEA€11€21€61€17329€0€17329€0€5199€9135€2195€800€0€     -27€0.0988€8620€0.0473€19€8309€17€400€0.04€15
N€N0003€200106€VELPRT€11€21€40€9565€0€9565€0€3225€5640€600€100€0€       1€0.1207€5245€0.0358€15€4020€10€300€0.07€21
N€N0003€200106€VGM€11€21€26€5974€0€5974€0€2694€2750€530€0€0€       8€0.0349€3386€0.0109€14€2588€12€€€
N€N0003€200106€VGR€11€21€505€95521€600€94921€0€26817€43606€15460€8788€250€      76€0.1196€39410€0.111€32€46153€19€9358€0.0972€28
N€N0003€200106€VIG€11€21€10€2057€0€2057€0€389€1668€0€0€0€       5€0.0391€800€0.0125€10€1157€10€100€0.01€13
N€N0003€200106€VIN€11€21€31€6807€0€6807€0€2456€1434€892€2025€0€      15€0.0312€2010€0.013€41€4797€48€€€
N€N0003€200106€VIT€11€21€48€12624€0€12624€0€7444€4875€305€0€0€       5€0.0359€6412€0.0114€11€5887€8€325€0.01€8
N€N0003€200106€VNV€11€21€7€2270€0€2270€0€780€1190€300€0€0€      -2€0.0457€538€0.01€26€1732€10€€€
N€N0003€200106€VOD€11€21€7053€1514065€2700€1506152€4300€792257€578419€118150€21426€200€       8€0.0158€842187€0.0218€14€579386€10€88879€0.0263€17
N€N0003€200106€VOL€11€21€102€20551€0€20551€0€5757€10161€2999€1534€100€      37€0.0808€10322€0.0528€27€8844€20€1385€0.0453€26
N€N0003€200106€VOT€11€21€23€6573€0€6573€0€2658€3686€229€0€0€       2€0.0539€2850€0.0175€15€2968€10€755€0.01€23
N€N0003€200106€VPA€11€21€33€9050€0€9050€0€1907€5339€1300€504€0€      12€0.0632€5957€0.0343€22€3093€18€€€
N€N0003€200106€VPQ€11€21€33€8868€0€8868€0€2747€4560€686€875€0€      10€0.0517€3903€0.0212€19€4965€23€€€
N€N0003€200106€VRC€11€21€3288€721772€1186€719800€600€264831€294864€105814€54891€0€       6€0.045€286261€0.0307€21€317784€20€116355€0.0471€28
N€N0003€200106€VSH€11€21€2045€439313€1600€434513€3200€160494€181677€67281€28161€100€      22€0.0236€201249€0.0324€22€186762€16€49702€0.0348€26
N€N0003€200106€VVC€11€21€766€178642€300€178342€0€45864€72830€35634€23102€912€     -21€0.0386€69059€0.0436€36€101042€24€8241€0.0549€69
N€N0003€200106€VVR€11€21€328€83284€0€83284€0€28751€37822€13076€3635€0€      -4€0.013€15688€0.0125€22€66309€18€1287€0.01€29
N€N0003€200106€WFR€11€21€248€55333€0€55133€200€19295€21918€7154€6214€752€     -23€0.0502€20319€0.0448€40€31596€17€3418€0.0496€22
N€N0003€200106€WG€11€21€177€43323€200€43123€0€7887€16391€10247€8498€100€     -13€0.0786€26932€0.0573€40€12256€37€3935€0.0413€33
N€N0003€200106€WLP€11€21€3166€613165€3600€607565€1800€224212€285602€70528€28442€581€      53€0.0537€307476€0.0591€19€225772€15€76117€0.0715€21
N€N0003€200106€WNI€11€21€6€620€0€620€0€100€320€200€0€0€       5€0.0194€420€0.0333€11€200€39€€€
N€N0003€200106€WSM€11€21€1521€335089€7400€327689€0€107654€147769€43968€28298€0€      61€0.0431€146297€0.0509€24€138437€17€42955€0.0611€38
N€N0003€200106€WTS€11€21€134€25867€0€25867€0€9094€10894€4105€1774€0€      21€0.0725€13047€0.0591€24€12620€23€200€0.01€8
N€N0003€200106€XRX€11€21€6165€1563755€1500€1551990€9300€899430€518310€111272€32278€0€       1€0.0141€589903€0.0185€14€835374€9€136013€0.0244€21
N€N0003€200106€XVF€11€21€284€63667€300€63367€0€20329€30220€10193€2625€0€     -66€0.2107€36209€0.0865€21€24028€17€3130€0.1246€6
N€N0003€200106€YLD€11€21€49€13280€0€13280€0€5464€4515€2276€1025€0€      -7€0.0193€3096€0.0162€19€9884€23€300€0.01€7
N€N0003€200106€YUM€11€21€3481€681270€15304€663764€1800€124966€222082€150777€158519€9220€      26€0.025€322286€0.0381€48€259741€38€83537€0.0503€67
N€N0003€200106€ZIF€11€21€45€9335€0€9335€0€3943€4592€700€100€0€     -26€0.0384€4741€0.018€12€4594€17€€€
N€N0003€200106€ZMX€11€21€13€2620€0€2620€0€0€1999€353€268€0€     -14€0.0335€1979€0.0469€24€641€47€€€'

	EXEC -t'€' -k 4,4 -lsum,regress,op=avg:float:17 $data/euro.dat
		OUTPUT - $'N€N0003€200106€AA€11€21€14596€3524300€9331€3494983€15500€1129332€1283396€639798€452298€5659€1.05000€0.0289€1717663€0.038€30€1195358€20€597462€0.0481€35
N€N0003€200106€AAT€11€21€48€14046€0€14046€0€7421€4549€1485€591€0€       0€0.0304€2513€0.01€25€11333€14€200€0.01€90
N€N0003€200106€ABJ€11€21€57€14508€0€14508€0€2603€9175€1650€1080€0€2.52941€0.0779€6636€0.0136€17€7872€25€€€
N€N0003€200106€ABS€11€21€7425€1465605€200€1461410€2900€483622€651665€241738€87165€120€0.25000€0.0284€599869€0.0306€22€670152€18€194289€0.0373€25
N€N0003€200106€ABT€11€21€14051€3368858€8904€3347422€10900€1469987€1273455€447558€166267€1055€0.50000€0.0273€1682138€0.0365€18€1150749€14€525435€0.044€25
N€N0003€200106€ACA€11€21€45€11490€0€11490€0€2845€7495€100€1050€0€-0.750€0.0946€5052€0.0146€17€6438€22€€€
N€N0003€200106€ACS€11€21€2456€523323€13500€509523€0€192518€202103€71973€42229€700€3.95000€0.0658€254514€0.0654€21€177869€17€77140€0.0915€38
N€N0003€200106€AEF€11€21€210€61757€0€61757€0€9524€22881€15536€13616€200€-0.300€0.0464€24867€0.0137€47€35248€43€1642€0.0401€27
N€N0003€200106€AET€11€21€2439€472785€900€471531€300€213068€162069€63465€32949€280€1.20000€0.0217€214120€0.0315€22€224763€16€32948€0.035€26
N€N0003€200106€AGC€11€21€6689€1443428€2747€1438956€1000€588445€574302€188125€88940€0€0.15000€0.0283€603123€0.0256€22€661220€16€175613€0.0329€31
N€N0003€200106€AGCPRA€11€21€56€16339€0€16339€0€3810€5914€4990€1625€0€1.05882€0.1187€7461€0.11€44€8678€25€200€0.085€8
N€N0003€200106€AGCPRB€11€21€25€6853€0€6853€0€100€3855€1550€1348€0€2.68750€0.115€3097€0.0587€44€3756€46€€€
N€N0003€200106€AGCPRM€11€21€57€15702€100€15602€0€1685€7911€3046€2170€790€-1.438€0.0876€4071€0.0247€64€11031€65€500€0.078€166
N€N0003€200106€AGCPRMCL€11€21€4€1223€0€1223€0€0€923€300€0€0€1.70000€0.04€1223€0.01€22€€€€€
N€N0003€200106€AGCPRN€11€21€82€18338€0€18338€0€5186€8423€2223€2306€200€      -1€0.0967€2885€0.0334€65€15203€23€250€0.046€21
N€N0003€200106€AGCPRNCL€11€21€3€665€0€665€0€100€565€0€0€0€1.14286€0.01€€€€665€21€€€
N€N0003€200106€AGI€11€21€23€4879€0€4879€0€730€2761€1388€0€0€0.88889€0.0238€4099€0.0433€19€780€29€€€
N€N0003€200106€AHO€11€21€514€101764€100€101464€200€25120€56355€13898€6291€0€0.20000€0.061€51772€0.043€22€43731€19€6161€0.0371€23
N€N0003€200106€AIV€11€21€697€143764€0€143464€0€58036€56027€19187€10214€0€-0.100€0.0629€54117€0.0484€20€80319€20€9028€0.0438€29
N€N0003€200106€AIVPRC€11€21€23€5998€0€5998€0€2025€2725€948€300€0€-0.333€0.1098€2675€0.0259€25€3023€15€300€0.09€37
N€N0003€200106€AIVPRD€11€21€63€15180€0€15180€0€5430€8025€825€900€0€1.33333€0.1226€6105€0.0322€15€8975€24€100€0.04€12
N€N0003€200106€AIVPRG€11€21€45€12295€0€12295€0€3195€6435€1315€1350€0€-0.389€0.0783€3675€0.0122€30€7920€24€700€0.0343€32
N€N0003€200106€AIVPRH€11€21€25€5959€0€5959€0€2100€3074€785€0€0€-1.625€0.1345€2824€0.0322€13€3035€18€100€0.11€9
N€N0003€200106€AIVPRK€11€21€9€2070€0€2070€0€0€1070€600€400€0€0.33333€0.4413€1350€0.1863€48€720€20€€€
N€N0003€200106€AIVPRP€11€21€56€11916€0€11916€0€3681€4873€2148€1214€0€       1€0.2129€3376€0.0379€23€8540€26€€€
N€N0003€200106€AIVPRQ€11€21€39€10242€0€10242€0€3898€5497€327€520€0€-0.105€0.0792€4613€0.0174€19€5629€13€€€
N€N0003€200106€AJG€11€21€875€196649€600€196049€0€80999€79015€21230€12954€1851€0.95000€0.0426€79215€0.0366€26€106810€13€10024€0.0518€45
N€N0003€200106€ALM€11€21€38€9137€0€9137€0€300€7876€961€0€0€-1.389€0.0618€7139€0.0245€19€1998€15€€€
N€N0003€200106€ALPPRN€11€21€3€1290€0€1290€0€0€890€400€0€0€0.20000€0.181€400€0.05€16€890€21€€€
N€N0003€200106€ALPPRO€11€21€6€1700€0€1700€0€0€1700€0€0€0€-9.778€0.2247€950€0.0621€26€750€18€€€
N€N0003€200106€ALPPRQ€11€21€28€7400€0€7400€0€2517€4483€400€0€0€0.21429€0.0795€3496€0.0287€17€3904€11€€€
N€N0003€200106€ALPPRR€11€21€43€12186€0€12186€0€2223€8511€1152€300€0€-1.294€0.0713€4546€0.0179€18€7540€15€100€0.04€63
N€N0003€200106€ALQ€11€21€53€14947€0€14947€0€5706€7091€2050€100€0€0.83333€0.0864€8607€0.0231€21€6040€12€300€0.01€7
N€N0003€200106€ALZ€11€21€38€10019€0€10019€0€800€8563€656€0€0€2.29412€0.1095€6749€0.0256€19€3270€13€€€
N€N0003€200106€AMB€11€21€340€82057€0€81694€0€49345€26444€3944€1961€0€0.15000€0.029€37759€0.0248€12€40635€11€3300€0.0224€15
N€N0003€200106€AMBPRA€11€21€19€5460€0€5460€0€3560€1700€200€0€0€       1€0.1091€3300€0.0473€10€2160€13€€€
N€N0003€200106€AMD€11€21€22321€4782471€105767€4655665€17300€1343670€1809871€952933€564656€1635€0.70000€0.0399€2160554€0.0464€24€1180503€21€1331908€0.0601€37
N€N0003€200106€ANN€11€21€1471€308613€7500€301013€100€160173€110558€25319€5063€0€2.95000€0.0525€131184€0.0608€13€134861€10€35068€0.0762€17
N€N0003€200106€AOC€11€21€3951€740421€1545€737685€900€213132€304297€146622€73959€575€0.50000€0.0241€340231€0.0367€28€337678€21€60676€0.0378€34
N€N0003€200106€ARB€11€21€432€81559€300€81259€0€24043€40724€12568€3924€0€0.90000€0.0549€39589€0.0546€22€36715€18€4955€0.0477€23
N€N0003€200106€ARH€11€21€9€1815€0€1815€0€400€1115€100€200€0€-0.350€0.0527€1190€0.0182€31€625€19€€€
N€N0003€200106€ATI€11€21€1153€204221€195€204026€0€95949€86063€15394€6520€100€1.10000€0.0249€88367€0.0285€16€109155€13€6504€0.0249€20
N€N0003€200106€AVP€11€21€5362€1025278€1664€1021714€1300€640871€320330€47980€12801€1032€1.30000€0.0305€463631€0.0358€10€466899€8€92484€0.0454€15
N€N0003€200106€AVZ€11€21€203€42999€0€42899€100€15985€19543€6471€1000€0€1.30000€0.1957€20702€0.1167€19€19355€14€2942€0.0663€19
N€N0003€200106€AXL€11€21€233€43442€0€43442€0€11343€20974€6885€4240€0€-0.950€0.0834€21281€0.0732€30€20822€22€1339€0.0249€14
N€N0003€200106€AZA€11€21€4036€777156€5600€770456€500€475253€227074€51985€16512€132€-0.200€0.0359€346051€0.0248€11€287853€9€137052€0.035€17
N€N0003€200106€AZZ€11€21€141€30688€0€30688€0€5454€17696€5938€1600€0€2.62500€0.0925€17081€0.0713€24€12107€24€1500€0.0293€20
N€N0003€200106€BC€11€21€1794€347438€2150€344388€900€119326€140853€55052€29034€1023€1.40000€0.0287€151059€0.0335€27€165409€19€28820€0.0421€28
N€N0003€200106€BCC€11€21€1261€232534€1500€231034€0€90880€102617€27338€10199€0€1.60000€0.0495€86498€0.0425€21€123377€15€21159€0.0489€20
N€N0003€200106€BD€11€21€132€26224€200€26024€0€8210€15964€1850€0€0€       0€0.0147€10370€0.0141€12€14654€13€1000€0.014€21
N€N0003€200106€BDF€11€21€39€9620€0€9620€0€3229€4243€1738€410€0€-1.188€0.0565€2903€0.0136€13€6717€23€€€
N€N0003€200106€BGG€11€21€774€164711€600€163823€0€76597€68590€14556€4080€0€1.31579€0.0874€65955€0.0439€16€85847€11€12021€0.0977€21
N€N0003€200106€BGT€11€21€60€15473€0€15473€0€8014€5024€1985€450€0€0.50000€0.0185€3385€0.01€10€12088€14€€€
N€N0003€200106€BK€11€21€14814€3340606€5800€3332030€800€2109454€974660€195186€53530€0€1.20000€0.0372€1548826€0.0305€11€1273475€9€510529€0.0417€16
N€N0003€200106€BKE€11€21€104€18544€0€18544€0€3788€12093€2226€437€0€1.70000€0.0528€10301€0.0694€18€7843€20€400€0.035€15
N€N0003€200106€BKPRC€11€21€66€17897€0€17897€0€10855€5842€850€350€0€0.44444€0.0857€8767€0.0274€15€8630€11€500€0.028€7
N€N0003€200106€BKPRD€11€21€80€21826€0€21826€0€13055€7571€500€700€0€0.68421€0.0714€10371€0.0168€11€11155€14€300€0.08€18
N€N0003€200106€BKPRE€11€21€81€23243€0€23243€0€10876€10497€1470€400€0€1.66667€0.0832€15715€0.0205€15€7528€12€€€
N€N0003€200106€BLI€11€21€1232€227952€1609€226143€100€75627€104943€33926€11747€0€0.50000€0.0263€112032€0.0332€20€104908€17€9303€0.0328€22
N€N0003€200106€BNI€11€21€6187€1206018€400€1203328€1600€680896€414696€85020€23178€1138€       0€0.0285€588392€0.0262€13€511908€10€104628€0.0403€19
N€N0003€200106€BR€11€21€7135€1378982€4900€1370416€2000€687207€493400€131614€58722€1473€0.60000€0.0302€782525€0.0406€16€459377€12€130514€0.0503€29
N€N0003€200106€BRG€11€21€56€11360€0€11360€0€2143€6614€1791€812€0€-1.765€0.1699€6410€0.118€29€4850€22€100€0.1€63
N€N0003€200106€BSP€11€21€25€4791€0€4791€0€1745€2537€509€0€0€0.63158€0.0835€2054€0.0143€14€2337€15€400€0.045€9
N€N0003€200106€BTY€11€21€1036€203914€400€203314€200€78459€82586€27485€14884€100€5.36842€0.1174€111376€0.0744€24€78300€16€13838€0.0657€24
N€N0002€200106€BTYRT€11€21€239€50506€0€50506€0€19517€24313€3320€3356€0€-60.30€0.1598€32175€0.1498€23€17731€14€600€0.055€20
N€N0003€200106€BWG€11€21€30€6512€0€6512€0€1183€4379€650€300€0€-0.333€0.1734€4366€0.0936€24€2046€21€100€0.08€0
N€N0003€200106€BXS€11€21€157€33939€0€33939€0€14334€13818€5063€724€0€0.65000€0.0378€17439€0.042€14€15418€17€1082€0.0204€22
N€N0003€200106€BYD€11€21€166€35218€200€35018€0€8011€13121€6471€7115€300€0.05000€0.0426€12541€0.0321€37€19449€44€3028€0.0338€50
N€N0003€200106€BZL€11€21€10€2330€0€2330€0€1000€400€530€400€0€-0.222€0.0748€1130€0.04€53€800€8€400€0.02€7
N€N0003€200106€C€11€21€36206€7798662€31303€7747379€16900€3563357€2481386€1113981€603003€2552€0.05000€0.0228€4246991€0.0389€19€2228824€15€1288464€0.0463€33
N€N0003€200106€CBM€11€21€983€194272€2240€191632€0€63286€89872€27044€11430€0€4.15000€0.1101€81401€0.0814€22€85841€16€24390€0.132€30
N€N0003€200106€CCC€11€21€209€43832€300€43532€0€9359€19019€8257€6297€600€0.50000€0.0488€20746€0.0443€44€20283€29€2503€0.0202€39
N€N0003€200106€CCPPRA€11€21€60€13025€0€13025€0€2350€7424€2707€544€0€-4.333€0.3285€5751€0.0625€18€6774€26€500€0.058€17
N€N0003€200106€CCR€11€21€3630€728090€6800€719678€1000€267653€271128€122720€59077€100€2.45000€0.0301€346880€0.0381€22€277870€18€95928€0.0488€30
N€N0003€200106€CEA€11€21€10€2229€0€2229€0€300€1601€328€0€0€-1.857€0.1549€928€0.031€17€1201€16€100€0.01€16
N€N0003€200106€CED€11€21€138€25925€300€25625€0€5812€12625€5838€1350€0€0.80000€0.108€13523€0.0484€25€10252€19€1850€0.043€36
N€N0003€200106€CEM€11€21€155€30385€0€30385€0€6560€16100€6125€1600€0€-0.500€0.0917€15567€0.0682€23€13468€23€1350€0.0337€30
N€N0003€200106€CEN€11€21€498€110436€0€110236€200€45363€46318€11486€6969€300€-0.400€0.0306€50010€0.0344€21€55025€14€5401€0.0262€38
N€N0003€200106€CF€11€21€3637€639764€3248€634316€1500€182374€248718€123189€77927€3608€0.40000€0.0254€286515€0.033€30€282454€22€66847€0.0282€49
N€N0003€200106€CFE€11€21€7€1684€0€1684€0€1300€100€284€0€0€-2.714€0.1669€984€0.25€18€700€8€€€
N€N0003€200106€CFN€11€21€16€4234€0€4234€0€1018€1116€1300€800€0€-0.400€0.0828€1200€0.3967€71€3034€26€€€
N€N0003€200106€CGPPRG€12€21€54€5400€4900€500€0€0€100€200€200€0€-14.50€0.184€200€0.75€80€300€33€€€
N€N0003€200106€CGPPRI€11€21€4€750€0€750€0€0€200€0€400€150€ -18.71€0.026€550€0.7182€511€200€23€€€
N€N0003€200106€CGPPRT€11€21€38€9711€0€9711€0€3766€4598€1147€200€0€      -3€0.0734€2517€0.0372€15€7042€15€152€0.01€24
N€N0003€200106€CHD€11€21€606€132464€1359€131105€0€52672€55896€14149€7853€535€-0.579€0.0634€55486€0.0467€19€68291€17€7328€0.0501€27
N€N0003€200106€CHH€11€21€242€54062€0€53762€0€17816€21767€9596€4583€0€       0€0.0552€26188€0.0734€31€23562€16€4012€0.0527€16
N€N0002€200106€CHTRT€11€21€12€3174€0€3174€0€160€0€320€2375€319€1.43750€0.0609€1735€0.0113€116€1439€198€€€
N€N0002€200106€CHTRTWI€12€24€1€5000€0€5000€0€0€0€5000€0€0€-1.200€0.04€€€€5000€31€€€
N€N0003€200106€CIC€11€21€184€49613€0€49613€0€12025€25301€7518€4769€0€-0.950€0.0656€15733€0.0419€22€33280€25€600€0.0533€62
N€N0003€200106€CIP€11€21€84€22418€0€22418€0€4677€16266€1050€425€0€-1.211€0.0745€11685€0.0212€16€10033€16€700€0.0229€12
N€N0003€200106€CIR€11€21€339€57557€600€56957€0€24724€23479€6114€2640€0€3.75000€0.0568€31783€0.0736€16€21547€14€3627€0.1043€30
N€N0003€200106€CKC€11€21€157€29607€0€29607€0€9386€15183€3387€1651€0€-3.526€0.0255€7241€0.0637€30€21486€17€880€0.0327€46
N€N0003€200106€CKH€11€21€487€88089€0€88089€0€41269€36261€7618€2941€0€0.30000€0.0825€32140€0.0668€15€48565€12€7384€0.0821€18
N€N0003€200106€CLB€11€21€640€122678€600€122078€0€25245€56302€22564€17297€670€2.85000€0.0714€57167€0.0743€39€58510€25€6401€0.0322€58
N€N0003€200106€CLJ€11€21€236€38026€0€38026€0€5116€17590€8934€6386€0€-1.474€0.0909€17649€0.0682€43€19877€32€500€0.042€67
N€N0003€200106€CLL€11€21€46€8406€300€8106€0€1238€4650€1785€433€0€-2.667€0.2263€3948€0.1524€16€3958€24€200€0.29€58
N€N0003€200106€CMO€11€21€543€106712€0€106312€400€43418€52504€8949€1841€0€2.90000€0.0488€53463€0.043€16€49371€12€3878€0.0384€11
N€N0003€200106€CMOPRA€11€21€15€3043€0€3043€0€1294€850€599€300€0€3.72727€0.3056€1249€0.5695€35€1794€16€€€
N€N0003€200106€CMOPRB€11€21€38€10036€0€10036€0€3886€4894€915€341€0€2.45000€0.13€3128€0.0804€19€6528€19€380€0.01€14
N€N0003€200106€CMP€11€21€326€73395€0€73395€0€17955€42915€9935€2590€0€-0.895€0.1083€20714€0.0277€19€48680€18€4001€0.0559€33
N€N0003€200106€CMS€11€21€2234€430340€888€427110€2000€222679€168912€27920€9599€0€1.80000€0.0312€192319€0.0264€13€205993€11€30798€0.0334€18
N€N0003€200106€CMSPRJ€11€21€22€6005€0€6005€0€975€4230€800€0€0€2.92308€0.2442€3930€0.0288€18€1775€17€300€0.1€17
N€N0003€200106€CMSPRK€11€21€33€9399€0€9399€0€800€7649€950€0€0€1.14286€0.2479€2575€0.0399€17€6124€18€700€0.1843€12
N€N0003€200106€CMSPRL€11€21€35€9413€0€9413€0€2016€4977€2005€415€0€3.75000€0.1851€4199€0.0565€24€4814€22€400€0.1€37
N€N0003€200106€CMSPRM€11€21€7€1698€0€1698€0€0€1398€0€300€0€-0.333€0.3419€1398€0.0949€20€€€300€0.25€156
N€N0003€200106€CMSPRN€11€21€17€4241€0€4241€0€523€2258€1260€200€0€0.60000€0.0779€3641€0.0212€28€600€9€€€
N€N0003€200106€CNA€11€21€681€155244€0€154844€400€57125€83968€12351€1800€0€0.35000€0.0546€66722€0.0293€14€80492€10€8030€0.033€17
N€N0003€200106€CNL€11€21€567€129633€100€129233€300€70295€48666€7529€3043€0€-1.700€0.0612€53723€0.0363€14€69264€10€6546€0.0487€18
N€N0003€200106€CNN€11€21€21€4852€0€4852€0€2531€1646€200€475€0€0.05882€0.038€3087€0.0285€13€1765€48€€€
N€N0003€200106€COE€11€21€21€5098€0€5098€0€1085€1178€1635€1200€0€0.50000€0.0358€1785€0.0243€33€3313€59€€€
N€N0003€200106€COG€11€21€625€131188€1478€129510€200€31708€55095€27764€14801€342€0.55000€0.0433€60097€0.0666€32€60933€24€8680€0.0682€51
N€N0003€200106€CPD€11€21€41€9634€0€9634€0€4435€3309€1640€250€0€1.41667€0.0417€7584€0.0444€18€2050€11€€€
N€N0003€200106€CPP€11€21€13€3230€0€3230€0€900€1350€980€0€0€11.0909€0.1737€900€0.0567€28€2330€18€€€
N€N0003€200106€CPRE€11€21€90€23321€0€23321€0€2550€15745€3669€1357€0€-0.550€0.0674€13212€0.0199€26€9709€18€400€0.1€41
N€N0003€200106€CPRF€11€21€6€1100€0€1100€0€0€900€0€200€0€-4.750€0.3159€250€0.48€23€850€28€€€
N€N0003€200106€CPRG€11€21€7€1326€0€1326€0€0€764€562€0€0€5.90909€0.4987€664€0.1324€29€662€30€€€
N€N0003€200106€CPRH€11€21€6€1320€0€1320€0€0€600€720€0€0€15.1667€0.422€920€0.1978€23€400€59€€€
N€N0003€200106€CPRK€11€21€42€11084€0€11084€0€500€7692€2092€600€200€2.82353€0.2243€5553€0.0862€41€5131€29€400€0.165€32
N€N0003€200106€CPRM€11€21€10€2226€0€2226€0€339€960€727€200€0€13.4444€0.5577€1580€0.2241€29€446€18€200€0.25€38
N€N0003€200106€CPRN€11€21€43€11091€0€11091€0€2000€7226€1205€660€0€0.88235€0.0632€5145€0.0127€21€5946€26€€€
N€N0003€200106€CPRQ€11€21€4€1200€0€1200€0€0€500€700€0€0€20.6667€0.5625€400€0.05€31€600€21€200€0.1€22
N€N0003€200106€CPRR€11€21€2€500€0€500€0€0€300€0€200€0€25.6000€0.602€300€0.03€26€200€72€€€
N€N0003€200106€CPRU€11€21€12€3145€0€3145€0€200€1745€800€400€0€15.5000€0.5192€1470€0.0813€20€1675€47€€€
N€N0003€200106€CPRW€11€21€203€54632€0€54632€0€10698€29850€9542€4142€400€0.33333€0.0715€24025€0.0144€27€30207€31€400€0.04€21
N€N0003€200106€CPRX€11€21€152€45053€400€44653€0€9460€26551€5112€3530€0€0.20000€0.0603€19055€0.0159€31€25098€22€500€0.044€106
N€N0003€200106€CQPRA€11€21€80€19210€0€19210€0€5594€9166€3275€1175€0€-2.313€0.1641€10230€0.0347€18€8480€27€500€0.08€40
N€N0003€200106€CRM€11€21€6€1000€0€1000€0€0€300€0€700€0€-6.429€-0.057€500€0.81€65€500€66€€€
N€N0003€200106€CRY€11€21€1181€234595€3650€230145€500€98877€107261€19489€5018€0€5.40000€0.1235€91095€0.097€16€107036€12€32514€0.1306€20
N€N0003€200106€CSL€11€21€702€142404€860€141544€0€43960€64987€21866€10199€532€-0.200€0.0624€60868€0.0381€24€68088€17€12588€0.0475€27
N€N0003€200106€CSP€11€21€46€11788€0€11188€600€4305€5430€1114€939€0€0.40000€0.0379€3505€0.0229€13€8183€24€100€0.02€14
N€N0003€200106€CVC€11€21€1573€300546€2400€297846€0€124254€143338€23288€6966€0€3.85000€0.0522€119404€0.0584€16€145555€12€32887€0.052€19
N€N0003€200106€CVD€11€21€957€215338€1250€212285€1000€63619€102151€34471€13044€0€0.40000€0.0433€91877€0.0469€22€107181€19€14227€0.0438€27
N€N0003€200106€CW€11€21€64€11629€0€11629€0€1568€7271€1704€1086€0€-1.357€0.1445€5531€0.0981€29€5598€18€500€0.082€24
N€N0003€200106€CWN€11€21€268€59776€200€59176€400€10708€28045€14206€6517€100€0.10000€0.0268€23025€0.035€36€35286€30€1265€0.0361€38
N€N0003€200106€CWNPRA€11€21€23€5460€0€5460€0€1280€2775€1105€300€0€4.92857€0.1623€2850€0.0813€21€2610€29€€€
N€N0003€200106€CYE€11€21€163€44347€0€44047€300€11950€16310€9270€6567€250€-1.150€0.029€15808€0.0208€39€28139€28€400€0.03€68
N€N0003€200106€D€11€21€6378€1219758€2220€1216438€1100€899099€288283€25052€5104€0€1.50000€0.0547€587917€0.0449€8€463592€7€166029€0.0507€10
N€N0003€200106€DCP€11€21€120€23882€0€23882€0€6845€13962€2650€425€0€-1.647€0.4252€14729€0.1923€19€9153€17€€€
N€N0003€200106€DCS€11€21€26€4646€100€4546€0€826€1934€886€900€0€-0.056€0.0374€646€0.0154€28€3900€39€€€
N€N0003€200106€DDF€11€21€130€34631€104€34527€0€7804€18014€5335€3374€0€-1.750€0.0619€12217€0.0453€22€21810€22€500€0.01€12
N€N0003€200106€DFG€11€21€322€57038€0€57038€0€27051€22775€5339€1873€0€-0.833€0.0532€24654€0.036€18€28384€11€4000€0.0359€16
N€N0003€200106€DGX€11€21€5186€1005363€24875€978733€1100€406700€402320€118543€51365€905€7.85000€0.1035€454631€0.1058€20€354981€15€170221€0.1344€24
N€N0003€200106€DHY€11€21€69€15511€0€15511€0€3644€6401€3456€1868€142€      -1€0.0212€5804€0.0202€39€9407€33€300€0.01€39
N€N0003€200106€DJM€11€21€2€830€0€830€0€400€430€0€0€0€0.41667€0.1004€430€0.01€22€400€4€€€
N€N0003€200106€DLX€11€21€1601€281299€2671€278216€300€71701€103284€50590€50913€2028€1.70000€0.0344€101971€0.0331€40€151551€33€24994€0.05€48
N€N0003€200106€DNB€11€21€925€207241€100€207141€0€97114€83577€20796€5654€0€0.45000€0.0423€106479€0.0315€16€90982€12€9680€0.0268€21
N€N0003€200106€DNR€11€21€384€73429€101€72428€900€27435€35656€7906€2331€0€0.60000€0.0339€30182€0.0324€16€39174€15€3972€0.0371€19
N€N0003€200106€DNY€11€21€1965€380145€100€379832€0€216298€132793€19890€10851€0€-0.200€0.0381€156676€0.0298€13€193479€12€29677€0.0313€15
N€N0003€200106€DPRA€11€21€125€35911€0€35911€0€16642€14590€3109€1570€0€-1.833€0.1137€13725€0.0222€17€20986€15€1200€0.0733€17
N€N0003€200106€DSU€11€21€261€76624€280€76344€0€28055€28115€11749€8425€0€-0.450€0.0231€27021€0.0138€28€48009€27€1314€0.0163€34
N€N0003€200106€DT€11€21€2026€446775€1300€444775€700€253675€148003€35543€8254€0€0.10000€0.0166€202363€0.0184€12€202306€10€40806€0.0204€23
N€N0003€200106€DV€11€21€677€149804€900€148704€200€53027€64825€19880€10136€1036€2.63158€0.0764€65449€0.0428€22€72670€17€10785€0.0449€21
N€N0003€200106€EAS€11€21€709€158503€600€157500€0€70724€51100€22068€13608€0€0.30000€0.0322€57187€0.035€26€94069€17€6244€0.0266€40
N€N0003€200106€ED€11€21€4263€765164€1625€760880€1700€269390€288368€128899€73604€4061€0.40000€0.0326€315254€0.0402€32€364869€20€82457€0.0417€45
N€N0003€200106€EDE€11€21€259€54956€0€54856€100€22840€24852€6013€1251€100€-2.421€0.0399€26989€0.0521€15€25555€16€2412€0.0353€19
N€N0003€200106€EDEPRD€11€21€20€4917€0€4917€0€900€2790€1127€100€0€3.91667€0.0871€4417€0.1058€19€300€26€200€0.06€31
N€N0003€200106€EDL€11€21€93€24045€0€24045€0€4069€14154€4450€1372€0€-0.850€0.0953€4642€0.0249€30€17298€22€2105€0.0329€18
N€N0003€200106€EDO€11€21€700€150405€2000€148405€0€48400€64713€22279€12513€500€0.55000€0.0571€72066€0.0717€23€66460€15€9879€0.0961€31
N€N0003€200106€EDPRA€11€21€19€3320€0€3320€0€500€1950€400€470€0€-12.22€0.8095€1820€0.7951€31€1200€27€300€0.4167€28
N€N0003€200106€EFL€11€21€24€4491€0€4491€0€1783€2333€275€100€0€-0.400€0.1064€3238€0.0392€14€1253€18€€€
N€N0003€200106€ELN€11€21€8381€1698154€28233€1658521€9800€591927€749792€247952€77850€800€3.55000€0.0376€896938€0.0543€20€574910€16€196473€0.0643€24
N€N0003€200106€ELNWSA€11€21€81€15924€0€15924€0€2530€8535€2849€2010€0€3.11111€0.618€9810€0.2236€33€5214€14€900€0.1233€61
N€N0003€200106€ELNWSB€11€21€16€3710€0€3710€0€950€1510€800€450€0€6.21429€1.0969€2100€0.5145€54€1410€12€200€0.79€20
N€N0003€200106€EMC€11€21€47650€9897171€68202€9782039€39300€3244345€4085888€1836849€651461€1701€-0.050€0.0249€5060991€0.0472€22€2257708€15€2502640€0.0544€30
N€N0003€200106€EMD€11€21€14€3634€0€3634€0€200€2219€700€515€0€2.05556€0.0971€1119€0.0607€21€2515€31€€€
N€N0003€200106€EPG€11€21€18292€3812438€35121€3757321€15900€1178720€1457845€694790€424248€17468€1.65000€0.0318€2175190€0.0565€26€985314€20€612717€0.0627€36
N€N0003€200106€EPGPR€11€21€4€589€0€589€0€0€0€100€489€0€27.6667€1.1746€489€0.234€91€100€142€€€
N€N0003€200106€EPGPRC€11€21€9€1800€0€1800€0€0€200€800€400€400€-42.33€1.6667€500€0.298€99€900€253€400€1.05€42
N€N0003€200106€EPI€11€21€126€33956€200€33756€0€10726€15906€5444€1680€0€-0.316€0.0843€13803€0.0236€22€19153€19€800€0.0238€21
N€N0003€200106€EPL€11€21€326€76532€0€76232€300€31698€32628€8058€4148€0€4.30000€0.039€33547€0.0448€20€41085€15€1900€0.0384€30
N€N0003€200106€EPN€11€21€918€207403€200€207003€200€67977€98548€24636€15492€550€-0.800€0.0573€111443€0.0584€22€85320€22€10440€0.0449€39
N€N0003€200106€ESI€11€21€1347€263316€10079€252937€200€72537€103484€43898€32168€1050€1.75000€0.0683€113865€0.0789€32€107821€21€31451€0.1062€56
N€N0003€200106€ETA€11€21€30€6305€0€6305€0€800€3730€1385€390€0€-0.450€0.0437€3350€0.023€24€2855€29€100€0.04€38
N€N0003€200106€EX€11€21€189€36259€200€36059€0€11720€18552€4551€1236€0€0.95000€0.0391€16262€0.0377€21€18701€14€1096€0.0338€35
N€N0003€200106€FC€11€21€39€7273€0€7273€0€2340€3733€1100€100€0€1.47059€0.0469€4128€0.0602€21€3045€11€100€0.02€14
N€N0003€200106€FCX€11€21€2268€477507€0€477007€500€224775€186859€45247€20626€0€-0.450€0.0182€200039€0.0292€19€251445€13€26023€0.0258€17
N€N0003€200106€FCXA€11€21€203€43156€440€42716€0€15376€22763€3384€1049€144€0.78947€0.0382€23814€0.0421€19€17487€13€1415€0.0248€40
N€N0003€200106€FCXPRA€11€21€76€18015€0€18015€0€5645€7438€3682€1250€0€1.05263€0.0635€11571€0.0507€23€6444€22€€€
N€N0003€200106€FCXPRB€11€21€66€14738€0€14738€0€3662€8961€1765€350€0€-0.929€0.1379€5695€0.0608€21€9043€19€€€
N€N0003€200106€FCXPRC€11€21€18€4202€0€4202€0€0€2202€1700€300€0€2.73333€0.1058€1100€0.0409€35€3102€25€€€
N€N0003€200106€FCXPRD€11€21€32€7878€0€7878€0€754€6474€650€0€0€-0.529€0.0839€4508€0.0431€17€3370€19€€€
N€N0003€200106€FE€11€21€4339€852395€1200€849495€600€440011€305729€80238€22433€1684€0.70000€0.0259€297521€0.0334€15€484823€12€67751€0.0391€18
N€N0003€200106€FLR€11€21€2918€566592€10100€554892€1000€189895€244194€85222€36481€100€       4€0.062€286010€0.0751€20€184057€16€85825€0.1055€33
N€N0003€200106€FMC€11€21€1529€300685€6100€294585€0€119860€125954€33675€15096€0€5.50000€0.06€158560€0.0587€18€100317€17€35708€0.0695€31
N€N0003€200106€FO€11€21€2620€497417€300€496617€200€263838€184257€39171€9551€0€0.85000€0.0459€217394€0.0347€13€239890€11€39533€0.0497€21
N€N0003€200106€FOE€11€21€591€125134€506€124228€0€44257€57903€16669€5399€0€0.85000€0.0377€56458€0.0374€20€61161€16€6609€0.0451€19
N€N0003€200106€FOPRA€13€21€1€300€300€0€0€0€0€0€0€0€0€€€€€€€€€
N€N0003€200106€FOR€11€21€60€12184€0€12184€0€8401€3433€350€0€0€0.31579€0.0292€7012€0.0142€10€5172€7€€€
N€N0003€200106€FPCPRA€11€21€74€22202€0€22202€0€9105€6257€2976€3864€0€       2€0.1081€10106€0.0562€28€12096€34€€€
N€N0003€200106€FRC€11€21€251€47308€200€47108€0€11567€14565€9783€10893€300€1.84211€0.0645€16764€0.0702€53€24944€38€5400€0.1115€77
N€N0003€200106€FSH€11€21€917€195393€1100€194093€200€78546€81804€23834€10409€0€2.55000€0.0717€92235€0.068€22€89125€14€12933€0.0638€25
N€N0003€200106€FTI€11€21€1980€362127€100€361927€100€145638€148580€54179€13530€100€4.85000€0.0225€195780€0.0546€19€152912€17€13335€0.0439€26
N€N0003€200106€FWJ€11€21€3€900€0€900€0€0€900€0€0€0€-0.143€0.1167€300€0.1€18€600€20€€€
N€N0003€200106€GBE€11€21€23€4475€0€4475€0€1148€1629€814€884€0€-0.118€0.0771€2092€0.049€30€2083€24€300€0.05€49
N€N0003€200106€GCG€11€21€4€900€0€900€0€400€0€100€400€0€0.70588€-0.0011€700€0.0443€57€200€0€€€
N€N0003€200106€GDP€11€21€20€4550€0€4550€0€1660€2414€476€0€0€1.42105€0.0799€1889€0.0255€18€2261€11€400€0.015€11
N€N0003€200106€GGT€11€21€114€24322€0€24322€0€9040€11256€3414€612€0€-0.105€0.0914€9010€0.0369€16€14434€18€878€0.0613€14
N€N0003€200106€GGTPR€11€21€9€2302€0€2302€0€400€1602€300€0€0€4.58333€0.2422€200€0.02€8€2102€16€€€
N€N0003€200106€GID€11€21€3€600€0€600€0€100€300€200€0€0€       0€0.0133€600€0.05€28€€€€€
N€N0003€200106€GK€11€21€110€17156€0€17156€0€1750€7742€4376€3062€226€0.10526€0.0597€9137€0.0484€35€6619€55€1400€0.0421€52
N€N0003€200106€GLC€11€21€1397€310305€2700€306105€1100€88027€135891€55266€26942€1079€0.15000€0.0268€152886€0.0322€25€129221€21€25098€0.0498€30
N€N0003€200106€GLG€11€21€210€51489€0€51089€400€30501€17462€3225€301€0€0.05000€0.0265€13063€0.0168€11€37509€11€917€0.0151€7
N€N0003€200106€GLH€11€21€201€45051€0€45051€0€15566€21649€5843€1993€0€-1.350€0.143€14705€0.0661€23€28551€15€1795€0.0261€21
N€N0003€200106€GLW€11€21€31632€6854173€13360€6798713€38700€3855589€2284747€586994€109468€615€0.05000€0.0136€3112503€0.0242€12€2413309€9€1311601€0.0273€18
N€N0003€200106€GPB€11€21€94€26231€0€26231€0€4691€15476€4364€1700€0€-1.850€0.0968€14042€0.057€21€11889€26€300€0.0167€53
N€N0003€200106€GPD€11€21€53€13433€0€13433€0€7588€5845€0€0€0€1.40000€0.1593€7865€0.0481€10€5268€10€300€0.1€9
N€N0003€200106€GPEPRA€11€21€62€17189€0€17189€0€7510€8831€848€0€0€2.58824€0.1118€10268€0.0573€13€6921€10€€€
N€N0003€200106€GPEPRT€11€21€57€14799€400€14399€0€6781€6318€1100€200€0€0.50000€0.0711€6620€0.0196€18€7779€8€€€
N€N0003€200106€GPEPRU€11€21€49€12589€0€12589€0€4059€8135€395€0€0€2.46154€0.1653€7537€0.0333€12€5052€11€€€
N€N0003€200106€GPEPRV€11€21€32€7953€0€7953€0€1966€4966€1021€0€0€2.69231€0.1588€4145€0.0421€17€3508€19€300€0.0733€14
N€N0003€200106€GPF€11€21€20€5986€0€5986€0€1030€3571€925€460€0€-2.278€0.1622€1540€0.0802€23€4446€26€€€
N€N0003€200106€GPU€11€21€1834€331935€1599€329136€500€179273€123240€20383€6540€200€1.50000€0.0418€164349€0.0434€12€136469€11€28818€0.0411€15
N€N0003€200106€GRA€11€21€217€50998€0€50998€0€21532€22718€6164€584€0€-0.700€0.0143€18821€0.0151€17€31361€14€816€0.0202€6
N€N0003€200106€GRB€11€21€163€27554€0€27554€0€5052€13374€6620€2508€0€0.40000€0.0295€12715€0.0593€26€13418€28€1421€0.0244€47
N€N0003€200106€GUPPRA€11€21€18€4554€0€4554€0€350€4204€0€0€0€0.66667€0.1284€2809€0.1062€13€1745€14€€€
N€N0003€200106€GUPPRB€11€21€21€5484€0€5484€0€550€4584€350€0€0€-1.222€0.1667€3784€0.0723€15€1700€11€€€
N€N0003€200106€HAR€11€21€769€148497€1800€146597€100€34515€73133€27304€11745€0€3.70000€0.0552€68766€0.0854€26€67117€23€10814€0.1312€22
N€N0003€200106€HAS€11€21€2142€438982€100€437882€1000€174135€192970€53185€18592€0€0.45000€0.0301€246768€0.0269€17€172621€16€19493€0.0313€24
N€N0003€200106€HCN€11€21€804€177141€0€175441€800€59204€72907€26587€16813€730€-1.600€0.034€81716€0.0317€27€85715€20€8810€0.0327€45
N€N0003€200106€HCNPRB€11€21€38€10125€0€10125€0€2217€4841€2284€783€0€0.58333€0.1173€6825€0.0796€25€2900€37€400€0.05€14
N€N0003€200106€HGR€11€21€31€7668€0€7668€0€2203€2650€1915€900€0€0.05000€0.0502€2915€0.0361€44€4653€19€100€0.02€8
N€N0003€200106€HIL€11€21€58€12938€0€12938€0€3997€7419€1222€300€0€-0.050€0.0221€7891€0.0332€15€4547€15€500€0.026€18
N€N0003€200106€HIW€11€21€853€201813€138€201675€0€124564€67892€7219€1700€300€0.85000€0.0302€92008€0.0319€10€101169€9€8498€0.0282€18
N€N0003€200106€HIWPRB€11€21€48€13382€0€13382€0€3770€8212€1000€400€0€-1.500€0.1308€9665€0.0841€16€3717€18€€€
N€N0003€200106€HIWPRD€11€21€51€13883€0€13883€0€3676€7969€2238€0€0€-2.538€0.1521€8843€0.0724€17€4640€16€400€0.055€9
N€N0003€200106€HMA€11€21€1305€285451€0€284551€900€120298€111741€35184€17878€350€0.80000€0.0185€153353€0.0329€22€115598€15€16500€0.0365€33
N€N0003€200106€HMC€11€21€327€61763€0€61763€0€23757€28584€7033€2389€0€5.89474€0.1751€29459€0.1755€21€28592€13€3712€0.0987€30
N€N0003€200106€HMT€11€21€1019€248392€300€245792€2300€101541€107186€25592€12063€1710€0.20000€0.0155€123922€0.0207€20€115408€14€8762€0.018€59
N€N0003€200106€HMTPRA€11€21€40€10915€0€10915€0€2225€7190€1100€400€0€-0.625€0.1225€4130€0.0509€12€6285€19€500€0.086€42
N€N0003€200106€HMTPRB€11€21€45€12320€0€12320€0€4705€5465€1700€450€0€-3.824€0.0985€7575€0.0284€16€4545€23€200€0.1€18
N€N0003€200106€HMTPRC€11€21€58€16685€0€16685€0€4440€10635€1280€330€0€-1.778€0.0897€7385€0.018€21€8900€13€400€0.05€7
N€N0003€200106€HON€11€21€19634€4537992€36160€4486970€11800€2162439€1652916€496192€184563€2660€ -0.300€0.0359€2222825€0.0602€16€1376974€12€898971€0.0831€26
N€N0003€200106€HOV€11€21€497€107289€200€106689€300€46229€49915€7595€3250€0€1.50000€0.0621€47328€0.0482€16€52446€13€7215€0.0522€15
N€N0003€200106€HZO€11€21€20€4175€0€4175€0€1240€2184€200€551€0€1.10526€0.039€1809€0.0585€30€2366€22€€€
N€N0003€200106€ICS€11€21€7€1506€0€1506€0€0€1506€0€0€0€0.93333€0.0675€770€0.0113€10€736€16€€€
N€N0003€200106€IDG€11€21€11€2461€0€2461€0€319€1494€648€0€0€1.80000€0.1105€1813€0.0317€11€€€648€0.1€38
N€N0003€200106€IEU€11€21€16€4255€0€4255€0€255€3200€400€400€0€-1.273€0.2366€1555€0.0971€15€2700€36€€€
N€N0003€200106€IFX€11€21€738€155517€1600€152017€400€57220€65935€19363€9549€350€2.70000€0.1008€54177€0.0564€21€66889€15€31351€0.0759€27
N€N0003€200106€IGL€11€21€884€187910€400€187210€300€46812€77036€38157€24596€909€0.50000€0.0177€77292€0.0227€36€101416€23€8802€0.0292€38
N€N0003€200106€IML€11€21€24€6306€0€6306€0€857€3090€1110€945€304€0.78947€0.1118€4214€0.0282€50€1335€44€757€0.0617€87
N€N0003€200106€IQM€11€21€27€9088€0€9088€0€3112€3224€1533€1219€0€-0.600€0.0412€2795€0.0247€19€6163€27€130€0.02€15
N€N0003€200106€IR€11€21€3775€759241€2050€754499€2100€278603€313443€122486€41102€1380€1.30000€0.0277€384981€0.0303€20€301091€17€70527€0.0412€26
N€N0003€200106€ISP€11€21€117€20875€0€20875€0€5474€11352€2541€1508€0€2.25000€0.0493€11155€0.0345€20€8420€19€1300€0.0331€33
N€N0003€200106€ITG€11€21€1108€235115€3900€231115€100€71405€116744€30416€12650€0€3.75000€0.0835€110607€0.0695€22€102156€15€18452€0.1072€32
N€N0003€200106€ITN€11€21€371€78922€429€78493€0€38979€31129€6358€2027€0€1.55000€0.0448€27960€0.0329€13€45177€12€5356€0.037€20
N€N0003€200106€ITT€11€21€1622€286838€300€285930€500€109564€148979€23443€4444€0€1.90000€0.0516€134635€0.0453€15€131715€12€20080€0.0523€18
N€N0003€200106€ITX€11€21€71€16878€200€16678€0€3675€9192€2450€1361€0€       0€0.0615€5862€0.039€25€7799€16€3017€0.0462€32
N€N0003€200106€ITXPR€11€21€8€1738€0€1738€0€199€729€450€360€0€-11.09€0.3264€888€0.2684€41€700€45€150€0.5€10
N€N0003€200106€IVC€11€21€574€109326€0€109042€0€56256€39484€9774€3528€0€-0.105€0.0595€52292€0.0707€14€49763€14€6987€0.0589€23
N€N0003€200106€JBL€11€21€10652€2021224€38650€1976374€5600€828342€716374€280748€152377€4133€2.15000€0.0406€978092€0.0497€20€664172€15€339710€0.0735€35
N€N0003€200106€JCP€11€21€4785€923275€3200€917192€2600€476919€354391€69553€17871€1058€0.90000€0.027€417906€0.0348€15€412601€11€89285€0.0462€17
N€N0003€200106€JEM€11€21€14€3691€0€3691€0€2595€846€250€0€0€2.66667€0.0709€650€0.0162€17€3041€8€€€
N€N0003€200106€JOE€11€21€560€109132€100€108932€100€37049€49203€13005€9415€360€       1€0.0545€30081€0.028€28€72812€20€6139€0.0361€55
N€N0003€200106€JYPPRZ€11€21€33€8294€0€8294€0€3987€2853€1454€0€0€-0.688€0.0813€2801€0.0214€12€5093€17€400€0.055€13
N€N0003€200106€KBH€11€21€2003€396444€1900€393544€700€235578€135787€19031€3612€236€1.55000€0.052€158530€0.0436€12€201018€9€34696€0.062€18
N€N0003€200106€KBHPRG€12€23€1€4000€3800€200€0€0€200€0€0€0€     -16€0.25€€€€200€18€€€
N€N0003€200106€KBHPRI€11€21€10€1870€0€1870€0€670€1200€0€0€0€-0.050€0.1165€600€0.0233€10€1270€11€€€
N€N0003€200106€KEG€11€21€1018€219955€1787€218168€0€79979€96492€29441€11905€351€0.10000€0.0309€96876€0.0251€21€100725€18€20567€0.0376€30
N€N0003€200106€KEI€11€21€1527€304821€3399€301422€0€107761€129096€42537€22028€0€2.15000€0.0795€140598€0.0738€21€117736€18€43088€0.0839€31
N€N0003€200106€KG€11€21€5215€1031366€8400€1021866€1100€454412€432306€107139€28667€442€2.15000€0.0377€522352€0.0555€16€392279€13€108335€0.069€18
N€N0003€200106€KLU€11€21€160€33466€0€33466€0€12755€16840€3321€550€0€0.25000€0.052€13916€0.0403€14€18540€14€1010€0.01€16
N€N0003€200106€KMB€11€21€10045€2164410€4955€2150133€7000€686439€883329€387441€193491€6433€       1€0.0322€1162179€0.0422€24€704899€21€290055€0.0583€29
N€N0003€200106€KOR€11€21€26€5566€0€5566€0€1145€2746€600€1075€0€-1.105€0.0425€3656€0.0338€26€1910€33€€€
N€N0003€200106€KPA€11€21€290€63086€0€62586€500€27584€24830€7518€3154€0€0.25000€0.0301€18392€0.0203€18€41710€16€2984€0.0191€24
N€N0003€200106€KPAPRA€11€21€38€8841€0€8841€0€2025€3910€800€2106€0€      -1€0.2095€2760€0.056€50€5456€28€625€0.1156€16
N€N0003€200106€KRJ€11€21€4€1150€0€1150€0€300€850€0€0€0€0.75000€0.113€600€0.0833€18€550€14€€€
N€N0003€200106€KTB€11€21€24€6825€0€6825€0€1200€3975€850€800€0€0.87500€0.1024€4475€0.0597€29€2350€20€€€
N€N0003€200106€KTP€11€21€113€29875€0€29875€0€11654€14076€3720€425€0€-0.333€0.1111€13092€0.0381€17€15603€15€1180€0.0632€17
N€N0003€200106€KYO€11€21€488€90772€0€90472€300€44067€39611€5763€1331€0€5.11765€0.3294€39291€0.1462€13€44089€12€7392€0.1991€15
N€N0003€200106€LBI€11€21€9€1540€0€1540€0€200€1090€250€0€0€-1.053€0.0645€713€0.121€22€827€15€€€
N€N0003€200106€LDP€11€21€71€16330€0€16330€0€4713€7895€1543€2179€0€0.35000€0.0814€6311€0.0355€21€9254€26€765€0.0413€41
N€N0003€200106€LMM€11€21€5€1340€0€1340€0€400€450€490€0€0€0.41176€0.0192€210€0.0257€18€1130€27€€€
N€N0003€200106€LMS€11€21€40€8949€0€8949€0€1605€5269€1025€1050€0€ -1.211€0.0789€5069€0.0544€32€3770€16€110€0.02€12
N€N0003€200106€LMT€11€21€7427€1539221€2321€1534598€1500€813099€498258€155630€68871€240€1.25000€0.038€652816€0.0387€18€731392€12€151890€0.0449€19
N€N0003€200106€LNT€11€21€1104€241025€0€240325€700€74986€120488€33823€11428€300€0.15000€0.0345€72301€0.0345€18€155939€17€12785€0.0238€23
N€N0003€200106€LRY€11€21€728€157798€0€156898€900€63418€75594€14717€4069€0€-0.550€0.0361€80555€0.0294€15€73460€14€3783€0.0312€21
N€N0003€200106€LRYPRA€11€21€45€11239€0€11239€0€5040€5074€675€450€0€-0.563€0.1347€2244€0.0408€19€8795€14€200€0.05€24
N€N0003€200106€LSHPRA€11€21€38€8884€0€8884€0€1777€4625€1100€1382€0€1.75000€0.1001€4602€0.0332€34€4282€29€€€
N€N0003€200106€MAG€11€21€205€40664€100€40564€0€11519€19271€7942€1832€0€0.15000€0.034€18625€0.0561€21€21026€17€913€0.0264€46
N€N0003€200106€MAR€11€21€4566€852217€3439€847777€500€327186€338792€115285€64394€2620€0.85000€0.0336€371175€0.0377€23€376069€17€101033€0.0395€25
N€N0003€200106€MAT€11€21€6271€1269034€600€1265555€2400€804303€370087€74517€19048€0€0.45000€0.0286€536799€0.0232€12€603833€9€127323€0.0268€17
N€N0003€200106€MCC€11€21€92€15602€100€15502€0€3391€5930€2640€3441€100€1.93750€0.1551€10231€0.1351€48€3496€48€1775€0.1344€50
N€N0003€200106€MCO€11€21€2564€482050€300€481050€0€205260€224512€38524€12754€0€2.50000€0.0344€232157€0.0449€16€218413€12€30480€0.0506€21
N€N0003€200106€MCT€11€21€93€18905€300€18605€0€6170€8860€2500€1175€0€-5.938€0.2168€10070€0.0931€22€7035€21€1500€0.0993€18
N€N0003€200106€MDG€11€21€222€44774€100€44574€100€18941€16881€6899€1953€0€0.15000€0.0379€17024€0.0225€15€23758€15€3892€0.029€43
N€N0003€200106€MEE€11€21€1036€209709€1746€206463€1500€66383€99319€28763€13498€0€1.45000€0.0405€111328€0.0591€22€81354€18€15281€0.0622€27
N€N0003€200106€MEH€11€21€251€48319€0€48319€0€14334€23793€6423€3769€0€1.21053€0.0701€17902€0.0429€26€24568€19€5849€0.046€31
N€N0003€200106€MER€11€21€30073€6760165€79577€6655420€22100€3730194€2256343€498914€187021€5048€1.50000€0.0551€3050308€0.0476€13€1925818€9€1701394€0.066€19
N€N0003€200106€MERPRA€11€21€78€19057€0€19057€0€7062€8478€2817€700€0€1.25000€0.101€10546€0.0317€22€8411€15€100€0.02€24
N€N0003€200106€MERPRB€11€21€79€20512€0€20512€0€6773€11414€1925€400€0€-0.353€0.0985€12232€0.0367€16€7980€17€300€0.01€11
N€N0003€200106€MERPRC€11€21€75€18441€0€18441€0€4795€11057€1582€1007€0€-0.294€0.1103€11160€0.0386€24€7181€16€100€0.07€17
N€N0003€200106€MERPRD€11€21€180€50455€0€50455€0€18698€26565€3992€1200€0€-0.167€0.0677€28689€0.0208€17€21266€15€500€0.026€20
N€N0003€200106€MERPRE€11€21€91€24866€0€24866€0€7807€13364€1525€2170€0€0.25000€0.0673€17369€0.0194€23€7497€26€€€
N€N0003€200106€MERPRF€11€21€254€64465€0€64465€0€22971€30739€8030€2725€0€-1.167€0.0566€35833€0.0187€19€27832€19€800€0.025€12
N€N0003€200106€MFW€11€21€32€7466€0€7466€0€2841€4113€512€0€0€-0.158€0.0181€2029€0.0623€12€5437€14€€€
N€N0003€200106€MGF€11€21€70€16120€0€16120€0€6543€8899€500€178€0€0.20000€0.0166€3887€0.0103€17€12233€12€€€
N€N0003€200106€MHN€11€21€44€10018€0€10018€0€5361€3632€1025€0€0€-0.100€0.0315€3926€0.014€17€5792€10€300€0.0133€16
N€N0003€200106€MIM€11€21€7€1347€0€1347€0€275€672€200€200€0€-2.615€0.1074€140€0.13€24€1207€26€€€
N€N0003€200106€MLI€11€21€373€69963€100€69763€100€19462€27043€13949€9309€100€2.30000€0.0273€31833€0.0706€30€34350€30€3680€0.0433€50
N€N0003€200106€MLM€11€21€956€204799€300€204099€400€61064€95095€32619€15821€300€0.45000€0.0477€80241€0.0608€24€108917€20€15341€0.0475€23
N€N0003€200106€MLS€11€21€869€206055€0€205855€200€74780€98864€22395€10016€0€-0.300€0.065€79217€0.0297€20€113979€14€12859€0.0332€28
N€N0003€200106€MMA€11€21€164€41547€0€41347€200€6120€18982€11510€4935€0€-1.750€0.0759€18868€0.0622€31€22479€28€200€0.01€42
N€N0003€200106€MMC€11€21€7854€1504024€4800€1496324€2400€848935€524310€93936€31240€303€4.80000€0.0776€737970€0.0635€14€537240€9€223514€0.0759€16
N€N0003€200106€MMR€11€21€143€24452€0€24452€0€4408€14201€3524€2319€0€-3.368€0.0584€10071€0.0532€24€13468€26€913€0.0605€21
N€N0003€200106€MMS€11€21€1627€318955€1900€315905€900€106853€137298€48809€23545€300€8.45000€0.0495€180240€0.06€24€113201€20€23364€0.0565€33
N€N0003€200106€MOT€11€21€15110€3328170€5844€3311576€8100€1598352€1234943€389062€96669€650€0.10000€0.0107€1631510€0.0236€17€1229766€10€458400€0.0247€21
N€N0003€200106€MOTPRA€11€21€193€54690€0€54690€0€19492€24106€8167€2925€0€-0.053€0.0898€30541€0.0284€23€23749€17€400€0.025€16
N€N0003€200106€MPPRD€11€21€9€1975€0€1975€0€300€775€900€0€0€4.14286€0.2923€1600€0.04€28€375€14€€€
N€N0003€200106€MRX€11€21€1621€320344€8637€310782€200€63174€159322€56740€29946€1800€0.85000€0.0942€133022€0.0768€30€134927€24€43033€0.1141€30
N€N0003€200106€MSF€11€21€42€9509€0€9509€0€2112€6131€766€200€300€-1.050€0.0626€3761€0.0423€15€5748€16€€€
N€N0003€200106€MTN€11€21€145€22165€0€21965€200€4845€12736€2407€2177€0€2.55556€0.0896€11127€0.0907€28€10716€22€322€0.1€10
N€N0003€200106€MTTPRX€11€21€23€5969€0€5969€0€850€4879€240€0€0€8.85714€0.1935€3074€0.1643€18€2895€13€€€
N€N0003€200106€MTX€11€21€764€141623€0€140313€0€59229€61833€11244€8007€0€ -0.150€0.062€55775€0.0467€18€74506€17€10032€0.0553€28
N€N0003€200106€MUC€11€21€37€9273€0€9273€0€3762€3999€400€1112€0€-0.650€0.0279€5611€0.0146€17€3262€42€400€0.01€6
N€N0003€200106€MUJ€11€21€36€8266€0€8266€0€3118€4948€200€0€0€0.05263€0.0292€4991€0.0126€15€3275€10€€€
N€N0003€200106€MUO€11€21€47€10408€0€10408€0€2493€6074€1116€725€0€-0.316€0.0519€3863€0.0223€24€6345€13€200€0.06€140
N€N0003€200106€MYI€11€21€107€32319€0€32319€0€11642€14632€3472€2373€200€-0.579€0.0318€11728€0.0141€29€20291€17€300€0.01€18
N€N0003€200106€NAV€11€21€1165€207641€200€206594€300€100039€87977€14008€4870€0€1.70000€0.0271€94076€0.027€14€101550€12€11268€0.0438€17
N€N0003€200106€NC€11€21€422€70933€0€70933€0€24172€40012€5599€1150€0€-3.550€0.1476€27278€0.0952€18€37888€11€5767€0.0974€18
N€N0003€200106€NCI€11€21€165€36300€0€36300€0€12555€13153€5331€4291€970€       1€0.0448€13065€0.0375€23€21642€25€1593€0.0567€119
N€N0003€200106€NDE€11€21€1140€252703€3500€248903€200€62581€105339€52043€27991€1149€1.55000€0.0427€103869€0.041€28€124648€23€20586€0.0692€57
N€N0003€200106€NEU€11€21€2069€434722€5500€427622€500€148279€190275€58105€31463€0€5.90000€0.0733€193603€0.0723€25€172307€15€62212€0.0672€31
N€N0003€200106€NMA€11€21€57€13504€0€13504€0€2868€6470€2799€1367€0€0.27778€0.033€1804€0.0319€18€11350€29€350€0.01€41
N€N0003€200106€NMI€11€21€23€5888€0€5888€0€2227€2881€580€200€0€1.43750€0.0667€4313€0.0145€18€1575€13€€€
N€N0003€200106€NMK€11€21€1636€308307€100€307707€400€114811€128594€41825€22677€200€0.05000€0.0191€97748€0.016€23€190283€18€20076€0.0143€28
N€N0003€200106€NMKPRK€11€21€1€100€0€100€0€100€0€0€0€0€27.5000€0.75€€€€100€9€€€
N€N0003€200106€NMT€11€21€21€5072€0€5072€0€507€4032€133€400€0€1.42857€0.0602€2876€0.023€19€2196€23€€€
N€N0003€200106€NPC€11€21€12€2425€0€2425€0€798€1627€0€0€0€0.53333€0.0694€927€0.0578€14€1498€14€€€
N€N0003€200106€NPV€11€21€36€8346€0€8346€0€2790€3706€1850€0€0€0.58824€0.0865€4223€0.0241€20€3823€17€300€0.01€13
N€N0003€200106€NQF€11€21€33€8197€0€8197€0€3319€3533€1145€0€200€-0.059€0.0506€4778€0.0118€32€3419€10€€€
N€N0003€200106€NQS€11€21€50€13224€0€13224€0€3268€6571€3385€0€0€0.31579€0.0344€3655€0.0223€23€9235€17€334€0.04€32
N€N0003€200106€NSH€11€21€31€6351€0€6351€0€1216€4108€927€100€0€-0.467€0.0711€3151€0.0624€19€3200€18€€€
N€N0003€200106€NSI€11€21€989€206016€700€204916€400€81854€88750€26478€8134€100€1.30000€0.053€78530€0.0423€19€115118€14€11668€0.0455€29
N€N0003€200106€NTC€11€21€29€7856€0€7856€0€2683€4673€500€0€0€1.43750€0.0692€5213€0.0129€16€2643€12€€€
N€N0003€200106€NUT€11€21€24€5170€0€5170€0€713€3916€541€0€0€0.89474€0.0767€3509€0.0365€19€1548€11€113€0.05€9
N€N0003€200106€NVN€11€21€60€17595€0€17595€0€3541€10820€1951€1283€0€-0.400€0.0528€6675€0.015€21€10105€23€815€0.0316€14
N€N0003€200106€OAT€11€21€3034€570965€4200€565465€1300€270878€204505€62275€28792€315€       2€0.0499€293935€0.0578€17€213478€13€59352€0.0588€21
N€N0003€200106€OCN€11€21€196€44482€122€44160€200€11948€15964€8555€7893€0€1.40000€0.0487€16847€0.0378€38€24518€33€2995€0.0362€41
N€N0003€200106€OECPRT€11€21€37€8598€0€8598€0€5028€2770€600€200€0€5.90000€0.3758€5885€0.0151€16€2713€9€€€
N€N0003€200106€OFC€11€21€228€44336€0€44336€0€7456€16953€9168€10759€0€-1.579€0.0313€17630€0.0546€51€22481€36€4225€0.0178€24
N€N0003€200106€OFCPRB€11€21€24€4268€0€4268€0€240€1775€1155€700€398€-1.067€0.0926€2050€0.1197€37€2118€122€100€0.05€65
N€N0003€200106€OFCPRE€11€21€22€4805€0€4805€0€700€1725€1130€1150€100€0.81250€0.1068€2310€0.0747€57€2195€46€300€0.03€11
N€N0003€200106€OH€11€21€149€34617€140€34377€100€9919€17741€4045€2772€0€-0.050€0.0328€14906€0.0318€32€19248€18€323€0.0286€89
N€N0003€200106€OI€11€21€353€74739€0€74739€0€33123€30579€7601€3436€0€0.60000€0.0219€24529€0.0238€16€47287€16€2923€0.0227€21
N€N0003€200106€OIPRA€11€21€62€16193€100€16093€0€2270€6602€2439€4282€500€-1.947€0.1128€7247€0.0299€73€7547€45€1299€0.0585€54
N€N0003€200106€OMG€11€21€965€189051€1000€186551€0€54715€91492€27624€12720€0€1.15789€0.0607€70167€0.0623€23€97105€18€19279€0.0554€29
N€N0003€200106€OMI€11€21€565€107087€500€106087€300€26099€48534€18229€13525€0€1.60000€0.0552€41150€0.0578€29€56474€24€8763€0.0579€42
N€N0003€200106€ONE€11€21€10768€2557497€1921€2549239€4900€1590050€761410€159619€42657€403€0.45000€0.0277€1132248€0.0266€12€1085876€9€336015€0.0315€15
N€N0003€200106€ONEPRB€11€21€3€400€0€400€0€0€200€0€200€0€35.1667€2.3875€200€0.55€91€200€18€€€
N€N0003€200106€ONEPRC€11€21€1€100€0€100€0€0€0€0€100€0€1.5€2€100€1€83€€€€€
N€N0003€200106€ONEPRT€11€21€109€29362€0€29362€0€13993€11061€3728€580€0€-1.333€0.0822€11554€0.0415€15€16908€15€900€0.0289€13
N€N0003€200106€ONEPRU€11€21€60€17827€0€17827€0€6895€7268€3264€400€0€-1.533€0.1008€7272€0.0373€19€10355€15€200€0.05€22
N€N0003€200106€ONEPRV€11€21€93€23722€0€23722€0€10722€12220€400€380€0€-0.526€0.0884€13172€0.031€12€9650€13€900€0.0311€19
N€N0003€200106€OSI€11€21€1058€248089€2075€245714€300€63505€109163€44599€28147€600€1.15000€0.0554€102160€0.0585€31€123370€21€20484€0.0677€33
N€N0003€200106€OTL€11€21€200€33973€0€33973€0€8320€18238€7115€300€0€2.20000€0.1038€11952€0.0549€18€17721€15€4300€0.2072€34
N€N0003€200106€OWC€11€21€426€97564€400€97164€0€51956€36885€6365€1958€0€0.20000€0.0286€25059€0.0166€13€64887€11€7218€0.0214€26
N€N0003€200106€PAG€11€21€182€38597€0€38597€0€14405€16254€5316€2622€0€0.15000€0.0262€13760€0.0177€24€24337€16€500€0.016€16
N€N0003€200106€PAR€11€21€38€8752€0€8752€0€2836€4398€1118€400€0€-1.667€0.0644€3723€0.049€17€4629€33€400€0.0425€17
N€N0003€200106€PAS€11€21€469€116739€596€115743€0€32186€50278€20265€12755€259€       1€0.0361€55329€0.0333€31€57869€26€2545€0.0876€29
N€N0003€200106€PCEPR€11€21€28€7237€0€7237€0€1438€3578€1621€600€0€2.05556€0.1203€2378€0.0377€23€4459€27€400€0.0825€15
N€N0003€200106€PCEPRA€11€21€67€19235€0€19235€0€4495€7684€3786€3070€200€-0.600€0.1339€6197€0.0854€34€12438€40€600€0.0767€103
N€N0003€200106€PCL€11€21€870€207041€0€205966€800€82550€84819€26006€12302€1289€1.90000€0.0518€79822€0.0285€32€112427€17€14517€0.0474€59
N€N0003€200106€PCT€11€21€41€10980€0€10980€0€1755€5233€2274€1718€0€-0.308€0.1086€4575€0.0492€32€6405€31€€€
N€N0003€200106€PDE€11€21€1349€311176€2700€307576€900€153759€109523€33382€11412€400€0.25000€0.0241€146622€0.0338€16€130255€11€31599€0.0309€23
N€N0003€200106€PECPRX€11€21€31€9116€0€9116€0€3045€5421€650€0€0€4.18182€0.253€6766€0.2323€14€2250€16€100€0.2€13
N€N0003€200106€PEP€11€21€17054€3961781€3610€3935924€19800€1877493€1559852€407217€111162€0€0.50000€0.0169€2074843€0.0276€16€1458336€12€422545€0.0302€20
N€N0003€200106€PER€11€21€681€147898€1311€146587€0€54071€50664€20863€20325€664€-0.150€0.0494€60502€0.0331€30€70966€23€15119€0.0414€37
N€N0003€200106€PFP€11€21€20€4346€0€4346€0€611€3014€223€498€0€6.81818€0.2408€2737€0.1043€23€1609€22€€€
N€N0003€200106€PFPPR€11€21€8€1998€0€1998€0€456€1542€0€0€0€2.37500€0.3709€1060€0.1181€14€938€3€€€
N€N0003€200106€PG€11€21€14631€3286058€7562€3265296€10900€1994720€980155€234132€65839€1200€0.85000€0.0383€1509114€0.0338€12€1185301€9€581781€0.0453€20
N€N0003€200106€PGF€11€21€13€3127€0€3127€0€400€2227€500€0€0€-1.727€0.1322€200€0.1€37€2927€16€€€
N€N0003€200106€PGN€11€21€4449€803192€1050€800855€1100€395029€308406€70143€26814€1563€0.55000€0.0442€356946€0.0318€16€362495€12€82514€0.0394€21
N€N0003€200106€PHA€11€21€11090€2625800€5054€2615898€2300€1194257€945635€349082€129224€0€0.90000€0.0269€1208326€0.0303€19€1030728€13€379144€0.0395€26
N€N0003€200106€PII€11€21€547€102532€100€102432€0€41394€47177€10024€3837€0€ -2.789€0.0656€43817€0.0617€19€50009€14€8606€0.067€21
N€N0003€200106€PIK€11€21€20€3575€0€3575€0€200€1904€349€1122€0€0.94118€0.048€2316€0.061€22€1092€112€167€0.02€177
N€N0003€200106€PIM€11€21€174€49075€0€49075€0€24946€18678€4419€1032€0€-0.550€0.0231€15250€0.0101€15€31123€13€2702€0.0172€21
N€N0003€200106€PIO€11€21€112€20834€0€20834€0€4049€12496€3547€742€0€      -1€0.1999€15381€0.3664€19€5353€24€100€0.03€57
N€N0003€200106€PKE€11€21€670€119484€100€119384€0€37310€62636€13909€5529€0€       0€0.0536€51032€0.0518€20€59311€16€9041€0.0835€42
N€N0003€200106€PKG€11€21€595€146975€435€146340€200€34426€54415€28787€26474€2438€1.45000€0.0363€71171€0.0341€45€66334€34€9035€0.0866€51
N€N0003€200106€PKX€11€21€711€142771€0€142226€200€41939€72365€20160€7962€0€1.65000€0.0222€67854€0.0374€22€71279€18€3293€0.0316€36
N€N0003€200106€PLP€11€21€84€20783€0€20783€0€6623€11908€1872€380€0€0.05263€0.0736€9234€0.0405€19€9569€14€1980€0.048€16
N€N0003€200106€PNP€11€21€360€77419€0€77419€0€21873€46990€6414€2142€0€2.45000€0.0584€39478€0.0455€17€35119€13€2822€0.0368€27
N€N0003€200106€PNW€11€21€2281€470049€2100€467443€400€193183€212965€42984€18311€400€2.90000€0.0449€244484€0.0442€17€188356€15€35003€0.0463€22
N€N0003€200106€PPD€11€21€1023€203099€1025€199574€2500€50324€81817€41329€28104€500€-0.400€0.0512€76073€0.06€40€105458€21€20543€0.056€41
N€N0003€200106€PPP€11€21€1071€218104€600€217504€0€90001€84657€30380€12466€0€1.65000€0.0533€86443€0.0541€21€107964€17€23097€0.0719€22
N€N0003€200106€PPPPRQ€11€21€8€1220€0€1220€0€0€340€750€130€0€-24.65€1.2508€400€0.461€62€820€29€€€
N€N0003€200106€PTV€11€21€2082€421537€524€420713€300€130636€203286€64391€22600€100€0.70000€0.0255€219254€0.0309€20€179782€19€21977€0.0307€20
N€N0003€200106€PX€11€21€4735€968093€4342€962551€400€391045€431840€105022€34611€433€1.60000€0.0323€517464€0.0384€17€360536€15€84951€0.0418€20
N€N0003€200106€RCL€11€21€888€192609€1279€191130€200€73260€79569€27645€10856€0€-0.200€0.0309€71595€0.0366€23€106888€15€12847€0.0291€21
N€N0003€200106€RCN€11€21€119€26769€0€26769€0€7428€11535€3395€4411€0€-3.421€0.13€9038€0.0576€40€14081€20€3650€0.0453€33
N€N0003€200106€RG€11€21€357€70949€0€70949€0€19784€28138€8150€13587€1290€0.21053€0.0507€16009€0.0463€71€42135€29€12805€0.0254€64
N€N0003€200106€RHB€11€21€1366€256151€6400€249751€0€54702€103946€53430€37673€0€-0.650€0.1091€117310€0.0835€36€102790€26€29651€0.1028€46
N€N0003€200106€RHD€11€21€830€166190€100€165990€0€55871€81814€20848€7457€0€0.95000€0.0431€76146€0.0406€19€82195€17€7649€0.0406€25
N€N0003€200106€RHI€11€21€2239€438400€1243€436357€800€200230€165695€49195€21787€250€       2€0.0378€212536€0.0402€18€187120€13€37501€0.0493€32
N€N0003€200106€RJF€11€21€865€179628€1970€177558€100€59606€69661€26503€21888€0€       3€0.0605€84064€0.0491€26€80046€18€13548€0.063€43
N€N0003€200106€RL€11€21€883€188977€400€187027€1200€51875€75446€38251€22355€300€0.35000€0.0584€80017€0.0683€29€84714€25€23496€0.0661€31
N€N0003€200106€RMG€11€21€406€76807€0€76807€0€31060€36138€8459€1150€0€3.31579€0.0786€40447€0.0656€14€32940€14€3420€0.0411€29
N€N0003€200106€RML€11€21€302€65767€851€64916€0€15388€24785€9913€14430€400€-0.050€0.0323€25040€0.0345€54€36262€32€3614€0.036€68
N€N0003€200106€RNS€11€21€11€3105€0€3105€0€1535€1370€200€0€0€ -19.60€0.1214€2105€0.1211€11€1000€14€€€
N€N0003€200106€ROP€11€21€637€119636€1400€118236€0€31245€46507€21949€17566€969€ -2.450€0.0654€52276€0.0767€37€54041€26€11919€0.076€60
N€N0003€200106€ROS€11€21€42€8810€0€8810€0€5900€2210€500€200€0€0.75000€0.0264€4960€0.0191€11€3850€15€€€
N€N0003€200106€ROV€11€21€1256€280099€300€278999€800€121057€99650€39115€18932€1045€2.40000€0.0251€165982€0.0469€20€98628€16€15189€0.0513€69
N€N0003€200106€RS€11€21€364€74715€300€74415€0€17112€35972€16048€5283€0€0.80000€0.0486€37850€0.0445€24€31898€21€4667€0.0411€26
N€N0003€200106€RSC€11€21€163€35415€0€35415€0€8219€17055€6911€3230€0€0.35000€0.1382€19992€0.0862€25€13593€24€1830€0.1025€40
N€N0003€200106€RTP€11€21€224€45752€200€45552€0€14891€21771€6917€1973€0€-5.250€0.4891€17391€0.1724€22€23561€14€4600€0.5028€31
N€N0003€200106€RWT€11€21€272€52267€0€52267€0€18388€19210€10069€4600€0€0.30000€0.0721€25393€0.0563€23€24774€18€2100€0.0438€14
N€N0003€200106€RWTPRB€11€21€9€1638€0€1638€0€100€1288€100€150€0€ -0.222€0.0114€1239€0.599€39€399€13€€€
N€N0003€200106€RYN€11€21€672€128546€700€127446€0€34511€58160€23802€10373€600€-0.632€0.0552€52145€0.0532€29€64697€21€10604€0.0443€37
N€N0003€200106€RZT€11€21€212€44179€0€44079€100€16442€21497€5031€1209€0€0.75000€0.0511€18311€0.046€16€23659€13€2209€0.09€34
N€N0003€200106€SACPR€11€21€3€700€0€700€0€0€0€200€500€0€17.6667€1.1014€€€€700€86€€€
N€N0003€200106€SACPRT€11€21€11€2493€0€2493€0€320€1463€300€410€0€-0.133€0.2151€413€0.1299€17€1980€41€100€0.1€16
N€N0003€200106€SAIPRW€11€21€70€17471€0€17471€0€9608€6338€1125€400€0€-1.316€0.0907€5971€0.0183€14€11400€15€100€0.03€7
N€N0003€200106€SBG€11€21€92€23981€0€23981€0€9947€6542€3638€3554€300€-0.550€0.0256€12268€0.0161€38€11713€39€€€
N€N0003€200106€SC€11€21€804€171378€1200€169328€600€35189€66402€34353€32589€1295€-0.050€0.0425€67572€0.0423€115€82345€33€20011€0.0432€74
N€N0003€200106€SCG€11€21€813€174445€1450€172995€0€36451€63067€41038€31401€1038€-1.300€0.0434€73380€0.0352€39€85091€31€14524€0.0479€57
N€N0003€200106€SCL€11€21€28€4080€0€4080€0€797€977€1156€1007€143€1.63636€0.1141€1361€0.0648€33€2719€95€€€
N€N0003€200106€SCX€11€21€19€5156€0€5156€0€1378€1806€500€1472€0€3.64286€0.1732€871€0.1332€41€4185€42€100€0.14€18
N€N0003€200106€SCZ€11€21€416€93540€0€93440€100€37105€43330€8965€4140€0€-0.100€0.0246€42050€0.032€19€49810€15€1680€0.0214€19
N€N0003€200106€SCZA€12€21€13€1667€270€1397€0€450€430€200€317€0€    -547€6.7545€317€1€165€1080€17€€€
N€N0003€200106€SDH€11€21€187€41816€0€41816€0€18699€18351€3596€1170€0€0.26316€0.0167€12656€0.0124€16€28810€12€350€0.0243€60
N€N0003€200106€SGH€11€21€24€6168€0€6168€0€1085€2758€1200€1125€0€0.26667€0.1265€2783€0.0408€37€3000€41€385€0.033€9
N€N0003€200106€SGI€11€21€340€72667€350€72017€300€24900€32188€9337€5892€0€       0€0.013€22488€0.0123€20€46559€19€3270€0.0143€58
N€N0003€200106€SGR€11€21€6170€1299132€35974€1259458€2700€574617€455207€144340€85394€2700€6.65000€0.0949€654440€0.1078€20€422851€13€184867€0.1534€37
N€N0003€200106€SGU€11€21€421€102190€475€101715€0€24400€44647€16278€15490€900€-1.950€0.0787€50870€0.0602€40€46623€28€4222€0.0301€56
N€N0003€200106€SII€11€21€12161€2461601€89352€2366784€2800€708230€989797€446578€224144€835€3.15000€0.1034€1098122€0.0831€23€658194€17€613268€0.1146€34
N€N0003€200106€SLC€11€21€462€102521€0€102521€0€31777€51814€14017€4913€0€0.40000€0.0498€39662€0.0221€22€51426€15€11433€0.021€27
N€N0003€200106€SLI€11€21€223€40617€418€39999€200€9667€16424€8563€5445€100€1.90000€0.0584€15844€0.0585€43€20722€21€3633€0.0345€53
N€N0003€200106€SO€11€21€7112€1830209€2000€1815354€11800€580083€787613€325490€133214€754€-0.200€0.0234€654768€0.0233€25€930696€18€241690€0.0333€29
N€N0003€200106€SOPRA€11€21€65€16715€0€16715€0€3470€8827€1949€2469€0€-0.118€0.0665€4028€0.0293€35€11087€27€1600€0.0338€30
N€N0003€200106€SOPRB€11€21€65€17925€0€17925€0€5235€6861€2834€2995€0€1.18750€0.0985€10104€0.042€50€7421€23€400€0.0375€42
N€N0003€200106€SOPRC€11€21€62€16462€0€16462€0€2966€8671€3400€1425€0€-1.667€0.0901€6935€0.0333€27€8927€25€600€0.0367€33
N€N0003€200106€SP€11€21€2259€417878€20700€395978€1000€88276€173307€84940€49425€1030€17.3000€0.2098€199842€0.171€26€116566€21€80570€0.2007€41
N€N0003€200106€SPN€11€21€400€100444€325€100119€0€31571€45383€12267€10898€0€1.95000€0.0288€43292€0.0424€30€56427€21€400€0.015€91
N€N0003€200106€SPP€11€21€229€51056€0€50756€300€10669€25951€9287€5149€0€0.75000€0.0357€20559€0.0263€30€27662€21€2835€0.0104€42
N€N0003€200106€SRE€11€21€4174€776656€470€775086€1100€536186€219314€17703€2755€228€1.40000€0.0319€347116€0.0326€9€370017€8€59053€0.036€11
N€N0003€200106€SREPRA€11€21€101€28661€0€28661€0€5688€17888€3435€1650€0€0.68750€0.1707€17662€0.1052€21€10199€21€800€0.075€20
N€N0003€200106€SSD€11€21€206€35844€500€35344€0€9983€16926€5118€3317€0€3.15789€0.1372€17605€0.1104€33€13239€17€4500€0.1138€32
N€N0003€200106€SSR€11€21€75€19430€0€19430€0€3254€10127€4436€1013€600€-0.737€0.0911€7555€0.0238€45€11475€28€400€0.035€22
N€N0003€200106€STZ€11€21€1619€339807€2000€337207€600€85800€149849€59664€42094€400€0.85000€0.0667€138641€0.0823€34€166570€25€32596€0.0947€42
N€N0003€200106€STZB€12€21€2€624€0€624€0€0€0€0€624€0€-1.714€2.1795€€€€400€153€224€0.25€294
N€N0003€200106€SUR€11€21€181€31393€0€31393€0€11609€15609€2915€1260€0€-0.250€0.0639€12522€0.0329€17€17749€15€1122€0.04€22
N€N0003€200106€SUT€11€21€236€35284€0€35084€0€12819€18577€3588€100€0€-2.150€0.0223€16575€0.0263€15€17409€13€1100€0.0291€14
N€N0003€200106€SUTPRA€11€21€47€10131€0€10131€0€1975€6048€2008€100€0€-0.588€0.1397€5027€0.083€25€5104€15€€€
N€N0003€200106€SVAPR€11€21€12€3315€0€3315€0€200€1775€1340€0€0€-1.300€0.1859€1185€0.0888€22€1930€29€200€0.05€13
N€N0003€200106€SWM€11€21€126€25116€100€25016€0€8271€12267€3269€1209€0€0.70000€0.0897€9365€0.0636€26€13651€16€2000€0.075€24
N€N0003€200106€SZ€11€21€12€2987€0€2987€0€0€1937€900€150€0€0.21053€0.0453€500€0.03€30€2487€36€€€
N€N0003€200106€TAPPRA€11€21€151€40656€0€40656€0€9089€25026€6266€275€0€-0.050€0.0587€14590€0.0156€21€25766€17€300€0.03€15
N€N0003€200106€TAPPRB€11€21€23€5637€0€5637€0€628€4379€630€0€0€1.46667€0.112€4215€0.0363€18€1222€10€200€0.04€11
N€N0003€200106€TCC€11€21€160€33038€0€32738€300€5154€13144€8508€6232€0€0.20000€0.0487€15161€0.0428€44€15526€27€2351€0.0516€33
N€N0003€200106€TCH€11€21€46€10532€0€10532€0€1828€7022€700€982€0€1.75000€0.0697€2692€0.0298€26€7640€21€200€0.05€0
N€N0003€200106€TCLPR€11€21€23€6611€0€6611€0€2911€3700€0€0€0€0.44444€0.1033€1800€0.0339€16€4811€11€€€
N€N0003€200106€TCR€11€21€254€64034€0€64034€0€13892€25318€11708€12916€200€-1.300€0.0366€20925€0.0261€44€38017€34€5092€0.0244€58
N€N0003€200106€TD€11€21€444€84704€200€84504€0€26904€43499€9309€4792€0€0.68421€0.0518€30355€0.0191€20€40045€14€14104€0.0498€25
N€N0003€200106€TDI€11€21€22€5012€0€5012€0€850€2266€1175€721€0€-2.100€0.177€2011€0.0975€46€3001€24€€€
N€N0003€200106€TDR€11€21€26€4930€0€4930€0€160€4120€450€200€0€-2.263€0.1429€3070€0.0602€24€1860€18€€€
N€N0003€200106€TDY€11€21€602€111666€327€111339€0€39645€56089€11267€4338€0€1.25000€0.0325€46693€0.0382€21€60096€14€4550€0.0372€18
N€N0003€200106€TEE€11€21€387€93634€194€93440€0€38091€39954€10290€5205€0€0.30000€0.0979€55764€0.0522€17€33575€17€4101€0.0442€24
N€N0003€200106€TEF€11€21€1902€396187€0€395605€100€185332€137753€47922€24698€0€1.95000€0.0489€199060€0.031€21€167710€14€28935€0.0439€27
N€N0003€200106€TEM€11€21€5€975€0€975€0€375€200€400€0€0€6.14286€0.2467€300€0.1167€11€675€25€€€
N€N0003€200106€TEN€11€21€340€70065€0€70065€0€20950€30885€10353€7877€0€0.80000€0.0338€26121€0.0405€24€39987€23€3957€0.0298€12
N€N0003€200106€TFS€11€21€769€145212€800€143612€800€41861€68860€23910€9781€0€2.50000€0.0531€57459€0.0478€23€76318€19€10635€0.0542€23
N€N0003€200106€TGT€11€21€13947€3240598€7313€3215448€13900€1249034€1213942€478651€281570€6151€       0€0.0267€1754183€0.0402€22€1020458€16€454707€0.0506€33
N€N0003€200106€THX€11€21€702€138946€400€137546€600€38790€53171€27131€18274€780€1.15789€0.0806€45773€0.104€35€75898€24€16475€0.1466€48
N€N0003€200106€TI€11€21€314€58047€100€57847€100€5609€27586€14591€9798€363€-5.850€0.3006€31788€0.331€46€23256€24€2903€0.1905€36
N€N0003€200106€TIA€12€23€1€3300€2600€700€0€0€0€0€700€0€    -127€2.68€€€€700€208€€€
N€N0003€200106€TLI€11€21€70€18393€0€18393€0€5914€7198€3215€2066€0€0.31579€0.0413€4007€0.0171€38€13686€23€700€0.0357€23
N€N0003€200106€TLK€11€21€37€9060€0€9060€0€1072€5706€1383€899€0€0.65000€0.0239€6138€0.0201€21€2922€33€€€
N€N0003€200106€TOL€11€21€1670€345725€1300€343187€300€106434€153897€54404€28752€0€0.10000€0.0455€141820€0.0581€27€171803€19€29864€0.0657€25
N€N0003€200106€TR€11€21€913€189915€1800€188115€0€37995€79907€42395€26708€1110€-4.650€0.0758€79587€0.0422€37€92597€28€15931€0.1202€54
N€N0003€200106€TRA€11€21€304€53919€100€53619€200€18468€22849€10610€1892€200€-0.250€0.0187€18222€0.0285€24€34022€21€1575€0.0225€27
N€N0003€200106€TRP€11€21€180€40568€300€39968€300€18516€17508€3049€1195€0€0.55000€0.0269€17545€0.0144€14€22113€14€610€0.0166€13
N€N0003€200106€TRPPR€11€21€65€18352€0€18352€0€6762€8990€2100€500€0€-0.053€0.0513€8625€0.0222€22€9527€12€200€0.03€10
N€N0003€200106€TRPPRC€11€21€25€6352€0€6352€0€3210€2942€200€0€0€-0.200€0.0643€2510€0.0303€14€3842€11€€€
N€N0003€200106€TTR€11€21€23€6839€0€6839€0€4785€1668€386€0€0€      -8€0.0552€1506€0.0338€10€5333€9€€€
N€N0003€200106€TWE€11€21€558€116045€212€115233€600€36782€50391€20674€7986€0€-3.950€0.0223€38403€0.0222€28€69540€19€7890€0.0292€31
N€N0003€200106€TWK€11€21€339€62550€426€62124€0€17218€21312€10709€12585€300€2.30000€0.0307€32607€0.0461€34€27617€38€1900€0.0442€41
N€N0003€200106€TX€11€21€10843€2376297€9060€2363465€2500€1397168€761431€163587€43779€0€1.30000€0.0354€1075238€0.0369€12€866775€10€423952€0.0385€15
N€N0003€200106€TXCPRA€11€21€138€35819€0€35819€0€20100€13164€1840€615€100€-0.526€0.0725€12355€0.0141€13€22764€13€700€0.0557€15
N€N0003€200106€TXCPRB€11€21€33€7489€0€7489€0€2855€3884€600€150€0€7.12500€0.1246€3550€0.0445€12€3739€19€200€0.01€22
N€N0003€200106€TXN€11€21€32718€7538253€101229€7394161€34500€2539737€2403485€1376649€1086906€21884€0.70000€0.0401€3888049€0.0556€27€1778802€21€1761810€0.066€43
N€N0003€200106€UIS€11€21€3976€863380€300€860260€2600€520238€271865€59247€11158€352€0.30000€0.0169€410722€0.0227€12€392168€9€59970€0.0259€19
N€N0003€200106€VAP€11€21€25€5620€0€5620€0€1085€2560€500€1475€0€3.28571€0.0888€4035€0.0313€40€1485€25€100€0.02€11
N€N0003€200106€VBF€11€21€88€20011€0€20011€0€4270€7857€4087€3597€200€0.21429€0.0668€10578€0.0362€41€9233€30€200€0.02€320
N€N0003€200106€VEA€11€21€61€17329€0€17329€0€5199€9135€2195€800€0€-1.588€0.0988€8620€0.0473€19€8309€17€400€0.04€15
N€N0003€200106€VELPRT€11€21€40€9565€0€9565€0€3225€5640€600€100€0€0.05882€0.1207€5245€0.0358€15€4020€10€300€0.07€21
N€N0003€200106€VGM€11€21€26€5974€0€5974€0€2694€2750€530€0€0€0.40000€0.0349€3386€0.0109€14€2588€12€€€
N€N0003€200106€VGR€11€21€505€95521€600€94921€0€26817€43606€15460€8788€250€3.80000€0.1196€39410€0.111€32€46153€19€9358€0.0972€28
N€N0003€200106€VIG€11€21€10€2057€0€2057€0€389€1668€0€0€0€0.26316€0.0391€800€0.0125€10€1157€10€100€0.01€13
N€N0003€200106€VIN€11€21€31€6807€0€6807€0€2456€1434€892€2025€0€0.83333€0.0312€2010€0.013€41€4797€48€€€
N€N0003€200106€VIT€11€21€48€12624€0€12624€0€7444€4875€305€0€0€0.25000€0.0359€6412€0.0114€11€5887€8€325€0.01€8
N€N0003€200106€VNV€11€21€7€2270€0€2270€0€780€1190€300€0€0€-0.125€0.0457€538€0.01€26€1732€10€€€
N€N0003€200106€VOD€11€21€7053€1514065€2700€1506152€4300€792257€578419€118150€21426€200€0.40000€0.0158€842187€0.0218€14€579386€10€88879€0.0263€17
N€N0003€200106€VOL€11€21€102€20551€0€20551€0€5757€10161€2999€1534€100€1.94737€0.0808€10322€0.0528€27€8844€20€1385€0.0453€26
N€N0003€200106€VOT€11€21€23€6573€0€6573€0€2658€3686€229€0€0€0.11765€0.0539€2850€0.0175€15€2968€10€755€0.01€23
N€N0003€200106€VPA€11€21€33€9050€0€9050€0€1907€5339€1300€504€0€0.66667€0.0632€5957€0.0343€22€3093€18€€€
N€N0003€200106€VPQ€11€21€33€8868€0€8868€0€2747€4560€686€875€0€0.66667€0.0517€3903€0.0212€19€4965€23€€€
N€N0003€200106€VRC€11€21€3288€721772€1186€719800€600€264831€294864€105814€54891€0€0.30000€0.045€286261€0.0307€21€317784€20€116355€0.0471€28
N€N0003€200106€VSH€11€21€2045€439313€1600€434513€3200€160494€181677€67281€28161€100€1.10000€0.0236€201249€0.0324€22€186762€16€49702€0.0348€26
N€N0003€200106€VVC€11€21€766€178642€300€178342€0€45864€72830€35634€23102€912€-1.050€0.0386€69059€0.0436€36€101042€24€8241€0.0549€69
N€N0003€200106€VVR€11€21€328€83284€0€83284€0€28751€37822€13076€3635€0€-0.200€0.013€15688€0.0125€22€66309€18€1287€0.01€29
N€N0003€200106€WFR€11€21€248€55333€0€55133€200€19295€21918€7154€6214€752€-1.211€0.0502€20319€0.0448€40€31596€17€3418€0.0496€22
N€N0003€200106€WG€11€21€177€43323€200€43123€0€7887€16391€10247€8498€100€-0.650€0.0786€26932€0.0573€40€12256€37€3935€0.0413€33
N€N0003€200106€WLP€11€21€3166€613165€3600€607565€1800€224212€285602€70528€28442€581€2.65000€0.0537€307476€0.0591€19€225772€15€76117€0.0715€21
N€N0003€200106€WNI€11€21€6€620€0€620€0€100€320€200€0€0€0.29412€0.0194€420€0.0333€11€200€39€€€
N€N0003€200106€WSM€11€21€1521€335089€7400€327689€0€107654€147769€43968€28298€0€3.05000€0.0431€146297€0.0509€24€138437€17€42955€0.0611€38
N€N0003€200106€WTS€11€21€134€25867€0€25867€0€9094€10894€4105€1774€0€1.16667€0.0725€13047€0.0591€24€12620€23€200€0.01€8
N€N0003€200106€XRX€11€21€6165€1563755€1500€1551990€9300€899430€518310€111272€32278€0€0.05000€0.0141€589903€0.0185€14€835374€9€136013€0.0244€21
N€N0003€200106€XVF€11€21€284€63667€300€63367€0€20329€30220€10193€2625€0€-3.300€0.2107€36209€0.0865€21€24028€17€3130€0.1246€6
N€N0003€200106€YLD€11€21€49€13280€0€13280€0€5464€4515€2276€1025€0€-0.350€0.0193€3096€0.0162€19€9884€23€300€0.01€7
N€N0003€200106€YUM€11€21€3481€681270€15304€663764€1800€124966€222082€150777€158519€9220€1.30000€0.025€322286€0.0381€48€259741€38€83537€0.0503€67
N€N0003€200106€ZIF€11€21€45€9335€0€9335€0€3943€4592€700€100€0€-1.300€0.0384€4741€0.018€12€4594€17€€€
N€N0003€200106€ZMX€11€21€13€2620€0€2620€0€0€1999€353€268€0€      -1€0.0335€1979€0.0469€24€641€47€€€'

	EXEC -t'€' -k 4,4 -lsum,regress,op=count:integer:7:average:float:17 $data/euro.dat
		OUTPUT - $'N€N0003€200106€AA€11€21€14596€3524300€9331€3494983€15500€1129332€1283396€639798€452298€5659€       0€0.0289€1717663€0.038€30€1195358€20€597462€0.0481€35
N€N0003€200106€AAT€11€21€48€14046€0€14046€0€7421€4549€1485€591€0€       0€0.0304€2513€0.01€25€11333€14€200€0.01€90
N€N0003€200106€ABJ€11€21€57€14508€0€14508€0€2603€9175€1650€1080€0€       2€0.0779€6636€0.0136€17€7872€25€€€
N€N0003€200106€ABS€11€21€7425€1465605€200€1461410€2900€483622€651665€241738€87165€120€       0€0.0284€599869€0.0306€22€670152€18€194289€0.0373€25
N€N0003€200106€ABT€11€21€14051€3368858€8904€3347422€10900€1469987€1273455€447558€166267€1055€       0€0.0273€1682138€0.0365€18€1150749€14€525435€0.044€25
N€N0003€200106€ACA€11€21€45€11490€0€11490€0€2845€7495€100€1050€0€       1€0.0946€5052€0.0146€17€6438€22€€€
N€N0003€200106€ACS€11€21€2456€523323€13500€509523€0€192518€202103€71973€42229€700€       0€0.0658€254514€0.0654€21€177869€17€77140€0.0915€38
N€N0003€200106€AEF€11€21€210€61757€0€61757€0€9524€22881€15536€13616€200€       0€0.0464€24867€0.0137€47€35248€43€1642€0.0401€27
N€N0003€200106€AET€11€21€2439€472785€900€471531€300€213068€162069€63465€32949€280€       0€0.0217€214120€0.0315€22€224763€16€32948€0.035€26
N€N0003€200106€AGC€11€21€6689€1443428€2747€1438956€1000€588445€574302€188125€88940€0€       0€0.0283€603123€0.0256€22€661220€16€175613€0.0329€31
N€N0003€200106€AGCPRA€11€21€56€16339€0€16339€0€3810€5914€4990€1625€0€       0€0.1187€7461€0.11€44€8678€25€200€0.085€8
N€N0003€200106€AGCPRB€11€21€25€6853€0€6853€0€100€3855€1550€1348€0€      -1€0.115€3097€0.0587€44€3756€46€€€
N€N0003€200106€AGCPRM€11€21€57€15702€100€15602€0€1685€7911€3046€2170€790€      -2€0.0876€4071€0.0247€64€11031€65€500€0.078€166
N€N0003€200106€AGCPRMCL€11€21€4€1223€0€1223€0€0€923€300€0€0€       1€0.04€1223€0.01€22€€€€€
N€N0003€200106€AGCPRN€11€21€82€18338€0€18338€0€5186€8423€2223€2306€200€      -2€0.0967€2885€0.0334€65€15203€23€250€0.046€21
N€N0003€200106€AGCPRNCL€11€21€3€665€0€665€0€100€565€0€0€0€       0€0.01€€€€665€21€€€
N€N0003€200106€AGI€11€21€23€4879€0€4879€0€730€2761€1388€0€0€      -1€0.0238€4099€0.0433€19€780€29€€€
N€N0003€200106€AHO€11€21€514€101764€100€101464€200€25120€56355€13898€6291€0€      -2€0.061€51772€0.043€22€43731€19€6161€0.0371€23
N€N0003€200106€AIV€11€21€697€143764€0€143464€0€58036€56027€19187€10214€0€      -1€0.0629€54117€0.0484€20€80319€20€9028€0.0438€29
N€N0003€200106€AIVPRC€11€21€23€5998€0€5998€0€2025€2725€948€300€0€      -1€0.1098€2675€0.0259€25€3023€15€300€0.09€37
N€N0003€200106€AIVPRD€11€21€63€15180€0€15180€0€5430€8025€825€900€0€       1€0.1226€6105€0.0322€15€8975€24€100€0.04€12
N€N0003€200106€AIVPRG€11€21€45€12295€0€12295€0€3195€6435€1315€1350€0€       0€0.0783€3675€0.0122€30€7920€24€700€0.0343€32
N€N0003€200106€AIVPRH€11€21€25€5959€0€5959€0€2100€3074€785€0€0€       0€0.1345€2824€0.0322€13€3035€18€100€0.11€9
N€N0003€200106€AIVPRK€11€21€9€2070€0€2070€0€0€1070€600€400€0€       0€0.4413€1350€0.1863€48€720€20€€€
N€N0003€200106€AIVPRP€11€21€56€11916€0€11916€0€3681€4873€2148€1214€0€       2€0.2129€3376€0.0379€23€8540€26€€€
N€N0003€200106€AIVPRQ€11€21€39€10242€0€10242€0€3898€5497€327€520€0€       1€0.0792€4613€0.0174€19€5629€13€€€
N€N0003€200106€AJG€11€21€875€196649€600€196049€0€80999€79015€21230€12954€1851€       1€0.0426€79215€0.0366€26€106810€13€10024€0.0518€45
N€N0003€200106€ALM€11€21€38€9137€0€9137€0€300€7876€961€0€0€      -4€0.0618€7139€0.0245€19€1998€15€€€
N€N0003€200106€ALPPRN€11€21€3€1290€0€1290€0€0€890€400€0€0€       1€0.181€400€0.05€16€890€21€€€
N€N0003€200106€ALPPRO€11€21€6€1700€0€1700€0€0€1700€0€0€0€      -6€0.2247€950€0.0621€26€750€18€€€
N€N0003€200106€ALPPRQ€11€21€28€7400€0€7400€0€2517€4483€400€0€0€       1€0.0795€3496€0.0287€17€3904€11€€€
N€N0003€200106€ALPPRR€11€21€43€12186€0€12186€0€2223€8511€1152€300€0€       0€0.0713€4546€0.0179€18€7540€15€100€0.04€63
N€N0003€200106€ALQ€11€21€53€14947€0€14947€0€5706€7091€2050€100€0€       1€0.0864€8607€0.0231€21€6040€12€300€0.01€7
N€N0003€200106€ALZ€11€21€38€10019€0€10019€0€800€8563€656€0€0€       3€0.1095€6749€0.0256€19€3270€13€€€
N€N0003€200106€AMB€11€21€340€82057€0€81694€0€49345€26444€3944€1961€0€       0€0.029€37759€0.0248€12€40635€11€3300€0.0224€15
N€N0003€200106€AMBPRA€11€21€19€5460€0€5460€0€3560€1700€200€0€0€       0€0.1091€3300€0.0473€10€2160€13€€€
N€N0003€200106€AMD€11€21€22321€4782471€105767€4655665€17300€1343670€1809871€952933€564656€1635€       0€0.0399€2160554€0.0464€24€1180503€21€1331908€0.0601€37
N€N0003€200106€ANN€11€21€1471€308613€7500€301013€100€160173€110558€25319€5063€0€       0€0.0525€131184€0.0608€13€134861€10€35068€0.0762€17
N€N0003€200106€AOC€11€21€3951€740421€1545€737685€900€213132€304297€146622€73959€575€       0€0.0241€340231€0.0367€28€337678€21€60676€0.0378€34
N€N0003€200106€ARB€11€21€432€81559€300€81259€0€24043€40724€12568€3924€0€       1€0.0549€39589€0.0546€22€36715€18€4955€0.0477€23
N€N0003€200106€ARH€11€21€9€1815€0€1815€0€400€1115€100€200€0€      -1€0.0527€1190€0.0182€31€625€19€€€
N€N0003€200106€ATI€11€21€1153€204221€195€204026€0€95949€86063€15394€6520€100€       0€0.0249€88367€0.0285€16€109155€13€6504€0.0249€20
N€N0003€200106€AVP€11€21€5362€1025278€1664€1021714€1300€640871€320330€47980€12801€1032€       0€0.0305€463631€0.0358€10€466899€8€92484€0.0454€15
N€N0003€200106€AVZ€11€21€203€42999€0€42899€100€15985€19543€6471€1000€0€      -2€0.1957€20702€0.1167€19€19355€14€2942€0.0663€19
N€N0003€200106€AXL€11€21€233€43442€0€43442€0€11343€20974€6885€4240€0€       0€0.0834€21281€0.0732€30€20822€22€1339€0.0249€14
N€N0003€200106€AZA€11€21€4036€777156€5600€770456€500€475253€227074€51985€16512€132€      -1€0.0359€346051€0.0248€11€287853€9€137052€0.035€17
N€N0003€200106€AZZ€11€21€141€30688€0€30688€0€5454€17696€5938€1600€0€       1€0.0925€17081€0.0713€24€12107€24€1500€0.0293€20
N€N0003€200106€BC€11€21€1794€347438€2150€344388€900€119326€140853€55052€29034€1023€       0€0.0287€151059€0.0335€27€165409€19€28820€0.0421€28
N€N0003€200106€BCC€11€21€1261€232534€1500€231034€0€90880€102617€27338€10199€0€       0€0.0495€86498€0.0425€21€123377€15€21159€0.0489€20
N€N0003€200106€BD€11€21€132€26224€200€26024€0€8210€15964€1850€0€0€       0€0.0147€10370€0.0141€12€14654€13€1000€0.014€21
N€N0003€200106€BDF€11€21€39€9620€0€9620€0€3229€4243€1738€410€0€       0€0.0565€2903€0.0136€13€6717€23€€€
N€N0003€200106€BGG€11€21€774€164711€600€163823€0€76597€68590€14556€4080€0€       1€0.0874€65955€0.0439€16€85847€11€12021€0.0977€21
N€N0003€200106€BGT€11€21€60€15473€0€15473€0€8014€5024€1985€450€0€       0€0.0185€3385€0.01€10€12088€14€€€
N€N0003€200106€BK€11€21€14814€3340606€5800€3332030€800€2109454€974660€195186€53530€0€       0€0.0372€1548826€0.0305€11€1273475€9€510529€0.0417€16
N€N0003€200106€BKE€11€21€104€18544€0€18544€0€3788€12093€2226€437€0€       0€0.0528€10301€0.0694€18€7843€20€400€0.035€15
N€N0003€200106€BKPRC€11€21€66€17897€0€17897€0€10855€5842€850€350€0€       1€0.0857€8767€0.0274€15€8630€11€500€0.028€7
N€N0003€200106€BKPRD€11€21€80€21826€0€21826€0€13055€7571€500€700€0€       0€0.0714€10371€0.0168€11€11155€14€300€0.08€18
N€N0003€200106€BKPRE€11€21€81€23243€0€23243€0€10876€10497€1470€400€0€       2€0.0832€15715€0.0205€15€7528€12€€€
N€N0003€200106€BLI€11€21€1232€227952€1609€226143€100€75627€104943€33926€11747€0€       0€0.0263€112032€0.0332€20€104908€17€9303€0.0328€22
N€N0003€200106€BNI€11€21€6187€1206018€400€1203328€1600€680896€414696€85020€23178€1138€       0€0.0285€588392€0.0262€13€511908€10€104628€0.0403€19
N€N0003€200106€BR€11€21€7135€1378982€4900€1370416€2000€687207€493400€131614€58722€1473€       0€0.0302€782525€0.0406€16€459377€12€130514€0.0503€29
N€N0003€200106€BRG€11€21€56€11360€0€11360€0€2143€6614€1791€812€0€      -5€0.1699€6410€0.118€29€4850€22€100€0.1€63
N€N0003€200106€BSP€11€21€25€4791€0€4791€0€1745€2537€509€0€0€       0€0.0835€2054€0.0143€14€2337€15€400€0.045€9
N€N0003€200106€BTY€11€21€1036€203914€400€203314€200€78459€82586€27485€14884€100€       1€0.1174€111376€0.0744€24€78300€16€13838€0.0657€24
N€N0002€200106€BTYRT€11€21€239€50506€0€50506€0€19517€24313€3320€3356€0€    -248€0.1598€32175€0.1498€23€17731€14€600€0.055€20
N€N0003€200106€BWG€11€21€30€6512€0€6512€0€1183€4379€650€300€0€      -3€0.1734€4366€0.0936€24€2046€21€100€0.08€0
N€N0003€200106€BXS€11€21€157€33939€0€33939€0€14334€13818€5063€724€0€       0€0.0378€17439€0.042€14€15418€17€1082€0.0204€22
N€N0003€200106€BYD€11€21€166€35218€200€35018€0€8011€13121€6471€7115€300€       0€0.0426€12541€0.0321€37€19449€44€3028€0.0338€50
N€N0003€200106€BZL€11€21€10€2330€0€2330€0€1000€400€530€400€0€      -1€0.0748€1130€0.04€53€800€8€400€0.02€7
N€N0003€200106€C€11€21€36206€7798662€31303€7747379€16900€3563357€2481386€1113981€603003€2552€       0€0.0228€4246991€0.0389€19€2228824€15€1288464€0.0463€33
N€N0003€200106€CBM€11€21€983€194272€2240€191632€0€63286€89872€27044€11430€0€       3€0.1101€81401€0.0814€22€85841€16€24390€0.132€30
N€N0003€200106€CCC€11€21€209€43832€300€43532€0€9359€19019€8257€6297€600€       0€0.0488€20746€0.0443€44€20283€29€2503€0.0202€39
N€N0003€200106€CCPPRA€11€21€60€13025€0€13025€0€2350€7424€2707€544€0€       3€0.3285€5751€0.0625€18€6774€26€500€0.058€17
N€N0003€200106€CCR€11€21€3630€728090€6800€719678€1000€267653€271128€122720€59077€100€       1€0.0301€346880€0.0381€22€277870€18€95928€0.0488€30
N€N0003€200106€CEA€11€21€10€2229€0€2229€0€300€1601€328€0€0€      -6€0.1549€928€0.031€17€1201€16€100€0.01€16
N€N0003€200106€CED€11€21€138€25925€300€25625€0€5812€12625€5838€1350€0€      -4€0.108€13523€0.0484€25€10252€19€1850€0.043€36
N€N0003€200106€CEM€11€21€155€30385€0€30385€0€6560€16100€6125€1600€0€       1€0.0917€15567€0.0682€23€13468€23€1350€0.0337€30
N€N0003€200106€CEN€11€21€498€110436€0€110236€200€45363€46318€11486€6969€300€       0€0.0306€50010€0.0344€21€55025€14€5401€0.0262€38
N€N0003€200106€CF€11€21€3637€639764€3248€634316€1500€182374€248718€123189€77927€3608€       0€0.0254€286515€0.033€30€282454€22€66847€0.0282€49
N€N0003€200106€CFE€11€21€7€1684€0€1684€0€1300€100€284€0€0€       4€0.1669€984€0.25€18€700€8€€€
N€N0003€200106€CFN€11€21€16€4234€0€4234€0€1018€1116€1300€800€0€      -1€0.0828€1200€0.3967€71€3034€26€€€
N€N0003€200106€CGPPRG€12€21€54€5400€4900€500€0€0€100€200€200€0€     -59€0.184€200€0.75€80€300€33€€€
N€N0003€200106€CGPPRI€11€21€4€750€0€750€0€0€200€0€400€150€     -17€0.026€550€0.7182€511€200€23€€€
N€N0003€200106€CGPPRT€11€21€38€9711€0€9711€0€3766€4598€1147€200€0€      -4€0.0734€2517€0.0372€15€7042€15€152€0.01€24
N€N0003€200106€CHD€11€21€606€132464€1359€131105€0€52672€55896€14149€7853€535€       0€0.0634€55486€0.0467€19€68291€17€7328€0.0501€27
N€N0003€200106€CHH€11€21€242€54062€0€53762€0€17816€21767€9596€4583€0€       0€0.0552€26188€0.0734€31€23562€16€4012€0.0527€16
N€N0002€200106€CHTRT€11€21€12€3174€0€3174€0€160€0€320€2375€319€       0€0.0609€1735€0.0113€116€1439€198€€€
N€N0002€200106€CHTRTWI€12€24€1€5000€0€5000€0€0€0€5000€0€0€      -1€0.04€€€€5000€31€€€
N€N0003€200106€CIC€11€21€184€49613€0€49613€0€12025€25301€7518€4769€0€       0€0.0656€15733€0.0419€22€33280€25€600€0.0533€62
N€N0003€200106€CIP€11€21€84€22418€0€22418€0€4677€16266€1050€425€0€      -1€0.0745€11685€0.0212€16€10033€16€700€0.0229€12
N€N0003€200106€CIR€11€21€339€57557€600€56957€0€24724€23479€6114€2640€0€       2€0.0568€31783€0.0736€16€21547€14€3627€0.1043€30
N€N0003€200106€CKC€11€21€157€29607€0€29607€0€9386€15183€3387€1651€0€       0€0.0255€7241€0.0637€30€21486€17€880€0.0327€46
N€N0003€200106€CKH€11€21€487€88089€0€88089€0€41269€36261€7618€2941€0€       1€0.0825€32140€0.0668€15€48565€12€7384€0.0821€18
N€N0003€200106€CLB€11€21€640€122678€600€122078€0€25245€56302€22564€17297€670€       0€0.0714€57167€0.0743€39€58510€25€6401€0.0322€58
N€N0003€200106€CLJ€11€21€236€38026€0€38026€0€5116€17590€8934€6386€0€       0€0.0909€17649€0.0682€43€19877€32€500€0.042€67
N€N0003€200106€CLL€11€21€46€8406€300€8106€0€1238€4650€1785€433€0€      -9€0.2263€3948€0.1524€16€3958€24€200€0.29€58
N€N0003€200106€CMO€11€21€543€106712€0€106312€400€43418€52504€8949€1841€0€       0€0.0488€53463€0.043€16€49371€12€3878€0.0384€11
N€N0003€200106€CMOPRA€11€21€15€3043€0€3043€0€1294€850€599€300€0€     -20€0.3056€1249€0.5695€35€1794€16€€€
N€N0003€200106€CMOPRB€11€21€38€10036€0€10036€0€3886€4894€915€341€0€       1€0.13€3128€0.0804€19€6528€19€380€0.01€14
N€N0003€200106€CMP€11€21€326€73395€0€73395€0€17955€42915€9935€2590€0€       0€0.1083€20714€0.0277€19€48680€18€4001€0.0559€33
N€N0003€200106€CMS€11€21€2234€430340€888€427110€2000€222679€168912€27920€9599€0€       0€0.0312€192319€0.0264€13€205993€11€30798€0.0334€18
N€N0003€200106€CMSPRJ€11€21€22€6005€0€6005€0€975€4230€800€0€0€      11€0.2442€3930€0.0288€18€1775€17€300€0.1€17
N€N0003€200106€CMSPRK€11€21€33€9399€0€9399€0€800€7649€950€0€0€       2€0.2479€2575€0.0399€17€6124€18€700€0.1843€12
N€N0003€200106€CMSPRL€11€21€35€9413€0€9413€0€2016€4977€2005€415€0€      -3€0.1851€4199€0.0565€24€4814€22€400€0.1€37
N€N0003€200106€CMSPRM€11€21€7€1698€0€1698€0€0€1398€0€300€0€     -11€0.3419€1398€0.0949€20€€€300€0.25€156
N€N0003€200106€CMSPRN€11€21€17€4241€0€4241€0€523€2258€1260€200€0€       1€0.0779€3641€0.0212€28€600€9€€€
N€N0003€200106€CNA€11€21€681€155244€0€154844€400€57125€83968€12351€1800€0€       0€0.0546€66722€0.0293€14€80492€10€8030€0.033€17
N€N0003€200106€CNL€11€21€567€129633€100€129233€300€70295€48666€7529€3043€0€       0€0.0612€53723€0.0363€14€69264€10€6546€0.0487€18
N€N0003€200106€CNN€11€21€21€4852€0€4852€0€2531€1646€200€475€0€      -2€0.038€3087€0.0285€13€1765€48€€€
N€N0003€200106€COE€11€21€21€5098€0€5098€0€1085€1178€1635€1200€0€       0€0.0358€1785€0.0243€33€3313€59€€€
N€N0003€200106€COG€11€21€625€131188€1478€129510€200€31708€55095€27764€14801€342€       0€0.0433€60097€0.0666€32€60933€24€8680€0.0682€51
N€N0003€200106€CPD€11€21€41€9634€0€9634€0€4435€3309€1640€250€0€       1€0.0417€7584€0.0444€18€2050€11€€€
N€N0003€200106€CPP€11€21€13€3230€0€3230€0€900€1350€980€0€0€      14€0.1737€900€0.0567€28€2330€18€€€
N€N0003€200106€CPRE€11€21€90€23321€0€23321€0€2550€15745€3669€1357€0€       1€0.0674€13212€0.0199€26€9709€18€400€0.1€41
N€N0003€200106€CPRF€11€21€6€1100€0€1100€0€0€900€0€200€0€       4€0.3159€250€0.48€23€850€28€€€
N€N0003€200106€CPRG€11€21€7€1326€0€1326€0€0€764€562€0€0€      14€0.4987€664€0.1324€29€662€30€€€
N€N0003€200106€CPRH€11€21€6€1320€0€1320€0€0€600€720€0€0€      13€0.422€920€0.1978€23€400€59€€€
N€N0003€200106€CPRK€11€21€42€11084€0€11084€0€500€7692€2092€600€200€       7€0.2243€5553€0.0862€41€5131€29€400€0.165€32
N€N0003€200106€CPRM€11€21€10€2226€0€2226€0€339€960€727€200€0€      12€0.5577€1580€0.2241€29€446€18€200€0.25€38
N€N0003€200106€CPRN€11€21€43€11091€0€11091€0€2000€7226€1205€660€0€       1€0.0632€5145€0.0127€21€5946€26€€€
N€N0003€200106€CPRQ€11€21€4€1200€0€1200€0€0€500€700€0€0€      27€0.5625€400€0.05€31€600€21€200€0.1€22
N€N0003€200106€CPRR€11€21€2€500€0€500€0€0€300€0€200€0€      28€0.602€300€0.03€26€200€72€€€
N€N0003€200106€CPRU€11€21€12€3145€0€3145€0€200€1745€800€400€0€      23€0.5192€1470€0.0813€20€1675€47€€€
N€N0003€200106€CPRW€11€21€203€54632€0€54632€0€10698€29850€9542€4142€400€       1€0.0715€24025€0.0144€27€30207€31€400€0.04€21
N€N0003€200106€CPRX€11€21€152€45053€400€44653€0€9460€26551€5112€3530€0€       1€0.0603€19055€0.0159€31€25098€22€500€0.044€106
N€N0003€200106€CQPRA€11€21€80€19210€0€19210€0€5594€9166€3275€1175€0€       0€0.1641€10230€0.0347€18€8480€27€500€0.08€40
N€N0003€200106€CRM€11€21€6€1000€0€1000€0€0€300€0€700€0€      -5€-0.057€500€0.81€65€500€66€€€
N€N0003€200106€CRY€11€21€1181€234595€3650€230145€500€98877€107261€19489€5018€0€       2€0.1235€91095€0.097€16€107036€12€32514€0.1306€20
N€N0003€200106€CSL€11€21€702€142404€860€141544€0€43960€64987€21866€10199€532€       1€0.0624€60868€0.0381€24€68088€17€12588€0.0475€27
N€N0003€200106€CSP€11€21€46€11788€0€11188€600€4305€5430€1114€939€0€       0€0.0379€3505€0.0229€13€8183€24€100€0.02€14
N€N0003€200106€CVC€11€21€1573€300546€2400€297846€0€124254€143338€23288€6966€0€       1€0.0522€119404€0.0584€16€145555€12€32887€0.052€19
N€N0003€200106€CVD€11€21€957€215338€1250€212285€1000€63619€102151€34471€13044€0€       0€0.0433€91877€0.0469€22€107181€19€14227€0.0438€27
N€N0003€200106€CW€11€21€64€11629€0€11629€0€1568€7271€1704€1086€0€       0€0.1445€5531€0.0981€29€5598€18€500€0.082€24
N€N0003€200106€CWN€11€21€268€59776€200€59176€400€10708€28045€14206€6517€100€       0€0.0268€23025€0.035€36€35286€30€1265€0.0361€38
N€N0003€200106€CWNPRA€11€21€23€5460€0€5460€0€1280€2775€1105€300€0€       2€0.1623€2850€0.0813€21€2610€29€€€
N€N0003€200106€CYE€11€21€163€44347€0€44047€300€11950€16310€9270€6567€250€       0€0.029€15808€0.0208€39€28139€28€400€0.03€68
N€N0003€200106€D€11€21€6378€1219758€2220€1216438€1100€899099€288283€25052€5104€0€       0€0.0547€587917€0.0449€8€463592€7€166029€0.0507€10
N€N0003€200106€DCP€11€21€120€23882€0€23882€0€6845€13962€2650€425€0€     -17€0.4252€14729€0.1923€19€9153€17€€€
N€N0003€200106€DCS€11€21€26€4646€100€4546€0€826€1934€886€900€0€      -1€0.0374€646€0.0154€28€3900€39€€€
N€N0003€200106€DDF€11€21€130€34631€104€34527€0€7804€18014€5335€3374€0€       0€0.0619€12217€0.0453€22€21810€22€500€0.01€12
N€N0003€200106€DFG€11€21€322€57038€0€57038€0€27051€22775€5339€1873€0€       0€0.0532€24654€0.036€18€28384€11€4000€0.0359€16
N€N0003€200106€DGX€11€21€5186€1005363€24875€978733€1100€406700€402320€118543€51365€905€       1€0.1035€454631€0.1058€20€354981€15€170221€0.1344€24
N€N0003€200106€DHY€11€21€69€15511€0€15511€0€3644€6401€3456€1868€142€      -1€0.0212€5804€0.0202€39€9407€33€300€0.01€39
N€N0003€200106€DJM€11€21€2€830€0€830€0€400€430€0€0€0€       0€0.1004€430€0.01€22€400€4€€€
N€N0003€200106€DLX€11€21€1601€281299€2671€278216€300€71701€103284€50590€50913€2028€       0€0.0344€101971€0.0331€40€151551€33€24994€0.05€48
N€N0003€200106€DNB€11€21€925€207241€100€207141€0€97114€83577€20796€5654€0€       0€0.0423€106479€0.0315€16€90982€12€9680€0.0268€21
N€N0003€200106€DNR€11€21€384€73429€101€72428€900€27435€35656€7906€2331€0€       0€0.0339€30182€0.0324€16€39174€15€3972€0.0371€19
N€N0003€200106€DNY€11€21€1965€380145€100€379832€0€216298€132793€19890€10851€0€       0€0.0381€156676€0.0298€13€193479€12€29677€0.0313€15
N€N0003€200106€DPRA€11€21€125€35911€0€35911€0€16642€14590€3109€1570€0€       0€0.1137€13725€0.0222€17€20986€15€1200€0.0733€17
N€N0003€200106€DSU€11€21€261€76624€280€76344€0€28055€28115€11749€8425€0€       0€0.0231€27021€0.0138€28€48009€27€1314€0.0163€34
N€N0003€200106€DT€11€21€2026€446775€1300€444775€700€253675€148003€35543€8254€0€       0€0.0166€202363€0.0184€12€202306€10€40806€0.0204€23
N€N0003€200106€DV€11€21€677€149804€900€148704€200€53027€64825€19880€10136€1036€       0€0.0764€65449€0.0428€22€72670€17€10785€0.0449€21
N€N0003€200106€EAS€11€21€709€158503€600€157500€0€70724€51100€22068€13608€0€       0€0.0322€57187€0.035€26€94069€17€6244€0.0266€40
N€N0003€200106€ED€11€21€4263€765164€1625€760880€1700€269390€288368€128899€73604€4061€       0€0.0326€315254€0.0402€32€364869€20€82457€0.0417€45
N€N0003€200106€EDE€11€21€259€54956€0€54856€100€22840€24852€6013€1251€100€       0€0.0399€26989€0.0521€15€25555€16€2412€0.0353€19
N€N0003€200106€EDEPRD€11€21€20€4917€0€4917€0€900€2790€1127€100€0€       0€0.0871€4417€0.1058€19€300€26€200€0.06€31
N€N0003€200106€EDL€11€21€93€24045€0€24045€0€4069€14154€4450€1372€0€       0€0.0953€4642€0.0249€30€17298€22€2105€0.0329€18
N€N0003€200106€EDO€11€21€700€150405€2000€148405€0€48400€64713€22279€12513€500€       1€0.0571€72066€0.0717€23€66460€15€9879€0.0961€31
N€N0003€200106€EDPRA€11€21€19€3320€0€3320€0€500€1950€400€470€0€      -6€0.8095€1820€0.7951€31€1200€27€300€0.4167€28
N€N0003€200106€EFL€11€21€24€4491€0€4491€0€1783€2333€275€100€0€       0€0.1064€3238€0.0392€14€1253€18€€€
N€N0003€200106€ELN€11€21€8381€1698154€28233€1658521€9800€591927€749792€247952€77850€800€       1€0.0376€896938€0.0543€20€574910€16€196473€0.0643€24
N€N0003€200106€ELNWSA€11€21€81€15924€0€15924€0€2530€8535€2849€2010€0€     -21€0.618€9810€0.2236€33€5214€14€900€0.1233€61
N€N0003€200106€ELNWSB€11€21€16€3710€0€3710€0€950€1510€800€450€0€     -47€1.0969€2100€0.5145€54€1410€12€200€0.79€20
N€N0003€200106€EMC€11€21€47650€9897171€68202€9782039€39300€3244345€4085888€1836849€651461€1701€       0€0.0249€5060991€0.0472€22€2257708€15€2502640€0.0544€30
N€N0003€200106€EMD€11€21€14€3634€0€3634€0€200€2219€700€515€0€       1€0.0971€1119€0.0607€21€2515€31€€€
N€N0003€200106€EPG€11€21€18292€3812438€35121€3757321€15900€1178720€1457845€694790€424248€17468€       0€0.0318€2175190€0.0565€26€985314€20€612717€0.0627€36
N€N0003€200106€EPGPR€11€21€4€589€0€589€0€0€0€100€489€0€      47€1.1746€489€0.234€91€100€142€€€
N€N0003€200106€EPGPRC€11€21€9€1800€0€1800€0€0€200€800€400€400€     -68€1.6667€500€0.298€99€900€253€400€1.05€42
N€N0003€200106€EPI€11€21€126€33956€200€33756€0€10726€15906€5444€1680€0€       0€0.0843€13803€0.0236€22€19153€19€800€0.0238€21
N€N0003€200106€EPL€11€21€326€76532€0€76232€300€31698€32628€8058€4148€0€       0€0.039€33547€0.0448€20€41085€15€1900€0.0384€30
N€N0003€200106€EPN€11€21€918€207403€200€207003€200€67977€98548€24636€15492€550€       0€0.0573€111443€0.0584€22€85320€22€10440€0.0449€39
N€N0003€200106€ESI€11€21€1347€263316€10079€252937€200€72537€103484€43898€32168€1050€       2€0.0683€113865€0.0789€32€107821€21€31451€0.1062€56
N€N0003€200106€ETA€11€21€30€6305€0€6305€0€800€3730€1385€390€0€      -2€0.0437€3350€0.023€24€2855€29€100€0.04€38
N€N0003€200106€EX€11€21€189€36259€200€36059€0€11720€18552€4551€1236€0€       0€0.0391€16262€0.0377€21€18701€14€1096€0.0338€35
N€N0003€200106€FC€11€21€39€7273€0€7273€0€2340€3733€1100€100€0€       0€0.0469€4128€0.0602€21€3045€11€100€0.02€14
N€N0003€200106€FCX€11€21€2268€477507€0€477007€500€224775€186859€45247€20626€0€       0€0.0182€200039€0.0292€19€251445€13€26023€0.0258€17
N€N0003€200106€FCXA€11€21€203€43156€440€42716€0€15376€22763€3384€1049€144€      -1€0.0382€23814€0.0421€19€17487€13€1415€0.0248€40
N€N0003€200106€FCXPRA€11€21€76€18015€0€18015€0€5645€7438€3682€1250€0€       0€0.0635€11571€0.0507€23€6444€22€€€
N€N0003€200106€FCXPRB€11€21€66€14738€0€14738€0€3662€8961€1765€350€0€       2€0.1379€5695€0.0608€21€9043€19€€€
N€N0003€200106€FCXPRC€11€21€18€4202€0€4202€0€0€2202€1700€300€0€       1€0.1058€1100€0.0409€35€3102€25€€€
N€N0003€200106€FCXPRD€11€21€32€7878€0€7878€0€754€6474€650€0€0€       0€0.0839€4508€0.0431€17€3370€19€€€
N€N0003€200106€FE€11€21€4339€852395€1200€849495€600€440011€305729€80238€22433€1684€       0€0.0259€297521€0.0334€15€484823€12€67751€0.0391€18
N€N0003€200106€FLR€11€21€2918€566592€10100€554892€1000€189895€244194€85222€36481€100€       3€0.062€286010€0.0751€20€184057€16€85825€0.1055€33
N€N0003€200106€FMC€11€21€1529€300685€6100€294585€0€119860€125954€33675€15096€0€       1€0.06€158560€0.0587€18€100317€17€35708€0.0695€31
N€N0003€200106€FO€11€21€2620€497417€300€496617€200€263838€184257€39171€9551€0€       0€0.0459€217394€0.0347€13€239890€11€39533€0.0497€21
N€N0003€200106€FOE€11€21€591€125134€506€124228€0€44257€57903€16669€5399€0€       0€0.0377€56458€0.0374€20€61161€16€6609€0.0451€19
N€N0003€200106€FOPRA€13€21€1€300€300€0€0€0€0€0€0€0€0€€€€€€€€€
N€N0003€200106€FOR€11€21€60€12184€0€12184€0€8401€3433€350€0€0€      -1€0.0292€7012€0.0142€10€5172€7€€€
N€N0003€200106€FPCPRA€11€21€74€22202€0€22202€0€9105€6257€2976€3864€0€       1€0.1081€10106€0.0562€28€12096€34€€€
N€N0003€200106€FRC€11€21€251€47308€200€47108€0€11567€14565€9783€10893€300€       1€0.0645€16764€0.0702€53€24944€38€5400€0.1115€77
N€N0003€200106€FSH€11€21€917€195393€1100€194093€200€78546€81804€23834€10409€0€       0€0.0717€92235€0.068€22€89125€14€12933€0.0638€25
N€N0003€200106€FTI€11€21€1980€362127€100€361927€100€145638€148580€54179€13530€100€       2€0.0225€195780€0.0546€19€152912€17€13335€0.0439€26
N€N0003€200106€FWJ€11€21€3€900€0€900€0€0€900€0€0€0€      -2€0.1167€300€0.1€18€600€20€€€
N€N0003€200106€GBE€11€21€23€4475€0€4475€0€1148€1629€814€884€0€       0€0.0771€2092€0.049€30€2083€24€300€0.05€49
N€N0003€200106€GCG€11€21€4€900€0€900€0€400€0€100€400€0€       0€-0.0011€700€0.0443€57€200€0€€€
N€N0003€200106€GDP€11€21€20€4550€0€4550€0€1660€2414€476€0€0€      -2€0.0799€1889€0.0255€18€2261€11€400€0.015€11
N€N0003€200106€GGT€11€21€114€24322€0€24322€0€9040€11256€3414€612€0€      -3€0.0914€9010€0.0369€16€14434€18€878€0.0613€14
N€N0003€200106€GGTPR€11€21€9€2302€0€2302€0€400€1602€300€0€0€      -1€0.2422€200€0.02€8€2102€16€€€
N€N0003€200106€GID€11€21€3€600€0€600€0€100€300€200€0€0€       2€0.0133€600€0.05€28€€€€€
N€N0003€200106€GK€11€21€110€17156€0€17156€0€1750€7742€4376€3062€226€      -2€0.0597€9137€0.0484€35€6619€55€1400€0.0421€52
N€N0003€200106€GLC€11€21€1397€310305€2700€306105€1100€88027€135891€55266€26942€1079€       0€0.0268€152886€0.0322€25€129221€21€25098€0.0498€30
N€N0003€200106€GLG€11€21€210€51489€0€51089€400€30501€17462€3225€301€0€       0€0.0265€13063€0.0168€11€37509€11€917€0.0151€7
N€N0003€200106€GLH€11€21€201€45051€0€45051€0€15566€21649€5843€1993€0€      -6€0.143€14705€0.0661€23€28551€15€1795€0.0261€21
N€N0003€200106€GLW€11€21€31632€6854173€13360€6798713€38700€3855589€2284747€586994€109468€615€       0€0.0136€3112503€0.0242€12€2413309€9€1311601€0.0273€18
N€N0003€200106€GPB€11€21€94€26231€0€26231€0€4691€15476€4364€1700€0€       1€0.0968€14042€0.057€21€11889€26€300€0.0167€53
N€N0003€200106€GPD€11€21€53€13433€0€13433€0€7588€5845€0€0€0€      -1€0.1593€7865€0.0481€10€5268€10€300€0.1€9
N€N0003€200106€GPEPRA€11€21€62€17189€0€17189€0€7510€8831€848€0€0€       1€0.1118€10268€0.0573€13€6921€10€€€
N€N0003€200106€GPEPRT€11€21€57€14799€400€14399€0€6781€6318€1100€200€0€       0€0.0711€6620€0.0196€18€7779€8€€€
N€N0003€200106€GPEPRU€11€21€49€12589€0€12589€0€4059€8135€395€0€0€       0€0.1653€7537€0.0333€12€5052€11€€€
N€N0003€200106€GPEPRV€11€21€32€7953€0€7953€0€1966€4966€1021€0€0€       5€0.1588€4145€0.0421€17€3508€19€300€0.0733€14
N€N0003€200106€GPF€11€21€20€5986€0€5986€0€1030€3571€925€460€0€      -2€0.1622€1540€0.0802€23€4446€26€€€
N€N0003€200106€GPU€11€21€1834€331935€1599€329136€500€179273€123240€20383€6540€200€       0€0.0418€164349€0.0434€12€136469€11€28818€0.0411€15
N€N0003€200106€GRA€11€21€217€50998€0€50998€0€21532€22718€6164€584€0€       0€0.0143€18821€0.0151€17€31361€14€816€0.0202€6
N€N0003€200106€GRB€11€21€163€27554€0€27554€0€5052€13374€6620€2508€0€       0€0.0295€12715€0.0593€26€13418€28€1421€0.0244€47
N€N0003€200106€GUPPRA€11€21€18€4554€0€4554€0€350€4204€0€0€0€       1€0.1284€2809€0.1062€13€1745€14€€€
N€N0003€200106€GUPPRB€11€21€21€5484€0€5484€0€550€4584€350€0€0€       4€0.1667€3784€0.0723€15€1700€11€€€
N€N0003€200106€HAR€11€21€769€148497€1800€146597€100€34515€73133€27304€11745€0€       2€0.0552€68766€0.0854€26€67117€23€10814€0.1312€22
N€N0003€200106€HAS€11€21€2142€438982€100€437882€1000€174135€192970€53185€18592€0€       0€0.0301€246768€0.0269€17€172621€16€19493€0.0313€24
N€N0003€200106€HCN€11€21€804€177141€0€175441€800€59204€72907€26587€16813€730€      -1€0.034€81716€0.0317€27€85715€20€8810€0.0327€45
N€N0003€200106€HCNPRB€11€21€38€10125€0€10125€0€2217€4841€2284€783€0€       3€0.1173€6825€0.0796€25€2900€37€400€0.05€14
N€N0003€200106€HGR€11€21€31€7668€0€7668€0€2203€2650€1915€900€0€       0€0.0502€2915€0.0361€44€4653€19€100€0.02€8
N€N0003€200106€HIL€11€21€58€12938€0€12938€0€3997€7419€1222€300€0€       0€0.0221€7891€0.0332€15€4547€15€500€0.026€18
N€N0003€200106€HIW€11€21€853€201813€138€201675€0€124564€67892€7219€1700€300€       0€0.0302€92008€0.0319€10€101169€9€8498€0.0282€18
N€N0003€200106€HIWPRB€11€21€48€13382€0€13382€0€3770€8212€1000€400€0€       2€0.1308€9665€0.0841€16€3717€18€€€
N€N0003€200106€HIWPRD€11€21€51€13883€0€13883€0€3676€7969€2238€0€0€       0€0.1521€8843€0.0724€17€4640€16€400€0.055€9
N€N0003€200106€HMA€11€21€1305€285451€0€284551€900€120298€111741€35184€17878€350€       0€0.0185€153353€0.0329€22€115598€15€16500€0.0365€33
N€N0003€200106€HMC€11€21€327€61763€0€61763€0€23757€28584€7033€2389€0€       0€0.1751€29459€0.1755€21€28592€13€3712€0.0987€30
N€N0003€200106€HMT€11€21€1019€248392€300€245792€2300€101541€107186€25592€12063€1710€       0€0.0155€123922€0.0207€20€115408€14€8762€0.018€59
N€N0003€200106€HMTPRA€11€21€40€10915€0€10915€0€2225€7190€1100€400€0€       0€0.1225€4130€0.0509€12€6285€19€500€0.086€42
N€N0003€200106€HMTPRB€11€21€45€12320€0€12320€0€4705€5465€1700€450€0€       0€0.0985€7575€0.0284€16€4545€23€200€0.1€18
N€N0003€200106€HMTPRC€11€21€58€16685€0€16685€0€4440€10635€1280€330€0€       0€0.0897€7385€0.018€21€8900€13€400€0.05€7
N€N0003€200106€HON€11€21€19634€4537992€36160€4486970€11800€2162439€1652916€496192€184563€2660€       0€0.0359€2222825€0.0602€16€1376974€12€898971€0.0831€26
N€N0003€200106€HOV€11€21€497€107289€200€106689€300€46229€49915€7595€3250€0€       0€0.0621€47328€0.0482€16€52446€13€7215€0.0522€15
N€N0003€200106€HZO€11€21€20€4175€0€4175€0€1240€2184€200€551€0€      -1€0.039€1809€0.0585€30€2366€22€€€
N€N0003€200106€ICS€11€21€7€1506€0€1506€0€0€1506€0€0€0€       0€0.0675€770€0.0113€10€736€16€€€
N€N0003€200106€IDG€11€21€11€2461€0€2461€0€319€1494€648€0€0€       3€0.1105€1813€0.0317€11€€€648€0.1€38
N€N0003€200106€IEU€11€21€16€4255€0€4255€0€255€3200€400€400€0€      -4€0.2366€1555€0.0971€15€2700€36€€€
N€N0003€200106€IFX€11€21€738€155517€1600€152017€400€57220€65935€19363€9549€350€      -2€0.1008€54177€0.0564€21€66889€15€31351€0.0759€27
N€N0003€200106€IGL€11€21€884€187910€400€187210€300€46812€77036€38157€24596€909€       0€0.0177€77292€0.0227€36€101416€23€8802€0.0292€38
N€N0003€200106€IML€11€21€24€6306€0€6306€0€857€3090€1110€945€304€      -1€0.1118€4214€0.0282€50€1335€44€757€0.0617€87
N€N0003€200106€IQM€11€21€27€9088€0€9088€0€3112€3224€1533€1219€0€       0€0.0412€2795€0.0247€19€6163€27€130€0.02€15
N€N0003€200106€IR€11€21€3775€759241€2050€754499€2100€278603€313443€122486€41102€1380€       0€0.0277€384981€0.0303€20€301091€17€70527€0.0412€26
N€N0003€200106€ISP€11€21€117€20875€0€20875€0€5474€11352€2541€1508€0€       0€0.0493€11155€0.0345€20€8420€19€1300€0.0331€33
N€N0003€200106€ITG€11€21€1108€235115€3900€231115€100€71405€116744€30416€12650€0€       0€0.0835€110607€0.0695€22€102156€15€18452€0.1072€32
N€N0003€200106€ITN€11€21€371€78922€429€78493€0€38979€31129€6358€2027€0€       0€0.0448€27960€0.0329€13€45177€12€5356€0.037€20
N€N0003€200106€ITT€11€21€1622€286838€300€285930€500€109564€148979€23443€4444€0€       0€0.0516€134635€0.0453€15€131715€12€20080€0.0523€18
N€N0003€200106€ITX€11€21€71€16878€200€16678€0€3675€9192€2450€1361€0€       0€0.0615€5862€0.039€25€7799€16€3017€0.0462€32
N€N0003€200106€ITXPR€11€21€8€1738€0€1738€0€199€729€450€360€0€     -23€0.3264€888€0.2684€41€700€45€150€0.5€10
N€N0003€200106€IVC€11€21€574€109326€0€109042€0€56256€39484€9774€3528€0€       1€0.0595€52292€0.0707€14€49763€14€6987€0.0589€23
N€N0003€200106€JBL€11€21€10652€2021224€38650€1976374€5600€828342€716374€280748€152377€4133€       0€0.0406€978092€0.0497€20€664172€15€339710€0.0735€35
N€N0003€200106€JCP€11€21€4785€923275€3200€917192€2600€476919€354391€69553€17871€1058€       0€0.027€417906€0.0348€15€412601€11€89285€0.0462€17
N€N0003€200106€JEM€11€21€14€3691€0€3691€0€2595€846€250€0€0€       1€0.0709€650€0.0162€17€3041€8€€€
N€N0003€200106€JOE€11€21€560€109132€100€108932€100€37049€49203€13005€9415€360€       0€0.0545€30081€0.028€28€72812€20€6139€0.0361€55
N€N0003€200106€JYPPRZ€11€21€33€8294€0€8294€0€3987€2853€1454€0€0€       0€0.0813€2801€0.0214€12€5093€17€400€0.055€13
N€N0003€200106€KBH€11€21€2003€396444€1900€393544€700€235578€135787€19031€3612€236€       0€0.052€158530€0.0436€12€201018€9€34696€0.062€18
N€N0003€200106€KBHPRG€12€23€1€4000€3800€200€0€0€200€0€0€0€      -5€0.25€€€€200€18€€€
N€N0003€200106€KBHPRI€11€21€10€1870€0€1870€0€670€1200€0€0€0€      -4€0.1165€600€0.0233€10€1270€11€€€
N€N0003€200106€KEG€11€21€1018€219955€1787€218168€0€79979€96492€29441€11905€351€       0€0.0309€96876€0.0251€21€100725€18€20567€0.0376€30
N€N0003€200106€KEI€11€21€1527€304821€3399€301422€0€107761€129096€42537€22028€0€       0€0.0795€140598€0.0738€21€117736€18€43088€0.0839€31
N€N0003€200106€KG€11€21€5215€1031366€8400€1021866€1100€454412€432306€107139€28667€442€       0€0.0377€522352€0.0555€16€392279€13€108335€0.069€18
N€N0003€200106€KLU€11€21€160€33466€0€33466€0€12755€16840€3321€550€0€       1€0.052€13916€0.0403€14€18540€14€1010€0.01€16
N€N0003€200106€KMB€11€21€10045€2164410€4955€2150133€7000€686439€883329€387441€193491€6433€       0€0.0322€1162179€0.0422€24€704899€21€290055€0.0583€29
N€N0003€200106€KOR€11€21€26€5566€0€5566€0€1145€2746€600€1075€0€      -2€0.0425€3656€0.0338€26€1910€33€€€
N€N0003€200106€KPA€11€21€290€63086€0€62586€500€27584€24830€7518€3154€0€       0€0.0301€18392€0.0203€18€41710€16€2984€0.0191€24
N€N0003€200106€KPAPRA€11€21€38€8841€0€8841€0€2025€3910€800€2106€0€       0€0.2095€2760€0.056€50€5456€28€625€0.1156€16
N€N0003€200106€KRJ€11€21€4€1150€0€1150€0€300€850€0€0€0€       2€0.113€600€0.0833€18€550€14€€€
N€N0003€200106€KTB€11€21€24€6825€0€6825€0€1200€3975€850€800€0€       3€0.1024€4475€0.0597€29€2350€20€€€
N€N0003€200106€KTP€11€21€113€29875€0€29875€0€11654€14076€3720€425€0€       0€0.1111€13092€0.0381€17€15603€15€1180€0.0632€17
N€N0003€200106€KYO€11€21€488€90772€0€90472€300€44067€39611€5763€1331€0€      -5€0.3294€39291€0.1462€13€44089€12€7392€0.1991€15
N€N0003€200106€LBI€11€21€9€1540€0€1540€0€200€1090€250€0€0€      -4€0.0645€713€0.121€22€827€15€€€
N€N0003€200106€LDP€11€21€71€16330€0€16330€0€4713€7895€1543€2179€0€      -1€0.0814€6311€0.0355€21€9254€26€765€0.0413€41
N€N0003€200106€LMM€11€21€5€1340€0€1340€0€400€450€490€0€0€       0€0.0192€210€0.0257€18€1130€27€€€
N€N0003€200106€LMS€11€21€40€8949€0€8949€0€1605€5269€1025€1050€0€      -1€0.0789€5069€0.0544€32€3770€16€110€0.02€12
N€N0003€200106€LMT€11€21€7427€1539221€2321€1534598€1500€813099€498258€155630€68871€240€       0€0.038€652816€0.0387€18€731392€12€151890€0.0449€19
N€N0003€200106€LNT€11€21€1104€241025€0€240325€700€74986€120488€33823€11428€300€       0€0.0345€72301€0.0345€18€155939€17€12785€0.0238€23
N€N0003€200106€LRY€11€21€728€157798€0€156898€900€63418€75594€14717€4069€0€       0€0.0361€80555€0.0294€15€73460€14€3783€0.0312€21
N€N0003€200106€LRYPRA€11€21€45€11239€0€11239€0€5040€5074€675€450€0€      -3€0.1347€2244€0.0408€19€8795€14€200€0.05€24
N€N0003€200106€LSHPRA€11€21€38€8884€0€8884€0€1777€4625€1100€1382€0€       0€0.1001€4602€0.0332€34€4282€29€€€
N€N0003€200106€MAG€11€21€205€40664€100€40564€0€11519€19271€7942€1832€0€       0€0.034€18625€0.0561€21€21026€17€913€0.0264€46
N€N0003€200106€MAR€11€21€4566€852217€3439€847777€500€327186€338792€115285€64394€2620€       0€0.0336€371175€0.0377€23€376069€17€101033€0.0395€25
N€N0003€200106€MAT€11€21€6271€1269034€600€1265555€2400€804303€370087€74517€19048€0€       0€0.0286€536799€0.0232€12€603833€9€127323€0.0268€17
N€N0003€200106€MCC€11€21€92€15602€100€15502€0€3391€5930€2640€3441€100€       1€0.1551€10231€0.1351€48€3496€48€1775€0.1344€50
N€N0003€200106€MCO€11€21€2564€482050€300€481050€0€205260€224512€38524€12754€0€       0€0.0344€232157€0.0449€16€218413€12€30480€0.0506€21
N€N0003€200106€MCT€11€21€93€18905€300€18605€0€6170€8860€2500€1175€0€      -6€0.2168€10070€0.0931€22€7035€21€1500€0.0993€18
N€N0003€200106€MDG€11€21€222€44774€100€44574€100€18941€16881€6899€1953€0€      -2€0.0379€17024€0.0225€15€23758€15€3892€0.029€43
N€N0003€200106€MEE€11€21€1036€209709€1746€206463€1500€66383€99319€28763€13498€0€       0€0.0405€111328€0.0591€22€81354€18€15281€0.0622€27
N€N0003€200106€MEH€11€21€251€48319€0€48319€0€14334€23793€6423€3769€0€       2€0.0701€17902€0.0429€26€24568€19€5849€0.046€31
N€N0003€200106€MER€11€21€30073€6760165€79577€6655420€22100€3730194€2256343€498914€187021€5048€       0€0.0551€3050308€0.0476€13€1925818€9€1701394€0.066€19
N€N0003€200106€MERPRA€11€21€78€19057€0€19057€0€7062€8478€2817€700€0€       3€0.101€10546€0.0317€22€8411€15€100€0.02€24
N€N0003€200106€MERPRB€11€21€79€20512€0€20512€0€6773€11414€1925€400€0€       1€0.0985€12232€0.0367€16€7980€17€300€0.01€11
N€N0003€200106€MERPRC€11€21€75€18441€0€18441€0€4795€11057€1582€1007€0€       4€0.1103€11160€0.0386€24€7181€16€100€0.07€17
N€N0003€200106€MERPRD€11€21€180€50455€0€50455€0€18698€26565€3992€1200€0€       0€0.0677€28689€0.0208€17€21266€15€500€0.026€20
N€N0003€200106€MERPRE€11€21€91€24866€0€24866€0€7807€13364€1525€2170€0€       2€0.0673€17369€0.0194€23€7497€26€€€
N€N0003€200106€MERPRF€11€21€254€64465€0€64465€0€22971€30739€8030€2725€0€       0€0.0566€35833€0.0187€19€27832€19€800€0.025€12
N€N0003€200106€MFW€11€21€32€7466€0€7466€0€2841€4113€512€0€0€      -2€0.0181€2029€0.0623€12€5437€14€€€
N€N0003€200106€MGF€11€21€70€16120€0€16120€0€6543€8899€500€178€0€       0€0.0166€3887€0.0103€17€12233€12€€€
N€N0003€200106€MHN€11€21€44€10018€0€10018€0€5361€3632€1025€0€0€       0€0.0315€3926€0.014€17€5792€10€300€0.0133€16
N€N0003€200106€MIM€11€21€7€1347€0€1347€0€275€672€200€200€0€      -8€0.1074€140€0.13€24€1207€26€€€
N€N0003€200106€MLI€11€21€373€69963€100€69763€100€19462€27043€13949€9309€100€       0€0.0273€31833€0.0706€30€34350€30€3680€0.0433€50
N€N0003€200106€MLM€11€21€956€204799€300€204099€400€61064€95095€32619€15821€300€       0€0.0477€80241€0.0608€24€108917€20€15341€0.0475€23
N€N0003€200106€MLS€11€21€869€206055€0€205855€200€74780€98864€22395€10016€0€       0€0.065€79217€0.0297€20€113979€14€12859€0.0332€28
N€N0003€200106€MMA€11€21€164€41547€0€41347€200€6120€18982€11510€4935€0€       0€0.0759€18868€0.0622€31€22479€28€200€0.01€42
N€N0003€200106€MMC€11€21€7854€1504024€4800€1496324€2400€848935€524310€93936€31240€303€       0€0.0776€737970€0.0635€14€537240€9€223514€0.0759€16
N€N0003€200106€MMR€11€21€143€24452€0€24452€0€4408€14201€3524€2319€0€      -1€0.0584€10071€0.0532€24€13468€26€913€0.0605€21
N€N0003€200106€MMS€11€21€1627€318955€1900€315905€900€106853€137298€48809€23545€300€       1€0.0495€180240€0.06€24€113201€20€23364€0.0565€33
N€N0003€200106€MOT€11€21€15110€3328170€5844€3311576€8100€1598352€1234943€389062€96669€650€       0€0.0107€1631510€0.0236€17€1229766€10€458400€0.0247€21
N€N0003€200106€MOTPRA€11€21€193€54690€0€54690€0€19492€24106€8167€2925€0€       1€0.0898€30541€0.0284€23€23749€17€400€0.025€16
N€N0003€200106€MPPRD€11€21€9€1975€0€1975€0€300€775€900€0€0€       0€0.2923€1600€0.04€28€375€14€€€
N€N0003€200106€MRX€11€21€1621€320344€8637€310782€200€63174€159322€56740€29946€1800€       1€0.0942€133022€0.0768€30€134927€24€43033€0.1141€30
N€N0003€200106€MSF€11€21€42€9509€0€9509€0€2112€6131€766€200€300€      -2€0.0626€3761€0.0423€15€5748€16€€€
N€N0003€200106€MTN€11€21€145€22165€0€21965€200€4845€12736€2407€2177€0€       0€0.0896€11127€0.0907€28€10716€22€322€0.1€10
N€N0003€200106€MTTPRX€11€21€23€5969€0€5969€0€850€4879€240€0€0€       6€0.1935€3074€0.1643€18€2895€13€€€
N€N0003€200106€MTX€11€21€764€141623€0€140313€0€59229€61833€11244€8007€0€       0€0.062€55775€0.0467€18€74506€17€10032€0.0553€28
N€N0003€200106€MUC€11€21€37€9273€0€9273€0€3762€3999€400€1112€0€      -1€0.0279€5611€0.0146€17€3262€42€400€0.01€6
N€N0003€200106€MUJ€11€21€36€8266€0€8266€0€3118€4948€200€0€0€       0€0.0292€4991€0.0126€15€3275€10€€€
N€N0003€200106€MUO€11€21€47€10408€0€10408€0€2493€6074€1116€725€0€       0€0.0519€3863€0.0223€24€6345€13€200€0.06€140
N€N0003€200106€MYI€11€21€107€32319€0€32319€0€11642€14632€3472€2373€200€       0€0.0318€11728€0.0141€29€20291€17€300€0.01€18
N€N0003€200106€NAV€11€21€1165€207641€200€206594€300€100039€87977€14008€4870€0€       1€0.0271€94076€0.027€14€101550€12€11268€0.0438€17
N€N0003€200106€NC€11€21€422€70933€0€70933€0€24172€40012€5599€1150€0€       0€0.1476€27278€0.0952€18€37888€11€5767€0.0974€18
N€N0003€200106€NCI€11€21€165€36300€0€36300€0€12555€13153€5331€4291€970€       1€0.0448€13065€0.0375€23€21642€25€1593€0.0567€119
N€N0003€200106€NDE€11€21€1140€252703€3500€248903€200€62581€105339€52043€27991€1149€       1€0.0427€103869€0.041€28€124648€23€20586€0.0692€57
N€N0003€200106€NEU€11€21€2069€434722€5500€427622€500€148279€190275€58105€31463€0€       2€0.0733€193603€0.0723€25€172307€15€62212€0.0672€31
N€N0003€200106€NMA€11€21€57€13504€0€13504€0€2868€6470€2799€1367€0€       0€0.033€1804€0.0319€18€11350€29€350€0.01€41
N€N0003€200106€NMI€11€21€23€5888€0€5888€0€2227€2881€580€200€0€      -2€0.0667€4313€0.0145€18€1575€13€€€
N€N0003€200106€NMK€11€21€1636€308307€100€307707€400€114811€128594€41825€22677€200€       0€0.0191€97748€0.016€23€190283€18€20076€0.0143€28
N€N0003€200106€NMKPRK€11€21€1€100€0€100€0€100€0€0€0€0€       5€0.75€€€€100€9€€€
N€N0003€200106€NMT€11€21€21€5072€0€5072€0€507€4032€133€400€0€      -2€0.0602€2876€0.023€19€2196€23€€€
N€N0003€200106€NPC€11€21€12€2425€0€2425€0€798€1627€0€0€0€      -1€0.0694€927€0.0578€14€1498€14€€€
N€N0003€200106€NPV€11€21€36€8346€0€8346€0€2790€3706€1850€0€0€       3€0.0865€4223€0.0241€20€3823€17€300€0.01€13
N€N0003€200106€NQF€11€21€33€8197€0€8197€0€3319€3533€1145€0€200€       0€0.0506€4778€0.0118€32€3419€10€€€
N€N0003€200106€NQS€11€21€50€13224€0€13224€0€3268€6571€3385€0€0€       0€0.0344€3655€0.0223€23€9235€17€334€0.04€32
N€N0003€200106€NSH€11€21€31€6351€0€6351€0€1216€4108€927€100€0€      -1€0.0711€3151€0.0624€19€3200€18€€€
N€N0003€200106€NSI€11€21€989€206016€700€204916€400€81854€88750€26478€8134€100€       0€0.053€78530€0.0423€19€115118€14€11668€0.0455€29
N€N0003€200106€NTC€11€21€29€7856€0€7856€0€2683€4673€500€0€0€      -2€0.0692€5213€0.0129€16€2643€12€€€
N€N0003€200106€NUT€11€21€24€5170€0€5170€0€713€3916€541€0€0€      -1€0.0767€3509€0.0365€19€1548€11€113€0.05€9
N€N0003€200106€NVN€11€21€60€17595€0€17595€0€3541€10820€1951€1283€0€       0€0.0528€6675€0.015€21€10105€23€815€0.0316€14
N€N0003€200106€OAT€11€21€3034€570965€4200€565465€1300€270878€204505€62275€28792€315€       0€0.0499€293935€0.0578€17€213478€13€59352€0.0588€21
N€N0003€200106€OCN€11€21€196€44482€122€44160€200€11948€15964€8555€7893€0€       1€0.0487€16847€0.0378€38€24518€33€2995€0.0362€41
N€N0003€200106€OECPRT€11€21€37€8598€0€8598€0€5028€2770€600€200€0€       8€0.3758€5885€0.0151€16€2713€9€€€
N€N0003€200106€OFC€11€21€228€44336€0€44336€0€7456€16953€9168€10759€0€      -1€0.0313€17630€0.0546€51€22481€36€4225€0.0178€24
N€N0003€200106€OFCPRB€11€21€24€4268€0€4268€0€240€1775€1155€700€398€      -1€0.0926€2050€0.1197€37€2118€122€100€0.05€65
N€N0003€200106€OFCPRE€11€21€22€4805€0€4805€0€700€1725€1130€1150€100€       0€0.1068€2310€0.0747€57€2195€46€300€0.03€11
N€N0003€200106€OH€11€21€149€34617€140€34377€100€9919€17741€4045€2772€0€       0€0.0328€14906€0.0318€32€19248€18€323€0.0286€89
N€N0003€200106€OI€11€21€353€74739€0€74739€0€33123€30579€7601€3436€0€       0€0.0219€24529€0.0238€16€47287€16€2923€0.0227€21
N€N0003€200106€OIPRA€11€21€62€16193€100€16093€0€2270€6602€2439€4282€500€       1€0.1128€7247€0.0299€73€7547€45€1299€0.0585€54
N€N0003€200106€OMG€11€21€965€189051€1000€186551€0€54715€91492€27624€12720€0€       1€0.0607€70167€0.0623€23€97105€18€19279€0.0554€29
N€N0003€200106€OMI€11€21€565€107087€500€106087€300€26099€48534€18229€13525€0€       0€0.0552€41150€0.0578€29€56474€24€8763€0.0579€42
N€N0003€200106€ONE€11€21€10768€2557497€1921€2549239€4900€1590050€761410€159619€42657€403€       0€0.0277€1132248€0.0266€12€1085876€9€336015€0.0315€15
N€N0003€200106€ONEPRB€11€21€3€400€0€400€0€0€200€0€200€0€      55€2.3875€200€0.55€91€200€18€€€
N€N0003€200106€ONEPRC€11€21€1€100€0€100€0€0€0€0€100€0€1.5€2€100€1€83€€€€€
N€N0003€200106€ONEPRT€11€21€109€29362€0€29362€0€13993€11061€3728€580€0€       0€0.0822€11554€0.0415€15€16908€15€900€0.0289€13
N€N0003€200106€ONEPRU€11€21€60€17827€0€17827€0€6895€7268€3264€400€0€       0€0.1008€7272€0.0373€19€10355€15€200€0.05€22
N€N0003€200106€ONEPRV€11€21€93€23722€0€23722€0€10722€12220€400€380€0€       2€0.0884€13172€0.031€12€9650€13€900€0.0311€19
N€N0003€200106€OSI€11€21€1058€248089€2075€245714€300€63505€109163€44599€28147€600€       0€0.0554€102160€0.0585€31€123370€21€20484€0.0677€33
N€N0003€200106€OTL€11€21€200€33973€0€33973€0€8320€18238€7115€300€0€       2€0.1038€11952€0.0549€18€17721€15€4300€0.2072€34
N€N0003€200106€OWC€11€21€426€97564€400€97164€0€51956€36885€6365€1958€0€       0€0.0286€25059€0.0166€13€64887€11€7218€0.0214€26
N€N0003€200106€PAG€11€21€182€38597€0€38597€0€14405€16254€5316€2622€0€       0€0.0262€13760€0.0177€24€24337€16€500€0.016€16
N€N0003€200106€PAR€11€21€38€8752€0€8752€0€2836€4398€1118€400€0€       0€0.0644€3723€0.049€17€4629€33€400€0.0425€17
N€N0003€200106€PAS€11€21€469€116739€596€115743€0€32186€50278€20265€12755€259€       0€0.0361€55329€0.0333€31€57869€26€2545€0.0876€29
N€N0003€200106€PCEPR€11€21€28€7237€0€7237€0€1438€3578€1621€600€0€       0€0.1203€2378€0.0377€23€4459€27€400€0.0825€15
N€N0003€200106€PCEPRA€11€21€67€19235€0€19235€0€4495€7684€3786€3070€200€       0€0.1339€6197€0.0854€34€12438€40€600€0.0767€103
N€N0003€200106€PCL€11€21€870€207041€0€205966€800€82550€84819€26006€12302€1289€       0€0.0518€79822€0.0285€32€112427€17€14517€0.0474€59
N€N0003€200106€PCT€11€21€41€10980€0€10980€0€1755€5233€2274€1718€0€      -2€0.1086€4575€0.0492€32€6405€31€€€
N€N0003€200106€PDE€11€21€1349€311176€2700€307576€900€153759€109523€33382€11412€400€       0€0.0241€146622€0.0338€16€130255€11€31599€0.0309€23
N€N0003€200106€PECPRX€11€21€31€9116€0€9116€0€3045€5421€650€0€0€       8€0.253€6766€0.2323€14€2250€16€100€0.2€13
N€N0003€200106€PEP€11€21€17054€3961781€3610€3935924€19800€1877493€1559852€407217€111162€0€       0€0.0169€2074843€0.0276€16€1458336€12€422545€0.0302€20
N€N0003€200106€PER€11€21€681€147898€1311€146587€0€54071€50664€20863€20325€664€       0€0.0494€60502€0.0331€30€70966€23€15119€0.0414€37
N€N0003€200106€PFP€11€21€20€4346€0€4346€0€611€3014€223€498€0€       5€0.2408€2737€0.1043€23€1609€22€€€
N€N0003€200106€PFPPR€11€21€8€1998€0€1998€0€456€1542€0€0€0€       2€0.3709€1060€0.1181€14€938€3€€€
N€N0003€200106€PG€11€21€14631€3286058€7562€3265296€10900€1994720€980155€234132€65839€1200€       0€0.0383€1509114€0.0338€12€1185301€9€581781€0.0453€20
N€N0003€200106€PGF€11€21€13€3127€0€3127€0€400€2227€500€0€0€      -9€0.1322€200€0.1€37€2927€16€€€
N€N0003€200106€PGN€11€21€4449€803192€1050€800855€1100€395029€308406€70143€26814€1563€       0€0.0442€356946€0.0318€16€362495€12€82514€0.0394€21
N€N0003€200106€PHA€11€21€11090€2625800€5054€2615898€2300€1194257€945635€349082€129224€0€       0€0.0269€1208326€0.0303€19€1030728€13€379144€0.0395€26
N€N0003€200106€PII€11€21€547€102532€100€102432€0€41394€47177€10024€3837€0€       1€0.0656€43817€0.0617€19€50009€14€8606€0.067€21
N€N0003€200106€PIK€11€21€20€3575€0€3575€0€200€1904€349€1122€0€      -2€0.048€2316€0.061€22€1092€112€167€0.02€177
N€N0003€200106€PIM€11€21€174€49075€0€49075€0€24946€18678€4419€1032€0€       0€0.0231€15250€0.0101€15€31123€13€2702€0.0172€21
N€N0003€200106€PIO€11€21€112€20834€0€20834€0€4049€12496€3547€742€0€      -4€0.1999€15381€0.3664€19€5353€24€100€0.03€57
N€N0003€200106€PKE€11€21€670€119484€100€119384€0€37310€62636€13909€5529€0€       0€0.0536€51032€0.0518€20€59311€16€9041€0.0835€42
N€N0003€200106€PKG€11€21€595€146975€435€146340€200€34426€54415€28787€26474€2438€       1€0.0363€71171€0.0341€45€66334€34€9035€0.0866€51
N€N0003€200106€PKX€11€21€711€142771€0€142226€200€41939€72365€20160€7962€0€       1€0.0222€67854€0.0374€22€71279€18€3293€0.0316€36
N€N0003€200106€PLP€11€21€84€20783€0€20783€0€6623€11908€1872€380€0€       0€0.0736€9234€0.0405€19€9569€14€1980€0.048€16
N€N0003€200106€PNP€11€21€360€77419€0€77419€0€21873€46990€6414€2142€0€       0€0.0584€39478€0.0455€17€35119€13€2822€0.0368€27
N€N0003€200106€PNW€11€21€2281€470049€2100€467443€400€193183€212965€42984€18311€400€       0€0.0449€244484€0.0442€17€188356€15€35003€0.0463€22
N€N0003€200106€PPD€11€21€1023€203099€1025€199574€2500€50324€81817€41329€28104€500€       0€0.0512€76073€0.06€40€105458€21€20543€0.056€41
N€N0003€200106€PPP€11€21€1071€218104€600€217504€0€90001€84657€30380€12466€0€       1€0.0533€86443€0.0541€21€107964€17€23097€0.0719€22
N€N0003€200106€PPPPRQ€11€21€8€1220€0€1220€0€0€340€750€130€0€    -100€1.2508€400€0.461€62€820€29€€€
N€N0003€200106€PTV€11€21€2082€421537€524€420713€300€130636€203286€64391€22600€100€       0€0.0255€219254€0.0309€20€179782€19€21977€0.0307€20
N€N0003€200106€PX€11€21€4735€968093€4342€962551€400€391045€431840€105022€34611€433€       0€0.0323€517464€0.0384€17€360536€15€84951€0.0418€20
N€N0003€200106€RCL€11€21€888€192609€1279€191130€200€73260€79569€27645€10856€0€       0€0.0309€71595€0.0366€23€106888€15€12847€0.0291€21
N€N0003€200106€RCN€11€21€119€26769€0€26769€0€7428€11535€3395€4411€0€      -6€0.13€9038€0.0576€40€14081€20€3650€0.0453€33
N€N0003€200106€RG€11€21€357€70949€0€70949€0€19784€28138€8150€13587€1290€       0€0.0507€16009€0.0463€71€42135€29€12805€0.0254€64
N€N0003€200106€RHB€11€21€1366€256151€6400€249751€0€54702€103946€53430€37673€0€       0€0.1091€117310€0.0835€36€102790€26€29651€0.1028€46
N€N0003€200106€RHD€11€21€830€166190€100€165990€0€55871€81814€20848€7457€0€       1€0.0431€76146€0.0406€19€82195€17€7649€0.0406€25
N€N0003€200106€RHI€11€21€2239€438400€1243€436357€800€200230€165695€49195€21787€250€       0€0.0378€212536€0.0402€18€187120€13€37501€0.0493€32
N€N0003€200106€RJF€11€21€865€179628€1970€177558€100€59606€69661€26503€21888€0€       1€0.0605€84064€0.0491€26€80046€18€13548€0.063€43
N€N0003€200106€RL€11€21€883€188977€400€187027€1200€51875€75446€38251€22355€300€       1€0.0584€80017€0.0683€29€84714€25€23496€0.0661€31
N€N0003€200106€RMG€11€21€406€76807€0€76807€0€31060€36138€8459€1150€0€       0€0.0786€40447€0.0656€14€32940€14€3420€0.0411€29
N€N0003€200106€RML€11€21€302€65767€851€64916€0€15388€24785€9913€14430€400€       0€0.0323€25040€0.0345€54€36262€32€3614€0.036€68
N€N0003€200106€RNS€11€21€11€3105€0€3105€0€1535€1370€200€0€0€      -5€0.1214€2105€0.1211€11€1000€14€€€
N€N0003€200106€ROP€11€21€637€119636€1400€118236€0€31245€46507€21949€17566€969€       2€0.0654€52276€0.0767€37€54041€26€11919€0.076€60
N€N0003€200106€ROS€11€21€42€8810€0€8810€0€5900€2210€500€200€0€      -1€0.0264€4960€0.0191€11€3850€15€€€
N€N0003€200106€ROV€11€21€1256€280099€300€278999€800€121057€99650€39115€18932€1045€       1€0.0251€165982€0.0469€20€98628€16€15189€0.0513€69
N€N0003€200106€RS€11€21€364€74715€300€74415€0€17112€35972€16048€5283€0€       0€0.0486€37850€0.0445€24€31898€21€4667€0.0411€26
N€N0003€200106€RSC€11€21€163€35415€0€35415€0€8219€17055€6911€3230€0€      -1€0.1382€19992€0.0862€25€13593€24€1830€0.1025€40
N€N0003€200106€RTP€11€21€224€45752€200€45552€0€14891€21771€6917€1973€0€       0€0.4891€17391€0.1724€22€23561€14€4600€0.5028€31
N€N0003€200106€RWT€11€21€272€52267€0€52267€0€18388€19210€10069€4600€0€      -1€0.0721€25393€0.0563€23€24774€18€2100€0.0438€14
N€N0003€200106€RWTPRB€11€21€9€1638€0€1638€0€100€1288€100€150€0€      -8€0.0114€1239€0.599€39€399€13€€€
N€N0003€200106€RYN€11€21€672€128546€700€127446€0€34511€58160€23802€10373€600€      -1€0.0552€52145€0.0532€29€64697€21€10604€0.0443€37
N€N0003€200106€RZT€11€21€212€44179€0€44079€100€16442€21497€5031€1209€0€       1€0.0511€18311€0.046€16€23659€13€2209€0.09€34
N€N0003€200106€SACPR€11€21€3€700€0€700€0€0€0€200€500€0€      17€1.1014€€€€700€86€€€
N€N0003€200106€SACPRT€11€21€11€2493€0€2493€0€320€1463€300€410€0€       0€0.2151€413€0.1299€17€1980€41€100€0.1€16
N€N0003€200106€SAIPRW€11€21€70€17471€0€17471€0€9608€6338€1125€400€0€       1€0.0907€5971€0.0183€14€11400€15€100€0.03€7
N€N0003€200106€SBG€11€21€92€23981€0€23981€0€9947€6542€3638€3554€300€       0€0.0256€12268€0.0161€38€11713€39€€€
N€N0003€200106€SC€11€21€804€171378€1200€169328€600€35189€66402€34353€32589€1295€       0€0.0425€67572€0.0423€115€82345€33€20011€0.0432€74
N€N0003€200106€SCG€11€21€813€174445€1450€172995€0€36451€63067€41038€31401€1038€       0€0.0434€73380€0.0352€39€85091€31€14524€0.0479€57
N€N0003€200106€SCL€11€21€28€4080€0€4080€0€797€977€1156€1007€143€       1€0.1141€1361€0.0648€33€2719€95€€€
N€N0003€200106€SCX€11€21€19€5156€0€5156€0€1378€1806€500€1472€0€       1€0.1732€871€0.1332€41€4185€42€100€0.14€18
N€N0003€200106€SCZ€11€21€416€93540€0€93440€100€37105€43330€8965€4140€0€       0€0.0246€42050€0.032€19€49810€15€1680€0.0214€19
N€N0003€200106€SCZA€12€21€13€1667€270€1397€0€450€430€200€317€0€    -643€6.7545€317€1€165€1080€17€€€
N€N0003€200106€SDH€11€21€187€41816€0€41816€0€18699€18351€3596€1170€0€       0€0.0167€12656€0.0124€16€28810€12€350€0.0243€60
N€N0003€200106€SGH€11€21€24€6168€0€6168€0€1085€2758€1200€1125€0€      -3€0.1265€2783€0.0408€37€3000€41€385€0.033€9
N€N0003€200106€SGI€11€21€340€72667€350€72017€300€24900€32188€9337€5892€0€       0€0.013€22488€0.0123€20€46559€19€3270€0.0143€58
N€N0003€200106€SGR€11€21€6170€1299132€35974€1259458€2700€574617€455207€144340€85394€2700€       3€0.0949€654440€0.1078€20€422851€13€184867€0.1534€37
N€N0003€200106€SGU€11€21€421€102190€475€101715€0€24400€44647€16278€15490€900€       0€0.0787€50870€0.0602€40€46623€28€4222€0.0301€56
N€N0003€200106€SII€11€21€12161€2461601€89352€2366784€2800€708230€989797€446578€224144€835€       0€0.1034€1098122€0.0831€23€658194€17€613268€0.1146€34
N€N0003€200106€SLC€11€21€462€102521€0€102521€0€31777€51814€14017€4913€0€      -2€0.0498€39662€0.0221€22€51426€15€11433€0.021€27
N€N0003€200106€SLI€11€21€223€40617€418€39999€200€9667€16424€8563€5445€100€       0€0.0584€15844€0.0585€43€20722€21€3633€0.0345€53
N€N0003€200106€SO€11€21€7112€1830209€2000€1815354€11800€580083€787613€325490€133214€754€       0€0.0234€654768€0.0233€25€930696€18€241690€0.0333€29
N€N0003€200106€SOPRA€11€21€65€16715€0€16715€0€3470€8827€1949€2469€0€       0€0.0665€4028€0.0293€35€11087€27€1600€0.0338€30
N€N0003€200106€SOPRB€11€21€65€17925€0€17925€0€5235€6861€2834€2995€0€       1€0.0985€10104€0.042€50€7421€23€400€0.0375€42
N€N0003€200106€SOPRC€11€21€62€16462€0€16462€0€2966€8671€3400€1425€0€       0€0.0901€6935€0.0333€27€8927€25€600€0.0367€33
N€N0003€200106€SP€11€21€2259€417878€20700€395978€1000€88276€173307€84940€49425€1030€       2€0.2098€199842€0.171€26€116566€21€80570€0.2007€41
N€N0003€200106€SPN€11€21€400€100444€325€100119€0€31571€45383€12267€10898€0€       1€0.0288€43292€0.0424€30€56427€21€400€0.015€91
N€N0003€200106€SPP€11€21€229€51056€0€50756€300€10669€25951€9287€5149€0€       0€0.0357€20559€0.0263€30€27662€21€2835€0.0104€42
N€N0003€200106€SRE€11€21€4174€776656€470€775086€1100€536186€219314€17703€2755€228€       0€0.0319€347116€0.0326€9€370017€8€59053€0.036€11
N€N0003€200106€SREPRA€11€21€101€28661€0€28661€0€5688€17888€3435€1650€0€       5€0.1707€17662€0.1052€21€10199€21€800€0.075€20
N€N0003€200106€SSD€11€21€206€35844€500€35344€0€9983€16926€5118€3317€0€       0€0.1372€17605€0.1104€33€13239€17€4500€0.1138€32
N€N0003€200106€SSR€11€21€75€19430€0€19430€0€3254€10127€4436€1013€600€       0€0.0911€7555€0.0238€45€11475€28€400€0.035€22
N€N0003€200106€STZ€11€21€1619€339807€2000€337207€600€85800€149849€59664€42094€400€       2€0.0667€138641€0.0823€34€166570€25€32596€0.0947€42
N€N0003€200106€STZB€12€21€2€624€0€624€0€0€0€0€624€0€       3€2.1795€€€€400€153€224€0.25€294
N€N0003€200106€SUR€11€21€181€31393€0€31393€0€11609€15609€2915€1260€0€       0€0.0639€12522€0.0329€17€17749€15€1122€0.04€22
N€N0003€200106€SUT€11€21€236€35284€0€35084€0€12819€18577€3588€100€0€       0€0.0223€16575€0.0263€15€17409€13€1100€0.0291€14
N€N0003€200106€SUTPRA€11€21€47€10131€0€10131€0€1975€6048€2008€100€0€       3€0.1397€5027€0.083€25€5104€15€€€
N€N0003€200106€SVAPR€11€21€12€3315€0€3315€0€200€1775€1340€0€0€       0€0.1859€1185€0.0888€22€1930€29€200€0.05€13
N€N0003€200106€SWM€11€21€126€25116€100€25016€0€8271€12267€3269€1209€0€       0€0.0897€9365€0.0636€26€13651€16€2000€0.075€24
N€N0003€200106€SZ€11€21€12€2987€0€2987€0€0€1937€900€150€0€       0€0.0453€500€0.03€30€2487€36€€€
N€N0003€200106€TAPPRA€11€21€151€40656€0€40656€0€9089€25026€6266€275€0€       1€0.0587€14590€0.0156€21€25766€17€300€0.03€15
N€N0003€200106€TAPPRB€11€21€23€5637€0€5637€0€628€4379€630€0€0€       0€0.112€4215€0.0363€18€1222€10€200€0.04€11
N€N0003€200106€TCC€11€21€160€33038€0€32738€300€5154€13144€8508€6232€0€       0€0.0487€15161€0.0428€44€15526€27€2351€0.0516€33
N€N0003€200106€TCH€11€21€46€10532€0€10532€0€1828€7022€700€982€0€      -1€0.0697€2692€0.0298€26€7640€21€200€0.05€0
N€N0003€200106€TCLPR€11€21€23€6611€0€6611€0€2911€3700€0€0€0€      -3€0.1033€1800€0.0339€16€4811€11€€€
N€N0003€200106€TCR€11€21€254€64034€0€64034€0€13892€25318€11708€12916€200€      -1€0.0366€20925€0.0261€44€38017€34€5092€0.0244€58
N€N0003€200106€TD€11€21€444€84704€200€84504€0€26904€43499€9309€4792€0€       0€0.0518€30355€0.0191€20€40045€14€14104€0.0498€25
N€N0003€200106€TDI€11€21€22€5012€0€5012€0€850€2266€1175€721€0€       0€0.177€2011€0.0975€46€3001€24€€€
N€N0003€200106€TDR€11€21€26€4930€0€4930€0€160€4120€450€200€0€      -3€0.1429€3070€0.0602€24€1860€18€€€
N€N0003€200106€TDY€11€21€602€111666€327€111339€0€39645€56089€11267€4338€0€       1€0.0325€46693€0.0382€21€60096€14€4550€0.0372€18
N€N0003€200106€TEE€11€21€387€93634€194€93440€0€38091€39954€10290€5205€0€       0€0.0979€55764€0.0522€17€33575€17€4101€0.0442€24
N€N0003€200106€TEF€11€21€1902€396187€0€395605€100€185332€137753€47922€24698€0€       1€0.0489€199060€0.031€21€167710€14€28935€0.0439€27
N€N0003€200106€TEM€11€21€5€975€0€975€0€375€200€400€0€0€       0€0.2467€300€0.1167€11€675€25€€€
N€N0003€200106€TEN€11€21€340€70065€0€70065€0€20950€30885€10353€7877€0€       0€0.0338€26121€0.0405€24€39987€23€3957€0.0298€12
N€N0003€200106€TFS€11€21€769€145212€800€143612€800€41861€68860€23910€9781€0€       1€0.0531€57459€0.0478€23€76318€19€10635€0.0542€23
N€N0003€200106€TGT€11€21€13947€3240598€7313€3215448€13900€1249034€1213942€478651€281570€6151€       0€0.0267€1754183€0.0402€22€1020458€16€454707€0.0506€33
N€N0003€200106€THX€11€21€702€138946€400€137546€600€38790€53171€27131€18274€780€       0€0.0806€45773€0.104€35€75898€24€16475€0.1466€48
N€N0003€200106€TI€11€21€314€58047€100€57847€100€5609€27586€14591€9798€363€      -4€0.3006€31788€0.331€46€23256€24€2903€0.1905€36
N€N0003€200106€TIA€12€23€1€3300€2600€700€0€0€0€0€700€0€    -105€2.68€€€€700€208€€€
N€N0003€200106€TLI€11€21€70€18393€0€18393€0€5914€7198€3215€2066€0€       0€0.0413€4007€0.0171€38€13686€23€700€0.0357€23
N€N0003€200106€TLK€11€21€37€9060€0€9060€0€1072€5706€1383€899€0€       0€0.0239€6138€0.0201€21€2922€33€€€
N€N0003€200106€TOL€11€21€1670€345725€1300€343187€300€106434€153897€54404€28752€0€       0€0.0455€141820€0.0581€27€171803€19€29864€0.0657€25
N€N0003€200106€TR€11€21€913€189915€1800€188115€0€37995€79907€42395€26708€1110€       0€0.0758€79587€0.0422€37€92597€28€15931€0.1202€54
N€N0003€200106€TRA€11€21€304€53919€100€53619€200€18468€22849€10610€1892€200€       0€0.0187€18222€0.0285€24€34022€21€1575€0.0225€27
N€N0003€200106€TRP€11€21€180€40568€300€39968€300€18516€17508€3049€1195€0€       0€0.0269€17545€0.0144€14€22113€14€610€0.0166€13
N€N0003€200106€TRPPR€11€21€65€18352€0€18352€0€6762€8990€2100€500€0€      -5€0.0513€8625€0.0222€22€9527€12€200€0.03€10
N€N0003€200106€TRPPRC€11€21€25€6352€0€6352€0€3210€2942€200€0€0€       0€0.0643€2510€0.0303€14€3842€11€€€
N€N0003€200106€TTR€11€21€23€6839€0€6839€0€4785€1668€386€0€0€      -4€0.0552€1506€0.0338€10€5333€9€€€
N€N0003€200106€TWE€11€21€558€116045€212€115233€600€36782€50391€20674€7986€0€      -2€0.0223€38403€0.0222€28€69540€19€7890€0.0292€31
N€N0003€200106€TWK€11€21€339€62550€426€62124€0€17218€21312€10709€12585€300€       0€0.0307€32607€0.0461€34€27617€38€1900€0.0442€41
N€N0003€200106€TX€11€21€10843€2376297€9060€2363465€2500€1397168€761431€163587€43779€0€       0€0.0354€1075238€0.0369€12€866775€10€423952€0.0385€15
N€N0003€200106€TXCPRA€11€21€138€35819€0€35819€0€20100€13164€1840€615€100€       0€0.0725€12355€0.0141€13€22764€13€700€0.0557€15
N€N0003€200106€TXCPRB€11€21€33€7489€0€7489€0€2855€3884€600€150€0€       5€0.1246€3550€0.0445€12€3739€19€200€0.01€22
N€N0003€200106€TXN€11€21€32718€7538253€101229€7394161€34500€2539737€2403485€1376649€1086906€21884€       0€0.0401€3888049€0.0556€27€1778802€21€1761810€0.066€43
N€N0003€200106€UIS€11€21€3976€863380€300€860260€2600€520238€271865€59247€11158€352€       0€0.0169€410722€0.0227€12€392168€9€59970€0.0259€19
N€N0003€200106€VAP€11€21€25€5620€0€5620€0€1085€2560€500€1475€0€       0€0.0888€4035€0.0313€40€1485€25€100€0.02€11
N€N0003€200106€VBF€11€21€88€20011€0€20011€0€4270€7857€4087€3597€200€      -2€0.0668€10578€0.0362€41€9233€30€200€0.02€320
N€N0003€200106€VEA€11€21€61€17329€0€17329€0€5199€9135€2195€800€0€       1€0.0988€8620€0.0473€19€8309€17€400€0.04€15
N€N0003€200106€VELPRT€11€21€40€9565€0€9565€0€3225€5640€600€100€0€      -1€0.1207€5245€0.0358€15€4020€10€300€0.07€21
N€N0003€200106€VGM€11€21€26€5974€0€5974€0€2694€2750€530€0€0€       0€0.0349€3386€0.0109€14€2588€12€€€
N€N0003€200106€VGR€11€21€505€95521€600€94921€0€26817€43606€15460€8788€250€       4€0.1196€39410€0.111€32€46153€19€9358€0.0972€28
N€N0003€200106€VIG€11€21€10€2057€0€2057€0€389€1668€0€0€0€       0€0.0391€800€0.0125€10€1157€10€100€0.01€13
N€N0003€200106€VIN€11€21€31€6807€0€6807€0€2456€1434€892€2025€0€       0€0.0312€2010€0.013€41€4797€48€€€
N€N0003€200106€VIT€11€21€48€12624€0€12624€0€7444€4875€305€0€0€       0€0.0359€6412€0.0114€11€5887€8€325€0.01€8
N€N0003€200106€VNV€11€21€7€2270€0€2270€0€780€1190€300€0€0€       0€0.0457€538€0.01€26€1732€10€€€
N€N0003€200106€VOD€11€21€7053€1514065€2700€1506152€4300€792257€578419€118150€21426€200€       0€0.0158€842187€0.0218€14€579386€10€88879€0.0263€17
N€N0003€200106€VOL€11€21€102€20551€0€20551€0€5757€10161€2999€1534€100€       0€0.0808€10322€0.0528€27€8844€20€1385€0.0453€26
N€N0003€200106€VOT€11€21€23€6573€0€6573€0€2658€3686€229€0€0€       0€0.0539€2850€0.0175€15€2968€10€755€0.01€23
N€N0003€200106€VPA€11€21€33€9050€0€9050€0€1907€5339€1300€504€0€       0€0.0632€5957€0.0343€22€3093€18€€€
N€N0003€200106€VPQ€11€21€33€8868€0€8868€0€2747€4560€686€875€0€       0€0.0517€3903€0.0212€19€4965€23€€€
N€N0003€200106€VRC€11€21€3288€721772€1186€719800€600€264831€294864€105814€54891€0€       0€0.045€286261€0.0307€21€317784€20€116355€0.0471€28
N€N0003€200106€VSH€11€21€2045€439313€1600€434513€3200€160494€181677€67281€28161€100€       0€0.0236€201249€0.0324€22€186762€16€49702€0.0348€26
N€N0003€200106€VVC€11€21€766€178642€300€178342€0€45864€72830€35634€23102€912€       0€0.0386€69059€0.0436€36€101042€24€8241€0.0549€69
N€N0003€200106€VVR€11€21€328€83284€0€83284€0€28751€37822€13076€3635€0€       0€0.013€15688€0.0125€22€66309€18€1287€0.01€29
N€N0003€200106€WFR€11€21€248€55333€0€55133€200€19295€21918€7154€6214€752€       0€0.0502€20319€0.0448€40€31596€17€3418€0.0496€22
N€N0003€200106€WG€11€21€177€43323€200€43123€0€7887€16391€10247€8498€100€       0€0.0786€26932€0.0573€40€12256€37€3935€0.0413€33
N€N0003€200106€WLP€11€21€3166€613165€3600€607565€1800€224212€285602€70528€28442€581€       1€0.0537€307476€0.0591€19€225772€15€76117€0.0715€21
N€N0003€200106€WNI€11€21€6€620€0€620€0€100€320€200€0€0€       0€0.0194€420€0.0333€11€200€39€€€
N€N0003€200106€WSM€11€21€1521€335089€7400€327689€0€107654€147769€43968€28298€0€       1€0.0431€146297€0.0509€24€138437€17€42955€0.0611€38
N€N0003€200106€WTS€11€21€134€25867€0€25867€0€9094€10894€4105€1774€0€       1€0.0725€13047€0.0591€24€12620€23€200€0.01€8
N€N0003€200106€XRX€11€21€6165€1563755€1500€1551990€9300€899430€518310€111272€32278€0€       0€0.0141€589903€0.0185€14€835374€9€136013€0.0244€21
N€N0003€200106€XVF€11€21€284€63667€300€63367€0€20329€30220€10193€2625€0€      -3€0.2107€36209€0.0865€21€24028€17€3130€0.1246€6
N€N0003€200106€YLD€11€21€49€13280€0€13280€0€5464€4515€2276€1025€0€       0€0.0193€3096€0.0162€19€9884€23€300€0.01€7
N€N0003€200106€YUM€11€21€3481€681270€15304€663764€1800€124966€222082€150777€158519€9220€       0€0.025€322286€0.0381€48€259741€38€83537€0.0503€67
N€N0003€200106€ZIF€11€21€45€9335€0€9335€0€3943€4592€700€100€0€      -1€0.0384€4741€0.018€12€4594€17€€€
N€N0003€200106€ZMX€11€21€13€2620€0€2620€0€0€1999€353€268€0€      -2€0.0335€1979€0.0469€24€641€47€€€'
