########################################################################
#                                                                      #
#               This software is part of the ast package               #
#          Copyright (c) 1989-2011 AT&T Intellectual Property          #
#                      and is licensed under the                       #
#                 Eclipse Public License, Version 1.0                  #
#                    by AT&T Intellectual Property                     #
#                                                                      #
#                A copy of the License is available at                 #
#          http://www.eclipse.org/org/documents/epl-v10.html           #
#         (with md5 checksum b35adb5213ca9657e911e9befb180842)         #
#                                                                      #
#              Information and Software Systems Research               #
#                            AT&T Research                             #
#                           Florham Park NJ                            #
#                                                                      #
#               Glenn Fowler <glenn.s.fowler@gmail.com>                #
#                                                                      #
########################################################################
: convert MAM dependency info to dot input
COMMAND=mamdot
case `(getopts '[-][123:xyz]' opt --xyz; echo 0$opt) 2>/dev/null` in
0123)	ARGV0="-a $COMMAND"
	USAGE=$'
[-?
@(#)$Id: mamdot (AT&T Labs Research) 1997-02-16 $
]
'$USAGE_LICENSE$'
[+NAME?mamdot - make abstract machine to dot dependency graph conversion filter]
[+DESCRIPTION?\bmamdot\b reads MAM (Make Abstract Machine) target and
	prerequisite file descriptions from the standard input and writes a
	\bdot\b(1) description of the dependency graph on the standard output.
	Mamfiles are generated by the \b--mam\b option of \bnmake\b(1) and
	\bgmake\b(1).]
[i:ignore?Dependency names matching the shell \apattern\a are
	ignored.]:[pattern]
[+SEE ALSO?\bdot\b(1), \bgmake\b(1), \bnmake\b(1)]
'
	;;
*)	ARGV0=""
	USAGE="i:[pattern]"
	;;
esac

usage()
{
	OPTIND=0
	getopts $ARGV0 "$USAGE" OPT '-?'
	exit 2
}

integer level=0
typeset -A pwd top
typeset ignore= tree="@(make|done|prev)"

while	getopts $ARGV0 "$USAGE" OPT
do	case $OPT in
	i)	[[ $ignore ]] && ignore="$ignore|"
		ignore=$ignore$OPTARG
		;;
	*)	usage
		;;
	esac
done
[[ $ignore ]] && ignore="@($ignore)"

list[0]=all
top[0]=1
print "digraph mam {"
print "rankdir = LR"
print "node [ shape = box ]"
while read -r label op arg arg2 arg3 args
do	[[ $label == [[:digit:]]* ]] || {
		arg3=$args
		arg2=$arg
		arg=$op
		op=$label
		label=0
	}
	rule=$arg
	[[ ${top[$label]} || $arg == */* || $op != $tree ]] || {
		arg=$label::$arg
		[[ $op == make ]] && print "\"$arg\" [ label = \"$rule\" ]"
	}
	case $op in
	make)	[[ $rule == $ignore ]] || list[level]=${list[level]}$'\n'\"$arg\"
		level=level+1
		list[level]=
		;;
	prev)	[[ $rule == $ignore ]] || list[level]=${list[level]}$'\n'\"$arg\"
		;;
	done)	[[ $rule == $ignore || ! ${list[level]} ]] ||
			print "\"$arg\" -> {${list[level]} }"
		level=level-1
		;;
	info)	case $arg in
		pwd)	[[ $arg3 == "." ]] && top[$label]=1 ;;
		esac
		;;
	esac
done
print "}"
