# regression tests for the dss netflow method

TITLE + netflow

export TZ=EST5EDT

VIEW data

TEST 01 'netflow method, version 5'
	EXEC -x netflow -p '%(time:%=u%K)s %(prot)d %(src_addr)s:%(src_port)d %(dst_addr)s:%(dst_port)d %(hop)s' prot==6 $data/netflow-5.dat
		OUTPUT - $'2002-02-17+00:21:21 6 209.50.252.151:80 24.159.97.130:2912 12.123.20.193
2002-02-17+00:21:21 6 209.50.252.151:80 24.159.97.130:2912 12.123.20.193
2002-02-17+00:21:21 6 209.126.184.10:80 24.159.97.130:2939 12.123.20.185
2002-02-17+00:21:21 6 209.126.184.10:80 24.159.97.130:2940 12.123.20.185
2002-02-17+00:21:21 6 208.184.29.70:80 24.159.97.59:1876 12.123.20.193
2002-02-17+00:21:21 6 208.184.29.70:80 24.159.97.59:1878 12.123.20.193
2002-02-17+00:21:24 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2941 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2942 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2943 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2944 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2945 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2947 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2948 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2949 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2950 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2951 12.123.20.185
2002-02-17+00:21:34 6 66.28.46.100:80 24.159.97.133:3538 12.123.20.197
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2952 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2953 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2954 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2955 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2956 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2957 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2958 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2959 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2960 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2961 12.123.20.185
2002-02-17+00:21:34 6 208.184.29.70:80 24.159.97.59:1880 12.123.20.193
2002-02-17+00:21:34 6 208.184.29.70:80 24.159.97.59:1881 12.123.20.193
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2962 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2963 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2964 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2965 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2966 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2967 12.123.20.185
2002-02-17+00:21:34 6 209.126.184.10:80 24.159.97.130:2968 12.123.20.185
2002-02-17+00:21:45 6 209.126.184.10:80 24.159.97.130:2970 12.123.20.185
2002-02-17+00:21:45 6 209.126.184.10:80 24.159.97.130:2969 12.123.20.185
2002-02-17+00:21:45 6 209.126.184.10:80 24.159.97.130:2971 12.123.20.185
2002-02-17+00:21:45 6 209.126.184.10:80 24.159.97.130:2972 12.123.20.185
2002-02-17+00:21:45 6 209.126.184.10:80 24.159.97.130:2973 12.123.20.185
2002-02-17+00:21:45 6 209.126.184.10:80 24.159.97.130:2943 12.123.20.185
2002-02-17+00:21:45 6 209.126.184.10:80 24.159.97.130:2974 12.123.20.185
2002-02-17+00:21:54 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:22:03 6 209.126.184.10:80 24.159.97.130:2980 12.123.20.185
2002-02-17+00:22:03 6 209.126.184.10:80 24.159.97.130:2981 12.123.20.185
2002-02-17+00:22:03 6 209.126.184.10:80 24.159.97.130:2982 12.123.20.185
2002-02-17+00:22:03 6 209.133.93.174:80 24.159.97.97:1144 12.123.20.193
2002-02-17+00:22:03 6 209.133.93.174:80 24.159.97.97:1145 12.123.20.193
2002-02-17+00:22:03 6 216.174.23.32:3186 24.159.97.24:6347 12.123.20.185
2002-02-17+00:22:17 6 209.133.93.174:80 24.159.97.97:1145 12.123.20.193
2002-02-17+00:22:17 6 209.133.93.174:80 24.159.97.97:1144 12.123.20.193
2002-02-17+00:22:17 6 172.188.243.115:1214 24.159.97.250:1123 12.123.20.197
2002-02-17+00:22:17 6 209.50.252.152:80 24.159.97.130:3031 12.123.20.197
2002-02-17+00:22:17 6 209.50.252.152:80 24.159.97.130:3032 12.123.20.197
2002-02-17+00:22:26 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:22:38 6 209.50.252.151:80 24.159.97.130:3033 12.123.20.193
2002-02-17+00:22:38 6 209.50.252.151:80 24.159.97.130:3033 12.123.20.193
2002-02-17+00:22:38 6 208.184.29.70:80 24.159.97.59:1884 12.123.20.193
2002-02-17+00:22:56 6 209.50.252.150:80 24.159.97.130:3049 12.123.20.193
2002-02-17+00:22:56 6 209.50.252.150:80 24.159.97.130:3050 12.123.20.193
2002-02-17+00:22:56 6 208.185.127.162:80 24.159.97.137:3014 12.123.20.189
2002-02-17+00:22:56 6 208.185.127.162:80 24.159.97.137:3015 12.123.20.189
2002-02-17+00:22:56 6 208.185.127.162:80 24.159.97.137:3013 12.123.20.189
2002-02-17+00:22:56 6 208.185.127.162:80 24.159.97.137:3016 12.123.20.189
2002-02-17+00:22:56 6 208.185.127.162:80 24.159.97.137:3017 12.123.20.189
2002-02-17+00:22:56 6 209.50.252.150:80 24.159.97.130:3049 12.123.20.193
2002-02-17+00:22:56 6 209.50.252.150:80 24.159.97.130:3050 12.123.20.193
2002-02-17+00:22:56 6 209.50.252.151:80 24.159.97.130:3062 12.123.20.193
2002-02-17+00:22:56 6 208.185.127.162:80 24.159.97.137:3012 12.123.20.189
2002-02-17+00:22:56 6 209.50.252.151:80 24.159.97.130:3062 12.123.20.193
2002-02-17+00:22:56 6 208.184.29.70:80 24.159.97.59:1887 12.123.20.193
2002-02-17+00:23:05 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:23:08 6 80.1.72.245:44305 24.159.97.120:1214 12.123.20.185
2002-02-17+00:23:25 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:23:30 6 80.1.72.245:44305 24.159.97.120:1214 12.123.20.185
2002-02-17+00:23:30 6 66.114.68.27:65325 24.159.97.195:9443 12.123.20.197
2002-02-17+00:23:40 6 210.241.116.100:4814 192.205.33.224:80 0.0.0.0
2002-02-17+00:23:40 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:23:49 6 80.1.72.245:44305 24.159.97.120:1214 12.123.20.185
2002-02-17+00:24:10 6 172.188.209.250:3251 24.159.97.1:1214 12.123.20.197
2002-02-17+00:24:27 6 172.188.140.2:4617 24.159.97.124:1214 12.123.20.189
2002-02-17+00:24:27 6 172.188.209.250:3251 24.159.97.1:1214 12.123.20.197
2002-02-17+00:24:41 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:24:50 6 80.1.72.245:44305 24.159.97.120:1214 12.123.20.185
2002-02-17+00:24:50 6 208.185.127.162:80 24.159.97.137:3019 12.123.20.189
2002-02-17+00:24:50 6 208.185.127.162:80 24.159.97.137:3020 12.123.20.189
2002-02-17+00:24:50 6 208.185.127.162:80 24.159.97.137:3021 12.123.20.189
2002-02-17+00:24:50 6 208.185.127.162:80 24.159.97.137:3022 12.123.20.189
2002-02-17+00:24:50 6 208.185.127.162:80 24.159.97.137:3018 12.123.20.189
2002-02-17+00:25:02 6 12.122.0.21:34479 192.205.33.224:179 0.0.0.0
2002-02-17+00:25:02 6 12.122.0.21:34479 192.205.33.224:179 0.0.0.0
2002-02-17+00:25:02 6 12.122.0.22:20403 192.205.33.224:179 0.0.0.0
2002-02-17+00:25:02 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:25:02 6 208.185.127.162:80 24.159.97.137:3023 12.123.20.189
2002-02-17+00:25:17 6 62.255.22.110:1325 24.159.97.124:1214 12.123.20.197
2002-02-17+00:25:17 6 66.28.69.137:80 24.159.97.17:1104 12.123.20.189
2002-02-17+00:25:17 6 216.218.204.2:80 24.159.97.27:1051 12.123.20.197
2002-02-17+00:25:31 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:25:31 6 63.211.153.119:6346 24.159.97.27:1053 12.123.20.193
2002-02-17+00:25:31 6 208.185.127.162:80 24.159.97.137:3025 12.123.20.189
2002-02-17+00:25:31 6 80.1.72.245:44305 24.159.97.120:1214 12.123.20.185
2002-02-17+00:25:31 6 208.185.127.162:80 24.159.97.137:3024 12.123.20.189
2002-02-17+00:25:31 6 208.185.127.162:80 24.159.97.137:3026 12.123.20.189
2002-02-17+00:25:31 6 208.184.224.94:80 24.159.97.17:1112 12.123.20.193
2002-02-17+00:25:58 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:26:18 6 80.1.72.245:50264 24.159.97.120:1214 12.123.20.185
2002-02-17+00:26:18 6 80.1.72.245:44305 24.159.97.120:1214 12.123.20.185
2002-02-17+00:26:26 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:27:04 6 80.1.72.245:50264 24.159.97.120:1214 12.123.20.185
2002-02-17+00:27:16 6 80.1.72.245:50264 24.159.97.120:1214 12.123.20.185
2002-02-17+00:27:16 6 209.249.90.101:119 24.159.97.73:3187 12.123.20.185
2002-02-17+00:27:18 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:27:30 6 80.1.72.245:53482 24.159.97.120:1214 12.123.20.185
2002-02-17+00:27:41 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:27:43 6 208.184.29.150:80 24.159.97.249:64471 12.123.20.197
2002-02-17+00:27:43 6 208.184.29.150:80 24.159.97.249:64487 12.123.20.197
2002-02-17+00:27:57 6 66.28.166.34:2152 24.159.97.24:6347 12.123.20.193
2002-02-17+00:28:10 6 80.1.72.245:53482 24.159.97.120:1214 12.123.20.185
2002-02-17+00:28:10 6 208.184.29.150:80 24.159.97.249:64523 12.123.20.197
2002-02-17+00:28:29 6 80.1.72.245:53482 24.159.97.120:1214 12.123.20.185
2002-02-17+00:28:39 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:28:43 6 66.28.46.100:80 24.159.97.250:1496 12.123.20.197
2002-02-17+00:29:06 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:29:09 6 213.105.158.36:21116 24.159.97.24:6347 12.123.20.189
2002-02-17+00:29:09 6 213.105.158.36:21116 24.159.97.24:6347 12.123.20.189
2002-02-17+00:29:25 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:29:28 6 80.1.72.245:53482 24.159.97.120:1214 12.123.20.185
2002-02-17+00:29:45 6 80.1.72.245:53482 24.159.97.120:1214 12.123.20.185
2002-02-17+00:30:06 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:30:07 6 80.1.72.245:53482 24.159.97.120:1214 12.123.20.185
2002-02-17+00:30:19 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:30:19 6 172.188.209.250:3502 24.159.97.1:1214 12.123.20.197
2002-02-17+00:30:37 6 66.28.166.35:2862 24.159.97.24:6347 12.123.20.193
2002-02-17+00:30:37 6 172.188.209.250:3502 24.159.97.1:1214 12.123.20.197
2002-02-17+00:30:47 6 12.0.1.28:179 192.205.33.224:11008 0.0.0.0
2002-02-17+00:31:04 6 80.1.72.245:53482 24.159.97.120:1214 12.123.20.185
2002-02-17+00:31:04 6 208.184.29.150:80 24.159.97.88:3233 12.123.20.185
2002-02-17+00:31:16 6 208.184.29.150:80 24.159.97.88:3245 12.123.20.185
2002-02-17+00:31:16 6 208.184.29.150:80 24.159.97.88:3246 12.123.20.185
2002-02-17+00:31:16 6 80.1.50.125:2377 24.159.97.1:1214 12.123.20.193'
	EXEC -x netflow '(prot==6)|{print "%(time:%=u%K)s %(prot)d %(src_addr)s:%(src_port)d %(dst_addr)s:%(dst_port)d %(hop)s"}' $data/netflow-5.dat
	EXEC -x netflow -c 'time.min>=28&&time.min<=31&&time.sec==37' $data/netflow-5.dat
		OUTPUT - $'2/247'
	EXEC -x netflow '(time.min>=28&&time.min<=31&&time.sec==37)|{count}' $data/netflow-5.dat
	EXEC -x netflow -p '%(time.min)02d:%(time.sec)02d' 'time.min>=28&&time.min<=31&&time.sec==37' $data/netflow-5.dat
		OUTPUT - $'30:37\n30:37'
	EXEC -x netflow -c 'time.min>=28&&time.min<=31&&src_addr=~"199.37/16"' $data/netflow-5.dat
		OUTPUT - $'18/247'
	EXEC -x netflow -p '%(time.min)02d:%(time.sec)02d %(src_addr)s' 'time.min>=28&&time.min<=31&&src_addr=~"199.37/16"' $data/netflow-5.dat
		OUTPUT - $'28:18 199.37.175.40
28:18 199.37.184.158
28:39 199.37.184.110
29:06 199.37.184.107
29:25 199.37.184.107
29:25 199.37.184.107
29:25 199.37.184.107
29:25 199.37.184.158
29:40 199.37.184.110
30:19 199.37.184.196
30:19 199.37.184.158
30:31 199.37.184.197
30:31 199.37.184.197
30:31 199.37.184.197
30:31 199.37.184.110
30:47 199.37.184.198
31:06 199.37.184.198
31:06 199.37.184.198'

TEST 02 'time basics'
	EXEC -x netflow '(start.min==30)|{print "%(start.hour)02d:%(start.min)02d:%(start.sec)02d %(start:%K.%5N)s %(src_addr)s"}' $data/netflow-5.dat
		OUTPUT - $'19:30:03 2002-02-16+19:30:03.57727 80.1.72.245
19:30:03 2002-02-16+19:30:03.32956 199.37.184.196
19:30:08 2002-02-16+19:30:08.66956 12.0.1.28
19:30:12 2002-02-16+19:30:12.63756 199.37.184.158
19:30:06 2002-02-16+19:30:06.02927 172.188.209.250
19:30:15 2002-02-16+19:30:15.62570 199.37.184.197
19:30:15 2002-02-16+19:30:15.72970 199.37.184.197
19:30:16 2002-02-16+19:30:16.31370 199.37.184.197
19:30:12 2002-02-16+19:30:12.11370 205.171.13.252
19:30:12 2002-02-16+19:30:12.11770 205.171.13.252
19:30:12 2002-02-16+19:30:12.44970 205.171.13.252
19:30:12 2002-02-16+19:30:12.98570 208.147.25.251
19:30:12 2002-02-16+19:30:12.98970 208.147.25.251
19:30:13 2002-02-16+19:30:13.04570 208.147.25.251
19:30:14 2002-02-16+19:30:14.73770 65.114.231.109
19:30:14 2002-02-16+19:30:14.74170 65.114.231.109
19:30:14 2002-02-16+19:30:14.74970 65.114.231.109
19:30:14 2002-02-16+19:30:14.75370 65.114.231.109
19:30:16 2002-02-16+19:30:16.09370 207.87.182.129
19:30:16 2002-02-16+19:30:16.10170 207.87.182.129
19:30:16 2002-02-16+19:30:16.12570 207.87.182.129
19:30:17 2002-02-16+19:30:17.26970 38.16.59.16
19:30:18 2002-02-16+19:30:18.64170 38.16.59.16
19:30:19 2002-02-16+19:30:19.45370 38.16.59.16
19:30:27 2002-02-16+19:30:27.05370 199.37.184.110
19:30:22 2002-02-16+19:30:22.38127 172.188.209.250
19:30:31 2002-02-16+19:30:31.41387 199.37.184.198
19:30:35 2002-02-16+19:30:35.33387 12.0.1.28
19:30:41 2002-02-16+19:30:41.57387 12.0.1.72
19:30:51 2002-02-16+19:30:51.07007 199.37.184.198
19:30:51 2002-02-16+19:30:51.13807 199.37.184.198'
	EXEC -x netflow '(time.min==30)|{print "%(time.hour)02d:%(time.min)02d:%(time.sec)02d %(time)s %(src_addr)s"}' $data/netflow-5.dat
		OUTPUT - $'19:30:06 2002-02-16+19:30:06 12.0.1.28
19:30:06 2002-02-16+19:30:06 207.126.105.150
19:30:07 2002-02-16+19:30:07 66.28.166.35
19:30:07 2002-02-16+19:30:07 80.1.72.245
19:30:19 2002-02-16+19:30:19 199.37.184.196
19:30:19 2002-02-16+19:30:19 12.0.1.28
19:30:19 2002-02-16+19:30:19 199.37.184.158
19:30:19 2002-02-16+19:30:19 172.188.209.250
19:30:31 2002-02-16+19:30:31 199.37.184.197
19:30:31 2002-02-16+19:30:31 199.37.184.197
19:30:31 2002-02-16+19:30:31 199.37.184.197
19:30:31 2002-02-16+19:30:31 205.171.13.252
19:30:31 2002-02-16+19:30:31 205.171.13.252
19:30:31 2002-02-16+19:30:31 205.171.13.252
19:30:31 2002-02-16+19:30:31 208.147.25.251
19:30:31 2002-02-16+19:30:31 208.147.25.251
19:30:31 2002-02-16+19:30:31 208.147.25.251
19:30:31 2002-02-16+19:30:31 65.114.231.109
19:30:31 2002-02-16+19:30:31 65.114.231.109
19:30:31 2002-02-16+19:30:31 65.114.231.109
19:30:31 2002-02-16+19:30:31 65.114.231.109
19:30:31 2002-02-16+19:30:31 207.87.182.129
19:30:31 2002-02-16+19:30:31 207.87.182.129
19:30:31 2002-02-16+19:30:31 207.87.182.129
19:30:31 2002-02-16+19:30:31 38.16.59.16
19:30:31 2002-02-16+19:30:31 38.16.59.16
19:30:31 2002-02-16+19:30:31 38.16.59.16
19:30:31 2002-02-16+19:30:31 199.37.184.110
19:30:37 2002-02-16+19:30:37 66.28.166.35
19:30:37 2002-02-16+19:30:37 172.188.209.250
19:30:47 2002-02-16+19:30:47 199.37.184.198
19:30:47 2002-02-16+19:30:47 12.0.1.28
19:30:47 2002-02-16+19:30:47 12.0.1.72'
	EXEC -x netflow -p "%(prot)d %(time.hour)02d:%(time.min)02d:%(time.sec)02d %(time)s %(src_addr)s" '(prot==6)&&(time.min==30)' $data/netflow-5.dat
		OUTPUT - $'6 19:30:06 2002-02-16+19:30:06 12.0.1.28
6 19:30:07 2002-02-16+19:30:07 80.1.72.245
6 19:30:19 2002-02-16+19:30:19 12.0.1.28
6 19:30:19 2002-02-16+19:30:19 172.188.209.250
6 19:30:37 2002-02-16+19:30:37 66.28.166.35
6 19:30:37 2002-02-16+19:30:37 172.188.209.250
6 19:30:47 2002-02-16+19:30:47 12.0.1.28'

TEST 03 'maps'
	EXEC -I$data -x netflow-map '((tcp_flags&"FIN|SYN")=="FIN")|{count}' netflow-5.dat
		OUTPUT - $'11/247'
	EXEC -I$data -x netflow-map '((tcp_flags&"FIN|SYN")=="SYN")|{count}' netflow-5.dat
		OUTPUT - $'16/247'
	EXEC -I$data -x netflow-map '((tcp_flags&"FIN|SYN")=="FIN|SYN")|{count}' netflow-5.dat
		OUTPUT - $'77/247'
	EXEC -I$data -x netflow-map '(tcp_flags&"FIN|SYN")|{count}' netflow-5.dat
		OUTPUT - $'104/247'
	EXEC -I$data -x netflow-map '((tcp_flags&"FIN|SYN")==0)|{count}' netflow-5.dat
		OUTPUT - $'143/247'
	EXEC -I$data -x netflow-map '(prot=="ICMP")|{count}' netflow-5.dat
		OUTPUT - $'69/247'
	EXEC -I$data -x netflow-map '(prot=="TCP")|{count}' netflow-5.dat
		OUTPUT - $'142/247'
	EXEC -I$data -x netflow-map '(prot=="UDP")|{count}' netflow-5.dat
		OUTPUT - $'36/247'
