/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.database;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.database.DatabaseService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\f\u001a\n \r*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/javacs/kt/database/DatabaseService;", "", "()V", "<set-?>", "Lorg/jetbrains/exposed/sql/Database;", "db", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "deleteDb", "", "storagePath", "Ljava/nio/file/Path;", "getDbFilePath", "kotlin.jvm.PlatformType", "getDbFromFile", "setup", "Companion", "shared"})
@SourceDebugExtension(value={"SMAP\nDatabaseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseService.kt\norg/javacs/kt/database/DatabaseService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class DatabaseService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Database db;
    public static final int DB_VERSION = 3;
    @NotNull
    public static final String DB_FILENAME = "kls_database.db";

    @Nullable
    public final Database getDb() {
        return this.db;
    }

    public final void setup(@Nullable Path storagePath) {
        this.db = this.getDbFromFile(storagePath);
        int currentVersion2 = ((Number)ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)setup.currentVersion.1.INSTANCE)).intValue();
        if (currentVersion2 != 3) {
            LoggerKt.getLOG().info("Database has version " + currentVersion2 + " != 3 (the required version), therefore it will be rebuilt...", new Object[0]);
            this.deleteDb(storagePath);
            this.db = this.getDbFromFile(storagePath);
            ThreadLocalTransactionManagerKt.transaction((Database)this.db, (Function1)setup.1.INSTANCE);
        } else {
            LoggerKt.getLOG().info("Database has the correct version " + currentVersion2 + " and will be used as-is", new Object[0]);
        }
    }

    private final Database getDbFromFile(Path storagePath) {
        Database database;
        Path path = storagePath;
        if (path != null) {
            Path it = path;
            boolean bl = false;
            database = Files.isDirectory(it, new LinkOption[0]) ? Database.Companion.connect$default((Database.Companion)Database.Companion, (String)("jdbc:sqlite:" + this.getDbFilePath(it)), null, null, null, null, null, null, (int)126, null) : null;
        } else {
            database = null;
        }
        return database;
    }

    private final void deleteDb(Path storagePath) {
        block0: {
            Path path = storagePath;
            if (path == null) break block0;
            Path it = path;
            boolean bl = false;
            Files.deleteIfExists(this.getDbFilePath(it));
        }
    }

    private final Path getDbFilePath(Path storagePath) {
        String[] stringArray = new String[]{DB_FILENAME};
        return Path.of(((Object)storagePath).toString(), stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/javacs/kt/database/DatabaseService$Companion;", "", "()V", "DB_FILENAME", "", "DB_VERSION", "", "shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

