/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.Artifact;
import org.javacs.kt.classpath.HomeKt;
import org.javacs.kt.classpath.MavenClassPathResolverKt;
import org.javacs.kt.util.ShellPathUtilsKt;
import org.javacs.kt.util.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00112\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0011\u001a\u001c\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00112\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0011\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0002\u001a$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u001c\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0002\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006!"}, d2={"artifactPattern", "Lkotlin/text/Regex;", "mvnCommandFromPath", "Ljava/nio/file/Path;", "getMvnCommandFromPath", "()Ljava/nio/file/Path;", "mvnCommandFromPath$delegate", "Lkotlin/Lazy;", "findMavenArtifact", "a", "Lorg/javacs/kt/classpath/Artifact;", "source", "", "generateMavenDependencyList", "pom", "generateMavenDependencySourcesList", "mavenJarName", "", "mvnCommand", "parseMavenArtifact", "rawArtifact", "version", "parseMavenSource", "readMavenDependencyList", "", "dependenciesOutput", "readMavenDependencyListWithSources", "artifacts", "sourcesOutput", "runCommand", "", "command", "", "shared"})
@SourceDebugExtension(value={"SMAP\nMavenClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenClassPathResolver.kt\norg/javacs/kt/classpath/MavenClassPathResolverKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n766#2:215\n857#2,2:216\n1549#2:218\n1620#2,3:219\n766#2:222\n857#2,2:223\n1603#2,9:225\n1855#2:234\n1856#2:236\n1612#2:237\n1855#2:238\n1747#2,3:239\n1856#2:242\n1#3:235\n*S KotlinDebug\n*F\n+ 1 MavenClassPathResolver.kt\norg/javacs/kt/classpath/MavenClassPathResolverKt\n*L\n71#1:215\n71#1:216,2\n72#1:218\n72#1:219,3\n78#1:222\n78#1:223,2\n79#1:225,9\n79#1:234\n79#1:236\n79#1:237\n82#1:238\n82#1:239,3\n82#1:242\n79#1:235\n*E\n"})
public final class MavenClassPathResolverKt {
    @NotNull
    private static final Regex artifactPattern = new Regex("^[^:]+:(?:[^:]+:)+[^:]+");
    @NotNull
    private static final Lazy mvnCommandFromPath$delegate = LazyKt.lazy((Function0)mvnCommandFromPath.2.INSTANCE);

    /*
     * WARNING - void declaration
     */
    private static final Set<Artifact> readMavenDependencyList(Path dependenciesOutput) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        File file = dependenciesOutput.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Iterable $this$filter$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!artifactPattern.matches((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MavenClassPathResolverKt.parseMavenArtifact$default(it, null, 2, null));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<Artifact> readMavenDependencyListWithSources(Set<Artifact> artifacts2, Path sourcesOutput) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        File file = sourcesOutput.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Iterable $this$filter$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!artifactPattern.matches((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Artifact it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (MavenClassPathResolverKt.parseMavenSource$default(it, null, 2, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set sources = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = artifacts2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            block6: {
                void $this$any$iv;
                Artifact it = (Artifact)element$iv;
                boolean bl4 = false;
                Iterable $i$f$forEach3 = sources;
                object = it;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Artifact it1 = (Artifact)element$iv2;
                        boolean bl5 = false;
                        if (!(Intrinsics.areEqual((Object)it1.getGroup(), (Object)it.getGroup()) && Intrinsics.areEqual((Object)it1.getArtifact(), (Object)it.getArtifact()) && Intrinsics.areEqual((Object)it1.getVersion(), (Object)it.getVersion()))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean bl6 = bl;
            ((Artifact)object).setSource(bl6);
        }
        return artifacts2;
    }

    private static final Path findMavenArtifact(Artifact a, boolean source) {
        Path path;
        Path result = HomeKt.getMavenRepository().resolve(StringsKt.replace$default((String)a.getGroup(), (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null)).resolve(a.getArtifact()).resolve(a.getVersion()).resolve(MavenClassPathResolverKt.mavenJarName(a, source));
        if (Files.exists(result, new LinkOption[0])) {
            path = result;
        } else {
            Object[] objectArray = new Object[]{a, result};
            LoggerKt.getLOG().warn("Couldn't find {} in {}", objectArray);
            path = null;
        }
        return path;
    }

    private static final String mavenJarName(Artifact a, boolean source) {
        return source ? a.getArtifact() + "-" + a.getVersion() + "-sources.jar" : a.getArtifact() + "-" + a.getVersion() + ".jar";
    }

    private static final Path generateMavenDependencyList(Path pom) {
        Path mavenOutput = Files.createTempFile("deps", ".txt", new FileAttribute[0]);
        Object[] objectArray = new String[]{((Object)MavenClassPathResolverKt.mvnCommand(pom)).toString(), "dependency:list", "-DincludeScope=test", "-DoutputFile=" + mavenOutput, "-Dstyle.color=never"};
        List command = CollectionsKt.listOf((Object[])objectArray);
        MavenClassPathResolverKt.runCommand(pom, command);
        Intrinsics.checkNotNull((Object)mavenOutput);
        return mavenOutput;
    }

    private static final Path generateMavenDependencySourcesList(Path pom) {
        Path mavenOutput = Files.createTempFile("sources", ".txt", new FileAttribute[0]);
        Object[] objectArray = new String[]{((Object)MavenClassPathResolverKt.mvnCommand(pom)).toString(), "dependency:sources", "-DincludeScope=test", "-DoutputFile=" + mavenOutput, "-Dstyle.color=never"};
        List command = CollectionsKt.listOf((Object[])objectArray);
        MavenClassPathResolverKt.runCommand(pom, command);
        Intrinsics.checkNotNull((Object)mavenOutput);
        return mavenOutput;
    }

    private static final void runCommand(Path pom, List<String> command) {
        Path workingDirectory = pom.toAbsolutePath().getParent();
        Object[] objectArray = new Object[]{command, workingDirectory};
        LoggerKt.getLOG().info("Run {} in {}", objectArray);
        Intrinsics.checkNotNull((Object)workingDirectory);
        objectArray = UtilsKt.execAndReadStdoutAndStderr(command, workingDirectory);
        String result = (String)objectArray.component1();
        String errors = (String)objectArray.component2();
        LoggerKt.getLOG().debug(result, new Object[0]);
        if (StringsKt.contains$default((CharSequence)errors, (CharSequence)"BUILD FAILURE", (boolean)false, (int)2, null)) {
            Object[] objectArray2 = new Object[]{CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)errors))};
            LoggerKt.getLOG().warn("Maven task failed: {}", objectArray2);
        }
    }

    private static final Path getMvnCommandFromPath() {
        Lazy lazy = mvnCommandFromPath$delegate;
        return (Path)lazy.getValue();
    }

    private static final Path mvnCommand(Path pom) {
        Path path = MavenClassPathResolverKt.getMvnCommandFromPath();
        if (path == null) {
            Path path2 = ShellPathUtilsKt.findProjectCommandWithName("mvnw", pom);
            if (path2 != null) {
                Path path3;
                Path it = path3 = path2;
                boolean bl = false;
                LoggerKt.getLOG().info("Using mvn wrapper (mvnw) in place of mvn command", new Object[0]);
                path = path3;
            } else {
                path = null;
            }
        }
        if (path == null) {
            boolean bl = false;
            String string = "Unable to find the 'mvn' command or suitable wrapper";
            throw new IllegalArgumentException(string.toString());
        }
        return path;
    }

    @NotNull
    public static final Artifact parseMavenArtifact(@NotNull String rawArtifact, @Nullable String version) {
        Artifact artifact;
        Intrinsics.checkNotNullParameter((Object)rawArtifact, (String)"rawArtifact");
        char[] cArray = new char[]{':'};
        List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)rawArtifact)).toString(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        switch (parts.size()) {
            case 3: {
                String string = (String)parts.get(0);
                String string2 = (String)parts.get(1);
                String string3 = version;
                if (string3 == null) {
                    string3 = (String)parts.get(2);
                }
                artifact = new Artifact(string, string2, null, null, string3, null, false);
                break;
            }
            case 4: {
                String string = (String)parts.get(0);
                String string4 = (String)parts.get(1);
                String string5 = (String)parts.get(2);
                String string6 = version;
                if (string6 == null) {
                    string6 = (String)parts.get(3);
                }
                artifact = new Artifact(string, string4, string5, null, string6, null, false);
                break;
            }
            case 5: {
                String string = (String)parts.get(0);
                String string7 = (String)parts.get(1);
                String string8 = (String)parts.get(2);
                String string9 = version;
                if (string9 == null) {
                    string9 = (String)parts.get(3);
                }
                artifact = new Artifact(string, string7, string8, null, string9, (String)parts.get(4), false);
                break;
            }
            case 6: {
                String string = (String)parts.get(0);
                String string10 = (String)parts.get(1);
                String string11 = (String)parts.get(2);
                String string12 = (String)parts.get(3);
                String string13 = version;
                if (string13 == null) {
                    string13 = (String)parts.get(4);
                }
                artifact = new Artifact(string, string10, string11, string12, string13, (String)parts.get(5), false);
                break;
            }
            default: {
                throw new IllegalArgumentException(rawArtifact + " is not a properly formed Maven/Gradle artifact");
            }
        }
        return artifact;
    }

    public static /* synthetic */ Artifact parseMavenArtifact$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return MavenClassPathResolverKt.parseMavenArtifact(string, string2);
    }

    @Nullable
    public static final Artifact parseMavenSource(@NotNull String rawArtifact, @Nullable String version) {
        Artifact artifact;
        Intrinsics.checkNotNullParameter((Object)rawArtifact, (String)"rawArtifact");
        char[] cArray = new char[]{':'};
        List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)rawArtifact)).toString(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() == 5) {
            if (Intrinsics.areEqual(parts.get(3), (Object)"sources")) {
                String string = (String)parts.get(0);
                String string2 = (String)parts.get(1);
                String string3 = (String)parts.get(2);
                String string4 = version;
                if (string4 == null) {
                    String[] stringArray = new String[]{" "};
                    string4 = (String)StringsKt.split$default((CharSequence)((CharSequence)parts.get(4)), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
                }
                artifact = new Artifact(string, string2, string3, null, string4, null, true);
            } else {
                artifact = null;
            }
        } else {
            artifact = null;
        }
        return artifact;
    }

    public static /* synthetic */ Artifact parseMavenSource$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return MavenClassPathResolverKt.parseMavenSource(string, string2);
    }

    public static final /* synthetic */ Path access$generateMavenDependencyList(Path pom) {
        return MavenClassPathResolverKt.generateMavenDependencyList(pom);
    }

    public static final /* synthetic */ Set access$readMavenDependencyList(Path dependenciesOutput) {
        return MavenClassPathResolverKt.readMavenDependencyList(dependenciesOutput);
    }

    public static final /* synthetic */ Path access$generateMavenDependencySourcesList(Path pom) {
        return MavenClassPathResolverKt.generateMavenDependencySourcesList(pom);
    }

    public static final /* synthetic */ Set access$readMavenDependencyListWithSources(Set artifacts2, Path sourcesOutput) {
        return MavenClassPathResolverKt.readMavenDependencyListWithSources(artifacts2, sourcesOutput);
    }

    public static final /* synthetic */ Path access$findMavenArtifact(Artifact a, boolean source) {
        return MavenClassPathResolverKt.findMavenArtifact(a, source);
    }
}

