/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DetectionUtil {
    private static final int JAVA_VERSION = DetectionUtil.javaVersion0();
    private static final boolean HAS_UNSAFE = DetectionUtil.hasUnsafe(AtomicInteger.class.getClassLoader());

    public static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    public static int javaVersion() {
        return JAVA_VERSION;
    }

    private static boolean hasUnsafe(ClassLoader loader) {
        try {
            Class<?> unsafeClazz = Class.forName("sun.misc.Unsafe", true, loader);
            return DetectionUtil.hasUnsafeField(unsafeClazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasUnsafeField(final Class<?> unsafeClass) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                unsafeClass.getDeclaredField("theUnsafe");
                return true;
            }
        });
    }

    private static int javaVersion0() {
        try {
            Deflater.class.getDeclaredField("SYNC_FLUSH");
            return 7;
        }
        catch (Exception e) {
            try {
                Double.class.getDeclaredField("MIN_NORMAL");
                return 6;
            }
            catch (Exception exception) {
                return 5;
            }
        }
    }

    private DetectionUtil() {
    }
}

