/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobHistoryServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class jobhistoryhome_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    private void printJob(String timestamp, String jobId, String jobName, String user, Path logFile, JspWriter out) throws IOException {
        out.print("<tr>");
        out.print("<td>" + new Date(Long.parseLong(timestamp)) + "</td>");
        out.print("<td><a href=\"jobdetailshistory.jsp?logFile=" + logFile.toString() + "\">" + jobId + "</a></td>");
        out.print("<td>" + HtmlQuoting.quoteHtmlChars(this.unescapeUnderscores(jobName)) + "</td>");
        out.print("<td>" + HtmlQuoting.quoteHtmlChars(this.unescapeUnderscores(user)) + "</td>");
        out.print("</tr>");
    }

    private String escapeUnderscores(String rawString) {
        return this.convertStrings(rawString, "_", "%5F");
    }

    private String unescapeUnderscores(String rawString) {
        return this.convertStrings(rawString, "%5F", "_");
    }

    private String convertStrings(String escapedString, String from, String to) {
        int firstEscape = escapedString.indexOf(from);
        if (firstEscape < 0) {
            return escapedString;
        }
        return escapedString.substring(0, firstEscape) + to + this.unescapeUnderscores(escapedString.substring(firstEscape + from.length()));
    }

    private void printNavigationTool(int pageno, int size, int max, String searchPlusScan, JspWriter out) throws IOException {
        int lastPage;
        int firstPage;
        int NUMBER_INDICES_TO_SHOW = 5;
        int numIndexToShow = 5;
        out.print("<center> <");
        if (pageno > 1) {
            out.println("<a href=\"jobhistoryhome.jsp?pageno=" + (pageno - 1) + searchPlusScan + "\">Previous</a>");
        }
        if ((firstPage = pageno - numIndexToShow) < 1) {
            firstPage = 1;
        }
        if ((lastPage = pageno + numIndexToShow) > max) {
            lastPage = max;
        }
        out.println("<!--DEBUG : firstPage : " + firstPage + ", lastPage : " + lastPage + " -->");
        for (int i = firstPage; i <= lastPage; ++i) {
            if (i != pageno) {
                out.println(" <a href=\"jobhistoryhome.jsp?pageno=" + i + searchPlusScan + "\">" + i + "</a> ");
                continue;
            }
            out.println(i);
        }
        if (pageno < max) {
            out.println("<a href=\"jobhistoryhome.jsp?pageno=" + (pageno + 1) + searchPlusScan + "\">Next</a>");
        }
        out.print("></center>");
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block38: {
            int maxPageNo;
            int size;
            int pageno;
            long lengthEstimate;
            boolean sizeIsExact;
            Path[] jobFiles;
            int numHistoryFiles;
            String dateComponent;
            Comparator<Path> latestFirstCreationTimeComparator;
            String rawJobname;
            int currentScanSizeIndex;
            String rawUser;
            String soughtDate;
            String search;
            int[] SCAN_SIZES;
            PageContext _jspx_page_context;
            JspWriter _jspx_out;
            JspWriter out;
            block37: {
                block35: {
                    block36: {
                        String historyLogDir;
                        FileSystem fs;
                        PathFilter jobLogFileFilter;
                        Pattern dateSearchParse;
                        block34: {
                            String trackerUrl;
                            String trackerName;
                            PageContext pageContext = null;
                            HttpSession session = null;
                            ServletContext application = null;
                            ServletConfig config = null;
                            out = null;
                            jobhistoryhome_jsp page = this;
                            _jspx_out = null;
                            _jspx_page_context = null;
                            response.setContentType("text/html; charset=UTF-8");
                            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)((Object)this), (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                            application = pageContext.getServletContext();
                            config = pageContext.getServletConfig();
                            session = pageContext.getSession();
                            _jspx_out = out = pageContext.getOut();
                            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                            out.write(10);
                            JobConf jobConf = (JobConf)application.getAttribute("jobConf");
                            String trackerAddress = jobConf.get("mapred.job.tracker.http.address");
                            InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(trackerAddress);
                            if (JobHistoryServer.isEmbedded(jobConf)) {
                                trackerName = StringUtils.simpleHostname(InetAddress.getLocalHost().getCanonicalHostName());
                                trackerUrl = "";
                            } else {
                                trackerUrl = "http://" + trackerAddress;
                                trackerName = StringUtils.simpleHostname(infoSocAddr.getHostName());
                            }
                            out.write(10);
                            out.write(10);
                            out.write("\n<html>\n<head>\n<script type=\"text/JavaScript\">\n<!--\nfunction showUserHistory(search)\n{\nvar url\nif (search == null || \"\".equals(search)) {\n  url=\"jobhistoryhome.jsp\";\n} else {\n  url=\"jobhistoryhome.jsp?pageno=1&search=\" + search;\n}\nwindow.location.href = url;\n}\n//-->\n</script>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<title>");
                            out.print(trackerName);
                            out.write(" Hadoop Map/Reduce History Viewer</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n</head>\n<body>\n<h1> <a href=\"");
                            out.print(trackerUrl);
                            out.write("/jobtracker.jsp\">");
                            out.print(trackerName);
                            out.write("</a> Hadoop Map/Reduce\n     <a href=\"jobhistoryhome.jsp\">History Viewer</a></h1>\n<hr>\n");
                            boolean JOB_ID_START = false;
                            int FILENAME_JOBID_END = 3;
                            int FILENAME_SUBMIT_TIMESTAMP_PART = 3;
                            int FILENAME_USER_PART = 4;
                            int FILENAME_JOBNAME_PART = 5;
                            SCAN_SIZES = new int[]{20, 50, 200, 1000};
                            int FILES_PER_SCAN = 1000;
                            int DEFAULT_PAGE_SIZE = 100;
                            String DEFAULT_DATE_GLOB_COMPONENT = "*/*/*";
                            String SERIAL_NUMBER_GLOB_COMPONENT = "/*";
                            search = request.getParameter("search") == null ? "" : request.getParameter("search");
                            String[] dateSplit = search.split(";");
                            soughtDate = dateSplit.length > 1 ? dateSplit[1] : "";
                            String[] parts = dateSplit[0].split(":");
                            rawUser = parts.length >= 1 ? parts[0].toLowerCase() : "";
                            final String userInFname = this.escapeUnderscores(JobHistory.JobInfo.encodeJobHistoryFileName(HtmlQuoting.unquoteHtmlChars(rawUser))).toLowerCase();
                            currentScanSizeIndex = request.getParameter("scansize") == null ? 0 : Math.min(Integer.parseInt(request.getParameter("scansize")), SCAN_SIZES.length - 1);
                            String SEARCH_PARSE_REGEX = "([0-1]?[0-9])/([0-3]?[0-9])/((?:2[0-9])[0-9][0-9])";
                            dateSearchParse = Pattern.compile("([0-1]?[0-9])/([0-3]?[0-9])/((?:2[0-9])[0-9][0-9])");
                            rawJobname = parts.length >= 2 ? parts[1].toLowerCase() : "";
                            final String jobnameKeywordInFname = this.escapeUnderscores(JobHistory.JobInfo.encodeJobHistoryFileName(HtmlQuoting.unquoteHtmlChars(rawJobname))).toLowerCase();
                            jobLogFileFilter = new PathFilter(){

                                private boolean matchUser(String fileName) {
                                    return "".equals(userInFname) || userInFname.equals(fileName.split("_")[4].toLowerCase());
                                }

                                private boolean matchJobName(String fileName) {
                                    return "".equals(jobnameKeywordInFname) || fileName.split("_")[5].toLowerCase().contains(jobnameKeywordInFname);
                                }

                                @Override
                                public boolean accept(Path path) {
                                    String name = path.getName();
                                    return !name.endsWith(".xml") && this.matchUser(name) && this.matchJobName(name);
                                }
                            };
                            fs = (FileSystem)application.getAttribute("fileSys");
                            historyLogDir = (String)application.getAttribute("historyLogDir");
                            if (fs != null) break block34;
                            out.println("Null file system. May be namenode is in safemode!");
                            _jspxFactory.releasePageContext(_jspx_page_context);
                            return;
                        }
                        Comparator<FileStatus> mtimeComparator = new Comparator<FileStatus>(){

                            @Override
                            public int compare(FileStatus status1, FileStatus status2) {
                                Long time1 = new Long(status1.getModificationTime());
                                Long time2 = new Long(status2.getModificationTime());
                                return time2.compareTo(time1);
                            }
                        };
                        latestFirstCreationTimeComparator = new Comparator<Path>(){

                            @Override
                            public int compare(Path p1, Path p2) {
                                String dp1 = null;
                                String dp2 = null;
                                try {
                                    dp1 = JobHistory.JobInfo.decodeJobHistoryFileName(p1.getName());
                                    dp2 = JobHistory.JobInfo.decodeJobHistoryFileName(p2.getName());
                                }
                                catch (IOException ioe) {
                                    throw new RuntimeException(ioe);
                                }
                                String[] split1 = dp1.split("_");
                                String[] split2 = dp2.split("_");
                                int res = new Date(Long.parseLong(split2[1])).compareTo(new Date(Long.parseLong(split1[1])));
                                if (res == 0) {
                                    res = new Date(Long.parseLong(split2[3])).compareTo(new Date(Long.parseLong(split1[3])));
                                }
                                if (res == 0) {
                                    Long l1 = Long.parseLong(split2[2]);
                                    res = l1.compareTo(Long.parseLong(split1[2]));
                                }
                                return res;
                            }
                        };
                        String versionComponent = "version-1";
                        String trackerComponent = "*";
                        dateComponent = "*/*/*";
                        Matcher dateMatcher = dateSearchParse.matcher(soughtDate);
                        if (dateMatcher.matches()) {
                            String date;
                            String month;
                            String year = dateMatcher.group(3);
                            if (year.length() == 2) {
                                year = "20" + year;
                            }
                            if ((month = dateMatcher.group(1)).length() == 1) {
                                month = "0" + month;
                            }
                            if ((date = dateMatcher.group(2)).length() == 1) {
                                date = "0" + date;
                            }
                            dateComponent = year + "/" + month + "/" + date;
                        }
                        Path historyPath = new Path(historyLogDir);
                        String leadGlob = versionComponent + "/" + trackerComponent + "/" + dateComponent;
                        AtomicBoolean hasLegacyFiles = new AtomicBoolean(false);
                        FileStatus[] buckets = JobHistory.localGlobber(fs, historyPath, "/" + leadGlob, null, hasLegacyFiles);
                        Arrays.sort(buckets, mtimeComparator);
                        int arrayLimit = SCAN_SIZES[currentScanSizeIndex] > buckets.length ? buckets.length : SCAN_SIZES[currentScanSizeIndex];
                        FileStatus[] scanSizeBuckets = Arrays.copyOf(buckets, arrayLimit);
                        Path[] snPaths = FileUtil.stat2Paths(scanSizeBuckets);
                        numHistoryFiles = 0;
                        jobFiles = null;
                        Path[][] pathVectorVector = new Path[arrayLimit][];
                        for (int i = 0; i < arrayLimit; ++i) {
                            pathVectorVector[i] = FileUtil.stat2Paths(fs.listStatus(snPaths[i], jobLogFileFilter));
                            numHistoryFiles += pathVectorVector[i].length;
                        }
                        jobFiles = new Path[numHistoryFiles];
                        int pathsCursor = 0;
                        for (int i = 0; i < arrayLimit; ++i) {
                            System.arraycopy(pathVectorVector[i], 0, jobFiles, pathsCursor, pathVectorVector[i].length);
                            pathsCursor += pathVectorVector[i].length;
                        }
                        sizeIsExact = arrayLimit == snPaths.length;
                        long l = lengthEstimate = sizeIsExact ? (long)numHistoryFiles : (long)numHistoryFiles * (long)snPaths.length / (long)arrayLimit;
                        if (hasLegacyFiles.get()) {
                            out.println("<h2>This history has some legacy files.  <a href=\"legacyjobhistory.jsp\">go to Legacy History Viewer</a></h2>");
                        }
                        out.println("<!--  user : " + rawUser + ", jobname : " + rawJobname + "-->");
                        String searchMore = "&search=" + search;
                        if (null != jobFiles && jobFiles.length != 0) break block35;
                        if (currentScanSizeIndex < SCAN_SIZES.length - 1) {
                            out.println(" [<span class=\"small\"><a href=\"jobhistoryhome.jsp?pageno=1" + searchMore + "&scansize=" + (currentScanSizeIndex + 1) + "\">No files found - try and get more results</a></span>]");
                            break block36;
                        }
                        out.println("No files found!");
                    }
                    _jspxFactory.releasePageContext(_jspx_page_context);
                    return;
                }
                pageno = request.getParameter("pageno") == null ? 1 : Integer.parseInt(request.getParameter("pageno"));
                size = 100;
                if (pageno == -1 || size > jobFiles.length) {
                    size = jobFiles.length;
                }
                if (pageno == -1) {
                    pageno = 1;
                }
                maxPageNo = (jobFiles.length + size - 1) / size;
                if (pageno >= 1 && pageno <= maxPageNo) break block37;
                out.println("Invalid page index");
                _jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
            try {
                int length = size;
                if (pageno == maxPageNo) {
                    int startOnLast = (pageno - 1) * size + 1;
                    length = jobFiles.length - startOnLast + 1;
                }
                out.println("<form name=search><b> Filter (username:jobname) </b>");
                out.println("<input type=text name=search size=\"20\" value=\"" + search + "\">");
                out.println("<input type=submit value=\"Filter!\" onClick=\"showUserHistory(document.getElementById('search').value)\"></form>");
                out.println("<p><span class=\"small\">Specify [user][:jobname keyword(s)][;MM/DD/YYYY] .  Each of the three components is optional.  Filter components are conjunctive.</span></p>");
                out.println("<p><span class=\"small\">Example: 'smith' will display jobs submitted by user 'smith'. 'smith:sort' will display jobs from user 'smith' having a 'sort' keyword in the jobname. ';07/04/2010' restricts to July 4, 2010</span></p>");
                out.println("<hr>");
                int start = (pageno - 1) * size + 1;
                out.println("<!-- pageno : " + pageno + ", size : " + size + ", length : " + length + ", start : " + start + ", maxpg : " + maxPageNo + "-->");
                out.println("<font size=5><b>Available Jobs in History </b></font>");
                out.println("(<i> <span class=\"small\">Displaying <b>" + length + "</b> jobs from <b>" + start + "</b> to <b>" + (start + length - 1) + "</b> out of " + (sizeIsExact ? "" : "approximately ") + "<b>" + lengthEstimate + "</b> jobs" + (sizeIsExact ? "" : ", <b>" + numHistoryFiles + "</b> gotten"));
                if (!"".equals(rawUser)) {
                    out.println(" for user <b>" + rawUser + "</b>");
                }
                if (!"".equals(rawJobname)) {
                    out.println(" with jobname having the keyword <b>" + rawJobname + "</b> in it.");
                }
                if (!"*/*/*".equals(dateComponent)) {
                    out.println(" for the date <b>" + soughtDate + "</b>");
                }
                out.print("</span></i>)");
                String searchPart = "&search=" + search;
                String scansizePart = "&scansize=" + currentScanSizeIndex;
                String searchPlusScan = searchPart + scansizePart;
                if (currentScanSizeIndex == SCAN_SIZES.length - 1) {
                    out.println("[<span class=\"small\">get more results</span>]");
                } else {
                    out.println(" [<span class=\"small\"><a href=\"jobhistoryhome.jsp?pageno=1" + searchPart + "&scansize=" + (currentScanSizeIndex + 1) + "\">get more results</a></span>]");
                }
                out.println(" [<span class=\"small\"><a href=\"jobhistoryhome.jsp?pageno=-1" + searchPlusScan + "\">show in one page</a></span>]");
                if (pageno > 1) {
                    out.println(" [<span class=\"small\"><a href=\"jobhistoryhome.jsp?pageno=1" + searchPlusScan + "\">first page</a></span>]");
                } else {
                    out.println("[<span class=\"small\">first page]</span>");
                }
                if (pageno < maxPageNo) {
                    out.println(" [<span class=\"small\"><a href=\"jobhistoryhome.jsp?pageno=" + maxPageNo + searchPlusScan + "\">last page</a></span>]");
                } else {
                    out.println("<span class=\"small\">[last page]</span>");
                }
                Arrays.sort(jobFiles, latestFirstCreationTimeComparator);
                out.println("<br><br>");
                this.printNavigationTool(pageno, size, maxPageNo, searchPlusScan, out);
                out.print("<table align=center border=2 cellpadding=\"5\" cellspacing=\"2\">");
                out.print("<tr>");
                out.print("<td>Job submit time</td><td>Job Id</td><td>Name</td><td>User</td>");
                out.print("</tr>");
                HashSet<String> displayedJobs = new HashSet<String>();
                for (int i = start - 1; i < start + length - 1; ++i) {
                    Path jobFile = jobFiles[i];
                    String fname = jobFile.getName();
                    String marker = JobHistory.nonOccursString(fname);
                    String reescapedFname = JobHistory.replaceStringInstances(fname, "%5F", marker);
                    String decodedJobFileName = JobHistory.JobInfo.decodeJobHistoryFileName(reescapedFname);
                    String[] jobDetails = decodedJobFileName.split("_");
                    String trackerStartTime = jobDetails[1];
                    String jobId = jobDetails[0] + "_" + jobDetails[1] + "_" + jobDetails[2];
                    String submitTimestamp = jobDetails[3];
                    String userName = JobHistory.replaceStringInstances(jobDetails[4], marker, "%5F");
                    String jobName = JobHistory.replaceStringInstances(jobDetails[5], marker, "%5F");
                    if (displayedJobs.contains(jobId)) continue;
                    displayedJobs.add(jobId);
                    String preEncodedJobFileName = JobHistory.JobInfo.encodeJobHistoryFileName(jobFile.getName());
                    String encodedJobFileName = JobHistory.replaceStringInstances(preEncodedJobFileName, "%5F", "%255F");
                    out.write("\n<center>\n");
                    this.printJob(submitTimestamp, jobId, jobName, userName, new Path(jobFile.getParent(), encodedJobFileName), out);
                    out.write("\n</center> \n");
                }
                out.print("</table>");
                this.printNavigationTool(pageno, size, maxPageNo, searchPlusScan, out);
                out.write(10);
                out.write(" \n</body></html>\n");
            }
            catch (Throwable t) {
                try {
                    if (!(t instanceof SkipPageException)) {
                        out = _jspx_out;
                        if (out != null && out.getBufferSize() != 0) {
                            out.clearBuffer();
                        }
                        if (_jspx_page_context != null) {
                            _jspx_page_context.handlePageException(t);
                        }
                    }
                    break block38;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }
}

