/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.ipc.trace.AvroTrace;
import org.apache.avro.ipc.trace.FileSpanStorage;
import org.apache.avro.ipc.trace.ID;
import org.apache.avro.ipc.trace.InMemorySpanStorage;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.SpanStorage;
import org.apache.avro.ipc.trace.StaticServlet;
import org.apache.avro.ipc.trace.TimestampedEvent;
import org.apache.avro.ipc.trace.TraceClientServlet;
import org.apache.avro.ipc.trace.TracePluginConfiguration;
import org.apache.avro.ipc.trace.Util;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracePlugin
extends RPCPlugin {
    private static final Random RANDOM = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(TracePlugin.class);
    protected static TracePlugin singleton;
    protected static TracePluginConfiguration singletonConf;
    private static final String TRACE_ID_KEY = "traceID";
    private static final String SPAN_ID_KEY = "spanID";
    private static final String PARENT_SPAN_ID_KEY = "parentSpanID";
    private double traceProb;
    private int port;
    private int clientPort;
    private StorageType storageType;
    private long maxSpans;
    private boolean enabled;
    protected TracePluginConfiguration config;
    private ThreadLocal<Span> currentSpan;
    private ThreadLocal<Span> childSpan;
    protected SpanStorage storage;
    protected HttpServer httpServer;
    protected SpecificResponder responder;
    protected Server clientFacingServer;
    private String hostname;

    public static synchronized TracePlugin getSingleton() throws IOException {
        if (singletonConf == null) {
            throw new RuntimeException("Singleton not configured yet.");
        }
        singleton = new TracePlugin(singletonConf);
        return singleton;
    }

    public static synchronized void configureSingleton(TracePluginConfiguration conf) {
        if (singleton != null && !TracePlugin.singleton.config.equals(conf)) {
            throw new RuntimeException("Singleton already in use: can't reconfigure.");
        }
        singletonConf = conf;
    }

    public TracePlugin(TracePluginConfiguration conf) throws IOException {
        this.config = conf;
        this.traceProb = conf.traceProb;
        this.port = conf.port;
        this.clientPort = conf.clientPort;
        this.storageType = conf.storageType;
        this.maxSpans = conf.maxSpans;
        this.enabled = conf.enabled;
        if (!(this.traceProb >= 0.0) || !(this.traceProb <= 1.0)) {
            this.traceProb = 0.0;
        }
        if (this.port <= 0 || this.port >= 65535) {
            this.port = 51001;
        }
        if (this.clientPort <= 0 || this.clientPort >= 65535) {
            this.clientPort = 51200;
        }
        if (this.maxSpans < 0L) {
            this.maxSpans = 5000L;
        }
        try {
            this.hostname = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            this.hostname = "Unknown";
        }
        this.currentSpan = new ThreadLocal<Span>(){

            @Override
            protected Span initialValue() {
                return null;
            }
        };
        this.childSpan = new ThreadLocal<Span>(){

            @Override
            protected Span initialValue() {
                return null;
            }
        };
        this.storage = this.storageType == StorageType.MEMORY ? new InMemorySpanStorage() : (this.storageType == StorageType.DISK ? new FileSpanStorage(false, conf) : new InMemorySpanStorage());
        this.storage.setMaxSpans(this.maxSpans);
        this.responder = new SpecificResponder(AvroTrace.PROTOCOL, (Object)new TraceResponder(this.storage));
        boolean bound = false;
        while (!bound) {
            try {
                this.httpServer = new HttpServer((Responder)this.responder, this.port);
                this.httpServer.start();
                bound = true;
            }
            catch (AvroRuntimeException e) {
                if (e.getCause() instanceof BindException) {
                    LOG.error("Failed to bind to port: " + this.port);
                    ++this.port;
                    continue;
                }
                throw e;
            }
        }
        this.initializeClientServer();
    }

    @Override
    public void clientStartConnect(RPCContext context) {
        Span span;
        if (this.currentSpan.get() == null && (double)RANDOM.nextFloat() < this.traceProb && this.enabled) {
            span = Util.createEventlessSpan(null, null, null);
            span.requestorHostname = this.hostname;
            this.childSpan.set(span);
        }
        if (this.currentSpan.get() != null && this.enabled) {
            Span currSpan = this.currentSpan.get();
            Span span2 = Util.createEventlessSpan(currSpan.traceID, null, currSpan.spanID);
            span2.requestorHostname = this.hostname;
            this.childSpan.set(span2);
        }
        if (this.childSpan.get() != null) {
            span = this.childSpan.get();
            context.requestHandshakeMeta().put(TRACE_ID_KEY, ByteBuffer.wrap(span.traceID.bytes()));
            context.requestHandshakeMeta().put(SPAN_ID_KEY, ByteBuffer.wrap(span.spanID.bytes()));
            if (span.parentSpanID != null) {
                context.requestHandshakeMeta().put(PARENT_SPAN_ID_KEY, ByteBuffer.wrap(span.parentSpanID.bytes()));
            }
        }
    }

    @Override
    public void serverConnecting(RPCContext context) {
        Map<String, ByteBuffer> meta = context.requestHandshakeMeta();
        if (meta.containsKey(TRACE_ID_KEY) && this.enabled) {
            if (!meta.containsKey(SPAN_ID_KEY)) {
                LOG.warn("Span ID missing for trace " + meta.get(TRACE_ID_KEY).toString());
                return;
            }
            byte[] spanIDBytes = new byte[8];
            meta.get(SPAN_ID_KEY).get(spanIDBytes);
            ID spanID = new ID();
            spanID.bytes(spanIDBytes);
            ID parentSpanID = null;
            if (meta.get(PARENT_SPAN_ID_KEY) != null) {
                parentSpanID = new ID();
                parentSpanID.bytes(meta.get(PARENT_SPAN_ID_KEY).array());
            }
            ID traceID = new ID();
            traceID.bytes(meta.get(TRACE_ID_KEY).array());
            Span span = Util.createEventlessSpan(traceID, spanID, parentSpanID);
            span.responderHostname = this.hostname;
            span.events = new GenericData.Array<TimestampedEvent>(100, Schema.createArray(TimestampedEvent.SCHEMA$));
            this.currentSpan.set(span);
        }
    }

    @Override
    public void clientFinishConnect(RPCContext context) {
    }

    @Override
    public void clientSendRequest(RPCContext context) {
        if (this.childSpan.get() != null) {
            Span child = this.childSpan.get();
            Util.addEvent(child, SpanEvent.CLIENT_SEND);
            child.messageName = context.getMessage().getName();
            child.requestPayloadSize = Util.getPayloadSize(context.getRequestPayload());
        }
    }

    @Override
    public void serverReceiveRequest(RPCContext context) {
        if (this.currentSpan.get() != null) {
            Span current = this.currentSpan.get();
            Util.addEvent(current, SpanEvent.SERVER_RECV);
            current.messageName = context.getMessage().getName();
            current.requestPayloadSize = Util.getPayloadSize(context.getRequestPayload());
        }
    }

    @Override
    public void serverSendResponse(RPCContext context) {
        if (this.currentSpan.get() != null) {
            Span current = this.currentSpan.get();
            Util.addEvent(current, SpanEvent.SERVER_SEND);
            current.responsePayloadSize = Util.getPayloadSize(context.getResponsePayload());
            this.storage.addSpan(this.currentSpan.get());
            this.currentSpan.set(null);
        }
    }

    @Override
    public void clientReceiveResponse(RPCContext context) {
        if (this.childSpan.get() != null) {
            Span child = this.childSpan.get();
            Util.addEvent(child, SpanEvent.CLIENT_RECV);
            child.responsePayloadSize = Util.getPayloadSize(context.getResponsePayload());
            this.storage.addSpan(this.childSpan.get());
            this.childSpan.set(null);
        }
    }

    public void stopClientServer() {
        try {
            this.clientFacingServer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initializeClientServer() {
        this.clientFacingServer = new Server();
        Context staticContext = new Context(this.clientFacingServer, "/static");
        staticContext.addServlet(new ServletHolder(new StaticServlet()), "/");
        Context context = new Context(this.clientFacingServer, "/");
        context.addServlet(new ServletHolder(new TraceClientServlet()), "/");
        boolean connected = false;
        SocketConnector socket = null;
        while (!connected) {
            try {
                socket = new SocketConnector();
                socket.setPort(this.clientPort);
                this.clientFacingServer.addConnector(socket);
                this.clientFacingServer.start();
                connected = true;
            }
            catch (Exception e) {
                if (!(e instanceof BindException)) break;
                this.clientFacingServer.removeConnector(socket);
                ++this.clientPort;
            }
        }
    }

    class TraceResponder
    implements AvroTrace {
        private SpanStorage spanStorage;

        public TraceResponder(SpanStorage spanStorage) {
            this.spanStorage = spanStorage;
        }

        @Override
        public List<Span> getAllSpans() throws AvroRemoteException {
            return this.spanStorage.getAllSpans();
        }

        @Override
        public List<Span> getSpansInRange(long start, long end) throws AvroRemoteException {
            return this.spanStorage.getSpansInRange(start, end);
        }
    }

    public static enum StorageType {
        MEMORY,
        DISK;

    }
}

