// Auto-generated by avdl-compiler v1.3.20 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/keybase1/teams.avdl

package keybase1

import (
	"errors"
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type TeamRole int

const (
	TeamRole_NONE   TeamRole = 0
	TeamRole_READER TeamRole = 1
	TeamRole_WRITER TeamRole = 2
	TeamRole_ADMIN  TeamRole = 3
	TeamRole_OWNER  TeamRole = 4
)

func (o TeamRole) DeepCopy() TeamRole { return o }

var TeamRoleMap = map[string]TeamRole{
	"NONE":   0,
	"READER": 1,
	"WRITER": 2,
	"ADMIN":  3,
	"OWNER":  4,
}

var TeamRoleRevMap = map[TeamRole]string{
	0: "NONE",
	1: "READER",
	2: "WRITER",
	3: "ADMIN",
	4: "OWNER",
}

func (e TeamRole) String() string {
	if v, ok := TeamRoleRevMap[e]; ok {
		return v
	}
	return ""
}

type TeamApplication int

const (
	TeamApplication_KBFS         TeamApplication = 1
	TeamApplication_CHAT         TeamApplication = 2
	TeamApplication_SALTPACK     TeamApplication = 3
	TeamApplication_GIT_METADATA TeamApplication = 4
)

func (o TeamApplication) DeepCopy() TeamApplication { return o }

var TeamApplicationMap = map[string]TeamApplication{
	"KBFS":         1,
	"CHAT":         2,
	"SALTPACK":     3,
	"GIT_METADATA": 4,
}

var TeamApplicationRevMap = map[TeamApplication]string{
	1: "KBFS",
	2: "CHAT",
	3: "SALTPACK",
	4: "GIT_METADATA",
}

func (e TeamApplication) String() string {
	if v, ok := TeamApplicationRevMap[e]; ok {
		return v
	}
	return ""
}

type PerTeamKeyGeneration int

func (o PerTeamKeyGeneration) DeepCopy() PerTeamKeyGeneration {
	return o
}

type TeamApplicationKey struct {
	Application   TeamApplication      `codec:"application" json:"application"`
	KeyGeneration PerTeamKeyGeneration `codec:"keyGeneration" json:"keyGeneration"`
	Key           Bytes32              `codec:"key" json:"key"`
}

func (o TeamApplicationKey) DeepCopy() TeamApplicationKey {
	return TeamApplicationKey{
		Application:   o.Application.DeepCopy(),
		KeyGeneration: o.KeyGeneration.DeepCopy(),
		Key:           o.Key.DeepCopy(),
	}
}

type MaskB64 []byte

func (o MaskB64) DeepCopy() MaskB64 {
	return (func(x []byte) []byte {
		if x == nil {
			return nil
		}
		return append([]byte{}, x...)
	})(o)
}

type TeamInviteID string

func (o TeamInviteID) DeepCopy() TeamInviteID {
	return o
}

type ReaderKeyMask struct {
	Application TeamApplication      `codec:"application" json:"application"`
	Generation  PerTeamKeyGeneration `codec:"generation" json:"generation"`
	Mask        MaskB64              `codec:"mask" json:"mask"`
}

func (o ReaderKeyMask) DeepCopy() ReaderKeyMask {
	return ReaderKeyMask{
		Application: o.Application.DeepCopy(),
		Generation:  o.Generation.DeepCopy(),
		Mask:        o.Mask.DeepCopy(),
	}
}

type PerTeamKey struct {
	Gen    PerTeamKeyGeneration `codec:"gen" json:"gen"`
	Seqno  Seqno                `codec:"seqno" json:"seqno"`
	SigKID KID                  `codec:"sigKID" json:"sigKID"`
	EncKID KID                  `codec:"encKID" json:"encKID"`
}

func (o PerTeamKey) DeepCopy() PerTeamKey {
	return PerTeamKey{
		Gen:    o.Gen.DeepCopy(),
		Seqno:  o.Seqno.DeepCopy(),
		SigKID: o.SigKID.DeepCopy(),
		EncKID: o.EncKID.DeepCopy(),
	}
}

type PerTeamKeySeed [32]byte

func (o PerTeamKeySeed) DeepCopy() PerTeamKeySeed {
	var ret PerTeamKeySeed
	copy(ret[:], o[:])
	return ret
}

type PerTeamKeySeedItem struct {
	Seed       PerTeamKeySeed       `codec:"seed" json:"seed"`
	Generation PerTeamKeyGeneration `codec:"generation" json:"generation"`
	Seqno      Seqno                `codec:"seqno" json:"seqno"`
}

func (o PerTeamKeySeedItem) DeepCopy() PerTeamKeySeedItem {
	return PerTeamKeySeedItem{
		Seed:       o.Seed.DeepCopy(),
		Generation: o.Generation.DeepCopy(),
		Seqno:      o.Seqno.DeepCopy(),
	}
}

type TeamMember struct {
	Uid         UID      `codec:"uid" json:"uid"`
	Role        TeamRole `codec:"role" json:"role"`
	EldestSeqno Seqno    `codec:"eldestSeqno" json:"eldestSeqno"`
}

func (o TeamMember) DeepCopy() TeamMember {
	return TeamMember{
		Uid:         o.Uid.DeepCopy(),
		Role:        o.Role.DeepCopy(),
		EldestSeqno: o.EldestSeqno.DeepCopy(),
	}
}

type TeamMembers struct {
	Owners  []UserVersion `codec:"owners" json:"owners"`
	Admins  []UserVersion `codec:"admins" json:"admins"`
	Writers []UserVersion `codec:"writers" json:"writers"`
	Readers []UserVersion `codec:"readers" json:"readers"`
}

func (o TeamMembers) DeepCopy() TeamMembers {
	return TeamMembers{
		Owners: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Owners),
		Admins: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Admins),
		Writers: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Writers),
		Readers: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Readers),
	}
}

type TeamMemberDetails struct {
	Uv       UserVersion `codec:"uv" json:"uv"`
	Username string      `codec:"username" json:"username"`
	Active   bool        `codec:"active" json:"active"`
}

func (o TeamMemberDetails) DeepCopy() TeamMemberDetails {
	return TeamMemberDetails{
		Uv:       o.Uv.DeepCopy(),
		Username: o.Username,
		Active:   o.Active,
	}
}

type TeamMembersDetails struct {
	Owners  []TeamMemberDetails `codec:"owners" json:"owners"`
	Admins  []TeamMemberDetails `codec:"admins" json:"admins"`
	Writers []TeamMemberDetails `codec:"writers" json:"writers"`
	Readers []TeamMemberDetails `codec:"readers" json:"readers"`
}

func (o TeamMembersDetails) DeepCopy() TeamMembersDetails {
	return TeamMembersDetails{
		Owners: (func(x []TeamMemberDetails) []TeamMemberDetails {
			if x == nil {
				return nil
			}
			var ret []TeamMemberDetails
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Owners),
		Admins: (func(x []TeamMemberDetails) []TeamMemberDetails {
			if x == nil {
				return nil
			}
			var ret []TeamMemberDetails
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Admins),
		Writers: (func(x []TeamMemberDetails) []TeamMemberDetails {
			if x == nil {
				return nil
			}
			var ret []TeamMemberDetails
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Writers),
		Readers: (func(x []TeamMemberDetails) []TeamMemberDetails {
			if x == nil {
				return nil
			}
			var ret []TeamMemberDetails
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Readers),
	}
}

type TeamDetails struct {
	Members                TeamMembersDetails                   `codec:"members" json:"members"`
	KeyGeneration          PerTeamKeyGeneration                 `codec:"keyGeneration" json:"keyGeneration"`
	AnnotatedActiveInvites map[TeamInviteID]AnnotatedTeamInvite `codec:"annotatedActiveInvites" json:"annotatedActiveInvites"`
}

func (o TeamDetails) DeepCopy() TeamDetails {
	return TeamDetails{
		Members:       o.Members.DeepCopy(),
		KeyGeneration: o.KeyGeneration.DeepCopy(),
		AnnotatedActiveInvites: (func(x map[TeamInviteID]AnnotatedTeamInvite) map[TeamInviteID]AnnotatedTeamInvite {
			if x == nil {
				return nil
			}
			ret := make(map[TeamInviteID]AnnotatedTeamInvite)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := v.DeepCopy()
				ret[kCopy] = vCopy
			}
			return ret
		})(o.AnnotatedActiveInvites),
	}
}

type UserVersion struct {
	Uid         UID   `codec:"uid" json:"uid"`
	EldestSeqno Seqno `codec:"eldestSeqno" json:"eldestSeqno"`
}

func (o UserVersion) DeepCopy() UserVersion {
	return UserVersion{
		Uid:         o.Uid.DeepCopy(),
		EldestSeqno: o.EldestSeqno.DeepCopy(),
	}
}

type UserVersionPercentForm string

func (o UserVersionPercentForm) DeepCopy() UserVersionPercentForm {
	return o
}

type TeamChangeReq struct {
	Owners           []UserVersion                           `codec:"owners" json:"owners"`
	Admins           []UserVersion                           `codec:"admins" json:"admins"`
	Writers          []UserVersion                           `codec:"writers" json:"writers"`
	Readers          []UserVersion                           `codec:"readers" json:"readers"`
	None             []UserVersion                           `codec:"none" json:"none"`
	CompletedInvites map[TeamInviteID]UserVersionPercentForm `codec:"completedInvites" json:"completedInvites"`
}

func (o TeamChangeReq) DeepCopy() TeamChangeReq {
	return TeamChangeReq{
		Owners: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Owners),
		Admins: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Admins),
		Writers: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Writers),
		Readers: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Readers),
		None: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.None),
		CompletedInvites: (func(x map[TeamInviteID]UserVersionPercentForm) map[TeamInviteID]UserVersionPercentForm {
			if x == nil {
				return nil
			}
			ret := make(map[TeamInviteID]UserVersionPercentForm)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := v.DeepCopy()
				ret[kCopy] = vCopy
			}
			return ret
		})(o.CompletedInvites),
	}
}

type TeamPlusApplicationKeys struct {
	Id              TeamID               `codec:"id" json:"id"`
	Name            string               `codec:"name" json:"name"`
	Implicit        bool                 `codec:"implicit" json:"implicit"`
	Public          bool                 `codec:"public" json:"public"`
	Application     TeamApplication      `codec:"application" json:"application"`
	Writers         []UserVersion        `codec:"writers" json:"writers"`
	OnlyReaders     []UserVersion        `codec:"onlyReaders" json:"onlyReaders"`
	ApplicationKeys []TeamApplicationKey `codec:"applicationKeys" json:"applicationKeys"`
}

func (o TeamPlusApplicationKeys) DeepCopy() TeamPlusApplicationKeys {
	return TeamPlusApplicationKeys{
		Id:          o.Id.DeepCopy(),
		Name:        o.Name,
		Implicit:    o.Implicit,
		Public:      o.Public,
		Application: o.Application.DeepCopy(),
		Writers: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Writers),
		OnlyReaders: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.OnlyReaders),
		ApplicationKeys: (func(x []TeamApplicationKey) []TeamApplicationKey {
			if x == nil {
				return nil
			}
			var ret []TeamApplicationKey
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.ApplicationKeys),
	}
}

type TeamData struct {
	Secretless      bool                                                 `codec:"secretless" json:"secretless"`
	Name            TeamName                                             `codec:"name" json:"name"`
	Chain           TeamSigChainState                                    `codec:"chain" json:"chain"`
	PerTeamKeySeeds map[PerTeamKeyGeneration]PerTeamKeySeedItem          `codec:"perTeamKeySeeds" json:"perTeamKeySeeds"`
	ReaderKeyMasks  map[TeamApplication]map[PerTeamKeyGeneration]MaskB64 `codec:"readerKeyMasks" json:"readerKeyMasks"`
	CachedAt        Time                                                 `codec:"cachedAt" json:"cachedAt"`
}

func (o TeamData) DeepCopy() TeamData {
	return TeamData{
		Secretless: o.Secretless,
		Name:       o.Name.DeepCopy(),
		Chain:      o.Chain.DeepCopy(),
		PerTeamKeySeeds: (func(x map[PerTeamKeyGeneration]PerTeamKeySeedItem) map[PerTeamKeyGeneration]PerTeamKeySeedItem {
			if x == nil {
				return nil
			}
			ret := make(map[PerTeamKeyGeneration]PerTeamKeySeedItem)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := v.DeepCopy()
				ret[kCopy] = vCopy
			}
			return ret
		})(o.PerTeamKeySeeds),
		ReaderKeyMasks: (func(x map[TeamApplication]map[PerTeamKeyGeneration]MaskB64) map[TeamApplication]map[PerTeamKeyGeneration]MaskB64 {
			if x == nil {
				return nil
			}
			ret := make(map[TeamApplication]map[PerTeamKeyGeneration]MaskB64)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := (func(x map[PerTeamKeyGeneration]MaskB64) map[PerTeamKeyGeneration]MaskB64 {
					if x == nil {
						return nil
					}
					ret := make(map[PerTeamKeyGeneration]MaskB64)
					for k, v := range x {
						kCopy := k.DeepCopy()
						vCopy := v.DeepCopy()
						ret[kCopy] = vCopy
					}
					return ret
				})(v)
				ret[kCopy] = vCopy
			}
			return ret
		})(o.ReaderKeyMasks),
		CachedAt: o.CachedAt.DeepCopy(),
	}
}

type TeamInviteCategory int

const (
	TeamInviteCategory_NONE    TeamInviteCategory = 0
	TeamInviteCategory_UNKNOWN TeamInviteCategory = 1
	TeamInviteCategory_KEYBASE TeamInviteCategory = 2
	TeamInviteCategory_EMAIL   TeamInviteCategory = 3
	TeamInviteCategory_SBS     TeamInviteCategory = 4
)

func (o TeamInviteCategory) DeepCopy() TeamInviteCategory { return o }

var TeamInviteCategoryMap = map[string]TeamInviteCategory{
	"NONE":    0,
	"UNKNOWN": 1,
	"KEYBASE": 2,
	"EMAIL":   3,
	"SBS":     4,
}

var TeamInviteCategoryRevMap = map[TeamInviteCategory]string{
	0: "NONE",
	1: "UNKNOWN",
	2: "KEYBASE",
	3: "EMAIL",
	4: "SBS",
}

func (e TeamInviteCategory) String() string {
	if v, ok := TeamInviteCategoryRevMap[e]; ok {
		return v
	}
	return ""
}

type TeamInviteType struct {
	C__       TeamInviteCategory       `codec:"c" json:"c"`
	Unknown__ *string                  `codec:"unknown,omitempty" json:"unknown,omitempty"`
	Sbs__     *TeamInviteSocialNetwork `codec:"sbs,omitempty" json:"sbs,omitempty"`
}

func (o *TeamInviteType) C() (ret TeamInviteCategory, err error) {
	switch o.C__ {
	case TeamInviteCategory_UNKNOWN:
		if o.Unknown__ == nil {
			err = errors.New("unexpected nil value for Unknown__")
			return ret, err
		}
	case TeamInviteCategory_SBS:
		if o.Sbs__ == nil {
			err = errors.New("unexpected nil value for Sbs__")
			return ret, err
		}
	}
	return o.C__, nil
}

func (o TeamInviteType) Unknown() (res string) {
	if o.C__ != TeamInviteCategory_UNKNOWN {
		panic("wrong case accessed")
	}
	if o.Unknown__ == nil {
		return
	}
	return *o.Unknown__
}

func (o TeamInviteType) Sbs() (res TeamInviteSocialNetwork) {
	if o.C__ != TeamInviteCategory_SBS {
		panic("wrong case accessed")
	}
	if o.Sbs__ == nil {
		return
	}
	return *o.Sbs__
}

func NewTeamInviteTypeWithUnknown(v string) TeamInviteType {
	return TeamInviteType{
		C__:       TeamInviteCategory_UNKNOWN,
		Unknown__: &v,
	}
}

func NewTeamInviteTypeWithSbs(v TeamInviteSocialNetwork) TeamInviteType {
	return TeamInviteType{
		C__:   TeamInviteCategory_SBS,
		Sbs__: &v,
	}
}

func NewTeamInviteTypeDefault(c TeamInviteCategory) TeamInviteType {
	return TeamInviteType{
		C__: c,
	}
}

func (o TeamInviteType) DeepCopy() TeamInviteType {
	return TeamInviteType{
		C__: o.C__.DeepCopy(),
		Unknown__: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.Unknown__),
		Sbs__: (func(x *TeamInviteSocialNetwork) *TeamInviteSocialNetwork {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Sbs__),
	}
}

type TeamInviteSocialNetwork string

func (o TeamInviteSocialNetwork) DeepCopy() TeamInviteSocialNetwork {
	return o
}

type TeamInviteName string

func (o TeamInviteName) DeepCopy() TeamInviteName {
	return o
}

type TeamInvite struct {
	Role    TeamRole       `codec:"role" json:"role"`
	Id      TeamInviteID   `codec:"id" json:"id"`
	Type    TeamInviteType `codec:"type" json:"type"`
	Name    TeamInviteName `codec:"name" json:"name"`
	Inviter UserVersion    `codec:"inviter" json:"inviter"`
}

func (o TeamInvite) DeepCopy() TeamInvite {
	return TeamInvite{
		Role:    o.Role.DeepCopy(),
		Id:      o.Id.DeepCopy(),
		Type:    o.Type.DeepCopy(),
		Name:    o.Name.DeepCopy(),
		Inviter: o.Inviter.DeepCopy(),
	}
}

type AnnotatedTeamInvite struct {
	Role            TeamRole       `codec:"role" json:"role"`
	Id              TeamInviteID   `codec:"id" json:"id"`
	Type            TeamInviteType `codec:"type" json:"type"`
	Name            TeamInviteName `codec:"name" json:"name"`
	Inviter         UserVersion    `codec:"inviter" json:"inviter"`
	InviterUsername string         `codec:"inviterUsername" json:"inviterUsername"`
	TeamName        string         `codec:"teamName" json:"teamName"`
}

func (o AnnotatedTeamInvite) DeepCopy() AnnotatedTeamInvite {
	return AnnotatedTeamInvite{
		Role:            o.Role.DeepCopy(),
		Id:              o.Id.DeepCopy(),
		Type:            o.Type.DeepCopy(),
		Name:            o.Name.DeepCopy(),
		Inviter:         o.Inviter.DeepCopy(),
		InviterUsername: o.InviterUsername,
		TeamName:        o.TeamName,
	}
}

type TeamSigChainState struct {
	Reader         UserVersion                         `codec:"reader" json:"reader"`
	Id             TeamID                              `codec:"id" json:"id"`
	Implicit       bool                                `codec:"implicit" json:"implicit"`
	Public         bool                                `codec:"public" json:"public"`
	RootAncestor   TeamName                            `codec:"rootAncestor" json:"rootAncestor"`
	NameDepth      int                                 `codec:"nameDepth" json:"nameDepth"`
	NameLog        []TeamNameLogPoint                  `codec:"nameLog" json:"nameLog"`
	LastSeqno      Seqno                               `codec:"lastSeqno" json:"lastSeqno"`
	LastLinkID     LinkID                              `codec:"lastLinkID" json:"lastLinkID"`
	ParentID       *TeamID                             `codec:"parentID,omitempty" json:"parentID,omitempty"`
	UserLog        map[UserVersion][]UserLogPoint      `codec:"userLog" json:"userLog"`
	SubteamLog     map[TeamID][]SubteamLogPoint        `codec:"subteamLog" json:"subteamLog"`
	PerTeamKeys    map[PerTeamKeyGeneration]PerTeamKey `codec:"perTeamKeys" json:"perTeamKeys"`
	LinkIDs        map[Seqno]LinkID                    `codec:"linkIDs" json:"linkIDs"`
	StubbedLinks   map[Seqno]bool                      `codec:"stubbedLinks" json:"stubbedLinks"`
	ActiveInvites  map[TeamInviteID]TeamInvite         `codec:"activeInvites" json:"activeInvites"`
	Open           bool                                `codec:"open" json:"open"`
	OpenTeamJoinAs TeamRole                            `codec:"openTeamJoinAs" json:"openTeamJoinAs"`
}

func (o TeamSigChainState) DeepCopy() TeamSigChainState {
	return TeamSigChainState{
		Reader:       o.Reader.DeepCopy(),
		Id:           o.Id.DeepCopy(),
		Implicit:     o.Implicit,
		Public:       o.Public,
		RootAncestor: o.RootAncestor.DeepCopy(),
		NameDepth:    o.NameDepth,
		NameLog: (func(x []TeamNameLogPoint) []TeamNameLogPoint {
			if x == nil {
				return nil
			}
			var ret []TeamNameLogPoint
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.NameLog),
		LastSeqno:  o.LastSeqno.DeepCopy(),
		LastLinkID: o.LastLinkID.DeepCopy(),
		ParentID: (func(x *TeamID) *TeamID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.ParentID),
		UserLog: (func(x map[UserVersion][]UserLogPoint) map[UserVersion][]UserLogPoint {
			if x == nil {
				return nil
			}
			ret := make(map[UserVersion][]UserLogPoint)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := (func(x []UserLogPoint) []UserLogPoint {
					if x == nil {
						return nil
					}
					var ret []UserLogPoint
					for _, v := range x {
						vCopy := v.DeepCopy()
						ret = append(ret, vCopy)
					}
					return ret
				})(v)
				ret[kCopy] = vCopy
			}
			return ret
		})(o.UserLog),
		SubteamLog: (func(x map[TeamID][]SubteamLogPoint) map[TeamID][]SubteamLogPoint {
			if x == nil {
				return nil
			}
			ret := make(map[TeamID][]SubteamLogPoint)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := (func(x []SubteamLogPoint) []SubteamLogPoint {
					if x == nil {
						return nil
					}
					var ret []SubteamLogPoint
					for _, v := range x {
						vCopy := v.DeepCopy()
						ret = append(ret, vCopy)
					}
					return ret
				})(v)
				ret[kCopy] = vCopy
			}
			return ret
		})(o.SubteamLog),
		PerTeamKeys: (func(x map[PerTeamKeyGeneration]PerTeamKey) map[PerTeamKeyGeneration]PerTeamKey {
			if x == nil {
				return nil
			}
			ret := make(map[PerTeamKeyGeneration]PerTeamKey)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := v.DeepCopy()
				ret[kCopy] = vCopy
			}
			return ret
		})(o.PerTeamKeys),
		LinkIDs: (func(x map[Seqno]LinkID) map[Seqno]LinkID {
			if x == nil {
				return nil
			}
			ret := make(map[Seqno]LinkID)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := v.DeepCopy()
				ret[kCopy] = vCopy
			}
			return ret
		})(o.LinkIDs),
		StubbedLinks: (func(x map[Seqno]bool) map[Seqno]bool {
			if x == nil {
				return nil
			}
			ret := make(map[Seqno]bool)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := v
				ret[kCopy] = vCopy
			}
			return ret
		})(o.StubbedLinks),
		ActiveInvites: (func(x map[TeamInviteID]TeamInvite) map[TeamInviteID]TeamInvite {
			if x == nil {
				return nil
			}
			ret := make(map[TeamInviteID]TeamInvite)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := v.DeepCopy()
				ret[kCopy] = vCopy
			}
			return ret
		})(o.ActiveInvites),
		Open:           o.Open,
		OpenTeamJoinAs: o.OpenTeamJoinAs.DeepCopy(),
	}
}

type TeamNameLogPoint struct {
	LastPart TeamNamePart `codec:"lastPart" json:"lastPart"`
	Seqno    Seqno        `codec:"seqno" json:"seqno"`
}

func (o TeamNameLogPoint) DeepCopy() TeamNameLogPoint {
	return TeamNameLogPoint{
		LastPart: o.LastPart.DeepCopy(),
		Seqno:    o.Seqno.DeepCopy(),
	}
}

type UserLogPoint struct {
	Role    TeamRole          `codec:"role" json:"role"`
	SigMeta SignatureMetadata `codec:"sigMeta" json:"sigMeta"`
}

func (o UserLogPoint) DeepCopy() UserLogPoint {
	return UserLogPoint{
		Role:    o.Role.DeepCopy(),
		SigMeta: o.SigMeta.DeepCopy(),
	}
}

type SubteamLogPoint struct {
	Name  TeamName `codec:"name" json:"name"`
	Seqno Seqno    `codec:"seqno" json:"seqno"`
}

func (o SubteamLogPoint) DeepCopy() SubteamLogPoint {
	return SubteamLogPoint{
		Name:  o.Name.DeepCopy(),
		Seqno: o.Seqno.DeepCopy(),
	}
}

type TeamNamePart string

func (o TeamNamePart) DeepCopy() TeamNamePart {
	return o
}

type TeamName struct {
	Parts []TeamNamePart `codec:"parts" json:"parts"`
}

func (o TeamName) DeepCopy() TeamName {
	return TeamName{
		Parts: (func(x []TeamNamePart) []TeamNamePart {
			if x == nil {
				return nil
			}
			var ret []TeamNamePart
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Parts),
	}
}

type TeamCLKRMsg struct {
	TeamID     TeamID               `codec:"teamID" json:"team_id"`
	Generation PerTeamKeyGeneration `codec:"generation" json:"generation"`
	Score      int                  `codec:"score" json:"score"`
}

func (o TeamCLKRMsg) DeepCopy() TeamCLKRMsg {
	return TeamCLKRMsg{
		TeamID:     o.TeamID.DeepCopy(),
		Generation: o.Generation.DeepCopy(),
		Score:      o.Score,
	}
}

type TeamChangeRow struct {
	Id                TeamID `codec:"id" json:"id"`
	Name              string `codec:"name" json:"name"`
	KeyRotated        bool   `codec:"keyRotated" json:"key_rotated"`
	MembershipChanged bool   `codec:"membershipChanged" json:"membership_changed"`
	LatestSeqno       Seqno  `codec:"latestSeqno" json:"latest_seqno"`
}

func (o TeamChangeRow) DeepCopy() TeamChangeRow {
	return TeamChangeRow{
		Id:                o.Id.DeepCopy(),
		Name:              o.Name,
		KeyRotated:        o.KeyRotated,
		MembershipChanged: o.MembershipChanged,
		LatestSeqno:       o.LatestSeqno.DeepCopy(),
	}
}

type TeamExitRow struct {
	Id TeamID `codec:"id" json:"id"`
}

func (o TeamExitRow) DeepCopy() TeamExitRow {
	return TeamExitRow{
		Id: o.Id.DeepCopy(),
	}
}

type TeamInvitee struct {
	InviteID    TeamInviteID `codec:"inviteID" json:"invite_id"`
	Uid         UID          `codec:"uid" json:"uid"`
	EldestSeqno Seqno        `codec:"eldestSeqno" json:"eldest_seqno"`
	Role        TeamRole     `codec:"role" json:"role"`
}

func (o TeamInvitee) DeepCopy() TeamInvitee {
	return TeamInvitee{
		InviteID:    o.InviteID.DeepCopy(),
		Uid:         o.Uid.DeepCopy(),
		EldestSeqno: o.EldestSeqno.DeepCopy(),
		Role:        o.Role.DeepCopy(),
	}
}

type TeamSBSMsg struct {
	TeamID   TeamID        `codec:"teamID" json:"team_id"`
	Score    int           `codec:"score" json:"score"`
	Invitees []TeamInvitee `codec:"invitees" json:"invitees"`
}

func (o TeamSBSMsg) DeepCopy() TeamSBSMsg {
	return TeamSBSMsg{
		TeamID: o.TeamID.DeepCopy(),
		Score:  o.Score,
		Invitees: (func(x []TeamInvitee) []TeamInvitee {
			if x == nil {
				return nil
			}
			var ret []TeamInvitee
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Invitees),
	}
}

type TeamAccessRequest struct {
	Uid         UID   `codec:"uid" json:"uid"`
	EldestSeqno Seqno `codec:"eldestSeqno" json:"eldest_seqno"`
}

func (o TeamAccessRequest) DeepCopy() TeamAccessRequest {
	return TeamAccessRequest{
		Uid:         o.Uid.DeepCopy(),
		EldestSeqno: o.EldestSeqno.DeepCopy(),
	}
}

type TeamOpenReqMsg struct {
	TeamID TeamID              `codec:"teamID" json:"team_id"`
	Tars   []TeamAccessRequest `codec:"tars" json:"tars"`
}

func (o TeamOpenReqMsg) DeepCopy() TeamOpenReqMsg {
	return TeamOpenReqMsg{
		TeamID: o.TeamID.DeepCopy(),
		Tars: (func(x []TeamAccessRequest) []TeamAccessRequest {
			if x == nil {
				return nil
			}
			var ret []TeamAccessRequest
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Tars),
	}
}

// * TeamRefreshData are needed or wanted data requirements that, if unmet, will cause
// * a refresh of the cache.
type TeamRefreshers struct {
	NeedKeyGeneration PerTeamKeyGeneration `codec:"needKeyGeneration" json:"needKeyGeneration"`
	WantMembers       []UserVersion        `codec:"wantMembers" json:"wantMembers"`
	WantMembersRole   TeamRole             `codec:"wantMembersRole" json:"wantMembersRole"`
}

func (o TeamRefreshers) DeepCopy() TeamRefreshers {
	return TeamRefreshers{
		NeedKeyGeneration: o.NeedKeyGeneration.DeepCopy(),
		WantMembers: (func(x []UserVersion) []UserVersion {
			if x == nil {
				return nil
			}
			var ret []UserVersion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.WantMembers),
		WantMembersRole: o.WantMembersRole.DeepCopy(),
	}
}

type LoadTeamArg struct {
	ID              TeamID         `codec:"ID" json:"ID"`
	Name            string         `codec:"name" json:"name"`
	NeedAdmin       bool           `codec:"needAdmin" json:"needAdmin"`
	Refreshers      TeamRefreshers `codec:"refreshers" json:"refreshers"`
	ForceFullReload bool           `codec:"forceFullReload" json:"forceFullReload"`
	ForceRepoll     bool           `codec:"forceRepoll" json:"forceRepoll"`
	StaleOK         bool           `codec:"staleOK" json:"staleOK"`
}

func (o LoadTeamArg) DeepCopy() LoadTeamArg {
	return LoadTeamArg{
		ID:              o.ID.DeepCopy(),
		Name:            o.Name,
		NeedAdmin:       o.NeedAdmin,
		Refreshers:      o.Refreshers.DeepCopy(),
		ForceFullReload: o.ForceFullReload,
		ForceRepoll:     o.ForceRepoll,
		StaleOK:         o.StaleOK,
	}
}

type ImplicitRole struct {
	Role     TeamRole `codec:"role" json:"role"`
	Ancestor TeamID   `codec:"ancestor" json:"ancestor"`
}

func (o ImplicitRole) DeepCopy() ImplicitRole {
	return ImplicitRole{
		Role:     o.Role.DeepCopy(),
		Ancestor: o.Ancestor.DeepCopy(),
	}
}

type MemberInfo struct {
	UserID         UID           `codec:"userID" json:"uid"`
	TeamID         TeamID        `codec:"teamID" json:"team_id"`
	FqName         string        `codec:"fqName" json:"fq_name"`
	IsImplicitTeam bool          `codec:"isImplicitTeam" json:"is_implicit_team"`
	Role           TeamRole      `codec:"role" json:"role"`
	Implicit       *ImplicitRole `codec:"implicit,omitempty" json:"implicit,omitempty"`
}

func (o MemberInfo) DeepCopy() MemberInfo {
	return MemberInfo{
		UserID:         o.UserID.DeepCopy(),
		TeamID:         o.TeamID.DeepCopy(),
		FqName:         o.FqName,
		IsImplicitTeam: o.IsImplicitTeam,
		Role:           o.Role.DeepCopy(),
		Implicit: (func(x *ImplicitRole) *ImplicitRole {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Implicit),
	}
}

type TeamList struct {
	Teams []MemberInfo `codec:"teams" json:"teams"`
}

func (o TeamList) DeepCopy() TeamList {
	return TeamList{
		Teams: (func(x []MemberInfo) []MemberInfo {
			if x == nil {
				return nil
			}
			var ret []MemberInfo
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Teams),
	}
}

type AnnotatedMemberInfo struct {
	UserID         UID           `codec:"userID" json:"uid"`
	TeamID         TeamID        `codec:"teamID" json:"team_id"`
	Username       string        `codec:"username" json:"username"`
	FullName       string        `codec:"fullName" json:"full_name"`
	FqName         string        `codec:"fqName" json:"fq_name"`
	IsImplicitTeam bool          `codec:"isImplicitTeam" json:"is_implicit_team"`
	Role           TeamRole      `codec:"role" json:"role"`
	Implicit       *ImplicitRole `codec:"implicit,omitempty" json:"implicit,omitempty"`
}

func (o AnnotatedMemberInfo) DeepCopy() AnnotatedMemberInfo {
	return AnnotatedMemberInfo{
		UserID:         o.UserID.DeepCopy(),
		TeamID:         o.TeamID.DeepCopy(),
		Username:       o.Username,
		FullName:       o.FullName,
		FqName:         o.FqName,
		IsImplicitTeam: o.IsImplicitTeam,
		Role:           o.Role.DeepCopy(),
		Implicit: (func(x *ImplicitRole) *ImplicitRole {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Implicit),
	}
}

type AnnotatedTeamList struct {
	Teams                  []AnnotatedMemberInfo                `codec:"teams" json:"teams"`
	AnnotatedActiveInvites map[TeamInviteID]AnnotatedTeamInvite `codec:"annotatedActiveInvites" json:"annotatedActiveInvites"`
}

func (o AnnotatedTeamList) DeepCopy() AnnotatedTeamList {
	return AnnotatedTeamList{
		Teams: (func(x []AnnotatedMemberInfo) []AnnotatedMemberInfo {
			if x == nil {
				return nil
			}
			var ret []AnnotatedMemberInfo
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Teams),
		AnnotatedActiveInvites: (func(x map[TeamInviteID]AnnotatedTeamInvite) map[TeamInviteID]AnnotatedTeamInvite {
			if x == nil {
				return nil
			}
			ret := make(map[TeamInviteID]AnnotatedTeamInvite)
			for k, v := range x {
				kCopy := k.DeepCopy()
				vCopy := v.DeepCopy()
				ret[kCopy] = vCopy
			}
			return ret
		})(o.AnnotatedActiveInvites),
	}
}

type TeamAddMemberResult struct {
	Invited   bool  `codec:"invited" json:"invited"`
	User      *User `codec:"user,omitempty" json:"user,omitempty"`
	EmailSent bool  `codec:"emailSent" json:"emailSent"`
	ChatSent  bool  `codec:"chatSent" json:"chatSent"`
}

func (o TeamAddMemberResult) DeepCopy() TeamAddMemberResult {
	return TeamAddMemberResult{
		Invited: o.Invited,
		User: (func(x *User) *User {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.User),
		EmailSent: o.EmailSent,
		ChatSent:  o.ChatSent,
	}
}

type TeamJoinRequest struct {
	Name     string `codec:"name" json:"name"`
	Username string `codec:"username" json:"username"`
}

func (o TeamJoinRequest) DeepCopy() TeamJoinRequest {
	return TeamJoinRequest{
		Name:     o.Name,
		Username: o.Username,
	}
}

type TeamTreeResult struct {
	Entries []TeamTreeEntry `codec:"entries" json:"entries"`
}

func (o TeamTreeResult) DeepCopy() TeamTreeResult {
	return TeamTreeResult{
		Entries: (func(x []TeamTreeEntry) []TeamTreeEntry {
			if x == nil {
				return nil
			}
			var ret []TeamTreeEntry
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Entries),
	}
}

type TeamTreeEntry struct {
	Name  TeamName `codec:"name" json:"name"`
	Admin bool     `codec:"admin" json:"admin"`
}

func (o TeamTreeEntry) DeepCopy() TeamTreeEntry {
	return TeamTreeEntry{
		Name:  o.Name.DeepCopy(),
		Admin: o.Admin,
	}
}

type TeamCreateResult struct {
	ChatSent     bool `codec:"chatSent" json:"chatSent"`
	CreatorAdded bool `codec:"creatorAdded" json:"creatorAdded"`
}

func (o TeamCreateResult) DeepCopy() TeamCreateResult {
	return TeamCreateResult{
		ChatSent:     o.ChatSent,
		CreatorAdded: o.CreatorAdded,
	}
}

type TeamSettings struct {
	Open   bool     `codec:"open" json:"open"`
	JoinAs TeamRole `codec:"joinAs" json:"joinAs"`
}

func (o TeamSettings) DeepCopy() TeamSettings {
	return TeamSettings{
		Open:   o.Open,
		JoinAs: o.JoinAs.DeepCopy(),
	}
}

type ImplicitTeamUserSet struct {
	KeybaseUsers    []string          `codec:"keybaseUsers" json:"keybaseUsers"`
	UnresolvedUsers []SocialAssertion `codec:"unresolvedUsers" json:"unresolvedUsers"`
}

func (o ImplicitTeamUserSet) DeepCopy() ImplicitTeamUserSet {
	return ImplicitTeamUserSet{
		KeybaseUsers: (func(x []string) []string {
			if x == nil {
				return nil
			}
			var ret []string
			for _, v := range x {
				vCopy := v
				ret = append(ret, vCopy)
			}
			return ret
		})(o.KeybaseUsers),
		UnresolvedUsers: (func(x []SocialAssertion) []SocialAssertion {
			if x == nil {
				return nil
			}
			var ret []SocialAssertion
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.UnresolvedUsers),
	}
}

// * iTeams
type ImplicitTeamDisplayName struct {
	IsPublic     bool                      `codec:"isPublic" json:"isPublic"`
	Writers      ImplicitTeamUserSet       `codec:"writers" json:"writers"`
	Readers      ImplicitTeamUserSet       `codec:"readers" json:"readers"`
	ConflictInfo *ImplicitTeamConflictInfo `codec:"conflictInfo,omitempty" json:"conflictInfo,omitempty"`
}

func (o ImplicitTeamDisplayName) DeepCopy() ImplicitTeamDisplayName {
	return ImplicitTeamDisplayName{
		IsPublic: o.IsPublic,
		Writers:  o.Writers.DeepCopy(),
		Readers:  o.Readers.DeepCopy(),
		ConflictInfo: (func(x *ImplicitTeamConflictInfo) *ImplicitTeamConflictInfo {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.ConflictInfo),
	}
}

type ImplicitTeamConflictInfo struct {
	Generation int  `codec:"generation" json:"generation"`
	Time       Time `codec:"time" json:"time"`
}

func (o ImplicitTeamConflictInfo) DeepCopy() ImplicitTeamConflictInfo {
	return ImplicitTeamConflictInfo{
		Generation: o.Generation,
		Time:       o.Time.DeepCopy(),
	}
}

type TeamCreateArg struct {
	SessionID            int    `codec:"sessionID" json:"sessionID"`
	Name                 string `codec:"name" json:"name"`
	SendChatNotification bool   `codec:"sendChatNotification" json:"sendChatNotification"`
}

func (o TeamCreateArg) DeepCopy() TeamCreateArg {
	return TeamCreateArg{
		SessionID:            o.SessionID,
		Name:                 o.Name,
		SendChatNotification: o.SendChatNotification,
	}
}

type TeamCreateWithSettingsArg struct {
	SessionID            int          `codec:"sessionID" json:"sessionID"`
	Name                 string       `codec:"name" json:"name"`
	SendChatNotification bool         `codec:"sendChatNotification" json:"sendChatNotification"`
	Settings             TeamSettings `codec:"settings" json:"settings"`
}

func (o TeamCreateWithSettingsArg) DeepCopy() TeamCreateWithSettingsArg {
	return TeamCreateWithSettingsArg{
		SessionID:            o.SessionID,
		Name:                 o.Name,
		SendChatNotification: o.SendChatNotification,
		Settings:             o.Settings.DeepCopy(),
	}
}

type TeamGetArg struct {
	SessionID   int    `codec:"sessionID" json:"sessionID"`
	Name        string `codec:"name" json:"name"`
	ForceRepoll bool   `codec:"forceRepoll" json:"forceRepoll"`
}

func (o TeamGetArg) DeepCopy() TeamGetArg {
	return TeamGetArg{
		SessionID:   o.SessionID,
		Name:        o.Name,
		ForceRepoll: o.ForceRepoll,
	}
}

type TeamListArg struct {
	SessionID            int    `codec:"sessionID" json:"sessionID"`
	UserAssertion        string `codec:"userAssertion" json:"userAssertion"`
	All                  bool   `codec:"all" json:"all"`
	IncludeImplicitTeams bool   `codec:"includeImplicitTeams" json:"includeImplicitTeams"`
}

func (o TeamListArg) DeepCopy() TeamListArg {
	return TeamListArg{
		SessionID:            o.SessionID,
		UserAssertion:        o.UserAssertion,
		All:                  o.All,
		IncludeImplicitTeams: o.IncludeImplicitTeams,
	}
}

type TeamListSubteamsRecursiveArg struct {
	SessionID      int    `codec:"sessionID" json:"sessionID"`
	ParentTeamName string `codec:"parentTeamName" json:"parentTeamName"`
	ForceRepoll    bool   `codec:"forceRepoll" json:"forceRepoll"`
}

func (o TeamListSubteamsRecursiveArg) DeepCopy() TeamListSubteamsRecursiveArg {
	return TeamListSubteamsRecursiveArg{
		SessionID:      o.SessionID,
		ParentTeamName: o.ParentTeamName,
		ForceRepoll:    o.ForceRepoll,
	}
}

type TeamChangeMembershipArg struct {
	SessionID int           `codec:"sessionID" json:"sessionID"`
	Name      string        `codec:"name" json:"name"`
	Req       TeamChangeReq `codec:"req" json:"req"`
}

func (o TeamChangeMembershipArg) DeepCopy() TeamChangeMembershipArg {
	return TeamChangeMembershipArg{
		SessionID: o.SessionID,
		Name:      o.Name,
		Req:       o.Req.DeepCopy(),
	}
}

type TeamAddMemberArg struct {
	SessionID            int      `codec:"sessionID" json:"sessionID"`
	Name                 string   `codec:"name" json:"name"`
	Email                string   `codec:"email" json:"email"`
	Username             string   `codec:"username" json:"username"`
	Role                 TeamRole `codec:"role" json:"role"`
	SendChatNotification bool     `codec:"sendChatNotification" json:"sendChatNotification"`
}

func (o TeamAddMemberArg) DeepCopy() TeamAddMemberArg {
	return TeamAddMemberArg{
		SessionID:            o.SessionID,
		Name:                 o.Name,
		Email:                o.Email,
		Username:             o.Username,
		Role:                 o.Role.DeepCopy(),
		SendChatNotification: o.SendChatNotification,
	}
}

type TeamRemoveMemberArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Name      string `codec:"name" json:"name"`
	Username  string `codec:"username" json:"username"`
}

func (o TeamRemoveMemberArg) DeepCopy() TeamRemoveMemberArg {
	return TeamRemoveMemberArg{
		SessionID: o.SessionID,
		Name:      o.Name,
		Username:  o.Username,
	}
}

type TeamLeaveArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Name      string `codec:"name" json:"name"`
	Permanent bool   `codec:"permanent" json:"permanent"`
}

func (o TeamLeaveArg) DeepCopy() TeamLeaveArg {
	return TeamLeaveArg{
		SessionID: o.SessionID,
		Name:      o.Name,
		Permanent: o.Permanent,
	}
}

type TeamEditMemberArg struct {
	SessionID int      `codec:"sessionID" json:"sessionID"`
	Name      string   `codec:"name" json:"name"`
	Username  string   `codec:"username" json:"username"`
	Role      TeamRole `codec:"role" json:"role"`
}

func (o TeamEditMemberArg) DeepCopy() TeamEditMemberArg {
	return TeamEditMemberArg{
		SessionID: o.SessionID,
		Name:      o.Name,
		Username:  o.Username,
		Role:      o.Role.DeepCopy(),
	}
}

type TeamRenameArg struct {
	SessionID int      `codec:"sessionID" json:"sessionID"`
	PrevName  TeamName `codec:"prevName" json:"prevName"`
	NewName   TeamName `codec:"newName" json:"newName"`
}

func (o TeamRenameArg) DeepCopy() TeamRenameArg {
	return TeamRenameArg{
		SessionID: o.SessionID,
		PrevName:  o.PrevName.DeepCopy(),
		NewName:   o.NewName.DeepCopy(),
	}
}

type TeamAcceptInviteArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Token     string `codec:"token" json:"token"`
}

func (o TeamAcceptInviteArg) DeepCopy() TeamAcceptInviteArg {
	return TeamAcceptInviteArg{
		SessionID: o.SessionID,
		Token:     o.Token,
	}
}

type TeamRequestAccessArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Name      string `codec:"name" json:"name"`
}

func (o TeamRequestAccessArg) DeepCopy() TeamRequestAccessArg {
	return TeamRequestAccessArg{
		SessionID: o.SessionID,
		Name:      o.Name,
	}
}

type TeamAcceptInviteOrRequestAccessArg struct {
	SessionID   int    `codec:"sessionID" json:"sessionID"`
	TokenOrName string `codec:"tokenOrName" json:"tokenOrName"`
}

func (o TeamAcceptInviteOrRequestAccessArg) DeepCopy() TeamAcceptInviteOrRequestAccessArg {
	return TeamAcceptInviteOrRequestAccessArg{
		SessionID:   o.SessionID,
		TokenOrName: o.TokenOrName,
	}
}

type TeamListRequestsArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

func (o TeamListRequestsArg) DeepCopy() TeamListRequestsArg {
	return TeamListRequestsArg{
		SessionID: o.SessionID,
	}
}

type TeamIgnoreRequestArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Name      string `codec:"name" json:"name"`
	Username  string `codec:"username" json:"username"`
}

func (o TeamIgnoreRequestArg) DeepCopy() TeamIgnoreRequestArg {
	return TeamIgnoreRequestArg{
		SessionID: o.SessionID,
		Name:      o.Name,
		Username:  o.Username,
	}
}

type TeamTreeArg struct {
	SessionID int      `codec:"sessionID" json:"sessionID"`
	Name      TeamName `codec:"name" json:"name"`
}

func (o TeamTreeArg) DeepCopy() TeamTreeArg {
	return TeamTreeArg{
		SessionID: o.SessionID,
		Name:      o.Name.DeepCopy(),
	}
}

type TeamDeleteArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Name      string `codec:"name" json:"name"`
}

func (o TeamDeleteArg) DeepCopy() TeamDeleteArg {
	return TeamDeleteArg{
		SessionID: o.SessionID,
		Name:      o.Name,
	}
}

type TeamSetSettingsArg struct {
	SessionID int          `codec:"sessionID" json:"sessionID"`
	Name      string       `codec:"name" json:"name"`
	Settings  TeamSettings `codec:"settings" json:"settings"`
}

func (o TeamSetSettingsArg) DeepCopy() TeamSetSettingsArg {
	return TeamSetSettingsArg{
		SessionID: o.SessionID,
		Name:      o.Name,
		Settings:  o.Settings.DeepCopy(),
	}
}

type LookupImplicitTeamArg struct {
	Name   string `codec:"name" json:"name"`
	Public bool   `codec:"public" json:"public"`
}

func (o LookupImplicitTeamArg) DeepCopy() LookupImplicitTeamArg {
	return LookupImplicitTeamArg{
		Name:   o.Name,
		Public: o.Public,
	}
}

type LookupOrCreateImplicitTeamArg struct {
	Name   string `codec:"name" json:"name"`
	Public bool   `codec:"public" json:"public"`
}

func (o LookupOrCreateImplicitTeamArg) DeepCopy() LookupOrCreateImplicitTeamArg {
	return LookupOrCreateImplicitTeamArg{
		Name:   o.Name,
		Public: o.Public,
	}
}

type TeamReAddMemberAfterResetArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Id        TeamID `codec:"id" json:"id"`
	Username  string `codec:"username" json:"username"`
}

func (o TeamReAddMemberAfterResetArg) DeepCopy() TeamReAddMemberAfterResetArg {
	return TeamReAddMemberAfterResetArg{
		SessionID: o.SessionID,
		Id:        o.Id.DeepCopy(),
		Username:  o.Username,
	}
}

type LoadTeamPlusApplicationKeysArg struct {
	SessionID   int             `codec:"sessionID" json:"sessionID"`
	Id          TeamID          `codec:"id" json:"id"`
	Application TeamApplication `codec:"application" json:"application"`
	Refreshers  TeamRefreshers  `codec:"refreshers" json:"refreshers"`
}

func (o LoadTeamPlusApplicationKeysArg) DeepCopy() LoadTeamPlusApplicationKeysArg {
	return LoadTeamPlusApplicationKeysArg{
		SessionID:   o.SessionID,
		Id:          o.Id.DeepCopy(),
		Application: o.Application.DeepCopy(),
		Refreshers:  o.Refreshers.DeepCopy(),
	}
}

type GetTeamRootIDArg struct {
	Id TeamID `codec:"id" json:"id"`
}

func (o GetTeamRootIDArg) DeepCopy() GetTeamRootIDArg {
	return GetTeamRootIDArg{
		Id: o.Id.DeepCopy(),
	}
}

type TeamsInterface interface {
	TeamCreate(context.Context, TeamCreateArg) (TeamCreateResult, error)
	TeamCreateWithSettings(context.Context, TeamCreateWithSettingsArg) (TeamCreateResult, error)
	TeamGet(context.Context, TeamGetArg) (TeamDetails, error)
	TeamList(context.Context, TeamListArg) (AnnotatedTeamList, error)
	TeamListSubteamsRecursive(context.Context, TeamListSubteamsRecursiveArg) ([]TeamIDAndName, error)
	TeamChangeMembership(context.Context, TeamChangeMembershipArg) error
	TeamAddMember(context.Context, TeamAddMemberArg) (TeamAddMemberResult, error)
	TeamRemoveMember(context.Context, TeamRemoveMemberArg) error
	TeamLeave(context.Context, TeamLeaveArg) error
	TeamEditMember(context.Context, TeamEditMemberArg) error
	TeamRename(context.Context, TeamRenameArg) error
	TeamAcceptInvite(context.Context, TeamAcceptInviteArg) error
	TeamRequestAccess(context.Context, TeamRequestAccessArg) error
	TeamAcceptInviteOrRequestAccess(context.Context, TeamAcceptInviteOrRequestAccessArg) error
	TeamListRequests(context.Context, int) ([]TeamJoinRequest, error)
	TeamIgnoreRequest(context.Context, TeamIgnoreRequestArg) error
	TeamTree(context.Context, TeamTreeArg) (TeamTreeResult, error)
	TeamDelete(context.Context, TeamDeleteArg) error
	TeamSetSettings(context.Context, TeamSetSettingsArg) error
	LookupImplicitTeam(context.Context, LookupImplicitTeamArg) (TeamID, error)
	LookupOrCreateImplicitTeam(context.Context, LookupOrCreateImplicitTeamArg) (TeamID, error)
	TeamReAddMemberAfterReset(context.Context, TeamReAddMemberAfterResetArg) error
	// * loadTeamPlusApplicationKeys loads team information for applications like KBFS and Chat.
	// * If refreshers are non-empty, then force a refresh of the cache if the requirements
	// * of the refreshers aren't met.
	LoadTeamPlusApplicationKeys(context.Context, LoadTeamPlusApplicationKeysArg) (TeamPlusApplicationKeys, error)
	GetTeamRootID(context.Context, TeamID) (TeamID, error)
}

func TeamsProtocol(i TeamsInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "keybase.1.teams",
		Methods: map[string]rpc.ServeHandlerDescription{
			"teamCreate": {
				MakeArg: func() interface{} {
					ret := make([]TeamCreateArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamCreateArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamCreateArg)(nil), args)
						return
					}
					ret, err = i.TeamCreate(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamCreateWithSettings": {
				MakeArg: func() interface{} {
					ret := make([]TeamCreateWithSettingsArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamCreateWithSettingsArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamCreateWithSettingsArg)(nil), args)
						return
					}
					ret, err = i.TeamCreateWithSettings(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamGet": {
				MakeArg: func() interface{} {
					ret := make([]TeamGetArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamGetArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamGetArg)(nil), args)
						return
					}
					ret, err = i.TeamGet(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamList": {
				MakeArg: func() interface{} {
					ret := make([]TeamListArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamListArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamListArg)(nil), args)
						return
					}
					ret, err = i.TeamList(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamListSubteamsRecursive": {
				MakeArg: func() interface{} {
					ret := make([]TeamListSubteamsRecursiveArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamListSubteamsRecursiveArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamListSubteamsRecursiveArg)(nil), args)
						return
					}
					ret, err = i.TeamListSubteamsRecursive(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamChangeMembership": {
				MakeArg: func() interface{} {
					ret := make([]TeamChangeMembershipArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamChangeMembershipArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamChangeMembershipArg)(nil), args)
						return
					}
					err = i.TeamChangeMembership(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamAddMember": {
				MakeArg: func() interface{} {
					ret := make([]TeamAddMemberArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamAddMemberArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamAddMemberArg)(nil), args)
						return
					}
					ret, err = i.TeamAddMember(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamRemoveMember": {
				MakeArg: func() interface{} {
					ret := make([]TeamRemoveMemberArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamRemoveMemberArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamRemoveMemberArg)(nil), args)
						return
					}
					err = i.TeamRemoveMember(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamLeave": {
				MakeArg: func() interface{} {
					ret := make([]TeamLeaveArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamLeaveArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamLeaveArg)(nil), args)
						return
					}
					err = i.TeamLeave(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamEditMember": {
				MakeArg: func() interface{} {
					ret := make([]TeamEditMemberArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamEditMemberArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamEditMemberArg)(nil), args)
						return
					}
					err = i.TeamEditMember(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamRename": {
				MakeArg: func() interface{} {
					ret := make([]TeamRenameArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamRenameArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamRenameArg)(nil), args)
						return
					}
					err = i.TeamRename(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamAcceptInvite": {
				MakeArg: func() interface{} {
					ret := make([]TeamAcceptInviteArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamAcceptInviteArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamAcceptInviteArg)(nil), args)
						return
					}
					err = i.TeamAcceptInvite(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamRequestAccess": {
				MakeArg: func() interface{} {
					ret := make([]TeamRequestAccessArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamRequestAccessArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamRequestAccessArg)(nil), args)
						return
					}
					err = i.TeamRequestAccess(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamAcceptInviteOrRequestAccess": {
				MakeArg: func() interface{} {
					ret := make([]TeamAcceptInviteOrRequestAccessArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamAcceptInviteOrRequestAccessArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamAcceptInviteOrRequestAccessArg)(nil), args)
						return
					}
					err = i.TeamAcceptInviteOrRequestAccess(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamListRequests": {
				MakeArg: func() interface{} {
					ret := make([]TeamListRequestsArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamListRequestsArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamListRequestsArg)(nil), args)
						return
					}
					ret, err = i.TeamListRequests(ctx, (*typedArgs)[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamIgnoreRequest": {
				MakeArg: func() interface{} {
					ret := make([]TeamIgnoreRequestArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamIgnoreRequestArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamIgnoreRequestArg)(nil), args)
						return
					}
					err = i.TeamIgnoreRequest(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamTree": {
				MakeArg: func() interface{} {
					ret := make([]TeamTreeArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamTreeArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamTreeArg)(nil), args)
						return
					}
					ret, err = i.TeamTree(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamDelete": {
				MakeArg: func() interface{} {
					ret := make([]TeamDeleteArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamDeleteArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamDeleteArg)(nil), args)
						return
					}
					err = i.TeamDelete(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamSetSettings": {
				MakeArg: func() interface{} {
					ret := make([]TeamSetSettingsArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamSetSettingsArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamSetSettingsArg)(nil), args)
						return
					}
					err = i.TeamSetSettings(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"lookupImplicitTeam": {
				MakeArg: func() interface{} {
					ret := make([]LookupImplicitTeamArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]LookupImplicitTeamArg)
					if !ok {
						err = rpc.NewTypeError((*[]LookupImplicitTeamArg)(nil), args)
						return
					}
					ret, err = i.LookupImplicitTeam(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"lookupOrCreateImplicitTeam": {
				MakeArg: func() interface{} {
					ret := make([]LookupOrCreateImplicitTeamArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]LookupOrCreateImplicitTeamArg)
					if !ok {
						err = rpc.NewTypeError((*[]LookupOrCreateImplicitTeamArg)(nil), args)
						return
					}
					ret, err = i.LookupOrCreateImplicitTeam(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"teamReAddMemberAfterReset": {
				MakeArg: func() interface{} {
					ret := make([]TeamReAddMemberAfterResetArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]TeamReAddMemberAfterResetArg)
					if !ok {
						err = rpc.NewTypeError((*[]TeamReAddMemberAfterResetArg)(nil), args)
						return
					}
					err = i.TeamReAddMemberAfterReset(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadTeamPlusApplicationKeys": {
				MakeArg: func() interface{} {
					ret := make([]LoadTeamPlusApplicationKeysArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]LoadTeamPlusApplicationKeysArg)
					if !ok {
						err = rpc.NewTypeError((*[]LoadTeamPlusApplicationKeysArg)(nil), args)
						return
					}
					ret, err = i.LoadTeamPlusApplicationKeys(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getTeamRootID": {
				MakeArg: func() interface{} {
					ret := make([]GetTeamRootIDArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetTeamRootIDArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetTeamRootIDArg)(nil), args)
						return
					}
					ret, err = i.GetTeamRootID(ctx, (*typedArgs)[0].Id)
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type TeamsClient struct {
	Cli rpc.GenericClient
}

func (c TeamsClient) TeamCreate(ctx context.Context, __arg TeamCreateArg) (res TeamCreateResult, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamCreate", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) TeamCreateWithSettings(ctx context.Context, __arg TeamCreateWithSettingsArg) (res TeamCreateResult, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamCreateWithSettings", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) TeamGet(ctx context.Context, __arg TeamGetArg) (res TeamDetails, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamGet", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) TeamList(ctx context.Context, __arg TeamListArg) (res AnnotatedTeamList, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamList", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) TeamListSubteamsRecursive(ctx context.Context, __arg TeamListSubteamsRecursiveArg) (res []TeamIDAndName, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamListSubteamsRecursive", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) TeamChangeMembership(ctx context.Context, __arg TeamChangeMembershipArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamChangeMembership", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamAddMember(ctx context.Context, __arg TeamAddMemberArg) (res TeamAddMemberResult, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamAddMember", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) TeamRemoveMember(ctx context.Context, __arg TeamRemoveMemberArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamRemoveMember", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamLeave(ctx context.Context, __arg TeamLeaveArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamLeave", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamEditMember(ctx context.Context, __arg TeamEditMemberArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamEditMember", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamRename(ctx context.Context, __arg TeamRenameArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamRename", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamAcceptInvite(ctx context.Context, __arg TeamAcceptInviteArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamAcceptInvite", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamRequestAccess(ctx context.Context, __arg TeamRequestAccessArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamRequestAccess", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamAcceptInviteOrRequestAccess(ctx context.Context, __arg TeamAcceptInviteOrRequestAccessArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamAcceptInviteOrRequestAccess", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamListRequests(ctx context.Context, sessionID int) (res []TeamJoinRequest, err error) {
	__arg := TeamListRequestsArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.teams.teamListRequests", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) TeamIgnoreRequest(ctx context.Context, __arg TeamIgnoreRequestArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamIgnoreRequest", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamTree(ctx context.Context, __arg TeamTreeArg) (res TeamTreeResult, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamTree", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) TeamDelete(ctx context.Context, __arg TeamDeleteArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamDelete", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) TeamSetSettings(ctx context.Context, __arg TeamSetSettingsArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamSetSettings", []interface{}{__arg}, nil)
	return
}

func (c TeamsClient) LookupImplicitTeam(ctx context.Context, __arg LookupImplicitTeamArg) (res TeamID, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.lookupImplicitTeam", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) LookupOrCreateImplicitTeam(ctx context.Context, __arg LookupOrCreateImplicitTeamArg) (res TeamID, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.lookupOrCreateImplicitTeam", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) TeamReAddMemberAfterReset(ctx context.Context, __arg TeamReAddMemberAfterResetArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.teamReAddMemberAfterReset", []interface{}{__arg}, nil)
	return
}

// * loadTeamPlusApplicationKeys loads team information for applications like KBFS and Chat.
// * If refreshers are non-empty, then force a refresh of the cache if the requirements
// * of the refreshers aren't met.
func (c TeamsClient) LoadTeamPlusApplicationKeys(ctx context.Context, __arg LoadTeamPlusApplicationKeysArg) (res TeamPlusApplicationKeys, err error) {
	err = c.Cli.Call(ctx, "keybase.1.teams.loadTeamPlusApplicationKeys", []interface{}{__arg}, &res)
	return
}

func (c TeamsClient) GetTeamRootID(ctx context.Context, id TeamID) (res TeamID, err error) {
	__arg := GetTeamRootIDArg{Id: id}
	err = c.Cli.Call(ctx, "keybase.1.teams.getTeamRootID", []interface{}{__arg}, &res)
	return
}
