// Auto-generated by avdl-compiler v1.3.20 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/keybase1/provision_ui.avdl

package keybase1

import (
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type ProvisionMethod int

const (
	ProvisionMethod_DEVICE     ProvisionMethod = 0
	ProvisionMethod_PAPER_KEY  ProvisionMethod = 1
	ProvisionMethod_PASSPHRASE ProvisionMethod = 2
	ProvisionMethod_GPG_IMPORT ProvisionMethod = 3
	ProvisionMethod_GPG_SIGN   ProvisionMethod = 4
)

func (o ProvisionMethod) DeepCopy() ProvisionMethod { return o }

var ProvisionMethodMap = map[string]ProvisionMethod{
	"DEVICE":     0,
	"PAPER_KEY":  1,
	"PASSPHRASE": 2,
	"GPG_IMPORT": 3,
	"GPG_SIGN":   4,
}

var ProvisionMethodRevMap = map[ProvisionMethod]string{
	0: "DEVICE",
	1: "PAPER_KEY",
	2: "PASSPHRASE",
	3: "GPG_IMPORT",
	4: "GPG_SIGN",
}

func (e ProvisionMethod) String() string {
	if v, ok := ProvisionMethodRevMap[e]; ok {
		return v
	}
	return ""
}

type GPGMethod int

const (
	GPGMethod_GPG_NONE   GPGMethod = 0
	GPGMethod_GPG_IMPORT GPGMethod = 1
	GPGMethod_GPG_SIGN   GPGMethod = 2
)

func (o GPGMethod) DeepCopy() GPGMethod { return o }

var GPGMethodMap = map[string]GPGMethod{
	"GPG_NONE":   0,
	"GPG_IMPORT": 1,
	"GPG_SIGN":   2,
}

var GPGMethodRevMap = map[GPGMethod]string{
	0: "GPG_NONE",
	1: "GPG_IMPORT",
	2: "GPG_SIGN",
}

func (e GPGMethod) String() string {
	if v, ok := GPGMethodRevMap[e]; ok {
		return v
	}
	return ""
}

type ChooseType int

const (
	ChooseType_EXISTING_DEVICE ChooseType = 0
	ChooseType_NEW_DEVICE      ChooseType = 1
)

func (o ChooseType) DeepCopy() ChooseType { return o }

var ChooseTypeMap = map[string]ChooseType{
	"EXISTING_DEVICE": 0,
	"NEW_DEVICE":      1,
}

var ChooseTypeRevMap = map[ChooseType]string{
	0: "EXISTING_DEVICE",
	1: "NEW_DEVICE",
}

func (e ChooseType) String() string {
	if v, ok := ChooseTypeRevMap[e]; ok {
		return v
	}
	return ""
}

// SecretResponse should be returned by DisplayAndPromptSecret.  Use either secret or phrase.
type SecretResponse struct {
	Secret []byte `codec:"secret" json:"secret"`
	Phrase string `codec:"phrase" json:"phrase"`
}

func (o SecretResponse) DeepCopy() SecretResponse {
	return SecretResponse{
		Secret: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.Secret),
		Phrase: o.Phrase,
	}
}

type ChooseProvisioningMethodArg struct {
	SessionID int  `codec:"sessionID" json:"sessionID"`
	GpgOption bool `codec:"gpgOption" json:"gpgOption"`
}

func (o ChooseProvisioningMethodArg) DeepCopy() ChooseProvisioningMethodArg {
	return ChooseProvisioningMethodArg{
		SessionID: o.SessionID,
		GpgOption: o.GpgOption,
	}
}

type ChooseGPGMethodArg struct {
	SessionID int      `codec:"sessionID" json:"sessionID"`
	Keys      []GPGKey `codec:"keys" json:"keys"`
}

func (o ChooseGPGMethodArg) DeepCopy() ChooseGPGMethodArg {
	return ChooseGPGMethodArg{
		SessionID: o.SessionID,
		Keys: (func(x []GPGKey) []GPGKey {
			if x == nil {
				return nil
			}
			var ret []GPGKey
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Keys),
	}
}

type SwitchToGPGSignOKArg struct {
	SessionID   int    `codec:"sessionID" json:"sessionID"`
	Key         GPGKey `codec:"key" json:"key"`
	ImportError string `codec:"importError" json:"importError"`
}

func (o SwitchToGPGSignOKArg) DeepCopy() SwitchToGPGSignOKArg {
	return SwitchToGPGSignOKArg{
		SessionID:   o.SessionID,
		Key:         o.Key.DeepCopy(),
		ImportError: o.ImportError,
	}
}

type ChooseDeviceArg struct {
	SessionID         int      `codec:"sessionID" json:"sessionID"`
	Devices           []Device `codec:"devices" json:"devices"`
	CanSelectNoDevice bool     `codec:"canSelectNoDevice" json:"canSelectNoDevice"`
}

func (o ChooseDeviceArg) DeepCopy() ChooseDeviceArg {
	return ChooseDeviceArg{
		SessionID: o.SessionID,
		Devices: (func(x []Device) []Device {
			if x == nil {
				return nil
			}
			var ret []Device
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Devices),
		CanSelectNoDevice: o.CanSelectNoDevice,
	}
}

type ChooseDeviceTypeArg struct {
	SessionID int        `codec:"sessionID" json:"sessionID"`
	Kind      ChooseType `codec:"kind" json:"kind"`
}

func (o ChooseDeviceTypeArg) DeepCopy() ChooseDeviceTypeArg {
	return ChooseDeviceTypeArg{
		SessionID: o.SessionID,
		Kind:      o.Kind.DeepCopy(),
	}
}

type DisplayAndPromptSecretArg struct {
	SessionID       int        `codec:"sessionID" json:"sessionID"`
	Secret          []byte     `codec:"secret" json:"secret"`
	Phrase          string     `codec:"phrase" json:"phrase"`
	OtherDeviceType DeviceType `codec:"otherDeviceType" json:"otherDeviceType"`
	PreviousErr     string     `codec:"previousErr" json:"previousErr"`
}

func (o DisplayAndPromptSecretArg) DeepCopy() DisplayAndPromptSecretArg {
	return DisplayAndPromptSecretArg{
		SessionID: o.SessionID,
		Secret: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.Secret),
		Phrase:          o.Phrase,
		OtherDeviceType: o.OtherDeviceType.DeepCopy(),
		PreviousErr:     o.PreviousErr,
	}
}

type DisplaySecretExchangedArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

func (o DisplaySecretExchangedArg) DeepCopy() DisplaySecretExchangedArg {
	return DisplaySecretExchangedArg{
		SessionID: o.SessionID,
	}
}

type PromptNewDeviceNameArg struct {
	SessionID       int      `codec:"sessionID" json:"sessionID"`
	ExistingDevices []string `codec:"existingDevices" json:"existingDevices"`
	ErrorMessage    string   `codec:"errorMessage" json:"errorMessage"`
}

func (o PromptNewDeviceNameArg) DeepCopy() PromptNewDeviceNameArg {
	return PromptNewDeviceNameArg{
		SessionID: o.SessionID,
		ExistingDevices: (func(x []string) []string {
			if x == nil {
				return nil
			}
			var ret []string
			for _, v := range x {
				vCopy := v
				ret = append(ret, vCopy)
			}
			return ret
		})(o.ExistingDevices),
		ErrorMessage: o.ErrorMessage,
	}
}

type ProvisioneeSuccessArg struct {
	SessionID  int    `codec:"sessionID" json:"sessionID"`
	Username   string `codec:"username" json:"username"`
	DeviceName string `codec:"deviceName" json:"deviceName"`
}

func (o ProvisioneeSuccessArg) DeepCopy() ProvisioneeSuccessArg {
	return ProvisioneeSuccessArg{
		SessionID:  o.SessionID,
		Username:   o.Username,
		DeviceName: o.DeviceName,
	}
}

type ProvisionerSuccessArg struct {
	SessionID  int    `codec:"sessionID" json:"sessionID"`
	DeviceName string `codec:"deviceName" json:"deviceName"`
	DeviceType string `codec:"deviceType" json:"deviceType"`
}

func (o ProvisionerSuccessArg) DeepCopy() ProvisionerSuccessArg {
	return ProvisionerSuccessArg{
		SessionID:  o.SessionID,
		DeviceName: o.DeviceName,
		DeviceType: o.DeviceType,
	}
}

type ProvisionUiInterface interface {
	// DEPRECATED:
	// Called during device provisioning for the user to select a
	// method for provisioning.  gpgOption will be true if GPG
	// should be offered as an option.
	ChooseProvisioningMethod(context.Context, ChooseProvisioningMethodArg) (ProvisionMethod, error)
	// Called during device provisioning for the user to select a
	// GPG method, either import the key into keybase's local keyring
	// or use GPG to sign a provisioning statement.
	//
	// The keys are provided for display purposes, so the UI can
	// do something like "We found the following GPG keys on this
	// machine.  How would you like to use one of them to provision
	// this device?"
	//
	// After this, gpg_ui.selectKey will be called (if there are
	// multiple keys available).
	ChooseGPGMethod(context.Context, ChooseGPGMethodArg) (GPGMethod, error)
	// If there was an error importing a gpg key into the local
	// keyring, tell the user and offer to switch to GPG signing
	// with this key.  Return true to switch to GPG signing,
	// false to abort provisioning.
	SwitchToGPGSignOK(context.Context, SwitchToGPGSignOKArg) (bool, error)
	ChooseDevice(context.Context, ChooseDeviceArg) (DeviceID, error)
	// If provisioning via device, this will be called so user can select the provisioner/provisionee device type: desktop or mobile.
	// If selecting the existing device type, set kind to EXISTING_DEVICE_0.
	// If selecting the new device type, set kind to NEW_DEVICE_1.
	ChooseDeviceType(context.Context, ChooseDeviceTypeArg) (DeviceType, error)
	// DisplayAndPromptSecret displays a secret that the user can enter into the other device.
	// It also can return a secret that the user enters into this device (from the other device).
	// If it does not return a secret, it will be canceled when this device receives the secret via kex2.
	// If there is an error in the phrase, then previousErr will be set when this is called again.
	DisplayAndPromptSecret(context.Context, DisplayAndPromptSecretArg) (SecretResponse, error)
	// DisplaySecretExchanged is called when the kex2 secret has successfully been exchanged by the two
	// devices.
	DisplaySecretExchanged(context.Context, int) error
	// PromptNewDeviceName is called when the device provisioning process needs a name for the new device.
	// To help the clients not send a duplicate name, existingDevices is populated with the current device
	// names for the user.  If the device name returned to the service is invalid or already
	// taken, it will call this again with an error message in errorMessage.
	PromptNewDeviceName(context.Context, PromptNewDeviceNameArg) (string, error)
	// ProvisioneeSuccess is called on provisionee when it is successfully provisioned.
	ProvisioneeSuccess(context.Context, ProvisioneeSuccessArg) error
	// ProvisionerSuccess is called on provisioner when it successfully provisions another device.
	ProvisionerSuccess(context.Context, ProvisionerSuccessArg) error
}

func ProvisionUiProtocol(i ProvisionUiInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "keybase.1.provisionUi",
		Methods: map[string]rpc.ServeHandlerDescription{
			"chooseProvisioningMethod": {
				MakeArg: func() interface{} {
					ret := make([]ChooseProvisioningMethodArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]ChooseProvisioningMethodArg)
					if !ok {
						err = rpc.NewTypeError((*[]ChooseProvisioningMethodArg)(nil), args)
						return
					}
					ret, err = i.ChooseProvisioningMethod(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"chooseGPGMethod": {
				MakeArg: func() interface{} {
					ret := make([]ChooseGPGMethodArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]ChooseGPGMethodArg)
					if !ok {
						err = rpc.NewTypeError((*[]ChooseGPGMethodArg)(nil), args)
						return
					}
					ret, err = i.ChooseGPGMethod(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"switchToGPGSignOK": {
				MakeArg: func() interface{} {
					ret := make([]SwitchToGPGSignOKArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]SwitchToGPGSignOKArg)
					if !ok {
						err = rpc.NewTypeError((*[]SwitchToGPGSignOKArg)(nil), args)
						return
					}
					ret, err = i.SwitchToGPGSignOK(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"chooseDevice": {
				MakeArg: func() interface{} {
					ret := make([]ChooseDeviceArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]ChooseDeviceArg)
					if !ok {
						err = rpc.NewTypeError((*[]ChooseDeviceArg)(nil), args)
						return
					}
					ret, err = i.ChooseDevice(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"chooseDeviceType": {
				MakeArg: func() interface{} {
					ret := make([]ChooseDeviceTypeArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]ChooseDeviceTypeArg)
					if !ok {
						err = rpc.NewTypeError((*[]ChooseDeviceTypeArg)(nil), args)
						return
					}
					ret, err = i.ChooseDeviceType(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"DisplayAndPromptSecret": {
				MakeArg: func() interface{} {
					ret := make([]DisplayAndPromptSecretArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DisplayAndPromptSecretArg)
					if !ok {
						err = rpc.NewTypeError((*[]DisplayAndPromptSecretArg)(nil), args)
						return
					}
					ret, err = i.DisplayAndPromptSecret(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"DisplaySecretExchanged": {
				MakeArg: func() interface{} {
					ret := make([]DisplaySecretExchangedArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DisplaySecretExchangedArg)
					if !ok {
						err = rpc.NewTypeError((*[]DisplaySecretExchangedArg)(nil), args)
						return
					}
					err = i.DisplaySecretExchanged(ctx, (*typedArgs)[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"PromptNewDeviceName": {
				MakeArg: func() interface{} {
					ret := make([]PromptNewDeviceNameArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PromptNewDeviceNameArg)
					if !ok {
						err = rpc.NewTypeError((*[]PromptNewDeviceNameArg)(nil), args)
						return
					}
					ret, err = i.PromptNewDeviceName(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"ProvisioneeSuccess": {
				MakeArg: func() interface{} {
					ret := make([]ProvisioneeSuccessArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]ProvisioneeSuccessArg)
					if !ok {
						err = rpc.NewTypeError((*[]ProvisioneeSuccessArg)(nil), args)
						return
					}
					err = i.ProvisioneeSuccess(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"ProvisionerSuccess": {
				MakeArg: func() interface{} {
					ret := make([]ProvisionerSuccessArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]ProvisionerSuccessArg)
					if !ok {
						err = rpc.NewTypeError((*[]ProvisionerSuccessArg)(nil), args)
						return
					}
					err = i.ProvisionerSuccess(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type ProvisionUiClient struct {
	Cli rpc.GenericClient
}

// DEPRECATED:
// Called during device provisioning for the user to select a
// method for provisioning.  gpgOption will be true if GPG
// should be offered as an option.
func (c ProvisionUiClient) ChooseProvisioningMethod(ctx context.Context, __arg ChooseProvisioningMethodArg) (res ProvisionMethod, err error) {
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.chooseProvisioningMethod", []interface{}{__arg}, &res)
	return
}

// Called during device provisioning for the user to select a
// GPG method, either import the key into keybase's local keyring
// or use GPG to sign a provisioning statement.
//
// The keys are provided for display purposes, so the UI can
// do something like "We found the following GPG keys on this
// machine.  How would you like to use one of them to provision
// this device?"
//
// After this, gpg_ui.selectKey will be called (if there are
// multiple keys available).
func (c ProvisionUiClient) ChooseGPGMethod(ctx context.Context, __arg ChooseGPGMethodArg) (res GPGMethod, err error) {
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.chooseGPGMethod", []interface{}{__arg}, &res)
	return
}

// If there was an error importing a gpg key into the local
// keyring, tell the user and offer to switch to GPG signing
// with this key.  Return true to switch to GPG signing,
// false to abort provisioning.
func (c ProvisionUiClient) SwitchToGPGSignOK(ctx context.Context, __arg SwitchToGPGSignOKArg) (res bool, err error) {
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.switchToGPGSignOK", []interface{}{__arg}, &res)
	return
}

func (c ProvisionUiClient) ChooseDevice(ctx context.Context, __arg ChooseDeviceArg) (res DeviceID, err error) {
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.chooseDevice", []interface{}{__arg}, &res)
	return
}

// If provisioning via device, this will be called so user can select the provisioner/provisionee device type: desktop or mobile.
// If selecting the existing device type, set kind to EXISTING_DEVICE_0.
// If selecting the new device type, set kind to NEW_DEVICE_1.
func (c ProvisionUiClient) ChooseDeviceType(ctx context.Context, __arg ChooseDeviceTypeArg) (res DeviceType, err error) {
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.chooseDeviceType", []interface{}{__arg}, &res)
	return
}

// DisplayAndPromptSecret displays a secret that the user can enter into the other device.
// It also can return a secret that the user enters into this device (from the other device).
// If it does not return a secret, it will be canceled when this device receives the secret via kex2.
// If there is an error in the phrase, then previousErr will be set when this is called again.
func (c ProvisionUiClient) DisplayAndPromptSecret(ctx context.Context, __arg DisplayAndPromptSecretArg) (res SecretResponse, err error) {
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.DisplayAndPromptSecret", []interface{}{__arg}, &res)
	return
}

// DisplaySecretExchanged is called when the kex2 secret has successfully been exchanged by the two
// devices.
func (c ProvisionUiClient) DisplaySecretExchanged(ctx context.Context, sessionID int) (err error) {
	__arg := DisplaySecretExchangedArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.DisplaySecretExchanged", []interface{}{__arg}, nil)
	return
}

// PromptNewDeviceName is called when the device provisioning process needs a name for the new device.
// To help the clients not send a duplicate name, existingDevices is populated with the current device
// names for the user.  If the device name returned to the service is invalid or already
// taken, it will call this again with an error message in errorMessage.
func (c ProvisionUiClient) PromptNewDeviceName(ctx context.Context, __arg PromptNewDeviceNameArg) (res string, err error) {
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.PromptNewDeviceName", []interface{}{__arg}, &res)
	return
}

// ProvisioneeSuccess is called on provisionee when it is successfully provisioned.
func (c ProvisionUiClient) ProvisioneeSuccess(ctx context.Context, __arg ProvisioneeSuccessArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.ProvisioneeSuccess", []interface{}{__arg}, nil)
	return
}

// ProvisionerSuccess is called on provisioner when it successfully provisions another device.
func (c ProvisionUiClient) ProvisionerSuccess(ctx context.Context, __arg ProvisionerSuccessArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.provisionUi.ProvisionerSuccess", []interface{}{__arg}, nil)
	return
}
