// Auto-generated by avdl-compiler v1.3.20 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/keybase1/pgp_ui.avdl

package keybase1

import (
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type OutputSignatureSuccessArg struct {
	SessionID   int    `codec:"sessionID" json:"sessionID"`
	Fingerprint string `codec:"fingerprint" json:"fingerprint"`
	Username    string `codec:"username" json:"username"`
	SignedAt    Time   `codec:"signedAt" json:"signedAt"`
}

func (o OutputSignatureSuccessArg) DeepCopy() OutputSignatureSuccessArg {
	return OutputSignatureSuccessArg{
		SessionID:   o.SessionID,
		Fingerprint: o.Fingerprint,
		Username:    o.Username,
		SignedAt:    o.SignedAt.DeepCopy(),
	}
}

type OutputSignatureSuccessNonKeybaseArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	KeyID     string `codec:"keyID" json:"keyID"`
	SignedAt  Time   `codec:"signedAt" json:"signedAt"`
}

func (o OutputSignatureSuccessNonKeybaseArg) DeepCopy() OutputSignatureSuccessNonKeybaseArg {
	return OutputSignatureSuccessNonKeybaseArg{
		SessionID: o.SessionID,
		KeyID:     o.KeyID,
		SignedAt:  o.SignedAt.DeepCopy(),
	}
}

type KeyGeneratedArg struct {
	SessionID int     `codec:"sessionID" json:"sessionID"`
	Kid       KID     `codec:"kid" json:"kid"`
	Key       KeyInfo `codec:"key" json:"key"`
}

func (o KeyGeneratedArg) DeepCopy() KeyGeneratedArg {
	return KeyGeneratedArg{
		SessionID: o.SessionID,
		Kid:       o.Kid.DeepCopy(),
		Key:       o.Key.DeepCopy(),
	}
}

type ShouldPushPrivateArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

func (o ShouldPushPrivateArg) DeepCopy() ShouldPushPrivateArg {
	return ShouldPushPrivateArg{
		SessionID: o.SessionID,
	}
}

type FinishedArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

func (o FinishedArg) DeepCopy() FinishedArg {
	return FinishedArg{
		SessionID: o.SessionID,
	}
}

type PGPUiInterface interface {
	OutputSignatureSuccess(context.Context, OutputSignatureSuccessArg) error
	OutputSignatureSuccessNonKeybase(context.Context, OutputSignatureSuccessNonKeybaseArg) error
	KeyGenerated(context.Context, KeyGeneratedArg) error
	ShouldPushPrivate(context.Context, int) (bool, error)
	Finished(context.Context, int) error
}

func PGPUiProtocol(i PGPUiInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "keybase.1.pgpUi",
		Methods: map[string]rpc.ServeHandlerDescription{
			"outputSignatureSuccess": {
				MakeArg: func() interface{} {
					ret := make([]OutputSignatureSuccessArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]OutputSignatureSuccessArg)
					if !ok {
						err = rpc.NewTypeError((*[]OutputSignatureSuccessArg)(nil), args)
						return
					}
					err = i.OutputSignatureSuccess(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"outputSignatureSuccessNonKeybase": {
				MakeArg: func() interface{} {
					ret := make([]OutputSignatureSuccessNonKeybaseArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]OutputSignatureSuccessNonKeybaseArg)
					if !ok {
						err = rpc.NewTypeError((*[]OutputSignatureSuccessNonKeybaseArg)(nil), args)
						return
					}
					err = i.OutputSignatureSuccessNonKeybase(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"keyGenerated": {
				MakeArg: func() interface{} {
					ret := make([]KeyGeneratedArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]KeyGeneratedArg)
					if !ok {
						err = rpc.NewTypeError((*[]KeyGeneratedArg)(nil), args)
						return
					}
					err = i.KeyGenerated(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"shouldPushPrivate": {
				MakeArg: func() interface{} {
					ret := make([]ShouldPushPrivateArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]ShouldPushPrivateArg)
					if !ok {
						err = rpc.NewTypeError((*[]ShouldPushPrivateArg)(nil), args)
						return
					}
					ret, err = i.ShouldPushPrivate(ctx, (*typedArgs)[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"finished": {
				MakeArg: func() interface{} {
					ret := make([]FinishedArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]FinishedArg)
					if !ok {
						err = rpc.NewTypeError((*[]FinishedArg)(nil), args)
						return
					}
					err = i.Finished(ctx, (*typedArgs)[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type PGPUiClient struct {
	Cli rpc.GenericClient
}

func (c PGPUiClient) OutputSignatureSuccess(ctx context.Context, __arg OutputSignatureSuccessArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.pgpUi.outputSignatureSuccess", []interface{}{__arg}, nil)
	return
}

func (c PGPUiClient) OutputSignatureSuccessNonKeybase(ctx context.Context, __arg OutputSignatureSuccessNonKeybaseArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.pgpUi.outputSignatureSuccessNonKeybase", []interface{}{__arg}, nil)
	return
}

func (c PGPUiClient) KeyGenerated(ctx context.Context, __arg KeyGeneratedArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.pgpUi.keyGenerated", []interface{}{__arg}, nil)
	return
}

func (c PGPUiClient) ShouldPushPrivate(ctx context.Context, sessionID int) (res bool, err error) {
	__arg := ShouldPushPrivateArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.pgpUi.shouldPushPrivate", []interface{}{__arg}, &res)
	return
}

func (c PGPUiClient) Finished(ctx context.Context, sessionID int) (err error) {
	__arg := FinishedArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.pgpUi.finished", []interface{}{__arg}, nil)
	return
}
