// Auto-generated by avdl-compiler v1.3.20 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/keybase1/ctl.avdl

package keybase1

import (
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type ExitCode int

const (
	ExitCode_OK      ExitCode = 0
	ExitCode_NOTOK   ExitCode = 2
	ExitCode_RESTART ExitCode = 4
)

func (o ExitCode) DeepCopy() ExitCode { return o }

var ExitCodeMap = map[string]ExitCode{
	"OK":      0,
	"NOTOK":   2,
	"RESTART": 4,
}

var ExitCodeRevMap = map[ExitCode]string{
	0: "OK",
	2: "NOTOK",
	4: "RESTART",
}

func (e ExitCode) String() string {
	if v, ok := ExitCodeRevMap[e]; ok {
		return v
	}
	return ""
}

type DbType int

const (
	DbType_MAIN DbType = 0
	DbType_CHAT DbType = 1
)

func (o DbType) DeepCopy() DbType { return o }

var DbTypeMap = map[string]DbType{
	"MAIN": 0,
	"CHAT": 1,
}

var DbTypeRevMap = map[DbType]string{
	0: "MAIN",
	1: "CHAT",
}

func (e DbType) String() string {
	if v, ok := DbTypeRevMap[e]; ok {
		return v
	}
	return ""
}

type DbKey struct {
	DbType  DbType `codec:"dbType" json:"dbType"`
	ObjType int    `codec:"objType" json:"objType"`
	Key     string `codec:"key" json:"key"`
}

func (o DbKey) DeepCopy() DbKey {
	return DbKey{
		DbType:  o.DbType.DeepCopy(),
		ObjType: o.ObjType,
		Key:     o.Key,
	}
}

type DbValue []byte

func (o DbValue) DeepCopy() DbValue {
	return (func(x []byte) []byte {
		if x == nil {
			return nil
		}
		return append([]byte{}, x...)
	})(o)
}

type StopArg struct {
	SessionID int      `codec:"sessionID" json:"sessionID"`
	ExitCode  ExitCode `codec:"exitCode" json:"exitCode"`
}

func (o StopArg) DeepCopy() StopArg {
	return StopArg{
		SessionID: o.SessionID,
		ExitCode:  o.ExitCode.DeepCopy(),
	}
}

type LogRotateArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

func (o LogRotateArg) DeepCopy() LogRotateArg {
	return LogRotateArg{
		SessionID: o.SessionID,
	}
}

type ReloadArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

func (o ReloadArg) DeepCopy() ReloadArg {
	return ReloadArg{
		SessionID: o.SessionID,
	}
}

type DbNukeArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

func (o DbNukeArg) DeepCopy() DbNukeArg {
	return DbNukeArg{
		SessionID: o.SessionID,
	}
}

type AppExitArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

func (o AppExitArg) DeepCopy() AppExitArg {
	return AppExitArg{
		SessionID: o.SessionID,
	}
}

type DbDeleteArg struct {
	SessionID int   `codec:"sessionID" json:"sessionID"`
	Key       DbKey `codec:"key" json:"key"`
}

func (o DbDeleteArg) DeepCopy() DbDeleteArg {
	return DbDeleteArg{
		SessionID: o.SessionID,
		Key:       o.Key.DeepCopy(),
	}
}

type DbPutArg struct {
	SessionID int     `codec:"sessionID" json:"sessionID"`
	Key       DbKey   `codec:"key" json:"key"`
	Value     DbValue `codec:"value" json:"value"`
}

func (o DbPutArg) DeepCopy() DbPutArg {
	return DbPutArg{
		SessionID: o.SessionID,
		Key:       o.Key.DeepCopy(),
		Value:     o.Value.DeepCopy(),
	}
}

type DbGetArg struct {
	SessionID int   `codec:"sessionID" json:"sessionID"`
	Key       DbKey `codec:"key" json:"key"`
}

func (o DbGetArg) DeepCopy() DbGetArg {
	return DbGetArg{
		SessionID: o.SessionID,
		Key:       o.Key.DeepCopy(),
	}
}

type CtlInterface interface {
	Stop(context.Context, StopArg) error
	LogRotate(context.Context, int) error
	Reload(context.Context, int) error
	DbNuke(context.Context, int) error
	AppExit(context.Context, int) error
	DbDelete(context.Context, DbDeleteArg) error
	DbPut(context.Context, DbPutArg) error
	DbGet(context.Context, DbGetArg) (*DbValue, error)
}

func CtlProtocol(i CtlInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "keybase.1.ctl",
		Methods: map[string]rpc.ServeHandlerDescription{
			"stop": {
				MakeArg: func() interface{} {
					ret := make([]StopArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]StopArg)
					if !ok {
						err = rpc.NewTypeError((*[]StopArg)(nil), args)
						return
					}
					err = i.Stop(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"logRotate": {
				MakeArg: func() interface{} {
					ret := make([]LogRotateArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]LogRotateArg)
					if !ok {
						err = rpc.NewTypeError((*[]LogRotateArg)(nil), args)
						return
					}
					err = i.LogRotate(ctx, (*typedArgs)[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"reload": {
				MakeArg: func() interface{} {
					ret := make([]ReloadArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]ReloadArg)
					if !ok {
						err = rpc.NewTypeError((*[]ReloadArg)(nil), args)
						return
					}
					err = i.Reload(ctx, (*typedArgs)[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"dbNuke": {
				MakeArg: func() interface{} {
					ret := make([]DbNukeArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DbNukeArg)
					if !ok {
						err = rpc.NewTypeError((*[]DbNukeArg)(nil), args)
						return
					}
					err = i.DbNuke(ctx, (*typedArgs)[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"appExit": {
				MakeArg: func() interface{} {
					ret := make([]AppExitArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]AppExitArg)
					if !ok {
						err = rpc.NewTypeError((*[]AppExitArg)(nil), args)
						return
					}
					err = i.AppExit(ctx, (*typedArgs)[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"dbDelete": {
				MakeArg: func() interface{} {
					ret := make([]DbDeleteArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DbDeleteArg)
					if !ok {
						err = rpc.NewTypeError((*[]DbDeleteArg)(nil), args)
						return
					}
					err = i.DbDelete(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"dbPut": {
				MakeArg: func() interface{} {
					ret := make([]DbPutArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DbPutArg)
					if !ok {
						err = rpc.NewTypeError((*[]DbPutArg)(nil), args)
						return
					}
					err = i.DbPut(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"dbGet": {
				MakeArg: func() interface{} {
					ret := make([]DbGetArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DbGetArg)
					if !ok {
						err = rpc.NewTypeError((*[]DbGetArg)(nil), args)
						return
					}
					ret, err = i.DbGet(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type CtlClient struct {
	Cli rpc.GenericClient
}

func (c CtlClient) Stop(ctx context.Context, __arg StopArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.ctl.stop", []interface{}{__arg}, nil)
	return
}

func (c CtlClient) LogRotate(ctx context.Context, sessionID int) (err error) {
	__arg := LogRotateArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.ctl.logRotate", []interface{}{__arg}, nil)
	return
}

func (c CtlClient) Reload(ctx context.Context, sessionID int) (err error) {
	__arg := ReloadArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.ctl.reload", []interface{}{__arg}, nil)
	return
}

func (c CtlClient) DbNuke(ctx context.Context, sessionID int) (err error) {
	__arg := DbNukeArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.ctl.dbNuke", []interface{}{__arg}, nil)
	return
}

func (c CtlClient) AppExit(ctx context.Context, sessionID int) (err error) {
	__arg := AppExitArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.ctl.appExit", []interface{}{__arg}, nil)
	return
}

func (c CtlClient) DbDelete(ctx context.Context, __arg DbDeleteArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.ctl.dbDelete", []interface{}{__arg}, nil)
	return
}

func (c CtlClient) DbPut(ctx context.Context, __arg DbPutArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.ctl.dbPut", []interface{}{__arg}, nil)
	return
}

func (c CtlClient) DbGet(ctx context.Context, __arg DbGetArg) (res *DbValue, err error) {
	err = c.Cli.Call(ctx, "keybase.1.ctl.dbGet", []interface{}{__arg}, &res)
	return
}
