  // This file is autogenerated
  #import "KBRPC.h"

@implementation KBRCommonRequest

@end

@implementation KBRProveCommonRequest

@end

@implementation KBRIdentifyCommonRequest

@end

@implementation KBRSaltpackUiRequest

- (void)saltpackPromptForDecrypt:(KBRSaltpackPromptForDecryptRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"sender": KBRValue(params.sender), @"usedDelegateUI": @(params.usedDelegateUI)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpackUi.saltpackPromptForDecrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)saltpackPromptForDecryptWithSender:(KBRSaltpackSender *)sender usedDelegateUI:(BOOL)usedDelegateUI completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"sender": KBRValue(sender), @"usedDelegateUI": @(usedDelegateUI)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpackUi.saltpackPromptForDecrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)saltpackVerifySuccess:(KBRSaltpackVerifySuccessRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"signingKID": KBRValue(params.signingKID), @"sender": KBRValue(params.sender)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpackUi.saltpackVerifySuccess" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)saltpackVerifySuccessWithSigningKID:(NSString *)signingKID sender:(KBRSaltpackSender *)sender completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"signingKID": KBRValue(signingKID), @"sender": KBRValue(sender)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpackUi.saltpackVerifySuccess" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRAccountRequest

- (void)passphraseChange:(KBRPassphraseChangeRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"oldPassphrase": KBRValue(params.oldPassphrase), @"passphrase": KBRValue(params.passphrase), @"force": @(params.force)};
  [self.client sendRequestWithMethod:@"keybase.1.account.passphraseChange" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)passphraseChangeWithOldPassphrase:(NSString *)oldPassphrase passphrase:(NSString *)passphrase force:(BOOL)force completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"oldPassphrase": KBRValue(oldPassphrase), @"passphrase": KBRValue(passphrase), @"force": @(force)};
  [self.client sendRequestWithMethod:@"keybase.1.account.passphraseChange" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)passphrasePrompt:(KBRPassphrasePromptRequestParams *)params completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion {
  NSDictionary *rparams = @{@"guiArg": KBRValue(params.guiArg)};
  [self.client sendRequestWithMethod:@"keybase.1.account.passphrasePrompt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRGetPassphraseRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRGetPassphraseRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)passphrasePromptWithGuiArg:(KBRGUIEntryArg *)guiArg completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion {
  NSDictionary *rparams = @{@"guiArg": KBRValue(guiArg)};
  [self.client sendRequestWithMethod:@"keybase.1.account.passphrasePrompt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRGetPassphraseRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRGetPassphraseRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRApiserverRequest

- (void)get:(KBRGetRequestParams *)params completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion {
  NSDictionary *rparams = @{@"endpoint": KBRValue(params.endpoint), @"args": KBRValue(params.args), @"httpStatus": KBRValue(params.httpStatus), @"appStatusCode": KBRValue(params.appStatusCode)};
  [self.client sendRequestWithMethod:@"keybase.1.apiserver.Get" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRAPIRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRAPIRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getWithEndpoint:(NSString *)endpoint args:(NSArray *)args httpStatus:(NSArray *)httpStatus appStatusCode:(NSArray *)appStatusCode completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion {
  NSDictionary *rparams = @{@"endpoint": KBRValue(endpoint), @"args": KBRValue(args), @"httpStatus": KBRValue(httpStatus), @"appStatusCode": KBRValue(appStatusCode)};
  [self.client sendRequestWithMethod:@"keybase.1.apiserver.Get" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRAPIRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRAPIRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)post:(KBRPostRequestParams *)params completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion {
  NSDictionary *rparams = @{@"endpoint": KBRValue(params.endpoint), @"args": KBRValue(params.args), @"httpStatus": KBRValue(params.httpStatus), @"appStatusCode": KBRValue(params.appStatusCode)};
  [self.client sendRequestWithMethod:@"keybase.1.apiserver.Post" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRAPIRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRAPIRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)postWithEndpoint:(NSString *)endpoint args:(NSArray *)args httpStatus:(NSArray *)httpStatus appStatusCode:(NSArray *)appStatusCode completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion {
  NSDictionary *rparams = @{@"endpoint": KBRValue(endpoint), @"args": KBRValue(args), @"httpStatus": KBRValue(httpStatus), @"appStatusCode": KBRValue(appStatusCode)};
  [self.client sendRequestWithMethod:@"keybase.1.apiserver.Post" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRAPIRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRAPIRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)postJSON:(KBRPostJSONRequestParams *)params completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion {
  NSDictionary *rparams = @{@"endpoint": KBRValue(params.endpoint), @"args": KBRValue(params.args), @"JSONPayload": KBRValue(params.JSONPayload), @"httpStatus": KBRValue(params.httpStatus), @"appStatusCode": KBRValue(params.appStatusCode)};
  [self.client sendRequestWithMethod:@"keybase.1.apiserver.PostJSON" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRAPIRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRAPIRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)postJSONWithEndpoint:(NSString *)endpoint args:(NSArray *)args JSONPayload:(NSArray *)JSONPayload httpStatus:(NSArray *)httpStatus appStatusCode:(NSArray *)appStatusCode completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion {
  NSDictionary *rparams = @{@"endpoint": KBRValue(endpoint), @"args": KBRValue(args), @"JSONPayload": KBRValue(JSONPayload), @"httpStatus": KBRValue(httpStatus), @"appStatusCode": KBRValue(appStatusCode)};
  [self.client sendRequestWithMethod:@"keybase.1.apiserver.PostJSON" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRAPIRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRAPIRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRBackendCommonRequest

@end

@implementation KBRBlockRequest

- (void)getSessionChallenge:(void (^)(NSError *error, KBRChallengeInfo *challengeInfo))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.block.getSessionChallenge" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRChallengeInfo *result = retval ? [MTLJSONAdapter modelOfClass:KBRChallengeInfo.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)authenticateSession:(KBRAuthenticateSessionRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"signature": KBRValue(params.signature)};
  [self.client sendRequestWithMethod:@"keybase.1.block.authenticateSession" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)authenticateSessionWithSignature:(NSString *)signature completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"signature": KBRValue(signature)};
  [self.client sendRequestWithMethod:@"keybase.1.block.authenticateSession" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)putBlock:(KBRPutBlockRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"bid": KBRValue(params.bid), @"folder": KBRValue(params.folder), @"blockKey": KBRValue(params.blockKey), @"buf": KBRValue(params.buf)};
  [self.client sendRequestWithMethod:@"keybase.1.block.putBlock" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)putBlockWithBid:(KBRBlockIdCombo *)bid folder:(NSString *)folder blockKey:(NSString *)blockKey buf:(NSData *)buf completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"bid": KBRValue(bid), @"folder": KBRValue(folder), @"blockKey": KBRValue(blockKey), @"buf": KBRValue(buf)};
  [self.client sendRequestWithMethod:@"keybase.1.block.putBlock" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)getBlock:(KBRGetBlockRequestParams *)params completion:(void (^)(NSError *error, KBRGetBlockRes *getBlockRes))completion {
  NSDictionary *rparams = @{@"bid": KBRValue(params.bid), @"folder": KBRValue(params.folder)};
  [self.client sendRequestWithMethod:@"keybase.1.block.getBlock" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRGetBlockRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRGetBlockRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getBlockWithBid:(KBRBlockIdCombo *)bid folder:(NSString *)folder completion:(void (^)(NSError *error, KBRGetBlockRes *getBlockRes))completion {
  NSDictionary *rparams = @{@"bid": KBRValue(bid), @"folder": KBRValue(folder)};
  [self.client sendRequestWithMethod:@"keybase.1.block.getBlock" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRGetBlockRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRGetBlockRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)addReference:(KBRAddReferenceRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(params.folder), @"ref": KBRValue(params.ref)};
  [self.client sendRequestWithMethod:@"keybase.1.block.addReference" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)addReferenceWithFolder:(NSString *)folder ref:(KBRBlockReference *)ref completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(folder), @"ref": KBRValue(ref)};
  [self.client sendRequestWithMethod:@"keybase.1.block.addReference" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)delReference:(KBRDelReferenceRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(params.folder), @"ref": KBRValue(params.ref)};
  [self.client sendRequestWithMethod:@"keybase.1.block.delReference" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)delReferenceWithFolder:(NSString *)folder ref:(KBRBlockReference *)ref completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(folder), @"ref": KBRValue(ref)};
  [self.client sendRequestWithMethod:@"keybase.1.block.delReference" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)archiveReference:(KBRArchiveReferenceRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(params.folder), @"refs": KBRValue(params.refs)};
  [self.client sendRequestWithMethod:@"keybase.1.block.archiveReference" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRBlockReference.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)archiveReferenceWithFolder:(NSString *)folder refs:(NSArray *)refs completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(folder), @"refs": KBRValue(refs)};
  [self.client sendRequestWithMethod:@"keybase.1.block.archiveReference" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRBlockReference.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)delReferenceWithCount:(KBRDelReferenceWithCountRequestParams *)params completion:(void (^)(NSError *error, KBRDowngradeReferenceRes *downgradeReferenceRes))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(params.folder), @"refs": KBRValue(params.refs)};
  [self.client sendRequestWithMethod:@"keybase.1.block.delReferenceWithCount" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRDowngradeReferenceRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRDowngradeReferenceRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)delReferenceWithCountWithFolder:(NSString *)folder refs:(NSArray *)refs completion:(void (^)(NSError *error, KBRDowngradeReferenceRes *downgradeReferenceRes))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(folder), @"refs": KBRValue(refs)};
  [self.client sendRequestWithMethod:@"keybase.1.block.delReferenceWithCount" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRDowngradeReferenceRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRDowngradeReferenceRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)archiveReferenceWithCount:(KBRArchiveReferenceWithCountRequestParams *)params completion:(void (^)(NSError *error, KBRDowngradeReferenceRes *downgradeReferenceRes))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(params.folder), @"refs": KBRValue(params.refs)};
  [self.client sendRequestWithMethod:@"keybase.1.block.archiveReferenceWithCount" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRDowngradeReferenceRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRDowngradeReferenceRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)archiveReferenceWithCountWithFolder:(NSString *)folder refs:(NSArray *)refs completion:(void (^)(NSError *error, KBRDowngradeReferenceRes *downgradeReferenceRes))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(folder), @"refs": KBRValue(refs)};
  [self.client sendRequestWithMethod:@"keybase.1.block.archiveReferenceWithCount" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRDowngradeReferenceRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRDowngradeReferenceRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getUserQuotaInfo:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.block.getUserQuotaInfo" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRBTCRequest

- (void)registerBTC:(KBRRegisterBTCRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"address": KBRValue(params.address), @"force": @(params.force)};
  [self.client sendRequestWithMethod:@"keybase.1.BTC.registerBTC" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)registerBTCWithAddress:(NSString *)address force:(BOOL)force completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"address": KBRValue(address), @"force": @(force)};
  [self.client sendRequestWithMethod:@"keybase.1.BTC.registerBTC" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRConfigRequest

- (void)getCurrentStatus:(void (^)(NSError *error, KBRGetCurrentStatusRes *getCurrentStatusRes))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.config.getCurrentStatus" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRGetCurrentStatusRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRGetCurrentStatusRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getExtendedStatus:(void (^)(NSError *error, KBRExtendedStatus *extendedStatus))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.config.getExtendedStatus" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRExtendedStatus *result = retval ? [MTLJSONAdapter modelOfClass:KBRExtendedStatus.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getConfig:(void (^)(NSError *error, KBRConfig *config))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.config.getConfig" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRConfig *result = retval ? [MTLJSONAdapter modelOfClass:KBRConfig.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)setUserConfig:(KBRSetUserConfigRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username), @"key": KBRValue(params.key), @"value": KBRValue(params.value)};
  [self.client sendRequestWithMethod:@"keybase.1.config.setUserConfig" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)setUserConfigWithUsername:(NSString *)username key:(NSString *)key value:(NSString *)value completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username), @"key": KBRValue(key), @"value": KBRValue(value)};
  [self.client sendRequestWithMethod:@"keybase.1.config.setUserConfig" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)setPath:(KBRSetPathRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"path": KBRValue(params.path)};
  [self.client sendRequestWithMethod:@"keybase.1.config.setPath" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)setPathWithPath:(NSString *)path completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"path": KBRValue(path)};
  [self.client sendRequestWithMethod:@"keybase.1.config.setPath" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)helloIAm:(KBRHelloIAmRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"details": KBRValue(params.details)};
  [self.client sendRequestWithMethod:@"keybase.1.config.helloIAm" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)helloIAmWithDetails:(KBRClientDetails *)details completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"details": KBRValue(details)};
  [self.client sendRequestWithMethod:@"keybase.1.config.helloIAm" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)setValue:(KBRSetValueRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"path": KBRValue(params.path), @"value": KBRValue(params.value)};
  [self.client sendRequestWithMethod:@"keybase.1.config.setValue" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)setValueWithPath:(NSString *)path value:(KBRConfigValue *)value completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"path": KBRValue(path), @"value": KBRValue(value)};
  [self.client sendRequestWithMethod:@"keybase.1.config.setValue" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)clearValue:(KBRClearValueRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"path": KBRValue(params.path)};
  [self.client sendRequestWithMethod:@"keybase.1.config.clearValue" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)clearValueWithPath:(NSString *)path completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"path": KBRValue(path)};
  [self.client sendRequestWithMethod:@"keybase.1.config.clearValue" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)getValue:(KBRGetValueRequestParams *)params completion:(void (^)(NSError *error, KBRConfigValue *configValue))completion {
  NSDictionary *rparams = @{@"path": KBRValue(params.path)};
  [self.client sendRequestWithMethod:@"keybase.1.config.getValue" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRConfigValue *result = retval ? [MTLJSONAdapter modelOfClass:KBRConfigValue.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getValueWithPath:(NSString *)path completion:(void (^)(NSError *error, KBRConfigValue *configValue))completion {
  NSDictionary *rparams = @{@"path": KBRValue(path)};
  [self.client sendRequestWithMethod:@"keybase.1.config.getValue" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRConfigValue *result = retval ? [MTLJSONAdapter modelOfClass:KBRConfigValue.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)checkAPIServerOutOfDateWarning:(void (^)(NSError *error, KBROutOfDateInfo *outOfDateInfo))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.config.checkAPIServerOutOfDateWarning" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBROutOfDateInfo *result = retval ? [MTLJSONAdapter modelOfClass:KBROutOfDateInfo.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRConstantsRequest

@end

@implementation KBRCryptoRequest

- (void)signED25519:(KBRSignED25519RequestParams *)params completion:(void (^)(NSError *error, KBRED25519SignatureInfo *eD25519SignatureInfo))completion {
  NSDictionary *rparams = @{@"msg": KBRValue(params.msg), @"reason": KBRValue(params.reason)};
  [self.client sendRequestWithMethod:@"keybase.1.crypto.signED25519" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRED25519SignatureInfo *result = retval ? [MTLJSONAdapter modelOfClass:KBRED25519SignatureInfo.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)signED25519WithMsg:(NSData *)msg reason:(NSString *)reason completion:(void (^)(NSError *error, KBRED25519SignatureInfo *eD25519SignatureInfo))completion {
  NSDictionary *rparams = @{@"msg": KBRValue(msg), @"reason": KBRValue(reason)};
  [self.client sendRequestWithMethod:@"keybase.1.crypto.signED25519" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRED25519SignatureInfo *result = retval ? [MTLJSONAdapter modelOfClass:KBRED25519SignatureInfo.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)signToString:(KBRSignToStringRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"msg": KBRValue(params.msg), @"reason": KBRValue(params.reason)};
  [self.client sendRequestWithMethod:@"keybase.1.crypto.signToString" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)signToStringWithMsg:(NSData *)msg reason:(NSString *)reason completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"msg": KBRValue(msg), @"reason": KBRValue(reason)};
  [self.client sendRequestWithMethod:@"keybase.1.crypto.signToString" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)unboxBytes32:(KBRUnboxBytes32RequestParams *)params completion:(void (^)(NSError *error, NSData *bytes32))completion {
  NSDictionary *rparams = @{@"encryptedBytes32": KBRValue(params.encryptedBytes32), @"nonce": KBRValue(params.nonce), @"peersPublicKey": KBRValue(params.peersPublicKey), @"reason": KBRValue(params.reason)};
  [self.client sendRequestWithMethod:@"keybase.1.crypto.unboxBytes32" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)unboxBytes32WithEncryptedBytes32:(NSData *)encryptedBytes32 nonce:(NSData *)nonce peersPublicKey:(NSData *)peersPublicKey reason:(NSString *)reason completion:(void (^)(NSError *error, NSData *bytes32))completion {
  NSDictionary *rparams = @{@"encryptedBytes32": KBRValue(encryptedBytes32), @"nonce": KBRValue(nonce), @"peersPublicKey": KBRValue(peersPublicKey), @"reason": KBRValue(reason)};
  [self.client sendRequestWithMethod:@"keybase.1.crypto.unboxBytes32" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)unboxBytes32Any:(KBRUnboxBytes32AnyRequestParams *)params completion:(void (^)(NSError *error, KBRUnboxAnyRes *unboxAnyRes))completion {
  NSDictionary *rparams = @{@"bundles": KBRValue(params.bundles), @"reason": KBRValue(params.reason), @"promptPaper": @(params.promptPaper)};
  [self.client sendRequestWithMethod:@"keybase.1.crypto.unboxBytes32Any" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUnboxAnyRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRUnboxAnyRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)unboxBytes32AnyWithBundles:(NSArray *)bundles reason:(NSString *)reason promptPaper:(BOOL)promptPaper completion:(void (^)(NSError *error, KBRUnboxAnyRes *unboxAnyRes))completion {
  NSDictionary *rparams = @{@"bundles": KBRValue(bundles), @"reason": KBRValue(reason), @"promptPaper": @(promptPaper)};
  [self.client sendRequestWithMethod:@"keybase.1.crypto.unboxBytes32Any" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUnboxAnyRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRUnboxAnyRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRCtlRequest

- (void)stop:(KBRStopRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"exitCode": @(params.exitCode)};
  [self.client sendRequestWithMethod:@"keybase.1.ctl.stop" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)stopWithExitCode:(KBRExitCode)exitCode completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"exitCode": @(exitCode)};
  [self.client sendRequestWithMethod:@"keybase.1.ctl.stop" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)logRotate:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.ctl.logRotate" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)reload:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.ctl.reload" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)dbNuke:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.ctl.dbNuke" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)appExit:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.ctl.appExit" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRDebuggingRequest

- (void)firstStep:(KBRFirstStepRequestParams *)params completion:(void (^)(NSError *error, KBRFirstStepResult *firstStepResult))completion {
  NSDictionary *rparams = @{@"val": @(params.val)};
  [self.client sendRequestWithMethod:@"keybase.1.debugging.firstStep" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRFirstStepResult *result = retval ? [MTLJSONAdapter modelOfClass:KBRFirstStepResult.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)firstStepWithVal:(NSInteger)val completion:(void (^)(NSError *error, KBRFirstStepResult *firstStepResult))completion {
  NSDictionary *rparams = @{@"val": @(val)};
  [self.client sendRequestWithMethod:@"keybase.1.debugging.firstStep" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRFirstStepResult *result = retval ? [MTLJSONAdapter modelOfClass:KBRFirstStepResult.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)secondStep:(KBRSecondStepRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{@"val": @(params.val)};
  [self.client sendRequestWithMethod:@"keybase.1.debugging.secondStep" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)secondStepWithVal:(NSInteger)val completion:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{@"val": @(val)};
  [self.client sendRequestWithMethod:@"keybase.1.debugging.secondStep" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)increment:(KBRIncrementRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{@"val": @(params.val)};
  [self.client sendRequestWithMethod:@"keybase.1.debugging.increment" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)incrementWithVal:(NSInteger)val completion:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{@"val": @(val)};
  [self.client sendRequestWithMethod:@"keybase.1.debugging.increment" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

@end

@implementation KBRDelegateUiCtlRequest

- (void)registerIdentifyUI:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.delegateUiCtl.registerIdentifyUI" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)registerSecretUI:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.delegateUiCtl.registerSecretUI" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)registerUpdateUI:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.delegateUiCtl.registerUpdateUI" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)registerRekeyUI:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.delegateUiCtl.registerRekeyUI" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)registerGregorFirehose:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.delegateUiCtl.registerGregorFirehose" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRDeviceRequest

- (void)deviceList:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.device.deviceList" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRDevice.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)deviceHistoryList:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.device.deviceHistoryList" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRDeviceDetail.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)deviceAdd:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.device.deviceAdd" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)checkDeviceNameFormat:(KBRCheckDeviceNameFormatRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"name": KBRValue(params.name)};
  [self.client sendRequestWithMethod:@"keybase.1.device.checkDeviceNameFormat" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)checkDeviceNameFormatWithName:(NSString *)name completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"name": KBRValue(name)};
  [self.client sendRequestWithMethod:@"keybase.1.device.checkDeviceNameFormat" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

@end

@implementation KBRFavoriteRequest

- (void)favoriteAdd:(KBRFavoriteAddRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(params.folder)};
  [self.client sendRequestWithMethod:@"keybase.1.favorite.favoriteAdd" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)favoriteAddWithFolder:(KBRFolder *)folder completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(folder)};
  [self.client sendRequestWithMethod:@"keybase.1.favorite.favoriteAdd" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)favoriteIgnore:(KBRFavoriteIgnoreRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(params.folder)};
  [self.client sendRequestWithMethod:@"keybase.1.favorite.favoriteIgnore" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)favoriteIgnoreWithFolder:(KBRFolder *)folder completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folder": KBRValue(folder)};
  [self.client sendRequestWithMethod:@"keybase.1.favorite.favoriteIgnore" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)getFavorites:(void (^)(NSError *error, KBRFavoritesResult *favoritesResult))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.favorite.getFavorites" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRFavoritesResult *result = retval ? [MTLJSONAdapter modelOfClass:KBRFavoritesResult.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRFsRequest

- (void)list:(KBRListRequestParams *)params completion:(void (^)(NSError *error, KBRListResult *listResult))completion {
  NSDictionary *rparams = @{@"path": KBRValue(params.path)};
  [self.client sendRequestWithMethod:@"keybase.1.fs.List" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRListResult *result = retval ? [MTLJSONAdapter modelOfClass:KBRListResult.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)listWithPath:(NSString *)path completion:(void (^)(NSError *error, KBRListResult *listResult))completion {
  NSDictionary *rparams = @{@"path": KBRValue(path)};
  [self.client sendRequestWithMethod:@"keybase.1.fs.List" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRListResult *result = retval ? [MTLJSONAdapter modelOfClass:KBRListResult.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRGpgCommonRequest

@end

@implementation KBRGpgUiRequest

- (void)wantToAddGPGKey:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.gpgUi.wantToAddGPGKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)confirmDuplicateKeyChosen:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.gpgUi.confirmDuplicateKeyChosen" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)selectKeyAndPushOption:(KBRSelectKeyAndPushOptionRequestParams *)params completion:(void (^)(NSError *error, KBRSelectKeyRes *selectKeyRes))completion {
  NSDictionary *rparams = @{@"keys": KBRValue(params.keys)};
  [self.client sendRequestWithMethod:@"keybase.1.gpgUi.selectKeyAndPushOption" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSelectKeyRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRSelectKeyRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)selectKeyAndPushOptionWithKeys:(NSArray *)keys completion:(void (^)(NSError *error, KBRSelectKeyRes *selectKeyRes))completion {
  NSDictionary *rparams = @{@"keys": KBRValue(keys)};
  [self.client sendRequestWithMethod:@"keybase.1.gpgUi.selectKeyAndPushOption" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSelectKeyRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRSelectKeyRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)selectKey:(KBRSelectKeyRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"keys": KBRValue(params.keys)};
  [self.client sendRequestWithMethod:@"keybase.1.gpgUi.selectKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)selectKeyWithKeys:(NSArray *)keys completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"keys": KBRValue(keys)};
  [self.client sendRequestWithMethod:@"keybase.1.gpgUi.selectKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)sign:(KBRSignRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"msg": KBRValue(params.msg), @"fingerprint": KBRValue(params.fingerprint)};
  [self.client sendRequestWithMethod:@"keybase.1.gpgUi.sign" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)signWithMsg:(NSData *)msg fingerprint:(NSData *)fingerprint completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"msg": KBRValue(msg), @"fingerprint": KBRValue(fingerprint)};
  [self.client sendRequestWithMethod:@"keybase.1.gpgUi.sign" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRIdentifyRequest

- (void)resolve:(KBRResolveRequestParams *)params completion:(void (^)(NSError *error, NSString *uID))completion {
  NSDictionary *rparams = @{@"assertion": KBRValue(params.assertion)};
  [self.client sendRequestWithMethod:@"keybase.1.identify.Resolve" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)resolveWithAssertion:(NSString *)assertion completion:(void (^)(NSError *error, NSString *uID))completion {
  NSDictionary *rparams = @{@"assertion": KBRValue(assertion)};
  [self.client sendRequestWithMethod:@"keybase.1.identify.Resolve" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)resolve2:(KBRResolve2RequestParams *)params completion:(void (^)(NSError *error, KBRUser *user))completion {
  NSDictionary *rparams = @{@"assertion": KBRValue(params.assertion)};
  [self.client sendRequestWithMethod:@"keybase.1.identify.Resolve2" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUser *result = retval ? [MTLJSONAdapter modelOfClass:KBRUser.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)resolve2WithAssertion:(NSString *)assertion completion:(void (^)(NSError *error, KBRUser *user))completion {
  NSDictionary *rparams = @{@"assertion": KBRValue(assertion)};
  [self.client sendRequestWithMethod:@"keybase.1.identify.Resolve2" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUser *result = retval ? [MTLJSONAdapter modelOfClass:KBRUser.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)identify:(KBRIdentifyRequestParams *)params completion:(void (^)(NSError *error, KBRIdentifyRes *identifyRes))completion {
  NSDictionary *rparams = @{@"userAssertion": KBRValue(params.userAssertion), @"forceRemoteCheck": @(params.forceRemoteCheck), @"useDelegateUI": @(params.useDelegateUI), @"reason": KBRValue(params.reason), @"source": @(params.source)};
  [self.client sendRequestWithMethod:@"keybase.1.identify.identify" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRIdentifyRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRIdentifyRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)identifyWithUserAssertion:(NSString *)userAssertion forceRemoteCheck:(BOOL)forceRemoteCheck useDelegateUI:(BOOL)useDelegateUI reason:(KBRIdentifyReason *)reason source:(KBRClientType)source completion:(void (^)(NSError *error, KBRIdentifyRes *identifyRes))completion {
  NSDictionary *rparams = @{@"userAssertion": KBRValue(userAssertion), @"forceRemoteCheck": @(forceRemoteCheck), @"useDelegateUI": @(useDelegateUI), @"reason": KBRValue(reason), @"source": @(source)};
  [self.client sendRequestWithMethod:@"keybase.1.identify.identify" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRIdentifyRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRIdentifyRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)identify2:(KBRIdentify2RequestParams *)params completion:(void (^)(NSError *error, KBRIdentify2Res *identify2Res))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid), @"userAssertion": KBRValue(params.userAssertion), @"reason": KBRValue(params.reason), @"useDelegateUI": @(params.useDelegateUI), @"alwaysBlock": @(params.alwaysBlock), @"noErrorOnTrackFailure": @(params.noErrorOnTrackFailure), @"forceRemoteCheck": @(params.forceRemoteCheck), @"needProofSet": @(params.needProofSet), @"allowEmptySelfID": @(params.allowEmptySelfID), @"noSkipSelf": @(params.noSkipSelf)};
  [self.client sendRequestWithMethod:@"keybase.1.identify.identify2" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRIdentify2Res *result = retval ? [MTLJSONAdapter modelOfClass:KBRIdentify2Res.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)identify2WithUid:(NSString *)uid userAssertion:(NSString *)userAssertion reason:(KBRIdentifyReason *)reason useDelegateUI:(BOOL)useDelegateUI alwaysBlock:(BOOL)alwaysBlock noErrorOnTrackFailure:(BOOL)noErrorOnTrackFailure forceRemoteCheck:(BOOL)forceRemoteCheck needProofSet:(BOOL)needProofSet allowEmptySelfID:(BOOL)allowEmptySelfID noSkipSelf:(BOOL)noSkipSelf completion:(void (^)(NSError *error, KBRIdentify2Res *identify2Res))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid), @"userAssertion": KBRValue(userAssertion), @"reason": KBRValue(reason), @"useDelegateUI": @(useDelegateUI), @"alwaysBlock": @(alwaysBlock), @"noErrorOnTrackFailure": @(noErrorOnTrackFailure), @"forceRemoteCheck": @(forceRemoteCheck), @"needProofSet": @(needProofSet), @"allowEmptySelfID": @(allowEmptySelfID), @"noSkipSelf": @(noSkipSelf)};
  [self.client sendRequestWithMethod:@"keybase.1.identify.identify2" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRIdentify2Res *result = retval ? [MTLJSONAdapter modelOfClass:KBRIdentify2Res.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRIdentifyUiRequest

- (void)displayTLFCreateWithInvite:(KBRDisplayTLFCreateWithInviteRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderName": KBRValue(params.folderName), @"isPrivate": @(params.isPrivate), @"assertion": KBRValue(params.assertion), @"socialAssertion": KBRValue(params.socialAssertion), @"inviteLink": KBRValue(params.inviteLink), @"throttled": @(params.throttled)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayTLFCreateWithInvite" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayTLFCreateWithInviteWithFolderName:(NSString *)folderName isPrivate:(BOOL)isPrivate assertion:(NSString *)assertion socialAssertion:(KBRSocialAssertion *)socialAssertion inviteLink:(NSString *)inviteLink throttled:(BOOL)throttled completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderName": KBRValue(folderName), @"isPrivate": @(isPrivate), @"assertion": KBRValue(assertion), @"socialAssertion": KBRValue(socialAssertion), @"inviteLink": KBRValue(inviteLink), @"throttled": @(throttled)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayTLFCreateWithInvite" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)delegateIdentifyUI:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.delegateIdentifyUI" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)start:(KBRStartRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username), @"reason": KBRValue(params.reason)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.start" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)startWithUsername:(NSString *)username reason:(KBRIdentifyReason *)reason completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username), @"reason": KBRValue(reason)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.start" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayKey:(KBRDisplayKeyRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"key": KBRValue(params.key)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayKeyWithKey:(KBRIdentifyKey *)key completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"key": KBRValue(key)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)reportLastTrack:(KBRReportLastTrackRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"track": KBRValue(params.track)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.reportLastTrack" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)reportLastTrackWithTrack:(KBRTrackSummary *)track completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"track": KBRValue(track)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.reportLastTrack" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)launchNetworkChecks:(KBRLaunchNetworkChecksRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"identity": KBRValue(params.identity), @"user": KBRValue(params.user)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.launchNetworkChecks" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)launchNetworkChecksWithIdentity:(KBRIdentity *)identity user:(KBRUser *)user completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"identity": KBRValue(identity), @"user": KBRValue(user)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.launchNetworkChecks" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayTrackStatement:(KBRDisplayTrackStatementRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"stmt": KBRValue(params.stmt)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayTrackStatement" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayTrackStatementWithStmt:(NSString *)stmt completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"stmt": KBRValue(stmt)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayTrackStatement" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)finishWebProofCheck:(KBRFinishWebProofCheckRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"rp": KBRValue(params.rp), @"lcr": KBRValue(params.lcr)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.finishWebProofCheck" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)finishWebProofCheckWithRp:(KBRRemoteProof *)rp lcr:(KBRLinkCheckResult *)lcr completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"rp": KBRValue(rp), @"lcr": KBRValue(lcr)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.finishWebProofCheck" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)finishSocialProofCheck:(KBRFinishSocialProofCheckRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"rp": KBRValue(params.rp), @"lcr": KBRValue(params.lcr)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.finishSocialProofCheck" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)finishSocialProofCheckWithRp:(KBRRemoteProof *)rp lcr:(KBRLinkCheckResult *)lcr completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"rp": KBRValue(rp), @"lcr": KBRValue(lcr)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.finishSocialProofCheck" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayCryptocurrency:(KBRDisplayCryptocurrencyRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"c": KBRValue(params.c)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayCryptocurrency" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayCryptocurrencyWithC:(KBRCryptocurrency *)c completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"c": KBRValue(c)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayCryptocurrency" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)reportTrackToken:(KBRReportTrackTokenRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"trackToken": KBRValue(params.trackToken)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.reportTrackToken" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)reportTrackTokenWithTrackToken:(NSString *)trackToken completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"trackToken": KBRValue(trackToken)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.reportTrackToken" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayUserCard:(KBRDisplayUserCardRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"card": KBRValue(params.card)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayUserCard" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayUserCardWithCard:(KBRUserCard *)card completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"card": KBRValue(card)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.displayUserCard" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)confirm:(KBRConfirmRequestParams *)params completion:(void (^)(NSError *error, KBRConfirmResult *confirmResult))completion {
  NSDictionary *rparams = @{@"outcome": KBRValue(params.outcome)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.confirm" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRConfirmResult *result = retval ? [MTLJSONAdapter modelOfClass:KBRConfirmResult.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)confirmWithOutcome:(KBRIdentifyOutcome *)outcome completion:(void (^)(NSError *error, KBRConfirmResult *confirmResult))completion {
  NSDictionary *rparams = @{@"outcome": KBRValue(outcome)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.confirm" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRConfirmResult *result = retval ? [MTLJSONAdapter modelOfClass:KBRConfirmResult.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)finish:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.finish" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)dismiss:(KBRDismissRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username), @"reason": KBRValue(params.reason)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.dismiss" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)dismissWithUsername:(NSString *)username reason:(KBRDismissReason *)reason completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username), @"reason": KBRValue(reason)};
  [self.client sendRequestWithMethod:@"keybase.1.identifyUi.dismiss" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRInstallRequest

@end

@implementation KBRKbfsRequest

- (void)fSEvent:(KBRFSEventRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"event": KBRValue(params.event)};
  [self.client sendRequestWithMethod:@"keybase.1.kbfs.FSEvent" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)fSEventWithEvent:(KBRFSNotification *)event completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"event": KBRValue(event)};
  [self.client sendRequestWithMethod:@"keybase.1.kbfs.FSEvent" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRKbfsCommonRequest

@end

@implementation KBRKex2ProvisioneeRequest

- (void)hello:(KBRHelloRequestParams *)params completion:(void (^)(NSError *error, NSString *helloRes))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid), @"token": KBRValue(params.token), @"csrf": KBRValue(params.csrf), @"pps": KBRValue(params.pps), @"sigBody": KBRValue(params.sigBody)};
  [self.client sendRequestWithMethod:@"keybase.1.Kex2Provisionee.hello" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)helloWithUid:(NSString *)uid token:(NSString *)token csrf:(NSString *)csrf pps:(KBRPassphraseStream *)pps sigBody:(NSString *)sigBody completion:(void (^)(NSError *error, NSString *helloRes))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid), @"token": KBRValue(token), @"csrf": KBRValue(csrf), @"pps": KBRValue(pps), @"sigBody": KBRValue(sigBody)};
  [self.client sendRequestWithMethod:@"keybase.1.Kex2Provisionee.hello" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)didCounterSign:(KBRDidCounterSignRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"sig": KBRValue(params.sig)};
  [self.client sendRequestWithMethod:@"keybase.1.Kex2Provisionee.didCounterSign" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)didCounterSignWithSig:(NSData *)sig completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"sig": KBRValue(sig)};
  [self.client sendRequestWithMethod:@"keybase.1.Kex2Provisionee.didCounterSign" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRKex2ProvisionerRequest

- (void)kexStart:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.Kex2Provisioner.kexStart" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRLogRequest

- (void)registerLogger:(KBRRegisterLoggerRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"name": KBRValue(params.name), @"level": @(params.level)};
  [self.client sendRequestWithMethod:@"keybase.1.log.registerLogger" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)registerLoggerWithName:(NSString *)name level:(KBRLogLevel)level completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"name": KBRValue(name), @"level": @(level)};
  [self.client sendRequestWithMethod:@"keybase.1.log.registerLogger" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRLogUiRequest

- (void)log:(KBRLogRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"level": @(params.level), @"text": KBRValue(params.text)};
  [self.client sendRequestWithMethod:@"keybase.1.logUi.log" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)logWithLevel:(KBRLogLevel)level text:(KBRText *)text completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"level": @(level), @"text": KBRValue(text)};
  [self.client sendRequestWithMethod:@"keybase.1.logUi.log" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRLoginRequest

- (void)getConfiguredAccounts:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.login.getConfiguredAccounts" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRConfiguredAccount.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)login:(KBRLoginRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"deviceType": KBRValue(params.deviceType), @"usernameOrEmail": KBRValue(params.usernameOrEmail), @"clientType": @(params.clientType)};
  [self.client sendRequestWithMethod:@"keybase.1.login.login" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)loginWithDeviceType:(NSString *)deviceType usernameOrEmail:(NSString *)usernameOrEmail clientType:(KBRClientType)clientType completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"deviceType": KBRValue(deviceType), @"usernameOrEmail": KBRValue(usernameOrEmail), @"clientType": @(clientType)};
  [self.client sendRequestWithMethod:@"keybase.1.login.login" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)clearStoredSecret:(KBRClearStoredSecretRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username)};
  [self.client sendRequestWithMethod:@"keybase.1.login.clearStoredSecret" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)clearStoredSecretWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username)};
  [self.client sendRequestWithMethod:@"keybase.1.login.clearStoredSecret" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)logout:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.login.logout" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)deprovision:(KBRDeprovisionRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username), @"doRevoke": @(params.doRevoke)};
  [self.client sendRequestWithMethod:@"keybase.1.login.deprovision" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)deprovisionWithUsername:(NSString *)username doRevoke:(BOOL)doRevoke completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username), @"doRevoke": @(doRevoke)};
  [self.client sendRequestWithMethod:@"keybase.1.login.deprovision" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)recoverAccountFromEmailAddress:(KBRRecoverAccountFromEmailAddressRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"email": KBRValue(params.email)};
  [self.client sendRequestWithMethod:@"keybase.1.login.recoverAccountFromEmailAddress" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)recoverAccountFromEmailAddressWithEmail:(NSString *)email completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"email": KBRValue(email)};
  [self.client sendRequestWithMethod:@"keybase.1.login.recoverAccountFromEmailAddress" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)paperKey:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.login.paperKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)paperKeySubmit:(KBRPaperKeySubmitRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"paperPhrase": KBRValue(params.paperPhrase)};
  [self.client sendRequestWithMethod:@"keybase.1.login.paperKeySubmit" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)paperKeySubmitWithPaperPhrase:(NSString *)paperPhrase completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"paperPhrase": KBRValue(paperPhrase)};
  [self.client sendRequestWithMethod:@"keybase.1.login.paperKeySubmit" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)unlock:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.login.unlock" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)unlockWithPassphrase:(KBRUnlockWithPassphraseRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"passphrase": KBRValue(params.passphrase)};
  [self.client sendRequestWithMethod:@"keybase.1.login.unlockWithPassphrase" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)unlockWithPassphraseWithPassphrase:(NSString *)passphrase completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"passphrase": KBRValue(passphrase)};
  [self.client sendRequestWithMethod:@"keybase.1.login.unlockWithPassphrase" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpProvision:(KBRPgpProvisionRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username), @"passphrase": KBRValue(params.passphrase), @"deviceName": KBRValue(params.deviceName)};
  [self.client sendRequestWithMethod:@"keybase.1.login.pgpProvision" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpProvisionWithUsername:(NSString *)username passphrase:(NSString *)passphrase deviceName:(NSString *)deviceName completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username), @"passphrase": KBRValue(passphrase), @"deviceName": KBRValue(deviceName)};
  [self.client sendRequestWithMethod:@"keybase.1.login.pgpProvision" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRLoginUiRequest

- (void)getEmailOrUsername:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.loginUi.getEmailOrUsername" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)promptRevokePaperKeys:(KBRPromptRevokePaperKeysRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"device": KBRValue(params.device), @"index": @(params.index)};
  [self.client sendRequestWithMethod:@"keybase.1.loginUi.promptRevokePaperKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)promptRevokePaperKeysWithDevice:(KBRDevice *)device index:(NSInteger)index completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"device": KBRValue(device), @"index": @(index)};
  [self.client sendRequestWithMethod:@"keybase.1.loginUi.promptRevokePaperKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)displayPaperKeyPhrase:(KBRDisplayPaperKeyPhraseRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"phrase": KBRValue(params.phrase)};
  [self.client sendRequestWithMethod:@"keybase.1.loginUi.displayPaperKeyPhrase" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayPaperKeyPhraseWithPhrase:(NSString *)phrase completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"phrase": KBRValue(phrase)};
  [self.client sendRequestWithMethod:@"keybase.1.loginUi.displayPaperKeyPhrase" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayPrimaryPaperKey:(KBRDisplayPrimaryPaperKeyRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"phrase": KBRValue(params.phrase)};
  [self.client sendRequestWithMethod:@"keybase.1.loginUi.displayPrimaryPaperKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayPrimaryPaperKeyWithPhrase:(NSString *)phrase completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"phrase": KBRValue(phrase)};
  [self.client sendRequestWithMethod:@"keybase.1.loginUi.displayPrimaryPaperKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRMetadataRequest

- (void)getChallenge:(void (^)(NSError *error, KBRChallengeInfo *challengeInfo))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getChallenge" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRChallengeInfo *result = retval ? [MTLJSONAdapter modelOfClass:KBRChallengeInfo.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)authenticate:(KBRAuthenticateRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{@"signature": KBRValue(params.signature)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.authenticate" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)authenticateWithSignature:(NSString *)signature completion:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{@"signature": KBRValue(signature)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.authenticate" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)putMetadata:(KBRPutMetadataRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"mdBlock": KBRValue(params.mdBlock), @"logTags": KBRValue(params.logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.putMetadata" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)putMetadataWithMdBlock:(KBRMDBlock *)mdBlock logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"mdBlock": KBRValue(mdBlock), @"logTags": KBRValue(logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.putMetadata" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)getMetadata:(KBRGetMetadataRequestParams *)params completion:(void (^)(NSError *error, KBRMetadataResponse *metadataResponse))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(params.folderID), @"folderHandle": KBRValue(params.folderHandle), @"branchID": KBRValue(params.branchID), @"unmerged": @(params.unmerged), @"startRevision": @(params.startRevision), @"stopRevision": @(params.stopRevision), @"logTags": KBRValue(params.logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMetadata" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRMetadataResponse *result = retval ? [MTLJSONAdapter modelOfClass:KBRMetadataResponse.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getMetadataWithFolderID:(NSString *)folderID folderHandle:(NSData *)folderHandle branchID:(NSString *)branchID unmerged:(BOOL)unmerged startRevision:(long)startRevision stopRevision:(long)stopRevision logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error, KBRMetadataResponse *metadataResponse))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(folderID), @"folderHandle": KBRValue(folderHandle), @"branchID": KBRValue(branchID), @"unmerged": @(unmerged), @"startRevision": @(startRevision), @"stopRevision": @(stopRevision), @"logTags": KBRValue(logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMetadata" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRMetadataResponse *result = retval ? [MTLJSONAdapter modelOfClass:KBRMetadataResponse.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)registerForUpdates:(KBRRegisterForUpdatesRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(params.folderID), @"currRevision": @(params.currRevision), @"logTags": KBRValue(params.logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.registerForUpdates" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)registerForUpdatesWithFolderID:(NSString *)folderID currRevision:(long)currRevision logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(folderID), @"currRevision": @(currRevision), @"logTags": KBRValue(logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.registerForUpdates" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pruneBranch:(KBRPruneBranchRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(params.folderID), @"branchID": KBRValue(params.branchID), @"logTags": KBRValue(params.logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.pruneBranch" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pruneBranchWithFolderID:(NSString *)folderID branchID:(NSString *)branchID logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(folderID), @"branchID": KBRValue(branchID), @"logTags": KBRValue(logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.pruneBranch" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)putKeys:(KBRPutKeysRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"keyHalves": KBRValue(params.keyHalves), @"logTags": KBRValue(params.logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.putKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)putKeysWithKeyHalves:(NSArray *)keyHalves logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"keyHalves": KBRValue(keyHalves), @"logTags": KBRValue(logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.putKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)getKey:(KBRGetKeyRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"keyHalfID": KBRValue(params.keyHalfID), @"deviceKID": KBRValue(params.deviceKID), @"logTags": KBRValue(params.logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getKeyWithKeyHalfID:(NSData *)keyHalfID deviceKID:(NSString *)deviceKID logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"keyHalfID": KBRValue(keyHalfID), @"deviceKID": KBRValue(deviceKID), @"logTags": KBRValue(logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)deleteKey:(KBRDeleteKeyRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid), @"deviceKID": KBRValue(params.deviceKID), @"keyHalfID": KBRValue(params.keyHalfID), @"logTags": KBRValue(params.logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.deleteKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)deleteKeyWithUid:(NSString *)uid deviceKID:(NSString *)deviceKID keyHalfID:(NSData *)keyHalfID logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid), @"deviceKID": KBRValue(deviceKID), @"keyHalfID": KBRValue(keyHalfID), @"logTags": KBRValue(logTags)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.deleteKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)truncateLock:(KBRTruncateLockRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(params.folderID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.truncateLock" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)truncateLockWithFolderID:(NSString *)folderID completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(folderID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.truncateLock" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)truncateUnlock:(KBRTruncateUnlockRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(params.folderID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.truncateUnlock" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)truncateUnlockWithFolderID:(NSString *)folderID completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(folderID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.truncateUnlock" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)getFolderHandle:(KBRGetFolderHandleRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(params.folderID), @"signature": KBRValue(params.signature), @"challenge": KBRValue(params.challenge)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getFolderHandle" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getFolderHandleWithFolderID:(NSString *)folderID signature:(NSString *)signature challenge:(NSString *)challenge completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(folderID), @"signature": KBRValue(signature), @"challenge": KBRValue(challenge)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getFolderHandle" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getFoldersForRekey:(KBRGetFoldersForRekeyRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"deviceKID": KBRValue(params.deviceKID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getFoldersForRekey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)getFoldersForRekeyWithDeviceKID:(NSString *)deviceKID completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"deviceKID": KBRValue(deviceKID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getFoldersForRekey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)ping:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.ping" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)ping2:(void (^)(NSError *error, KBRPingResponse *pingResponse))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.ping2" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRPingResponse *result = retval ? [MTLJSONAdapter modelOfClass:KBRPingResponse.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getLatestFolderHandle:(KBRGetLatestFolderHandleRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(params.folderID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getLatestFolderHandle" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getLatestFolderHandleWithFolderID:(NSString *)folderID completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(folderID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getLatestFolderHandle" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getMerkleRoot:(KBRGetMerkleRootRequestParams *)params completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion {
  NSDictionary *rparams = @{@"treeID": @(params.treeID), @"seqNo": @(params.seqNo)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMerkleRoot" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRMerkleRoot *result = retval ? [MTLJSONAdapter modelOfClass:KBRMerkleRoot.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getMerkleRootWithTreeID:(KBRMerkleTreeID)treeID seqNo:(long)seqNo completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion {
  NSDictionary *rparams = @{@"treeID": @(treeID), @"seqNo": @(seqNo)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMerkleRoot" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRMerkleRoot *result = retval ? [MTLJSONAdapter modelOfClass:KBRMerkleRoot.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getMerkleRootLatest:(KBRGetMerkleRootLatestRequestParams *)params completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion {
  NSDictionary *rparams = @{@"treeID": @(params.treeID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMerkleRootLatest" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRMerkleRoot *result = retval ? [MTLJSONAdapter modelOfClass:KBRMerkleRoot.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getMerkleRootLatestWithTreeID:(KBRMerkleTreeID)treeID completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion {
  NSDictionary *rparams = @{@"treeID": @(treeID)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMerkleRootLatest" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRMerkleRoot *result = retval ? [MTLJSONAdapter modelOfClass:KBRMerkleRoot.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getMerkleRootSince:(KBRGetMerkleRootSinceRequestParams *)params completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion {
  NSDictionary *rparams = @{@"treeID": @(params.treeID), @"when": @(params.when)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMerkleRootSince" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRMerkleRoot *result = retval ? [MTLJSONAdapter modelOfClass:KBRMerkleRoot.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getMerkleRootSinceWithTreeID:(KBRMerkleTreeID)treeID when:(long)when completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion {
  NSDictionary *rparams = @{@"treeID": @(treeID), @"when": @(when)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMerkleRootSince" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRMerkleRoot *result = retval ? [MTLJSONAdapter modelOfClass:KBRMerkleRoot.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getMerkleNode:(KBRGetMerkleNodeRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"hash": KBRValue(params.hash)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMerkleNode" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getMerkleNodeWithHash:(NSString *)hash completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"hash": KBRValue(hash)};
  [self.client sendRequestWithMethod:@"keybase.1.metadata.getMerkleNode" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRMetadataUpdateRequest

- (void)metadataUpdate:(KBRMetadataUpdateRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(params.folderID), @"revision": @(params.revision)};
  [self.client sendRequestWithMethod:@"keybase.1.metadataUpdate.metadataUpdate" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)metadataUpdateWithFolderID:(NSString *)folderID revision:(long)revision completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(folderID), @"revision": @(revision)};
  [self.client sendRequestWithMethod:@"keybase.1.metadataUpdate.metadataUpdate" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)folderNeedsRekey:(KBRFolderNeedsRekeyRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(params.folderID), @"revision": @(params.revision)};
  [self.client sendRequestWithMethod:@"keybase.1.metadataUpdate.folderNeedsRekey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)folderNeedsRekeyWithFolderID:(NSString *)folderID revision:(long)revision completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"folderID": KBRValue(folderID), @"revision": @(revision)};
  [self.client sendRequestWithMethod:@"keybase.1.metadataUpdate.folderNeedsRekey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifyAppRequest

- (void)exit:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyApp.exit" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifyCtlRequest

- (void)setNotifications:(KBRSetNotificationsRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"channels": KBRValue(params.channels)};
  [self.client sendRequestWithMethod:@"keybase.1.notifyCtl.setNotifications" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)setNotificationsWithChannels:(KBRNotificationChannels *)channels completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"channels": KBRValue(channels)};
  [self.client sendRequestWithMethod:@"keybase.1.notifyCtl.setNotifications" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifyFavoritesRequest

- (void)favoritesChanged:(KBRFavoritesChangedRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyFavorites.favoritesChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)favoritesChangedWithUid:(NSString *)uid completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyFavorites.favoritesChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifyFSRequest

- (void)fSActivity:(KBRFSActivityRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"notification": KBRValue(params.notification)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyFS.FSActivity" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)fSActivityWithNotification:(KBRFSNotification *)notification completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"notification": KBRValue(notification)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyFS.FSActivity" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifyKeyfamilyRequest

- (void)keyfamilyChanged:(KBRKeyfamilyChangedRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyKeyfamily.keyfamilyChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)keyfamilyChangedWithUid:(NSString *)uid completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyKeyfamily.keyfamilyChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifyPaperKeyRequest

- (void)paperKeyCached:(KBRPaperKeyCachedRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid), @"encKID": KBRValue(params.encKID), @"sigKID": KBRValue(params.sigKID)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyPaperKey.paperKeyCached" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)paperKeyCachedWithUid:(NSString *)uid encKID:(NSString *)encKID sigKID:(NSString *)sigKID completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid), @"encKID": KBRValue(encKID), @"sigKID": KBRValue(sigKID)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyPaperKey.paperKeyCached" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifyServiceRequest

- (void)shutdown:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyService.shutdown" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifySessionRequest

- (void)loggedOut:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.NotifySession.loggedOut" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)loggedIn:(KBRLoggedInRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifySession.loggedIn" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)loggedInWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifySession.loggedIn" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)clientOutOfDate:(KBRClientOutOfDateRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"upgradeTo": KBRValue(params.upgradeTo), @"upgradeURI": KBRValue(params.upgradeURI), @"upgradeMsg": KBRValue(params.upgradeMsg)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifySession.clientOutOfDate" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)clientOutOfDateWithUpgradeTo:(NSString *)upgradeTo upgradeURI:(NSString *)upgradeURI upgradeMsg:(NSString *)upgradeMsg completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"upgradeTo": KBRValue(upgradeTo), @"upgradeURI": KBRValue(upgradeURI), @"upgradeMsg": KBRValue(upgradeMsg)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifySession.clientOutOfDate" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifyTrackingRequest

- (void)trackingChanged:(KBRTrackingChangedRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid), @"username": KBRValue(params.username)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyTracking.trackingChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)trackingChangedWithUid:(NSString *)uid username:(NSString *)username completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid), @"username": KBRValue(username)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyTracking.trackingChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRNotifyUsersRequest

- (void)userChanged:(KBRUserChangedRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyUsers.userChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)userChangedWithUid:(NSString *)uid completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid)};
  [self.client sendRequestWithMethod:@"keybase.1.NotifyUsers.userChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRPaperprovisionRequest

- (void)paperProvision:(KBRPaperProvisionRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username), @"deviceName": KBRValue(params.deviceName), @"paperKey": KBRValue(params.paperKey)};
  [self.client sendRequestWithMethod:@"keybase.1.paperprovision.paperProvision" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)paperProvisionWithUsername:(NSString *)username deviceName:(NSString *)deviceName paperKey:(NSString *)paperKey completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username), @"deviceName": KBRValue(deviceName), @"paperKey": KBRValue(paperKey)};
  [self.client sendRequestWithMethod:@"keybase.1.paperprovision.paperProvision" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRPassphraseCommonRequest

@end

@implementation KBRPgpRequest

- (void)pgpSign:(KBRPgpSignRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(params.source), @"sink": KBRValue(params.sink), @"opts": KBRValue(params.opts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpSign" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpSignWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRPGPSignOptions *)opts completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(source), @"sink": KBRValue(sink), @"opts": KBRValue(opts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpSign" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpPull:(KBRPgpPullRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"userAsserts": KBRValue(params.userAsserts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpPull" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpPullWithUserAsserts:(NSArray *)userAsserts completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"userAsserts": KBRValue(userAsserts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpPull" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpEncrypt:(KBRPgpEncryptRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(params.source), @"sink": KBRValue(params.sink), @"opts": KBRValue(params.opts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpEncrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpEncryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRPGPEncryptOptions *)opts completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(source), @"sink": KBRValue(sink), @"opts": KBRValue(opts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpEncrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpDecrypt:(KBRPgpDecryptRequestParams *)params completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion {
  NSDictionary *rparams = @{@"source": KBRValue(params.source), @"sink": KBRValue(params.sink), @"opts": KBRValue(params.opts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpDecrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRPGPSigVerification *result = retval ? [MTLJSONAdapter modelOfClass:KBRPGPSigVerification.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)pgpDecryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRPGPDecryptOptions *)opts completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion {
  NSDictionary *rparams = @{@"source": KBRValue(source), @"sink": KBRValue(sink), @"opts": KBRValue(opts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpDecrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRPGPSigVerification *result = retval ? [MTLJSONAdapter modelOfClass:KBRPGPSigVerification.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)pgpVerify:(KBRPgpVerifyRequestParams *)params completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion {
  NSDictionary *rparams = @{@"source": KBRValue(params.source), @"opts": KBRValue(params.opts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpVerify" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRPGPSigVerification *result = retval ? [MTLJSONAdapter modelOfClass:KBRPGPSigVerification.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)pgpVerifyWithSource:(KBRStream *)source opts:(KBRPGPVerifyOptions *)opts completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion {
  NSDictionary *rparams = @{@"source": KBRValue(source), @"opts": KBRValue(opts)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpVerify" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRPGPSigVerification *result = retval ? [MTLJSONAdapter modelOfClass:KBRPGPSigVerification.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)pgpImport:(KBRPgpImportRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"key": KBRValue(params.key), @"pushSecret": @(params.pushSecret)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpImport" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpImportWithKey:(NSData *)key pushSecret:(BOOL)pushSecret completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"key": KBRValue(key), @"pushSecret": @(pushSecret)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpImport" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpExport:(KBRPgpExportRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"options": KBRValue(params.options)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpExport" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRKeyInfo.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)pgpExportWithOptions:(KBRPGPQuery *)options completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"options": KBRValue(options)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpExport" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRKeyInfo.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)pgpExportByFingerprint:(KBRPgpExportByFingerprintRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"options": KBRValue(params.options)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpExportByFingerprint" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRKeyInfo.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)pgpExportByFingerprintWithOptions:(KBRPGPQuery *)options completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"options": KBRValue(options)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpExportByFingerprint" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRKeyInfo.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)pgpExportByKID:(KBRPgpExportByKIDRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"options": KBRValue(params.options)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpExportByKID" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRKeyInfo.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)pgpExportByKIDWithOptions:(KBRPGPQuery *)options completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"options": KBRValue(options)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpExportByKID" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRKeyInfo.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)pgpKeyGen:(KBRPgpKeyGenRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"primaryBits": @(params.primaryBits), @"subkeyBits": @(params.subkeyBits), @"createUids": KBRValue(params.createUids), @"allowMulti": @(params.allowMulti), @"doExport": @(params.doExport), @"pushSecret": @(params.pushSecret)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpKeyGen" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpKeyGenWithPrimaryBits:(NSInteger)primaryBits subkeyBits:(NSInteger)subkeyBits createUids:(KBRPGPCreateUids *)createUids allowMulti:(BOOL)allowMulti doExport:(BOOL)doExport pushSecret:(BOOL)pushSecret completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"primaryBits": @(primaryBits), @"subkeyBits": @(subkeyBits), @"createUids": KBRValue(createUids), @"allowMulti": @(allowMulti), @"doExport": @(doExport), @"pushSecret": @(pushSecret)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpKeyGen" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpDeletePrimary:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpDeletePrimary" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpSelect:(KBRPgpSelectRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"fingerprintQuery": KBRValue(params.fingerprintQuery), @"allowMulti": @(params.allowMulti), @"skipImport": @(params.skipImport), @"onlyImport": @(params.onlyImport)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpSelect" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpSelectWithFingerprintQuery:(NSString *)fingerprintQuery allowMulti:(BOOL)allowMulti skipImport:(BOOL)skipImport onlyImport:(BOOL)onlyImport completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"fingerprintQuery": KBRValue(fingerprintQuery), @"allowMulti": @(allowMulti), @"skipImport": @(skipImport), @"onlyImport": @(onlyImport)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpSelect" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpUpdate:(KBRPgpUpdateRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"all": @(params.all), @"fingerprints": KBRValue(params.fingerprints)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpUpdate" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpUpdateWithAll:(BOOL)all fingerprints:(NSArray *)fingerprints completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"all": @(all), @"fingerprints": KBRValue(fingerprints)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpUpdate" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)pgpPurge:(KBRPgpPurgeRequestParams *)params completion:(void (^)(NSError *error, KBRPGPPurgeRes *pGPPurgeRes))completion {
  NSDictionary *rparams = @{@"doPurge": @(params.doPurge)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpPurge" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRPGPPurgeRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRPGPPurgeRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)pgpPurgeWithDoPurge:(BOOL)doPurge completion:(void (^)(NSError *error, KBRPGPPurgeRes *pGPPurgeRes))completion {
  NSDictionary *rparams = @{@"doPurge": @(doPurge)};
  [self.client sendRequestWithMethod:@"keybase.1.pgp.pgpPurge" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRPGPPurgeRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRPGPPurgeRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRPgpUiRequest

- (void)outputSignatureSuccess:(KBROutputSignatureSuccessRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"fingerprint": KBRValue(params.fingerprint), @"username": KBRValue(params.username), @"signedAt": @(params.signedAt)};
  [self.client sendRequestWithMethod:@"keybase.1.pgpUi.outputSignatureSuccess" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)outputSignatureSuccessWithFingerprint:(NSString *)fingerprint username:(NSString *)username signedAt:(long)signedAt completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"fingerprint": KBRValue(fingerprint), @"username": KBRValue(username), @"signedAt": @(signedAt)};
  [self.client sendRequestWithMethod:@"keybase.1.pgpUi.outputSignatureSuccess" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRProcessRequest

@end

@implementation KBRProveRequest

- (void)startProof:(KBRStartProofRequestParams *)params completion:(void (^)(NSError *error, KBRStartProofResult *startProofResult))completion {
  NSDictionary *rparams = @{@"service": KBRValue(params.service), @"username": KBRValue(params.username), @"force": @(params.force), @"promptPosted": @(params.promptPosted), @"auto": @(params.automatic)};
  [self.client sendRequestWithMethod:@"keybase.1.prove.startProof" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRStartProofResult *result = retval ? [MTLJSONAdapter modelOfClass:KBRStartProofResult.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)startProofWithService:(NSString *)service username:(NSString *)username force:(BOOL)force promptPosted:(BOOL)promptPosted automatic:(BOOL)automatic completion:(void (^)(NSError *error, KBRStartProofResult *startProofResult))completion {
  NSDictionary *rparams = @{@"service": KBRValue(service), @"username": KBRValue(username), @"force": @(force), @"promptPosted": @(promptPosted), @"auto": @(automatic)};
  [self.client sendRequestWithMethod:@"keybase.1.prove.startProof" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRStartProofResult *result = retval ? [MTLJSONAdapter modelOfClass:KBRStartProofResult.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)checkProof:(KBRCheckProofRequestParams *)params completion:(void (^)(NSError *error, KBRCheckProofStatus *checkProofStatus))completion {
  NSDictionary *rparams = @{@"sigID": KBRValue(params.sigID)};
  [self.client sendRequestWithMethod:@"keybase.1.prove.checkProof" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRCheckProofStatus *result = retval ? [MTLJSONAdapter modelOfClass:KBRCheckProofStatus.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)checkProofWithSigID:(NSString *)sigID completion:(void (^)(NSError *error, KBRCheckProofStatus *checkProofStatus))completion {
  NSDictionary *rparams = @{@"sigID": KBRValue(sigID)};
  [self.client sendRequestWithMethod:@"keybase.1.prove.checkProof" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRCheckProofStatus *result = retval ? [MTLJSONAdapter modelOfClass:KBRCheckProofStatus.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRProveUiRequest

- (void)promptOverwrite:(KBRPromptOverwriteRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"account": KBRValue(params.account), @"typ": @(params.typ)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.promptOverwrite" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)promptOverwriteWithAccount:(NSString *)account typ:(KBRPromptOverwriteType)typ completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"account": KBRValue(account), @"typ": @(typ)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.promptOverwrite" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)promptUsername:(KBRPromptUsernameRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"prompt": KBRValue(params.prompt), @"prevError": KBRValue(params.prevError)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.promptUsername" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)promptUsernameWithPrompt:(NSString *)prompt prevError:(KBRStatus *)prevError completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"prompt": KBRValue(prompt), @"prevError": KBRValue(prevError)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.promptUsername" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)outputPrechecks:(KBROutputPrechecksRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"text": KBRValue(params.text)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.outputPrechecks" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)outputPrechecksWithText:(KBRText *)text completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"text": KBRValue(text)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.outputPrechecks" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)preProofWarning:(KBRPreProofWarningRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"text": KBRValue(params.text)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.preProofWarning" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)preProofWarningWithText:(KBRText *)text completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"text": KBRValue(text)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.preProofWarning" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)outputInstructions:(KBROutputInstructionsRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"instructions": KBRValue(params.instructions), @"proof": KBRValue(params.proof)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.outputInstructions" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)outputInstructionsWithInstructions:(KBRText *)instructions proof:(NSString *)proof completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"instructions": KBRValue(instructions), @"proof": KBRValue(proof)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.outputInstructions" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)okToCheck:(KBROkToCheckRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"name": KBRValue(params.name), @"attempt": @(params.attempt)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.okToCheck" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)okToCheckWithName:(NSString *)name attempt:(NSInteger)attempt completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"name": KBRValue(name), @"attempt": @(attempt)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.okToCheck" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)displayRecheckWarning:(KBRDisplayRecheckWarningRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"text": KBRValue(params.text)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.displayRecheckWarning" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)displayRecheckWarningWithText:(KBRText *)text completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"text": KBRValue(text)};
  [self.client sendRequestWithMethod:@"keybase.1.proveUi.displayRecheckWarning" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRProvisionUiRequest

- (void)chooseProvisioningMethod:(KBRChooseProvisioningMethodRequestParams *)params completion:(void (^)(NSError *error, KBRProvisionMethod provisionMethod))completion {
  NSDictionary *rparams = @{@"gpgOption": @(params.gpgOption)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.chooseProvisioningMethod" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, [retval integerValue]);
  }];
}

- (void)chooseProvisioningMethodWithGpgOption:(BOOL)gpgOption completion:(void (^)(NSError *error, KBRProvisionMethod provisionMethod))completion {
  NSDictionary *rparams = @{@"gpgOption": @(gpgOption)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.chooseProvisioningMethod" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, [retval integerValue]);
  }];
}

- (void)chooseGPGMethod:(KBRChooseGPGMethodRequestParams *)params completion:(void (^)(NSError *error, KBRGPGMethod gPGMethod))completion {
  NSDictionary *rparams = @{@"keys": KBRValue(params.keys)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.chooseGPGMethod" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, [retval integerValue]);
  }];
}

- (void)chooseGPGMethodWithKeys:(NSArray *)keys completion:(void (^)(NSError *error, KBRGPGMethod gPGMethod))completion {
  NSDictionary *rparams = @{@"keys": KBRValue(keys)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.chooseGPGMethod" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, [retval integerValue]);
  }];
}

- (void)switchToGPGSignOK:(KBRSwitchToGPGSignOKRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"key": KBRValue(params.key), @"importError": KBRValue(params.importError)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.switchToGPGSignOK" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)switchToGPGSignOKWithKey:(KBRGPGKey *)key importError:(NSString *)importError completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"key": KBRValue(key), @"importError": KBRValue(importError)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.switchToGPGSignOK" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)chooseDevice:(KBRChooseDeviceRequestParams *)params completion:(void (^)(NSError *error, NSString *deviceID))completion {
  NSDictionary *rparams = @{@"devices": KBRValue(params.devices)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.chooseDevice" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)chooseDeviceWithDevices:(NSArray *)devices completion:(void (^)(NSError *error, NSString *deviceID))completion {
  NSDictionary *rparams = @{@"devices": KBRValue(devices)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.chooseDevice" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)chooseDeviceType:(KBRChooseDeviceTypeRequestParams *)params completion:(void (^)(NSError *error, KBRDeviceType deviceType))completion {
  NSDictionary *rparams = @{@"kind": @(params.kind)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.chooseDeviceType" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, [retval integerValue]);
  }];
}

- (void)chooseDeviceTypeWithKind:(KBRChooseType)kind completion:(void (^)(NSError *error, KBRDeviceType deviceType))completion {
  NSDictionary *rparams = @{@"kind": @(kind)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.chooseDeviceType" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, [retval integerValue]);
  }];
}

- (void)displayAndPromptSecret:(KBRDisplayAndPromptSecretRequestParams *)params completion:(void (^)(NSError *error, KBRSecretResponse *secretResponse))completion {
  NSDictionary *rparams = @{@"secret": KBRValue(params.secret), @"phrase": KBRValue(params.phrase), @"otherDeviceType": @(params.otherDeviceType)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.DisplayAndPromptSecret" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSecretResponse *result = retval ? [MTLJSONAdapter modelOfClass:KBRSecretResponse.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)displayAndPromptSecretWithSecret:(NSData *)secret phrase:(NSString *)phrase otherDeviceType:(KBRDeviceType)otherDeviceType completion:(void (^)(NSError *error, KBRSecretResponse *secretResponse))completion {
  NSDictionary *rparams = @{@"secret": KBRValue(secret), @"phrase": KBRValue(phrase), @"otherDeviceType": @(otherDeviceType)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.DisplayAndPromptSecret" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSecretResponse *result = retval ? [MTLJSONAdapter modelOfClass:KBRSecretResponse.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)displaySecretExchanged:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.DisplaySecretExchanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)promptNewDeviceName:(KBRPromptNewDeviceNameRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"existingDevices": KBRValue(params.existingDevices), @"errorMessage": KBRValue(params.errorMessage)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.PromptNewDeviceName" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)promptNewDeviceNameWithExistingDevices:(NSArray *)existingDevices errorMessage:(NSString *)errorMessage completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"existingDevices": KBRValue(existingDevices), @"errorMessage": KBRValue(errorMessage)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.PromptNewDeviceName" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)provisioneeSuccess:(KBRProvisioneeSuccessRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username), @"deviceName": KBRValue(params.deviceName)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.ProvisioneeSuccess" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)provisioneeSuccessWithUsername:(NSString *)username deviceName:(NSString *)deviceName completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username), @"deviceName": KBRValue(deviceName)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.ProvisioneeSuccess" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)provisionerSuccess:(KBRProvisionerSuccessRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"deviceName": KBRValue(params.deviceName), @"deviceType": KBRValue(params.deviceType)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.ProvisionerSuccess" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)provisionerSuccessWithDeviceName:(NSString *)deviceName deviceType:(NSString *)deviceType completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"deviceName": KBRValue(deviceName), @"deviceType": KBRValue(deviceType)};
  [self.client sendRequestWithMethod:@"keybase.1.provisionUi.ProvisionerSuccess" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRQuotaRequest

- (void)verifySession:(KBRVerifySessionRequestParams *)params completion:(void (^)(NSError *error, KBRVerifySessionRes *verifySessionRes))completion {
  NSDictionary *rparams = @{@"session": KBRValue(params.session)};
  [self.client sendRequestWithMethod:@"keybase.1.quota.verifySession" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRVerifySessionRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRVerifySessionRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)verifySessionWithSession:(NSString *)session completion:(void (^)(NSError *error, KBRVerifySessionRes *verifySessionRes))completion {
  NSDictionary *rparams = @{@"session": KBRValue(session)};
  [self.client sendRequestWithMethod:@"keybase.1.quota.verifySession" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRVerifySessionRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRVerifySessionRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRRekeyRequest

- (void)showPendingRekeyStatus:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.rekey.showPendingRekeyStatus" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)getPendingRekeyStatus:(void (^)(NSError *error, KBRProblemSetDevices *problemSetDevices))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.rekey.getPendingRekeyStatus" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRProblemSetDevices *result = retval ? [MTLJSONAdapter modelOfClass:KBRProblemSetDevices.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)debugShowRekeyStatus:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.rekey.debugShowRekeyStatus" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)rekeyStatusFinish:(void (^)(NSError *error, KBROutcome outcome))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.rekey.rekeyStatusFinish" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, [retval integerValue]);
  }];
}

@end

@implementation KBRRekeyUIRequest

- (void)delegateRekeyUI:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.rekeyUI.delegateRekeyUI" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)refresh:(KBRRefreshRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"problemSetDevices": KBRValue(params.problemSetDevices)};
  [self.client sendRequestWithMethod:@"keybase.1.rekeyUI.refresh" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)refreshWithProblemSetDevices:(KBRProblemSetDevices *)problemSetDevices completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"problemSetDevices": KBRValue(problemSetDevices)};
  [self.client sendRequestWithMethod:@"keybase.1.rekeyUI.refresh" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRRevokeRequest

- (void)revokeKey:(KBRRevokeKeyRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"keyID": KBRValue(params.keyID)};
  [self.client sendRequestWithMethod:@"keybase.1.revoke.revokeKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)revokeKeyWithKeyID:(NSString *)keyID completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"keyID": KBRValue(keyID)};
  [self.client sendRequestWithMethod:@"keybase.1.revoke.revokeKey" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)revokeDevice:(KBRRevokeDeviceRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"deviceID": KBRValue(params.deviceID), @"force": @(params.force)};
  [self.client sendRequestWithMethod:@"keybase.1.revoke.revokeDevice" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)revokeDeviceWithDeviceID:(NSString *)deviceID force:(BOOL)force completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"deviceID": KBRValue(deviceID), @"force": @(force)};
  [self.client sendRequestWithMethod:@"keybase.1.revoke.revokeDevice" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)revokeSigs:(KBRRevokeSigsRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"sigIDQueries": KBRValue(params.sigIDQueries)};
  [self.client sendRequestWithMethod:@"keybase.1.revoke.revokeSigs" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)revokeSigsWithSigIDQueries:(NSArray *)sigIDQueries completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"sigIDQueries": KBRValue(sigIDQueries)};
  [self.client sendRequestWithMethod:@"keybase.1.revoke.revokeSigs" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRSaltpackRequest

- (void)saltpackEncrypt:(KBRSaltpackEncryptRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(params.source), @"sink": KBRValue(params.sink), @"opts": KBRValue(params.opts)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpack.saltpackEncrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)saltpackEncryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltpackEncryptOptions *)opts completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(source), @"sink": KBRValue(sink), @"opts": KBRValue(opts)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpack.saltpackEncrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)saltpackDecrypt:(KBRSaltpackDecryptRequestParams *)params completion:(void (^)(NSError *error, KBRSaltpackEncryptedMessageInfo *saltpackEncryptedMessageInfo))completion {
  NSDictionary *rparams = @{@"source": KBRValue(params.source), @"sink": KBRValue(params.sink), @"opts": KBRValue(params.opts)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpack.saltpackDecrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSaltpackEncryptedMessageInfo *result = retval ? [MTLJSONAdapter modelOfClass:KBRSaltpackEncryptedMessageInfo.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)saltpackDecryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltpackDecryptOptions *)opts completion:(void (^)(NSError *error, KBRSaltpackEncryptedMessageInfo *saltpackEncryptedMessageInfo))completion {
  NSDictionary *rparams = @{@"source": KBRValue(source), @"sink": KBRValue(sink), @"opts": KBRValue(opts)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpack.saltpackDecrypt" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSaltpackEncryptedMessageInfo *result = retval ? [MTLJSONAdapter modelOfClass:KBRSaltpackEncryptedMessageInfo.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)saltpackSign:(KBRSaltpackSignRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(params.source), @"sink": KBRValue(params.sink), @"opts": KBRValue(params.opts)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpack.saltpackSign" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)saltpackSignWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltpackSignOptions *)opts completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(source), @"sink": KBRValue(sink), @"opts": KBRValue(opts)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpack.saltpackSign" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)saltpackVerify:(KBRSaltpackVerifyRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(params.source), @"sink": KBRValue(params.sink), @"opts": KBRValue(params.opts)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpack.saltpackVerify" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)saltpackVerifyWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltpackVerifyOptions *)opts completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"source": KBRValue(source), @"sink": KBRValue(sink), @"opts": KBRValue(opts)};
  [self.client sendRequestWithMethod:@"keybase.1.saltpack.saltpackVerify" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRSecretUiRequest

- (void)getPassphrase:(KBRGetPassphraseRequestParams *)params completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion {
  NSDictionary *rparams = @{@"pinentry": KBRValue(params.pinentry), @"terminal": KBRValue(params.terminal)};
  [self.client sendRequestWithMethod:@"keybase.1.secretUi.getPassphrase" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRGetPassphraseRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRGetPassphraseRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getPassphraseWithPinentry:(KBRGUIEntryArg *)pinentry terminal:(KBRSecretEntryArg *)terminal completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion {
  NSDictionary *rparams = @{@"pinentry": KBRValue(pinentry), @"terminal": KBRValue(terminal)};
  [self.client sendRequestWithMethod:@"keybase.1.secretUi.getPassphrase" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRGetPassphraseRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRGetPassphraseRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRSecretKeysRequest

- (void)getSecretKeys:(void (^)(NSError *error, KBRSecretKeys *secretKeys))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.SecretKeys.getSecretKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSecretKeys *result = retval ? [MTLJSONAdapter modelOfClass:KBRSecretKeys.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRSessionRequest

- (void)currentSession:(void (^)(NSError *error, KBRSession *session))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.session.currentSession" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSession *result = retval ? [MTLJSONAdapter modelOfClass:KBRSession.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRSignupRequest

- (void)checkUsernameAvailable:(KBRCheckUsernameAvailableRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username)};
  [self.client sendRequestWithMethod:@"keybase.1.signup.checkUsernameAvailable" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)checkUsernameAvailableWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username)};
  [self.client sendRequestWithMethod:@"keybase.1.signup.checkUsernameAvailable" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)signup:(KBRSignupRequestParams *)params completion:(void (^)(NSError *error, KBRSignupRes *signupRes))completion {
  NSDictionary *rparams = @{@"email": KBRValue(params.email), @"inviteCode": KBRValue(params.inviteCode), @"passphrase": KBRValue(params.passphrase), @"username": KBRValue(params.username), @"deviceName": KBRValue(params.deviceName), @"storeSecret": @(params.storeSecret), @"skipMail": @(params.skipMail), @"genPGPBatch": @(params.genPGPBatch)};
  [self.client sendRequestWithMethod:@"keybase.1.signup.signup" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSignupRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRSignupRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)signupWithEmail:(NSString *)email inviteCode:(NSString *)inviteCode passphrase:(NSString *)passphrase username:(NSString *)username deviceName:(NSString *)deviceName storeSecret:(BOOL)storeSecret skipMail:(BOOL)skipMail genPGPBatch:(BOOL)genPGPBatch completion:(void (^)(NSError *error, KBRSignupRes *signupRes))completion {
  NSDictionary *rparams = @{@"email": KBRValue(email), @"inviteCode": KBRValue(inviteCode), @"passphrase": KBRValue(passphrase), @"username": KBRValue(username), @"deviceName": KBRValue(deviceName), @"storeSecret": @(storeSecret), @"skipMail": @(skipMail), @"genPGPBatch": @(genPGPBatch)};
  [self.client sendRequestWithMethod:@"keybase.1.signup.signup" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRSignupRes *result = retval ? [MTLJSONAdapter modelOfClass:KBRSignupRes.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)inviteRequest:(KBRInviteRequestRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"email": KBRValue(params.email), @"fullname": KBRValue(params.fullname), @"notes": KBRValue(params.notes)};
  [self.client sendRequestWithMethod:@"keybase.1.signup.inviteRequest" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)inviteRequestWithEmail:(NSString *)email fullname:(NSString *)fullname notes:(NSString *)notes completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"email": KBRValue(email), @"fullname": KBRValue(fullname), @"notes": KBRValue(notes)};
  [self.client sendRequestWithMethod:@"keybase.1.signup.inviteRequest" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)checkInvitationCode:(KBRCheckInvitationCodeRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"invitationCode": KBRValue(params.invitationCode)};
  [self.client sendRequestWithMethod:@"keybase.1.signup.checkInvitationCode" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)checkInvitationCodeWithInvitationCode:(NSString *)invitationCode completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"invitationCode": KBRValue(invitationCode)};
  [self.client sendRequestWithMethod:@"keybase.1.signup.checkInvitationCode" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRSigsRequest

- (void)sigList:(KBRSigListRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"arg": KBRValue(params.arg)};
  [self.client sendRequestWithMethod:@"keybase.1.sigs.sigList" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRSig.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)sigListWithArg:(KBRSigListArgs *)arg completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"arg": KBRValue(arg)};
  [self.client sendRequestWithMethod:@"keybase.1.sigs.sigList" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRSig.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)sigListJSON:(KBRSigListJSONRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"arg": KBRValue(params.arg)};
  [self.client sendRequestWithMethod:@"keybase.1.sigs.sigListJSON" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)sigListJSONWithArg:(KBRSigListArgs *)arg completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"arg": KBRValue(arg)};
  [self.client sendRequestWithMethod:@"keybase.1.sigs.sigListJSON" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRStreamUiRequest

- (void)close:(KBRCloseRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"s": KBRValue(params.s)};
  [self.client sendRequestWithMethod:@"keybase.1.streamUi.close" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)closeWithS:(KBRStream *)s completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"s": KBRValue(s)};
  [self.client sendRequestWithMethod:@"keybase.1.streamUi.close" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)read:(KBRReadRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"s": KBRValue(params.s), @"sz": @(params.sz)};
  [self.client sendRequestWithMethod:@"keybase.1.streamUi.read" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)readWithS:(KBRStream *)s sz:(NSInteger)sz completion:(void (^)(NSError *error, NSData *bytes))completion {
  NSDictionary *rparams = @{@"s": KBRValue(s), @"sz": @(sz)};
  [self.client sendRequestWithMethod:@"keybase.1.streamUi.read" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSData *result = retval ? [MTLJSONAdapter modelOfClass:NSData.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)write:(KBRWriteRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{@"s": KBRValue(params.s), @"buf": KBRValue(params.buf)};
  [self.client sendRequestWithMethod:@"keybase.1.streamUi.write" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)writeWithS:(KBRStream *)s buf:(NSData *)buf completion:(void (^)(NSError *error, NSInteger n))completion {
  NSDictionary *rparams = @{@"s": KBRValue(s), @"buf": KBRValue(buf)};
  [self.client sendRequestWithMethod:@"keybase.1.streamUi.write" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

@end

@implementation KBRTestRequest

- (void)test:(KBRTestRequestParams *)params completion:(void (^)(NSError *error, KBRTest *test))completion {
  NSDictionary *rparams = @{@"name": KBRValue(params.name)};
  [self.client sendRequestWithMethod:@"keybase.1.test.test" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRTest *result = retval ? [MTLJSONAdapter modelOfClass:KBRTest.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)testWithName:(NSString *)name completion:(void (^)(NSError *error, KBRTest *test))completion {
  NSDictionary *rparams = @{@"name": KBRValue(name)};
  [self.client sendRequestWithMethod:@"keybase.1.test.test" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRTest *result = retval ? [MTLJSONAdapter modelOfClass:KBRTest.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)testCallback:(KBRTestCallbackRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"name": KBRValue(params.name)};
  [self.client sendRequestWithMethod:@"keybase.1.test.testCallback" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)testCallbackWithName:(NSString *)name completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"name": KBRValue(name)};
  [self.client sendRequestWithMethod:@"keybase.1.test.testCallback" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)panic:(KBRPanicRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"message": KBRValue(params.message)};
  [self.client sendRequestWithMethod:@"keybase.1.test.panic" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)panicWithMessage:(NSString *)message completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"message": KBRValue(message)};
  [self.client sendRequestWithMethod:@"keybase.1.test.panic" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRTlfRequest

- (void)cryptKeys:(KBRCryptKeysRequestParams *)params completion:(void (^)(NSError *error, KBRTLFCryptKeys *tLFCryptKeys))completion {
  NSDictionary *rparams = @{@"tlfName": KBRValue(params.tlfName)};
  [self.client sendRequestWithMethod:@"keybase.1.tlf.CryptKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRTLFCryptKeys *result = retval ? [MTLJSONAdapter modelOfClass:KBRTLFCryptKeys.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)cryptKeysWithTlfName:(NSString *)tlfName completion:(void (^)(NSError *error, KBRTLFCryptKeys *tLFCryptKeys))completion {
  NSDictionary *rparams = @{@"tlfName": KBRValue(tlfName)};
  [self.client sendRequestWithMethod:@"keybase.1.tlf.CryptKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRTLFCryptKeys *result = retval ? [MTLJSONAdapter modelOfClass:KBRTLFCryptKeys.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRTlfKeysRequest

- (void)getTLFCryptKeys:(KBRGetTLFCryptKeysRequestParams *)params completion:(void (^)(NSError *error, KBRTLFCryptKeys *tLFCryptKeys))completion {
  NSDictionary *rparams = @{@"tlfName": KBRValue(params.tlfName)};
  [self.client sendRequestWithMethod:@"keybase.1.tlfKeys.getTLFCryptKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRTLFCryptKeys *result = retval ? [MTLJSONAdapter modelOfClass:KBRTLFCryptKeys.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)getTLFCryptKeysWithTlfName:(NSString *)tlfName completion:(void (^)(NSError *error, KBRTLFCryptKeys *tLFCryptKeys))completion {
  NSDictionary *rparams = @{@"tlfName": KBRValue(tlfName)};
  [self.client sendRequestWithMethod:@"keybase.1.tlfKeys.getTLFCryptKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRTLFCryptKeys *result = retval ? [MTLJSONAdapter modelOfClass:KBRTLFCryptKeys.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end

@implementation KBRTrackRequest

- (void)track:(KBRTrackRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"userAssertion": KBRValue(params.userAssertion), @"options": KBRValue(params.options), @"forceRemoteCheck": @(params.forceRemoteCheck)};
  [self.client sendRequestWithMethod:@"keybase.1.track.track" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)trackWithUserAssertion:(NSString *)userAssertion options:(KBRTrackOptions *)options forceRemoteCheck:(BOOL)forceRemoteCheck completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"userAssertion": KBRValue(userAssertion), @"options": KBRValue(options), @"forceRemoteCheck": @(forceRemoteCheck)};
  [self.client sendRequestWithMethod:@"keybase.1.track.track" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)trackWithToken:(KBRTrackWithTokenRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"trackToken": KBRValue(params.trackToken), @"options": KBRValue(params.options)};
  [self.client sendRequestWithMethod:@"keybase.1.track.trackWithToken" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)trackWithTokenWithTrackToken:(NSString *)trackToken options:(KBRTrackOptions *)options completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"trackToken": KBRValue(trackToken), @"options": KBRValue(options)};
  [self.client sendRequestWithMethod:@"keybase.1.track.trackWithToken" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)dismissWithToken:(KBRDismissWithTokenRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"trackToken": KBRValue(params.trackToken)};
  [self.client sendRequestWithMethod:@"keybase.1.track.dismissWithToken" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)dismissWithTokenWithTrackToken:(NSString *)trackToken completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"trackToken": KBRValue(trackToken)};
  [self.client sendRequestWithMethod:@"keybase.1.track.dismissWithToken" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)untrack:(KBRUntrackRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username)};
  [self.client sendRequestWithMethod:@"keybase.1.track.untrack" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)untrackWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username)};
  [self.client sendRequestWithMethod:@"keybase.1.track.untrack" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)checkTracking:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.track.checkTracking" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)fakeTrackingChanged:(KBRFakeTrackingChangedRequestParams *)params completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username)};
  [self.client sendRequestWithMethod:@"keybase.1.track.fakeTrackingChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

- (void)fakeTrackingChangedWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username)};
  [self.client sendRequestWithMethod:@"keybase.1.track.fakeTrackingChanged" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error);
  }];
}

@end

@implementation KBRUiRequest

- (void)promptYesNo:(KBRPromptYesNoRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"text": KBRValue(params.text), @"promptDefault": @(params.promptDefault)};
  [self.client sendRequestWithMethod:@"keybase.1.ui.promptYesNo" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

- (void)promptYesNoWithText:(KBRText *)text promptDefault:(KBRPromptDefault)promptDefault completion:(void (^)(NSError *error, BOOL b))completion {
  NSDictionary *rparams = @{@"text": KBRValue(text), @"promptDefault": @(promptDefault)};
  [self.client sendRequestWithMethod:@"keybase.1.ui.promptYesNo" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    completion(error, 0);
  }];
}

@end

@implementation KBRUserRequest

- (void)listTrackers:(KBRListTrackersRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTrackers" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRTracker.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)listTrackersWithUid:(NSString *)uid completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTrackers" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRTracker.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)listTrackersByName:(KBRListTrackersByNameRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTrackersByName" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRTracker.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)listTrackersByNameWithUsername:(NSString *)username completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTrackersByName" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRTracker.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)listTrackersSelf:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTrackersSelf" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRTracker.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)loadUncheckedUserSummaries:(KBRLoadUncheckedUserSummariesRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"uids": KBRValue(params.uids)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadUncheckedUserSummaries" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRUserSummary.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)loadUncheckedUserSummariesWithUids:(NSArray *)uids completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"uids": KBRValue(uids)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadUncheckedUserSummaries" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRUserSummary.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)loadUser:(KBRLoadUserRequestParams *)params completion:(void (^)(NSError *error, KBRUser *user))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadUser" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUser *result = retval ? [MTLJSONAdapter modelOfClass:KBRUser.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)loadUserWithUid:(NSString *)uid completion:(void (^)(NSError *error, KBRUser *user))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadUser" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUser *result = retval ? [MTLJSONAdapter modelOfClass:KBRUser.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)loadUserByName:(KBRLoadUserByNameRequestParams *)params completion:(void (^)(NSError *error, KBRUser *user))completion {
  NSDictionary *rparams = @{@"username": KBRValue(params.username)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadUserByName" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUser *result = retval ? [MTLJSONAdapter modelOfClass:KBRUser.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)loadUserByNameWithUsername:(NSString *)username completion:(void (^)(NSError *error, KBRUser *user))completion {
  NSDictionary *rparams = @{@"username": KBRValue(username)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadUserByName" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUser *result = retval ? [MTLJSONAdapter modelOfClass:KBRUser.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)loadUserPlusKeys:(KBRLoadUserPlusKeysRequestParams *)params completion:(void (^)(NSError *error, KBRUserPlusKeys *userPlusKeys))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadUserPlusKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUserPlusKeys *result = retval ? [MTLJSONAdapter modelOfClass:KBRUserPlusKeys.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)loadUserPlusKeysWithUid:(NSString *)uid completion:(void (^)(NSError *error, KBRUserPlusKeys *userPlusKeys))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadUserPlusKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUserPlusKeys *result = retval ? [MTLJSONAdapter modelOfClass:KBRUserPlusKeys.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)loadPublicKeys:(KBRLoadPublicKeysRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadPublicKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRPublicKey.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)loadPublicKeysWithUid:(NSString *)uid completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadPublicKeys" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRPublicKey.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)listTracking:(KBRListTrackingRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"filter": KBRValue(params.filter), @"assertion": KBRValue(params.assertion)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTracking" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRUserSummary.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)listTrackingWithFilter:(NSString *)filter assertion:(NSString *)assertion completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"filter": KBRValue(filter), @"assertion": KBRValue(assertion)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTracking" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRUserSummary.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)listTrackingJSON:(KBRListTrackingJSONRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"filter": KBRValue(params.filter), @"verbose": @(params.verbose), @"assertion": KBRValue(params.assertion)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTrackingJSON" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)listTrackingJSONWithFilter:(NSString *)filter verbose:(BOOL)verbose assertion:(NSString *)assertion completion:(void (^)(NSError *error, NSString *str))completion {
  NSDictionary *rparams = @{@"filter": KBRValue(filter), @"verbose": @(verbose), @"assertion": KBRValue(assertion)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTrackingJSON" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSString *result = retval ? [MTLJSONAdapter modelOfClass:NSString.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)search:(KBRSearchRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"query": KBRValue(params.query)};
  [self.client sendRequestWithMethod:@"keybase.1.user.search" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRSearchResult.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)searchWithQuery:(NSString *)query completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"query": KBRValue(query)};
  [self.client sendRequestWithMethod:@"keybase.1.user.search" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRSearchResult.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)loadAllPublicKeysUnverified:(KBRLoadAllPublicKeysUnverifiedRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(params.uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadAllPublicKeysUnverified" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRPublicKey.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)loadAllPublicKeysUnverifiedWithUid:(NSString *)uid completion:(void (^)(NSError *error, NSArray *items))completion {
  NSDictionary *rparams = @{@"uid": KBRValue(uid)};
  [self.client sendRequestWithMethod:@"keybase.1.user.loadAllPublicKeysUnverified" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    NSArray *results = retval ? [MTLJSONAdapter modelsOfClass:KBRPublicKey.class fromJSONArray:retval error:&error] : nil;
    completion(error, results);
  }];
}

- (void)listTrackers2:(KBRListTrackers2RequestParams *)params completion:(void (^)(NSError *error, KBRUserSummary2Set *userSummary2Set))completion {
  NSDictionary *rparams = @{@"assertion": KBRValue(params.assertion), @"reverse": @(params.reverse)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTrackers2" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUserSummary2Set *result = retval ? [MTLJSONAdapter modelOfClass:KBRUserSummary2Set.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

- (void)listTrackers2WithAssertion:(NSString *)assertion reverse:(BOOL)reverse completion:(void (^)(NSError *error, KBRUserSummary2Set *userSummary2Set))completion {
  NSDictionary *rparams = @{@"assertion": KBRValue(assertion), @"reverse": @(reverse)};
  [self.client sendRequestWithMethod:@"keybase.1.user.listTrackers2" params:rparams sessionId:self.sessionId completion:^(NSError *error, id retval) {
    if (error) {
      completion(error, nil);
      return;
    }
    KBRUserSummary2Set *result = retval ? [MTLJSONAdapter modelOfClass:KBRUserSummary2Set.class fromJSONDictionary:retval error:&error] : nil;
    completion(error, result);
  }];
}

@end
@implementation KBRSaltpackPromptForDecryptRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.sender = [MTLJSONAdapter modelOfClass:KBRSaltpackSender.class fromJSONDictionary:params[0][@"sender"] error:nil];
    self.usedDelegateUI = [params[0][@"usedDelegateUI"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRSaltpackPromptForDecryptRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSaltpackVerifySuccessRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.signingKID = params[0][@"signingKID"];
    self.sender = [MTLJSONAdapter modelOfClass:KBRSaltpackSender.class fromJSONDictionary:params[0][@"sender"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSaltpackVerifySuccessRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPassphraseChangeRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.oldPassphrase = params[0][@"oldPassphrase"];
    self.passphrase = params[0][@"passphrase"];
    self.force = [params[0][@"force"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPassphraseChangeRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPassphrasePromptRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.guiArg = [MTLJSONAdapter modelOfClass:KBRGUIEntryArg.class fromJSONDictionary:params[0][@"guiArg"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPassphrasePromptRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.endpoint = params[0][@"endpoint"];
    self.args = [MTLJSONAdapter modelsOfClass:KBRStringKVPair.class fromJSONArray:params[0][@"args"] error:nil];
    self.httpStatus = KBRValidateArray(params[0][@"httpStatus"], NSNumber.class);
    self.appStatusCode = KBRValidateArray(params[0][@"appStatusCode"], NSNumber.class);
  }
  return self;
}

+ (instancetype)params {
  KBRGetRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPostRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.endpoint = params[0][@"endpoint"];
    self.args = [MTLJSONAdapter modelsOfClass:KBRStringKVPair.class fromJSONArray:params[0][@"args"] error:nil];
    self.httpStatus = KBRValidateArray(params[0][@"httpStatus"], NSNumber.class);
    self.appStatusCode = KBRValidateArray(params[0][@"appStatusCode"], NSNumber.class);
  }
  return self;
}

+ (instancetype)params {
  KBRPostRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPostJSONRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.endpoint = params[0][@"endpoint"];
    self.args = [MTLJSONAdapter modelsOfClass:KBRStringKVPair.class fromJSONArray:params[0][@"args"] error:nil];
    self.JSONPayload = [MTLJSONAdapter modelsOfClass:KBRStringKVPair.class fromJSONArray:params[0][@"JSONPayload"] error:nil];
    self.httpStatus = KBRValidateArray(params[0][@"httpStatus"], NSNumber.class);
    self.appStatusCode = KBRValidateArray(params[0][@"appStatusCode"], NSNumber.class);
  }
  return self;
}

+ (instancetype)params {
  KBRPostJSONRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRAuthenticateSessionRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.signature = params[0][@"signature"];
  }
  return self;
}

+ (instancetype)params {
  KBRAuthenticateSessionRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPutBlockRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.bid = [MTLJSONAdapter modelOfClass:KBRBlockIdCombo.class fromJSONDictionary:params[0][@"bid"] error:nil];
    self.folder = params[0][@"folder"];
    self.blockKey = params[0][@"blockKey"];
    self.buf = params[0][@"buf"];
  }
  return self;
}

+ (instancetype)params {
  KBRPutBlockRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetBlockRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.bid = [MTLJSONAdapter modelOfClass:KBRBlockIdCombo.class fromJSONDictionary:params[0][@"bid"] error:nil];
    self.folder = params[0][@"folder"];
  }
  return self;
}

+ (instancetype)params {
  KBRGetBlockRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRAddReferenceRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folder = params[0][@"folder"];
    self.ref = [MTLJSONAdapter modelOfClass:KBRBlockReference.class fromJSONDictionary:params[0][@"ref"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRAddReferenceRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDelReferenceRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folder = params[0][@"folder"];
    self.ref = [MTLJSONAdapter modelOfClass:KBRBlockReference.class fromJSONDictionary:params[0][@"ref"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRDelReferenceRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRArchiveReferenceRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folder = params[0][@"folder"];
    self.refs = [MTLJSONAdapter modelsOfClass:KBRBlockReference.class fromJSONArray:params[0][@"refs"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRArchiveReferenceRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDelReferenceWithCountRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folder = params[0][@"folder"];
    self.refs = [MTLJSONAdapter modelsOfClass:KBRBlockReference.class fromJSONArray:params[0][@"refs"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRDelReferenceWithCountRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRArchiveReferenceWithCountRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folder = params[0][@"folder"];
    self.refs = [MTLJSONAdapter modelsOfClass:KBRBlockReference.class fromJSONArray:params[0][@"refs"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRArchiveReferenceWithCountRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRRegisterBTCRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.address = params[0][@"address"];
    self.force = [params[0][@"force"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRRegisterBTCRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetCurrentStatusRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetCurrentStatusRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetExtendedStatusRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetExtendedStatusRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetConfigRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetConfigRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSetUserConfigRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
    self.key = params[0][@"key"];
    self.value = params[0][@"value"];
  }
  return self;
}

+ (instancetype)params {
  KBRSetUserConfigRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSetPathRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.path = params[0][@"path"];
  }
  return self;
}

+ (instancetype)params {
  KBRSetPathRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRHelloIAmRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.details = [MTLJSONAdapter modelOfClass:KBRClientDetails.class fromJSONDictionary:params[0][@"details"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRHelloIAmRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSetValueRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.path = params[0][@"path"];
    self.value = [MTLJSONAdapter modelOfClass:KBRConfigValue.class fromJSONDictionary:params[0][@"value"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSetValueRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRClearValueRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.path = params[0][@"path"];
  }
  return self;
}

+ (instancetype)params {
  KBRClearValueRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetValueRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.path = params[0][@"path"];
  }
  return self;
}

+ (instancetype)params {
  KBRGetValueRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSignED25519RequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.msg = params[0][@"msg"];
    self.reason = params[0][@"reason"];
  }
  return self;
}

+ (instancetype)params {
  KBRSignED25519RequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSignToStringRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.msg = params[0][@"msg"];
    self.reason = params[0][@"reason"];
  }
  return self;
}

+ (instancetype)params {
  KBRSignToStringRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRUnboxBytes32RequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.encryptedBytes32 = params[0][@"encryptedBytes32"];
    self.nonce = params[0][@"nonce"];
    self.peersPublicKey = params[0][@"peersPublicKey"];
    self.reason = params[0][@"reason"];
  }
  return self;
}

+ (instancetype)params {
  KBRUnboxBytes32RequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRUnboxBytes32AnyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.bundles = [MTLJSONAdapter modelsOfClass:KBRCiphertextBundle.class fromJSONArray:params[0][@"bundles"] error:nil];
    self.reason = params[0][@"reason"];
    self.promptPaper = [params[0][@"promptPaper"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRUnboxBytes32AnyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRStopRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.exitCode = [params[0][@"exitCode"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRStopRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLogRotateRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRLogRotateRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRReloadRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRReloadRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDbNukeRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRDbNukeRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRAppExitRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRAppExitRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFirstStepRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.val = [params[0][@"val"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRFirstStepRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSecondStepRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.val = [params[0][@"val"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRSecondStepRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRIncrementRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.val = [params[0][@"val"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRIncrementRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDeviceListRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRDeviceListRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDeviceHistoryListRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRDeviceHistoryListRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDeviceAddRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRDeviceAddRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRCheckDeviceNameFormatRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.name = params[0][@"name"];
  }
  return self;
}

+ (instancetype)params {
  KBRCheckDeviceNameFormatRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFavoriteAddRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.folder = [MTLJSONAdapter modelOfClass:KBRFolder.class fromJSONDictionary:params[0][@"folder"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRFavoriteAddRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFavoriteIgnoreRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.folder = [MTLJSONAdapter modelOfClass:KBRFolder.class fromJSONDictionary:params[0][@"folder"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRFavoriteIgnoreRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetFavoritesRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetFavoritesRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRListRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.path = params[0][@"path"];
  }
  return self;
}

+ (instancetype)params {
  KBRListRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRWantToAddGPGKeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRWantToAddGPGKeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRConfirmDuplicateKeyChosenRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRConfirmDuplicateKeyChosenRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSelectKeyAndPushOptionRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.keys = [MTLJSONAdapter modelsOfClass:KBRGPGKey.class fromJSONArray:params[0][@"keys"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSelectKeyAndPushOptionRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSelectKeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.keys = [MTLJSONAdapter modelsOfClass:KBRGPGKey.class fromJSONArray:params[0][@"keys"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSelectKeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSignRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.msg = params[0][@"msg"];
    self.fingerprint = params[0][@"fingerprint"];
  }
  return self;
}

+ (instancetype)params {
  KBRSignRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRResolveRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.assertion = params[0][@"assertion"];
  }
  return self;
}

+ (instancetype)params {
  KBRResolveRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRResolve2RequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.assertion = params[0][@"assertion"];
  }
  return self;
}

+ (instancetype)params {
  KBRResolve2RequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRIdentifyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.userAssertion = params[0][@"userAssertion"];
    self.forceRemoteCheck = [params[0][@"forceRemoteCheck"] boolValue];
    self.useDelegateUI = [params[0][@"useDelegateUI"] boolValue];
    self.reason = [MTLJSONAdapter modelOfClass:KBRIdentifyReason.class fromJSONDictionary:params[0][@"reason"] error:nil];
    self.source = [params[0][@"source"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRIdentifyRequestParams *p = [[self alloc] init];
  // Add default values
  p.forceRemoteCheck = false;
  p.useDelegateUI = false;
  return p;
}
@end

@implementation KBRIdentify2RequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.uid = params[0][@"uid"];
    self.userAssertion = params[0][@"userAssertion"];
    self.reason = [MTLJSONAdapter modelOfClass:KBRIdentifyReason.class fromJSONDictionary:params[0][@"reason"] error:nil];
    self.useDelegateUI = [params[0][@"useDelegateUI"] boolValue];
    self.alwaysBlock = [params[0][@"alwaysBlock"] boolValue];
    self.noErrorOnTrackFailure = [params[0][@"noErrorOnTrackFailure"] boolValue];
    self.forceRemoteCheck = [params[0][@"forceRemoteCheck"] boolValue];
    self.needProofSet = [params[0][@"needProofSet"] boolValue];
    self.allowEmptySelfID = [params[0][@"allowEmptySelfID"] boolValue];
    self.noSkipSelf = [params[0][@"noSkipSelf"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRIdentify2RequestParams *p = [[self alloc] init];
  // Add default values
  p.useDelegateUI = false;
  p.alwaysBlock = false;
  p.noErrorOnTrackFailure = false;
  p.forceRemoteCheck = false;
  p.needProofSet = false;
  p.allowEmptySelfID = false;
  p.noSkipSelf = true;
  return p;
}
@end

@implementation KBRDisplayTLFCreateWithInviteRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.folderName = params[0][@"folderName"];
    self.isPrivate = [params[0][@"isPrivate"] boolValue];
    self.assertion = params[0][@"assertion"];
    self.socialAssertion = [MTLJSONAdapter modelOfClass:KBRSocialAssertion.class fromJSONDictionary:params[0][@"socialAssertion"] error:nil];
    self.inviteLink = params[0][@"inviteLink"];
    self.throttled = [params[0][@"throttled"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplayTLFCreateWithInviteRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRStartRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
    self.reason = [MTLJSONAdapter modelOfClass:KBRIdentifyReason.class fromJSONDictionary:params[0][@"reason"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRStartRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDisplayKeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.key = [MTLJSONAdapter modelOfClass:KBRIdentifyKey.class fromJSONDictionary:params[0][@"key"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplayKeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRReportLastTrackRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.track = [MTLJSONAdapter modelOfClass:KBRTrackSummary.class fromJSONDictionary:params[0][@"track"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRReportLastTrackRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLaunchNetworkChecksRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.identity = [MTLJSONAdapter modelOfClass:KBRIdentity.class fromJSONDictionary:params[0][@"identity"] error:nil];
    self.user = [MTLJSONAdapter modelOfClass:KBRUser.class fromJSONDictionary:params[0][@"user"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRLaunchNetworkChecksRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDisplayTrackStatementRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.stmt = params[0][@"stmt"];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplayTrackStatementRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFinishWebProofCheckRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.rp = [MTLJSONAdapter modelOfClass:KBRRemoteProof.class fromJSONDictionary:params[0][@"rp"] error:nil];
    self.lcr = [MTLJSONAdapter modelOfClass:KBRLinkCheckResult.class fromJSONDictionary:params[0][@"lcr"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRFinishWebProofCheckRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFinishSocialProofCheckRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.rp = [MTLJSONAdapter modelOfClass:KBRRemoteProof.class fromJSONDictionary:params[0][@"rp"] error:nil];
    self.lcr = [MTLJSONAdapter modelOfClass:KBRLinkCheckResult.class fromJSONDictionary:params[0][@"lcr"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRFinishSocialProofCheckRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDisplayCryptocurrencyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.c = [MTLJSONAdapter modelOfClass:KBRCryptocurrency.class fromJSONDictionary:params[0][@"c"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplayCryptocurrencyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRReportTrackTokenRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.trackToken = params[0][@"trackToken"];
  }
  return self;
}

+ (instancetype)params {
  KBRReportTrackTokenRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDisplayUserCardRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.card = [MTLJSONAdapter modelOfClass:KBRUserCard.class fromJSONDictionary:params[0][@"card"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplayUserCardRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRConfirmRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.outcome = [MTLJSONAdapter modelOfClass:KBRIdentifyOutcome.class fromJSONDictionary:params[0][@"outcome"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRConfirmRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFinishRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRFinishRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDismissRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
    self.reason = [MTLJSONAdapter modelOfClass:KBRDismissReason.class fromJSONDictionary:params[0][@"reason"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRDismissRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFSEventRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.event = [MTLJSONAdapter modelOfClass:KBRFSNotification.class fromJSONDictionary:params[0][@"event"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRFSEventRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRHelloRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.uid = params[0][@"uid"];
    self.token = params[0][@"token"];
    self.csrf = params[0][@"csrf"];
    self.pps = [MTLJSONAdapter modelOfClass:KBRPassphraseStream.class fromJSONDictionary:params[0][@"pps"] error:nil];
    self.sigBody = params[0][@"sigBody"];
  }
  return self;
}

+ (instancetype)params {
  KBRHelloRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDidCounterSignRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sig = params[0][@"sig"];
  }
  return self;
}

+ (instancetype)params {
  KBRDidCounterSignRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRRegisterLoggerRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.name = params[0][@"name"];
    self.level = [params[0][@"level"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRRegisterLoggerRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLogRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.level = [params[0][@"level"] integerValue];
    self.text = [MTLJSONAdapter modelOfClass:KBRText.class fromJSONDictionary:params[0][@"text"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRLogRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetConfiguredAccountsRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetConfiguredAccountsRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLoginRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.deviceType = params[0][@"deviceType"];
    self.usernameOrEmail = params[0][@"usernameOrEmail"];
    self.clientType = [params[0][@"clientType"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRLoginRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRClearStoredSecretRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
  }
  return self;
}

+ (instancetype)params {
  KBRClearStoredSecretRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLogoutRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRLogoutRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDeprovisionRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
    self.doRevoke = [params[0][@"doRevoke"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRDeprovisionRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRRecoverAccountFromEmailAddressRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.email = params[0][@"email"];
  }
  return self;
}

+ (instancetype)params {
  KBRRecoverAccountFromEmailAddressRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPaperKeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPaperKeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPaperKeySubmitRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.paperPhrase = params[0][@"paperPhrase"];
  }
  return self;
}

+ (instancetype)params {
  KBRPaperKeySubmitRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRUnlockRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRUnlockRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRUnlockWithPassphraseRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.passphrase = params[0][@"passphrase"];
  }
  return self;
}

+ (instancetype)params {
  KBRUnlockWithPassphraseRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpProvisionRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
    self.passphrase = params[0][@"passphrase"];
    self.deviceName = params[0][@"deviceName"];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpProvisionRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetEmailOrUsernameRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetEmailOrUsernameRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPromptRevokePaperKeysRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.device = [MTLJSONAdapter modelOfClass:KBRDevice.class fromJSONDictionary:params[0][@"device"] error:nil];
    self.index = [params[0][@"index"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPromptRevokePaperKeysRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDisplayPaperKeyPhraseRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.phrase = params[0][@"phrase"];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplayPaperKeyPhraseRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDisplayPrimaryPaperKeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.phrase = params[0][@"phrase"];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplayPrimaryPaperKeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRAuthenticateRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.signature = params[0][@"signature"];
  }
  return self;
}

+ (instancetype)params {
  KBRAuthenticateRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPutMetadataRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.mdBlock = [MTLJSONAdapter modelOfClass:KBRMDBlock.class fromJSONDictionary:params[0][@"mdBlock"] error:nil];
    self.logTags = KBRValidateDictionary(params[0][@"logTags"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRPutMetadataRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetMetadataRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folderID = params[0][@"folderID"];
    self.folderHandle = params[0][@"folderHandle"];
    self.branchID = params[0][@"branchID"];
    self.unmerged = [params[0][@"unmerged"] boolValue];
    self.startRevision = [params[0][@"startRevision"] longValue];
    self.stopRevision = [params[0][@"stopRevision"] longValue];
    self.logTags = KBRValidateDictionary(params[0][@"logTags"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRGetMetadataRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRRegisterForUpdatesRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folderID = params[0][@"folderID"];
    self.currRevision = [params[0][@"currRevision"] longValue];
    self.logTags = KBRValidateDictionary(params[0][@"logTags"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRRegisterForUpdatesRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPruneBranchRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folderID = params[0][@"folderID"];
    self.branchID = params[0][@"branchID"];
    self.logTags = KBRValidateDictionary(params[0][@"logTags"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRPruneBranchRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPutKeysRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.keyHalves = [MTLJSONAdapter modelsOfClass:KBRKeyHalf.class fromJSONArray:params[0][@"keyHalves"] error:nil];
    self.logTags = KBRValidateDictionary(params[0][@"logTags"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRPutKeysRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetKeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.keyHalfID = params[0][@"keyHalfID"];
    self.deviceKID = params[0][@"deviceKID"];
    self.logTags = KBRValidateDictionary(params[0][@"logTags"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRGetKeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDeleteKeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.uid = params[0][@"uid"];
    self.deviceKID = params[0][@"deviceKID"];
    self.keyHalfID = params[0][@"keyHalfID"];
    self.logTags = KBRValidateDictionary(params[0][@"logTags"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRDeleteKeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRTruncateLockRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folderID = params[0][@"folderID"];
  }
  return self;
}

+ (instancetype)params {
  KBRTruncateLockRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRTruncateUnlockRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folderID = params[0][@"folderID"];
  }
  return self;
}

+ (instancetype)params {
  KBRTruncateUnlockRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetFolderHandleRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folderID = params[0][@"folderID"];
    self.signature = params[0][@"signature"];
    self.challenge = params[0][@"challenge"];
  }
  return self;
}

+ (instancetype)params {
  KBRGetFolderHandleRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetFoldersForRekeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.deviceKID = params[0][@"deviceKID"];
  }
  return self;
}

+ (instancetype)params {
  KBRGetFoldersForRekeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetLatestFolderHandleRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folderID = params[0][@"folderID"];
  }
  return self;
}

+ (instancetype)params {
  KBRGetLatestFolderHandleRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetMerkleRootRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.treeID = [params[0][@"treeID"] integerValue];
    self.seqNo = [params[0][@"seqNo"] longValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetMerkleRootRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetMerkleRootLatestRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.treeID = [params[0][@"treeID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetMerkleRootLatestRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetMerkleRootSinceRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.treeID = [params[0][@"treeID"] integerValue];
    self.when = [params[0][@"when"] longValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetMerkleRootSinceRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetMerkleNodeRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.hash = params[0][@"hash"];
  }
  return self;
}

+ (instancetype)params {
  KBRGetMerkleNodeRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRMetadataUpdateRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folderID = params[0][@"folderID"];
    self.revision = [params[0][@"revision"] longValue];
  }
  return self;
}

+ (instancetype)params {
  KBRMetadataUpdateRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFolderNeedsRekeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.folderID = params[0][@"folderID"];
    self.revision = [params[0][@"revision"] longValue];
  }
  return self;
}

+ (instancetype)params {
  KBRFolderNeedsRekeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSetNotificationsRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.channels = [MTLJSONAdapter modelOfClass:KBRNotificationChannels.class fromJSONDictionary:params[0][@"channels"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSetNotificationsRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFavoritesChangedRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.uid = params[0][@"uid"];
  }
  return self;
}

+ (instancetype)params {
  KBRFavoritesChangedRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFSActivityRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.notification = [MTLJSONAdapter modelOfClass:KBRFSNotification.class fromJSONDictionary:params[0][@"notification"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRFSActivityRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRKeyfamilyChangedRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.uid = params[0][@"uid"];
  }
  return self;
}

+ (instancetype)params {
  KBRKeyfamilyChangedRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPaperKeyCachedRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.uid = params[0][@"uid"];
    self.encKID = params[0][@"encKID"];
    self.sigKID = params[0][@"sigKID"];
  }
  return self;
}

+ (instancetype)params {
  KBRPaperKeyCachedRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLoggedInRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.username = params[0][@"username"];
  }
  return self;
}

+ (instancetype)params {
  KBRLoggedInRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRClientOutOfDateRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.upgradeTo = params[0][@"upgradeTo"];
    self.upgradeURI = params[0][@"upgradeURI"];
    self.upgradeMsg = params[0][@"upgradeMsg"];
  }
  return self;
}

+ (instancetype)params {
  KBRClientOutOfDateRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRTrackingChangedRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.uid = params[0][@"uid"];
    self.username = params[0][@"username"];
  }
  return self;
}

+ (instancetype)params {
  KBRTrackingChangedRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRUserChangedRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.uid = params[0][@"uid"];
  }
  return self;
}

+ (instancetype)params {
  KBRUserChangedRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPaperProvisionRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
    self.deviceName = params[0][@"deviceName"];
    self.paperKey = params[0][@"paperKey"];
  }
  return self;
}

+ (instancetype)params {
  KBRPaperProvisionRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpSignRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.source = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"source"] error:nil];
    self.sink = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"sink"] error:nil];
    self.opts = [MTLJSONAdapter modelOfClass:KBRPGPSignOptions.class fromJSONDictionary:params[0][@"opts"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpSignRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpPullRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.userAsserts = KBRValidateArray(params[0][@"userAsserts"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRPgpPullRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpEncryptRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.source = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"source"] error:nil];
    self.sink = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"sink"] error:nil];
    self.opts = [MTLJSONAdapter modelOfClass:KBRPGPEncryptOptions.class fromJSONDictionary:params[0][@"opts"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpEncryptRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpDecryptRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.source = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"source"] error:nil];
    self.sink = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"sink"] error:nil];
    self.opts = [MTLJSONAdapter modelOfClass:KBRPGPDecryptOptions.class fromJSONDictionary:params[0][@"opts"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpDecryptRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpVerifyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.source = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"source"] error:nil];
    self.opts = [MTLJSONAdapter modelOfClass:KBRPGPVerifyOptions.class fromJSONDictionary:params[0][@"opts"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpVerifyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpImportRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.key = params[0][@"key"];
    self.pushSecret = [params[0][@"pushSecret"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpImportRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpExportRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.options = [MTLJSONAdapter modelOfClass:KBRPGPQuery.class fromJSONDictionary:params[0][@"options"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpExportRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpExportByFingerprintRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.options = [MTLJSONAdapter modelOfClass:KBRPGPQuery.class fromJSONDictionary:params[0][@"options"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpExportByFingerprintRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpExportByKIDRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.options = [MTLJSONAdapter modelOfClass:KBRPGPQuery.class fromJSONDictionary:params[0][@"options"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpExportByKIDRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpKeyGenRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.primaryBits = [params[0][@"primaryBits"] integerValue];
    self.subkeyBits = [params[0][@"subkeyBits"] integerValue];
    self.createUids = [MTLJSONAdapter modelOfClass:KBRPGPCreateUids.class fromJSONDictionary:params[0][@"createUids"] error:nil];
    self.allowMulti = [params[0][@"allowMulti"] boolValue];
    self.doExport = [params[0][@"doExport"] boolValue];
    self.pushSecret = [params[0][@"pushSecret"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpKeyGenRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpDeletePrimaryRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpDeletePrimaryRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpSelectRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.fingerprintQuery = params[0][@"fingerprintQuery"];
    self.allowMulti = [params[0][@"allowMulti"] boolValue];
    self.skipImport = [params[0][@"skipImport"] boolValue];
    self.onlyImport = [params[0][@"onlyImport"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpSelectRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpUpdateRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.all = [params[0][@"all"] boolValue];
    self.fingerprints = KBRValidateArray(params[0][@"fingerprints"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRPgpUpdateRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPgpPurgeRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.doPurge = [params[0][@"doPurge"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPgpPurgeRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBROutputSignatureSuccessRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.fingerprint = params[0][@"fingerprint"];
    self.username = params[0][@"username"];
    self.signedAt = [params[0][@"signedAt"] longValue];
  }
  return self;
}

+ (instancetype)params {
  KBROutputSignatureSuccessRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRStartProofRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.service = params[0][@"service"];
    self.username = params[0][@"username"];
    self.force = [params[0][@"force"] boolValue];
    self.promptPosted = [params[0][@"promptPosted"] boolValue];
    self.automatic = [params[0][@"automatic"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRStartProofRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRCheckProofRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.sigID = params[0][@"sigID"];
  }
  return self;
}

+ (instancetype)params {
  KBRCheckProofRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPromptOverwriteRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.account = params[0][@"account"];
    self.typ = [params[0][@"typ"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPromptOverwriteRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPromptUsernameRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.prompt = params[0][@"prompt"];
    self.prevError = [MTLJSONAdapter modelOfClass:KBRStatus.class fromJSONDictionary:params[0][@"prevError"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPromptUsernameRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBROutputPrechecksRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.text = [MTLJSONAdapter modelOfClass:KBRText.class fromJSONDictionary:params[0][@"text"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBROutputPrechecksRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPreProofWarningRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.text = [MTLJSONAdapter modelOfClass:KBRText.class fromJSONDictionary:params[0][@"text"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRPreProofWarningRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBROutputInstructionsRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.instructions = [MTLJSONAdapter modelOfClass:KBRText.class fromJSONDictionary:params[0][@"instructions"] error:nil];
    self.proof = params[0][@"proof"];
  }
  return self;
}

+ (instancetype)params {
  KBROutputInstructionsRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBROkToCheckRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.name = params[0][@"name"];
    self.attempt = [params[0][@"attempt"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBROkToCheckRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDisplayRecheckWarningRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.text = [MTLJSONAdapter modelOfClass:KBRText.class fromJSONDictionary:params[0][@"text"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplayRecheckWarningRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRChooseProvisioningMethodRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.gpgOption = [params[0][@"gpgOption"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRChooseProvisioningMethodRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRChooseGPGMethodRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.keys = [MTLJSONAdapter modelsOfClass:KBRGPGKey.class fromJSONArray:params[0][@"keys"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRChooseGPGMethodRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSwitchToGPGSignOKRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.key = [MTLJSONAdapter modelOfClass:KBRGPGKey.class fromJSONDictionary:params[0][@"key"] error:nil];
    self.importError = params[0][@"importError"];
  }
  return self;
}

+ (instancetype)params {
  KBRSwitchToGPGSignOKRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRChooseDeviceRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.devices = [MTLJSONAdapter modelsOfClass:KBRDevice.class fromJSONArray:params[0][@"devices"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRChooseDeviceRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRChooseDeviceTypeRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.kind = [params[0][@"kind"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRChooseDeviceTypeRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDisplayAndPromptSecretRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.secret = params[0][@"secret"];
    self.phrase = params[0][@"phrase"];
    self.otherDeviceType = [params[0][@"otherDeviceType"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplayAndPromptSecretRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDisplaySecretExchangedRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRDisplaySecretExchangedRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPromptNewDeviceNameRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.existingDevices = KBRValidateArray(params[0][@"existingDevices"], NSString.class);
    self.errorMessage = params[0][@"errorMessage"];
  }
  return self;
}

+ (instancetype)params {
  KBRPromptNewDeviceNameRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRProvisioneeSuccessRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
    self.deviceName = params[0][@"deviceName"];
  }
  return self;
}

+ (instancetype)params {
  KBRProvisioneeSuccessRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRProvisionerSuccessRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.deviceName = params[0][@"deviceName"];
    self.deviceType = params[0][@"deviceType"];
  }
  return self;
}

+ (instancetype)params {
  KBRProvisionerSuccessRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRVerifySessionRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.session = params[0][@"session"];
  }
  return self;
}

+ (instancetype)params {
  KBRVerifySessionRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRShowPendingRekeyStatusRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRShowPendingRekeyStatusRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetPendingRekeyStatusRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetPendingRekeyStatusRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDebugShowRekeyStatusRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRDebugShowRekeyStatusRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRRekeyStatusFinishRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRRekeyStatusFinishRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRRefreshRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.problemSetDevices = [MTLJSONAdapter modelOfClass:KBRProblemSetDevices.class fromJSONDictionary:params[0][@"problemSetDevices"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRRefreshRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRRevokeKeyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.keyID = params[0][@"keyID"];
  }
  return self;
}

+ (instancetype)params {
  KBRRevokeKeyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRRevokeDeviceRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.deviceID = params[0][@"deviceID"];
    self.force = [params[0][@"force"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRRevokeDeviceRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRRevokeSigsRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.sigIDQueries = KBRValidateArray(params[0][@"sigIDQueries"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRRevokeSigsRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSaltpackEncryptRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.source = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"source"] error:nil];
    self.sink = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"sink"] error:nil];
    self.opts = [MTLJSONAdapter modelOfClass:KBRSaltpackEncryptOptions.class fromJSONDictionary:params[0][@"opts"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSaltpackEncryptRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSaltpackDecryptRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.source = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"source"] error:nil];
    self.sink = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"sink"] error:nil];
    self.opts = [MTLJSONAdapter modelOfClass:KBRSaltpackDecryptOptions.class fromJSONDictionary:params[0][@"opts"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSaltpackDecryptRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSaltpackSignRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.source = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"source"] error:nil];
    self.sink = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"sink"] error:nil];
    self.opts = [MTLJSONAdapter modelOfClass:KBRSaltpackSignOptions.class fromJSONDictionary:params[0][@"opts"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSaltpackSignRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSaltpackVerifyRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.source = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"source"] error:nil];
    self.sink = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"sink"] error:nil];
    self.opts = [MTLJSONAdapter modelOfClass:KBRSaltpackVerifyOptions.class fromJSONDictionary:params[0][@"opts"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSaltpackVerifyRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetPassphraseRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.pinentry = [MTLJSONAdapter modelOfClass:KBRGUIEntryArg.class fromJSONDictionary:params[0][@"pinentry"] error:nil];
    self.terminal = [MTLJSONAdapter modelOfClass:KBRSecretEntryArg.class fromJSONDictionary:params[0][@"terminal"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRGetPassphraseRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetSecretKeysRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRGetSecretKeysRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRCurrentSessionRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRCurrentSessionRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRCheckUsernameAvailableRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
  }
  return self;
}

+ (instancetype)params {
  KBRCheckUsernameAvailableRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSignupRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.email = params[0][@"email"];
    self.inviteCode = params[0][@"inviteCode"];
    self.passphrase = params[0][@"passphrase"];
    self.username = params[0][@"username"];
    self.deviceName = params[0][@"deviceName"];
    self.storeSecret = [params[0][@"storeSecret"] boolValue];
    self.skipMail = [params[0][@"skipMail"] boolValue];
    self.genPGPBatch = [params[0][@"genPGPBatch"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRSignupRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRInviteRequestRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.email = params[0][@"email"];
    self.fullname = params[0][@"fullname"];
    self.notes = params[0][@"notes"];
  }
  return self;
}

+ (instancetype)params {
  KBRInviteRequestRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRCheckInvitationCodeRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.invitationCode = params[0][@"invitationCode"];
  }
  return self;
}

+ (instancetype)params {
  KBRCheckInvitationCodeRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSigListRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.arg = [MTLJSONAdapter modelOfClass:KBRSigListArgs.class fromJSONDictionary:params[0][@"arg"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSigListRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSigListJSONRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.arg = [MTLJSONAdapter modelOfClass:KBRSigListArgs.class fromJSONDictionary:params[0][@"arg"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRSigListJSONRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRCloseRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.s = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"s"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRCloseRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRReadRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.s = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"s"] error:nil];
    self.sz = [params[0][@"sz"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRReadRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRWriteRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.s = [MTLJSONAdapter modelOfClass:KBRStream.class fromJSONDictionary:params[0][@"s"] error:nil];
    self.buf = params[0][@"buf"];
  }
  return self;
}

+ (instancetype)params {
  KBRWriteRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRTestRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.name = params[0][@"name"];
  }
  return self;
}

+ (instancetype)params {
  KBRTestRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRTestCallbackRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.name = params[0][@"name"];
  }
  return self;
}

+ (instancetype)params {
  KBRTestCallbackRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPanicRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.message = params[0][@"message"];
  }
  return self;
}

+ (instancetype)params {
  KBRPanicRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRCryptKeysRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.tlfName = params[0][@"tlfName"];
  }
  return self;
}

+ (instancetype)params {
  KBRCryptKeysRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRGetTLFCryptKeysRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.tlfName = params[0][@"tlfName"];
  }
  return self;
}

+ (instancetype)params {
  KBRGetTLFCryptKeysRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRTrackRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.userAssertion = params[0][@"userAssertion"];
    self.options = [MTLJSONAdapter modelOfClass:KBRTrackOptions.class fromJSONDictionary:params[0][@"options"] error:nil];
    self.forceRemoteCheck = [params[0][@"forceRemoteCheck"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRTrackRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRTrackWithTokenRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.trackToken = params[0][@"trackToken"];
    self.options = [MTLJSONAdapter modelOfClass:KBRTrackOptions.class fromJSONDictionary:params[0][@"options"] error:nil];
  }
  return self;
}

+ (instancetype)params {
  KBRTrackWithTokenRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRDismissWithTokenRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.trackToken = params[0][@"trackToken"];
  }
  return self;
}

+ (instancetype)params {
  KBRDismissWithTokenRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRUntrackRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
  }
  return self;
}

+ (instancetype)params {
  KBRUntrackRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRCheckTrackingRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRCheckTrackingRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRFakeTrackingChangedRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
  }
  return self;
}

+ (instancetype)params {
  KBRFakeTrackingChangedRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRPromptYesNoRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.text = [MTLJSONAdapter modelOfClass:KBRText.class fromJSONDictionary:params[0][@"text"] error:nil];
    self.promptDefault = [params[0][@"promptDefault"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRPromptYesNoRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRListTrackersRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.uid = params[0][@"uid"];
  }
  return self;
}

+ (instancetype)params {
  KBRListTrackersRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRListTrackersByNameRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
  }
  return self;
}

+ (instancetype)params {
  KBRListTrackersByNameRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRListTrackersSelfRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
  }
  return self;
}

+ (instancetype)params {
  KBRListTrackersSelfRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLoadUncheckedUserSummariesRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.uids = KBRValidateArray(params[0][@"uids"], NSString.class);
  }
  return self;
}

+ (instancetype)params {
  KBRLoadUncheckedUserSummariesRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLoadUserRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.uid = params[0][@"uid"];
  }
  return self;
}

+ (instancetype)params {
  KBRLoadUserRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLoadUserByNameRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.username = params[0][@"username"];
  }
  return self;
}

+ (instancetype)params {
  KBRLoadUserByNameRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLoadUserPlusKeysRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.uid = params[0][@"uid"];
  }
  return self;
}

+ (instancetype)params {
  KBRLoadUserPlusKeysRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLoadPublicKeysRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.uid = params[0][@"uid"];
  }
  return self;
}

+ (instancetype)params {
  KBRLoadPublicKeysRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRListTrackingRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.filter = params[0][@"filter"];
    self.assertion = params[0][@"assertion"];
  }
  return self;
}

+ (instancetype)params {
  KBRListTrackingRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRListTrackingJSONRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.filter = params[0][@"filter"];
    self.verbose = [params[0][@"verbose"] boolValue];
    self.assertion = params[0][@"assertion"];
  }
  return self;
}

+ (instancetype)params {
  KBRListTrackingJSONRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRSearchRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.query = params[0][@"query"];
  }
  return self;
}

+ (instancetype)params {
  KBRSearchRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRLoadAllPublicKeysUnverifiedRequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.uid = params[0][@"uid"];
  }
  return self;
}

+ (instancetype)params {
  KBRLoadAllPublicKeysUnverifiedRequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end

@implementation KBRListTrackers2RequestParams

- (instancetype)initWithParams:(NSArray *)params {
  if ((self = [super initWithParams:params])) {
    self.sessionID = [params[0][@"sessionID"] integerValue];
    self.assertion = params[0][@"assertion"];
    self.reverse = [params[0][@"reverse"] boolValue];
  }
  return self;
}

+ (instancetype)params {
  KBRListTrackers2RequestParams *p = [[self alloc] init];
  // Add default values
  return p;
}
@end
@implementation KBRStringKVPair
@end

@implementation KBRStatus
+ (NSValueTransformer *)fieldsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRStringKVPair.class]; }
@end

@implementation KBRText
@end

@implementation KBRPGPIdentity
@end

@implementation KBRPublicKey
+ (NSValueTransformer *)PGPIdentitiesJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRPGPIdentity.class]; }
@end

@implementation KBRKeybaseTime
@end

@implementation KBRRevokedKey
@end

@implementation KBRUser
@end

@implementation KBRDevice
@end

@implementation KBRStream
@end

@implementation KBRUserVersionVector
@end

@implementation KBRUserPlusKeys
+ (NSValueTransformer *)deviceKeysJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRPublicKey.class]; }
+ (NSValueTransformer *)revokedDeviceKeysJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRRevokedKey.class]; }
@end

@implementation KBRSocialAssertion
@end

@implementation KBRUserResolution
@end

@implementation KBRTrackDiff
@end

@implementation KBRTrackSummary
@end

@implementation KBRTrackOptions
@end

@implementation KBRIdentifyReason
@end

@implementation KBRIdentifyOutcome
+ (NSValueTransformer *)revokedJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRTrackDiff.class]; }
@end

@implementation KBRIdentifyRes
+ (NSValueTransformer *)publicKeysJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRPublicKey.class]; }
@end

@implementation KBRRemoteProof
@end

@implementation KBRSaltpackSender
@end

@implementation KBRAPIRes
@end

@implementation KBRBlockIdCombo
@end

@implementation KBRChallengeInfo
@end

@implementation KBRGetBlockRes
@end

@implementation KBRBlockReference
@end

@implementation KBRBlockReferenceCount
@end

@implementation KBRDowngradeReferenceRes
+ (NSValueTransformer *)completedJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRBlockReferenceCount.class]; }
@end

@implementation KBRGetCurrentStatusRes
@end

@implementation KBRSessionStatus
@end

@implementation KBRClientDetails
@end

@implementation KBRPlatformInfo
@end

@implementation KBRExtendedStatus
+ (NSValueTransformer *)ClientsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRClientDetails.class]; }
@end

@implementation KBRConfig
@end

@implementation KBRConfigValue
@end

@implementation KBROutOfDateInfo
@end

@implementation KBRED25519SignatureInfo
@end

@implementation KBRCiphertextBundle
@end

@implementation KBRUnboxAnyRes
@end

@implementation KBRFirstStepResult
@end

@implementation KBRDeviceDetail
@end

@implementation KBRFolder
@end

@implementation KBRFavoritesResult
+ (NSValueTransformer *)favoriteFoldersJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRFolder.class]; }
+ (NSValueTransformer *)ignoredFoldersJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRFolder.class]; }
+ (NSValueTransformer *)foldersNewJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRFolder.class]; }
@end

@implementation KBRFile
@end

@implementation KBRListResult
+ (NSValueTransformer *)filesJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRFile.class]; }
@end

@implementation KBRGPGKey
+ (NSValueTransformer *)identitiesJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRPGPIdentity.class]; }
@end

@implementation KBRSelectKeyRes
@end

@implementation KBRIdentify2Res
@end

@implementation KBRProofResult
@end

@implementation KBRIdentifyRow
@end

@implementation KBRIdentifyKey
@end

@implementation KBRCryptocurrency
@end

@implementation KBRRevokedProof
@end

@implementation KBRIdentity
+ (NSValueTransformer *)proofsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRIdentifyRow.class]; }
+ (NSValueTransformer *)cryptocurrencyJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRCryptocurrency.class]; }
+ (NSValueTransformer *)revokedJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRTrackDiff.class]; }
+ (NSValueTransformer *)revokedDetailsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRRevokedProof.class]; }
@end

@implementation KBRSigHint
@end

@implementation KBRCheckResult
@end

@implementation KBRLinkCheckResult
@end

@implementation KBRUserCard
@end

@implementation KBRConfirmResult
@end

@implementation KBRDismissReason
@end

@implementation KBRServiceStatus
@end

@implementation KBRServicesStatus
+ (NSValueTransformer *)serviceJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRServiceStatus.class]; }
+ (NSValueTransformer *)kbfsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRServiceStatus.class]; }
+ (NSValueTransformer *)updaterJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRServiceStatus.class]; }
@end

@implementation KBRFuseMountInfo
@end

@implementation KBRFuseStatus
+ (NSValueTransformer *)mountInfosJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRFuseMountInfo.class]; }
@end

@implementation KBRComponentResult
@end

@implementation KBRInstallResult
+ (NSValueTransformer *)componentResultsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRComponentResult.class]; }
@end

@implementation KBRUninstallResult
+ (NSValueTransformer *)componentResultsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRComponentResult.class]; }
@end

@implementation KBRFSNotification
@end

@implementation KBRPassphraseStream
@end

@implementation KBRConfiguredAccount
@end

@implementation KBRKeyHalf
@end

@implementation KBRMDBlock
@end

@implementation KBRMetadataResponse
+ (NSValueTransformer *)mdBlocksJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRMDBlock.class]; }
@end

@implementation KBRMerkleRoot
@end

@implementation KBRPingResponse
@end

@implementation KBRNotificationChannels
@end

@implementation KBRFeature
@end

@implementation KBRGUIEntryFeatures
@end

@implementation KBRGUIEntryArg
@end

@implementation KBRGetPassphraseRes
@end

@implementation KBRPGPSignOptions
@end

@implementation KBRPGPEncryptOptions
@end

@implementation KBRPGPSigVerification
@end

@implementation KBRPGPDecryptOptions
@end

@implementation KBRPGPVerifyOptions
@end

@implementation KBRKeyInfo
@end

@implementation KBRPGPQuery
@end

@implementation KBRPGPCreateUids
+ (NSValueTransformer *)idsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRPGPIdentity.class]; }
@end

@implementation KBRPGPPurgeRes
@end

@implementation KBRFileDescriptor
@end

@implementation KBRProcess
+ (NSValueTransformer *)fileDescriptorsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRFileDescriptor.class]; }
@end

@implementation KBRCheckProofStatus
@end

@implementation KBRStartProofResult
@end

@implementation KBRSecretResponse
@end

@implementation KBRVerifySessionRes
@end

@implementation KBRTLF
@end

@implementation KBRProblemTLF
+ (NSValueTransformer *)solution_kidsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:NSString.class]; }
@end

@implementation KBRProblemSet
+ (NSValueTransformer *)tlfsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRProblemTLF.class]; }
@end

@implementation KBRProblemSetDevices
+ (NSValueTransformer *)devicesJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRDevice.class]; }
@end

@implementation KBRSaltpackEncryptOptions
@end

@implementation KBRSaltpackDecryptOptions
@end

@implementation KBRSaltpackSignOptions
@end

@implementation KBRSaltpackVerifyOptions
@end

@implementation KBRSaltpackEncryptedMessageInfo
+ (NSValueTransformer *)devicesJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRDevice.class]; }
@end

@implementation KBRSecretEntryArg
@end

@implementation KBRSecretEntryRes
@end

@implementation KBRSecretKeys
@end

@implementation KBRSession
@end

@implementation KBRSignupRes
@end

@implementation KBRSig
@end

@implementation KBRSigTypes
@end

@implementation KBRSigListArgs
@end

@implementation KBRTest
@end

@implementation KBRCryptKey
@end

@implementation KBRTLFCryptKeys
+ (NSValueTransformer *)CryptKeysJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRCryptKey.class]; }
@end

@implementation KBRTracker
@end

@implementation KBRTrackProof
@end

@implementation KBRWebProof
@end

@implementation KBRProofs
+ (NSValueTransformer *)socialJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRTrackProof.class]; }
+ (NSValueTransformer *)webJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRWebProof.class]; }
+ (NSValueTransformer *)publicKeysJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRPublicKey.class]; }
@end

@implementation KBRUserSummary
@end

@implementation KBRSearchComponent
@end

@implementation KBRSearchResult
+ (NSValueTransformer *)componentsJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRSearchComponent.class]; }
@end

@implementation KBRUserSummary2
@end

@implementation KBRUserSummary2Set
+ (NSValueTransformer *)usersJSONTransformer { return [MTLJSONAdapter arrayTransformerWithModelClass:KBRUserSummary2.class]; }
@end
