/* @flow */

// This file is auto-generated by client/protocol/Makefile.
import * as gregor1 from './flow-types-gregor'

import engine from '../../engine'
import type {$Exact} from './more'
export type int = number
export type int64 = number
export type long = number
export type double = number
export type bytes = any
export type RPCError = {
  code: number,
  desc: string
}
export function Kex2ProvisionerKexStartRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'Kex2Provisioner.kexStart'})
}
export function NotifyAppExitRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifyApp.exit'})
}
export function NotifyServiceShutdownRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifyService.shutdown'})
}
export function NotifySessionLoggedOutRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifySession.loggedOut'})
}
export function ctlAppExitRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'ctl.appExit'})
}
export function ctlDbNukeRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'ctl.dbNuke'})
}
export function ctlLogRotateRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'ctl.logRotate'})
}
export function ctlReloadRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'ctl.reload'})
}
export function delegateUiCtlRegisterGregorFirehoseRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'delegateUiCtl.registerGregorFirehose'})
}
export function delegateUiCtlRegisterIdentifyUIRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'delegateUiCtl.registerIdentifyUI'})
}
export function delegateUiCtlRegisterRekeyUIRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'delegateUiCtl.registerRekeyUI'})
}
export function delegateUiCtlRegisterSecretUIRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'delegateUiCtl.registerSecretUI'})
}
export function delegateUiCtlRegisterUpdateUIRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'delegateUiCtl.registerUpdateUI'})
}
export function deviceDeviceAddRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'device.deviceAdd'})
}
export function identifyUiFinishRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.finish'})
}
export function loginLogoutRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.logout'})
}
export function loginPaperKeyRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.paperKey'})
}
export function loginUnlockRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.unlock'})
}
export function metadataPingRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'metadata.ping'})
}
export function pgpPgpDeletePrimaryRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpDeletePrimary'})
}
export function provisionUiDisplaySecretExchangedRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.DisplaySecretExchanged'})
}
export function rekeyDebugShowRekeyStatusRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'rekey.debugShowRekeyStatus'})
}
export function rekeyShowPendingRekeyStatusRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'rekey.showPendingRekeyStatus'})
}
export function trackCheckTrackingRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'track.checkTracking'})
}
export type APIRes = {
  status: string;
  body: string;
  httpStatus: int;
  appStatus: string;
}

export type BTCRegisterBTCRpcParam = $Exact<{
  address: string,
  force: boolean
}>

export function BTCRegisterBTCRpc (request: $Exact<{
  param: BTCRegisterBTCRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'BTC.registerBTC'})
}
export type BlockIdCombo = {
  blockHash: string;
  chargedTo: UID;
}

export type BlockRefNonce = any

export type BlockReference = {
  bid: BlockIdCombo;
  nonce: BlockRefNonce;
  chargedTo: UID;
}

export type BlockReferenceCount = {
  ref: BlockReference;
  liveCount: int;
}

export type BoxNonce = any

export type BoxPublicKey = any

export type Bytes32 = any

export type ChallengeInfo = {
  now: long;
  challenge: string;
}

export type CheckProofStatus = {
  found: boolean;
  status: ProofStatus;
  proofText: string;
  state: ProofState;
}

export type CheckResult = {
  proofResult: ProofResult;
  time: Time;
  freshness: CheckResultFreshness;
}

export type CheckResultFreshness =
    0 // FRESH_0
  | 1 // AGED_1
  | 2 // RANCID_2

export type ChooseType =
    0 // EXISTING_DEVICE_0
  | 1 // NEW_DEVICE_1

export type CiphertextBundle = {
  kid: KID;
  ciphertext: EncryptedBytes32;
  nonce: BoxNonce;
  publicKey: BoxPublicKey;
}

export type ClientDetails = {
  pid: int;
  clientType: ClientType;
  argv?: ?Array<string>;
  desc: string;
  version: string;
}

export type ClientType = 2 // FORCE GUI ONLY

export type ComponentResult = {
  name: string;
  status: Status;
}

export type Config = {
  serverURI: string;
  socketFile: string;
  label: string;
  runMode: string;
  gpgExists: boolean;
  gpgPath: string;
  version: string;
  path: string;
  configPath: string;
  versionShort: string;
  versionFull: string;
  isAutoForked: boolean;
  forkType: ForkType;
}

export type ConfigValue = {
  isNull: boolean;
  b?: ?boolean;
  i?: ?int;
  s?: ?string;
  o?: ?string;
}

export type ConfiguredAccount = {
  username: string;
  hasStoredSecret: boolean;
}

export type ConfirmResult = {
  identityConfirmed: boolean;
  remoteConfirmed: boolean;
  expiringLocal: boolean;
}

export type Cryptocurrency = {
  rowId: int;
  pkhash: bytes;
  address: string;
}

export type CsrfToken = string

export type Device = {
  type: string;
  name: string;
  deviceID: DeviceID;
  cTime: Time;
  mTime: Time;
  lastUsedTime: Time;
  encryptKey: KID;
  verifyKey: KID;
  status: int;
}

export type DeviceDetail = {
  device: Device;
  eldest: boolean;
  provisioner?: ?Device;
  provisionedAt?: ?Time;
  revokedAt?: ?Time;
  revokedBy: KID;
  revokedByDevice?: ?Device;
  currentDevice: boolean;
}

export type DeviceID = string

export type DeviceType =
    0 // DESKTOP_0
  | 1 // MOBILE_1

export type DismissReason = {
  type: DismissReasonType;
  reason: string;
  resource: string;
}

export type DismissReasonType =
    0 // NONE_0
  | 1 // HANDLED_ELSEWHERE_1

export type DowngradeReferenceRes = {
  completed?: ?Array<BlockReferenceCount>;
  failed: BlockReference;
}

export type ED25519PublicKey = any

export type ED25519Signature = any

export type ED25519SignatureInfo = {
  sig: ED25519Signature;
  publicKey: ED25519PublicKey;
}

export type EncryptedBytes32 = any

export type ExitCode =
    0 // OK_0
  | 2 // NOTOK_2
  | 4 // RESTART_4

export type ExtendedStatus = {
  standalone: boolean;
  passphraseStreamCached: boolean;
  tsecCached: boolean;
  deviceSigKeyCached: boolean;
  deviceEncKeyCached: boolean;
  paperSigKeyCached: boolean;
  paperEncKeyCached: boolean;
  storedSecret: boolean;
  secretPromptSkip: boolean;
  device?: ?Device;
  logDir: string;
  session?: ?SessionStatus;
  defaultUsername: string;
  provisionedUsernames?: ?Array<string>;
  Clients?: ?Array<ClientDetails>;
  platformInfo: PlatformInfo;
}

export type FSErrorType =
    0 // ACCESS_DENIED_0
  | 1 // USER_NOT_FOUND_1
  | 2 // REVOKED_DATA_DETECTED_2
  | 3 // NOT_LOGGED_IN_3
  | 4 // TIMEOUT_4
  | 5 // REKEY_NEEDED_5
  | 6 // BAD_FOLDER_6
  | 7 // NOT_IMPLEMENTED_7
  | 8 // OLD_VERSION_8
  | 9 // OVER_QUOTA_9
  | 10 // NO_SIG_CHAIN_10

export type FSNotification = {
  publicTopLevelFolder: boolean;
  filename: string;
  status: string;
  statusCode: FSStatusCode;
  notificationType: FSNotificationType;
  errorType: FSErrorType;
  params: {[key: string]: string};
}

export type FSNotificationType =
    0 // ENCRYPTING_0
  | 1 // DECRYPTING_1
  | 2 // SIGNING_2
  | 3 // VERIFYING_3
  | 4 // REKEYING_4
  | 5 // CONNECTION_5
  | 6 // MD_READ_SUCCESS_6

export type FSStatusCode =
    0 // START_0
  | 1 // FINISH_1
  | 2 // ERROR_2

export type FavoritesResult = {
  favoriteFolders?: ?Array<Folder>;
  ignoredFolders?: ?Array<Folder>;
  newFolders?: ?Array<Folder>;
}

export type Feature = {
  allow: boolean;
  defaultValue: boolean;
  readonly: boolean;
  label: string;
}

export type File = {
  path: string;
}

export type FileDescriptor = {
  name: string;
  type: FileType;
}

export type FileType =
    0 // UNKNOWN_0
  | 1 // DIRECTORY_1
  | 2 // FILE_2

export type FirstStepResult = {
  valPlusTwo: int;
}

export type Folder = {
  name: string;
  private: boolean;
  notificationsOn: boolean;
  created: boolean;
}

export type ForkType =
    0 // NONE_0
  | 1 // AUTO_1
  | 2 // WATCHDOG_2
  | 3 // LAUNCHD_3

export type FuseMountInfo = {
  path: string;
  fstype: string;
  output: string;
}

export type FuseStatus = {
  version: string;
  bundleVersion: string;
  kextID: string;
  path: string;
  kextStarted: boolean;
  installStatus: InstallStatus;
  installAction: InstallAction;
  mountInfos?: ?Array<FuseMountInfo>;
  status: Status;
}

export type GPGKey = {
  algorithm: string;
  keyID: string;
  creation: string;
  expiration: string;
  identities?: ?Array<PGPIdentity>;
}

export type GPGMethod =
    0 // GPG_NONE_0
  | 1 // GPG_IMPORT_1
  | 2 // GPG_SIGN_2

export type GUIEntryArg = {
  windowTitle: string;
  prompt: string;
  username: string;
  submitLabel: string;
  cancelLabel: string;
  retryLabel: string;
  type: PassphraseType;
  features: GUIEntryFeatures;
}

export type GUIEntryFeatures = {
  storeSecret: Feature;
  showTyping: Feature;
}

export type GetBlockRes = {
  blockKey: string;
  buf: bytes;
}

export type GetCurrentStatusRes = {
  configured: boolean;
  registered: boolean;
  loggedIn: boolean;
  sessionIsValid: boolean;
  user?: ?User;
}

export type GetPassphraseRes = {
  passphrase: string;
  storeSecret: boolean;
}

export type HelloRes = string

export type Identify2Res = {
  upk: UserPlusKeys;
}

export type IdentifyKey = {
  pgpFingerprint: bytes;
  KID: KID;
  trackDiff?: ?TrackDiff;
  breaksTracking: boolean;
}

export type IdentifyOutcome = {
  username: string;
  status?: ?Status;
  warnings?: ?Array<string>;
  trackUsed?: ?TrackSummary;
  trackStatus: TrackStatus;
  numTrackFailures: int;
  numTrackChanges: int;
  numProofFailures: int;
  numRevoked: int;
  numProofSuccesses: int;
  revoked?: ?Array<TrackDiff>;
  trackOptions: TrackOptions;
  forPGPPull: boolean;
  reason: IdentifyReason;
}

export type IdentifyReason = {
  type: IdentifyReasonType;
  reason: string;
  resource: string;
}

export type IdentifyReasonType =
    0 // NONE_0
  | 1 // ID_1
  | 2 // TRACK_2
  | 3 // ENCRYPT_3
  | 4 // DECRYPT_4
  | 5 // VERIFY_5
  | 6 // RESOURCE_6

export type IdentifyRes = {
  user?: ?User;
  publicKeys?: ?Array<PublicKey>;
  outcome: IdentifyOutcome;
  trackToken: TrackToken;
}

export type IdentifyRow = {
  rowId: int;
  proof: RemoteProof;
  trackDiff?: ?TrackDiff;
}

export type Identity = {
  status?: ?Status;
  whenLastTracked: Time;
  proofs?: ?Array<IdentifyRow>;
  cryptocurrency?: ?Array<Cryptocurrency>;
  revoked?: ?Array<TrackDiff>;
  revokedDetails?: ?Array<RevokedProof>;
  breaksTracking: boolean;
}

export type InstallAction =
    0 // UNKNOWN_0
  | 1 // NONE_1
  | 2 // UPGRADE_2
  | 3 // REINSTALL_3
  | 4 // INSTALL_4

export type InstallResult = {
  componentResults?: ?Array<ComponentResult>;
  status: Status;
  fatal: boolean;
}

export type InstallStatus =
    0 // UNKNOWN_0
  | 1 // ERROR_1
  | 2 // NOT_INSTALLED_2
  | 4 // INSTALLED_4

export type KID = string

export type Kex2ProvisioneeDidCounterSignRpcParam = $Exact<{
  sig: bytes
}>

export function Kex2ProvisioneeDidCounterSignRpc (request: $Exact<{
  param: Kex2ProvisioneeDidCounterSignRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'Kex2Provisionee.didCounterSign'})
}
export type Kex2ProvisioneeHelloRpcParam = $Exact<{
  uid: UID,
  token: SessionToken,
  csrf: CsrfToken,
  pps: PassphraseStream,
  sigBody: string
}>

type Kex2ProvisioneeHelloResult = HelloRes

export function Kex2ProvisioneeHelloRpc (request: $Exact<{
  param: Kex2ProvisioneeHelloRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: Kex2ProvisioneeHelloResult) => void)}>) {
  engine.rpc({...request, method: 'Kex2Provisionee.hello'})
}
export type KeyHalf = {
  user: UID;
  deviceKID: KID;
  key: bytes;
}

export type KeyInfo = {
  fingerprint: string;
  key: string;
  desc: string;
}

export type KeybaseTime = {
  unix: Time;
  chain: int;
}

export type LinkCheckResult = {
  proofId: int;
  proofResult: ProofResult;
  snoozedResult: ProofResult;
  torWarning: boolean;
  tmpTrackExpireTime: Time;
  cached?: ?CheckResult;
  diff?: ?TrackDiff;
  remoteDiff?: ?TrackDiff;
  hint?: ?SigHint;
  breaksTracking: boolean;
}

export type ListResult = {
  files?: ?Array<File>;
}

export type LogLevel =
    0 // NONE_0
  | 1 // DEBUG_1
  | 2 // INFO_2
  | 3 // NOTICE_3
  | 4 // WARN_4
  | 5 // ERROR_5
  | 6 // CRITICAL_6
  | 7 // FATAL_7

export type MDBlock = {
  version: int;
  timestamp: Time;
  block: bytes;
}

export type MerkleRoot = {
  version: int;
  root: bytes;
}

export type MerkleTreeID =
    0 // MASTER_0
  | 1 // KBFS_PUBLIC_1
  | 2 // KBFS_PRIVATE_2

export type MetadataResponse = {
  folderID: string;
  mdBlocks?: ?Array<MDBlock>;
}

export type NaclDHKeyPrivate = any

export type NaclDHKeyPublic = any

export type NaclSigningKeyPrivate = any

export type NaclSigningKeyPublic = any

export type NotificationChannels = {
  session: boolean;
  users: boolean;
  kbfs: boolean;
  tracking: boolean;
  favorites: boolean;
  paperkeys: boolean;
  keyfamily: boolean;
  service: boolean;
  app: boolean;
}

export type NotifyFSFSActivityRpcParam = $Exact<{
  notification: FSNotification
}>

export function NotifyFSFSActivityRpc (request: $Exact<{
  param: NotifyFSFSActivityRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifyFS.FSActivity'})
}
export type NotifyFavoritesFavoritesChangedRpcParam = $Exact<{
  uid: UID
}>

export function NotifyFavoritesFavoritesChangedRpc (request: $Exact<{
  param: NotifyFavoritesFavoritesChangedRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifyFavorites.favoritesChanged'})
}
export type NotifyKeyfamilyKeyfamilyChangedRpcParam = $Exact<{
  uid: UID
}>

export function NotifyKeyfamilyKeyfamilyChangedRpc (request: $Exact<{
  param: NotifyKeyfamilyKeyfamilyChangedRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifyKeyfamily.keyfamilyChanged'})
}
export type NotifyPaperKeyPaperKeyCachedRpcParam = $Exact<{
  uid: UID,
  encKID: KID,
  sigKID: KID
}>

export function NotifyPaperKeyPaperKeyCachedRpc (request: $Exact<{
  param: NotifyPaperKeyPaperKeyCachedRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifyPaperKey.paperKeyCached'})
}
export type NotifySessionClientOutOfDateRpcParam = $Exact<{
  upgradeTo: string,
  upgradeURI: string,
  upgradeMsg: string
}>

export function NotifySessionClientOutOfDateRpc (request: $Exact<{
  param: NotifySessionClientOutOfDateRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifySession.clientOutOfDate'})
}
export type NotifySessionLoggedInRpcParam = $Exact<{
  username: string
}>

export function NotifySessionLoggedInRpc (request: $Exact<{
  param: NotifySessionLoggedInRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifySession.loggedIn'})
}
export type NotifyTrackingTrackingChangedRpcParam = $Exact<{
  uid: UID,
  username: string
}>

export function NotifyTrackingTrackingChangedRpc (request: $Exact<{
  param: NotifyTrackingTrackingChangedRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifyTracking.trackingChanged'})
}
export type NotifyUsersUserChangedRpcParam = $Exact<{
  uid: UID
}>

export function NotifyUsersUserChangedRpc (request: $Exact<{
  param: NotifyUsersUserChangedRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'NotifyUsers.userChanged'})
}
export type OutOfDateInfo = {
  upgradeTo: string;
  upgradeURI: string;
  customMessage: string;
}

export type Outcome =
    0 // NONE_0
  | 1 // FIXED_1
  | 2 // IGNORED_2

export type PGPCreateUids = {
  useDefault: boolean;
  ids?: ?Array<PGPIdentity>;
}

export type PGPDecryptOptions = {
  assertSigned: boolean;
  signedBy: string;
}

export type PGPEncryptOptions = {
  recipients?: ?Array<string>;
  noSign: boolean;
  noSelf: boolean;
  binaryOut: boolean;
  keyQuery: string;
}

export type PGPIdentity = {
  username: string;
  comment: string;
  email: string;
}

export type PGPQuery = {
  secret: boolean;
  query: string;
  exactMatch: boolean;
}

export type PGPSigVerification = {
  isSigned: boolean;
  verified: boolean;
  signer: User;
  signKey: PublicKey;
}

export type PGPSignOptions = {
  keyQuery: string;
  mode: SignMode;
  binaryIn: boolean;
  binaryOut: boolean;
}

export type PGPVerifyOptions = {
  signedBy: string;
  signature: bytes;
}

export type PassphraseStream = {
  passphraseStream: bytes;
  generation: int;
}

export type PassphraseType =
    0 // NONE_0
  | 1 // PAPER_KEY_1
  | 2 // PASS_PHRASE_2
  | 3 // VERIFY_PASS_PHRASE_3

export type PingResponse = {
  timestamp: Time;
}

export type PlatformInfo = {
  os: string;
  arch: string;
  goVersion: string;
}

export type ProblemSet = {
  user: User;
  kid: KID;
  tlfs?: ?Array<ProblemTLF>;
}

export type ProblemSetDevices = {
  problemSet: ProblemSet;
  devices?: ?Array<Device>;
}

export type ProblemTLF = {
  tlf: TLF;
  score: int;
  solution_kids?: ?Array<KID>;
}

export type Process = {
  pid: string;
  command: string;
  fileDescriptors?: ?Array<FileDescriptor>;
}

export type PromptDefault =
    0 // NONE_0
  | 1 // YES_1
  | 2 // NO_2

export type PromptOverwriteType =
    0 // SOCIAL_0
  | 1 // SITE_1

export type ProofResult = {
  state: ProofState;
  status: ProofStatus;
  desc: string;
}

export type ProofState =
    0 // NONE_0
  | 1 // OK_1
  | 2 // TEMP_FAILURE_2
  | 3 // PERM_FAILURE_3
  | 4 // LOOKING_4
  | 5 // SUPERSEDED_5
  | 6 // POSTED_6
  | 7 // REVOKED_7

export type ProofStatus =
    0 // NONE_0
  | 1 // OK_1
  | 2 // LOCAL_2
  | 3 // FOUND_3
  | 100 // BASE_ERROR_100
  | 101 // HOST_UNREACHABLE_101
  | 103 // PERMISSION_DENIED_103
  | 106 // FAILED_PARSE_106
  | 107 // DNS_ERROR_107
  | 108 // AUTH_FAILED_108
  | 129 // HTTP_429_129
  | 150 // HTTP_500_150
  | 160 // TIMEOUT_160
  | 170 // INTERNAL_ERROR_170
  | 200 // BASE_HARD_ERROR_200
  | 201 // NOT_FOUND_201
  | 202 // CONTENT_FAILURE_202
  | 203 // BAD_USERNAME_203
  | 204 // BAD_REMOTE_ID_204
  | 205 // TEXT_NOT_FOUND_205
  | 206 // BAD_ARGS_206
  | 207 // CONTENT_MISSING_207
  | 208 // TITLE_NOT_FOUND_208
  | 209 // SERVICE_ERROR_209
  | 210 // TOR_SKIPPED_210
  | 211 // TOR_INCOMPATIBLE_211
  | 230 // HTTP_300_230
  | 240 // HTTP_400_240
  | 260 // HTTP_OTHER_260
  | 270 // EMPTY_JSON_270
  | 301 // DELETED_301
  | 302 // SERVICE_DEAD_302
  | 303 // BAD_SIGNATURE_303
  | 304 // BAD_API_URL_304
  | 305 // UNKNOWN_TYPE_305
  | 306 // NO_HINT_306
  | 307 // BAD_HINT_TEXT_307

export type ProofType =
    0 // NONE_0
  | 1 // KEYBASE_1
  | 2 // TWITTER_2
  | 3 // GITHUB_3
  | 4 // REDDIT_4
  | 5 // COINBASE_5
  | 6 // HACKERNEWS_6
  | 1000 // GENERIC_WEB_SITE_1000
  | 1001 // DNS_1001
  | 1002 // PGP_1002
  | 100001 // ROOTER_100001

export type Proofs = {
  social?: ?Array<TrackProof>;
  web?: ?Array<WebProof>;
  publicKeys?: ?Array<PublicKey>;
}

export type ProvisionMethod =
    0 // DEVICE_0
  | 1 // PAPER_KEY_1
  | 2 // PASSPHRASE_2
  | 3 // GPG_IMPORT_3
  | 4 // GPG_SIGN_4

export type PublicKey = {
  KID: KID;
  PGPFingerprint: string;
  PGPIdentities?: ?Array<PGPIdentity>;
  isSibkey: boolean;
  isEldest: boolean;
  parentID: string;
  deviceID: DeviceID;
  deviceDescription: string;
  deviceType: string;
  cTime: Time;
  eTime: Time;
}

export type PushReason =
    0 // NONE_0
  | 1 // RECONNECTED_1
  | 2 // NEW_DATA_2

export type RemoteProof = {
  proofType: ProofType;
  key: string;
  value: string;
  displayMarkup: string;
  sigID: SigID;
  mTime: Time;
}

export type RevokedKey = {
  key: PublicKey;
  time: KeybaseTime;
  by: KID;
}

export type RevokedProof = {
  proof: RemoteProof;
  diff: TrackDiff;
}

export type SaltpackDecryptOptions = {
  interactive: boolean;
  forceRemoteCheck: boolean;
  usePaperKey: boolean;
}

export type SaltpackEncryptOptions = {
  recipients?: ?Array<string>;
  hideSelf: boolean;
  noSelfEncrypt: boolean;
  binary: boolean;
  hideRecipients: boolean;
}

export type SaltpackEncryptedMessageInfo = {
  devices?: ?Array<Device>;
  numAnonReceivers: int;
  receiverIsAnon: boolean;
  sender: SaltpackSender;
}

export type SaltpackSender = {
  uid: UID;
  username: string;
  senderType: SaltpackSenderType;
}

export type SaltpackSenderType =
    0 // NOT_TRACKED_0
  | 1 // UNKNOWN_1
  | 2 // ANONYMOUS_2
  | 3 // TRACKING_BROKE_3
  | 4 // TRACKING_OK_4
  | 5 // SELF_5

export type SaltpackSignOptions = {
  detached: boolean;
  binary: boolean;
}

export type SaltpackVerifyOptions = {
  signedBy: string;
  signature: bytes;
}

export type SearchComponent = {
  key: string;
  value: string;
  score: double;
}

export type SearchResult = {
  uid: UID;
  username: string;
  components?: ?Array<SearchComponent>;
  score: double;
}

export type SecretEntryArg = {
  desc: string;
  prompt: string;
  err: string;
  cancel: string;
  ok: string;
  reason: string;
  useSecretStore: boolean;
  showTyping: boolean;
}

export type SecretEntryRes = {
  text: string;
  canceled: boolean;
  storeSecret: boolean;
}

export type SecretKeys = {
  signing: NaclSigningKeyPrivate;
  encryption: NaclDHKeyPrivate;
}

export type SecretResponse = {
  secret: bytes;
  phrase: string;
}

export type SelectKeyRes = {
  keyID: string;
  doSecretPush: boolean;
}

export type ServiceStatus = {
  version: string;
  label: string;
  pid: string;
  lastExitStatus: string;
  bundleVersion: string;
  installStatus: InstallStatus;
  installAction: InstallAction;
  status: Status;
}

export type ServicesStatus = {
  service?: ?Array<ServiceStatus>;
  kbfs?: ?Array<ServiceStatus>;
  updater?: ?Array<ServiceStatus>;
}

export type Session = {
  uid: UID;
  username: string;
  token: string;
  deviceSubkeyKid: KID;
  deviceSibkeyKid: KID;
}

export type SessionStatus = {
  SessionFor: string;
  Loaded: boolean;
  Cleared: boolean;
  SaltOnly: boolean;
  Expired: boolean;
}

export type SessionToken = string

export type Sig = {
  seqno: int;
  sigID: SigID;
  sigIDDisplay: string;
  type: string;
  cTime: Time;
  revoked: boolean;
  active: boolean;
  key: string;
  body: string;
}

export type SigHint = {
  remoteId: string;
  humanUrl: string;
  apiUrl: string;
  checkText: string;
}

export type SigID = string

export type SigListArgs = {
  sessionID: int;
  username: string;
  allKeys: boolean;
  types?: ?SigTypes;
  filterx: string;
  verbose: boolean;
  revoked: boolean;
}

export type SigTypes = {
  track: boolean;
  proof: boolean;
  cryptocurrency: boolean;
  isSelf: boolean;
}

export type SignMode =
    0 // ATTACHED_0
  | 1 // DETACHED_1
  | 2 // CLEAR_2

export type SignupRes = {
  passphraseOk: boolean;
  postOk: boolean;
  writeOk: boolean;
}

export type SocialAssertion = {
  user: string;
  service: SocialAssertionService;
}

export type SocialAssertionService = string

export type StartProofResult = {
  sigID: SigID;
}

export type Status = {
  code: int;
  name: string;
  desc: string;
  fields?: ?Array<StringKVPair>;
}

export type StatusCode =
    0 // SCOk_0
  | 201 // SCLoginRequired_201
  | 202 // SCBadSession_202
  | 203 // SCBadLoginUserNotFound_203
  | 204 // SCBadLoginPassword_204
  | 205 // SCNotFound_205
  | 210 // SCThrottleControl_210
  | 218 // SCGeneric_218
  | 235 // SCAlreadyLoggedIn_235
  | 237 // SCCanceled_237
  | 239 // SCInputCanceled_239
  | 274 // SCReloginRequired_274
  | 275 // SCResolutionFailed_275
  | 276 // SCProfileNotPublic_276
  | 277 // SCIdentifyFailed_277
  | 278 // SCTrackingBroke_278
  | 279 // SCWrongCryptoFormat_279
  | 280 // SCDecryptionError_280
  | 701 // SCBadSignupUsernameTaken_701
  | 707 // SCBadInvitationCode_707
  | 801 // SCMissingResult_801
  | 901 // SCKeyNotFound_901
  | 907 // SCKeyInUse_907
  | 913 // SCKeyBadGen_913
  | 914 // SCKeyNoSecret_914
  | 915 // SCKeyBadUIDs_915
  | 916 // SCKeyNoActive_916
  | 917 // SCKeyNoSig_917
  | 918 // SCKeyBadSig_918
  | 919 // SCKeyBadEldest_919
  | 920 // SCKeyNoEldest_920
  | 921 // SCKeyDuplicateUpdate_921
  | 922 // SCSibkeyAlreadyExists_922
  | 924 // SCDecryptionKeyNotFound_924
  | 927 // SCKeyNoPGPEncryption_927
  | 928 // SCKeyNoNaClEncryption_928
  | 929 // SCKeySyncedPGPNotFound_929
  | 930 // SCKeyNoMatchingGPG_930
  | 931 // SCKeyRevoked_931
  | 1301 // SCBadTrackSession_1301
  | 1409 // SCDeviceNotFound_1409
  | 1410 // SCDeviceMismatch_1410
  | 1411 // SCDeviceRequired_1411
  | 1413 // SCDevicePrevProvisioned_1413
  | 1414 // SCDeviceNoProvision_1414
  | 1501 // SCStreamExists_1501
  | 1502 // SCStreamNotFound_1502
  | 1503 // SCStreamWrongKind_1503
  | 1504 // SCStreamEOF_1504
  | 1600 // SCGenericAPIError_1600
  | 1601 // SCAPINetworkError_1601
  | 1602 // SCTimeout_1602
  | 1701 // SCProofError_1701
  | 1702 // SCIdentificationExpired_1702
  | 1703 // SCSelfNotFound_1703
  | 1704 // SCBadKexPhrase_1704
  | 1705 // SCNoUIDelegation_1705
  | 1706 // SCNoUI_1706
  | 1707 // SCGPGUnavailable_1707
  | 1800 // SCInvalidVersionError_1800
  | 1801 // SCOldVersionError_1801
  | 1802 // SCInvalidLocationError_1802
  | 1803 // SCServiceStatusError_1803
  | 1804 // SCInstallError_1804

export type Stream = {
  fd: int;
}

export type StringKVPair = {
  key: string;
  value: string;
}

export type TLF = {
  id: TLFID;
  name: string;
  writers?: ?Array<string>;
  readers?: ?Array<string>;
  isPrivate: boolean;
}

export type TLFID = string

export type Test = {
  reply: string;
}

export type Text = {
  data: string;
  markup: boolean;
}

export type Time = long

export type TrackDiff = {
  type: TrackDiffType;
  displayMarkup: string;
}

export type TrackDiffType =
    0 // NONE_0
  | 1 // ERROR_1
  | 2 // CLASH_2
  | 3 // REVOKED_3
  | 4 // UPGRADED_4
  | 5 // NEW_5
  | 6 // REMOTE_FAIL_6
  | 7 // REMOTE_WORKING_7
  | 8 // REMOTE_CHANGED_8
  | 9 // NEW_ELDEST_9
  | 10 // NONE_VIA_TEMPORARY_10

export type TrackOptions = {
  localOnly: boolean;
  bypassConfirm: boolean;
  forceRetrack: boolean;
  expiringLocal: boolean;
}

export type TrackProof = {
  proofType: string;
  proofName: string;
  idString: string;
}

export type TrackStatus =
    1 // NEW_OK_1
  | 2 // NEW_ZERO_PROOFS_2
  | 3 // NEW_FAIL_PROOFS_3
  | 4 // UPDATE_BROKEN_FAILED_PROOFS_4
  | 5 // UPDATE_NEW_PROOFS_5
  | 6 // UPDATE_OK_6
  | 7 // UPDATE_BROKEN_REVOKED_7

export type TrackSummary = {
  username: string;
  time: Time;
  isRemote: boolean;
}

export type TrackToken = string

export type Tracker = {
  tracker: UID;
  status: int;
  mTime: Time;
}

export type UID = string

export type UnboxAnyRes = {
  kid: KID;
  plaintext: Bytes32;
  index: int;
}

export type UninstallResult = {
  componentResults?: ?Array<ComponentResult>;
  status: Status;
}

export type User = {
  uid: UID;
  username: string;
}

export type UserCard = {
  following: int;
  followers: int;
  uid: UID;
  fullName: string;
  location: string;
  bio: string;
  website: string;
  twitter: string;
  youFollowThem: boolean;
  theyFollowYou: boolean;
}

export type UserPlusKeys = {
  uid: UID;
  username: string;
  deviceKeys?: ?Array<PublicKey>;
  revokedDeviceKeys?: ?Array<RevokedKey>;
  pgpKeyCount: int;
  uvv: UserVersionVector;
}

export type UserResolution = {
  assertion: SocialAssertion;
  userID: UID;
}

export type UserSummary = {
  uid: UID;
  username: string;
  thumbnail: string;
  idVersion: int;
  fullName: string;
  bio: string;
  proofs: Proofs;
  sigIDDisplay: string;
  trackTime: Time;
}

export type UserSummary2 = {
  uid: UID;
  username: string;
  thumbnail: string;
  fullName: string;
  isFollower: bool;
  isFollowee: bool;
}

export type UserSummary2Set = {
  users?: ?Array<UserSummary2>;
  time: Time;
  version: int;
}

export type UserVersionVector = {
  id: long;
  sigHints: int;
  sigChain: long;
  cachedAt: Time;
  lastIdentifiedAt: Time;
}

export type VerifySessionRes = {
  uid: UID;
  sid: string;
  generated: int;
  lifetime: int;
}

export type WebProof = {
  hostname: string;
  protocols?: ?Array<string>;
}

export type accountPassphraseChangeRpcParam = $Exact<{
  oldPassphrase: string,
  passphrase: string,
  force: boolean
}>

export function accountPassphraseChangeRpc (request: $Exact<{
  param: accountPassphraseChangeRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'account.passphraseChange'})
}
export type accountPassphrasePromptRpcParam = $Exact<{
  guiArg: GUIEntryArg
}>

type accountPassphrasePromptResult = GetPassphraseRes

export function accountPassphrasePromptRpc (request: $Exact<{
  param: accountPassphrasePromptRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: accountPassphrasePromptResult) => void)}>) {
  engine.rpc({...request, method: 'account.passphrasePrompt'})
}
export type apiserverGetRpcParam = $Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

type apiserverGetResult = APIRes

export function apiserverGetRpc (request: $Exact<{
  param: apiserverGetRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: apiserverGetResult) => void)}>) {
  engine.rpc({...request, method: 'apiserver.Get'})
}
export type apiserverPostJSONRpcParam = $Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  JSONPayload?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

type apiserverPostJSONResult = APIRes

export function apiserverPostJSONRpc (request: $Exact<{
  param: apiserverPostJSONRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: apiserverPostJSONResult) => void)}>) {
  engine.rpc({...request, method: 'apiserver.PostJSON'})
}
export type apiserverPostRpcParam = $Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

type apiserverPostResult = APIRes

export function apiserverPostRpc (request: $Exact<{
  param: apiserverPostRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: apiserverPostResult) => void)}>) {
  engine.rpc({...request, method: 'apiserver.Post'})
}
export type blockAddReferenceRpcParam = $Exact<{
  folder: string,
  ref: BlockReference
}>

export function blockAddReferenceRpc (request: $Exact<{
  param: blockAddReferenceRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'block.addReference'})
}
export type blockArchiveReferenceRpcParam = $Exact<{
  folder: string,
  refs?: ?Array<BlockReference>
}>

type blockArchiveReferenceResult = ?Array<BlockReference>

export function blockArchiveReferenceRpc (request: $Exact<{
  param: blockArchiveReferenceRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: blockArchiveReferenceResult) => void)}>) {
  engine.rpc({...request, method: 'block.archiveReference'})
}
export type blockArchiveReferenceWithCountRpcParam = $Exact<{
  folder: string,
  refs?: ?Array<BlockReference>
}>

type blockArchiveReferenceWithCountResult = DowngradeReferenceRes

export function blockArchiveReferenceWithCountRpc (request: $Exact<{
  param: blockArchiveReferenceWithCountRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: blockArchiveReferenceWithCountResult) => void)}>) {
  engine.rpc({...request, method: 'block.archiveReferenceWithCount'})
}
export type blockAuthenticateSessionRpcParam = $Exact<{
  signature: string
}>

export function blockAuthenticateSessionRpc (request: $Exact<{
  param: blockAuthenticateSessionRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'block.authenticateSession'})
}
export type blockDelReferenceRpcParam = $Exact<{
  folder: string,
  ref: BlockReference
}>

export function blockDelReferenceRpc (request: $Exact<{
  param: blockDelReferenceRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'block.delReference'})
}
export type blockDelReferenceWithCountRpcParam = $Exact<{
  folder: string,
  refs?: ?Array<BlockReference>
}>

type blockDelReferenceWithCountResult = DowngradeReferenceRes

export function blockDelReferenceWithCountRpc (request: $Exact<{
  param: blockDelReferenceWithCountRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: blockDelReferenceWithCountResult) => void)}>) {
  engine.rpc({...request, method: 'block.delReferenceWithCount'})
}
export type blockGetBlockRpcParam = $Exact<{
  bid: BlockIdCombo,
  folder: string
}>

type blockGetBlockResult = GetBlockRes

export function blockGetBlockRpc (request: $Exact<{
  param: blockGetBlockRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: blockGetBlockResult) => void)}>) {
  engine.rpc({...request, method: 'block.getBlock'})
}
export type blockPutBlockRpcParam = $Exact<{
  bid: BlockIdCombo,
  folder: string,
  blockKey: string,
  buf: bytes
}>

export function blockPutBlockRpc (request: $Exact<{
  param: blockPutBlockRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'block.putBlock'})
}
export type configClearValueRpcParam = $Exact<{
  path: string
}>

export function configClearValueRpc (request: $Exact<{
  param: configClearValueRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'config.clearValue'})
}
export type configGetValueRpcParam = $Exact<{
  path: string
}>

type configGetValueResult = ConfigValue

export function configGetValueRpc (request: $Exact<{
  param: configGetValueRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: configGetValueResult) => void)}>) {
  engine.rpc({...request, method: 'config.getValue'})
}
export type configHelloIAmRpcParam = $Exact<{
  details: ClientDetails
}>

export function configHelloIAmRpc (request: $Exact<{
  param: configHelloIAmRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'config.helloIAm'})
}
export type configSetPathRpcParam = $Exact<{
  path: string
}>

export function configSetPathRpc (request: $Exact<{
  param: configSetPathRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'config.setPath'})
}
export type configSetUserConfigRpcParam = $Exact<{
  username: string,
  key: string,
  value: string
}>

export function configSetUserConfigRpc (request: $Exact<{
  param: configSetUserConfigRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'config.setUserConfig'})
}
export type configSetValueRpcParam = $Exact<{
  path: string,
  value: ConfigValue
}>

export function configSetValueRpc (request: $Exact<{
  param: configSetValueRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'config.setValue'})
}
export type cryptoSignED25519RpcParam = $Exact<{
  msg: bytes,
  reason: string
}>

type cryptoSignED25519Result = ED25519SignatureInfo

export function cryptoSignED25519Rpc (request: $Exact<{
  param: cryptoSignED25519RpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: cryptoSignED25519Result) => void)}>) {
  engine.rpc({...request, method: 'crypto.signED25519'})
}
export type cryptoSignToStringRpcParam = $Exact<{
  msg: bytes,
  reason: string
}>

type cryptoSignToStringResult = string

export function cryptoSignToStringRpc (request: $Exact<{
  param: cryptoSignToStringRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: cryptoSignToStringResult) => void)}>) {
  engine.rpc({...request, method: 'crypto.signToString'})
}
export type cryptoUnboxBytes32AnyRpcParam = $Exact<{
  bundles?: ?Array<CiphertextBundle>,
  reason: string,
  promptPaper: boolean
}>

type cryptoUnboxBytes32AnyResult = UnboxAnyRes

export function cryptoUnboxBytes32AnyRpc (request: $Exact<{
  param: cryptoUnboxBytes32AnyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: cryptoUnboxBytes32AnyResult) => void)}>) {
  engine.rpc({...request, method: 'crypto.unboxBytes32Any'})
}
export type cryptoUnboxBytes32RpcParam = $Exact<{
  encryptedBytes32: EncryptedBytes32,
  nonce: BoxNonce,
  peersPublicKey: BoxPublicKey,
  reason: string
}>

type cryptoUnboxBytes32Result = Bytes32

export function cryptoUnboxBytes32Rpc (request: $Exact<{
  param: cryptoUnboxBytes32RpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: cryptoUnboxBytes32Result) => void)}>) {
  engine.rpc({...request, method: 'crypto.unboxBytes32'})
}
export type ctlStopRpcParam = $Exact<{
  exitCode: ExitCode
}>

export function ctlStopRpc (request: $Exact<{
  param: ctlStopRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'ctl.stop'})
}
export type debuggingFirstStepRpcParam = $Exact<{
  val: int
}>

type debuggingFirstStepResult = FirstStepResult

export function debuggingFirstStepRpc (request: $Exact<{
  param: debuggingFirstStepRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: debuggingFirstStepResult) => void)}>) {
  engine.rpc({...request, method: 'debugging.firstStep'})
}
export type debuggingIncrementRpcParam = $Exact<{
  val: int
}>

type debuggingIncrementResult = int

export function debuggingIncrementRpc (request: $Exact<{
  param: debuggingIncrementRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: debuggingIncrementResult) => void)}>) {
  engine.rpc({...request, method: 'debugging.increment'})
}
export type debuggingSecondStepRpcParam = $Exact<{
  val: int
}>

type debuggingSecondStepResult = int

export function debuggingSecondStepRpc (request: $Exact<{
  param: debuggingSecondStepRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: debuggingSecondStepResult) => void)}>) {
  engine.rpc({...request, method: 'debugging.secondStep'})
}
export type deviceCheckDeviceNameFormatRpcParam = $Exact<{
  name: string
}>

type deviceCheckDeviceNameFormatResult = boolean

export function deviceCheckDeviceNameFormatRpc (request: $Exact<{
  param: deviceCheckDeviceNameFormatRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: deviceCheckDeviceNameFormatResult) => void)}>) {
  engine.rpc({...request, method: 'device.checkDeviceNameFormat'})
}
export type favoriteFavoriteAddRpcParam = $Exact<{
  folder: Folder
}>

export function favoriteFavoriteAddRpc (request: $Exact<{
  param: favoriteFavoriteAddRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'favorite.favoriteAdd'})
}
export type favoriteFavoriteIgnoreRpcParam = $Exact<{
  folder: Folder
}>

export function favoriteFavoriteIgnoreRpc (request: $Exact<{
  param: favoriteFavoriteIgnoreRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'favorite.favoriteIgnore'})
}
export type fsListRpcParam = $Exact<{
  path: string
}>

type fsListResult = ListResult

export function fsListRpc (request: $Exact<{
  param: fsListRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: fsListResult) => void)}>) {
  engine.rpc({...request, method: 'fs.List'})
}
export type gpgUiSelectKeyAndPushOptionRpcParam = $Exact<{
  keys?: ?Array<GPGKey>
}>

type gpgUiSelectKeyAndPushOptionResult = SelectKeyRes

export function gpgUiSelectKeyAndPushOptionRpc (request: $Exact<{
  param: gpgUiSelectKeyAndPushOptionRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: gpgUiSelectKeyAndPushOptionResult) => void)}>) {
  engine.rpc({...request, method: 'gpgUi.selectKeyAndPushOption'})
}
export type gpgUiSelectKeyRpcParam = $Exact<{
  keys?: ?Array<GPGKey>
}>

type gpgUiSelectKeyResult = string

export function gpgUiSelectKeyRpc (request: $Exact<{
  param: gpgUiSelectKeyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: gpgUiSelectKeyResult) => void)}>) {
  engine.rpc({...request, method: 'gpgUi.selectKey'})
}
export type gpgUiSignRpcParam = $Exact<{
  msg: bytes,
  fingerprint: bytes
}>

type gpgUiSignResult = string

export function gpgUiSignRpc (request: $Exact<{
  param: gpgUiSignRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: gpgUiSignResult) => void)}>) {
  engine.rpc({...request, method: 'gpgUi.sign'})
}
export type gregorUIPushOutOfBandMessagesRpcParam = $Exact<{
  oobm?: ?Array<gregor1.OutOfBandMessage>
}>

export function gregorUIPushOutOfBandMessagesRpc (request: $Exact<{
  param: gregorUIPushOutOfBandMessagesRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'gregorUI.pushOutOfBandMessages'})
}
export type gregorUIPushStateRpcParam = $Exact<{
  state: gregor1.State,
  reason: PushReason
}>

export function gregorUIPushStateRpc (request: $Exact<{
  param: gregorUIPushStateRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'gregorUI.pushState'})
}
export type identifyIdentify2RpcParam = $Exact<{
  uid: UID,
  userAssertion: string,
  reason: IdentifyReason,
  useDelegateUI?: boolean,
  alwaysBlock?: boolean,
  noErrorOnTrackFailure?: boolean,
  forceRemoteCheck?: boolean,
  needProofSet?: boolean,
  allowEmptySelfID?: boolean,
  noSkipSelf?: boolean
}>

type identifyIdentify2Result = Identify2Res

export function identifyIdentify2Rpc (request: $Exact<{
  param: identifyIdentify2RpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: identifyIdentify2Result) => void)}>) {
  engine.rpc({...request, method: 'identify.identify2'})
}
export type identifyIdentifyRpcParam = $Exact<{
  userAssertion: string,
  forceRemoteCheck?: boolean,
  useDelegateUI?: boolean,
  reason: IdentifyReason,
  source: ClientType
}>

type identifyIdentifyResult = IdentifyRes

export function identifyIdentifyRpc (request: $Exact<{
  param: identifyIdentifyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: identifyIdentifyResult) => void)}>) {
  engine.rpc({...request, method: 'identify.identify'})
}
export type identifyResolve2RpcParam = $Exact<{
  assertion: string
}>

type identifyResolve2Result = User

export function identifyResolve2Rpc (request: $Exact<{
  param: identifyResolve2RpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: identifyResolve2Result) => void)}>) {
  engine.rpc({...request, method: 'identify.Resolve2'})
}
export type identifyResolveRpcParam = $Exact<{
  assertion: string
}>

type identifyResolveResult = UID

export function identifyResolveRpc (request: $Exact<{
  param: identifyResolveRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: identifyResolveResult) => void)}>) {
  engine.rpc({...request, method: 'identify.Resolve'})
}
export type identifyUiConfirmRpcParam = $Exact<{
  outcome: IdentifyOutcome
}>

type identifyUiConfirmResult = ConfirmResult

export function identifyUiConfirmRpc (request: $Exact<{
  param: identifyUiConfirmRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: identifyUiConfirmResult) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.confirm'})
}
export type identifyUiDismissRpcParam = $Exact<{
  username: string,
  reason: DismissReason
}>

export function identifyUiDismissRpc (request: $Exact<{
  param: identifyUiDismissRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.dismiss'})
}
export type identifyUiDisplayCryptocurrencyRpcParam = $Exact<{
  c: Cryptocurrency
}>

export function identifyUiDisplayCryptocurrencyRpc (request: $Exact<{
  param: identifyUiDisplayCryptocurrencyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.displayCryptocurrency'})
}
export type identifyUiDisplayKeyRpcParam = $Exact<{
  key: IdentifyKey
}>

export function identifyUiDisplayKeyRpc (request: $Exact<{
  param: identifyUiDisplayKeyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.displayKey'})
}
export type identifyUiDisplayTLFCreateWithInviteRpcParam = $Exact<{
  folderName: string,
  isPrivate: boolean,
  assertion: string,
  socialAssertion: SocialAssertion,
  inviteLink: string,
  throttled: boolean
}>

export function identifyUiDisplayTLFCreateWithInviteRpc (request: $Exact<{
  param: identifyUiDisplayTLFCreateWithInviteRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.displayTLFCreateWithInvite'})
}
export type identifyUiDisplayTrackStatementRpcParam = $Exact<{
  stmt: string
}>

export function identifyUiDisplayTrackStatementRpc (request: $Exact<{
  param: identifyUiDisplayTrackStatementRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.displayTrackStatement'})
}
export type identifyUiDisplayUserCardRpcParam = $Exact<{
  card: UserCard
}>

export function identifyUiDisplayUserCardRpc (request: $Exact<{
  param: identifyUiDisplayUserCardRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.displayUserCard'})
}
export type identifyUiFinishSocialProofCheckRpcParam = $Exact<{
  rp: RemoteProof,
  lcr: LinkCheckResult
}>

export function identifyUiFinishSocialProofCheckRpc (request: $Exact<{
  param: identifyUiFinishSocialProofCheckRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.finishSocialProofCheck'})
}
export type identifyUiFinishWebProofCheckRpcParam = $Exact<{
  rp: RemoteProof,
  lcr: LinkCheckResult
}>

export function identifyUiFinishWebProofCheckRpc (request: $Exact<{
  param: identifyUiFinishWebProofCheckRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.finishWebProofCheck'})
}
export type identifyUiLaunchNetworkChecksRpcParam = $Exact<{
  identity: Identity,
  user: User
}>

export function identifyUiLaunchNetworkChecksRpc (request: $Exact<{
  param: identifyUiLaunchNetworkChecksRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.launchNetworkChecks'})
}
export type identifyUiReportLastTrackRpcParam = $Exact<{
  track: (null | TrackSummary)
}>

export function identifyUiReportLastTrackRpc (request: $Exact<{
  param: identifyUiReportLastTrackRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.reportLastTrack'})
}
export type identifyUiReportTrackTokenRpcParam = $Exact<{
  trackToken: TrackToken
}>

export function identifyUiReportTrackTokenRpc (request: $Exact<{
  param: identifyUiReportTrackTokenRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.reportTrackToken'})
}
export type identifyUiStartRpcParam = $Exact<{
  username: string,
  reason: IdentifyReason
}>

export function identifyUiStartRpc (request: $Exact<{
  param: identifyUiStartRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.start'})
}
export type kbfsFSEventRpcParam = $Exact<{
  event: FSNotification
}>

export function kbfsFSEventRpc (request: $Exact<{
  param: kbfsFSEventRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'kbfs.FSEvent'})
}
export type logRegisterLoggerRpcParam = $Exact<{
  name: string,
  level: LogLevel
}>

export function logRegisterLoggerRpc (request: $Exact<{
  param: logRegisterLoggerRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'log.registerLogger'})
}
export type logUiLogRpcParam = $Exact<{
  level: LogLevel,
  text: Text
}>

export function logUiLogRpc (request: $Exact<{
  param: logUiLogRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'logUi.log'})
}
export type loginClearStoredSecretRpcParam = $Exact<{
  username: string
}>

export function loginClearStoredSecretRpc (request: $Exact<{
  param: loginClearStoredSecretRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.clearStoredSecret'})
}
export type loginDeprovisionRpcParam = $Exact<{
  username: string,
  doRevoke: boolean
}>

export function loginDeprovisionRpc (request: $Exact<{
  param: loginDeprovisionRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.deprovision'})
}
export type loginLoginRpcParam = $Exact<{
  deviceType: string,
  usernameOrEmail: string,
  clientType: ClientType
}>

export function loginLoginRpc (request: $Exact<{
  param: loginLoginRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.login'})
}
export type loginPaperKeySubmitRpcParam = $Exact<{
  paperPhrase: string
}>

export function loginPaperKeySubmitRpc (request: $Exact<{
  param: loginPaperKeySubmitRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.paperKeySubmit'})
}
export type loginPgpProvisionRpcParam = $Exact<{
  username: string,
  passphrase: string,
  deviceName: string
}>

export function loginPgpProvisionRpc (request: $Exact<{
  param: loginPgpProvisionRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.pgpProvision'})
}
export type loginRecoverAccountFromEmailAddressRpcParam = $Exact<{
  email: string
}>

export function loginRecoverAccountFromEmailAddressRpc (request: $Exact<{
  param: loginRecoverAccountFromEmailAddressRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.recoverAccountFromEmailAddress'})
}
export type loginUiDisplayPaperKeyPhraseRpcParam = $Exact<{
  phrase: string
}>

export function loginUiDisplayPaperKeyPhraseRpc (request: $Exact<{
  param: loginUiDisplayPaperKeyPhraseRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'loginUi.displayPaperKeyPhrase'})
}
export type loginUiDisplayPrimaryPaperKeyRpcParam = $Exact<{
  phrase: string
}>

export function loginUiDisplayPrimaryPaperKeyRpc (request: $Exact<{
  param: loginUiDisplayPrimaryPaperKeyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'loginUi.displayPrimaryPaperKey'})
}
export type loginUiPromptRevokePaperKeysRpcParam = $Exact<{
  device: Device,
  index: int
}>

type loginUiPromptRevokePaperKeysResult = boolean

export function loginUiPromptRevokePaperKeysRpc (request: $Exact<{
  param: loginUiPromptRevokePaperKeysRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: loginUiPromptRevokePaperKeysResult) => void)}>) {
  engine.rpc({...request, method: 'loginUi.promptRevokePaperKeys'})
}
export type loginUnlockWithPassphraseRpcParam = $Exact<{
  passphrase: string
}>

export function loginUnlockWithPassphraseRpc (request: $Exact<{
  param: loginUnlockWithPassphraseRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'login.unlockWithPassphrase'})
}
export type metadataAuthenticateRpcParam = $Exact<{
  signature: string
}>

type metadataAuthenticateResult = int

export function metadataAuthenticateRpc (request: $Exact<{
  param: metadataAuthenticateRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataAuthenticateResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.authenticate'})
}
export type metadataDeleteKeyRpcParam = $Exact<{
  uid: UID,
  deviceKID: KID,
  keyHalfID: bytes,
  logTags: {[key: string]: string}
}>

export function metadataDeleteKeyRpc (request: $Exact<{
  param: metadataDeleteKeyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'metadata.deleteKey'})
}
export type metadataGetFolderHandleRpcParam = $Exact<{
  folderID: string,
  signature: string,
  challenge: string
}>

type metadataGetFolderHandleResult = bytes

export function metadataGetFolderHandleRpc (request: $Exact<{
  param: metadataGetFolderHandleRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataGetFolderHandleResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.getFolderHandle'})
}
export type metadataGetFoldersForRekeyRpcParam = $Exact<{
  deviceKID: KID
}>

export function metadataGetFoldersForRekeyRpc (request: $Exact<{
  param: metadataGetFoldersForRekeyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'metadata.getFoldersForRekey'})
}
export type metadataGetKeyRpcParam = $Exact<{
  keyHalfID: bytes,
  deviceKID: string,
  logTags: {[key: string]: string}
}>

type metadataGetKeyResult = bytes

export function metadataGetKeyRpc (request: $Exact<{
  param: metadataGetKeyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataGetKeyResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.getKey'})
}
export type metadataGetLatestFolderHandleRpcParam = $Exact<{
  folderID: string
}>

type metadataGetLatestFolderHandleResult = bytes

export function metadataGetLatestFolderHandleRpc (request: $Exact<{
  param: metadataGetLatestFolderHandleRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataGetLatestFolderHandleResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.getLatestFolderHandle'})
}
export type metadataGetMerkleNodeRpcParam = $Exact<{
  hash: string
}>

type metadataGetMerkleNodeResult = bytes

export function metadataGetMerkleNodeRpc (request: $Exact<{
  param: metadataGetMerkleNodeRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataGetMerkleNodeResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.getMerkleNode'})
}
export type metadataGetMerkleRootLatestRpcParam = $Exact<{
  treeID: MerkleTreeID
}>

type metadataGetMerkleRootLatestResult = MerkleRoot

export function metadataGetMerkleRootLatestRpc (request: $Exact<{
  param: metadataGetMerkleRootLatestRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataGetMerkleRootLatestResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.getMerkleRootLatest'})
}
export type metadataGetMerkleRootRpcParam = $Exact<{
  treeID: MerkleTreeID,
  seqNo: long
}>

type metadataGetMerkleRootResult = MerkleRoot

export function metadataGetMerkleRootRpc (request: $Exact<{
  param: metadataGetMerkleRootRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataGetMerkleRootResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.getMerkleRoot'})
}
export type metadataGetMerkleRootSinceRpcParam = $Exact<{
  treeID: MerkleTreeID,
  when: Time
}>

type metadataGetMerkleRootSinceResult = MerkleRoot

export function metadataGetMerkleRootSinceRpc (request: $Exact<{
  param: metadataGetMerkleRootSinceRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataGetMerkleRootSinceResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.getMerkleRootSince'})
}
export type metadataGetMetadataRpcParam = $Exact<{
  folderID: string,
  folderHandle: bytes,
  branchID: string,
  unmerged: boolean,
  startRevision: long,
  stopRevision: long,
  logTags: {[key: string]: string}
}>

type metadataGetMetadataResult = MetadataResponse

export function metadataGetMetadataRpc (request: $Exact<{
  param: metadataGetMetadataRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataGetMetadataResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.getMetadata'})
}
export type metadataPruneBranchRpcParam = $Exact<{
  folderID: string,
  branchID: string,
  logTags: {[key: string]: string}
}>

export function metadataPruneBranchRpc (request: $Exact<{
  param: metadataPruneBranchRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'metadata.pruneBranch'})
}
export type metadataPutKeysRpcParam = $Exact<{
  keyHalves?: ?Array<KeyHalf>,
  logTags: {[key: string]: string}
}>

export function metadataPutKeysRpc (request: $Exact<{
  param: metadataPutKeysRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'metadata.putKeys'})
}
export type metadataPutMetadataRpcParam = $Exact<{
  mdBlock: MDBlock,
  logTags: {[key: string]: string}
}>

export function metadataPutMetadataRpc (request: $Exact<{
  param: metadataPutMetadataRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'metadata.putMetadata'})
}
export type metadataRegisterForUpdatesRpcParam = $Exact<{
  folderID: string,
  currRevision: long,
  logTags: {[key: string]: string}
}>

export function metadataRegisterForUpdatesRpc (request: $Exact<{
  param: metadataRegisterForUpdatesRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'metadata.registerForUpdates'})
}
export type metadataTruncateLockRpcParam = $Exact<{
  folderID: string
}>

type metadataTruncateLockResult = boolean

export function metadataTruncateLockRpc (request: $Exact<{
  param: metadataTruncateLockRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataTruncateLockResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.truncateLock'})
}
export type metadataTruncateUnlockRpcParam = $Exact<{
  folderID: string
}>

type metadataTruncateUnlockResult = boolean

export function metadataTruncateUnlockRpc (request: $Exact<{
  param: metadataTruncateUnlockRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataTruncateUnlockResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.truncateUnlock'})
}
export type metadataUpdateFolderNeedsRekeyRpcParam = $Exact<{
  folderID: string,
  revision: long
}>

export function metadataUpdateFolderNeedsRekeyRpc (request: $Exact<{
  param: metadataUpdateFolderNeedsRekeyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'metadataUpdate.folderNeedsRekey'})
}
export type metadataUpdateMetadataUpdateRpcParam = $Exact<{
  folderID: string,
  revision: long
}>

export function metadataUpdateMetadataUpdateRpc (request: $Exact<{
  param: metadataUpdateMetadataUpdateRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'metadataUpdate.metadataUpdate'})
}
export type notifyCtlSetNotificationsRpcParam = $Exact<{
  channels: NotificationChannels
}>

export function notifyCtlSetNotificationsRpc (request: $Exact<{
  param: notifyCtlSetNotificationsRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'notifyCtl.setNotifications'})
}
export type paperprovisionPaperProvisionRpcParam = $Exact<{
  username: string,
  deviceName: string,
  paperKey: string
}>

export function paperprovisionPaperProvisionRpc (request: $Exact<{
  param: paperprovisionPaperProvisionRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'paperprovision.paperProvision'})
}
export type pgpPgpDecryptRpcParam = $Exact<{
  source: Stream,
  sink: Stream,
  opts: PGPDecryptOptions
}>

type pgpPgpDecryptResult = PGPSigVerification

export function pgpPgpDecryptRpc (request: $Exact<{
  param: pgpPgpDecryptRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: pgpPgpDecryptResult) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpDecrypt'})
}
export type pgpPgpEncryptRpcParam = $Exact<{
  source: Stream,
  sink: Stream,
  opts: PGPEncryptOptions
}>

export function pgpPgpEncryptRpc (request: $Exact<{
  param: pgpPgpEncryptRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpEncrypt'})
}
export type pgpPgpExportByFingerprintRpcParam = $Exact<{
  options: PGPQuery
}>

type pgpPgpExportByFingerprintResult = ?Array<KeyInfo>

export function pgpPgpExportByFingerprintRpc (request: $Exact<{
  param: pgpPgpExportByFingerprintRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: pgpPgpExportByFingerprintResult) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpExportByFingerprint'})
}
export type pgpPgpExportByKIDRpcParam = $Exact<{
  options: PGPQuery
}>

type pgpPgpExportByKIDResult = ?Array<KeyInfo>

export function pgpPgpExportByKIDRpc (request: $Exact<{
  param: pgpPgpExportByKIDRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: pgpPgpExportByKIDResult) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpExportByKID'})
}
export type pgpPgpExportRpcParam = $Exact<{
  options: PGPQuery
}>

type pgpPgpExportResult = ?Array<KeyInfo>

export function pgpPgpExportRpc (request: $Exact<{
  param: pgpPgpExportRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: pgpPgpExportResult) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpExport'})
}
export type pgpPgpImportRpcParam = $Exact<{
  key: bytes,
  pushSecret: boolean
}>

export function pgpPgpImportRpc (request: $Exact<{
  param: pgpPgpImportRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpImport'})
}
export type pgpPgpKeyGenRpcParam = $Exact<{
  primaryBits: int,
  subkeyBits: int,
  createUids: PGPCreateUids,
  allowMulti: boolean,
  doExport: boolean,
  pushSecret: boolean
}>

export function pgpPgpKeyGenRpc (request: $Exact<{
  param: pgpPgpKeyGenRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpKeyGen'})
}
export type pgpPgpPullRpcParam = $Exact<{
  userAsserts?: ?Array<string>
}>

export function pgpPgpPullRpc (request: $Exact<{
  param: pgpPgpPullRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpPull'})
}
export type pgpPgpSelectRpcParam = $Exact<{
  fingerprintQuery: string,
  allowMulti: boolean,
  skipImport: boolean,
  onlyImport: boolean
}>

export function pgpPgpSelectRpc (request: $Exact<{
  param: pgpPgpSelectRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpSelect'})
}
export type pgpPgpSignRpcParam = $Exact<{
  source: Stream,
  sink: Stream,
  opts: PGPSignOptions
}>

export function pgpPgpSignRpc (request: $Exact<{
  param: pgpPgpSignRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpSign'})
}
export type pgpPgpUpdateRpcParam = $Exact<{
  all: boolean,
  fingerprints?: ?Array<string>
}>

export function pgpPgpUpdateRpc (request: $Exact<{
  param: pgpPgpUpdateRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpUpdate'})
}
export type pgpPgpVerifyRpcParam = $Exact<{
  source: Stream,
  opts: PGPVerifyOptions
}>

type pgpPgpVerifyResult = PGPSigVerification

export function pgpPgpVerifyRpc (request: $Exact<{
  param: pgpPgpVerifyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: pgpPgpVerifyResult) => void)}>) {
  engine.rpc({...request, method: 'pgp.pgpVerify'})
}
export type pgpUiOutputSignatureSuccessRpcParam = $Exact<{
  fingerprint: string,
  username: string,
  signedAt: Time
}>

export function pgpUiOutputSignatureSuccessRpc (request: $Exact<{
  param: pgpUiOutputSignatureSuccessRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'pgpUi.outputSignatureSuccess'})
}
export type proveCheckProofRpcParam = $Exact<{
  sigID: SigID
}>

type proveCheckProofResult = CheckProofStatus

export function proveCheckProofRpc (request: $Exact<{
  param: proveCheckProofRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: proveCheckProofResult) => void)}>) {
  engine.rpc({...request, method: 'prove.checkProof'})
}
export type proveStartProofRpcParam = $Exact<{
  service: string,
  username: string,
  force: boolean,
  promptPosted: boolean,
  auto: boolean
}>

type proveStartProofResult = StartProofResult

export function proveStartProofRpc (request: $Exact<{
  param: proveStartProofRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: proveStartProofResult) => void)}>) {
  engine.rpc({...request, method: 'prove.startProof'})
}
export type proveUiDisplayRecheckWarningRpcParam = $Exact<{
  text: Text
}>

export function proveUiDisplayRecheckWarningRpc (request: $Exact<{
  param: proveUiDisplayRecheckWarningRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'proveUi.displayRecheckWarning'})
}
export type proveUiOkToCheckRpcParam = $Exact<{
  name: string,
  attempt: int
}>

type proveUiOkToCheckResult = boolean

export function proveUiOkToCheckRpc (request: $Exact<{
  param: proveUiOkToCheckRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: proveUiOkToCheckResult) => void)}>) {
  engine.rpc({...request, method: 'proveUi.okToCheck'})
}
export type proveUiOutputInstructionsRpcParam = $Exact<{
  instructions: Text,
  proof: string
}>

export function proveUiOutputInstructionsRpc (request: $Exact<{
  param: proveUiOutputInstructionsRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'proveUi.outputInstructions'})
}
export type proveUiOutputPrechecksRpcParam = $Exact<{
  text: Text
}>

export function proveUiOutputPrechecksRpc (request: $Exact<{
  param: proveUiOutputPrechecksRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'proveUi.outputPrechecks'})
}
export type proveUiPreProofWarningRpcParam = $Exact<{
  text: Text
}>

type proveUiPreProofWarningResult = boolean

export function proveUiPreProofWarningRpc (request: $Exact<{
  param: proveUiPreProofWarningRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: proveUiPreProofWarningResult) => void)}>) {
  engine.rpc({...request, method: 'proveUi.preProofWarning'})
}
export type proveUiPromptOverwriteRpcParam = $Exact<{
  account: string,
  typ: PromptOverwriteType
}>

type proveUiPromptOverwriteResult = boolean

export function proveUiPromptOverwriteRpc (request: $Exact<{
  param: proveUiPromptOverwriteRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: proveUiPromptOverwriteResult) => void)}>) {
  engine.rpc({...request, method: 'proveUi.promptOverwrite'})
}
export type proveUiPromptUsernameRpcParam = $Exact<{
  prompt: string,
  prevError: (null | Status)
}>

type proveUiPromptUsernameResult = string

export function proveUiPromptUsernameRpc (request: $Exact<{
  param: proveUiPromptUsernameRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: proveUiPromptUsernameResult) => void)}>) {
  engine.rpc({...request, method: 'proveUi.promptUsername'})
}
export type provisionUiChooseDeviceRpcParam = $Exact<{
  devices?: ?Array<Device>
}>

type provisionUiChooseDeviceResult = DeviceID

export function provisionUiChooseDeviceRpc (request: $Exact<{
  param: provisionUiChooseDeviceRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: provisionUiChooseDeviceResult) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.chooseDevice'})
}
export type provisionUiChooseDeviceTypeRpcParam = $Exact<{
  kind: ChooseType
}>

type provisionUiChooseDeviceTypeResult = DeviceType

export function provisionUiChooseDeviceTypeRpc (request: $Exact<{
  param: provisionUiChooseDeviceTypeRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: provisionUiChooseDeviceTypeResult) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.chooseDeviceType'})
}
export type provisionUiChooseGPGMethodRpcParam = $Exact<{
  keys?: ?Array<GPGKey>
}>

type provisionUiChooseGPGMethodResult = GPGMethod

export function provisionUiChooseGPGMethodRpc (request: $Exact<{
  param: provisionUiChooseGPGMethodRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: provisionUiChooseGPGMethodResult) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.chooseGPGMethod'})
}
export type provisionUiChooseProvisioningMethodRpcParam = $Exact<{
  gpgOption: boolean
}>

type provisionUiChooseProvisioningMethodResult = ProvisionMethod

export function provisionUiChooseProvisioningMethodRpc (request: $Exact<{
  param: provisionUiChooseProvisioningMethodRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: provisionUiChooseProvisioningMethodResult) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.chooseProvisioningMethod'})
}
export type provisionUiDisplayAndPromptSecretRpcParam = $Exact<{
  secret: bytes,
  phrase: string,
  otherDeviceType: DeviceType
}>

type provisionUiDisplayAndPromptSecretResult = SecretResponse

export function provisionUiDisplayAndPromptSecretRpc (request: $Exact<{
  param: provisionUiDisplayAndPromptSecretRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: provisionUiDisplayAndPromptSecretResult) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.DisplayAndPromptSecret'})
}
export type provisionUiPromptNewDeviceNameRpcParam = $Exact<{
  existingDevices?: ?Array<string>,
  errorMessage: string
}>

type provisionUiPromptNewDeviceNameResult = string

export function provisionUiPromptNewDeviceNameRpc (request: $Exact<{
  param: provisionUiPromptNewDeviceNameRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: provisionUiPromptNewDeviceNameResult) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.PromptNewDeviceName'})
}
export type provisionUiProvisioneeSuccessRpcParam = $Exact<{
  username: string,
  deviceName: string
}>

export function provisionUiProvisioneeSuccessRpc (request: $Exact<{
  param: provisionUiProvisioneeSuccessRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.ProvisioneeSuccess'})
}
export type provisionUiProvisionerSuccessRpcParam = $Exact<{
  deviceName: string,
  deviceType: string
}>

export function provisionUiProvisionerSuccessRpc (request: $Exact<{
  param: provisionUiProvisionerSuccessRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.ProvisionerSuccess'})
}
export type provisionUiSwitchToGPGSignOKRpcParam = $Exact<{
  key: GPGKey,
  importError: string
}>

type provisionUiSwitchToGPGSignOKResult = boolean

export function provisionUiSwitchToGPGSignOKRpc (request: $Exact<{
  param: provisionUiSwitchToGPGSignOKRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: provisionUiSwitchToGPGSignOKResult) => void)}>) {
  engine.rpc({...request, method: 'provisionUi.switchToGPGSignOK'})
}
export type quotaVerifySessionRpcParam = $Exact<{
  session: string
}>

type quotaVerifySessionResult = VerifySessionRes

export function quotaVerifySessionRpc (request: $Exact<{
  param: quotaVerifySessionRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: quotaVerifySessionResult) => void)}>) {
  engine.rpc({...request, method: 'quota.verifySession'})
}
export type rekeyUIRefreshRpcParam = $Exact<{
  problemSetDevices: ProblemSetDevices
}>

export function rekeyUIRefreshRpc (request: $Exact<{
  param: rekeyUIRefreshRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'rekeyUI.refresh'})
}
export type revokeRevokeDeviceRpcParam = $Exact<{
  deviceID: DeviceID,
  force: boolean
}>

export function revokeRevokeDeviceRpc (request: $Exact<{
  param: revokeRevokeDeviceRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'revoke.revokeDevice'})
}
export type revokeRevokeKeyRpcParam = $Exact<{
  keyID: KID
}>

export function revokeRevokeKeyRpc (request: $Exact<{
  param: revokeRevokeKeyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'revoke.revokeKey'})
}
export type revokeRevokeSigsRpcParam = $Exact<{
  sigIDQueries?: ?Array<string>
}>

export function revokeRevokeSigsRpc (request: $Exact<{
  param: revokeRevokeSigsRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'revoke.revokeSigs'})
}
export type saltpackSaltpackDecryptRpcParam = $Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackDecryptOptions
}>

type saltpackSaltpackDecryptResult = SaltpackEncryptedMessageInfo

export function saltpackSaltpackDecryptRpc (request: $Exact<{
  param: saltpackSaltpackDecryptRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: saltpackSaltpackDecryptResult) => void)}>) {
  engine.rpc({...request, method: 'saltpack.saltpackDecrypt'})
}
export type saltpackSaltpackEncryptRpcParam = $Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackEncryptOptions
}>

export function saltpackSaltpackEncryptRpc (request: $Exact<{
  param: saltpackSaltpackEncryptRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'saltpack.saltpackEncrypt'})
}
export type saltpackSaltpackSignRpcParam = $Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackSignOptions
}>

export function saltpackSaltpackSignRpc (request: $Exact<{
  param: saltpackSaltpackSignRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'saltpack.saltpackSign'})
}
export type saltpackSaltpackVerifyRpcParam = $Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackVerifyOptions
}>

export function saltpackSaltpackVerifyRpc (request: $Exact<{
  param: saltpackSaltpackVerifyRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'saltpack.saltpackVerify'})
}
export type saltpackUiSaltpackPromptForDecryptRpcParam = $Exact<{
  sender: SaltpackSender,
  usedDelegateUI: bool
}>

export function saltpackUiSaltpackPromptForDecryptRpc (request: $Exact<{
  param: saltpackUiSaltpackPromptForDecryptRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'saltpackUi.saltpackPromptForDecrypt'})
}
export type saltpackUiSaltpackVerifySuccessRpcParam = $Exact<{
  signingKID: KID,
  sender: SaltpackSender
}>

export function saltpackUiSaltpackVerifySuccessRpc (request: $Exact<{
  param: saltpackUiSaltpackVerifySuccessRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'saltpackUi.saltpackVerifySuccess'})
}
export type secretUiGetPassphraseRpcParam = $Exact<{
  pinentry: GUIEntryArg,
  terminal: (null | SecretEntryArg)
}>

type secretUiGetPassphraseResult = GetPassphraseRes

export function secretUiGetPassphraseRpc (request: $Exact<{
  param: secretUiGetPassphraseRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: secretUiGetPassphraseResult) => void)}>) {
  engine.rpc({...request, method: 'secretUi.getPassphrase'})
}
export type signupCheckInvitationCodeRpcParam = $Exact<{
  invitationCode: string
}>

export function signupCheckInvitationCodeRpc (request: $Exact<{
  param: signupCheckInvitationCodeRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'signup.checkInvitationCode'})
}
export type signupCheckUsernameAvailableRpcParam = $Exact<{
  username: string
}>

export function signupCheckUsernameAvailableRpc (request: $Exact<{
  param: signupCheckUsernameAvailableRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'signup.checkUsernameAvailable'})
}
export type signupInviteRequestRpcParam = $Exact<{
  email: string,
  fullname: string,
  notes: string
}>

export function signupInviteRequestRpc (request: $Exact<{
  param: signupInviteRequestRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'signup.inviteRequest'})
}
export type signupSignupRpcParam = $Exact<{
  email: string,
  inviteCode: string,
  passphrase: string,
  username: string,
  deviceName: string,
  storeSecret: boolean,
  skipMail: boolean,
  genPGPBatch: boolean
}>

type signupSignupResult = SignupRes

export function signupSignupRpc (request: $Exact<{
  param: signupSignupRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: signupSignupResult) => void)}>) {
  engine.rpc({...request, method: 'signup.signup'})
}
export type sigsSigListJSONRpcParam = $Exact<{
  arg: SigListArgs
}>

type sigsSigListJSONResult = string

export function sigsSigListJSONRpc (request: $Exact<{
  param: sigsSigListJSONRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: sigsSigListJSONResult) => void)}>) {
  engine.rpc({...request, method: 'sigs.sigListJSON'})
}
export type sigsSigListRpcParam = $Exact<{
  arg: SigListArgs
}>

type sigsSigListResult = ?Array<Sig>

export function sigsSigListRpc (request: $Exact<{
  param: sigsSigListRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: sigsSigListResult) => void)}>) {
  engine.rpc({...request, method: 'sigs.sigList'})
}
export type streamUiCloseRpcParam = $Exact<{
  s: Stream
}>

export function streamUiCloseRpc (request: $Exact<{
  param: streamUiCloseRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'streamUi.close'})
}
export type streamUiReadRpcParam = $Exact<{
  s: Stream,
  sz: int
}>

type streamUiReadResult = bytes

export function streamUiReadRpc (request: $Exact<{
  param: streamUiReadRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: streamUiReadResult) => void)}>) {
  engine.rpc({...request, method: 'streamUi.read'})
}
export type streamUiWriteRpcParam = $Exact<{
  s: Stream,
  buf: bytes
}>

type streamUiWriteResult = int

export function streamUiWriteRpc (request: $Exact<{
  param: streamUiWriteRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: streamUiWriteResult) => void)}>) {
  engine.rpc({...request, method: 'streamUi.write'})
}
export type testPanicRpcParam = $Exact<{
  message: string
}>

export function testPanicRpc (request: $Exact<{
  param: testPanicRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'test.panic'})
}
export type testTestCallbackRpcParam = $Exact<{
  name: string
}>

type testTestCallbackResult = string

export function testTestCallbackRpc (request: $Exact<{
  param: testTestCallbackRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: testTestCallbackResult) => void)}>) {
  engine.rpc({...request, method: 'test.testCallback'})
}
export type testTestRpcParam = $Exact<{
  name: string
}>

type testTestResult = Test

export function testTestRpc (request: $Exact<{
  param: testTestRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: testTestResult) => void)}>) {
  engine.rpc({...request, method: 'test.test'})
}
export type trackDismissWithTokenRpcParam = $Exact<{
  trackToken: TrackToken
}>

export function trackDismissWithTokenRpc (request: $Exact<{
  param: trackDismissWithTokenRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'track.dismissWithToken'})
}
export type trackFakeTrackingChangedRpcParam = $Exact<{
  username: string
}>

export function trackFakeTrackingChangedRpc (request: $Exact<{
  param: trackFakeTrackingChangedRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'track.fakeTrackingChanged'})
}
export type trackTrackRpcParam = $Exact<{
  userAssertion: string,
  options: TrackOptions,
  forceRemoteCheck: boolean
}>

export function trackTrackRpc (request: $Exact<{
  param: trackTrackRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'track.track'})
}
export type trackTrackWithTokenRpcParam = $Exact<{
  trackToken: TrackToken,
  options: TrackOptions
}>

export function trackTrackWithTokenRpc (request: $Exact<{
  param: trackTrackWithTokenRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'track.trackWithToken'})
}
export type trackUntrackRpcParam = $Exact<{
  username: string
}>

export function trackUntrackRpc (request: $Exact<{
  param: trackUntrackRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any) => void)}>) {
  engine.rpc({...request, method: 'track.untrack'})
}
export type uiPromptYesNoRpcParam = $Exact<{
  text: Text,
  promptDefault: PromptDefault
}>

type uiPromptYesNoResult = boolean

export function uiPromptYesNoRpc (request: $Exact<{
  param: uiPromptYesNoRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: uiPromptYesNoResult) => void)}>) {
  engine.rpc({...request, method: 'ui.promptYesNo'})
}
export type userListTrackers2RpcParam = $Exact<{
  assertion: string,
  reverse: bool
}>

type userListTrackers2Result = UserSummary2Set

export function userListTrackers2Rpc (request: $Exact<{
  param: userListTrackers2RpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userListTrackers2Result) => void)}>) {
  engine.rpc({...request, method: 'user.listTrackers2'})
}
export type userListTrackersByNameRpcParam = $Exact<{
  username: string
}>

type userListTrackersByNameResult = ?Array<Tracker>

export function userListTrackersByNameRpc (request: $Exact<{
  param: userListTrackersByNameRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userListTrackersByNameResult) => void)}>) {
  engine.rpc({...request, method: 'user.listTrackersByName'})
}
export type userListTrackersRpcParam = $Exact<{
  uid: UID
}>

type userListTrackersResult = ?Array<Tracker>

export function userListTrackersRpc (request: $Exact<{
  param: userListTrackersRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userListTrackersResult) => void)}>) {
  engine.rpc({...request, method: 'user.listTrackers'})
}
export type userListTrackingJSONRpcParam = $Exact<{
  filter: string,
  verbose: boolean,
  assertion: string
}>

type userListTrackingJSONResult = string

export function userListTrackingJSONRpc (request: $Exact<{
  param: userListTrackingJSONRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userListTrackingJSONResult) => void)}>) {
  engine.rpc({...request, method: 'user.listTrackingJSON'})
}
export type userListTrackingRpcParam = $Exact<{
  filter: string,
  assertion: string
}>

type userListTrackingResult = ?Array<UserSummary>

export function userListTrackingRpc (request: $Exact<{
  param: userListTrackingRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userListTrackingResult) => void)}>) {
  engine.rpc({...request, method: 'user.listTracking'})
}
export type userLoadAllPublicKeysUnverifiedRpcParam = $Exact<{
  uid: UID
}>

type userLoadAllPublicKeysUnverifiedResult = ?Array<PublicKey>

export function userLoadAllPublicKeysUnverifiedRpc (request: $Exact<{
  param: userLoadAllPublicKeysUnverifiedRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userLoadAllPublicKeysUnverifiedResult) => void)}>) {
  engine.rpc({...request, method: 'user.loadAllPublicKeysUnverified'})
}
export type userLoadPublicKeysRpcParam = $Exact<{
  uid: UID
}>

type userLoadPublicKeysResult = ?Array<PublicKey>

export function userLoadPublicKeysRpc (request: $Exact<{
  param: userLoadPublicKeysRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userLoadPublicKeysResult) => void)}>) {
  engine.rpc({...request, method: 'user.loadPublicKeys'})
}
export type userLoadUncheckedUserSummariesRpcParam = $Exact<{
  uids?: ?Array<UID>
}>

type userLoadUncheckedUserSummariesResult = ?Array<UserSummary>

export function userLoadUncheckedUserSummariesRpc (request: $Exact<{
  param: userLoadUncheckedUserSummariesRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userLoadUncheckedUserSummariesResult) => void)}>) {
  engine.rpc({...request, method: 'user.loadUncheckedUserSummaries'})
}
export type userLoadUserByNameRpcParam = $Exact<{
  username: string
}>

type userLoadUserByNameResult = User

export function userLoadUserByNameRpc (request: $Exact<{
  param: userLoadUserByNameRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userLoadUserByNameResult) => void)}>) {
  engine.rpc({...request, method: 'user.loadUserByName'})
}
export type userLoadUserPlusKeysRpcParam = $Exact<{
  uid: UID
}>

type userLoadUserPlusKeysResult = UserPlusKeys

export function userLoadUserPlusKeysRpc (request: $Exact<{
  param: userLoadUserPlusKeysRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userLoadUserPlusKeysResult) => void)}>) {
  engine.rpc({...request, method: 'user.loadUserPlusKeys'})
}
export type userLoadUserRpcParam = $Exact<{
  uid: UID
}>

type userLoadUserResult = User

export function userLoadUserRpc (request: $Exact<{
  param: userLoadUserRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userLoadUserResult) => void)}>) {
  engine.rpc({...request, method: 'user.loadUser'})
}
export type userSearchRpcParam = $Exact<{
  query: string
}>

type userSearchResult = ?Array<SearchResult>

export function userSearchRpc (request: $Exact<{
  param: userSearchRpcParam,
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userSearchResult) => void)}>) {
  engine.rpc({...request, method: 'user.search'})
}
type SecretKeysGetSecretKeysResult = SecretKeys

export function SecretKeysGetSecretKeysRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: SecretKeysGetSecretKeysResult) => void)}>) {
  engine.rpc({...request, method: 'SecretKeys.getSecretKeys'})
}
type blockGetSessionChallengeResult = ChallengeInfo

export function blockGetSessionChallengeRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: blockGetSessionChallengeResult) => void)}>) {
  engine.rpc({...request, method: 'block.getSessionChallenge'})
}
type blockGetUserQuotaInfoResult = bytes

export function blockGetUserQuotaInfoRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: blockGetUserQuotaInfoResult) => void)}>) {
  engine.rpc({...request, method: 'block.getUserQuotaInfo'})
}
type configCheckAPIServerOutOfDateWarningResult = OutOfDateInfo

export function configCheckAPIServerOutOfDateWarningRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: configCheckAPIServerOutOfDateWarningResult) => void)}>) {
  engine.rpc({...request, method: 'config.checkAPIServerOutOfDateWarning'})
}
type configGetConfigResult = Config

export function configGetConfigRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: configGetConfigResult) => void)}>) {
  engine.rpc({...request, method: 'config.getConfig'})
}
type configGetCurrentStatusResult = GetCurrentStatusRes

export function configGetCurrentStatusRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: configGetCurrentStatusResult) => void)}>) {
  engine.rpc({...request, method: 'config.getCurrentStatus'})
}
type configGetExtendedStatusResult = ExtendedStatus

export function configGetExtendedStatusRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: configGetExtendedStatusResult) => void)}>) {
  engine.rpc({...request, method: 'config.getExtendedStatus'})
}
type deviceDeviceHistoryListResult = ?Array<DeviceDetail>

export function deviceDeviceHistoryListRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: deviceDeviceHistoryListResult) => void)}>) {
  engine.rpc({...request, method: 'device.deviceHistoryList'})
}
type deviceDeviceListResult = ?Array<Device>

export function deviceDeviceListRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: deviceDeviceListResult) => void)}>) {
  engine.rpc({...request, method: 'device.deviceList'})
}
type favoriteGetFavoritesResult = FavoritesResult

export function favoriteGetFavoritesRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: favoriteGetFavoritesResult) => void)}>) {
  engine.rpc({...request, method: 'favorite.getFavorites'})
}
type gpgUiConfirmDuplicateKeyChosenResult = boolean

export function gpgUiConfirmDuplicateKeyChosenRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: gpgUiConfirmDuplicateKeyChosenResult) => void)}>) {
  engine.rpc({...request, method: 'gpgUi.confirmDuplicateKeyChosen'})
}
type gpgUiWantToAddGPGKeyResult = boolean

export function gpgUiWantToAddGPGKeyRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: gpgUiWantToAddGPGKeyResult) => void)}>) {
  engine.rpc({...request, method: 'gpgUi.wantToAddGPGKey'})
}
type gregorGetStateResult = gregor1.State

export function gregorGetStateRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: gregorGetStateResult) => void)}>) {
  engine.rpc({...request, method: 'gregor.getState'})
}
type identifyUiDelegateIdentifyUIResult = int

export function identifyUiDelegateIdentifyUIRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: identifyUiDelegateIdentifyUIResult) => void)}>) {
  engine.rpc({...request, method: 'identifyUi.delegateIdentifyUI'})
}
type loginGetConfiguredAccountsResult = ?Array<ConfiguredAccount>

export function loginGetConfiguredAccountsRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: loginGetConfiguredAccountsResult) => void)}>) {
  engine.rpc({...request, method: 'login.getConfiguredAccounts'})
}
type loginUiGetEmailOrUsernameResult = string

export function loginUiGetEmailOrUsernameRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: loginUiGetEmailOrUsernameResult) => void)}>) {
  engine.rpc({...request, method: 'loginUi.getEmailOrUsername'})
}
type metadataGetChallengeResult = ChallengeInfo

export function metadataGetChallengeRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataGetChallengeResult) => void)}>) {
  engine.rpc({...request, method: 'metadata.getChallenge'})
}
type metadataPing2Result = PingResponse

export function metadataPing2Rpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: metadataPing2Result) => void)}>) {
  engine.rpc({...request, method: 'metadata.ping2'})
}
type rekeyGetPendingRekeyStatusResult = ProblemSetDevices

export function rekeyGetPendingRekeyStatusRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: rekeyGetPendingRekeyStatusResult) => void)}>) {
  engine.rpc({...request, method: 'rekey.getPendingRekeyStatus'})
}
type rekeyRekeyStatusFinishResult = Outcome

export function rekeyRekeyStatusFinishRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: rekeyRekeyStatusFinishResult) => void)}>) {
  engine.rpc({...request, method: 'rekey.rekeyStatusFinish'})
}
type rekeyUIDelegateRekeyUIResult = int

export function rekeyUIDelegateRekeyUIRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: rekeyUIDelegateRekeyUIResult) => void)}>) {
  engine.rpc({...request, method: 'rekeyUI.delegateRekeyUI'})
}
type sessionCurrentSessionResult = Session

export function sessionCurrentSessionRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: sessionCurrentSessionResult) => void)}>) {
  engine.rpc({...request, method: 'session.currentSession'})
}
type userListTrackersSelfResult = ?Array<Tracker>

export function userListTrackersSelfRpc (request: $Exact<{
  waitingHandler?: (waiting: boolean, method: string, sessionID: string) => void,
  incomingCallMap?: incomingCallMapType,
  callback?: (null | (err: ?any, response: userListTrackersSelfResult) => void)}>) {
  engine.rpc({...request, method: 'user.listTrackersSelf'})
}
export type rpc =
    BTCRegisterBTCRpc
  | Kex2ProvisioneeDidCounterSignRpc
  | Kex2ProvisioneeHelloRpc
  | Kex2ProvisionerKexStartRpc
  | NotifyAppExitRpc
  | NotifyFSFSActivityRpc
  | NotifyFavoritesFavoritesChangedRpc
  | NotifyKeyfamilyKeyfamilyChangedRpc
  | NotifyPaperKeyPaperKeyCachedRpc
  | NotifyServiceShutdownRpc
  | NotifySessionClientOutOfDateRpc
  | NotifySessionLoggedInRpc
  | NotifySessionLoggedOutRpc
  | NotifyTrackingTrackingChangedRpc
  | NotifyUsersUserChangedRpc
  | SecretKeysGetSecretKeysRpc
  | accountPassphraseChangeRpc
  | accountPassphrasePromptRpc
  | apiserverGetRpc
  | apiserverPostJSONRpc
  | apiserverPostRpc
  | blockAddReferenceRpc
  | blockArchiveReferenceRpc
  | blockArchiveReferenceWithCountRpc
  | blockAuthenticateSessionRpc
  | blockDelReferenceRpc
  | blockDelReferenceWithCountRpc
  | blockGetBlockRpc
  | blockGetSessionChallengeRpc
  | blockGetUserQuotaInfoRpc
  | blockPutBlockRpc
  | configCheckAPIServerOutOfDateWarningRpc
  | configClearValueRpc
  | configGetConfigRpc
  | configGetCurrentStatusRpc
  | configGetExtendedStatusRpc
  | configGetValueRpc
  | configHelloIAmRpc
  | configSetPathRpc
  | configSetUserConfigRpc
  | configSetValueRpc
  | cryptoSignED25519Rpc
  | cryptoSignToStringRpc
  | cryptoUnboxBytes32AnyRpc
  | cryptoUnboxBytes32Rpc
  | ctlAppExitRpc
  | ctlDbNukeRpc
  | ctlLogRotateRpc
  | ctlReloadRpc
  | ctlStopRpc
  | debuggingFirstStepRpc
  | debuggingIncrementRpc
  | debuggingSecondStepRpc
  | delegateUiCtlRegisterGregorFirehoseRpc
  | delegateUiCtlRegisterIdentifyUIRpc
  | delegateUiCtlRegisterRekeyUIRpc
  | delegateUiCtlRegisterSecretUIRpc
  | delegateUiCtlRegisterUpdateUIRpc
  | deviceCheckDeviceNameFormatRpc
  | deviceDeviceAddRpc
  | deviceDeviceHistoryListRpc
  | deviceDeviceListRpc
  | favoriteFavoriteAddRpc
  | favoriteFavoriteIgnoreRpc
  | favoriteGetFavoritesRpc
  | fsListRpc
  | gpgUiConfirmDuplicateKeyChosenRpc
  | gpgUiSelectKeyAndPushOptionRpc
  | gpgUiSelectKeyRpc
  | gpgUiSignRpc
  | gpgUiWantToAddGPGKeyRpc
  | gregorGetStateRpc
  | gregorUIPushOutOfBandMessagesRpc
  | gregorUIPushStateRpc
  | identifyIdentify2Rpc
  | identifyIdentifyRpc
  | identifyResolve2Rpc
  | identifyResolveRpc
  | identifyUiConfirmRpc
  | identifyUiDelegateIdentifyUIRpc
  | identifyUiDismissRpc
  | identifyUiDisplayCryptocurrencyRpc
  | identifyUiDisplayKeyRpc
  | identifyUiDisplayTLFCreateWithInviteRpc
  | identifyUiDisplayTrackStatementRpc
  | identifyUiDisplayUserCardRpc
  | identifyUiFinishRpc
  | identifyUiFinishSocialProofCheckRpc
  | identifyUiFinishWebProofCheckRpc
  | identifyUiLaunchNetworkChecksRpc
  | identifyUiReportLastTrackRpc
  | identifyUiReportTrackTokenRpc
  | identifyUiStartRpc
  | kbfsFSEventRpc
  | logRegisterLoggerRpc
  | logUiLogRpc
  | loginClearStoredSecretRpc
  | loginDeprovisionRpc
  | loginGetConfiguredAccountsRpc
  | loginLoginRpc
  | loginLogoutRpc
  | loginPaperKeyRpc
  | loginPaperKeySubmitRpc
  | loginPgpProvisionRpc
  | loginRecoverAccountFromEmailAddressRpc
  | loginUiDisplayPaperKeyPhraseRpc
  | loginUiDisplayPrimaryPaperKeyRpc
  | loginUiGetEmailOrUsernameRpc
  | loginUiPromptRevokePaperKeysRpc
  | loginUnlockRpc
  | loginUnlockWithPassphraseRpc
  | metadataAuthenticateRpc
  | metadataDeleteKeyRpc
  | metadataGetChallengeRpc
  | metadataGetFolderHandleRpc
  | metadataGetFoldersForRekeyRpc
  | metadataGetKeyRpc
  | metadataGetLatestFolderHandleRpc
  | metadataGetMerkleNodeRpc
  | metadataGetMerkleRootLatestRpc
  | metadataGetMerkleRootRpc
  | metadataGetMerkleRootSinceRpc
  | metadataGetMetadataRpc
  | metadataPing2Rpc
  | metadataPingRpc
  | metadataPruneBranchRpc
  | metadataPutKeysRpc
  | metadataPutMetadataRpc
  | metadataRegisterForUpdatesRpc
  | metadataTruncateLockRpc
  | metadataTruncateUnlockRpc
  | metadataUpdateFolderNeedsRekeyRpc
  | metadataUpdateMetadataUpdateRpc
  | notifyCtlSetNotificationsRpc
  | paperprovisionPaperProvisionRpc
  | pgpPgpDecryptRpc
  | pgpPgpDeletePrimaryRpc
  | pgpPgpEncryptRpc
  | pgpPgpExportByFingerprintRpc
  | pgpPgpExportByKIDRpc
  | pgpPgpExportRpc
  | pgpPgpImportRpc
  | pgpPgpKeyGenRpc
  | pgpPgpPullRpc
  | pgpPgpSelectRpc
  | pgpPgpSignRpc
  | pgpPgpUpdateRpc
  | pgpPgpVerifyRpc
  | pgpUiOutputSignatureSuccessRpc
  | proveCheckProofRpc
  | proveStartProofRpc
  | proveUiDisplayRecheckWarningRpc
  | proveUiOkToCheckRpc
  | proveUiOutputInstructionsRpc
  | proveUiOutputPrechecksRpc
  | proveUiPreProofWarningRpc
  | proveUiPromptOverwriteRpc
  | proveUiPromptUsernameRpc
  | provisionUiChooseDeviceRpc
  | provisionUiChooseDeviceTypeRpc
  | provisionUiChooseGPGMethodRpc
  | provisionUiChooseProvisioningMethodRpc
  | provisionUiDisplayAndPromptSecretRpc
  | provisionUiDisplaySecretExchangedRpc
  | provisionUiPromptNewDeviceNameRpc
  | provisionUiProvisioneeSuccessRpc
  | provisionUiProvisionerSuccessRpc
  | provisionUiSwitchToGPGSignOKRpc
  | quotaVerifySessionRpc
  | rekeyDebugShowRekeyStatusRpc
  | rekeyGetPendingRekeyStatusRpc
  | rekeyRekeyStatusFinishRpc
  | rekeyShowPendingRekeyStatusRpc
  | rekeyUIDelegateRekeyUIRpc
  | rekeyUIRefreshRpc
  | revokeRevokeDeviceRpc
  | revokeRevokeKeyRpc
  | revokeRevokeSigsRpc
  | saltpackSaltpackDecryptRpc
  | saltpackSaltpackEncryptRpc
  | saltpackSaltpackSignRpc
  | saltpackSaltpackVerifyRpc
  | saltpackUiSaltpackPromptForDecryptRpc
  | saltpackUiSaltpackVerifySuccessRpc
  | secretUiGetPassphraseRpc
  | sessionCurrentSessionRpc
  | signupCheckInvitationCodeRpc
  | signupCheckUsernameAvailableRpc
  | signupInviteRequestRpc
  | signupSignupRpc
  | sigsSigListJSONRpc
  | sigsSigListRpc
  | streamUiCloseRpc
  | streamUiReadRpc
  | streamUiWriteRpc
  | testPanicRpc
  | testTestCallbackRpc
  | testTestRpc
  | trackCheckTrackingRpc
  | trackDismissWithTokenRpc
  | trackFakeTrackingChangedRpc
  | trackTrackRpc
  | trackTrackWithTokenRpc
  | trackUntrackRpc
  | uiPromptYesNoRpc
  | userListTrackers2Rpc
  | userListTrackersByNameRpc
  | userListTrackersRpc
  | userListTrackersSelfRpc
  | userListTrackingJSONRpc
  | userListTrackingRpc
  | userLoadAllPublicKeysUnverifiedRpc
  | userLoadPublicKeysRpc
  | userLoadUncheckedUserSummariesRpc
  | userLoadUserByNameRpc
  | userLoadUserPlusKeysRpc
  | userLoadUserRpc
  | userSearchRpc

export type incomingCallMapType = $Exact<{
  'keybase.1.account.passphraseChange'?: (
    params: $Exact<{
      sessionID: int,
      oldPassphrase: string,
      passphrase: string,
      force: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.account.passphrasePrompt'?: (
    params: $Exact<{
      sessionID: int,
      guiArg: GUIEntryArg
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: accountPassphrasePromptResult) => void
    }
  ) => void,
  'keybase.1.apiserver.Get'?: (
    params: $Exact<{
      endpoint: string,
      args?: ?Array<StringKVPair>,
      httpStatus?: ?Array<int>,
      appStatusCode?: ?Array<int>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: apiserverGetResult) => void
    }
  ) => void,
  'keybase.1.apiserver.Post'?: (
    params: $Exact<{
      endpoint: string,
      args?: ?Array<StringKVPair>,
      httpStatus?: ?Array<int>,
      appStatusCode?: ?Array<int>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: apiserverPostResult) => void
    }
  ) => void,
  'keybase.1.apiserver.PostJSON'?: (
    params: $Exact<{
      endpoint: string,
      args?: ?Array<StringKVPair>,
      JSONPayload?: ?Array<StringKVPair>,
      httpStatus?: ?Array<int>,
      appStatusCode?: ?Array<int>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: apiserverPostJSONResult) => void
    }
  ) => void,
  'keybase.1.block.getSessionChallenge'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: (result: blockGetSessionChallengeResult) => void
    }
  ) => void,
  'keybase.1.block.authenticateSession'?: (
    params: $Exact<{
      signature: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.block.putBlock'?: (
    params: $Exact<{
      bid: BlockIdCombo,
      folder: string,
      blockKey: string,
      buf: bytes
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.block.getBlock'?: (
    params: $Exact<{
      bid: BlockIdCombo,
      folder: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: blockGetBlockResult) => void
    }
  ) => void,
  'keybase.1.block.addReference'?: (
    params: $Exact<{
      folder: string,
      ref: BlockReference
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.block.delReference'?: (
    params: $Exact<{
      folder: string,
      ref: BlockReference
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.block.archiveReference'?: (
    params: $Exact<{
      folder: string,
      refs?: ?Array<BlockReference>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: blockArchiveReferenceResult) => void
    }
  ) => void,
  'keybase.1.block.delReferenceWithCount'?: (
    params: $Exact<{
      folder: string,
      refs?: ?Array<BlockReference>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: blockDelReferenceWithCountResult) => void
    }
  ) => void,
  'keybase.1.block.archiveReferenceWithCount'?: (
    params: $Exact<{
      folder: string,
      refs?: ?Array<BlockReference>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: blockArchiveReferenceWithCountResult) => void
    }
  ) => void,
  'keybase.1.block.getUserQuotaInfo'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: (result: blockGetUserQuotaInfoResult) => void
    }
  ) => void,
  'keybase.1.BTC.registerBTC'?: (
    params: $Exact<{
      sessionID: int,
      address: string,
      force: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.config.getCurrentStatus'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: configGetCurrentStatusResult) => void
    }
  ) => void,
  'keybase.1.config.getExtendedStatus'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: configGetExtendedStatusResult) => void
    }
  ) => void,
  'keybase.1.config.getConfig'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: configGetConfigResult) => void
    }
  ) => void,
  'keybase.1.config.setUserConfig'?: (
    params: $Exact<{
      sessionID: int,
      username: string,
      key: string,
      value: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.config.setPath'?: (
    params: $Exact<{
      sessionID: int,
      path: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.config.helloIAm'?: (
    params: $Exact<{
      details: ClientDetails
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.config.setValue'?: (
    params: $Exact<{
      path: string,
      value: ConfigValue
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.config.clearValue'?: (
    params: $Exact<{
      path: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.config.getValue'?: (
    params: $Exact<{
      path: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: configGetValueResult) => void
    }
  ) => void,
  'keybase.1.config.checkAPIServerOutOfDateWarning'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: (result: configCheckAPIServerOutOfDateWarningResult) => void
    }
  ) => void,
  'keybase.1.crypto.signED25519'?: (
    params: $Exact<{
      sessionID: int,
      msg: bytes,
      reason: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: cryptoSignED25519Result) => void
    }
  ) => void,
  'keybase.1.crypto.signToString'?: (
    params: $Exact<{
      sessionID: int,
      msg: bytes,
      reason: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: cryptoSignToStringResult) => void
    }
  ) => void,
  'keybase.1.crypto.unboxBytes32'?: (
    params: $Exact<{
      sessionID: int,
      encryptedBytes32: EncryptedBytes32,
      nonce: BoxNonce,
      peersPublicKey: BoxPublicKey,
      reason: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: cryptoUnboxBytes32Result) => void
    }
  ) => void,
  'keybase.1.crypto.unboxBytes32Any'?: (
    params: $Exact<{
      sessionID: int,
      bundles?: ?Array<CiphertextBundle>,
      reason: string,
      promptPaper: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: cryptoUnboxBytes32AnyResult) => void
    }
  ) => void,
  'keybase.1.ctl.stop'?: (
    params: $Exact<{
      sessionID: int,
      exitCode: ExitCode
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.ctl.logRotate'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.ctl.reload'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.ctl.dbNuke'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.ctl.appExit'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.debugging.firstStep'?: (
    params: $Exact<{
      sessionID: int,
      val: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: debuggingFirstStepResult) => void
    }
  ) => void,
  'keybase.1.debugging.secondStep'?: (
    params: $Exact<{
      sessionID: int,
      val: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: debuggingSecondStepResult) => void
    }
  ) => void,
  'keybase.1.debugging.increment'?: (
    params: $Exact<{
      sessionID: int,
      val: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: debuggingIncrementResult) => void
    }
  ) => void,
  'keybase.1.delegateUiCtl.registerIdentifyUI'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.delegateUiCtl.registerSecretUI'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.delegateUiCtl.registerUpdateUI'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.delegateUiCtl.registerRekeyUI'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.delegateUiCtl.registerGregorFirehose'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.device.deviceList'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: deviceDeviceListResult) => void
    }
  ) => void,
  'keybase.1.device.deviceHistoryList'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: deviceDeviceHistoryListResult) => void
    }
  ) => void,
  'keybase.1.device.deviceAdd'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.device.checkDeviceNameFormat'?: (
    params: $Exact<{
      sessionID: int,
      name: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: deviceCheckDeviceNameFormatResult) => void
    }
  ) => void,
  'keybase.1.favorite.favoriteAdd'?: (
    params: $Exact<{
      sessionID: int,
      folder: Folder
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.favorite.favoriteIgnore'?: (
    params: $Exact<{
      sessionID: int,
      folder: Folder
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.favorite.getFavorites'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: favoriteGetFavoritesResult) => void
    }
  ) => void,
  'keybase.1.fs.List'?: (
    params: $Exact<{
      sessionID: int,
      path: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: fsListResult) => void
    }
  ) => void,
  'keybase.1.gpgUi.wantToAddGPGKey'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: gpgUiWantToAddGPGKeyResult) => void
    }
  ) => void,
  'keybase.1.gpgUi.confirmDuplicateKeyChosen'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: gpgUiConfirmDuplicateKeyChosenResult) => void
    }
  ) => void,
  'keybase.1.gpgUi.selectKeyAndPushOption'?: (
    params: $Exact<{
      sessionID: int,
      keys?: ?Array<GPGKey>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: gpgUiSelectKeyAndPushOptionResult) => void
    }
  ) => void,
  'keybase.1.gpgUi.selectKey'?: (
    params: $Exact<{
      sessionID: int,
      keys?: ?Array<GPGKey>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: gpgUiSelectKeyResult) => void
    }
  ) => void,
  'keybase.1.gpgUi.sign'?: (
    params: $Exact<{
      msg: bytes,
      fingerprint: bytes
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: gpgUiSignResult) => void
    }
  ) => void,
  'keybase.1.gregor.getState'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: (result: gregorGetStateResult) => void
    }
  ) => void,
  'keybase.1.gregorUI.pushState'?: (
    params: $Exact<{
      state: gregor1.State,
      reason: PushReason
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.gregorUI.pushOutOfBandMessages'?: (
    params: $Exact<{
      oobm?: ?Array<gregor1.OutOfBandMessage>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identify.Resolve'?: (
    params: $Exact<{
      assertion: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: identifyResolveResult) => void
    }
  ) => void,
  'keybase.1.identify.Resolve2'?: (
    params: $Exact<{
      assertion: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: identifyResolve2Result) => void
    }
  ) => void,
  'keybase.1.identify.identify'?: (
    params: $Exact<{
      sessionID: int,
      userAssertion: string,
      forceRemoteCheck?: boolean,
      useDelegateUI?: boolean,
      reason: IdentifyReason,
      source: ClientType
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: identifyIdentifyResult) => void
    }
  ) => void,
  'keybase.1.identify.identify2'?: (
    params: $Exact<{
      sessionID: int,
      uid: UID,
      userAssertion: string,
      reason: IdentifyReason,
      useDelegateUI?: boolean,
      alwaysBlock?: boolean,
      noErrorOnTrackFailure?: boolean,
      forceRemoteCheck?: boolean,
      needProofSet?: boolean,
      allowEmptySelfID?: boolean,
      noSkipSelf?: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: identifyIdentify2Result) => void
    }
  ) => void,
  'keybase.1.identifyUi.displayTLFCreateWithInvite'?: (
    params: $Exact<{
      sessionID: int,
      folderName: string,
      isPrivate: boolean,
      assertion: string,
      socialAssertion: SocialAssertion,
      inviteLink: string,
      throttled: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.delegateIdentifyUI'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: (result: identifyUiDelegateIdentifyUIResult) => void
    }
  ) => void,
  'keybase.1.identifyUi.start'?: (
    params: $Exact<{
      sessionID: int,
      username: string,
      reason: IdentifyReason
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.displayKey'?: (
    params: $Exact<{
      sessionID: int,
      key: IdentifyKey
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.reportLastTrack'?: (
    params: $Exact<{
      sessionID: int,
      track: (null | TrackSummary)
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.launchNetworkChecks'?: (
    params: $Exact<{
      sessionID: int,
      identity: Identity,
      user: User
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.displayTrackStatement'?: (
    params: $Exact<{
      sessionID: int,
      stmt: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.finishWebProofCheck'?: (
    params: $Exact<{
      sessionID: int,
      rp: RemoteProof,
      lcr: LinkCheckResult
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.finishSocialProofCheck'?: (
    params: $Exact<{
      sessionID: int,
      rp: RemoteProof,
      lcr: LinkCheckResult
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.displayCryptocurrency'?: (
    params: $Exact<{
      sessionID: int,
      c: Cryptocurrency
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.reportTrackToken'?: (
    params: $Exact<{
      sessionID: int,
      trackToken: TrackToken
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.displayUserCard'?: (
    params: $Exact<{
      sessionID: int,
      card: UserCard
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.confirm'?: (
    params: $Exact<{
      sessionID: int,
      outcome: IdentifyOutcome
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: identifyUiConfirmResult) => void
    }
  ) => void,
  'keybase.1.identifyUi.finish'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.identifyUi.dismiss'?: (
    params: $Exact<{
      sessionID: int,
      username: string,
      reason: DismissReason
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.kbfs.FSEvent'?: (
    params: $Exact<{
      event: FSNotification
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.Kex2Provisionee.hello'?: (
    params: $Exact<{
      uid: UID,
      token: SessionToken,
      csrf: CsrfToken,
      pps: PassphraseStream,
      sigBody: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: Kex2ProvisioneeHelloResult) => void
    }
  ) => void,
  'keybase.1.Kex2Provisionee.didCounterSign'?: (
    params: $Exact<{
      sig: bytes
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.Kex2Provisioner.kexStart'?: (
    params: $Exact<{}> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.log.registerLogger'?: (
    params: $Exact<{
      sessionID: int,
      name: string,
      level: LogLevel
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.logUi.log'?: (
    params: $Exact<{
      sessionID: int,
      level: LogLevel,
      text: Text
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.getConfiguredAccounts'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: loginGetConfiguredAccountsResult) => void
    }
  ) => void,
  'keybase.1.login.login'?: (
    params: $Exact<{
      sessionID: int,
      deviceType: string,
      usernameOrEmail: string,
      clientType: ClientType
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.clearStoredSecret'?: (
    params: $Exact<{
      sessionID: int,
      username: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.logout'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.deprovision'?: (
    params: $Exact<{
      sessionID: int,
      username: string,
      doRevoke: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.recoverAccountFromEmailAddress'?: (
    params: $Exact<{
      email: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.paperKey'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.paperKeySubmit'?: (
    params: $Exact<{
      sessionID: int,
      paperPhrase: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.unlock'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.unlockWithPassphrase'?: (
    params: $Exact<{
      sessionID: int,
      passphrase: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.login.pgpProvision'?: (
    params: $Exact<{
      sessionID: int,
      username: string,
      passphrase: string,
      deviceName: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.loginUi.getEmailOrUsername'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: loginUiGetEmailOrUsernameResult) => void
    }
  ) => void,
  'keybase.1.loginUi.promptRevokePaperKeys'?: (
    params: $Exact<{
      sessionID: int,
      device: Device,
      index: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: loginUiPromptRevokePaperKeysResult) => void
    }
  ) => void,
  'keybase.1.loginUi.displayPaperKeyPhrase'?: (
    params: $Exact<{
      sessionID: int,
      phrase: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.loginUi.displayPrimaryPaperKey'?: (
    params: $Exact<{
      sessionID: int,
      phrase: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.metadata.getChallenge'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataGetChallengeResult) => void
    }
  ) => void,
  'keybase.1.metadata.authenticate'?: (
    params: $Exact<{
      signature: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataAuthenticateResult) => void
    }
  ) => void,
  'keybase.1.metadata.putMetadata'?: (
    params: $Exact<{
      mdBlock: MDBlock,
      logTags: {[key: string]: string}
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.metadata.getMetadata'?: (
    params: $Exact<{
      folderID: string,
      folderHandle: bytes,
      branchID: string,
      unmerged: boolean,
      startRevision: long,
      stopRevision: long,
      logTags: {[key: string]: string}
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataGetMetadataResult) => void
    }
  ) => void,
  'keybase.1.metadata.registerForUpdates'?: (
    params: $Exact<{
      folderID: string,
      currRevision: long,
      logTags: {[key: string]: string}
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.metadata.pruneBranch'?: (
    params: $Exact<{
      folderID: string,
      branchID: string,
      logTags: {[key: string]: string}
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.metadata.putKeys'?: (
    params: $Exact<{
      keyHalves?: ?Array<KeyHalf>,
      logTags: {[key: string]: string}
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.metadata.getKey'?: (
    params: $Exact<{
      keyHalfID: bytes,
      deviceKID: string,
      logTags: {[key: string]: string}
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataGetKeyResult) => void
    }
  ) => void,
  'keybase.1.metadata.deleteKey'?: (
    params: $Exact<{
      uid: UID,
      deviceKID: KID,
      keyHalfID: bytes,
      logTags: {[key: string]: string}
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.metadata.truncateLock'?: (
    params: $Exact<{
      folderID: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataTruncateLockResult) => void
    }
  ) => void,
  'keybase.1.metadata.truncateUnlock'?: (
    params: $Exact<{
      folderID: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataTruncateUnlockResult) => void
    }
  ) => void,
  'keybase.1.metadata.getFolderHandle'?: (
    params: $Exact<{
      folderID: string,
      signature: string,
      challenge: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataGetFolderHandleResult) => void
    }
  ) => void,
  'keybase.1.metadata.getFoldersForRekey'?: (
    params: $Exact<{
      deviceKID: KID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.metadata.ping'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.metadata.ping2'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataPing2Result) => void
    }
  ) => void,
  'keybase.1.metadata.getLatestFolderHandle'?: (
    params: $Exact<{
      folderID: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataGetLatestFolderHandleResult) => void
    }
  ) => void,
  'keybase.1.metadata.getMerkleRoot'?: (
    params: $Exact<{
      treeID: MerkleTreeID,
      seqNo: long
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataGetMerkleRootResult) => void
    }
  ) => void,
  'keybase.1.metadata.getMerkleRootLatest'?: (
    params: $Exact<{
      treeID: MerkleTreeID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataGetMerkleRootLatestResult) => void
    }
  ) => void,
  'keybase.1.metadata.getMerkleRootSince'?: (
    params: $Exact<{
      treeID: MerkleTreeID,
      when: Time
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataGetMerkleRootSinceResult) => void
    }
  ) => void,
  'keybase.1.metadata.getMerkleNode'?: (
    params: $Exact<{
      hash: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: metadataGetMerkleNodeResult) => void
    }
  ) => void,
  'keybase.1.metadataUpdate.metadataUpdate'?: (
    params: $Exact<{
      folderID: string,
      revision: long
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.metadataUpdate.folderNeedsRekey'?: (
    params: $Exact<{
      folderID: string,
      revision: long
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.NotifyApp.exit'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.notifyCtl.setNotifications'?: (
    params: $Exact<{
      channels: NotificationChannels
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.NotifyFavorites.favoritesChanged'?: (
    params: $Exact<{
      uid: UID
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyFS.FSActivity'?: (
    params: $Exact<{
      notification: FSNotification
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyKeyfamily.keyfamilyChanged'?: (
    params: $Exact<{
      uid: UID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.NotifyPaperKey.paperKeyCached'?: (
    params: $Exact<{
      uid: UID,
      encKID: KID,
      sigKID: KID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.NotifyService.shutdown'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.NotifySession.loggedOut'?: (
    params: $Exact<{}> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifySession.loggedIn'?: (
    params: $Exact<{
      username: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.NotifySession.clientOutOfDate'?: (
    params: $Exact<{
      upgradeTo: string,
      upgradeURI: string,
      upgradeMsg: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.NotifyTracking.trackingChanged'?: (
    params: $Exact<{
      uid: UID,
      username: string
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyUsers.userChanged'?: (
    params: $Exact<{
      uid: UID
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.paperprovision.paperProvision'?: (
    params: $Exact<{
      sessionID: int,
      username: string,
      deviceName: string,
      paperKey: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.pgp.pgpSign'?: (
    params: $Exact<{
      sessionID: int,
      source: Stream,
      sink: Stream,
      opts: PGPSignOptions
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.pgp.pgpPull'?: (
    params: $Exact<{
      sessionID: int,
      userAsserts?: ?Array<string>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.pgp.pgpEncrypt'?: (
    params: $Exact<{
      sessionID: int,
      source: Stream,
      sink: Stream,
      opts: PGPEncryptOptions
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.pgp.pgpDecrypt'?: (
    params: $Exact<{
      sessionID: int,
      source: Stream,
      sink: Stream,
      opts: PGPDecryptOptions
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: pgpPgpDecryptResult) => void
    }
  ) => void,
  'keybase.1.pgp.pgpVerify'?: (
    params: $Exact<{
      sessionID: int,
      source: Stream,
      opts: PGPVerifyOptions
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: pgpPgpVerifyResult) => void
    }
  ) => void,
  'keybase.1.pgp.pgpImport'?: (
    params: $Exact<{
      sessionID: int,
      key: bytes,
      pushSecret: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.pgp.pgpExport'?: (
    params: $Exact<{
      sessionID: int,
      options: PGPQuery
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: pgpPgpExportResult) => void
    }
  ) => void,
  'keybase.1.pgp.pgpExportByFingerprint'?: (
    params: $Exact<{
      sessionID: int,
      options: PGPQuery
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: pgpPgpExportByFingerprintResult) => void
    }
  ) => void,
  'keybase.1.pgp.pgpExportByKID'?: (
    params: $Exact<{
      sessionID: int,
      options: PGPQuery
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: pgpPgpExportByKIDResult) => void
    }
  ) => void,
  'keybase.1.pgp.pgpKeyGen'?: (
    params: $Exact<{
      sessionID: int,
      primaryBits: int,
      subkeyBits: int,
      createUids: PGPCreateUids,
      allowMulti: boolean,
      doExport: boolean,
      pushSecret: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.pgp.pgpDeletePrimary'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.pgp.pgpSelect'?: (
    params: $Exact<{
      sessionID: int,
      fingerprintQuery: string,
      allowMulti: boolean,
      skipImport: boolean,
      onlyImport: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.pgp.pgpUpdate'?: (
    params: $Exact<{
      sessionID: int,
      all: boolean,
      fingerprints?: ?Array<string>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.pgpUi.outputSignatureSuccess'?: (
    params: $Exact<{
      sessionID: int,
      fingerprint: string,
      username: string,
      signedAt: Time
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.prove.startProof'?: (
    params: $Exact<{
      sessionID: int,
      service: string,
      username: string,
      force: boolean,
      promptPosted: boolean,
      auto: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: proveStartProofResult) => void
    }
  ) => void,
  'keybase.1.prove.checkProof'?: (
    params: $Exact<{
      sessionID: int,
      sigID: SigID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: proveCheckProofResult) => void
    }
  ) => void,
  'keybase.1.proveUi.promptOverwrite'?: (
    params: $Exact<{
      sessionID: int,
      account: string,
      typ: PromptOverwriteType
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: proveUiPromptOverwriteResult) => void
    }
  ) => void,
  'keybase.1.proveUi.promptUsername'?: (
    params: $Exact<{
      sessionID: int,
      prompt: string,
      prevError: (null | Status)
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: proveUiPromptUsernameResult) => void
    }
  ) => void,
  'keybase.1.proveUi.outputPrechecks'?: (
    params: $Exact<{
      sessionID: int,
      text: Text
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.proveUi.preProofWarning'?: (
    params: $Exact<{
      sessionID: int,
      text: Text
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: proveUiPreProofWarningResult) => void
    }
  ) => void,
  'keybase.1.proveUi.outputInstructions'?: (
    params: $Exact<{
      sessionID: int,
      instructions: Text,
      proof: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.proveUi.okToCheck'?: (
    params: $Exact<{
      sessionID: int,
      name: string,
      attempt: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: proveUiOkToCheckResult) => void
    }
  ) => void,
  'keybase.1.proveUi.displayRecheckWarning'?: (
    params: $Exact<{
      sessionID: int,
      text: Text
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.provisionUi.chooseProvisioningMethod'?: (
    params: $Exact<{
      sessionID: int,
      gpgOption: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: provisionUiChooseProvisioningMethodResult) => void
    }
  ) => void,
  'keybase.1.provisionUi.chooseGPGMethod'?: (
    params: $Exact<{
      sessionID: int,
      keys?: ?Array<GPGKey>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: provisionUiChooseGPGMethodResult) => void
    }
  ) => void,
  'keybase.1.provisionUi.switchToGPGSignOK'?: (
    params: $Exact<{
      sessionID: int,
      key: GPGKey,
      importError: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: provisionUiSwitchToGPGSignOKResult) => void
    }
  ) => void,
  'keybase.1.provisionUi.chooseDevice'?: (
    params: $Exact<{
      sessionID: int,
      devices?: ?Array<Device>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: provisionUiChooseDeviceResult) => void
    }
  ) => void,
  'keybase.1.provisionUi.chooseDeviceType'?: (
    params: $Exact<{
      sessionID: int,
      kind: ChooseType
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: provisionUiChooseDeviceTypeResult) => void
    }
  ) => void,
  'keybase.1.provisionUi.DisplayAndPromptSecret'?: (
    params: $Exact<{
      sessionID: int,
      secret: bytes,
      phrase: string,
      otherDeviceType: DeviceType
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: provisionUiDisplayAndPromptSecretResult) => void
    }
  ) => void,
  'keybase.1.provisionUi.DisplaySecretExchanged'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.provisionUi.PromptNewDeviceName'?: (
    params: $Exact<{
      sessionID: int,
      existingDevices?: ?Array<string>,
      errorMessage: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: provisionUiPromptNewDeviceNameResult) => void
    }
  ) => void,
  'keybase.1.provisionUi.ProvisioneeSuccess'?: (
    params: $Exact<{
      sessionID: int,
      username: string,
      deviceName: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.provisionUi.ProvisionerSuccess'?: (
    params: $Exact<{
      sessionID: int,
      deviceName: string,
      deviceType: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.quota.verifySession'?: (
    params: $Exact<{
      session: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: quotaVerifySessionResult) => void
    }
  ) => void,
  'keybase.1.rekey.showPendingRekeyStatus'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.rekey.getPendingRekeyStatus'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: rekeyGetPendingRekeyStatusResult) => void
    }
  ) => void,
  'keybase.1.rekey.debugShowRekeyStatus'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.rekey.rekeyStatusFinish'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: rekeyRekeyStatusFinishResult) => void
    }
  ) => void,
  'keybase.1.rekeyUI.delegateRekeyUI'?: (
    params: $Exact<{}>,
    response: {
      error: (err: RPCError) => void,
      result: (result: rekeyUIDelegateRekeyUIResult) => void
    }
  ) => void,
  'keybase.1.rekeyUI.refresh'?: (
    params: $Exact<{
      sessionID: int,
      problemSetDevices: ProblemSetDevices
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.revoke.revokeKey'?: (
    params: $Exact<{
      sessionID: int,
      keyID: KID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.revoke.revokeDevice'?: (
    params: $Exact<{
      sessionID: int,
      deviceID: DeviceID,
      force: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.revoke.revokeSigs'?: (
    params: $Exact<{
      sessionID: int,
      sigIDQueries?: ?Array<string>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.saltpack.saltpackEncrypt'?: (
    params: $Exact<{
      sessionID: int,
      source: Stream,
      sink: Stream,
      opts: SaltpackEncryptOptions
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.saltpack.saltpackDecrypt'?: (
    params: $Exact<{
      sessionID: int,
      source: Stream,
      sink: Stream,
      opts: SaltpackDecryptOptions
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: saltpackSaltpackDecryptResult) => void
    }
  ) => void,
  'keybase.1.saltpack.saltpackSign'?: (
    params: $Exact<{
      sessionID: int,
      source: Stream,
      sink: Stream,
      opts: SaltpackSignOptions
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.saltpack.saltpackVerify'?: (
    params: $Exact<{
      sessionID: int,
      source: Stream,
      sink: Stream,
      opts: SaltpackVerifyOptions
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.saltpackUi.saltpackPromptForDecrypt'?: (
    params: $Exact<{
      sessionID: int,
      sender: SaltpackSender,
      usedDelegateUI: bool
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.saltpackUi.saltpackVerifySuccess'?: (
    params: $Exact<{
      sessionID: int,
      signingKID: KID,
      sender: SaltpackSender
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.secretUi.getPassphrase'?: (
    params: $Exact<{
      sessionID: int,
      pinentry: GUIEntryArg,
      terminal: (null | SecretEntryArg)
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: secretUiGetPassphraseResult) => void
    }
  ) => void,
  'keybase.1.SecretKeys.getSecretKeys'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: SecretKeysGetSecretKeysResult) => void
    }
  ) => void,
  'keybase.1.session.currentSession'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: sessionCurrentSessionResult) => void
    }
  ) => void,
  'keybase.1.signup.checkUsernameAvailable'?: (
    params: $Exact<{
      sessionID: int,
      username: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.signup.signup'?: (
    params: $Exact<{
      sessionID: int,
      email: string,
      inviteCode: string,
      passphrase: string,
      username: string,
      deviceName: string,
      storeSecret: boolean,
      skipMail: boolean,
      genPGPBatch: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: signupSignupResult) => void
    }
  ) => void,
  'keybase.1.signup.inviteRequest'?: (
    params: $Exact<{
      sessionID: int,
      email: string,
      fullname: string,
      notes: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.signup.checkInvitationCode'?: (
    params: $Exact<{
      sessionID: int,
      invitationCode: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.sigs.sigList'?: (
    params: $Exact<{
      sessionID: int,
      arg: SigListArgs
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: sigsSigListResult) => void
    }
  ) => void,
  'keybase.1.sigs.sigListJSON'?: (
    params: $Exact<{
      sessionID: int,
      arg: SigListArgs
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: sigsSigListJSONResult) => void
    }
  ) => void,
  'keybase.1.streamUi.close'?: (
    params: $Exact<{
      sessionID: int,
      s: Stream
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.streamUi.read'?: (
    params: $Exact<{
      sessionID: int,
      s: Stream,
      sz: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: streamUiReadResult) => void
    }
  ) => void,
  'keybase.1.streamUi.write'?: (
    params: $Exact<{
      sessionID: int,
      s: Stream,
      buf: bytes
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: streamUiWriteResult) => void
    }
  ) => void,
  'keybase.1.test.test'?: (
    params: $Exact<{
      sessionID: int,
      name: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: testTestResult) => void
    }
  ) => void,
  'keybase.1.test.testCallback'?: (
    params: $Exact<{
      sessionID: int,
      name: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: testTestCallbackResult) => void
    }
  ) => void,
  'keybase.1.test.panic'?: (
    params: $Exact<{
      message: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.track.track'?: (
    params: $Exact<{
      sessionID: int,
      userAssertion: string,
      options: TrackOptions,
      forceRemoteCheck: boolean
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.track.trackWithToken'?: (
    params: $Exact<{
      sessionID: int,
      trackToken: TrackToken,
      options: TrackOptions
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.track.dismissWithToken'?: (
    params: $Exact<{
      sessionID: int,
      trackToken: TrackToken
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.track.untrack'?: (
    params: $Exact<{
      sessionID: int,
      username: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.track.checkTracking'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.track.fakeTrackingChanged'?: (
    params: $Exact<{
      sessionID: int,
      username: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: () => void
    }
  ) => void,
  'keybase.1.ui.promptYesNo'?: (
    params: $Exact<{
      sessionID: int,
      text: Text,
      promptDefault: PromptDefault
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: uiPromptYesNoResult) => void
    }
  ) => void,
  'keybase.1.user.listTrackers'?: (
    params: $Exact<{
      sessionID: int,
      uid: UID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userListTrackersResult) => void
    }
  ) => void,
  'keybase.1.user.listTrackersByName'?: (
    params: $Exact<{
      sessionID: int,
      username: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userListTrackersByNameResult) => void
    }
  ) => void,
  'keybase.1.user.listTrackersSelf'?: (
    params: $Exact<{
      sessionID: int
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userListTrackersSelfResult) => void
    }
  ) => void,
  'keybase.1.user.loadUncheckedUserSummaries'?: (
    params: $Exact<{
      sessionID: int,
      uids?: ?Array<UID>
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userLoadUncheckedUserSummariesResult) => void
    }
  ) => void,
  'keybase.1.user.loadUser'?: (
    params: $Exact<{
      sessionID: int,
      uid: UID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userLoadUserResult) => void
    }
  ) => void,
  'keybase.1.user.loadUserByName'?: (
    params: $Exact<{
      sessionID: int,
      username: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userLoadUserByNameResult) => void
    }
  ) => void,
  'keybase.1.user.loadUserPlusKeys'?: (
    params: $Exact<{
      sessionID: int,
      uid: UID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userLoadUserPlusKeysResult) => void
    }
  ) => void,
  'keybase.1.user.loadPublicKeys'?: (
    params: $Exact<{
      sessionID: int,
      uid: UID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userLoadPublicKeysResult) => void
    }
  ) => void,
  'keybase.1.user.listTracking'?: (
    params: $Exact<{
      sessionID: int,
      filter: string,
      assertion: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userListTrackingResult) => void
    }
  ) => void,
  'keybase.1.user.listTrackingJSON'?: (
    params: $Exact<{
      sessionID: int,
      filter: string,
      verbose: boolean,
      assertion: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userListTrackingJSONResult) => void
    }
  ) => void,
  'keybase.1.user.search'?: (
    params: $Exact<{
      sessionID: int,
      query: string
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userSearchResult) => void
    }
  ) => void,
  'keybase.1.user.loadAllPublicKeysUnverified'?: (
    params: $Exact<{
      sessionID: int,
      uid: UID
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userLoadAllPublicKeysUnverifiedResult) => void
    }
  ) => void,
  'keybase.1.user.listTrackers2'?: (
    params: $Exact<{
      sessionID: int,
      assertion: string,
      reverse: bool
    }>,
    response: {
      error: (err: RPCError) => void,
      result: (result: userListTrackers2Result) => void
    }
  ) => void
}>

