// @flow

type KeyType = 'space' | '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' | 'a' | 'add' | 'alt'
  | 'b' | 'back slash' | 'backspace' | 'c' | 'caps lock' | 'close braket' | 'comma' | 'ctrl'
  | 'd' | 'dash' | 'decimal point' | 'delete' | 'divide' | 'down arrow' | 'e' | 'end' | 'enter'
  | 'equal sign' | 'escape' | 'f' | 'f1' | 'f10' | 'f11' | 'f12' | 'f2' | 'f3' | 'f4' | 'f5'
  | 'f6' | 'f7' | 'f8' | 'f9' | 'forward slash' | 'g' | 'grave accent' | 'h' | 'home' | 'i' | 'insert'
  | 'j' | 'k' | 'l' | 'left arrow' | 'left window key' | 'm' | 'multiply' | 'n' | 'num lock' | 'numpad 0'
  | 'numpad 1' | 'numpad 2' | 'numpad 3' | 'numpad 4' | 'numpad 5' | 'numpad 6' | 'numpad 7' | 'numpad 8'
  | 'numpad 9' | 'o' | 'open bracket' | 'p' | 'page down' | 'page up' | 'pause/break' | 'period' | 'q'
  | 'r' | 'right arrow' | 'right window key' | 's' | 'scroll lock' | 'select key' | 'semi-colon'
  | 'shift' | 'single quote' | 'subtract' | 't' | 'tab' | 'u' | 'up arrow' | 'v' | 'w' | 'x' | 'y' | 'z'

const map: {[key:KeyType]: number} = {
  'space': 32,
  '0': 48,
  '1': 49,
  '2': 50,
  '3': 51,
  '4': 52,
  '5': 53,
  '6': 54,
  '7': 55,
  '8': 56,
  '9': 57,
  'a': 65,
  'add': 107,
  'alt': 18,
  'b': 66,
  'back slash': 220,
  'backspace': 8,
  'c': 67,
  'caps lock': 20,
  'close braket': 221,
  'comma': 188,
  'ctrl': 17,
  'd': 68,
  'dash': 189,
  'decimal point': 110,
  'delete': 46,
  'divide': 111,
  'down arrow': 40,
  'e': 69,
  'end': 35,
  'enter': 13,
  'equal sign': 187,
  'escape': 27,
  'f': 70,
  'f1': 112,
  'f10': 121,
  'f11': 122,
  'f12': 123,
  'f2': 113,
  'f3': 114,
  'f4': 115,
  'f5': 116,
  'f6': 117,
  'f7': 118,
  'f8': 119,
  'f9': 120,
  'forward slash': 191,
  'g': 71,
  'grave accent': 192,
  'h': 72,
  'home': 36,
  'i': 73,
  'insert': 45,
  'j': 74,
  'k': 75,
  'l': 76,
  'left arrow': 37,
  'left window key': 91,
  'm': 77,
  'multiply': 106,
  'n': 78,
  'num lock': 144,
  'numpad 0': 96,
  'numpad 1': 97,
  'numpad 2': 98,
  'numpad 3': 99,
  'numpad 4': 100,
  'numpad 5': 101,
  'numpad 6': 102,
  'numpad 7': 103,
  'numpad 8': 104,
  'numpad 9': 105,
  'o': 79,
  'open bracket': 219,
  'p': 80,
  'page down': 34,
  'page up': 33,
  'pause/break': 19,
  'period': 190,
  'q': 81,
  'r': 82,
  'right arrow': 39,
  'right window key': 92,
  's': 83,
  'scroll lock': 145,
  'select key': 93,
  'semi-colon': 186,
  'shift': 16,
  'single quote': 222,
  'subtract': 109,
  't': 84,
  'tab': 9,
  'u': 85,
  'up arrow': 38,
  'v': 86,
  'w': 87,
  'x': 88,
  'y': 89,
  'z': 90
}

export default map
