/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingInt;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingLong;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

@Deprecated
@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
public abstract class MetricsDynamicMBeanBase
implements DynamicMBean {
    private static final String AVG_TIME = "AvgTime";
    private static final String MIN_TIME = "MinTime";
    private static final String MAX_TIME = "MaxTime";
    private static final String NUM_OPS = "NumOps";
    private static final String RESET_ALL_MIN_MAX_OP = "resetAllMinMax";
    private MetricsRegistry metricsRegistry;
    private MBeanInfo mbeanInfo;
    private Map<String, MetricsBase> metricsRateAttributeMod;
    private int numEntriesInRegistry = 0;
    private String mbeanDescription;

    protected MetricsDynamicMBeanBase(MetricsRegistry mr, String aMBeanDescription) {
        this.metricsRegistry = mr;
        this.mbeanDescription = aMBeanDescription;
        this.createMBeanInfo();
    }

    private void updateMbeanInfoIfMetricsListChanged() {
        if (this.numEntriesInRegistry != this.metricsRegistry.size()) {
            this.createMBeanInfo();
        }
    }

    private void createMBeanInfo() {
        this.metricsRateAttributeMod = new HashMap<String, MetricsBase>();
        boolean needsMinMaxResetOperation = false;
        ArrayList<MBeanAttributeInfo> attributesInfo = new ArrayList<MBeanAttributeInfo>();
        MBeanOperationInfo[] operationsInfo = null;
        this.numEntriesInRegistry = this.metricsRegistry.size();
        for (MetricsBase o : this.metricsRegistry.getMetricsList()) {
            if (MetricsTimeVaryingRate.class.isInstance(o)) {
                attributesInfo.add(new MBeanAttributeInfo(o.getName() + NUM_OPS, "java.lang.Integer", o.getDescription(), true, false, false));
                attributesInfo.add(new MBeanAttributeInfo(o.getName() + AVG_TIME, "java.lang.Long", o.getDescription(), true, false, false));
                attributesInfo.add(new MBeanAttributeInfo(o.getName() + MIN_TIME, "java.lang.Long", o.getDescription(), true, false, false));
                attributesInfo.add(new MBeanAttributeInfo(o.getName() + MAX_TIME, "java.lang.Long", o.getDescription(), true, false, false));
                needsMinMaxResetOperation = true;
                this.metricsRateAttributeMod.put(o.getName() + NUM_OPS, o);
                this.metricsRateAttributeMod.put(o.getName() + AVG_TIME, o);
                this.metricsRateAttributeMod.put(o.getName() + MIN_TIME, o);
                this.metricsRateAttributeMod.put(o.getName() + MAX_TIME, o);
            } else if (MetricsIntValue.class.isInstance(o) || MetricsTimeVaryingInt.class.isInstance(o)) {
                attributesInfo.add(new MBeanAttributeInfo(o.getName(), "java.lang.Integer", o.getDescription(), true, false, false));
            } else if (MetricsLongValue.class.isInstance(o) || MetricsTimeVaryingLong.class.isInstance(o)) {
                attributesInfo.add(new MBeanAttributeInfo(o.getName(), "java.lang.Long", o.getDescription(), true, false, false));
            } else {
                MetricsUtil.LOG.error("unknown metrics type: " + o.getClass().getName());
            }
            if (!needsMinMaxResetOperation) continue;
            operationsInfo = new MBeanOperationInfo[]{new MBeanOperationInfo(RESET_ALL_MIN_MAX_OP, "Reset (zero) All Min Max", null, "void", 1)};
        }
        MBeanAttributeInfo[] attrArray = new MBeanAttributeInfo[attributesInfo.size()];
        this.mbeanInfo = new MBeanInfo(this.getClass().getName(), this.mbeanDescription, attributesInfo.toArray(attrArray), null, operationsInfo, null);
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException();
        }
        this.updateMbeanInfoIfMetricsListChanged();
        MetricsBase o = this.metricsRateAttributeMod.get(attributeName);
        if (o == null) {
            o = this.metricsRegistry.get(attributeName);
        }
        if (o == null) {
            throw new AttributeNotFoundException();
        }
        if (o instanceof MetricsIntValue) {
            return ((MetricsIntValue)o).get();
        }
        if (o instanceof MetricsLongValue) {
            return ((MetricsLongValue)o).get();
        }
        if (o instanceof MetricsTimeVaryingInt) {
            return ((MetricsTimeVaryingInt)o).getPreviousIntervalValue();
        }
        if (o instanceof MetricsTimeVaryingLong) {
            return ((MetricsTimeVaryingLong)o).getPreviousIntervalValue();
        }
        if (o instanceof MetricsTimeVaryingRate) {
            MetricsTimeVaryingRate or = (MetricsTimeVaryingRate)o;
            if (attributeName.endsWith(NUM_OPS)) {
                return or.getPreviousIntervalNumOps();
            }
            if (attributeName.endsWith(AVG_TIME)) {
                return or.getPreviousIntervalAverageTime();
            }
            if (attributeName.endsWith(MIN_TIME)) {
                return or.getMinTime();
            }
            if (attributeName.endsWith(MAX_TIME)) {
                return or.getMaxTime();
            }
            MetricsUtil.LOG.error("Unexpected attrubute suffix");
            throw new AttributeNotFoundException();
        }
        MetricsUtil.LOG.error("unknown metrics type: " + o.getClass().getName());
        throw new AttributeNotFoundException();
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null || attributeNames.length == 0) {
            throw new IllegalArgumentException();
        }
        this.updateMbeanInfoIfMetricsListChanged();
        AttributeList result = new AttributeList(attributeNames.length);
        for (String iAttributeName : attributeNames) {
            try {
                Object value = this.getAttribute(iAttributeName);
                result.add(new Attribute(iAttributeName, value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] parms, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException();
        }
        if (!actionName.equals(RESET_ALL_MIN_MAX_OP) || this.mbeanInfo.getOperations().length != 1) {
            throw new ReflectionException(new NoSuchMethodException(actionName));
        }
        for (MetricsBase m : this.metricsRegistry.getMetricsList()) {
            if (!MetricsTimeVaryingRate.class.isInstance(m)) continue;
            ((MetricsTimeVaryingRate)MetricsTimeVaryingRate.class.cast(m)).resetMinMax();
        }
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new ReflectionException(new NoSuchMethodException("set" + attribute));
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }
}

