/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.map;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;

public class MultithreadedMapper<K1, V1, K2, V2>
extends Mapper<K1, V1, K2, V2> {
    private static final Log LOG = LogFactory.getLog(MultithreadedMapper.class);
    private Class<? extends Mapper<K1, V1, K2, V2>> mapClass;
    private Mapper.Context outer;
    private List<MapRunner> runners;

    public static int getNumberOfThreads(JobContext job) {
        return job.getConfiguration().getInt("mapred.map.multithreadedrunner.threads", 10);
    }

    public static void setNumberOfThreads(Job job, int threads) {
        job.getConfiguration().setInt("mapred.map.multithreadedrunner.threads", threads);
    }

    public static <K1, V1, K2, V2> Class<Mapper<K1, V1, K2, V2>> getMapperClass(JobContext job) {
        return job.getConfiguration().getClass("mapred.map.multithreadedrunner.class", Mapper.class);
    }

    public static <K1, V1, K2, V2> void setMapperClass(Job job, Class<? extends Mapper<K1, V1, K2, V2>> cls) {
        if (MultithreadedMapper.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Can't have recursive MultithreadedMapper instances.");
        }
        job.getConfiguration().setClass("mapred.map.multithreadedrunner.class", cls, Mapper.class);
    }

    @Override
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        MapRunner thread;
        int i;
        this.outer = context;
        int numberOfThreads = MultithreadedMapper.getNumberOfThreads(context);
        this.mapClass = MultithreadedMapper.getMapperClass(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring multithread runner to use " + numberOfThreads + " threads");
        }
        this.runners = new ArrayList<MapRunner>(numberOfThreads);
        for (i = 0; i < numberOfThreads; ++i) {
            thread = new MapRunner(context);
            thread.start();
            this.runners.add(i, thread);
        }
        for (i = 0; i < numberOfThreads; ++i) {
            thread = this.runners.get(i);
            thread.join();
            Throwable th = thread.throwable;
            if (th == null) continue;
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof InterruptedException) {
                throw (InterruptedException)th;
            }
            throw new RuntimeException(th);
        }
    }

    private class MapRunner
    extends Thread {
        private Mapper<K1, V1, K2, V2> mapper;
        private Mapper.Context subcontext;
        private Throwable throwable;

        MapRunner(Mapper.Context context) throws IOException, InterruptedException {
            this.mapper = (Mapper)ReflectionUtils.newInstance(MultithreadedMapper.this.mapClass, context.getConfiguration());
            this.subcontext = new Mapper.Context(MultithreadedMapper.this.outer.getConfiguration(), MultithreadedMapper.this.outer.getTaskAttemptID(), new SubMapRecordReader(), new SubMapRecordWriter(), context.getOutputCommitter(), new SubMapStatusReporter(), MultithreadedMapper.this.outer.getInputSplit());
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public void run() {
            try {
                this.mapper.run(this.subcontext);
            }
            catch (Throwable ie) {
                this.throwable = ie;
            }
        }
    }

    private class SubMapStatusReporter
    extends StatusReporter {
        private SubMapStatusReporter() {
        }

        @Override
        public Counter getCounter(Enum<?> name) {
            return MultithreadedMapper.this.outer.getCounter(name);
        }

        @Override
        public Counter getCounter(String group, String name) {
            return MultithreadedMapper.this.outer.getCounter(group, name);
        }

        @Override
        public void progress() {
            MultithreadedMapper.this.outer.progress();
        }

        @Override
        public void setStatus(String status) {
            MultithreadedMapper.this.outer.setStatus(status);
        }
    }

    private class SubMapRecordWriter
    extends RecordWriter<K2, V2> {
        private SubMapRecordWriter() {
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(K2 key, V2 value) throws IOException, InterruptedException {
            Mapper.Context context = MultithreadedMapper.this.outer;
            synchronized (context) {
                MultithreadedMapper.this.outer.write(key, value);
            }
        }
    }

    private class SubMapRecordReader
    extends RecordReader<K1, V1> {
        private K1 key;
        private V1 value;
        private Configuration conf;

        private SubMapRecordReader() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        @Override
        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.conf = context.getConfiguration();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean nextKeyValue() throws IOException, InterruptedException {
            Mapper.Context context = MultithreadedMapper.this.outer;
            synchronized (context) {
                if (!MultithreadedMapper.this.outer.nextKeyValue()) {
                    return false;
                }
                this.key = ReflectionUtils.copy(MultithreadedMapper.this.outer.getConfiguration(), MultithreadedMapper.this.outer.getCurrentKey(), this.key);
                this.value = ReflectionUtils.copy(this.conf, MultithreadedMapper.this.outer.getCurrentValue(), this.value);
                return true;
            }
        }

        @Override
        public K1 getCurrentKey() {
            return this.key;
        }

        @Override
        public V1 getCurrentValue() {
            return this.value;
        }
    }
}

