/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import org.apache.avro.mapred.AvroCollector;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroReducer;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.HadoopReducerBase;
import org.apache.avro.mapred.Pair;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.util.ReflectionUtils;

class HadoopCombiner<K, V>
extends HadoopReducerBase<K, V, Pair<K, V>, AvroKey<K>, AvroValue<V>> {
    HadoopCombiner() {
    }

    @Override
    protected AvroReducer<K, V, Pair<K, V>> getReducer(JobConf conf) {
        return ReflectionUtils.newInstance(conf.getClass("avro.combiner", AvroReducer.class, AvroReducer.class), conf);
    }

    @Override
    protected AvroCollector<Pair<K, V>> getCollector(OutputCollector<AvroKey<K>, AvroValue<V>> collector) {
        return new PairCollector(collector);
    }

    private class PairCollector
    extends AvroCollector<Pair<K, V>> {
        private final AvroKey<K> keyWrapper = new AvroKey<Object>(null);
        private final AvroValue<V> valueWrapper = new AvroValue<Object>(null);
        private OutputCollector<AvroKey<K>, AvroValue<V>> collector;

        public PairCollector(OutputCollector<AvroKey<K>, AvroValue<V>> collector) {
            this.collector = collector;
        }

        @Override
        public void collect(Pair<K, V> datum) throws IOException {
            this.keyWrapper.datum(datum.key());
            this.valueWrapper.datum(datum.value());
            this.collector.collect(this.keyWrapper, this.valueWrapper);
        }
    }
}

