/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.avro.FooBarSpecificRecord;
import org.apache.avro.Schema;
import org.apache.avro.TypeEnum;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.io.ValidatingDecoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;

public class Perf {
    private static final int COUNT = 250000;
    private static final int CYCLES = 800;
    private static final long SEED = 19781210L;
    private static final List<TestDescriptor> BASIC = new ArrayList<TestDescriptor>();
    private static final List<TestDescriptor> RECORD = new ArrayList<TestDescriptor>();
    private static final List<TestDescriptor> GENERIC = new ArrayList<TestDescriptor>();
    private static final List<TestDescriptor> GENERIC_ONETIME = new ArrayList<TestDescriptor>();
    private static final List<TestDescriptor> SPECIFIC = new ArrayList<TestDescriptor>();
    private static final List<TestDescriptor> REFLECT = new ArrayList<TestDescriptor>();
    private static final LinkedHashMap<String, TestDescriptor> ALL_TESTS = new LinkedHashMap();
    private static final LinkedHashMap<String, List<TestDescriptor>> BATCHES = new LinkedHashMap();
    private static final String RECORD_SCHEMA = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }";
    private static final String NESTED_RECORD_SCHEMA = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \n{ \"type\": \"record\", \"name\": \"D\", \"fields\": [\n{\"name\": \"dbl\", \"type\": \"double\" }]\n} },\n{ \"name\": \"f2\", \"type\": \"D\" },\n{ \"name\": \"f3\", \"type\": \"D\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }";
    private static final String RECORD_SCHEMA_WITH_DEFAULT = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" },\n{ \"name\": \"f7\", \"type\": \"string\", \"default\": \"undefined\" },\n{ \"name\": \"f8\", \"type\": \"string\",\"default\": \"undefined\" }\n] }";
    private static final String RECORD_SCHEMA_WITH_OUT_OF_ORDER = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }";
    private static final String RECORD_SCHEMA_WITH_PROMOTION = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"long\" },\n{ \"name\": \"f5\", \"type\": \"long\" },\n{ \"name\": \"f6\", \"type\": \"long\" }\n] }";
    private static final String GENERIC_STRINGS = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"string\" },\n{ \"name\": \"f2\", \"type\": \"string\" },\n{ \"name\": \"f3\", \"type\": \"string\" }\n] }";

    protected static Random newRandom() {
        return new Random(19781210L);
    }

    private static void usage() {
        StringBuilder usage = new StringBuilder("Usage: Perf { -nowrite | -noread | ");
        StringBuilder details = new StringBuilder();
        details.append(" -nowrite   (do not execute write tests)\n");
        details.append(" -noread   (do not execute write tests)\n");
        for (Map.Entry<String, List<TestDescriptor>> entry : BATCHES.entrySet()) {
            List<TestDescriptor> lt = entry.getValue();
            String param = entry.getKey();
            String paramName = param.substring(1);
            usage.append(param).append(" | ");
            details.append(" ").append(param).append("   (executes all ").append(paramName).append(" tests):\n");
            for (TestDescriptor t : lt) {
                usage.append(t.param).append(" | ");
                details.append("      ").append(t.param).append("  (").append(t.test.getSimpleName()).append(")\n");
            }
        }
        usage.setLength(usage.length() - 2);
        usage.append("}\n");
        System.out.println(usage.toString());
        System.out.print(details.toString());
    }

    public static void main(String[] args) throws Exception {
        int k;
        ArrayList<Test> tests = new ArrayList<Test>();
        boolean writeTests = true;
        boolean readTests = true;
        for (String a : args) {
            TestDescriptor t = ALL_TESTS.get(a);
            if (null != t) {
                tests.add(t.test.newInstance());
                continue;
            }
            List<TestDescriptor> lt = BATCHES.get(a);
            if (null != lt) {
                for (TestDescriptor td : lt) {
                    tests.add(td.test.newInstance());
                }
                continue;
            }
            if ("-nowrite".equals(a)) {
                writeTests = false;
                continue;
            }
            if ("-noread".equals(a)) {
                readTests = false;
                continue;
            }
            Perf.usage();
            System.exit(1);
        }
        if (tests.isEmpty()) {
            for (Map.Entry<String, TestDescriptor> entry : ALL_TESTS.entrySet()) {
                TestDescriptor t = entry.getValue();
                Test test = t.test.newInstance();
                tests.add(test);
            }
        }
        System.out.println("Executing tests: \n" + tests + "\n readTests:" + readTests + "\n writeTests:" + writeTests + "\n cycles=" + 800);
        for (k = 0; k < tests.size(); ++k) {
            Test t = (Test)tests.get(k);
            try {
                t.init();
                if (t.isReadTest()) {
                    t.readTest();
                }
                if (t.isWriteTest()) {
                    t.writeTest();
                }
                t.reset();
                continue;
            }
            catch (Exception e) {
                System.out.println("Failed to execute test: " + t.getClass().getSimpleName());
                throw e;
            }
        }
        Perf.printHeader();
        for (k = 0; k < tests.size(); ++k) {
            int i;
            int i2;
            Test t = (Test)tests.get(k);
            t.init();
            if (t.isReadTest() && readTests) {
                for (i2 = 0; i2 < t.cycles / 2; ++i2) {
                    t.readTest();
                }
            }
            if (t.isWriteTest() && writeTests) {
                for (i2 = 0; i2 < t.cycles / 2; ++i2) {
                    t.writeTest();
                }
            }
            t.reset();
            long s = 0L;
            System.gc();
            t.init();
            if (t.isReadTest() && readTests) {
                for (i = 0; i < t.cycles; ++i) {
                    s += t.readTest();
                }
                Perf.printResult(s, t, t.name + "Read");
            }
            s = 0L;
            if (t.isWriteTest() && writeTests) {
                for (i = 0; i < t.cycles; ++i) {
                    s += t.writeTest();
                }
                Perf.printResult(s, t, t.name + "Write");
            }
            t.reset();
        }
    }

    private static final void printHeader() {
        String header = String.format("%60s     time    M entries/sec   M bytes/sec  bytes/cycle", "test name");
        System.out.println(header.toString());
    }

    private static final void printResult(long s, Test t, String name) {
        double entries = (double)t.cycles * (double)t.count;
        double bytes = (double)t.cycles * (double)t.encodedSize;
        StringBuilder result = new StringBuilder();
        result.append(String.format("%42s: %6d ms  ", name, (s /= 1000L) / 1000L));
        result.append(String.format("%10.3f   %11.3f   %11d", entries / (double)s, bytes / (double)s, t.encodedSize));
        System.out.println(result.toString());
    }

    private static String randomString(Random r) {
        char[] data = new char[r.nextInt(70)];
        for (int j = 0; j < data.length; ++j) {
            data[j] = (char)(97 + r.nextInt(25));
        }
        return new String(data);
    }

    static GenericRecord[] generateGenericNested(Schema schema, int count) {
        Random r = Perf.newRandom();
        GenericRecord[] sourceData = new GenericRecord[count];
        Schema doubleSchema = schema.getFields().get(0).schema();
        for (int i = 0; i < sourceData.length; ++i) {
            GenericData.Record rec = new GenericData.Record(schema);
            GenericData.Record inner = new GenericData.Record(doubleSchema);
            inner.put(0, (Object)r.nextDouble());
            rec.put(0, (Object)inner);
            inner = new GenericData.Record(doubleSchema);
            inner.put(0, (Object)r.nextDouble());
            rec.put(1, (Object)inner);
            inner = new GenericData.Record(doubleSchema);
            inner.put(0, (Object)r.nextDouble());
            rec.put(2, (Object)inner);
            rec.put(3, (Object)r.nextInt());
            rec.put(4, (Object)r.nextInt());
            rec.put(5, (Object)r.nextInt());
            sourceData[i] = rec;
        }
        return sourceData;
    }

    private static int smallArraySize(Random r) {
        return r.nextInt(15) + 1;
    }

    private static int largeArraySize(Random r) {
        return r.nextInt(97) + 16;
    }

    static float[] populateFloatArray(Random r, boolean large) {
        int size = large ? Perf.largeArraySize(r) : Perf.smallArraySize(r);
        return Perf.populateFloatArray(r, size);
    }

    static float[] populateFloatArray(Random r, int size) {
        float[] result = new float[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = r.nextFloat();
        }
        return result;
    }

    static double[] populateDoubleArray(Random r) {
        return Perf.populateDoubleArray(r, Perf.smallArraySize(r));
    }

    static double[] populateDoubleArray(Random r, int size) {
        double[] result = new double[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = r.nextDouble();
        }
        return result;
    }

    static int[] populateIntArray(Random r) {
        int size = Perf.smallArraySize(r);
        int[] result = new int[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = r.nextInt();
        }
        return result;
    }

    static long[] populateLongArray(Random r) {
        int size = Perf.smallArraySize(r);
        long[] result = new long[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = r.nextLong();
        }
        return result;
    }

    static {
        BATCHES.put("-basic", BASIC);
        new TestDescriptor(IntTest.class, "-i").add(BASIC);
        new TestDescriptor(SmallLongTest.class, "-ls").add(BASIC);
        new TestDescriptor(LongTest.class, "-l").add(BASIC);
        new TestDescriptor(FloatTest.class, "-f").add(BASIC);
        new TestDescriptor(DoubleTest.class, "-d").add(BASIC);
        new TestDescriptor(BoolTest.class, "-b").add(BASIC);
        new TestDescriptor(BytesTest.class, "-by").add(BASIC);
        new TestDescriptor(StringTest.class, "-s").add(BASIC);
        new TestDescriptor(ArrayTest.class, "-a").add(BASIC);
        new TestDescriptor(MapTest.class, "-m").add(BASIC);
        BATCHES.put("-record", RECORD);
        new TestDescriptor(RecordTest.class, "-R").add(RECORD);
        new TestDescriptor(ValidatingRecord.class, "-Rv").add(RECORD);
        new TestDescriptor(ResolvingRecord.class, "-Rr").add(RECORD);
        new TestDescriptor(RecordWithDefault.class, "-Rd").add(RECORD);
        new TestDescriptor(RecordWithOutOfOrder.class, "-Ro").add(RECORD);
        new TestDescriptor(RecordWithPromotion.class, "-Rp").add(RECORD);
        BATCHES.put("-generic", GENERIC);
        new TestDescriptor(GenericTest.class, "-G").add(GENERIC);
        new TestDescriptor(GenericStrings.class, "-Gs").add(GENERIC);
        new TestDescriptor(GenericNested.class, "-Gn").add(GENERIC);
        new TestDescriptor(GenericNestedFake.class, "-Gf").add(GENERIC);
        new TestDescriptor(GenericWithDefault.class, "-Gd").add(GENERIC);
        new TestDescriptor(GenericWithOutOfOrder.class, "-Go").add(GENERIC);
        new TestDescriptor(GenericWithPromotion.class, "-Gp").add(GENERIC);
        BATCHES.put("-generic-onetime", GENERIC_ONETIME);
        new TestDescriptor(GenericOneTimeDecoderUse.class, "-Gotd").add(GENERIC_ONETIME);
        new TestDescriptor(GenericOneTimeReaderUse.class, "-Gotr").add(GENERIC_ONETIME);
        new TestDescriptor(GenericOneTimeUse.class, "-Got").add(GENERIC_ONETIME);
        new TestDescriptor(FooBarSpecificRecordTest.class, "-Sf").add(SPECIFIC);
        BATCHES.put("-reflect", REFLECT);
        new TestDescriptor(ReflectRecordTest.class, "-REFr").add(REFLECT);
        new TestDescriptor(ReflectBigRecordTest.class, "-REFbr").add(REFLECT);
        new TestDescriptor(ReflectFloatTest.class, "-REFf").add(REFLECT);
        new TestDescriptor(ReflectDoubleTest.class, "-REFd").add(REFLECT);
        new TestDescriptor(ReflectIntArrayTest.class, "-REFia").add(REFLECT);
        new TestDescriptor(ReflectLongArrayTest.class, "-REFla").add(REFLECT);
        new TestDescriptor(ReflectDoubleArrayTest.class, "-REFda").add(REFLECT);
        new TestDescriptor(ReflectFloatArrayTest.class, "-REFfa").add(REFLECT);
        new TestDescriptor(ReflectNestedFloatArrayTest.class, "-REFnf").add(REFLECT);
        new TestDescriptor(ReflectNestedObjectArrayTest.class, "-REFno").add(REFLECT);
        new TestDescriptor(ReflectNestedLargeFloatArrayTest.class, "-REFnlf").add(REFLECT);
        new TestDescriptor(ReflectNestedLargeFloatArrayBlockedTest.class, "-REFnlfb").add(REFLECT);
    }

    static class ReflectBigRecordTest
    extends ReflectTest<Rec1> {
        public ReflectBigRecordTest() throws IOException {
            super("ReflectBigRecord", new Rec1(new Random()), 20);
        }

        @Override
        protected Rec1 createDatum(Random r) {
            return new Rec1(r);
        }
    }

    private static class Rec1 {
        double d1;
        double d11;
        float f2;
        float f22;
        int f3;
        int f33;
        long f4;
        long f44;
        byte f5;
        byte f55;
        short f6;
        short f66;

        Rec1() {
        }

        Rec1(Random r) {
            this.d1 = r.nextDouble();
            this.d11 = r.nextDouble();
            this.f2 = r.nextFloat();
            this.f22 = r.nextFloat();
            this.f3 = r.nextInt();
            this.f33 = r.nextInt();
            this.f4 = r.nextLong();
            this.f44 = r.nextLong();
            this.f5 = (byte)r.nextInt();
            this.f55 = (byte)r.nextInt();
            this.f6 = (short)r.nextInt();
            this.f66 = (short)r.nextInt();
        }
    }

    static class ReflectNestedLargeFloatArrayBlockedTest
    extends ReflectTest<FloatFoo> {
        public ReflectNestedLargeFloatArrayBlockedTest() throws IOException {
            super("ReflectNestedLargeFloatArrayBlocked", new FloatFoo(new Random(), true), 60);
        }

        @Override
        protected FloatFoo createDatum(Random r) {
            return new FloatFoo(r, true);
        }

        @Override
        protected Encoder newEncoder(ByteArrayOutputStream out) throws IOException {
            return new EncoderFactory().configureBlockSize(254).blockingBinaryEncoder(out, null);
        }
    }

    static class ReflectNestedLargeFloatArrayTest
    extends ReflectTest<FloatFoo> {
        public ReflectNestedLargeFloatArrayTest() throws IOException {
            super("ReflectNestedLargeFloatArray", new FloatFoo(new Random(), true), 60);
        }

        @Override
        protected FloatFoo createDatum(Random r) {
            return new FloatFoo(r, true);
        }
    }

    static class ReflectNestedFloatArrayTest
    extends ReflectTest<FloatFoo> {
        public ReflectNestedFloatArrayTest() throws IOException {
            super("ReflectNestedFloatArray", new FloatFoo(new Random(), false), 10);
        }

        @Override
        protected FloatFoo createDatum(Random r) {
            return new FloatFoo(r, false);
        }
    }

    public static class FloatFoo {
        float[] floatBar;

        FloatFoo() {
        }

        FloatFoo(Random r, boolean large) {
            this.floatBar = Perf.populateFloatArray(r, large);
        }
    }

    static class ReflectNestedObjectArrayTest
    extends ReflectTest<Foo> {
        ReflectNestedObjectArrayTest() throws IOException {
            super("ReflectNestedObjectArray", new Foo(new Random()), 50);
        }

        @Override
        protected Foo createDatum(Random r) {
            return new Foo(r);
        }

        static class Vals {
            float f1;
            float f2;
            float f3;
            float f4;

            Vals() {
            }

            Vals(Random r) {
                this.f1 = r.nextFloat();
                this.f2 = r.nextFloat();
                this.f3 = r.nextFloat();
                this.f4 = r.nextFloat();
            }
        }

        public static class Foo {
            Vals[] bar;

            Foo() {
            }

            Foo(Random r) {
                this.bar = new Vals[Perf.smallArraySize(r)];
                for (int i = 0; i < this.bar.length; ++i) {
                    this.bar[i] = new Vals(r);
                }
            }
        }
    }

    static class ReflectLongArrayTest
    extends ReflectTest<long[]> {
        ReflectLongArrayTest() throws IOException {
            super("ReflectLongArray", new long[0], 24);
        }

        @Override
        protected long[] createDatum(Random r) {
            return Perf.populateLongArray(r);
        }
    }

    static class ReflectIntArrayTest
    extends ReflectTest<int[]> {
        ReflectIntArrayTest() throws IOException {
            super("ReflectIntArray", new int[0], 12);
        }

        @Override
        protected int[] createDatum(Random r) {
            return Perf.populateIntArray(r);
        }
    }

    static class ReflectDoubleArrayTest
    extends ReflectTest<double[]> {
        ReflectDoubleArrayTest() throws IOException {
            super("ReflectDoubleArray", new double[0], 20);
        }

        @Override
        protected double[] createDatum(Random r) {
            return Perf.populateDoubleArray(r);
        }
    }

    static class ReflectFloatArrayTest
    extends ReflectTest<float[]> {
        ReflectFloatArrayTest() throws IOException {
            super("ReflectFloatArray", new float[0], 10);
        }

        @Override
        protected float[] createDatum(Random r) {
            return Perf.populateFloatArray(r, false);
        }
    }

    static class ReflectDoubleTest
    extends ReflectTest<double[]> {
        ReflectDoubleTest() throws IOException {
            super("ReflectDouble", new double[0], 250000);
        }

        @Override
        protected double[] createDatum(Random r) {
            return Perf.populateDoubleArray(r, 250000 / this.count);
        }
    }

    static class ReflectFloatTest
    extends ReflectTest<float[]> {
        ReflectFloatTest() throws IOException {
            super("ReflectFloat", new float[0], 250000);
        }

        @Override
        protected float[] createDatum(Random r) {
            return Perf.populateFloatArray(r, 250000 / this.count);
        }
    }

    static class ReflectRecordTest
    extends ReflectTest<Rec> {
        ReflectRecordTest() throws IOException {
            super("ReflectRecord", new Rec(), 12);
        }

        @Override
        protected Rec createDatum(Random r) {
            return new Rec(r);
        }
    }

    static abstract class ReflectTest<T>
    extends BasicTest {
        T[] sourceData = null;
        ReflectDatumReader<T> reader;
        ReflectDatumWriter<T> writer;
        Class<T> clazz;

        ReflectTest(String name, T sample, int factor) throws IOException {
            super(name, ReflectData.get().getSchema(sample.getClass()).toString(), factor);
            this.clazz = sample.getClass();
            this.reader = new ReflectDatumReader(this.schema);
            this.writer = new ReflectDatumWriter(this.schema);
        }

        @Override
        protected final void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = (Object[])Array.newInstance(this.clazz, this.count);
            for (int i = 0; i < this.sourceData.length; ++i) {
                this.sourceData[i] = this.createDatum(r);
            }
        }

        protected abstract T createDatum(Random var1);

        @Override
        protected final void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count; ++i) {
                this.reader.read(null, d);
            }
        }

        @Override
        protected final void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; ++i) {
                this.writer.write(this.sourceData[i], e);
            }
        }

        @Override
        protected final void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    static class FooBarSpecificRecordTest
    extends SpecificTest<FooBarSpecificRecord> {
        public FooBarSpecificRecordTest() throws IOException {
            super("FooBarSpecificRecordTest", FooBarSpecificRecord.SCHEMA$.toString());
        }

        @Override
        protected FooBarSpecificRecord genSingleRecord(Random r) {
            TypeEnum[] typeEnums = TypeEnum.values();
            ArrayList<Integer> relatedIds = new ArrayList<Integer>(10);
            for (int i = 0; i < 10; ++i) {
                relatedIds.add(r.nextInt());
            }
            try {
                return FooBarSpecificRecord.newBuilder().setId(r.nextInt()).setName(Perf.randomString(r)).setNicknames(Arrays.asList(Perf.randomString(r), Perf.randomString(r))).setTypeEnum(typeEnums[r.nextInt(typeEnums.length)]).setRelatedids(relatedIds).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static abstract class SpecificTest<T extends SpecificRecordBase>
    extends BasicTest {
        protected final SpecificDatumReader<T> reader = this.newReader();
        protected final SpecificDatumWriter<T> writer = this.newWriter();
        private Object[] sourceData;

        protected SpecificTest(String name, String writerSchema) throws IOException {
            super(name, writerSchema, 48);
        }

        protected SpecificDatumReader<T> getReader() {
            return this.reader;
        }

        protected SpecificDatumWriter<T> getWriter() {
            return this.writer;
        }

        protected SpecificDatumReader<T> newReader() {
            return new SpecificDatumReader(this.schema);
        }

        protected SpecificDatumWriter<T> newWriter() {
            return new SpecificDatumWriter(this.schema);
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new Object[this.count];
            for (int i = 0; i < this.sourceData.length; ++i) {
                this.sourceData[i] = this.genSingleRecord(r);
            }
        }

        protected abstract T genSingleRecord(Random var1);

        @Override
        void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count; ++i) {
                this.getReader().read(null, d);
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; ++i) {
                SpecificRecordBase rec = (SpecificRecordBase)this.sourceData[i];
                this.getWriter().write(rec, e);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    static class GenericOneTimeUse
    extends GenericTest {
        public GenericOneTimeUse() throws IOException {
            super("GenericOneTimeUse_");
            this.isWriteTest = false;
        }

        @Override
        protected GenericDatumReader<Object> getReader() {
            return this.newReader();
        }

        @Override
        protected Decoder getDecoder() {
            return this.newDecoder();
        }
    }

    static class GenericOneTimeReaderUse
    extends GenericTest {
        public GenericOneTimeReaderUse() throws IOException {
            super("GenericOneTimeReaderUse_");
            this.isWriteTest = false;
        }

        @Override
        protected GenericDatumReader<Object> getReader() {
            return this.newReader();
        }
    }

    static class GenericOneTimeDecoderUse
    extends GenericTest {
        public GenericOneTimeDecoderUse() throws IOException {
            super("GenericOneTimeDecoderUse_");
            this.isWriteTest = false;
        }

        @Override
        protected Decoder getDecoder() {
            return this.newDecoder();
        }
    }

    static class GenericWithPromotion
    extends GenericResolving {
        GenericWithPromotion() throws IOException {
            super("GenericWithPromotion_");
        }

        @Override
        protected Schema getReaderSchema() {
            return new Schema.Parser().parse(Perf.RECORD_SCHEMA_WITH_PROMOTION);
        }
    }

    static class GenericWithOutOfOrder
    extends GenericResolving {
        GenericWithOutOfOrder() throws IOException {
            super("GenericWithOutOfOrder_");
        }

        @Override
        protected Schema getReaderSchema() {
            return new Schema.Parser().parse(Perf.RECORD_SCHEMA_WITH_OUT_OF_ORDER);
        }
    }

    static class GenericWithDefault
    extends GenericResolving {
        GenericWithDefault() throws IOException {
            super("GenericWithDefault_");
        }

        @Override
        protected Schema getReaderSchema() {
            return new Schema.Parser().parse(Perf.RECORD_SCHEMA_WITH_DEFAULT);
        }
    }

    private static abstract class GenericResolving
    extends GenericTest {
        protected GenericResolving(String name) throws IOException {
            super(name);
            this.isWriteTest = false;
        }

        @Override
        protected GenericDatumReader<Object> newReader() {
            return new GenericDatumReader<Object>(this.schema, this.getReaderSchema());
        }

        protected abstract Schema getReaderSchema();
    }

    static class GenericNestedFake
    extends BasicTest {
        GenericRecord[] sourceData = null;

        public GenericNestedFake() throws IOException {
            super("GenericNestedFake_", Perf.NESTED_RECORD_SCHEMA, 12);
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            Schema doubleSchema = this.schema.getFields().get(0).schema();
            for (int i = 0; i < this.count; ++i) {
                GenericData.Record rec = new GenericData.Record(this.schema);
                GenericData.Record inner = new GenericData.Record(doubleSchema);
                inner.put(0, (Object)d.readDouble());
                rec.put(0, (Object)inner);
                inner = new GenericData.Record(doubleSchema);
                inner.put(0, (Object)d.readDouble());
                rec.put(1, (Object)inner);
                inner = new GenericData.Record(doubleSchema);
                inner.put(0, (Object)d.readDouble());
                rec.put(2, (Object)inner);
                rec.put(3, (Object)d.readInt());
                rec.put(4, (Object)d.readInt());
                rec.put(5, (Object)d.readInt());
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; ++i) {
                GenericRecord rec = this.sourceData[i];
                GenericRecord inner = (GenericRecord)rec.get(0);
                e.writeDouble((Double)inner.get(0));
                inner = (GenericRecord)rec.get(1);
                e.writeDouble((Double)inner.get(0));
                inner = (GenericRecord)rec.get(2);
                e.writeDouble((Double)inner.get(0));
                e.writeInt((Integer)rec.get(3));
                e.writeInt((Integer)rec.get(4));
                e.writeInt((Integer)rec.get(5));
            }
        }

        @Override
        void genSourceData() {
            this.sourceData = Perf.generateGenericNested(this.schema, this.count);
        }

        @Override
        void reset() {
            this.data = null;
            this.sourceData = null;
        }
    }

    static class GenericNested
    extends GenericTest {
        public GenericNested() throws IOException {
            super("GenericNested_", Perf.NESTED_RECORD_SCHEMA);
        }

        @Override
        void genSourceData() {
            this.sourceData = Perf.generateGenericNested(this.schema, this.count);
        }
    }

    static class GenericStrings
    extends GenericTest {
        public GenericStrings() throws IOException {
            super("GenericStrings", Perf.GENERIC_STRINGS);
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new GenericRecord[this.count];
            for (int i = 0; i < this.sourceData.length; ++i) {
                GenericData.Record rec = new GenericData.Record(this.schema);
                rec.put(0, (Object)Perf.randomString(r));
                rec.put(1, (Object)Perf.randomString(r));
                rec.put(2, (Object)Perf.randomString(r));
                this.sourceData[i] = rec;
            }
        }
    }

    static class GenericTest
    extends BasicTest {
        GenericRecord[] sourceData = null;
        protected final GenericDatumReader<Object> reader = this.newReader();

        public GenericTest() throws IOException {
            this("Generic");
        }

        protected GenericTest(String name) throws IOException {
            this(name, Perf.RECORD_SCHEMA);
        }

        protected GenericTest(String name, String writerSchema) throws IOException {
            super(name, writerSchema, 12);
        }

        protected GenericDatumReader<Object> getReader() {
            return this.reader;
        }

        protected GenericDatumReader<Object> newReader() {
            return new GenericDatumReader<Object>(this.schema);
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new GenericRecord[this.count];
            for (int i = 0; i < this.sourceData.length; ++i) {
                GenericData.Record rec = new GenericData.Record(this.schema);
                rec.put(0, (Object)r.nextDouble());
                rec.put(1, (Object)r.nextDouble());
                rec.put(2, (Object)r.nextDouble());
                rec.put(3, (Object)r.nextInt());
                rec.put(4, (Object)r.nextInt());
                rec.put(5, (Object)r.nextInt());
                this.sourceData[i] = rec;
            }
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count; ++i) {
                this.getReader().read(null, d);
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            GenericDatumWriter<GenericRecord> writer = new GenericDatumWriter<GenericRecord>(this.schema);
            for (int i = 0; i < this.sourceData.length; ++i) {
                GenericRecord rec = this.sourceData[i];
                writer.write(rec, e);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    static class RecordWithPromotion
    extends RecordTest {
        private final Schema readerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"long\" },\n{ \"name\": \"f5\", \"type\": \"long\" },\n{ \"name\": \"f6\", \"type\": \"long\" }\n] }");

        public RecordWithPromotion() throws IOException {
            super("RecordWithPromotion");
            this.isWriteTest = false;
        }

        @Override
        protected Decoder getDecoder() throws IOException {
            return new ResolvingDecoder(this.schema, this.readerSchema, super.getDecoder());
        }

        @Override
        protected void readInternal(Decoder d) throws IOException {
            ResolvingDecoder r = (ResolvingDecoder)d;
            Schema.Field[] ff = r.readFieldOrder();
            for (int i = 0; i < this.count; ++i) {
                block5: for (int j = 0; j < ff.length; ++j) {
                    Schema.Field f = ff[j];
                    switch (f.pos()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            r.readDouble();
                            continue block5;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            r.readLong();
                        }
                    }
                }
            }
        }
    }

    static class RecordWithOutOfOrder
    extends RecordTest {
        private final Schema readerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }");

        public RecordWithOutOfOrder() throws IOException {
            super("RecordWithOutOfOrder");
            this.isWriteTest = false;
        }

        @Override
        protected Decoder getDecoder() throws IOException {
            return new ResolvingDecoder(this.schema, this.readerSchema, super.getDecoder());
        }

        @Override
        protected void readInternal(Decoder d) throws IOException {
            ResolvingDecoder r = (ResolvingDecoder)d;
            Schema.Field[] ff = r.readFieldOrder();
            for (int i = 0; i < this.count; ++i) {
                block5: for (int j = 0; j < ff.length; ++j) {
                    Schema.Field f = ff[j];
                    switch (f.pos()) {
                        case 0: 
                        case 1: 
                        case 3: {
                            r.readDouble();
                            continue block5;
                        }
                        case 2: 
                        case 4: 
                        case 5: {
                            r.readInt();
                        }
                    }
                }
            }
        }
    }

    static class RecordWithDefault
    extends RecordTest {
        private final Schema readerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" },\n{ \"name\": \"f7\", \"type\": \"string\", \"default\": \"undefined\" },\n{ \"name\": \"f8\", \"type\": \"string\",\"default\": \"undefined\" }\n] }");

        public RecordWithDefault() throws IOException {
            super("RecordWithDefault");
            this.isWriteTest = false;
        }

        @Override
        protected Decoder getDecoder() throws IOException {
            return new ResolvingDecoder(this.schema, this.readerSchema, super.getDecoder());
        }

        @Override
        protected void readInternal(Decoder d) throws IOException {
            ResolvingDecoder r = (ResolvingDecoder)d;
            Schema.Field[] ff = r.readFieldOrder();
            for (int i = 0; i < this.count; ++i) {
                block6: for (int j = 0; j < ff.length; ++j) {
                    Schema.Field f = ff[j];
                    switch (f.pos()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            r.readDouble();
                            continue block6;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            r.readInt();
                            continue block6;
                        }
                        case 6: 
                        case 7: {
                            r.readString(null);
                        }
                    }
                }
            }
        }
    }

    static class ResolvingRecord
    extends RecordTest {
        public ResolvingRecord() throws IOException {
            super("ResolvingRecord");
            this.isWriteTest = false;
        }

        @Override
        protected Decoder getDecoder() throws IOException {
            return new ResolvingDecoder(this.schema, this.schema, super.getDecoder());
        }
    }

    static class ValidatingRecord
    extends RecordTest {
        ValidatingRecord() throws IOException {
            super("ValidatingRecord");
        }

        @Override
        protected Decoder getDecoder() throws IOException {
            return new ValidatingDecoder(this.schema, super.getDecoder());
        }

        @Override
        protected Encoder newEncoder(ByteArrayOutputStream out) throws IOException {
            return encoder_factory.validatingEncoder(this.schema, super.newEncoder(out));
        }
    }

    static class RecordTest
    extends BasicTest {
        Rec[] sourceData = null;

        public RecordTest() throws IOException {
            this("Record");
        }

        public RecordTest(String name) throws IOException {
            super(name, Perf.RECORD_SCHEMA, 6);
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new Rec[this.count];
            for (int i = 0; i < this.sourceData.length; ++i) {
                this.sourceData[i] = new Rec(r);
            }
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count; ++i) {
                d.readDouble();
                d.readDouble();
                d.readDouble();
                d.readInt();
                d.readInt();
                d.readInt();
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; ++i) {
                Rec r = this.sourceData[i];
                e.writeDouble(r.f1);
                e.writeDouble(r.f2);
                e.writeDouble(r.f3);
                e.writeInt(r.f4);
                e.writeInt(r.f5);
                e.writeInt(r.f6);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    private static class Rec {
        double f1;
        double f2;
        double f3;
        int f4;
        int f5;
        int f6;

        Rec() {
        }

        Rec(Random r) {
            this.f1 = r.nextDouble();
            this.f2 = r.nextDouble();
            this.f3 = r.nextDouble();
            this.f4 = r.nextInt();
            this.f5 = r.nextInt();
            this.f6 = r.nextInt();
        }
    }

    static class MapTest
    extends FloatTest {
        public MapTest() throws IOException {
            super("Map", "{ \"type\": \"map\", \"values\":   { \"type\": \"record\", \"name\":\"Vals\", \"fields\": [   {\"name\":\"f1\", \"type\":\"float\"},   {\"name\":\"f2\", \"type\":\"float\"},   {\"name\":\"f3\", \"type\":\"float\"},   {\"name\":\"f4\", \"type\":\"float\"}]  }} ");
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            Utf8 key = new Utf8();
            long i = d.readMapStart();
            while (i != 0L) {
                for (long j = 0L; j < i; ++j) {
                    key = d.readString(key);
                    d.readFloat();
                    d.readFloat();
                    d.readFloat();
                    d.readFloat();
                }
                i = d.mapNext();
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            int items = this.sourceData.length / 4;
            e.writeMapStart();
            e.setItemCount(items);
            Utf8 foo = new Utf8("foo");
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.startItem();
                e.writeString(foo);
                e.writeFloat(this.sourceData[i]);
                e.writeFloat(this.sourceData[i + 1]);
                e.writeFloat(this.sourceData[i + 2]);
                e.writeFloat(this.sourceData[i + 3]);
            }
            e.writeMapEnd();
        }
    }

    static class ArrayTest
    extends FloatTest {
        public ArrayTest() throws IOException {
            super("Array", "{ \"type\": \"array\", \"items\":  { \"type\": \"record\", \"name\":\"Foo\", \"fields\":   [{\"name\":\"bar\", \"type\":    {\"type\": \"array\", \"items\":      { \"type\": \"record\", \"name\":\"Vals\", \"fields\": [      {\"name\":\"f1\", \"type\":\"float\"},      {\"name\":\"f2\", \"type\":\"float\"},      {\"name\":\"f3\", \"type\":\"float\"},      {\"name\":\"f4\", \"type\":\"float\"}]     }    }   }]}}");
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            d.readArrayStart();
            long i = d.readArrayStart();
            while (i != 0L) {
                for (long j = 0L; j < i; ++j) {
                    d.readFloat();
                    d.readFloat();
                    d.readFloat();
                    d.readFloat();
                }
                i = d.arrayNext();
            }
            d.arrayNext();
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            int items = this.sourceData.length / 4;
            e.writeArrayStart();
            e.setItemCount(1L);
            e.startItem();
            e.writeArrayStart();
            e.setItemCount(items);
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.startItem();
                e.writeFloat(this.sourceData[i]);
                e.writeFloat(this.sourceData[i + 1]);
                e.writeFloat(this.sourceData[i + 2]);
                e.writeFloat(this.sourceData[i + 3]);
            }
            e.writeArrayEnd();
            e.writeArrayEnd();
        }
    }

    static class StringTest
    extends BasicTest {
        String[] sourceData = null;

        public StringTest() throws IOException {
            super("String", "{ \"type\": \"string\"} ", 5);
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new String[this.count];
            int i = 0;
            while (i < this.sourceData.length) {
                this.sourceData[i++] = Perf.randomString(r);
            }
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            Utf8 utf = new Utf8();
            for (int i = 0; i < this.count / 4; ++i) {
                d.readString(utf).toString();
                d.readString(utf).toString();
                d.readString(utf).toString();
                d.readString(utf).toString();
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.writeString(this.sourceData[i]);
                e.writeString(this.sourceData[i + 1]);
                e.writeString(this.sourceData[i + 2]);
                e.writeString(this.sourceData[i + 3]);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    static class BytesTest
    extends BasicTest {
        byte[][] sourceData = null;

        public BytesTest() throws IOException {
            super("Bytes", "{ \"type\": \"bytes\"} ", 5);
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new byte[this.count][];
            int i = 0;
            while (i < this.sourceData.length) {
                byte[] data = new byte[r.nextInt(70)];
                r.nextBytes(data);
                this.sourceData[i++] = data;
            }
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(70);
            for (int i = 0; i < this.count / 4; ++i) {
                d.readBytes(bb);
                d.readBytes(bb);
                d.readBytes(bb);
                d.readBytes(bb);
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.writeBytes(this.sourceData[i]);
                e.writeBytes(this.sourceData[i + 1]);
                e.writeBytes(this.sourceData[i + 2]);
                e.writeBytes(this.sourceData[i + 3]);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    static class BoolTest
    extends BasicTest {
        boolean[] sourceData = null;

        public BoolTest() throws IOException {
            super("Boolean", "{ \"type\": \"boolean\"} ");
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new boolean[this.count];
            int i = 0;
            while (i < this.sourceData.length) {
                this.sourceData[i++] = r.nextBoolean();
            }
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count / 4; ++i) {
                d.readBoolean();
                d.readBoolean();
                d.readBoolean();
                d.readBoolean();
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.writeBoolean(this.sourceData[i]);
                e.writeBoolean(this.sourceData[i + 1]);
                e.writeBoolean(this.sourceData[i + 2]);
                e.writeBoolean(this.sourceData[i + 3]);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    static class DoubleTest
    extends BasicTest {
        double[] sourceData = null;

        public DoubleTest() throws IOException {
            super("Double", "{ \"type\": \"double\"} ");
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new double[this.count];
            int i = 0;
            while (i < this.sourceData.length) {
                this.sourceData[i++] = r.nextDouble();
            }
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count; i += 4) {
                d.readDouble();
                d.readDouble();
                d.readDouble();
                d.readDouble();
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.writeDouble(this.sourceData[i]);
                e.writeDouble(this.sourceData[i + 1]);
                e.writeDouble(this.sourceData[i + 2]);
                e.writeDouble(this.sourceData[i + 3]);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    static class FloatTest
    extends BasicTest {
        float[] sourceData = null;

        public FloatTest() throws IOException {
            this("Float", "{ \"type\": \"float\"} ");
        }

        public FloatTest(String name, String schema) throws IOException {
            super(name, schema);
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new float[this.count];
            int i = 0;
            while (i < this.sourceData.length) {
                this.sourceData[i++] = r.nextFloat();
            }
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count; i += 4) {
                d.readFloat();
                d.readFloat();
                d.readFloat();
                d.readFloat();
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.writeFloat(this.sourceData[i]);
                e.writeFloat(this.sourceData[i + 1]);
                e.writeFloat(this.sourceData[i + 2]);
                e.writeFloat(this.sourceData[i + 3]);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    static class LongTest
    extends BasicTest {
        private long[] sourceData = null;

        public LongTest() throws IOException {
            super("Long", "{ \"type\": \"long\"} ");
        }

        @Override
        void genSourceData() {
            int i;
            Random r = Perf.newRandom();
            this.sourceData = new long[this.count];
            for (i = 0; i < this.sourceData.length; i += 4) {
                this.sourceData[i] = r.nextLong() % 127L;
                this.sourceData[i + 1] = r.nextLong() % 0x1FFFFFL;
                this.sourceData[i + 2] = r.nextLong() % 0x3FFFFFFFFL;
                this.sourceData[i + 3] = r.nextLong() % 0x1FFFFFFFFFFFFL;
            }
            for (i = this.sourceData.length - 16; i < this.sourceData.length; ++i) {
                this.sourceData[i] = r.nextLong();
            }
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count / 4; ++i) {
                d.readLong();
                d.readLong();
                d.readLong();
                d.readLong();
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.writeLong(this.sourceData[i]);
                e.writeLong(this.sourceData[i + 1]);
                e.writeLong(this.sourceData[i + 2]);
                e.writeLong(this.sourceData[i + 3]);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    static class SmallLongTest
    extends IntTest {
        public SmallLongTest() throws IOException {
            super("SmallLong", "{ \"type\": \"long\"} ");
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count / 4; ++i) {
                d.readLong();
                d.readLong();
                d.readLong();
                d.readLong();
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.writeLong(this.sourceData[i]);
                e.writeLong(this.sourceData[i + 1]);
                e.writeLong(this.sourceData[i + 2]);
                e.writeLong(this.sourceData[i + 3]);
            }
        }
    }

    static class IntTest
    extends BasicTest {
        protected int[] sourceData = null;

        public IntTest() throws IOException {
            this("Int", "{ \"type\": \"int\"} ");
        }

        private IntTest(String name, String schema) throws IOException {
            super(name, schema);
        }

        @Override
        void genSourceData() {
            Random r = Perf.newRandom();
            this.sourceData = new int[this.count];
            for (int i = 0; i < this.sourceData.length; i += 4) {
                this.sourceData[i] = r.nextInt(50);
                this.sourceData[i + 1] = r.nextInt(5000);
                this.sourceData[i + 2] = r.nextInt(500000);
                this.sourceData[i + 3] = r.nextInt(150000000);
            }
        }

        @Override
        void readInternal(Decoder d) throws IOException {
            for (int i = 0; i < this.count / 4; ++i) {
                d.readInt();
                d.readInt();
                d.readInt();
                d.readInt();
            }
        }

        @Override
        void writeInternal(Encoder e) throws IOException {
            for (int i = 0; i < this.sourceData.length; i += 4) {
                e.writeInt(this.sourceData[i]);
                e.writeInt(this.sourceData[i + 1]);
                e.writeInt(this.sourceData[i + 2]);
                e.writeInt(this.sourceData[i + 3]);
            }
        }

        @Override
        void reset() {
            this.sourceData = null;
            this.data = null;
        }
    }

    private static abstract class BasicTest
    extends Test {
        protected final Schema schema;
        protected byte[] data;

        BasicTest(String name, String json) throws IOException {
            this(name, json, 1);
        }

        BasicTest(String name, String json, int factor) throws IOException {
            super(name, 800, 250000 / factor);
            this.schema = new Schema.Parser().parse(json);
        }

        @Override
        public final long readTest() throws IOException {
            long t = System.nanoTime();
            Decoder d = this.getDecoder();
            this.readInternal(d);
            return System.nanoTime() - t;
        }

        @Override
        public final long writeTest() throws IOException {
            long t = System.nanoTime();
            Encoder e = this.getEncoder();
            this.writeInternal(e);
            e.flush();
            return System.nanoTime() - t;
        }

        protected Decoder getDecoder() throws IOException {
            return this.newDecoder();
        }

        private Encoder getEncoder() throws IOException {
            return this.newEncoder(this.getOutputStream());
        }

        protected Decoder newDecoder() {
            return decoder_factory.binaryDecoder(this.data, null);
        }

        protected Encoder newEncoder(ByteArrayOutputStream out) throws IOException {
            BinaryEncoder e = encoder_factory.binaryEncoder(out, null);
            return e;
        }

        private ByteArrayOutputStream getOutputStream() {
            return new ByteArrayOutputStream((int)(this.encodedSize > 0L ? this.encodedSize : (long)this.count));
        }

        @Override
        void init() throws IOException {
            this.genSourceData();
            ByteArrayOutputStream baos = this.getOutputStream();
            Encoder e = this.newEncoder(baos);
            this.writeInternal(e);
            e.flush();
            this.data = baos.toByteArray();
            this.encodedSize = this.data.length;
        }

        abstract void genSourceData();

        abstract void readInternal(Decoder var1) throws IOException;

        abstract void writeInternal(Encoder var1) throws IOException;
    }

    private static abstract class Test {
        public final String name;
        public final int count;
        public final int cycles;
        public long encodedSize = 0L;
        protected boolean isReadTest = true;
        protected boolean isWriteTest = true;
        static DecoderFactory decoder_factory = new DecoderFactory();
        static EncoderFactory encoder_factory = new EncoderFactory();

        public Test(String name, int cycles, int count) {
            this.name = name;
            this.cycles = cycles;
            this.count = count;
        }

        abstract long readTest() throws IOException;

        abstract long writeTest() throws IOException;

        final boolean isWriteTest() {
            return this.isWriteTest;
        }

        final boolean isReadTest() {
            return this.isReadTest;
        }

        abstract void init() throws IOException;

        abstract void reset();

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class TestDescriptor {
        Class<? extends Test> test;
        String param;

        TestDescriptor(Class<? extends Test> test, String param) {
            this.test = test;
            this.param = param;
        }

        void add(List<TestDescriptor> typeList) {
            ALL_TESTS.put(this.param, this);
            typeList.add(this);
        }
    }
}

