/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce.srp;

import java.math.BigInteger;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Util;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SRP6VerifierGenerator {
    protected BigInteger N;
    protected BigInteger g;
    protected TlsHash digest;

    public void init(BigInteger bigInteger, BigInteger bigInteger2, TlsHash tlsHash) {
        this.N = bigInteger;
        this.g = bigInteger2;
        this.digest = tlsHash;
    }

    public void init(SRP6Group sRP6Group, TlsHash tlsHash) {
        this.N = sRP6Group.getN();
        this.g = sRP6Group.getG();
        this.digest = tlsHash;
    }

    public BigInteger generateVerifier(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        BigInteger bigInteger = SRP6Util.calculateX(this.digest, this.N, byArray, byArray2, byArray3);
        return this.g.modPow(bigInteger, this.N);
    }
}

