/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyKernel;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandInstr;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ThrowExceptionInstr
extends OneOperandInstr
implements FixedArityInstr {
    public ThrowExceptionInstr(Operand exception2) {
        super(Operation.THROW, exception2);
    }

    public Operand getException() {
        return this.getOperand1();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ThrowExceptionInstr(this.getException().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getException());
    }

    public static ThrowExceptionInstr decode(IRReaderDecoder d) {
        return new ThrowExceptionInstr(d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        if (this.getException() instanceof IRException) {
            throw ((IRException)this.getException()).getException(context.runtime);
        }
        Object excObj = this.getException().retrieve(context, self2, currScope, currDynScope, temp);
        if (excObj instanceof IRubyObject) {
            RubyKernel.raise(context, context.runtime.getKernel(), new IRubyObject[]{(IRubyObject)excObj}, Block.NULL_BLOCK);
        } else if (excObj instanceof Throwable) {
            Helpers.throwException((Throwable)excObj);
        }
        throw new RuntimeException("Control shouldn't have reached here in ThrowEx");
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ThrowExceptionInstr(this);
    }
}

