/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartText;

import java.awt.font.FontRenderContext;
import java.text.NumberFormat;
import org.jCharts.axisChart.axis.scale.ScaleCalculator;
import org.jCharts.chartText.TextTagGroup;
import org.jCharts.properties.util.ChartFont;

public class NumericTagGroup
extends TextTagGroup {
    private NumberFormat numberFormat;

    public NumericTagGroup(ChartFont chartFont, FontRenderContext fontRenderContext, boolean bl, boolean bl2, boolean bl3, int n) {
        super(chartFont, fontRenderContext);
        this.numberFormat = NumericTagGroup.getNumberFormatInstance(bl, bl2, bl3, n);
    }

    public static final NumberFormat getNumberFormatInstance(boolean bl, boolean bl2, boolean bl3, int n) {
        NumberFormat numberFormat = bl ? NumberFormat.getCurrencyInstance() : (bl2 ? NumberFormat.getPercentInstance() : NumberFormat.getInstance());
        if (bl3) {
            numberFormat.setGroupingUsed(true);
        } else {
            numberFormat.setGroupingUsed(false);
        }
        if (n >= 0) {
            numberFormat.setMaximumFractionDigits(0);
            numberFormat.setMinimumFractionDigits(0);
        } else {
            numberFormat.setMaximumFractionDigits(-n);
            numberFormat.setMinimumFractionDigits(-n);
        }
        return numberFormat;
    }

    public void addLabel(double d) {
        super.addLabel(this.numberFormat.format(d));
    }

    public void createAxisScaleLabels(ScaleCalculator scaleCalculator) {
        double d = scaleCalculator.getMinValue();
        this.addLabel(d);
        int n = 1;
        while (n < scaleCalculator.getNumberOfScaleItems()) {
            this.addLabel(d += scaleCalculator.getIncrement());
            ++n;
        }
    }
}

