/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jetbrains.datalore.base.registration.Disposable;
import jetbrains.datalore.plot.MonolithicCommon;
import jetbrains.datalore.vis.swing.batik.DefaultPlotPanelBatik;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.jmeter.threads.openmodel.ThreadSchedule;
import org.apache.jmeter.threads.openmodel.ThreadScheduleStep;
import org.apache.jmeter.threads.openmodel.TimeUnitExtensionsKt;
import org.apache.jmeter.threads.openmodel.gui.TargetRateChart;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.GgplotKt;
import org.jetbrains.letsPlot.geom.geomLine;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.Plot;
import org.jetbrains.letsPlot.intern.ToSpecConvertersKt;
import org.jetbrains.letsPlot.label.GgtitleKt;
import org.jetbrains.letsPlot.scale.DateTimeKt;
import org.jetbrains.letsPlot.themes.theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL, since="5.5")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/apache/jmeter/threads/openmodel/gui/TargetRateChart;", "Ljavax/swing/JPanel;", "()V", "prevRate", "", "prevSteps", "", "Lorg/apache/jmeter/threads/openmodel/ThreadScheduleStep;", "prevTimes", "createChart", "Ljavax/swing/JComponent;", "time", "rate", "rateUnit", "Ljava/util/concurrent/TimeUnit;", "setData", "", "updateSchedule", "threadSchedule", "Lorg/apache/jmeter/threads/openmodel/ThreadSchedule;", "Companion", "ApacheJMeter_core"})
@SourceDebugExtension(value={"SMAP\nTargetRateChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetRateChart.kt\norg/apache/jmeter/threads/openmodel/gui/TargetRateChart\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,147:1\n13579#2,2:148\n*S KotlinDebug\n*F\n+ 1 TargetRateChart.kt\norg/apache/jmeter/threads/openmodel/gui/TargetRateChart\n*L\n113#1:148,2\n*E\n"})
public final class TargetRateChart
extends JPanel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private List<? extends ThreadScheduleStep> prevSteps;
    @Nullable
    private double[] prevTimes;
    @Nullable
    private double[] prevRate;
    private static final Logger log = LoggerFactory.getLogger(TargetRateChart.class);
    private static final double MIN_TICKS_FOR_TIME_AXIS = 2.5;

    public TargetRateChart() {
        this.setLayout(new BorderLayout());
    }

    public final void updateSchedule(@NotNull ThreadSchedule threadSchedule) {
        Intrinsics.checkNotNullParameter((Object)threadSchedule, (String)"threadSchedule");
        if (Intrinsics.areEqual(threadSchedule.getSteps(), this.prevSteps)) {
            return;
        }
        this.prevSteps = threadSchedule.getSteps();
        List timeValues = new ArrayList();
        List rateValues = new ArrayList();
        double time = 0.0;
        double rate = 0.0;
        boolean addPoint = false;
        for (ThreadScheduleStep step : threadSchedule.getSteps()) {
            Double d;
            ThreadScheduleStep threadScheduleStep = step;
            if (threadScheduleStep instanceof ThreadScheduleStep.RateStep) {
                rate = ((ThreadScheduleStep.RateStep)step).getRate();
                if (!addPoint) continue;
                addPoint = false;
                d = time;
                ((Collection)timeValues).add(d);
                d = rate;
                ((Collection)rateValues).add(d);
                continue;
            }
            if (!(threadScheduleStep instanceof ThreadScheduleStep.ArrivalsStep) || !(((ThreadScheduleStep.ArrivalsStep)step).getDuration() > 0.0)) continue;
            d = time;
            ((Collection)timeValues).add(d);
            d = rate;
            ((Collection)rateValues).add(d);
            addPoint = true;
            time += ((ThreadScheduleStep.ArrivalsStep)step).getDuration();
        }
        if (addPoint) {
            Double d = time;
            ((Collection)timeValues).add(d);
            d = rate;
            ((Collection)rateValues).add(d);
        }
        this.setData(CollectionsKt.toDoubleArray((Collection)timeValues), CollectionsKt.toDoubleArray((Collection)rateValues));
    }

    private final void setData(double[] time, double[] rate) {
        if (Arrays.equals(time, this.prevTimes) && Arrays.equals(rate, this.prevRate)) {
            return;
        }
        double[] dArray = Arrays.copyOf(time, time.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(this, size)");
        this.prevTimes = dArray;
        double[] dArray2 = Arrays.copyOf(rate, rate.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray2, (String)"copyOf(this, size)");
        this.prevRate = dArray2;
        double timeScale = TimeUnit.SECONDS.toMillis(1L);
        int i = 0;
        int n = time.length;
        while (i < n) {
            int n2 = i++;
            time[n2] = time[n2] * timeScale;
        }
        Double d = ArraysKt.maxOrNull((double[])rate);
        double maxRate = d != null ? d : 0.0;
        TimeUnit rateUnit = TimeUnitExtensionsKt.rateUnitFor(maxRate);
        if (rateUnit != TimeUnit.SECONDS) {
            double scale = TimeUnitExtensionsKt.getAsSeconds(rateUnit);
            int i2 = 0;
            int n3 = rate.length;
            while (i2 < n3) {
                int n4 = i2++;
                rate[n4] = rate[n4] * scale;
            }
        }
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"components");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            if (!(it instanceof Disposable)) continue;
            ((Disposable)it).dispose();
        }
        this.removeAll();
        this.add((Component)this.createChart(time, rate, rateUnit), "Center");
    }

    private final JComponent createChart(double[] time, double[] rate, TimeUnit rateUnit) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"time", (Object)time), TuplesKt.to((Object)"rate", (Object)rate)};
        Map data = MapsKt.mapOf((Pair[])pairArray);
        Object[] objectArray = new Integer[]{0, 0};
        Plot plot2 = GgplotKt.letsPlot$default((Map)data, null, (int)2, null).plus((Feature)new geomLine(null, null, null, false, null, null, null, null, null, null, null, null, null, (Function1)createChart.plot.1.INSTANCE, 8191, null)).plus((Feature)DateTimeKt.scaleXTime$default((String)"Time since test start", null, null, null, (List)CollectionsKt.listOf((Object[])objectArray), null, null, (int)110, null));
        StringBuilder stringBuilder = new StringBuilder().append("Target load rate per ");
        String string = rateUnit.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        Plot plot3 = plot2.plus((Feature)GgtitleKt.ggtitle$default((String)stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)"s")).toString(), null, (int)2, null)).plus((Feature)new theme(null, null, null, null, null, null, null, null, null, null, (Object)"blank", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1025, 262143, null));
        Map rawSpec = ToSpecConvertersKt.toSpec((Plot)plot3);
        Map processedSpec = MonolithicCommon.INSTANCE.processRawSpecs(rawSpec, false);
        return (JComponent)new DefaultPlotPanelBatik(processedSpec, false, false, 10, (Function1)createChart.1.INSTANCE);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/apache/jmeter/threads/openmodel/gui/TargetRateChart$Companion;", "", "()V", "MIN_TICKS_FOR_TIME_AXIS", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ApacheJMeter_core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

