/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.gui.Searchable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestElementTraverser;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.PropertyIteratorImpl;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apiguardian.api.API;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestElement
implements TestElement,
Serializable,
Searchable {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(AbstractTestElement.class);
    private final transient ReadWriteLock lock = this instanceof NoThreadClone || this instanceof AbstractThreadGroup ? new ReentrantReadWriteLock() : null;
    private final @GuardedBy(value={"lock"}) Map<String, JMeterProperty> propMap = this.lock != null ? new LinkedHashMap() : Collections.synchronizedMap(new LinkedHashMap());
    private final transient Map<String, JMeterProperty> propMapConcurrent = this.lock != null ? new ConcurrentHashMap() : null;
    private transient @GuardedBy(value={"lock"}) Set<JMeterProperty> temporaryProperties;
    private transient boolean runningVersion = false;
    private transient JMeterContext threadContext = null;
    private transient String threadName = null;

    @Override
    public Object clone() {
        try {
            TestElement clonedElement = (TestElement)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            PropertyIterator clonedProps = clonedElement.propertyIterator();
            while (clonedProps.hasNext()) {
                clonedProps.next();
                clonedProps.remove();
            }
            PropertyIterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                clonedElement.setProperty(iter.next().clone());
            }
            clonedElement.setRunningVersion(this.runningVersion);
            return clonedElement;
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void clear() {
        this.writeLock();
        try {
            this.propMap.clear();
            Map<String, JMeterProperty> propMapConcurrent = this.propMapConcurrent;
            if (propMapConcurrent != null) {
                propMapConcurrent.clear();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private void writeLock() {
        if (this.lock != null) {
            this.lock.writeLock().lock();
        }
    }

    private void writeUnlock() {
        if (this.lock != null) {
            this.lock.writeLock().unlock();
        }
    }

    private void readLock() {
        if (this.lock != null) {
            this.lock.readLock().lock();
        }
    }

    private void readUnlock() {
        if (this.lock != null) {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clearTestElementChildren() {
    }

    @Override
    public void removeProperty(String key) {
        this.writeLock();
        try {
            this.propMap.remove(key);
            Map<String, JMeterProperty> propMapConcurrent = this.propMapConcurrent;
            if (propMapConcurrent != null) {
                propMapConcurrent.remove(key);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractTestElement) {
            this.readLock();
            try {
                boolean bl = ((AbstractTestElement)o).propMap.equals(this.propMap);
                return bl;
            }
            finally {
                this.readUnlock();
            }
        }
        return false;
    }

    public int hashCode() {
        return this.propMap.hashCode();
    }

    @Override
    public void addTestElement(TestElement el) {
        this.mergeIn(el);
    }

    @Override
    public void setName(String name) {
        this.set(this.getSchema().getName(), name);
    }

    @Override
    public String getName() {
        return this.get(this.getSchema().getName());
    }

    @Override
    public void setComment(String comment) {
        this.set(this.getSchema().getComments(), comment);
    }

    @Override
    public String getComment() {
        return this.get(this.getSchema().getComments());
    }

    @Override
    public JMeterProperty getProperty(String key) {
        JMeterProperty prop = this.getPropertyOrNull(key);
        if (prop == null) {
            prop = new NullProperty(key);
        }
        return prop;
    }

    @Override
    @API(status=API.Status.EXPERIMENTAL, since="5.6")
    public JMeterProperty getPropertyOrNull(String key) {
        Map<String, JMeterProperty> propMapConcurrent = this.propMapConcurrent;
        if (propMapConcurrent != null) {
            return propMapConcurrent.get(key);
        }
        return this.propMap.get(key);
    }

    @Override
    public void traverse(TestElementTraverser traverser) {
        this.readLock();
        try {
            PropertyIterator iter = this.propertyIterator();
            traverser.startTestElement(this);
            while (iter.hasNext()) {
                this.traverseProperty(traverser, iter.next());
            }
            traverser.endTestElement(this);
        }
        finally {
            this.readUnlock();
        }
    }

    protected void traverseProperty(TestElementTraverser traverser, JMeterProperty value) {
        traverser.startProperty(value);
        if (value instanceof TestElementProperty) {
            ((TestElement)value.getObjectValue()).traverse(traverser);
        } else if (value instanceof CollectionProperty) {
            this.traverseCollection((CollectionProperty)value, traverser);
        } else if (value instanceof MapProperty) {
            this.traverseMap((MapProperty)value, traverser);
        }
        traverser.endProperty(value);
    }

    protected void traverseMap(MapProperty map, TestElementTraverser traverser) {
        PropertyIterator iter = map.valueIterator();
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
    }

    protected void traverseCollection(CollectionProperty col, TestElementTraverser traverser) {
        for (JMeterProperty jMeterProperty : col) {
            this.traverseProperty(traverser, jMeterProperty);
        }
    }

    @Override
    public int getPropertyAsInt(String key) {
        return this.getProperty(key).getIntValue();
    }

    @Override
    public int getPropertyAsInt(String key, int defaultValue) {
        JMeterProperty jmp = this.getPropertyOrNull(key);
        return jmp == null || jmp instanceof NullProperty ? defaultValue : jmp.getIntValue();
    }

    @Override
    public boolean getPropertyAsBoolean(String key) {
        return this.getProperty(key).getBooleanValue();
    }

    @Override
    public boolean getPropertyAsBoolean(String key, boolean defaultVal) {
        JMeterProperty jmp = this.getPropertyOrNull(key);
        return jmp == null || jmp instanceof NullProperty ? defaultVal : jmp.getBooleanValue();
    }

    @Override
    public float getPropertyAsFloat(String key) {
        return this.getProperty(key).getFloatValue();
    }

    @Override
    public long getPropertyAsLong(String key) {
        return this.getProperty(key).getLongValue();
    }

    @Override
    public long getPropertyAsLong(String key, long defaultValue) {
        JMeterProperty jmp = this.getPropertyOrNull(key);
        return jmp == null || jmp instanceof NullProperty ? defaultValue : jmp.getLongValue();
    }

    @Override
    public double getPropertyAsDouble(String key) {
        return this.getProperty(key).getDoubleValue();
    }

    @Override
    public String getPropertyAsString(String key) {
        return this.getProperty(key).getStringValue();
    }

    @Override
    public String getPropertyAsString(String key, String defaultValue) {
        JMeterProperty jmp = this.getPropertyOrNull(key);
        return jmp == null || jmp instanceof NullProperty ? defaultValue : jmp.getStringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addProperty(JMeterProperty property, boolean clone) {
        JMeterProperty propertyToPut = property;
        if (clone) {
            propertyToPut = property.clone();
        }
        if (this.isRunningVersion()) {
            this.setTemporary(propertyToPut);
        } else {
            this.clearTemporary(property);
        }
        JMeterProperty prop = this.getProperty(property.getName());
        if (prop instanceof NullProperty || prop instanceof StringProperty && prop.getStringValue().isEmpty()) {
            this.writeLock();
            try {
                this.propMap.put(property.getName(), propertyToPut);
                Map<String, JMeterProperty> propMapConcurrent = this.propMapConcurrent;
                if (propMapConcurrent == null) return;
                propMapConcurrent.put(property.getName(), propertyToPut);
                return;
            }
            finally {
                this.writeUnlock();
            }
        } else {
            prop.mergeIn(propertyToPut);
        }
    }

    protected void addProperty(JMeterProperty property) {
        this.addProperty(property, false);
    }

    protected void clearTemporary(JMeterProperty property) {
        this.writeLock();
        try {
            if (this.temporaryProperties != null) {
                this.temporaryProperties.remove(property);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void logProperties() {
        if (log.isDebugEnabled()) {
            PropertyIterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                JMeterProperty prop = iter.next();
                log.debug("Property {} is temp? {} and is a {}", new Object[]{prop.getName(), this.isTemporary(prop), prop.getObjectValue()});
            }
        }
    }

    @Override
    public void setProperty(JMeterProperty property) {
        if (this.isRunningVersion()) {
            if (this.getProperty(property.getName()) instanceof NullProperty) {
                this.addProperty(property);
            } else {
                this.getProperty(property.getName()).setObjectValue(property.getObjectValue());
            }
        } else {
            this.writeLock();
            try {
                this.propMap.put(property.getName(), property);
                Map<String, JMeterProperty> propMapConcurrent = this.propMapConcurrent;
                if (propMapConcurrent != null) {
                    propMapConcurrent.put(property.getName(), property);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.setProperty(new StringProperty(name, value));
    }

    @Override
    public void setProperty(String name, String value, String dflt) {
        if (dflt.equals(value)) {
            this.removeProperty(name);
        } else {
            this.setProperty(new StringProperty(name, value));
        }
    }

    @Override
    public void setProperty(String name, boolean value) {
        this.setProperty(new BooleanProperty(name, value));
    }

    @Override
    public void setProperty(String name, boolean value, boolean dflt) {
        if (value == dflt) {
            this.removeProperty(name);
        } else {
            this.setProperty(new BooleanProperty(name, value));
        }
    }

    @Override
    public void setProperty(String name, int value) {
        this.setProperty(new IntegerProperty(name, value));
    }

    @Override
    public void setProperty(String name, int value, int dflt) {
        if (value == dflt) {
            this.removeProperty(name);
        } else {
            this.setProperty(new IntegerProperty(name, value));
        }
    }

    @Override
    public void setProperty(String name, long value) {
        this.setProperty(new LongProperty(name, value));
    }

    @Override
    public void setProperty(String name, long value, long dflt) {
        if (value == dflt) {
            this.removeProperty(name);
        } else {
            this.setProperty(new LongProperty(name, value));
        }
    }

    @Override
    public PropertyIterator propertyIterator() {
        this.readLock();
        try {
            if (this.propMap.isEmpty()) {
                PropertyIterator propertyIterator = PropertyIteratorImpl.EMPTY_ITERATOR;
                return propertyIterator;
            }
            PropertyIteratorImpl propertyIteratorImpl = new PropertyIteratorImpl(this, this.propMap.values());
            return propertyIteratorImpl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeIn(TestElement element) {
        this.writeLock();
        try {
            PropertyIterator iter = element.propertyIterator();
            while (iter.hasNext()) {
                JMeterProperty prop = iter.next();
                this.addProperty(prop, false);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public boolean isRunningVersion() {
        return this.runningVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRunningVersion(boolean runningVersion) {
        this.writeLock();
        try {
            this.runningVersion = runningVersion;
            PropertyIterator iter = this.propertyIterator();
            Map<String, JMeterProperty> propMapConcurrent = this.propMapConcurrent;
            while (iter.hasNext()) {
                JMeterProperty property = iter.next();
                property.setRunningVersion(runningVersion);
                if (propMapConcurrent == null) continue;
                propMapConcurrent.put(property.getName(), property);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverRunningVersion() {
        if (this instanceof NoThreadClone) {
            return;
        }
        this.writeLock();
        try {
            Iterator<Map.Entry<String, JMeterProperty>> iter = this.propMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, JMeterProperty> entry = iter.next();
                JMeterProperty prop = entry.getValue();
                if (this.isTemporary(prop)) {
                    iter.remove();
                    this.clearTemporary(prop);
                    continue;
                }
                prop.recoverRunningVersion(this);
            }
            this.emptyTemporary();
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void emptyTemporary() {
        this.writeLock();
        try {
            if (this.temporaryProperties != null) {
                this.temporaryProperties.clear();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public boolean isTemporary(JMeterProperty property) {
        this.readLock();
        try {
            boolean bl = this.temporaryProperties != null && this.temporaryProperties.contains(property);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTemporary(JMeterProperty property) {
        this.writeLock();
        try {
            if (this.temporaryProperties == null) {
                LinkedHashSet set = new LinkedHashSet();
                this.temporaryProperties = this.lock != null ? set : Collections.synchronizedSet(set);
            }
            this.temporaryProperties.add(property);
            if (AbstractTestElement.isMergingEnclosedProperties(property)) {
                for (JMeterProperty jMeterProperty : (MultiProperty)property) {
                    this.setTemporary(jMeterProperty);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private static boolean isMergingEnclosedProperties(JMeterProperty property) {
        return property instanceof MultiProperty && !(property instanceof TestElementProperty);
    }

    @Override
    public JMeterContext getThreadContext() {
        if (this.threadContext == null) {
            this.threadContext = JMeterContextService.getContext();
        }
        return this.threadContext;
    }

    @Override
    public void setThreadContext(JMeterContext inthreadContext) {
        if (this.threadContext != null && inthreadContext != this.threadContext) {
            throw new RuntimeException("Attempting to reset the thread context");
        }
        this.threadContext = inthreadContext;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public void setThreadName(String inthreadName) {
        if (this.threadName != null && !this.threadName.equals(inthreadName)) {
            throw new RuntimeException("Attempting to reset the thread name");
        }
        this.threadName = inthreadName;
    }

    protected AbstractTestElement() {
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.get(this.getSchema().getEnabled());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.set(this.getSchema().getEnabled(), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSearchableTokens() {
        ArrayList<String> result = new ArrayList<String>(25);
        this.readLock();
        try {
            PropertyIterator iterator = this.propertyIterator();
            while (iterator.hasNext()) {
                JMeterProperty jMeterProperty = iterator.next();
                result.add(jMeterProperty.getName());
                result.add(jMeterProperty.getStringValue());
            }
        }
        finally {
            this.readUnlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addPropertiesValues(List<? super String> result, Set<String> propertyNames) {
        this.readLock();
        try {
            PropertyIterator iterator = this.propertyIterator();
            while (iterator.hasNext()) {
                JMeterProperty jMeterProperty = iterator.next();
                if (!propertyNames.contains(jMeterProperty.getName())) continue;
                result.add(jMeterProperty.getStringValue());
            }
        }
        finally {
            this.readUnlock();
        }
    }
}

