/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.exec.SystemCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReportGenerator {
    public static final String HTML_REPORT_SUCCESS = "generate_report_ui.html_report_success";
    public static final String ERROR_GENERATING = "generate_report_ui.html_report_error";
    public static final String NO_FILE = "generate_report_ui.no_such_file";
    public static final String NO_DIRECTORY = "generate_report_ui.no_such_directory";
    public static final String NOT_EMPTY_DIRECTORY = "generate_report_ui.directory_not_empty";
    public static final String CANNOT_CREATE_DIRECTORY = "generate_report_ui.cannot_create_directory";
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReportGenerator.class);
    private static final long COMMAND_TIMEOUT = JMeterUtils.getPropDefault("generate_report_ui.generation_timeout", 300000L);
    private final String csvFilePath;
    private final String userPropertiesFilePath;
    private final String outputDirectoryPath;

    public HtmlReportGenerator(String csvFilePath, String userPropertiesFilePath, String outputDirectoryPath) {
        this.csvFilePath = csvFilePath;
        this.userPropertiesFilePath = userPropertiesFilePath;
        this.outputDirectoryPath = outputDirectoryPath == null ? JMeterUtils.getJMeterBinDir() + "/report-output/" : outputDirectoryPath;
    }

    public List<String> run() {
        List<String> generationCommand;
        int resultCode;
        ArrayList<String> errorMessageList;
        block5: {
            errorMessageList = new ArrayList<String>();
            errorMessageList.addAll(this.checkArguments());
            if (!errorMessageList.isEmpty()) {
                return errorMessageList;
            }
            ByteArrayOutputStream commandExecutionOutput = new ByteArrayOutputStream();
            resultCode = -1;
            generationCommand = this.createGenerationCommand();
            try {
                SystemCommand sc = new SystemCommand(new File(JMeterUtils.getJMeterBinDir()), COMMAND_TIMEOUT, 100, null, null, (OutputStream)commandExecutionOutput, null);
                LOGGER.debug("Running report generation");
                resultCode = sc.run(generationCommand);
                if (resultCode != 0) {
                    errorMessageList.add(commandExecutionOutput.toString(Charset.defaultCharset().name()));
                    LOGGER.info("The HTML report generation failed and returned: {}", (Object)commandExecutionOutput);
                    return errorMessageList;
                }
            }
            catch (TimeoutException e) {
                errorMessageList.add(MessageFormat.format(JMeterUtils.getResString("generate_report_ui.html_report_timeout_error"), COMMAND_TIMEOUT, e.getMessage(), commandExecutionOutput));
                LOGGER.error("Report generation took more time than configured timeout (Property {}={}, command output=[{}])", new Object[]{"generate_report_ui.generation_timeout", COMMAND_TIMEOUT, commandExecutionOutput, e});
            }
            catch (IOException | InterruptedException e) {
                errorMessageList.add(MessageFormat.format(JMeterUtils.getResString("generate_report_ui.html_report_unknown_error"), e.getMessage(), commandExecutionOutput));
                LOGGER.error("Error during HTML report generation, executing {}", (Object)commandExecutionOutput, (Object)e);
                if (!(e instanceof InterruptedException)) break block5;
                Thread.currentThread().interrupt();
            }
        }
        LOGGER.debug("SystemCommand ran: {}  returned: {}", generationCommand, (Object)resultCode);
        return errorMessageList;
    }

    private List<String> createGenerationCommand() {
        String jmeterBinDir = JMeterUtils.getJMeterBinDir();
        ArrayList<String> arguments = new ArrayList<String>();
        String java = System.getProperty("java.home") + "/bin/java";
        arguments.add(java);
        arguments.add("-jar");
        arguments.add(jmeterBinDir + "/ApacheJMeter.jar");
        arguments.add("-p");
        arguments.add(jmeterBinDir + "/jmeter.properties");
        arguments.add("-q");
        arguments.add(this.userPropertiesFilePath);
        arguments.add("-g");
        arguments.add(this.csvFilePath);
        arguments.add("-j");
        arguments.add(jmeterBinDir + "/jmeter_html_report.log");
        arguments.add("-o");
        arguments.add(this.outputDirectoryPath);
        return arguments;
    }

    private List<String> checkArguments() {
        String outputError;
        String userPropertiesError;
        ArrayList<String> errors = new ArrayList<String>();
        String csvError = HtmlReportGenerator.checkFile(new File(this.csvFilePath));
        if (csvError != null) {
            errors.add(JMeterUtils.getResString("generate_report_ui.csv_file") + csvError);
        }
        if ((userPropertiesError = HtmlReportGenerator.checkFile(new File(this.userPropertiesFilePath))) != null) {
            errors.add(JMeterUtils.getResString("generate_report_ui.user_properties_file") + userPropertiesError);
        }
        if ((outputError = HtmlReportGenerator.checkDirectory(new File(this.outputDirectoryPath))) != null) {
            errors.add(JMeterUtils.getResString("generate_report_ui.output_directory") + outputError);
        }
        return errors;
    }

    private static String checkFile(File fileToCheck) {
        if (fileToCheck.exists() && fileToCheck.canRead() && fileToCheck.isFile()) {
            return null;
        }
        return MessageFormat.format(JMeterUtils.getResString(NO_FILE), fileToCheck);
    }

    private static String checkDirectory(File directoryToCheck) {
        if (directoryToCheck.exists()) {
            String[] files = directoryToCheck.list();
            if (files != null && files.length > 0) {
                return MessageFormat.format(JMeterUtils.getResString(NOT_EMPTY_DIRECTORY), directoryToCheck);
            }
            return null;
        }
        File parentDirectory = directoryToCheck.getParentFile();
        if (parentDirectory != null && parentDirectory.exists() && parentDirectory.canWrite()) {
            if (directoryToCheck.mkdir()) {
                return null;
            }
            return MessageFormat.format(JMeterUtils.getResString(CANNOT_CREATE_DIRECTORY), directoryToCheck);
        }
        return MessageFormat.format(JMeterUtils.getResString(CANNOT_CREATE_DIRECTORY), directoryToCheck);
    }
}

