/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Help;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionHelper
extends JDialog
implements ActionListener,
ChangeListener,
LocaleChangeListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggerFactory.getLogger(FunctionHelper.class);
    private static final String GENERATE = "GENERATE";
    private static final String RESET_VARS = "RESET_VARS";
    private static final String FUNCTION_PREFIX = "__";
    private JLabeledChoice functionList;
    private ArgumentsPanel parameterPanel;
    private JLabeledTextField cutPasteFunction;
    private JSyntaxTextArea resultTextArea;
    private JSyntaxTextArea variablesTextArea;
    private JMeterVariables jMeterVariables = new JMeterVariables();
    private static final char ANY_NORMAL_CHAR = ' ';

    public FunctionHelper() {
    }

    public FunctionHelper(JFrame parent) {
        super(parent, JMeterUtils.getResString("function_helper_title"), false);
        this.init();
        JMeterUtils.addLocaleChangeListener(this);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -4036804004190858925L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionHelper.this.setVisible(false);
            }
        };
        rootPane.getActionMap().put(escapeAction.getValue("Name"), escapeAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        return rootPane;
    }

    private void init() {
        this.parameterPanel = new ArgumentsPanel(true, JMeterUtils.getResString("function_params"));
        this.initializeFunctionList();
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel comboPanel = new JPanel(new FlowLayout(1));
        comboPanel.add((Component)this.functionList);
        JButton helpButton = new JButton(JMeterUtils.getResString("help"));
        helpButton.addActionListener(new HelpListener());
        comboPanel.add(helpButton);
        this.getContentPane().add((Component)comboPanel, "North");
        this.getContentPane().add((Component)this.parameterPanel, "Center");
        JPanel resultsPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2", "[][fill,grow]"));
        JPanel generatePanel = new JPanel(new FlowLayout(1));
        this.cutPasteFunction = new JLabeledTextField(JMeterUtils.getResString("cut_paste_function"), 35, null, false);
        this.cutPasteFunction.setEnabled(false);
        generatePanel.add((Component)this.cutPasteFunction);
        JButton generateButton = new JButton(JMeterUtils.getResString("generate"));
        generateButton.setActionCommand(GENERATE);
        generateButton.addActionListener(this);
        generatePanel.add(generateButton);
        JButton resetVarsButton = new JButton(JMeterUtils.getResString("function_helper_reset_vars"));
        resetVarsButton.setActionCommand(RESET_VARS);
        resetVarsButton.addActionListener(this);
        generatePanel.add(resetVarsButton);
        this.resultTextArea = JSyntaxTextArea.getInstance(5, 60);
        this.resultTextArea.setEditable(false);
        this.resultTextArea.setToolTipText(JMeterUtils.getResString("function_helper_dialog_result_warn"));
        this.variablesTextArea = JSyntaxTextArea.getInstance(10, 60);
        this.variablesTextArea.setEditable(false);
        resultsPanel.add((Component)generatePanel, "span 2");
        JTextScrollPane resultTextAreaJSP = JTextScrollPane.getInstance(this.resultTextArea);
        resultsPanel.add(JMeterUtils.labelFor((Component)((Object)resultTextAreaJSP), "result_function"));
        resultsPanel.add((Component)((Object)resultTextAreaJSP));
        JTextScrollPane variablesTextAreaJSP = JTextScrollPane.getInstance(this.variablesTextArea);
        resultsPanel.add(JMeterUtils.labelFor((Component)((Object)variablesTextAreaJSP), "function_helper_dialog_variables"));
        resultsPanel.add((Component)((Object)variablesTextAreaJSP));
        this.getContentPane().add((Component)resultsPanel, "South");
        this.pack();
        ComponentUtil.centerComponentInWindow((Component)this);
    }

    private void initializeFunctionList() {
        String[] functionNames = CompoundVariable.getFunctionNames();
        Arrays.sort(functionNames, String::compareToIgnoreCase);
        this.functionList = new JLabeledChoice(JMeterUtils.getResString("choose_function"), Arrays.stream(functionNames).map(e -> e.substring(FUNCTION_PREFIX.length())).collect(Collectors.toList()).toArray(new String[0]));
        this.functionList.addChangeListener((ChangeListener)this);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        try {
            this.initParameterPanel();
            this.getContentPane().remove(this.parameterPanel);
            this.pack();
            this.getContentPane().add((Component)this.parameterPanel, "Center");
            this.pack();
            this.validate();
            this.resultTextArea.setText("");
            this.repaint();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            log.info("Exception during stateChanged", (Throwable)ex);
        }
    }

    protected void initParameterPanel() throws InstantiationException, IllegalAccessException {
        Function function;
        Arguments args = new Arguments();
        String functionName = FunctionHelper.getFunctionName(this.functionList.getText());
        try {
            function = CompoundVariable.getFunctionClass(functionName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            InstantiationException ex = new InstantiationException("Unable to instantiate " + functionName);
            ex.initCause(e instanceof InvocationTargetException ? e.getCause() : e);
            throw ex;
        }
        List<String> argumentDesc = function.getArgumentDesc();
        for (String help : argumentDesc) {
            args.addArgument(help, "");
        }
        this.parameterPanel.configure(args);
        this.parameterPanel.revalidate();
    }

    private static final String getFunctionName(String text) {
        return FUNCTION_PREFIX + text;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (GENERATE.equals(actionCommand)) {
            String functionName = FunctionHelper.getFunctionName(this.functionList.getText());
            Arguments args = (Arguments)this.parameterPanel.createTestElement();
            String functionCall = FunctionHelper.buildFunctionCallString(functionName, args);
            this.cutPasteFunction.setText(functionCall);
            this.cutPasteFunction.setEnabled(true);
            GuiUtils.copyTextToClipboard((String)this.cutPasteFunction.getText());
            CompoundVariable function = new CompoundVariable(functionCall);
            JMeterContext threadContext = JMeterContextService.getContext();
            threadContext.setVariables(this.jMeterVariables);
            threadContext.setThreadNum(1);
            threadContext.getVariables().put("JMeterThread.last_sample_ok", "true");
            ThreadGroup threadGroup = new ThreadGroup();
            threadGroup.setName("FunctionHelper-Dialog-ThreadGroup");
            threadContext.setThreadGroup(threadGroup);
            try {
                this.resultTextArea.setText(function.execute().trim());
            }
            catch (Exception ex) {
                log.error("Error calling function {}", (Object)functionCall, (Object)ex);
                this.resultTextArea.setText(ex.getMessage() + ", \nstacktrace:\n " + ExceptionUtils.getStackTrace((Throwable)ex));
                this.resultTextArea.setCaretPosition(0);
            }
            this.variablesTextArea.setText(FunctionHelper.variablesToString(this.jMeterVariables));
        } else {
            this.jMeterVariables = new JMeterVariables();
            this.variablesTextArea.setText(FunctionHelper.variablesToString(this.jMeterVariables));
        }
    }

    private static String variablesToString(JMeterVariables jMeterVariables) {
        StringBuilder sb = new StringBuilder();
        jMeterVariables.entrySet().forEach(e -> sb.append((String)e.getKey()).append("=").append(e.getValue()).append("\r\n"));
        return sb.toString();
    }

    private static String buildFunctionCallString(String functionName, Arguments args) {
        StringBuilder functionCall = new StringBuilder("${");
        functionCall.append(functionName);
        if (args.getArguments().size() > 0) {
            functionCall.append("(");
            PropertyIterator iter = args.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                Argument arg = (Argument)iter.next().getObjectValue();
                if (!first) {
                    functionCall.append(",");
                }
                functionCall.append(FunctionHelper.escapeCommata(arg.getValue()));
                first = false;
            }
            functionCall.append(")");
        }
        functionCall.append("}");
        return functionCall.toString();
    }

    private static String escapeCommata(String arg) {
        int level = 0;
        StringBuilder result = new StringBuilder(arg.length());
        try (StringReader r = new StringReader(arg);){
            int c;
            int lastChar = 32;
            while ((c = ((Reader)r).read()) != -1) {
                char nextChar = (char)c;
                if (lastChar == 92) {
                    lastChar = 32;
                } else if (lastChar == 36 && nextChar == '{') {
                    ++level;
                    lastChar = 32;
                } else if (nextChar == '}') {
                    --level;
                    lastChar = 32;
                } else if (nextChar == ',' && level == 0) {
                    result.append('\\');
                    lastChar = 32;
                } else {
                    lastChar = nextChar;
                }
                result.append(nextChar);
            }
        }
        catch (IOException e) {
            log.warn("Can't escape commata in input string: {}", (Object)arg, (Object)e);
            return arg;
        }
        return result.toString();
    }

    @Override
    public void localeChanged(LocaleChangeEvent event) {
        this.setTitle(JMeterUtils.getResString("function_helper_title"));
        this.getContentPane().removeAll();
        this.init();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.initParameterPanel();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                log.error("Error initializing parameter panel", (Throwable)ex);
            }
        }
    }

    private class HelpListener
    implements ActionListener {
        private HelpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] source = new String[]{Help.HELP_FUNCTIONS, FunctionHelper.getFunctionName(FunctionHelper.this.functionList.getText())};
            ActionRouter.getInstance().doActionNow(new ActionEvent(source, e.getID(), "help"));
        }
    }
}

