/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.jmeter.engine.util.PropertyTransformer;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL, since="5.6")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/apache/jmeter/engine/util/DeepPropertyTransformer;", "Lorg/apache/jmeter/engine/util/PropertyTransformer;", "simpleTransformer", "(Lorg/apache/jmeter/engine/util/PropertyTransformer;)V", "getNewPropsOrNull", "", "Lorg/apache/jmeter/testelement/property/JMeterProperty;", "input", "Lorg/apache/jmeter/testelement/property/MultiProperty;", "processMultiProperty", "transform", "Companion", "ApacheJMeter_core"})
@SourceDebugExtension(value={"SMAP\nDeepPropertyTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepPropertyTransformer.kt\norg/apache/jmeter/engine/util/DeepPropertyTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class DeepPropertyTransformer
implements PropertyTransformer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PropertyTransformer simpleTransformer;
    private static final Logger log = LoggerFactory.getLogger(DeepPropertyTransformer.class);

    public DeepPropertyTransformer(@NotNull PropertyTransformer simpleTransformer) {
        Intrinsics.checkNotNullParameter((Object)simpleTransformer, (String)"simpleTransformer");
        this.simpleTransformer = simpleTransformer;
    }

    @Override
    @NotNull
    public JMeterProperty transform(@NotNull JMeterProperty input) {
        JMeterProperty jMeterProperty;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        log.debug("Processing property {}", (Object)input);
        if (input instanceof MultiProperty) {
            MultiProperty multiProperty = this.processMultiProperty((MultiProperty)input);
            if (multiProperty == null) {
                multiProperty = (MultiProperty)input;
            }
            jMeterProperty = multiProperty;
        } else {
            jMeterProperty = this.simpleTransformer.transform(input);
        }
        return jMeterProperty;
    }

    private final MultiProperty processMultiProperty(MultiProperty input) {
        MultiProperty multiProperty;
        List<JMeterProperty> list = this.getNewPropsOrNull(input);
        if (list != null) {
            List<JMeterProperty> props = list;
            boolean bl = false;
            log.debug("About to replace values in MultiProperty {} with new ones: {}", (Object)input, props);
            input.clear();
            for (JMeterProperty prop : props) {
                input.addProperty(prop);
            }
            multiProperty = input;
        } else {
            multiProperty = null;
        }
        return multiProperty;
    }

    private final List<JMeterProperty> getNewPropsOrNull(MultiProperty input) {
        List list;
        List props = new ArrayList();
        boolean hasTransformations = false;
        PropertyIterator propertyIterator = input.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)propertyIterator, (String)"input.iterator()");
        PropertyIterator it = propertyIterator;
        while (it.hasNext()) {
            JMeterProperty newValue;
            JMeterProperty jMeterProperty;
            JMeterProperty property = it.next();
            if (property instanceof MultiProperty) {
                MultiProperty multiProperty;
                Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
                MultiProperty res = this.processMultiProperty((MultiProperty)property);
                if (res != null) {
                    MultiProperty multiProperty2;
                    MultiProperty it2 = multiProperty2;
                    boolean bl = false;
                    hasTransformations = true;
                    multiProperty = multiProperty2;
                } else {
                    multiProperty = (MultiProperty)property;
                }
                jMeterProperty = multiProperty;
            } else {
                String string = property.getName();
                if (Intrinsics.areEqual((Object)string, (Object)"TestElement.gui_class") ? true : Intrinsics.areEqual((Object)string, (Object)"TestElement.test_class")) {
                    jMeterProperty = property;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
                    jMeterProperty = newValue = this.transform(property);
                }
            }
            if (property != newValue) {
                hasTransformations = true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)newValue, (String)"newValue");
            props.add(newValue);
        }
        List it3 = list = props;
        boolean bl = false;
        return hasTransformations ? list : null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/jmeter/engine/util/DeepPropertyTransformer$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ApacheJMeter_core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

