/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J1\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0003H\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\b\u0010 \u001a\u00020\u0003H\u0002J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000J\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010$J\u0006\u0010%\u001a\u00020\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/BlockRealMatrix;", "", "rows", "", "columns", "(II)V", "rawData", "", "", "([[D)V", "BLOCK_SIZE", "blockColumns", "blockRows", "blocks", "[[D", "blockHeight", "blockRow", "blockWidth", "blockColumn", "create", "", "blockData", "copyArray", "", "(II[[DZ)V", "createBlocksLayout", "(II)[[D", "getColumnDimension", "getEntry", "", "row", "column", "getRowDimension", "multiply", "m", "toBlocksLayout", "([[D)[[D", "transpose", "plot-base-portable"})
public final class BlockRealMatrix {
    private final int BLOCK_SIZE;
    private int rows;
    private int columns;
    private int blockRows;
    private int blockColumns;
    private double[][] blocks;

    public BlockRealMatrix(int rows, int columns) {
        this.BLOCK_SIZE = 52;
        this.rows = rows;
        this.columns = columns;
        this.blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        this.blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        this.blocks = this.createBlocksLayout(rows, columns);
    }

    public BlockRealMatrix(@NotNull double[][] rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        this.BLOCK_SIZE = 52;
        this.create(((Object[])rawData).length, rawData[0].length, this.toBlocksLayout(rawData), false);
    }

    public final void create(int rows, int columns, @NotNull double[][] blockData, boolean copyArray) {
        Intrinsics.checkNotNullParameter((Object)blockData, (String)"blockData");
        this.rows = rows;
        this.columns = columns;
        this.blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        this.blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        ArrayList<double[]> blocksCopyList = new ArrayList<double[]>();
        if (!copyArray) {
            this.blocks = blockData;
        }
        int index = 0;
        int n = this.blockRows;
        for (int iBlock = 0; iBlock < n; ++iBlock) {
            int iHeight = this.blockHeight(iBlock);
            int jBlock = 0;
            while (jBlock < this.blockColumns) {
                if (blockData[index].length != iHeight * this.blockWidth(jBlock)) {
                    throw new IllegalStateException("".toString());
                }
                if (copyArray) {
                    double[] dArray = blockData[index];
                    double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
                    Intrinsics.checkNotNullExpressionValue((Object)dArray2, (String)"copyOf(this, size)");
                    blocksCopyList.add(dArray2);
                }
                ++jBlock;
                ++index;
            }
        }
        if (copyArray) {
            Collection $this$toTypedArray$iv = blocksCopyList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.blocks = (double[][])thisCollection$iv.toArray((T[])new double[0][]);
        }
    }

    private final double[][] createBlocksLayout(int rows, int columns) {
        int blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        int blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        ArrayList<double[]> blocksList = new ArrayList<double[]>();
        int blockIndex = 0;
        for (int iBlock = 0; iBlock < blockRows; ++iBlock) {
            int pStart = iBlock * this.BLOCK_SIZE;
            int pEnd = Math.min(pStart + this.BLOCK_SIZE, rows);
            int iHeight = pEnd - pStart;
            for (int jBlock = 0; jBlock < blockColumns; ++jBlock) {
                int qStart = jBlock * this.BLOCK_SIZE;
                int qEnd = Math.min(qStart + this.BLOCK_SIZE, columns);
                int jWidth = qEnd - qStart;
                blocksList.add(new double[iHeight * jWidth]);
                ++blockIndex;
            }
        }
        Collection $this$toTypedArray$iv = blocksList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (double[][])thisCollection$iv.toArray((T[])new double[0][]);
    }

    @NotNull
    public final BlockRealMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BlockRealMatrix out = new BlockRealMatrix(nCols, nRows);
        int blockIndex = 0;
        int n = this.blockColumns;
        for (int iBlock = 0; iBlock < n; ++iBlock) {
            int n2 = this.blockRows;
            for (int jBlock = 0; jBlock < n2; ++jBlock) {
                double[][] dArray = out.blocks;
                if (out.blocks == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                    dArray = null;
                }
                double[] outBlock = dArray[blockIndex];
                double[][] dArray2 = this.blocks;
                if (this.blocks == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                    dArray2 = null;
                }
                double[] tBlock = dArray2[jBlock * this.blockColumns + iBlock];
                int pStart = iBlock * this.BLOCK_SIZE;
                int pEnd = Math.min(pStart + this.BLOCK_SIZE, this.columns);
                int qStart = jBlock * this.BLOCK_SIZE;
                int qEnd = Math.min(qStart + this.BLOCK_SIZE, this.rows);
                int k = 0;
                for (int p = pStart; p < pEnd; ++p) {
                    int lInc = pEnd - pStart;
                    int l = p - pStart;
                    for (int q = qStart; q < qEnd; ++q) {
                        outBlock[k] = tBlock[l];
                        ++k;
                        l += lInc;
                    }
                }
                ++blockIndex;
            }
        }
        return out;
    }

    @NotNull
    public final BlockRealMatrix multiply(@NotNull BlockRealMatrix m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        if (this.getColumnDimension() != m.getRowDimension()) {
            throw new IllegalStateException(("Matrix multiply dimension mismatch: " + this.getColumnDimension() + " x " + m.getRowDimension()).toString());
        }
        BlockRealMatrix out = new BlockRealMatrix(this.rows, m.columns);
        int blockIndex = 0;
        int n = out.blockRows;
        for (int iBlock = 0; iBlock < n; ++iBlock) {
            int pStart = iBlock * this.BLOCK_SIZE;
            int pEnd = Math.min(pStart + this.BLOCK_SIZE, this.rows);
            int n2 = out.blockColumns;
            for (int jBlock = 0; jBlock < n2; ++jBlock) {
                int jWidth = out.blockWidth(jBlock);
                int jWidth2 = jWidth + jWidth;
                int jWidth3 = jWidth2 + jWidth;
                int jWidth4 = jWidth3 + jWidth;
                double[][] dArray = out.blocks;
                if (out.blocks == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                    dArray = null;
                }
                double[] outBlock = dArray[blockIndex];
                int n3 = this.blockColumns;
                for (int kBlock = 0; kBlock < n3; ++kBlock) {
                    int kWidth = this.blockWidth(kBlock);
                    double[][] dArray2 = this.blocks;
                    if (this.blocks == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                        dArray2 = null;
                    }
                    double[] tBlock = dArray2[iBlock * this.blockColumns + kBlock];
                    double[][] dArray3 = m.blocks;
                    if (m.blocks == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                        dArray3 = null;
                    }
                    double[] mBlock = dArray3[kBlock * m.blockColumns + jBlock];
                    int k = 0;
                    for (int p = pStart; p < pEnd; ++p) {
                        int lStart = (p - pStart) * kWidth;
                        int lEnd = lStart + kWidth;
                        for (int nStart = 0; nStart < jWidth; ++nStart) {
                            double sum = 0.0;
                            int l = lStart;
                            int n4 = nStart;
                            while (l < lEnd - 3) {
                                sum += tBlock[l] * mBlock[n4] + tBlock[l + 1] * mBlock[n4 + jWidth] + tBlock[l + 2] * mBlock[n4 + jWidth2] + tBlock[l + 3] * mBlock[n4 + jWidth3];
                                l += 4;
                                n4 += jWidth4;
                            }
                            while (l < lEnd) {
                                sum += tBlock[l++] * mBlock[n4];
                                n4 += jWidth;
                            }
                            int n5 = k++;
                            outBlock[n5] = outBlock[n5] + sum;
                        }
                    }
                }
                ++blockIndex;
            }
        }
        return out;
    }

    public final double getEntry(int row, int column) {
        if (row < 0 || row > this.getRowDimension()) {
            throw new IllegalStateException(("row out of range: " + row).toString());
        }
        if (column < 0 || column > this.getColumnDimension()) {
            throw new IllegalStateException(("column out of range: " + column).toString());
        }
        int iBlock = row / this.BLOCK_SIZE;
        int jBlock = column / this.BLOCK_SIZE;
        int k = (row - iBlock * this.BLOCK_SIZE) * this.blockWidth(jBlock) + (column - jBlock * this.BLOCK_SIZE);
        double[][] dArray = this.blocks;
        if (this.blocks == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
            dArray = null;
        }
        return dArray[iBlock * this.blockColumns + jBlock][k];
    }

    private final int getRowDimension() {
        return this.rows;
    }

    private final int getColumnDimension() {
        return this.columns;
    }

    private final int blockWidth(int blockColumn) {
        return blockColumn == this.blockColumns - 1 ? this.columns - blockColumn * this.BLOCK_SIZE : this.BLOCK_SIZE;
    }

    private final int blockHeight(int blockRow) {
        return blockRow == this.blockRows - 1 ? this.rows - blockRow * this.BLOCK_SIZE : this.BLOCK_SIZE;
    }

    @NotNull
    public final double[][] toBlocksLayout(@NotNull double[][] rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        int rows = ((Object[])rawData).length;
        int columns = rawData[0].length;
        int blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        int blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        int n = ((Object[])rawData).length;
        for (int i = 0; i < n; ++i) {
            int length = rawData[i].length;
            if (length == columns) continue;
            throw new IllegalStateException(("Wrong dimension: " + columns + ", " + length).toString());
        }
        ArrayList<double[]> blocksList = new ArrayList<double[]>();
        int blockIndex = 0;
        for (int iBlock = 0; iBlock < blockRows; ++iBlock) {
            int pStart = iBlock * this.BLOCK_SIZE;
            int pEnd = Math.min(pStart + this.BLOCK_SIZE, rows);
            int iHeight = pEnd - pStart;
            for (int jBlock = 0; jBlock < blockColumns; ++jBlock) {
                int qStart = jBlock * this.BLOCK_SIZE;
                int qEnd = Math.min(qStart + this.BLOCK_SIZE, columns);
                int jWidth = qEnd - qStart;
                double[] block = new double[iHeight * jWidth];
                blocksList.add(block);
                int index = 0;
                for (int p = pStart; p < pEnd; ++p) {
                    ArraysKt.copyInto((double[])rawData[p], (double[])block, (int)index, (int)qStart, (int)qEnd);
                    index += jWidth;
                }
                ++blockIndex;
            }
        }
        Collection $this$toTypedArray$iv = blocksList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (double[][])thisCollection$iv.toArray((T[])new double[0][]);
    }
}

