/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002=>B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J,\u0010\r\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\\\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f0\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fJ;\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f0\u00112\u0006\u0010\u0017\u001a\u00020\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0000\u00a2\u0006\u0002\b\u001aJ \u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJB\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0 0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000f2\u0006\u0010!\u001a\u00020\u0012H\u0002JA\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0 0\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010&J(\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000fH\u0002JO\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u000f2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010,J)\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0 2\u000e\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000fH\u0000\u00a2\u0006\u0002\b/J3\u00100\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010 2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u00103J.\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u000f2\u0018\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0 0\u000fH\u0002J\"\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000f0\u000f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0002JA\u00108\u001a\u00020\u0007\"\u000e\b\u0000\u00109*\b\u0012\u0004\u0012\u00020\u00130\u000f2\u000e\u00107\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000f2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H90;H\u0000\u00a2\u0006\u0002\b<R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourStatUtil;", "", "()V", "xLoc", "", "yLoc", "checkEdge", "", "edge", "Ljetbrains/datalore/plot/base/stat/ContourStatUtil$Edge;", "colCount", "", "rowCount", "checkEdges", "paths", "", "computeContours", "", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "xRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "yRange", "data", "levels", "Ljetbrains/datalore/plot/base/DataFrame;", "computeContours$plot_base_portable", "computeLevels", "zRange", "binOptions", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "computeSegments", "Lkotlin/Pair;", "level", "computeSegmentsForGridCell", "value5", "col", "row", "(Ljava/lang/Double;[DII)Ljava/util/List;", "confirmPaths", "convertPaths", "xStep", "yStep", "origin", "(Ljava/util/List;DDLjetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;)Ljava/util/List;", "estimateRegularGridShape", "xs", "estimateRegularGridShape$plot_base_portable", "intersectionSegment", "vectors", "Ljetbrains/datalore/plot/base/stat/ContourStatUtil$TripleVector;", "(Ljava/util/List;Ljava/lang/Double;)Lkotlin/Pair;", "joinSegments", "segments", "pathSeparator", "path", "removePathByEndpoints", "T", "pathByEndPoint", "", "removePathByEndpoints$plot_base_portable", "Edge", "TripleVector", "plot-base-portable"})
public final class ContourStatUtil {
    @NotNull
    public static final ContourStatUtil INSTANCE = new ContourStatUtil();
    @NotNull
    private static final double[] xLoc;
    @NotNull
    private static final double[] yLoc;

    private ContourStatUtil() {
    }

    @NotNull
    public final Pair<Integer, Integer> estimateRegularGridShape$plot_base_portable(@NotNull List<Double> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        int colCount = 0;
        Double x0 = null;
        for (Double x : xs) {
            if (x0 == null) {
                x0 = x;
            } else if (Intrinsics.areEqual((Double)x, (Double)x0)) break;
            ++colCount;
        }
        if (colCount <= 1) {
            throw new IllegalArgumentException("Data grid must be at least 2 columns wide (was " + colCount + ')');
        }
        int rowCount = xs.size() / colCount;
        if (rowCount <= 1) {
            throw new IllegalArgumentException("Data grid must be at least 2 rows tall (was " + rowCount + ')');
        }
        return new Pair((Object)colCount, (Object)rowCount);
    }

    @Nullable
    public final List<Double> computeLevels(@NotNull DataFrame data, @NotNull BinStatUtil.BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        if (!(data.has(TransformVar.INSTANCE.getX()) && data.has(TransformVar.INSTANCE.getY()) && data.has(TransformVar.INSTANCE.getZ()))) {
            return null;
        }
        DoubleSpan zRange = data.range(TransformVar.INSTANCE.getZ());
        return this.computeLevels(zRange, binOptions);
    }

    @Nullable
    public final List<Double> computeLevels(@Nullable DoubleSpan zRange, @NotNull BinStatUtil.BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        if (zRange == null || SeriesUtil.INSTANCE.isBeyondPrecision(zRange)) {
            return null;
        }
        BinStatUtil.CountAndWidth b2 = BinStatUtil.INSTANCE.binCountAndWidth(zRange.getLength(), binOptions);
        ArrayList<Double> levels = new ArrayList<Double>();
        int n = b2.getCount();
        for (int i = 0; i < n; ++i) {
            double level = (double)i * b2.getWidth() + zRange.getLowerEnd();
            levels.add(level += b2.getWidth() / (double)2);
        }
        return levels;
    }

    @NotNull
    public final Map<Double, List<List<DoubleVector>>> computeContours$plot_base_portable(@NotNull DataFrame data, @NotNull List<Double> levels) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        List<Double> xVector = data.getNumeric(TransformVar.INSTANCE.getX());
        List<Double> zVector = data.getNumeric(TransformVar.INSTANCE.getZ());
        Pair<Integer, Integer> shape = this.estimateRegularGridShape$plot_base_portable(xVector);
        int colCount = ((Number)shape.getFirst()).intValue();
        int rowCount = ((Number)shape.getSecond()).intValue();
        DoubleSpan doubleSpan = data.range(TransformVar.INSTANCE.getX());
        Intrinsics.checkNotNull((Object)doubleSpan);
        DoubleSpan xRange = doubleSpan;
        DoubleSpan doubleSpan2 = data.range(TransformVar.INSTANCE.getY());
        Intrinsics.checkNotNull((Object)doubleSpan2);
        DoubleSpan yRange = doubleSpan2;
        return this.computeContours(xRange, yRange, colCount, rowCount, zVector, levels);
    }

    @NotNull
    public final Map<Double, List<List<DoubleVector>>> computeContours(@NotNull DoubleSpan xRange, @NotNull DoubleSpan yRange, int colCount, int rowCount, @NotNull List<Double> data, @NotNull List<Double> levels) {
        Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        double xStep = xRange.getLength() / (double)(colCount - 1);
        double yStep = yRange.getLength() / (double)(rowCount - 1);
        DoubleVector origin = new DoubleVector(xRange.getLowerEnd().doubleValue(), yRange.getLowerEnd().doubleValue());
        HashMap pathListByLevel = new HashMap();
        Iterator<Double> iterator = levels.iterator();
        while (iterator.hasNext()) {
            double level = ((Number)iterator.next()).doubleValue();
            List<Pair<Edge, Edge>> levelSegments = this.computeSegments(colCount, rowCount, data, level);
            List<List<Edge>> paths2 = this.joinSegments(levelSegments);
            List<List<DoubleVector>> pathsReal = this.convertPaths(paths2, xStep, yStep, origin, level);
            pathsReal = this.confirmPaths(pathsReal);
            Double d = level;
            ((Map)pathListByLevel).put(d, pathsReal);
        }
        return pathListByLevel;
    }

    private final List<List<Edge>> joinSegments(List<Pair<Edge, Edge>> segments) {
        ArrayList<List> pathList = new ArrayList<List>();
        HashMap pathByEndPoint = new HashMap();
        for (Pair<Edge, Edge> segment : segments) {
            Edge p0 = (Edge)segment.getFirst();
            Edge p1 = (Edge)segment.getSecond();
            if (pathByEndPoint.containsKey(p0) || pathByEndPoint.containsKey(p1)) {
                List path0 = (List)pathByEndPoint.get(p0);
                List path1 = (List)pathByEndPoint.get(p1);
                if (path0 != null) {
                    pathByEndPoint.remove(path0.get(0));
                    pathByEndPoint.remove(path0.get(path0.size() - 1));
                }
                if (path1 != null) {
                    pathByEndPoint.remove(path1.get(0));
                    pathByEndPoint.remove(path1.get(path1.size() - 1));
                }
                List longPath = null;
                if (path0 == path1) {
                    List list2 = path0;
                    Intrinsics.checkNotNull((Object)list2);
                    list2.add(segment.getSecond());
                    pathList.add(path0);
                    continue;
                }
                if (path0 != null && path1 != null) {
                    longPath = path0;
                    longPath.addAll(path1);
                } else if (path0 == null) {
                    List list3 = path1;
                    Intrinsics.checkNotNull((Object)list3);
                    longPath = list3;
                    longPath.add(0, segment.getFirst());
                } else {
                    longPath = path0;
                    longPath.add(segment.getSecond());
                }
                ((Map)pathByEndPoint).put(longPath.get(0), longPath);
                ((Map)pathByEndPoint).put(longPath.get(longPath.size() - 1), longPath);
                continue;
            }
            ArrayList<Object> path = new ArrayList<Object>();
            path.add(segment.getFirst());
            path.add(segment.getSecond());
            ((Map)pathByEndPoint).put(segment.getFirst(), path);
            ((Map)pathByEndPoint).put(segment.getSecond(), path);
        }
        HashSet pathSet = new HashSet(pathByEndPoint.values());
        for (List path : pathSet) {
            pathList.add(path);
        }
        return pathList;
    }

    private final List<List<DoubleVector>> convertPaths(List<? extends List<Edge>> paths2, double xStep, double yStep, DoubleVector origin, Double level) {
        ArrayList result = new ArrayList();
        for (List<Edge> list2 : paths2) {
            ArrayList<Object> temp = new ArrayList<Object>();
            DoubleVector lastPoint = null;
            for (Edge edge : list2) {
                Double d = level;
                Intrinsics.checkNotNull((Object)d);
                DoubleVector intersect = edge.intersect(d);
                intersect = new DoubleVector(xStep * intersect.getX(), yStep * intersect.getY()).add(origin);
                if (Intrinsics.areEqual((Object)intersect, lastPoint)) continue;
                temp.add(intersect);
                lastPoint = intersect;
            }
            if (Intrinsics.areEqual((Object)list2.get(0), (Object)list2.get(list2.size() - 1)) && !Intrinsics.areEqual(temp.get(0), temp.get(temp.size() - 1))) {
                temp.set(temp.size() - 1, temp.get(0));
            }
            if (temp.size() <= 1) continue;
            result.add(temp);
        }
        return result;
    }

    private final List<List<DoubleVector>> confirmPaths(List<? extends List<DoubleVector>> paths2) {
        ArrayList<List> newPaths = new ArrayList<List>();
        HashMap pathByEndPoint = new HashMap();
        for (List<DoubleVector> list2 : paths2) {
            DoubleVector doubleVector;
            DoubleVector p0 = list2.get(0);
            if (Intrinsics.areEqual((Object)p0, (Object)(doubleVector = list2.get(list2.size() - 1)))) {
                newPaths.add(list2);
                continue;
            }
            if (pathByEndPoint.containsKey(p0) || pathByEndPoint.containsKey(doubleVector)) {
                List path0 = (List)pathByEndPoint.get(p0);
                List path1 = (List)pathByEndPoint.get(doubleVector);
                this.removePathByEndpoints$plot_base_portable(path0, pathByEndPoint);
                this.removePathByEndpoints$plot_base_portable(path1, pathByEndPoint);
                ArrayList longPath = new ArrayList();
                if (path0 == path1) {
                    List list3 = path0;
                    Intrinsics.checkNotNull((Object)list3);
                    longPath.addAll(list3);
                    longPath.addAll(list2.subList(1, list2.size()));
                    newPaths.add(longPath);
                    continue;
                }
                if (path0 != null && path1 != null) {
                    longPath.addAll(path0);
                    longPath.addAll(list2.subList(1, list2.size() - 1));
                    longPath.addAll(path1);
                } else if (path0 == null) {
                    List list4 = path1;
                    Intrinsics.checkNotNull((Object)list4);
                    longPath.addAll(list4);
                    longPath.addAll(0, list2.subList(0, list2.size() - 1));
                } else {
                    longPath.addAll(path0);
                    longPath.addAll(list2.subList(1, list2.size()));
                }
                Map map = pathByEndPoint;
                Object e = longPath.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"longPath[0]");
                map.put(e, longPath);
                map = pathByEndPoint;
                Object e2 = longPath.get(longPath.size() - 1);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"longPath[longPath.size - 1]");
                map.put(e2, longPath);
                continue;
            }
            ((Map)pathByEndPoint).put(list2.get(0), list2);
            ((Map)pathByEndPoint).put(list2.get(list2.size() - 1), list2);
        }
        HashSet pathSet = new HashSet(pathByEndPoint.values());
        for (List path : pathSet) {
            newPaths.add(path);
        }
        ArrayList arrayList = new ArrayList();
        for (List list5 : newPaths) {
            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"path");
            arrayList.addAll(this.pathSeparator(list5));
        }
        return arrayList;
    }

    public final <T extends List<? extends DoubleVector>> void removePathByEndpoints$plot_base_portable(@Nullable List<DoubleVector> path, @NotNull Map<DoubleVector, T> pathByEndPoint) {
        Intrinsics.checkNotNullParameter(pathByEndPoint, (String)"pathByEndPoint");
        if (path != null) {
            pathByEndPoint.remove(path.get(0));
            pathByEndPoint.remove(path.get(path.size() - 1));
        }
    }

    private final List<List<DoubleVector>> pathSeparator(List<DoubleVector> path) {
        ArrayList<List<DoubleVector>> result = new ArrayList<List<DoubleVector>>();
        int startIndex = 0;
        int n = path.size() - 1;
        for (int nextIndex = 1; nextIndex < n; ++nextIndex) {
            if (!Intrinsics.areEqual((Object)path.get(startIndex), (Object)path.get(nextIndex))) continue;
            result.add(path.subList(startIndex, nextIndex + 1));
            startIndex = nextIndex;
        }
        if (startIndex == 0) {
            return CollectionsKt.listOf(path);
        }
        result.add(path.subList(startIndex, path.size()));
        return result;
    }

    private final List<Pair<Edge, Edge>> computeSegments(int colCount, int rowCount, List<Double> data, double level) {
        ArrayList segments = new ArrayList();
        int n = rowCount - 1;
        for (int row = 0; row < n; ++row) {
            int n2 = colCount - 1;
            for (int col = 0; col < n2; ++col) {
                int i0 = row * colCount + col;
                int i1 = row * colCount + col + 1;
                int i2 = (row + 1) * colCount + col + 1;
                int i3 = (row + 1) * colCount + col;
                double[] v = new double[5];
                Double d = data.get(i0);
                Intrinsics.checkNotNull((Object)d);
                v[0] = ((Number)d).doubleValue();
                Double d2 = data.get(i1);
                Intrinsics.checkNotNull((Object)d2);
                v[1] = ((Number)d2).doubleValue();
                Double d3 = data.get(i2);
                Intrinsics.checkNotNull((Object)d3);
                v[2] = ((Number)d3).doubleValue();
                Double d4 = data.get(i3);
                Intrinsics.checkNotNull((Object)d4);
                v[3] = ((Number)d4).doubleValue();
                double min = v[0];
                double max = v[0];
                for (int i = 1; i < 4; ++i) {
                    min = Math.min(min, v[i]);
                    max = Math.max(max, v[i]);
                }
                if (min == max) continue;
                v[4] = (v[0] + v[1] + v[2] + v[3] - min - max) / (double)2;
                if (!(level > min) || !(level <= max)) continue;
                List<Pair<Edge, Edge>> cellSegments = this.computeSegmentsForGridCell(level, v, col, row);
                segments.addAll(cellSegments);
            }
        }
        return segments;
    }

    private final List<Pair<Edge, Edge>> computeSegmentsForGridCell(Double level, double[] value5, int col, int row) {
        int i;
        ArrayList<Pair<Edge, Edge>> result = new ArrayList<Pair<Edge, Edge>>();
        ArrayList<TripleVector> points = new ArrayList<TripleVector>();
        List tempVector = null;
        for (i = 0; i < 5; ++i) {
            points.add(new TripleVector((double)col + xLoc[i], (double)row + yLoc[i], value5[i]));
        }
        for (i = 0; i < 4; ++i) {
            int i1 = (i + 1) % 4;
            tempVector = new ArrayList();
            Object e = points.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"points[i]");
            tempVector.add(e);
            Object e2 = points.get(i1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"points[i1]");
            tempVector.add(e2);
            Object e3 = points.get(4);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"points[4]");
            tempVector.add(e3);
            Pair<Edge, Edge> temp = this.intersectionSegment(tempVector, level);
            if (temp == null) continue;
            result.add(temp);
        }
        return result;
    }

    private final Pair<Edge, Edge> intersectionSegment(List<TripleVector> vectors, Double level) {
        Double d = level;
        Intrinsics.checkNotNull((Object)d);
        int type = vectors.get(0).getType(d) * 100 + vectors.get(1).getType(level) * 10 + vectors.get(2).getType(level);
        Edge start = null;
        Edge end = null;
        switch (type) {
            case 100: {
                start = new Edge(vectors.get(2), vectors.get(0));
                end = new Edge(vectors.get(0), vectors.get(1));
                break;
            }
            case 10: {
                start = new Edge(vectors.get(0), vectors.get(1));
                end = new Edge(vectors.get(1), vectors.get(2));
                break;
            }
            case 1: {
                start = new Edge(vectors.get(1), vectors.get(2));
                end = new Edge(vectors.get(2), vectors.get(0));
                break;
            }
            case 110: {
                start = new Edge(vectors.get(0), vectors.get(2));
                end = new Edge(vectors.get(2), vectors.get(1));
                break;
            }
            case 101: {
                start = new Edge(vectors.get(2), vectors.get(1));
                end = new Edge(vectors.get(1), vectors.get(0));
                break;
            }
            case 11: {
                start = new Edge(vectors.get(1), vectors.get(0));
                end = new Edge(vectors.get(0), vectors.get(2));
                break;
            }
            default: {
                return null;
            }
        }
        return new Pair((Object)start, (Object)end);
    }

    private final void checkEdges(List<? extends List<Edge>> paths2, int colCount, int rowCount) {
        for (List<Edge> list2 : paths2) {
            if (Intrinsics.areEqual((Object)list2.get(0), (Object)list2.get(list2.size() - 1))) continue;
            this.checkEdge(list2.get(0), colCount, rowCount);
            this.checkEdge(list2.get(list2.size() - 1), colCount, rowCount);
        }
    }

    private final void checkEdge(Edge edge, int colCount, int rowCount) {
        TripleVector a2 = edge.getMyA();
        TripleVector b2 = edge.getMyB();
        if (a2.getMyX() == 0 && b2.getMyX() == 0) {
            return;
        }
        if (a2.getMyY() == 0 && b2.getMyY() == 0) {
            return;
        }
        if (a2.getMyX() == colCount - 1 && b2.getMyX() == colCount - 1) {
            return;
        }
        if (a2.getMyY() == rowCount - 1 && b2.getMyY() == rowCount - 1) {
            return;
        }
        throw new IllegalArgumentException("Check Edge Failed");
    }

    static {
        double[] dArray = new double[]{0.0, 1.0, 1.0, 0.0, 0.5};
        xLoc = dArray;
        dArray = new double[]{0.0, 0.0, 1.0, 1.0, 0.5};
        yLoc = dArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0003J\b\u0010\u001b\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourStatUtil$TripleVector;", "", "x", "", "y", "z", "(DDD)V", "coord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getCoord", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "myIsCenter", "", "myX", "getMyX", "()I", "myY", "getMyY", "getX", "()D", "getY", "getZ", "equals", "", "other", "getType", "level", "hashCode", "plot-base-portable"})
    private static final class TripleVector {
        private final double z;
        private final int myX;
        private final int myY;
        private final int myIsCenter;

        public TripleVector(double x, double y, double z) {
            this.z = z;
            this.myX = (int)x;
            this.myY = (int)y;
            this.myIsCenter = x % 1.0 == 0.0 ? 0 : 1;
        }

        public final double getZ() {
            return this.z;
        }

        public final int getMyX() {
            return this.myX;
        }

        public final int getMyY() {
            return this.myY;
        }

        @NotNull
        public final DoubleVector getCoord() {
            return new DoubleVector(this.getX(), this.getY());
        }

        public final double getX() {
            return (double)this.myX + 0.5 * (double)this.myIsCenter;
        }

        public final double getY() {
            return (double)this.myY + 0.5 * (double)this.myIsCenter;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
                return false;
            }
            TripleVector that = (TripleVector)other;
            return this.myX == that.myX && this.myY == that.myY && this.myIsCenter == that.myIsCenter;
        }

        public int hashCode() {
            Integer[] integerArray = new Integer[]{this.myX, this.myY, this.myIsCenter};
            return integerArray.hashCode();
        }

        public final int getType(double level) {
            return this.z >= level ? 1 : 0;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourStatUtil$Edge;", "", "myA", "Ljetbrains/datalore/plot/base/stat/ContourStatUtil$TripleVector;", "myB", "(Ljetbrains/datalore/plot/base/stat/ContourStatUtil$TripleVector;Ljetbrains/datalore/plot/base/stat/ContourStatUtil$TripleVector;)V", "getMyA", "()Ljetbrains/datalore/plot/base/stat/ContourStatUtil$TripleVector;", "getMyB", "equals", "", "other", "hashCode", "", "intersect", "Ljetbrains/datalore/base/geometry/DoubleVector;", "level", "", "plot-base-portable"})
    private static final class Edge {
        @NotNull
        private final TripleVector myA;
        @NotNull
        private final TripleVector myB;

        public Edge(@NotNull TripleVector myA, @NotNull TripleVector myB) {
            Intrinsics.checkNotNullParameter((Object)myA, (String)"myA");
            Intrinsics.checkNotNullParameter((Object)myB, (String)"myB");
            this.myA = myA;
            this.myB = myB;
        }

        @NotNull
        public final TripleVector getMyA() {
            return this.myA;
        }

        @NotNull
        public final TripleVector getMyB() {
            return this.myB;
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge obj = (Edge)other;
            return Intrinsics.areEqual((Object)this.myA, (Object)obj.myA) && Intrinsics.areEqual((Object)this.myB, (Object)obj.myB) || Intrinsics.areEqual((Object)this.myA, (Object)obj.myB) && Intrinsics.areEqual((Object)this.myB, (Object)obj.myA);
        }

        public int hashCode() {
            return this.myA.getCoord().hashCode() + this.myB.getCoord().hashCode();
        }

        @NotNull
        public final DoubleVector intersect(double level) {
            double z0 = this.myA.getZ();
            double z1 = this.myB.getZ();
            if (level == z0) {
                return this.myA.getCoord();
            }
            if (level == z1) {
                return this.myB.getCoord();
            }
            double ratio = (z1 - z0) / (level - z0);
            double x0 = this.myA.getX();
            double y0 = this.myA.getY();
            double x1 = this.myB.getX();
            double y1 = this.myB.getY();
            double x = x0 + (x1 - x0) / ratio;
            double y = y0 + (y1 - y0) / ratio;
            return new DoubleVector(x, y);
        }
    }
}

