/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.render.point.symbol;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.render.point.symbol.CircleGlyph;
import jetbrains.datalore.plot.base.render.point.symbol.CrossGlyph;
import jetbrains.datalore.plot.base.render.point.symbol.DiamondGlyph;
import jetbrains.datalore.plot.base.render.point.symbol.Glyph;
import jetbrains.datalore.plot.base.render.point.symbol.GlyphPair;
import jetbrains.datalore.plot.base.render.point.symbol.PlusGlyph;
import jetbrains.datalore.plot.base.render.point.symbol.SquareGlyph;
import jetbrains.datalore.plot.base.render.point.symbol.TriangleGlyph;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u001e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u001e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/base/render/point/symbol/Glyphs;", "", "()V", "circle", "Ljetbrains/datalore/plot/base/render/point/symbol/Glyph;", "location", "Ljetbrains/datalore/base/geometry/DoubleVector;", "width", "", "diamond", "square", "stickCircleCross", "size", "stroke", "stickCirclePlus", "stickCross", "stickDiamondPlus", "stickPlus", "stickSquareCross", "stickSquarePlus", "stickSquareTriangleUp", "stickStar", "stickTriangleUpDown", "triangleDown", "triangleUp", "plot-base-portable"})
public final class Glyphs {
    @NotNull
    public static final Glyphs INSTANCE = new Glyphs();

    private Glyphs() {
    }

    @NotNull
    public final Glyph square(@NotNull DoubleVector location, double width2) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new SquareGlyph(location, width2);
    }

    @NotNull
    public final Glyph circle(@NotNull DoubleVector location, double width2) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new CircleGlyph(location, width2);
    }

    @NotNull
    public final Glyph diamond(@NotNull DoubleVector location, double width2) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new DiamondGlyph(location, width2);
    }

    @NotNull
    public final Glyph triangleUp(@NotNull DoubleVector location, double width2, double stroke) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new TriangleGlyph(location, width2, stroke, true, false, false, 48, null);
    }

    @NotNull
    public final Glyph triangleDown(@NotNull DoubleVector location, double width2, double stroke) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new TriangleGlyph(location, width2, stroke, false, false, false, 48, null);
    }

    @NotNull
    public final Glyph stickPlus(@NotNull DoubleVector location, double width2) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new PlusGlyph(location, width2);
    }

    @NotNull
    public final Glyph stickCross(@NotNull DoubleVector location, double width2) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new CrossGlyph(location, width2, false, 4, null);
    }

    @NotNull
    public final Glyph stickSquareCross(@NotNull DoubleVector location, double size) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new GlyphPair(new SquareGlyph(location, size), new CrossGlyph(location, size, false));
    }

    @NotNull
    public final Glyph stickStar(@NotNull DoubleVector location, double size) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new GlyphPair(new PlusGlyph(location, size), new CrossGlyph(location, size, false, 4, null));
    }

    @NotNull
    public final Glyph stickDiamondPlus(@NotNull DoubleVector location, double size) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new GlyphPair(new DiamondGlyph(location, size), new PlusGlyph(location, size));
    }

    @NotNull
    public final Glyph stickCirclePlus(@NotNull DoubleVector location, double size, double stroke) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new GlyphPair(new CircleGlyph(location, size), new PlusGlyph(location, size + stroke));
    }

    @NotNull
    public final Glyph stickTriangleUpDown(@NotNull DoubleVector location, double size, double stroke) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new GlyphPair(new TriangleGlyph(location, size, stroke, true, true, false, 32, null), new TriangleGlyph(location, size, stroke, false, true, false, 32, null));
    }

    @NotNull
    public final Glyph stickSquarePlus(@NotNull DoubleVector location, double size, double stroke) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new GlyphPair(new SquareGlyph(location, size), new PlusGlyph(location, size + stroke));
    }

    @NotNull
    public final Glyph stickCircleCross(@NotNull DoubleVector location, double size, double stroke) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new GlyphPair(new CircleGlyph(location, size), new CrossGlyph(location, size + stroke, false, 4, null));
    }

    @NotNull
    public final Glyph stickSquareTriangleUp(@NotNull DoubleVector location, double size, double stroke) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return new GlyphPair(new SquareGlyph(location, size), new TriangleGlyph(location, size, stroke, true, false, true));
    }
}

