/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.PointLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.PointRangeGeom;
import jetbrains.datalore.plot.base.geom.legend.CompositeLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.legend.VLineLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.util.BarTooltipHelper;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.point.PointShape;
import jetbrains.datalore.plot.base.render.point.PointShapeSvg;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.slim.SvgSlimObject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/base/geom/PointRangeGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "fattenMidPoint", "", "getFattenMidPoint", "()D", "setFattenMidPoint", "(D)V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "plot-base-portable"})
public final class PointRangeGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double fattenMidPoint = 5.0;
    public static final boolean HANDLES_GROUPS = false;
    public static final double DEF_FATTEN = 5.0;

    public final double getFattenMidPoint() {
        return this.fattenMidPoint;
    }

    public final void setFattenMidPoint(double d) {
        this.fattenMidPoint = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        LegendKeyElementFactory[] legendKeyElementFactoryArray = new LegendKeyElementFactory[]{new VLineLegendKeyElementFactory(), new PointLegendKeyElementFactory(5.0)};
        return new CompositeLegendKeyElementFactory(legendKeyElementFactoryArray);
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        GeomHelper.SvgElementHelper helper = geomHelper.createSvgElementHelper();
        helper.setStrokeAlphaEnabled(true);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.POINT_RANGE, ctx);
        for (DataPointAesthetics p : GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getYMIN(), Aes.Companion.getYMAX())) {
            DoubleVector location;
            PointShape shape;
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double x = d;
            Double d2 = p.y();
            Intrinsics.checkNotNull((Object)d2);
            double y = d2;
            Double d3 = p.ymin();
            Intrinsics.checkNotNull((Object)d3);
            double ymin = d3;
            Double d4 = p.ymax();
            Intrinsics.checkNotNull((Object)d4);
            DoubleVector start = new DoubleVector(x, ymin);
            double ymax = d4;
            DoubleVector end = new DoubleVector(x, ymax);
            SvgLineElement line = helper.createLine(start, end, p);
            if (line == null) continue;
            root.add((SvgNode)line);
            Intrinsics.checkNotNull((Object)geomHelper.toClient(new DoubleVector(x, y), p));
            Intrinsics.checkNotNull((Object)p.shape());
            SvgSlimObject o = PointShapeSvg.INSTANCE.create(shape, location, p, this.fattenMidPoint);
            root.add((SvgNode)GeomBase.Companion.wrap(o));
        }
        Object[] objectArray = new Aes[]{Aes.Companion.getYMAX(), Aes.Companion.getYMIN()};
        BarTooltipHelper.collectRectangleTargets$default(BarTooltipHelper.INSTANCE, CollectionsKt.listOf((Object[])objectArray), aesthetics, pos, coord, ctx, PointRangeGeom.Companion.clientRectByDataPoint(ctx, geomHelper, this.fattenMidPoint), buildIntern.1.INSTANCE, colorsByDataPoint, null, 256, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/base/geom/PointRangeGeom$Companion;", "", "()V", "DEF_FATTEN", "", "HANDLES_GROUPS", "", "clientRectByDataPoint", "Lkotlin/Function1;", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "fatten", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx, GeomHelper geomHelper, double fatten) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(geomHelper, fatten, ctx){
                final /* synthetic */ GeomHelper $geomHelper;
                final /* synthetic */ double $fatten;
                final /* synthetic */ GeomContext $ctx;
                {
                    this.$geomHelper = $geomHelper;
                    this.$fatten = $fatten;
                    this.$ctx = $ctx;
                    super(1);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                    DoubleRectangle doubleRectangle;
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (p.defined(Aes.Companion.getX()) && p.defined(Aes.Companion.getY())) {
                        Double d = p.x();
                        Intrinsics.checkNotNull((Object)d);
                        double x = d;
                        Double d2 = p.y();
                        Intrinsics.checkNotNull((Object)d2);
                        double y = d2;
                        PointShape pointShape = p.shape();
                        Intrinsics.checkNotNull((Object)pointShape);
                        PointShape shape = pointShape;
                        DoubleRectangle doubleRectangle2 = this.$geomHelper.toClient(new DoubleRectangle(new DoubleVector(x, y), DoubleVector.Companion.getZERO()), p);
                        Intrinsics.checkNotNull((Object)doubleRectangle2);
                        DoubleRectangle rect = doubleRectangle2;
                        double shapeSize = shape.size(p, this.$fatten);
                        double strokeWidth = shape.strokeWidth(p);
                        double width2 = shapeSize + strokeWidth;
                        doubleRectangle = GeomUtil.INSTANCE.extendWidth$plot_base_portable(rect, width2, this.$ctx.getFlipped());
                    } else {
                        doubleRectangle = null;
                    }
                    return doubleRectangle;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

