/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.coord;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.coord.CoordinatesMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\u0001H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/base/coord/DefaultCoordinateSystem;", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "coordMapper", "Ljetbrains/datalore/plot/base/coord/CoordinatesMapper;", "(Ljetbrains/datalore/plot/base/coord/CoordinatesMapper;)V", "clientBottom", "", "clientLeft", "flip", "toClient", "Ljetbrains/datalore/base/geometry/DoubleVector;", "p", "toScreen", "unitSize", "plot-base-portable"})
public final class DefaultCoordinateSystem
implements CoordinateSystem {
    @NotNull
    private final CoordinatesMapper coordMapper;
    private final double clientLeft;
    private final double clientBottom;

    public DefaultCoordinateSystem(@NotNull CoordinatesMapper coordMapper) {
        Intrinsics.checkNotNullParameter((Object)coordMapper, (String)"coordMapper");
        this.coordMapper = coordMapper;
        this.clientLeft = this.coordMapper.getClientBounds().xRange().getLowerEnd();
        this.clientBottom = this.coordMapper.getClientBounds().yRange().getUpperEnd();
    }

    @Override
    @Nullable
    public DoubleVector toClient(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector mapped = this.coordMapper.toClient(p);
        return mapped != null ? this.toScreen(mapped) : null;
    }

    @Override
    @NotNull
    public DoubleVector unitSize(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.coordMapper.unitSize(p);
    }

    @Override
    @NotNull
    public CoordinateSystem flip() {
        return new DefaultCoordinateSystem(this.coordMapper.flip());
    }

    private final DoubleVector toScreen(DoubleVector p) {
        double x = p.getX() - this.clientLeft;
        double y = this.clientBottom - p.getY();
        return new DoubleVector(x, y);
    }

    @Override
    @Nullable
    public DoubleRectangle toClient(@NotNull DoubleRectangle r) {
        return CoordinateSystem.DefaultImpls.toClient(this, r);
    }
}

