/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import jetbrains.datalore.base.spatial.GeographicKt;
import jetbrains.datalore.base.spatial.LonLat;
import jetbrains.datalore.base.spatial.QuadKey;
import jetbrains.datalore.base.spatial.QuadsKt;
import jetbrains.datalore.base.typedGeometry.ExtensionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import jetbrains.datalore.base.typedGeometry.Scalar;
import jetbrains.datalore.base.typedGeometry.Vec;
import jetbrains.datalore.base.typedGeometry.VecKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0005\u001a*\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0005\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\u0005*\b\u0012\u0004\u0012\u00020\t0\u0003\u001a0\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0005\u001a0\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0005\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u00070\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0005\u001a\u0010\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\t0\u0003\u00a8\u0006\u000f"}, d2={"computeOrigin", "Ljetbrains/datalore/base/typedGeometry/Vec;", "TypeT", "Ljetbrains/datalore/base/spatial/QuadKey;", "mapRect", "Ljetbrains/datalore/base/typedGeometry/Rect;", "computeRect", "T", "rect", "Ljetbrains/datalore/base/spatial/LonLat;", "projectOrigin", "OutT", "projectRect", "zoom", "", "base-portable"})
public final class QuadKeyKt {
    @NotNull
    public static final Rect<LonLat> computeRect(@NotNull QuadKey<LonLat> $this$computeRect) {
        Intrinsics.checkNotNullParameter($this$computeRect, (String)"<this>");
        Vec<LonLat> origin = QuadKeyKt.computeOrigin($this$computeRect, GeographicKt.getEARTH_RECT());
        Vec<LonLat> dimension = ExtensionsKt.div(GeographicKt.getEARTH_RECT().getDimension(), QuadsKt.calulateQuadsCount($this$computeRect.getLength()));
        double flippedY = ExtensionsKt.minus-dQIoAX8(ExtensionsKt.getScalarBottom(GeographicKt.getEARTH_RECT()), ExtensionsKt.minus-dQIoAX8(ExtensionsKt.plus-dQIoAX8(ExtensionsKt.getScalarY(origin), ExtensionsKt.getScalarY(dimension)), ExtensionsKt.getScalarTop(GeographicKt.getEARTH_RECT())));
        return Rect.Companion.XYWH(ExtensionsKt.transform$default(origin, null, (Function1)new Function1<Scalar<LonLat>, Scalar<LonLat>>(flippedY){
            final /* synthetic */ double $flippedY;
            {
                this.$flippedY = $flippedY;
                super(1);
            }

            public final double invoke-FjwMtaM(double it) {
                return this.$flippedY;
            }
        }, 1, null), dimension);
    }

    @NotNull
    public static final <T> Rect<T> computeRect(@NotNull QuadKey<T> $this$computeRect, @NotNull Rect<T> rect) {
        Intrinsics.checkNotNullParameter($this$computeRect, (String)"<this>");
        Intrinsics.checkNotNullParameter(rect, (String)"rect");
        return QuadKeyKt.projectRect($this$computeRect, rect);
    }

    @NotNull
    public static final <T, OutT> Rect<OutT> projectRect(@NotNull QuadKey<T> $this$projectRect, @NotNull Rect<OutT> rect) {
        Intrinsics.checkNotNullParameter($this$projectRect, (String)"<this>");
        Intrinsics.checkNotNullParameter(rect, (String)"rect");
        return Rect.Companion.XYWH(QuadKeyKt.projectOrigin($this$projectRect, rect), ExtensionsKt.div(rect.getDimension(), QuadsKt.calulateQuadsCount($this$projectRect.getLength())));
    }

    public static final int zoom(@NotNull QuadKey<LonLat> $this$zoom) {
        Intrinsics.checkNotNullParameter($this$zoom, (String)"<this>");
        return $this$zoom.getLength();
    }

    @NotNull
    public static final <TypeT> Vec<TypeT> computeOrigin(@NotNull QuadKey<TypeT> $this$computeOrigin, @NotNull Rect<TypeT> mapRect) {
        Intrinsics.checkNotNullParameter($this$computeOrigin, (String)"<this>");
        Intrinsics.checkNotNullParameter(mapRect, (String)"mapRect");
        return QuadKeyKt.projectOrigin($this$computeOrigin, mapRect);
    }

    @NotNull
    public static final <TypeT, OutT> Vec<OutT> projectOrigin(@NotNull QuadKey<TypeT> $this$projectOrigin, @NotNull Rect<OutT> mapRect) {
        Intrinsics.checkNotNullParameter($this$projectOrigin, (String)"<this>");
        Intrinsics.checkNotNullParameter(mapRect, (String)"mapRect");
        double left = ExtensionsKt.getScalarLeft(mapRect);
        double top = ExtensionsKt.getScalarTop(mapRect);
        double width = ExtensionsKt.getScalarWidth(mapRect);
        double height = ExtensionsKt.getScalarHeight(mapRect);
        String string = $this$projectOrigin.getKey();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char quadrant = string.charAt(i);
            width = ExtensionsKt.div-jIOXGx0(width, 2.0);
            height = ExtensionsKt.div-jIOXGx0(height, 2.0);
            if (quadrant == '1' || quadrant == '3') {
                left = ExtensionsKt.plus-dQIoAX8(left, width);
            }
            if (quadrant != '2' && quadrant != '3') continue;
            top = ExtensionsKt.plus-dQIoAX8(top, height);
        }
        return VecKt.newVec-dQIoAX8(left, top);
    }
}

