/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.algorithms.AdaptiveResampler;
import jetbrains.datalore.base.geometry.DoubleVector;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\b\n\u0018\u0000 $*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002$%B3\b\u0002\u0012\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cJ\u001a\u0010\u001f\u001a\u00028\u0000*\u00028\u00002\u0006\u0010 \u001a\u00028\u0000H\u0082\u0002\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u001f\u001a\u00028\u0000*\u00028\u00002\u0006\u0010!\u001a\u00020\u0006H\u0082\u0002\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00028\u0000*\u00028\u00002\u0006\u0010 \u001a\u00028\u0000H\u0082\u0002\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00020\u0006*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00020\u0006*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006&"}, d2={"Ljetbrains/datalore/base/algorithms/AdaptiveResampler;", "T", "", "transform", "Lkotlin/Function1;", "precision", "", "dataAdapter", "Ljetbrains/datalore/base/algorithms/AdaptiveResampler$DataAdapter;", "(Lkotlin/jvm/functions/Function1;DLjetbrains/datalore/base/algorithms/AdaptiveResampler$DataAdapter;)V", "precisionSqr", "x", "getX", "(Ljava/lang/Object;)D", "y", "getY", "computeMissingPoint", "p1", "p2", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "distance", "p", "l1", "l2", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)D", "length", "(Ljava/lang/Object;Ljava/lang/Object;)D", "resample", "", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "points", "div", "other", "v", "(Ljava/lang/Object;D)Ljava/lang/Object;", "plus", "Companion", "DataAdapter", "base-portable"})
public final class AdaptiveResampler<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<T, T> transform;
    @NotNull
    private final DataAdapter<T> dataAdapter;
    private final double precisionSqr;
    @NotNull
    private static final Companion.DOUBLE_VECTOR_ADAPTER.1 DOUBLE_VECTOR_ADAPTER = new DataAdapter<DoubleVector>(){

        public double x(@NotNull DoubleVector p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.getX();
        }

        public double y(@NotNull DoubleVector p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.getY();
        }

        @NotNull
        public DoubleVector create(double x2, double y2) {
            return new DoubleVector(x2, y2);
        }

        public double getX(@NotNull DoubleVector $this$x) {
            return DataAdapter.DefaultImpls.getX(this, $this$x);
        }

        public double getY(@NotNull DoubleVector $this$y) {
            return DataAdapter.DefaultImpls.getY(this, $this$y);
        }
    };

    private AdaptiveResampler(Function1<? super T, ? extends T> transform2, double precision, DataAdapter<T> dataAdapter) {
        this.transform = transform2;
        this.dataAdapter = dataAdapter;
        this.precisionSqr = precision * precision;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> resample(@NotNull List<? extends T> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        ArrayList result = new ArrayList(points.size());
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            void $this$forEach$iv;
            CollectionsKt.removeLastOrNull((List)result);
            Iterable iterable = this.resample(points.get(i - 1), points.get(i));
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object p0 = element$iv = iterator2.next();
                boolean bl = false;
                result.add(p0);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> resample(T p1, T p2) {
        void $this$mapNotNullTo$iv$iv;
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<Object> temp = new ArrayList<Object>();
        result.add(p1);
        temp.add(p2);
        while (!((Collection)temp).isEmpty()) {
            Object missingPoint = this.computeMissingPoint(CollectionsKt.last((List)result), CollectionsKt.last((List)temp));
            if (missingPoint == null) {
                result.add(CollectionsKt.removeLast((List)temp));
                continue;
            }
            temp.add(missingPoint);
        }
        Iterable $this$mapNotNull$iv = result;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl2 = false;
            if (this.transform.invoke(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final T computeMissingPoint(T p1, T p2) {
        T pc = this.div(this.plus(p1, p2), 2.0);
        Object object = this.transform.invoke(p1);
        if (object == null) {
            return null;
        }
        Object q1 = object;
        Object object2 = this.transform.invoke(p2);
        if (object2 == null) {
            return null;
        }
        Object q2 = object2;
        Object object3 = this.transform.invoke(pc);
        if (object3 == null) {
            return null;
        }
        Object qc = object3;
        double distance = Intrinsics.areEqual((Object)q1, (Object)q2) ? this.length(q1, qc) : this.distance(qc, q1, q2);
        return distance < this.precisionSqr ? null : (T)pc;
    }

    private final double length(T p1, T p2) {
        double x2 = this.getX(p2) - this.getX(p1);
        double y2 = this.getY(p2) - this.getY(p1);
        return x2 * x2 + y2 * y2;
    }

    private final double distance(T p, T l1, T l2) {
        double ortX = this.getX(l2) - this.getX(l1);
        double ortY = -(this.getY(l2) - this.getY(l1));
        double dot = (this.getX(p) - this.getX(l1)) * ortY + (this.getY(p) - this.getY(l1)) * ortX;
        double len = ortY * ortY + ortX * ortX;
        return dot * dot / len;
    }

    public final double getX(T $this$x) {
        return this.dataAdapter.x($this$x);
    }

    public final double getY(T $this$y) {
        return this.dataAdapter.y($this$y);
    }

    private final T plus(T $this$plus, T other) {
        return this.dataAdapter.create(this.getX($this$plus) + this.getX(other), this.getY($this$plus) + this.getY(other));
    }

    private final T div(T $this$div, T other) {
        return this.dataAdapter.create(this.getX($this$div) / this.getX(other), this.getY($this$div) / this.getY(other));
    }

    private final T div(T $this$div, double v) {
        return this.dataAdapter.create(this.getX($this$div) / v, this.getY($this$div) / v);
    }

    public /* synthetic */ AdaptiveResampler(Function1 transform2, double precision, DataAdapter dataAdapter, DefaultConstructorMarker $constructor_marker) {
        this(transform2, precision, dataAdapter);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\n2\u0006\u0010\u000b\u001a\u00020\fJ>\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007\"\u0004\b\u0001\u0010\u000e2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u0002H\u000e\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/base/algorithms/AdaptiveResampler$Companion;", "", "()V", "DOUBLE_VECTOR_ADAPTER", "jetbrains/datalore/base/algorithms/AdaptiveResampler$Companion$DOUBLE_VECTOR_ADAPTER$1", "Ljetbrains/datalore/base/algorithms/AdaptiveResampler$Companion$DOUBLE_VECTOR_ADAPTER$1;", "forDoubleVector", "Ljetbrains/datalore/base/algorithms/AdaptiveResampler;", "Ljetbrains/datalore/base/geometry/DoubleVector;", "transform", "Lkotlin/Function1;", "precision", "", "generic", "T", "adapter", "Ljetbrains/datalore/base/algorithms/AdaptiveResampler$DataAdapter;", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AdaptiveResampler<DoubleVector> forDoubleVector(@NotNull Function1<? super DoubleVector, DoubleVector> transform2, double precision) {
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            return new AdaptiveResampler<DoubleVector>(transform2, precision, DOUBLE_VECTOR_ADAPTER, null);
        }

        @NotNull
        public final <T> AdaptiveResampler<T> generic(@NotNull Function1<? super T, ? extends T> transform2, double precision, @NotNull DataAdapter<T> adapter) {
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            return new AdaptiveResampler(transform2, precision, adapter, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u001d\u0010\t\u001a\u00028\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006R\u0018\u0010\u0003\u001a\u00020\u0004*\u00028\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\u0004*\u00028\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/base/algorithms/AdaptiveResampler$DataAdapter;", "T", "", "x", "", "getX", "(Ljava/lang/Object;)D", "y", "getY", "create", "(DD)Ljava/lang/Object;", "p", "base-portable"})
    public static interface DataAdapter<T> {
        public double x(T var1);

        public double y(T var1);

        public T create(double var1, double var3);

        public double getX(T var1);

        public double getY(T var1);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static <T> double getX(@NotNull DataAdapter<T> $this, T $receiver) {
                return $this.x($receiver);
            }

            public static <T> double getY(@NotNull DataAdapter<T> $this, T $receiver) {
                return $this.y($receiver);
            }
        }
    }
}

