/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.PlotContext;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.builder.assemble.ColorBarAssembler;
import jetbrains.datalore.plot.builder.assemble.ColorBarOptions;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.LegendAssembler;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.assemble.PlotGuidesAssemblerUtil;
import jetbrains.datalore.plot.builder.layout.FacetedPlotLayout;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.layout.SingleTilePlotLayout;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutProvider;
import jetbrains.datalore.plot.builder.scale.AxisPosition;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import jetbrains.datalore.plot.builder.theme.FacetsTheme;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u001a\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\t2\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u000e\u001a\u00020\u000fJL\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ6\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\n2\b\u0010#\u001a\u0004\u0018\u00010$2\u0016\u0010%\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020$0&H\u0002\u00a8\u0006'"}, d2={"Ljetbrains/datalore/plot/builder/assemble/PlotAssemblerUtil;", "", "()V", "createLegends", "", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "ctx", "Ljetbrains/datalore/plot/base/PlotContext;", "scaleMappersNP", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/ScaleMapper;", "guideOptionsMap", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "createPlotLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "layoutProviderByTile", "Ljetbrains/datalore/plot/builder/layout/TileLayoutProvider;", "insideOut", "", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "facetsTheme", "Ljetbrains/datalore/plot/builder/theme/FacetsTheme;", "hAxisPosition", "Ljetbrains/datalore/plot/builder/scale/AxisPosition;", "vAxisPosition", "hAxisTheme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "vAxisTheme", "updateAesRangeMap", "", "aes", "range", "Ljetbrains/datalore/base/interval/DoubleSpan;", "rangeByAes", "", "plot-builder-portable"})
public final class PlotAssemblerUtil {
    @NotNull
    public static final PlotAssemblerUtil INSTANCE = new PlotAssemblerUtil();

    private PlotAssemblerUtil() {
    }

    private final void updateAesRangeMap(Aes<?> aes, DoubleSpan range, Map<Aes<?>, DoubleSpan> rangeByAes) {
        DoubleSpan range2 = range;
        if (range2 != null) {
            DoubleSpan wasRange = rangeByAes.get(aes);
            if (wasRange != null) {
                range2 = wasRange.union(range2);
            }
            rangeByAes.put(aes, range2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LegendBoxInfo> createLegends(@NotNull PlotContext ctx, @NotNull Map<Aes<?>, ? extends ScaleMapper<?>> scaleMappersNP, @NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, @NotNull LegendTheme theme) {
        LegendBoxInfo boxInfo;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(scaleMappersNP, (String)"scaleMappersNP");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        LinkedHashMap legendAssemblerByTitle = new LinkedHashMap();
        LinkedHashMap colorBarAssemblerByTitle = new LinkedHashMap();
        for (PlotContext.Layer contextLayer : ctx.getLayers()) {
            Object answer$iv;
            Object scale;
            HashMap layerConstantByAes = new HashMap();
            for (Aes aes : contextLayer.renderedAes()) {
                if (!contextLayer.hasConstant(aes)) continue;
                Map map2 = layerConstantByAes;
                Object object = contextLayer.getConstant(aes);
                Intrinsics.checkNotNull((Object)object);
                map2.put(aes, object);
            }
            LinkedHashMap aesListByScaleName = new LinkedHashMap();
            List<Aes<?>> aesList = PlotGuidesAssemblerUtil.INSTANCE.mappedRenderedAesToCreateGuides(contextLayer, guideOptionsMap);
            for (Aes<?> aes : aesList) {
                Object object;
                Object guideOptions;
                boolean colorBar = false;
                scale = ctx.getScale(aes);
                String scaleName = scale.getName();
                if (guideOptionsMap.containsKey(aes)) {
                    guideOptions = guideOptionsMap.get(aes);
                    if (guideOptions instanceof ColorBarOptions) {
                        PlotGuidesAssemblerUtil.INSTANCE.checkFitsColorBar(aes, (Scale)scale);
                        colorBar = true;
                        Map map3 = colorBarAssemblerByTitle;
                        DoubleSpan doubleSpan = ctx.overallTransformedDomain(aes);
                        Object object2 = MapsKt.getValue(scaleMappersNP, aes);
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.base.ScaleMapper<jetbrains.datalore.base.values.Color>");
                        ColorBarAssembler colorBarAssembler = PlotGuidesAssemblerUtil.INSTANCE.createColorBarAssembler(scaleName, doubleSpan, (Scale)scale, (ScaleMapper<Color>)((ScaleMapper)object2), (ColorBarOptions)guideOptions, theme);
                        map3.put(scaleName, colorBarAssembler);
                    }
                } else if (PlotGuidesAssemblerUtil.INSTANCE.fitsColorBar(aes, (Scale)scale)) {
                    colorBar = true;
                    guideOptions = colorBarAssemblerByTitle;
                    DoubleSpan doubleSpan = ctx.overallTransformedDomain(aes);
                    Object object3 = MapsKt.getValue(scaleMappersNP, aes);
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.base.ScaleMapper<jetbrains.datalore.base.values.Color>");
                    ColorBarAssembler colorBarAssembler = PlotGuidesAssemblerUtil.INSTANCE.createColorBarAssembler(scaleName, doubleSpan, (Scale)scale, (ScaleMapper<Color>)((ScaleMapper)object3), null, theme);
                    guideOptions.put(scaleName, colorBarAssembler);
                }
                if (colorBar) continue;
                Map $this$getOrPut$iv = aesListByScaleName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(scaleName);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(scaleName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(aes);
            }
            for (String scaleName : aesListByScaleName.keySet()) {
                Object object;
                void $this$getOrPut$iv;
                scale = legendAssemblerByTitle;
                Intrinsics.checkNotNullExpressionValue((Object)scaleName, (String)"scaleName");
                String key$iv = scaleName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new LegendAssembler(scaleName, guideOptionsMap, scaleMappersNP, theme);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                LegendAssembler legendAssembler = (LegendAssembler)object;
                List aesListForScaleName = (List)MapsKt.getValue((Map)aesListByScaleName, (Object)scaleName);
                LegendKeyElementFactory legendKeyFactory = contextLayer.getLegendKeyElementFactory();
                AestheticsDefaults aestheticsDefaults = contextLayer.getAestheticsDefaults();
                legendAssembler.addLayer(legendKeyFactory, aesListForScaleName, layerConstantByAes, aestheticsDefaults, ctx, (Aes<Color>)contextLayer.getColorByAes(), (Aes<Color>)contextLayer.getFillByAes());
            }
        }
        ArrayList<LegendBoxInfo> legendBoxInfos = new ArrayList<LegendBoxInfo>();
        for (String legendTitle : colorBarAssemblerByTitle.keySet()) {
            Object v = colorBarAssemblerByTitle.get(legendTitle);
            Intrinsics.checkNotNull(v);
            boxInfo = ((ColorBarAssembler)v).createColorBar();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        for (String legendTitle : legendAssemblerByTitle.keySet()) {
            Object v = legendAssemblerByTitle.get(legendTitle);
            Intrinsics.checkNotNull(v);
            boxInfo = ((LegendAssembler)v).createLegend();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        return legendBoxInfos;
    }

    @NotNull
    public final PlotLayout createPlotLayout(@NotNull List<? extends TileLayoutProvider> layoutProviderByTile, boolean insideOut, @NotNull PlotFacets facets, @NotNull FacetsTheme facetsTheme, @NotNull AxisPosition hAxisPosition, @NotNull AxisPosition vAxisPosition, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme) {
        PlotLayout plotLayout;
        Intrinsics.checkNotNullParameter(layoutProviderByTile, (String)"layoutProviderByTile");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter((Object)facetsTheme, (String)"facetsTheme");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisPosition), (String)"hAxisPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisPosition), (String)"vAxisPosition");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        if (facets.isDefined()) {
            plotLayout = new FacetedPlotLayout(facets, layoutProviderByTile, facetsTheme.showStrip(), hAxisPosition, vAxisPosition, hAxisTheme, vAxisTheme);
        } else {
            TileLayout tileLayout = insideOut ? layoutProviderByTile.get(0).createInsideOutTileLayout() : layoutProviderByTile.get(0).createTopDownTileLayout();
            plotLayout = new SingleTilePlotLayout(tileLayout, hAxisPosition, vAxisPosition, hAxisTheme, vAxisTheme);
        }
        return plotLayout;
    }
}

