/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.parser;

import com.github.weisj.darklaf.parser.Delimiters;
import com.github.weisj.darklaf.parser.KeyFilteredParser;
import com.github.weisj.darklaf.parser.ParseResult;
import com.github.weisj.darklaf.parser.Parser;
import com.github.weisj.darklaf.parser.ParserContext;
import com.github.weisj.darklaf.parser.ParserUtil;
import com.github.weisj.darklaf.uiresource.DarkFontUIResource;
import com.github.weisj.darklaf.util.FontUtil;
import java.awt.Font;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FontParser
extends KeyFilteredParser
implements Delimiters {
    private static final Map<AttributedCharacterIterator.Attribute, Integer> attributes = Collections.emptyMap();
    private static final String BASE_FONT = "font";
    private static final String FONT_FROM = "from";
    private static final String FONT_SIZE = "withSize";
    private static final String FONT_STYLE = "withStyle";
    private static final char FONT_DELIMITER = '-';

    public FontParser() {
        super(BASE_FONT);
    }

    @Override
    public ParseResult doParse(ParseResult parseResult, ParserContext context) {
        Font base = null;
        int size = -1;
        int style = -1;
        while (!parseResult.value.isEmpty()) {
            int length = parseResult.value.length();
            if (ParserUtil.stripPrefixFromValue(parseResult, BASE_FONT)) {
                if (base != null) {
                    ParserUtil.warning("Duplicate Base font declared: '" + parseResult.value + "'");
                }
                base = ParserUtil.parseBetween('(', ')', this::parseBaseFont, Font.class, parseResult, context).orElse(base);
            } else if (ParserUtil.stripPrefixFromValue(parseResult, FONT_FROM)) {
                if (base != null) {
                    ParserUtil.warning("Duplicate Base font declared: '" + parseResult.value + "'");
                }
                base = ParserUtil.parseBetween('(', ')', Font.class, parseResult, context).orElse(base);
            } else if (ParserUtil.stripPrefixFromValue(parseResult, FONT_STYLE)) {
                if (style >= 0) {
                    ParserUtil.warning("Duplicate font style declared: '" + parseResult.value + "'");
                }
                style = ParserUtil.parseBetween('(', ')', Integer.class, parseResult, context).orElse(style);
            } else if (ParserUtil.stripPrefixFromValue(parseResult, FONT_SIZE)) {
                if (size >= 0) {
                    ParserUtil.warning("Duplicate font size declared: '" + parseResult.value + "'");
                }
                size = ParserUtil.parseDelimited('(', ')', ',', Integer.class, parseResult, context).stream().reduce(Integer::sum).orElse(size);
            }
            if (parseResult.value.length() != length) continue;
            return ParserUtil.error(parseResult, "Unexpected token while parsing font");
        }
        if (base == null) {
            base = FontUtil.createFont(null, (int)0, (int)12);
        }
        if (size <= 0) {
            size = base.getSize();
        }
        if (style < 0) {
            style = base.getStyle();
        }
        Font font = base.deriveFont(style, size);
        return ParserUtil.setNonNull(parseResult, new DarkFontUIResource(font.deriveFont(attributes)));
    }

    private ParseResult parseBaseFont(ParseResult parseResult, ParserContext context) {
        List<Object> parts = ParserUtil.parseDelimited('-', Object.class, Parser.createParseResult("", parseResult.value), context);
        if (parts.size() != 3) {
            return this.fontStructureError(parseResult);
        }
        if (!(parts.get(0) instanceof String)) {
            return this.fontStructureError(parseResult);
        }
        if (!(parts.get(1) instanceof Integer)) {
            return this.fontStructureError(parseResult);
        }
        if (!(parts.get(2) instanceof Integer)) {
            return this.fontStructureError(parseResult);
        }
        return ParserUtil.setNonNull(parseResult, FontUtil.createFont((String)((String)parts.get(0)), (int)((Integer)parts.get(1)), (int)((Integer)parts.get(2))));
    }

    private ParseResult fontStructureError(ParseResult parseResult) {
        return ParserUtil.error(parseResult, "Expected structure FontName-FontStyle-FontStyle but got '" + parseResult.value + "'");
    }
}

