/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.IImageLine;
import org.jetbrains.letsPlot.util.pngj.IImageLineArray;
import org.jetbrains.letsPlot.util.pngj.ImageLineByte;
import org.jetbrains.letsPlot.util.pngj.ImageLineInt;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkPLTE;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTRNS;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ*\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bJ4\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005J*\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ImageLineHelper;", "", "()V", "DEPTH_UNPACK", "", "", "[[I", "DEPTH_UNPACK_1", "DEPTH_UNPACK_2", "DEPTH_UNPACK_4", "clampTo_0_255", "", "i", "convert2rgba", "line", "Lorg/jetbrains/letsPlot/util/pngj/IImageLineArray;", "pal", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkPLTE;", "trns", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTRNS;", "buf", "getMaskForPackedFormats", "bitDepth", "palette2rgb", "Lorg/jetbrains/letsPlot/util/pngj/IImageLine;", "alphaForced", "", "Lorg/jetbrains/letsPlot/util/pngj/ImageLineInt;", "plot-api"})
public final class ImageLineHelper {
    @NotNull
    public static final ImageLineHelper INSTANCE;
    @NotNull
    private static final int[] DEPTH_UNPACK_1;
    @NotNull
    private static final int[] DEPTH_UNPACK_2;
    @NotNull
    private static final int[] DEPTH_UNPACK_4;
    @NotNull
    private static final int[][] DEPTH_UNPACK;

    private ImageLineHelper() {
    }

    @NotNull
    public final int[] palette2rgb(@NotNull ImageLineInt line2, @NotNull PngChunkPLTE pal, @Nullable PngChunkTRNS trns, @Nullable int[] buf) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        Intrinsics.checkNotNullParameter((Object)pal, (String)"pal");
        return this.palette2rgb(line2, pal, trns, buf, false);
    }

    @NotNull
    public final int[] palette2rgb(@NotNull ImageLineInt line2, @NotNull PngChunkPLTE pal, @NotNull int[] buf) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        Intrinsics.checkNotNullParameter((Object)pal, (String)"pal");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return this.palette2rgb(line2, pal, null, buf, false);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final int[] convert2rgba(@NotNull IImageLineArray line, @NotNull PngChunkPLTE pal, @Nullable PngChunkTRNS trns, @Nullable int[] buf) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Intrinsics.checkNotNullParameter((Object)pal, (String)"pal");
                buf = buf;
                imi = line.getImageInfo();
                nsamples = imi.getCols() * 4;
                if (buf == null || buf.length < nsamples) {
                    buf = new int[nsamples];
                }
                maxval = imi.getBitDepth() == 16 ? 65535 : 255;
                ArrayUtilsKt.fill(buf, maxval);
                if (!imi.getIndexed()) break block10;
                v0 = trns;
                if (v0 == null) ** GOTO lbl-1000
                v1 = v0.getPalletteAlpha();
                v0 = v1;
                if (v1 != null) {
                    v2 = ((Object)v0).length;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = 0;
                }
                tlen = v2;
                var11_15 = imi.getCols();
                for (s = 0; s < var11_15; ++s) {
                    index = line.getElem(s);
                    pal.getEntryRgb(index, buf, s * 4);
                    if (index >= tlen) continue;
                    v3 = trns;
                    Intrinsics.checkNotNull((Object)v3);
                    buf[s * 4 + 3] = v3.getPalletteAlpha()[index];
                }
                break block11;
            }
            if (imi.getGreyscale()) {
                unpack = null;
                if (imi.getBitDepth() < 8) {
                    unpack = ImageLineHelper.DEPTH_UNPACK[imi.getBitDepth()];
                }
                s = 0;
                i = 0;
                for (p = 0; p < imi.getCols(); ++p) {
                    buf[s++] = unpack != null ? unpack[line.getElem(i++)] : line.getElem(i++);
                    buf[s] = buf[s - 1];
                    buf[++s] = buf[s - 1];
                    ++s;
                    if (imi.getChannels() == 2) {
                        buf[s++] = unpack != null ? unpack[line.getElem(i++)] : line.getElem(i++);
                        continue;
                    }
                    buf[s++] = maxval;
                }
            } else {
                s = 0;
                i = 0;
                for (p = 0; p < imi.getCols(); ++p) {
                    buf[s++] = line.getElem(i++);
                    buf[s++] = line.getElem(i++);
                    buf[s++] = line.getElem(i++);
                    buf[s++] = imi.getAlpha() != false ? line.getElem(i++) : maxval;
                }
            }
        }
        return buf;
    }

    public final int clampTo_0_255(int i) {
        return i > 255 ? 255 : (i < 0 ? 0 : i);
    }

    /*
     * Unable to fully structure code
     */
    private final int[] palette2rgb(IImageLine line, PngChunkPLTE pal, PngChunkTRNS trns, int[] buf, boolean alphaForced) {
        buf = buf;
        isalpha = trns != null;
        channels = isalpha != false ? 4 : 3;
        linei = line instanceof ImageLineInt != false ? (ImageLineInt)line : null;
        lineb = line instanceof ImageLineByte != false ? (ImageLineByte)line : null;
        isbyte = lineb != null;
        v0 = linei;
        if (v0 != null && (v0 = v0.getImgInfo()) != null) {
            v1 = v0.getCols();
        } else {
            v2 = lineb;
            Intrinsics.checkNotNull((Object)v2);
            v1 = v2.getImgInfo().getCols();
        }
        cols = v1;
        nsamples = cols * channels;
        if (buf == null || buf.length < nsamples) {
            buf = new int[nsamples];
        }
        if ((v3 = trns) == null) ** GOTO lbl-1000
        v4 = v3.getPalletteAlpha();
        v3 = v4;
        if (v4 != null) {
            v5 = ((Object)v3).length;
        } else lbl-1000:
        // 2 sources

        {
            v5 = 0;
        }
        nindexesWithAlpha = v5;
        for (c = 0; c < cols; ++c) {
            if (isbyte) {
                v6 = lineb;
                Intrinsics.checkNotNull((Object)v6);
                v7 = v6.getScanline()[c] & 255;
            } else {
                v8 = linei;
                Intrinsics.checkNotNull((Object)v8);
                v7 = v8.getScanline()[c];
            }
            index = v7;
            pal.getEntryRgb(index, buf, c * channels);
            if (!isalpha) continue;
            if (index < nindexesWithAlpha) {
                v9 = trns;
                Intrinsics.checkNotNull((Object)v9);
                v10 = v9.getPalletteAlpha()[index];
            } else {
                v10 = 255;
            }
            buf[c * channels + 3] = alpha = v10;
        }
        return buf;
    }

    public final int getMaskForPackedFormats(int bitDepth) {
        int n;
        switch (bitDepth) {
            case 4: {
                n = 240;
                break;
            }
            case 2: {
                n = 192;
                break;
            }
            default: {
                n = 128;
            }
        }
        return n;
    }

    static {
        int i;
        Object object;
        INSTANCE = new ImageLineHelper();
        int[] it = object = new int[2];
        boolean bl = false;
        for (i = 0; i < 2; ++i) {
            it[i] = i * 255;
        }
        DEPTH_UNPACK_1 = object;
        it = object = new int[4];
        boolean bl2 = false;
        for (i = 0; i < 4; ++i) {
            it[i] = i * 255 / 3;
        }
        DEPTH_UNPACK_2 = object;
        it = object = new int[16];
        boolean bl3 = false;
        for (i = 0; i < 16; ++i) {
            it[i] = i * 255 / 15;
        }
        DEPTH_UNPACK_4 = object;
        object = new int[5][];
        object[0] = (int)null;
        object[1] = (int)DEPTH_UNPACK_1;
        object[2] = (int)DEPTH_UNPACK_2;
        object[3] = (int)null;
        object[4] = (int)DEPTH_UNPACK_4;
        DEPTH_UNPACK = (int[][])object;
    }
}

